/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Utility;
import android.icu.text.Replaceable;
import android.icu.text.RuleBasedTransliterator;
import android.icu.text.StringMatcher;
import android.icu.text.StringReplacer;
import android.icu.text.Transliterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeMatcher;
import android.icu.text.UnicodeReplacer;
import android.icu.text.UnicodeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransliterationRule
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private StringMatcher anteContext;
    private StringMatcher key;
    private StringMatcher postContext;
    private UnicodeReplacer output;
    private String pattern;
    UnicodeMatcher[] segments;
    private int anteContextLength;
    private int keyLength;
    byte flags;
    static int ANCHOR_START = 1;
    static int ANCHOR_END = 2;
    private RuleBasedTransliterator.Data data;

    private void $$robo$$android_icu_text_TransliterationRule$__constructor__(String input, int anteContextPos, int postContextPos, String output, int cursorPos, int cursorOffset, UnicodeMatcher[] segs, boolean anchorStart, boolean anchorEnd, RuleBasedTransliterator.Data theData) {
        this.data = theData;
        if (anteContextPos < 0) {
            this.anteContextLength = 0;
        } else {
            if (anteContextPos > input.length()) {
                throw new IllegalArgumentException("Invalid ante context");
            }
            this.anteContextLength = anteContextPos;
        }
        if (postContextPos < 0) {
            this.keyLength = input.length() - this.anteContextLength;
        } else {
            if (postContextPos < this.anteContextLength || postContextPos > input.length()) {
                throw new IllegalArgumentException("Invalid post context");
            }
            this.keyLength = postContextPos - this.anteContextLength;
        }
        if (cursorPos < 0) {
            cursorPos = output.length();
        } else if (cursorPos > output.length()) {
            throw new IllegalArgumentException("Invalid cursor position");
        }
        this.segments = segs;
        this.pattern = input;
        this.flags = 0;
        if (anchorStart) {
            this.flags = (byte)(this.flags | 1);
        }
        if (anchorEnd) {
            this.flags = (byte)(this.flags | 2);
        }
        this.anteContext = null;
        if (this.anteContextLength > 0) {
            this.anteContext = new StringMatcher(this.pattern.substring(0, this.anteContextLength), 0, this.data);
        }
        this.key = null;
        if (this.keyLength > 0) {
            this.key = new StringMatcher(this.pattern.substring(this.anteContextLength, this.anteContextLength + this.keyLength), 0, this.data);
        }
        int postContextLength = this.pattern.length() - this.keyLength - this.anteContextLength;
        this.postContext = null;
        if (postContextLength > 0) {
            this.postContext = new StringMatcher(this.pattern.substring(this.anteContextLength + this.keyLength), 0, this.data);
        }
        this.output = new StringReplacer(output, cursorPos + cursorOffset, this.data);
    }

    private final int $$robo$$android_icu_text_TransliterationRule$getAnteContextLength() {
        return this.anteContextLength + ((this.flags & 1) != 0 ? 1 : 0);
    }

    private final int $$robo$$android_icu_text_TransliterationRule$getIndexValue() {
        if (this.anteContextLength == this.pattern.length()) {
            return -1;
        }
        int c = UTF16.charAt(this.pattern, this.anteContextLength);
        return this.data.lookupMatcher(c) == null ? c & 0xFF : -1;
    }

    private final boolean $$robo$$android_icu_text_TransliterationRule$matchesIndexValue(int v) {
        StringMatcher m = this.key != null ? this.key : this.postContext;
        return m != null ? m.matchesIndexValue(v) : true;
    }

    private final boolean $$robo$$android_icu_text_TransliterationRule$masks(TransliterationRule r2) {
        int len = this.pattern.length();
        int left = this.anteContextLength;
        int left2 = r2.anteContextLength;
        int right = this.pattern.length() - left;
        int right2 = r2.pattern.length() - left2;
        if (left == left2 && right == right2 && this.keyLength <= r2.keyLength && r2.pattern.regionMatches(0, this.pattern, 0, len)) {
            return this.flags == r2.flags || (this.flags & 1) == 0 && (this.flags & 2) == 0 || (r2.flags & 1) != 0 && (r2.flags & 2) != 0;
        }
        return left <= left2 && (right < right2 || right == right2 && this.keyLength <= r2.keyLength) && r2.pattern.regionMatches(left2 - left, this.pattern, 0, len);
    }

    private static final int $$robo$$android_icu_text_TransliterationRule$posBefore(Replaceable str, int pos) {
        return pos > 0 ? pos - UTF16.getCharCount(str.char32At(pos - 1)) : pos - 1;
    }

    private static final int $$robo$$android_icu_text_TransliterationRule$posAfter(Replaceable str, int pos) {
        return pos >= 0 && pos < str.length() ? pos + UTF16.getCharCount(str.char32At(pos)) : pos + 1;
    }

    private final int $$robo$$android_icu_text_TransliterationRule$matchAndReplace(Replaceable text, Transliterator.Position pos, boolean incremental) {
        int match;
        if (this.segments != null) {
            for (int i = 0; i < this.segments.length; ++i) {
                ((StringMatcher)this.segments[i]).resetMatch();
            }
        }
        int[] intRef = new int[1];
        int anteLimit = TransliterationRule.posBefore(text, pos.contextStart);
        intRef[0] = TransliterationRule.posBefore(text, pos.start);
        if (this.anteContext != null && (match = this.anteContext.matches(text, intRef, anteLimit, false)) != 2) {
            return 0;
        }
        int oText = intRef[0];
        int minOText = TransliterationRule.posAfter(text, oText);
        if ((this.flags & 1) != 0 && oText != anteLimit) {
            return 0;
        }
        intRef[0] = pos.start;
        if (this.key != null && (match = this.key.matches(text, intRef, pos.limit, incremental)) != 2) {
            return match;
        }
        int keyLimit = intRef[0];
        if (this.postContext != null) {
            if (incremental && keyLimit == pos.limit) {
                return 1;
            }
            match = this.postContext.matches(text, intRef, pos.contextLimit, incremental);
            if (match != 2) {
                return match;
            }
        }
        oText = intRef[0];
        if ((this.flags & 2) != 0) {
            if (oText != pos.contextLimit) {
                return 0;
            }
            if (incremental) {
                return 1;
            }
        }
        int newLength = this.output.replace(text, pos.start, keyLimit, intRef);
        int lenDelta = newLength - (keyLimit - pos.start);
        int newStart = intRef[0];
        pos.limit += lenDelta;
        pos.contextLimit += lenDelta;
        pos.start = Math.max(minOText, Math.min(Math.min(oText += lenDelta, pos.limit), newStart));
        return 2;
    }

    private final String $$robo$$android_icu_text_TransliterationRule$toRule(boolean escapeUnprintable) {
        boolean emitBraces;
        StringBuffer rule = new StringBuffer();
        StringBuffer quoteBuf = new StringBuffer();
        boolean bl = emitBraces = this.anteContext != null || this.postContext != null;
        if ((this.flags & 1) != 0) {
            rule.append('^');
        }
        Utility.appendToRule(rule, this.anteContext, escapeUnprintable, quoteBuf);
        if (emitBraces) {
            Utility.appendToRule(rule, 123, true, escapeUnprintable, quoteBuf);
        }
        Utility.appendToRule(rule, this.key, escapeUnprintable, quoteBuf);
        if (emitBraces) {
            Utility.appendToRule(rule, 125, true, escapeUnprintable, quoteBuf);
        }
        Utility.appendToRule(rule, this.postContext, escapeUnprintable, quoteBuf);
        if ((this.flags & 2) != 0) {
            rule.append('$');
        }
        Utility.appendToRule(rule, " > ", true, escapeUnprintable, quoteBuf);
        Utility.appendToRule(rule, this.output.toReplacerPattern(escapeUnprintable), true, escapeUnprintable, quoteBuf);
        Utility.appendToRule(rule, 59, true, escapeUnprintable, quoteBuf);
        return rule.toString();
    }

    private final String $$robo$$android_icu_text_TransliterationRule$toString() {
        return '{' + this.toRule(true) + '}';
    }

    private final void $$robo$$android_icu_text_TransliterationRule$addSourceTargetSet(UnicodeSet filter, UnicodeSet sourceSet, UnicodeSet targetSet, UnicodeSet revisiting) {
        int limit = this.anteContextLength + this.keyLength;
        UnicodeSet tempSource = new UnicodeSet();
        UnicodeSet temp = new UnicodeSet();
        int i = this.anteContextLength;
        while (i < limit) {
            int ch = UTF16.charAt(this.pattern, i);
            i += UTF16.getCharCount(ch);
            UnicodeMatcher matcher = this.data.lookupMatcher(ch);
            if (matcher == null) {
                if (!filter.contains(ch)) {
                    return;
                }
                tempSource.add(ch);
                continue;
            }
            try {
                if (!filter.containsSome((UnicodeSet)matcher)) {
                    return;
                }
                matcher.addMatchSetTo(tempSource);
            }
            catch (ClassCastException e) {
                temp.clear();
                matcher.addMatchSetTo(temp);
                if (!filter.containsSome(temp)) {
                    return;
                }
                tempSource.addAll(temp);
            }
        }
        sourceSet.addAll(tempSource);
        this.output.addReplacementSetTo(targetSet);
    }

    private void __constructor__(String string2, int n, int n2, String string3, int n3, int n4, UnicodeMatcher[] unicodeMatcherArray, boolean bl, boolean bl2, RuleBasedTransliterator.Data data) {
        this.$$robo$$android_icu_text_TransliterationRule$__constructor__(string2, n, n2, string3, n3, n4, unicodeMatcherArray, bl, bl2, data);
    }

    public TransliterationRule(String string2, int n, int n2, String string3, int n3, int n4, UnicodeMatcher[] unicodeMatcherArray, boolean bl, boolean bl2, RuleBasedTransliterator.Data data) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliterationRule$__constructor__(java.lang.String int int java.lang.String int int android.icu.text.UnicodeMatcher[] boolean boolean android.icu.text.RuleBasedTransliterator$Data ), 0, this, string2, n, n2, string3, n3, n4, unicodeMatcherArray, bl, bl2, data);
    }

    public int getAnteContextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getAnteContextLength", $$robo$$android_icu_text_TransliterationRule$getAnteContextLength(), 0, this);
    }

    int getIndexValue() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexValue", $$robo$$android_icu_text_TransliterationRule$getIndexValue(), 0, this);
    }

    boolean matchesIndexValue(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesIndexValue", $$robo$$android_icu_text_TransliterationRule$matchesIndexValue(int ), 0, this, n);
    }

    public boolean masks(TransliterationRule transliterationRule) {
        return (boolean)InvokeDynamicSupport.bootstrap("masks", $$robo$$android_icu_text_TransliterationRule$masks(android.icu.text.TransliterationRule ), 0, this, transliterationRule);
    }

    static int posBefore(Replaceable replaceable, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("posBefore", $$robo$$android_icu_text_TransliterationRule$posBefore(android.icu.text.Replaceable int ), 0, (Replaceable)replaceable, (int)n);
    }

    static int posAfter(Replaceable replaceable, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("posAfter", $$robo$$android_icu_text_TransliterationRule$posAfter(android.icu.text.Replaceable int ), 0, (Replaceable)replaceable, (int)n);
    }

    public int matchAndReplace(Replaceable replaceable, Transliterator.Position position, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("matchAndReplace", $$robo$$android_icu_text_TransliterationRule$matchAndReplace(android.icu.text.Replaceable android.icu.text.Transliterator$Position boolean ), 0, this, replaceable, position, bl);
    }

    public String toRule(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toRule", $$robo$$android_icu_text_TransliterationRule$toRule(boolean ), 0, this, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_TransliterationRule$toString(), 0, this);
    }

    void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3, UnicodeSet unicodeSet4) {
        InvokeDynamicSupport.bootstrap("addSourceTargetSet", $$robo$$android_icu_text_TransliterationRule$addSourceTargetSet(android.icu.text.UnicodeSet android.icu.text.UnicodeSet android.icu.text.UnicodeSet android.icu.text.UnicodeSet ), 0, this, unicodeSet, unicodeSet2, unicodeSet3, unicodeSet4);
    }

    public /* synthetic */ TransliterationRule() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransliterationRule)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

