/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SoftCache;
import android.icu.impl.TZDBTimeZoneNames;
import android.icu.impl.TextTrieMap;
import android.icu.impl.TimeZoneGenericNames;
import android.icu.impl.TimeZoneNamesImpl;
import android.icu.impl.ZoneMeta;
import android.icu.lang.UCharacter;
import android.icu.text.DateFormat;
import android.icu.text.NumberingSystem;
import android.icu.text.TimeZoneNames;
import android.icu.text.UFormat;
import android.icu.util.Calendar;
import android.icu.util.Freezable;
import android.icu.util.Output;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimeZoneFormat
extends UFormat
implements Freezable<TimeZoneFormat>,
Serializable {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 2281246852693575022L;
    private static int ISO_Z_STYLE_FLAG = 128;
    private static int ISO_LOCAL_STYLE_FLAG = 256;
    private ULocale _locale;
    private TimeZoneNames _tznames;
    private String _gmtPattern;
    private String[] _gmtOffsetPatterns;
    private String[] _gmtOffsetDigits;
    private String _gmtZeroFormat;
    private boolean _parseAllStyles;
    private boolean _parseTZDBNames;
    private volatile transient TimeZoneGenericNames _gnames;
    private transient String _gmtPatternPrefix;
    private transient String _gmtPatternSuffix;
    private transient Object[][] _gmtOffsetPatternItems;
    private transient boolean _abuttingOffsetHoursAndMinutes;
    private transient String _region;
    private volatile transient boolean _frozen;
    private volatile transient TimeZoneNames _tzdbNames;
    private static String TZID_GMT = "Etc/GMT";
    private static String[] ALT_GMT_STRINGS;
    private static String DEFAULT_GMT_PATTERN = "GMT{0}";
    private static String DEFAULT_GMT_ZERO = "GMT";
    private static String[] DEFAULT_GMT_DIGITS;
    private static char DEFAULT_GMT_OFFSET_SEP = ':';
    private static String ASCII_DIGITS = "0123456789";
    private static String ISO8601_UTC = "Z";
    private static String UNKNOWN_ZONE_ID = "Etc/Unknown";
    private static String UNKNOWN_SHORT_ZONE_ID = "unk";
    private static String UNKNOWN_LOCATION = "Unknown";
    private static GMTOffsetPatternType[] PARSE_GMT_OFFSET_TYPES;
    private static int MILLIS_PER_HOUR = 3600000;
    private static int MILLIS_PER_MINUTE = 60000;
    private static int MILLIS_PER_SECOND = 1000;
    private static int MAX_OFFSET = 86400000;
    private static int MAX_OFFSET_HOUR = 23;
    private static int MAX_OFFSET_MINUTE = 59;
    private static int MAX_OFFSET_SECOND = 59;
    private static int UNKNOWN_OFFSET = Integer.MAX_VALUE;
    private static TimeZoneFormatCache _tzfCache;
    private static EnumSet<TimeZoneNames.NameType> ALL_SIMPLE_NAME_TYPES;
    private static EnumSet<TimeZoneGenericNames.GenericNameType> ALL_GENERIC_NAME_TYPES;
    private static volatile TextTrieMap<String> ZONE_ID_TRIE;
    private static volatile TextTrieMap<String> SHORT_ZONE_ID_TRIE;
    private static ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_TimeZoneFormat$__constructor__(ULocale locale) {
        this._locale = locale;
        this._tznames = TimeZoneNames.getInstance(locale);
        String gmtPattern = null;
        String hourFormats = null;
        this._gmtZeroFormat = "GMT";
        try {
            ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b/zone", locale);
            try {
                gmtPattern = bundle.getStringWithFallback("zoneStrings/gmtFormat");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                hourFormats = bundle.getStringWithFallback("zoneStrings/hourFormat");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                this._gmtZeroFormat = bundle.getStringWithFallback("zoneStrings/gmtZeroFormat");
            }
            catch (MissingResourceException missingResourceException) {}
        }
        catch (MissingResourceException bundle) {
            // empty catch block
        }
        if (gmtPattern == null) {
            gmtPattern = "GMT{0}";
        }
        this.initGMTPattern(gmtPattern);
        String[] gmtOffsetPatterns = new String[GMTOffsetPatternType.values().length];
        if (hourFormats != null) {
            String[] stringArray = hourFormats.split(";", 2);
            gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern(stringArray[0]);
            gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_HM.ordinal()] = stringArray[0];
            gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_HMS.ordinal()] = TimeZoneFormat.expandOffsetPattern(stringArray[0]);
            gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern(stringArray[1]);
            gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_HM.ordinal()] = stringArray[1];
            gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_HMS.ordinal()] = TimeZoneFormat.expandOffsetPattern(stringArray[1]);
        } else {
            for (GMTOffsetPatternType patType : GMTOffsetPatternType.values()) {
                gmtOffsetPatterns[patType.ordinal()] = patType.defaultPattern();
            }
        }
        this.initGMTOffsetPatterns(gmtOffsetPatterns);
        this._gmtOffsetDigits = DEFAULT_GMT_DIGITS;
        NumberingSystem numberingSystem = NumberingSystem.getInstance(locale);
        if (!numberingSystem.isAlgorithmic()) {
            this._gmtOffsetDigits = TimeZoneFormat.toCodePoints(numberingSystem.getDescription());
        }
    }

    private static final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$getInstance(ULocale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        return (TimeZoneFormat)_tzfCache.getInstance(locale, locale);
    }

    private static final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$getInstance(Locale locale) {
        return TimeZoneFormat.getInstance(ULocale.forLocale(locale));
    }

    private final TimeZoneNames $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneNames() {
        return this._tznames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TimeZoneGenericNames $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneGenericNames() {
        if (this._gnames == null) {
            TimeZoneFormat timeZoneFormat = this;
            synchronized (timeZoneFormat) {
                if (this._gnames == null) {
                    this._gnames = TimeZoneGenericNames.getInstance(this._locale);
                }
            }
        }
        return this._gnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TimeZoneNames $$robo$$android_icu_text_TimeZoneFormat$getTZDBTimeZoneNames() {
        if (this._tzdbNames == null) {
            TimeZoneFormat timeZoneFormat = this;
            synchronized (timeZoneFormat) {
                if (this._tzdbNames == null) {
                    this._tzdbNames = new TZDBTimeZoneNames(this._locale);
                }
            }
        }
        return this._tzdbNames;
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$setTimeZoneNames(TimeZoneNames tznames) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this._tznames = tznames;
        this._gnames = new TimeZoneGenericNames(this._locale, this._tznames);
        return this;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$getGMTPattern() {
        return this._gmtPattern;
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$setGMTPattern(String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.initGMTPattern(pattern);
        return this;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$getGMTOffsetPattern(GMTOffsetPatternType type) {
        return this._gmtOffsetPatterns[type.ordinal()];
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$setGMTOffsetPattern(GMTOffsetPatternType type, String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (pattern == null) {
            throw new NullPointerException("Null GMT offset pattern");
        }
        Object[] parsedItems = TimeZoneFormat.parseOffsetPattern(pattern, type.required());
        this._gmtOffsetPatterns[type.ordinal()] = pattern;
        this._gmtOffsetPatternItems[type.ordinal()] = parsedItems;
        this.checkAbuttingHoursAndMinutes();
        return this;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$getGMTOffsetDigits() {
        StringBuilder buf = new StringBuilder(this._gmtOffsetDigits.length);
        for (String digit : this._gmtOffsetDigits) {
            buf.append(digit);
        }
        return buf.toString();
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$setGMTOffsetDigits(String digits) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (digits == null) {
            throw new NullPointerException("Null GMT offset digits");
        }
        String[] digitArray = TimeZoneFormat.toCodePoints(digits);
        if (digitArray.length != 10) {
            throw new IllegalArgumentException("Length of digits must be 10");
        }
        this._gmtOffsetDigits = digitArray;
        return this;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$getGMTZeroFormat() {
        return this._gmtZeroFormat;
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$setGMTZeroFormat(String gmtZeroFormat) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (gmtZeroFormat == null) {
            throw new NullPointerException("Null GMT zero format");
        }
        if (gmtZeroFormat.length() == 0) {
            throw new IllegalArgumentException("Empty GMT zero format");
        }
        this._gmtZeroFormat = gmtZeroFormat;
        return this;
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$setDefaultParseOptions(EnumSet<ParseOption> options) {
        this._parseAllStyles = options.contains((Object)ParseOption.ALL_STYLES);
        this._parseTZDBNames = options.contains((Object)ParseOption.TZ_DATABASE_ABBREVIATIONS);
        return this;
    }

    private final EnumSet<ParseOption> $$robo$$android_icu_text_TimeZoneFormat$getDefaultParseOptions() {
        if (this._parseAllStyles && this._parseTZDBNames) {
            return EnumSet.of(ParseOption.ALL_STYLES, ParseOption.TZ_DATABASE_ABBREVIATIONS);
        }
        if (this._parseAllStyles) {
            return EnumSet.of(ParseOption.ALL_STYLES);
        }
        if (this._parseTZDBNames) {
            return EnumSet.of(ParseOption.TZ_DATABASE_ABBREVIATIONS);
        }
        return EnumSet.noneOf(ParseOption.class);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatOffsetISO8601Basic(int offset, boolean useUtcIndicator, boolean isShort, boolean ignoreSeconds) {
        return this.formatOffsetISO8601(offset, true, useUtcIndicator, isShort, ignoreSeconds);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatOffsetISO8601Extended(int offset, boolean useUtcIndicator, boolean isShort, boolean ignoreSeconds) {
        return this.formatOffsetISO8601(offset, false, useUtcIndicator, isShort, ignoreSeconds);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatOffsetLocalizedGMT(int offset) {
        return this.formatOffsetLocalizedGMT(offset, false);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatOffsetShortLocalizedGMT(int offset) {
        return this.formatOffsetLocalizedGMT(offset, true);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$format(Style style2, TimeZone tz, long date) {
        return this.format(style2, tz, date, null);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$format(Style style2, TimeZone tz, long date, Output<TimeType> timeType) {
        String result = null;
        if (timeType != null) {
            timeType.value = TimeType.UNKNOWN;
        }
        boolean noOffsetFormatFallback = false;
        switch (1.$SwitchMap$android$icu$text$TimeZoneFormat$Style[style2.ordinal()]) {
            case 1: {
                result = this.getTimeZoneGenericNames().getGenericLocationName(ZoneMeta.getCanonicalCLDRID(tz));
                break;
            }
            case 2: {
                result = this.getTimeZoneGenericNames().getDisplayName(tz, TimeZoneGenericNames.GenericNameType.LONG, date);
                break;
            }
            case 3: {
                result = this.getTimeZoneGenericNames().getDisplayName(tz, TimeZoneGenericNames.GenericNameType.SHORT, date);
                break;
            }
            case 4: {
                result = this.formatSpecific(tz, TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT, date, timeType);
                break;
            }
            case 5: {
                result = this.formatSpecific(tz, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT, date, timeType);
                break;
            }
            case 6: {
                result = tz.getID();
                noOffsetFormatFallback = true;
                break;
            }
            case 7: {
                result = ZoneMeta.getShortID(tz);
                if (result == null) {
                    result = "unk";
                }
                noOffsetFormatFallback = true;
                break;
            }
            case 8: {
                result = this.formatExemplarLocation(tz);
                noOffsetFormatFallback = true;
                break;
            }
        }
        if (result == null && !noOffsetFormatFallback) {
            int[] offsets = new int[]{0, 0};
            tz.getOffset(date, false, offsets);
            int offset = offsets[0] + offsets[1];
            switch (1.$SwitchMap$android$icu$text$TimeZoneFormat$Style[style2.ordinal()]) {
                case 1: 
                case 2: 
                case 4: 
                case 9: {
                    result = this.formatOffsetLocalizedGMT(offset);
                    break;
                }
                case 3: 
                case 5: 
                case 10: {
                    result = this.formatOffsetShortLocalizedGMT(offset);
                    break;
                }
                case 11: {
                    result = this.formatOffsetISO8601Basic(offset, true, true, true);
                    break;
                }
                case 12: {
                    result = this.formatOffsetISO8601Basic(offset, false, true, true);
                    break;
                }
                case 13: {
                    result = this.formatOffsetISO8601Basic(offset, true, false, true);
                    break;
                }
                case 14: {
                    result = this.formatOffsetISO8601Basic(offset, false, false, true);
                    break;
                }
                case 15: {
                    result = this.formatOffsetISO8601Basic(offset, true, false, false);
                    break;
                }
                case 16: {
                    result = this.formatOffsetISO8601Basic(offset, false, false, false);
                    break;
                }
                case 17: {
                    result = this.formatOffsetISO8601Extended(offset, true, false, true);
                    break;
                }
                case 18: {
                    result = this.formatOffsetISO8601Extended(offset, false, false, true);
                    break;
                }
                case 19: {
                    result = this.formatOffsetISO8601Extended(offset, true, false, false);
                    break;
                }
                case 20: {
                    result = this.formatOffsetISO8601Extended(offset, false, false, false);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (timeType != null) {
                TimeType timeType2 = timeType.value = offsets[1] != 0 ? TimeType.DAYLIGHT : TimeType.STANDARD;
            }
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetISO8601(String text, ParsePosition pos) {
        return TimeZoneFormat.parseOffsetISO8601(text, pos, false, null);
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetLocalizedGMT(String text, ParsePosition pos) {
        return this.parseOffsetLocalizedGMT(text, pos, false, null);
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetShortLocalizedGMT(String text, ParsePosition pos) {
        return this.parseOffsetLocalizedGMT(text, pos, true, null);
    }

    /*
     * WARNING - void declaration
     */
    private final TimeZone $$robo$$android_icu_text_TimeZoneFormat$parse(Style style2, String text, ParsePosition pos, EnumSet<ParseOption> options, Output<TimeType> timeType) {
        boolean parseAllStyles;
        Output<Boolean> hasDigitOffset;
        int offset;
        if (timeType == null) {
            timeType = new Output<TimeType>(TimeType.UNKNOWN);
        } else {
            timeType.value = TimeType.UNKNOWN;
        }
        int startIdx = pos.getIndex();
        int maxPos = text.length();
        boolean fallbackLocalizedGMT = style2 == Style.SPECIFIC_LONG || style2 == Style.GENERIC_LONG || style2 == Style.GENERIC_LOCATION;
        boolean fallbackShortLocalizedGMT = style2 == Style.SPECIFIC_SHORT || style2 == Style.GENERIC_SHORT;
        int evaluated = 0;
        ParsePosition tmpPos = new ParsePosition(startIdx);
        int parsedOffset = Integer.MAX_VALUE;
        int parsedPos = -1;
        if (fallbackLocalizedGMT || fallbackShortLocalizedGMT) {
            Output<Boolean> hasDigitOffset2 = new Output<Boolean>(false);
            offset = this.parseOffsetLocalizedGMT(text, tmpPos, fallbackShortLocalizedGMT, hasDigitOffset2);
            if (tmpPos.getErrorIndex() == -1) {
                if (tmpPos.getIndex() == maxPos || ((Boolean)hasDigitOffset2.value).booleanValue()) {
                    pos.setIndex(tmpPos.getIndex());
                    return this.getTimeZoneForOffset(offset);
                }
                parsedOffset = offset;
                parsedPos = tmpPos.getIndex();
            }
            evaluated |= Style.LOCALIZED_GMT.flag | Style.LOCALIZED_GMT_SHORT.flag;
        }
        boolean parseTZDBAbbrev = options == null ? this.getDefaultParseOptions().contains((Object)ParseOption.TZ_DATABASE_ABBREVIATIONS) : options.contains((Object)ParseOption.TZ_DATABASE_ABBREVIATIONS);
        switch (1.$SwitchMap$android$icu$text$TimeZoneFormat$Style[style2.ordinal()]) {
            case 9: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                offset = this.parseOffsetLocalizedGMT(text, tmpPos);
                if (tmpPos.getErrorIndex() == -1) {
                    pos.setIndex(tmpPos.getIndex());
                    return this.getTimeZoneForOffset(offset);
                }
                evaluated |= Style.LOCALIZED_GMT_SHORT.flag;
                break;
            }
            case 10: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                offset = this.parseOffsetShortLocalizedGMT(text, tmpPos);
                if (tmpPos.getErrorIndex() == -1) {
                    pos.setIndex(tmpPos.getIndex());
                    return this.getTimeZoneForOffset(offset);
                }
                evaluated |= Style.LOCALIZED_GMT.flag;
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                offset = this.parseOffsetISO8601(text, tmpPos);
                if (tmpPos.getErrorIndex() != -1) break;
                pos.setIndex(tmpPos.getIndex());
                return this.getTimeZoneForOffset(offset);
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                Output<Boolean> hasDigitOffset3 = new Output<Boolean>(false);
                offset = TimeZoneFormat.parseOffsetISO8601(text, tmpPos, false, hasDigitOffset3);
                if (tmpPos.getErrorIndex() != -1 || !((Boolean)hasDigitOffset3.value).booleanValue()) break;
                pos.setIndex(tmpPos.getIndex());
                return this.getTimeZoneForOffset(offset);
            }
            case 4: 
            case 5: {
                EnumSet<TimeZoneNames.NameType> nameTypes = null;
                if (style2 == Style.SPECIFIC_LONG) {
                    nameTypes = EnumSet.of(TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT);
                } else {
                    if (!$assertionsDisabled && style2 != Style.SPECIFIC_SHORT) {
                        throw new AssertionError();
                    }
                    nameTypes = EnumSet.of(TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT);
                }
                Collection<TimeZoneNames.MatchInfo> specificMatches = this._tznames.find(text, startIdx, nameTypes);
                if (specificMatches != null) {
                    TimeZoneNames.MatchInfo specificMatch = null;
                    for (TimeZoneNames.MatchInfo matchInfo : specificMatches) {
                        if (startIdx + matchInfo.matchLength() <= parsedPos) continue;
                        specificMatch = matchInfo;
                        parsedPos = startIdx + matchInfo.matchLength();
                    }
                    if (specificMatch != null) {
                        timeType.value = this.getTimeType(specificMatch.nameType());
                        pos.setIndex(parsedPos);
                        return TimeZone.getTimeZone(this.getTimeZoneID(specificMatch.tzID(), specificMatch.mzID()));
                    }
                }
                if (!parseTZDBAbbrev || style2 != Style.SPECIFIC_SHORT) break;
                if (!$assertionsDisabled && !nameTypes.contains((Object)TimeZoneNames.NameType.SHORT_STANDARD)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !nameTypes.contains((Object)TimeZoneNames.NameType.SHORT_DAYLIGHT)) {
                    throw new AssertionError();
                }
                Collection<TimeZoneNames.MatchInfo> tzdbNameMatches = this.getTZDBTimeZoneNames().find(text, startIdx, nameTypes);
                if (tzdbNameMatches == null) break;
                TimeZoneNames.MatchInfo tzdbNameMatch = null;
                for (TimeZoneNames.MatchInfo match : tzdbNameMatches) {
                    if (startIdx + match.matchLength() <= parsedPos) continue;
                    tzdbNameMatch = match;
                    parsedPos = startIdx + match.matchLength();
                }
                if (tzdbNameMatch == null) break;
                timeType.value = this.getTimeType(tzdbNameMatch.nameType());
                pos.setIndex(parsedPos);
                return TimeZone.getTimeZone(this.getTimeZoneID(tzdbNameMatch.tzID(), tzdbNameMatch.mzID()));
            }
            case 1: 
            case 2: 
            case 3: {
                EnumSet<TimeZoneGenericNames.GenericNameType> genericNameTypes = null;
                switch (1.$SwitchMap$android$icu$text$TimeZoneFormat$Style[style2.ordinal()]) {
                    case 1: {
                        genericNameTypes = EnumSet.of(TimeZoneGenericNames.GenericNameType.LOCATION);
                        break;
                    }
                    case 2: {
                        genericNameTypes = EnumSet.of(TimeZoneGenericNames.GenericNameType.LONG, TimeZoneGenericNames.GenericNameType.LOCATION);
                        break;
                    }
                    case 3: {
                        genericNameTypes = EnumSet.of(TimeZoneGenericNames.GenericNameType.SHORT, TimeZoneGenericNames.GenericNameType.LOCATION);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                TimeZoneGenericNames.GenericMatchInfo bestGeneric = this.getTimeZoneGenericNames().findBestMatch(text, startIdx, genericNameTypes);
                if (bestGeneric == null || startIdx + bestGeneric.matchLength() <= parsedPos) break;
                timeType.value = bestGeneric.timeType();
                pos.setIndex(startIdx + bestGeneric.matchLength());
                return TimeZone.getTimeZone(bestGeneric.tzID());
            }
            case 6: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                String id2 = TimeZoneFormat.parseZoneID(text, tmpPos);
                if (tmpPos.getErrorIndex() != -1) break;
                pos.setIndex(tmpPos.getIndex());
                return TimeZone.getTimeZone(id2);
            }
            case 7: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                String id2 = TimeZoneFormat.parseShortZoneID(text, tmpPos);
                if (tmpPos.getErrorIndex() != -1) break;
                pos.setIndex(tmpPos.getIndex());
                return TimeZone.getTimeZone(id2);
            }
            case 8: {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                String id2 = this.parseExemplarLocation(text, tmpPos);
                if (tmpPos.getErrorIndex() != -1) break;
                pos.setIndex(tmpPos.getIndex());
                return TimeZone.getTimeZone(id2);
            }
        }
        evaluated |= style2.flag;
        if (parsedPos > startIdx) {
            if (!$assertionsDisabled && parsedOffset == Integer.MAX_VALUE) {
                throw new AssertionError();
            }
            pos.setIndex(parsedPos);
            return this.getTimeZoneForOffset(parsedOffset);
        }
        String parsedID = null;
        TimeType parsedTimeType = TimeType.UNKNOWN;
        if (!$assertionsDisabled && parsedPos >= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parsedOffset != Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (parsedPos < maxPos && ((evaluated & 0x80) == 0 || (evaluated & 0x100) == 0)) {
            tmpPos.setIndex(startIdx);
            tmpPos.setErrorIndex(-1);
            hasDigitOffset = new Output<Boolean>(false);
            offset = TimeZoneFormat.parseOffsetISO8601(text, tmpPos, false, hasDigitOffset);
            if (tmpPos.getErrorIndex() == -1) {
                if (tmpPos.getIndex() == maxPos || ((Boolean)hasDigitOffset.value).booleanValue()) {
                    pos.setIndex(tmpPos.getIndex());
                    return this.getTimeZoneForOffset(offset);
                }
                if (parsedPos < tmpPos.getIndex()) {
                    parsedOffset = offset;
                    parsedID = null;
                    parsedTimeType = TimeType.UNKNOWN;
                    parsedPos = tmpPos.getIndex();
                    if (!$assertionsDisabled && parsedPos != startIdx + 1) {
                        throw new AssertionError();
                    }
                }
            }
        }
        if (parsedPos < maxPos && (evaluated & Style.LOCALIZED_GMT.flag) == 0) {
            tmpPos.setIndex(startIdx);
            tmpPos.setErrorIndex(-1);
            hasDigitOffset = new Output<Boolean>(false);
            offset = this.parseOffsetLocalizedGMT(text, tmpPos, false, hasDigitOffset);
            if (tmpPos.getErrorIndex() == -1) {
                if (tmpPos.getIndex() == maxPos || ((Boolean)hasDigitOffset.value).booleanValue()) {
                    pos.setIndex(tmpPos.getIndex());
                    return this.getTimeZoneForOffset(offset);
                }
                if (parsedPos < tmpPos.getIndex()) {
                    parsedOffset = offset;
                    parsedID = null;
                    parsedTimeType = TimeType.UNKNOWN;
                    parsedPos = tmpPos.getIndex();
                }
            }
        }
        if (parsedPos < maxPos && (evaluated & Style.LOCALIZED_GMT_SHORT.flag) == 0) {
            tmpPos.setIndex(startIdx);
            tmpPos.setErrorIndex(-1);
            hasDigitOffset = new Output<Boolean>(false);
            offset = this.parseOffsetLocalizedGMT(text, tmpPos, true, hasDigitOffset);
            if (tmpPos.getErrorIndex() == -1) {
                if (tmpPos.getIndex() == maxPos || ((Boolean)hasDigitOffset.value).booleanValue()) {
                    pos.setIndex(tmpPos.getIndex());
                    return this.getTimeZoneForOffset(offset);
                }
                if (parsedPos < tmpPos.getIndex()) {
                    parsedOffset = offset;
                    parsedID = null;
                    parsedTimeType = TimeType.UNKNOWN;
                    parsedPos = tmpPos.getIndex();
                }
            }
        }
        boolean bl = parseAllStyles = options == null ? this.getDefaultParseOptions().contains((Object)ParseOption.ALL_STYLES) : options.contains((Object)ParseOption.ALL_STYLES);
        if (parseAllStyles) {
            TimeZoneGenericNames.GenericMatchInfo genericMatch;
            if (parsedPos < maxPos) {
                Collection<TimeZoneNames.MatchInfo> specificMatches = this._tznames.find(text, startIdx, ALL_SIMPLE_NAME_TYPES);
                Object var20_25 = null;
                int matchPos = -1;
                if (specificMatches != null) {
                    for (TimeZoneNames.MatchInfo match : specificMatches) {
                        if (startIdx + match.matchLength() <= matchPos) continue;
                        TimeZoneNames.MatchInfo matchInfo = match;
                        matchPos = startIdx + match.matchLength();
                    }
                }
                if (parsedPos < matchPos) {
                    void var20_26;
                    parsedPos = matchPos;
                    parsedID = this.getTimeZoneID(var20_26.tzID(), var20_26.mzID());
                    parsedTimeType = this.getTimeType(var20_26.nameType());
                    parsedOffset = Integer.MAX_VALUE;
                }
            }
            if (parseTZDBAbbrev && parsedPos < maxPos && (evaluated & Style.SPECIFIC_SHORT.flag) == 0) {
                Collection<TimeZoneNames.MatchInfo> tzdbNameMatches = this.getTZDBTimeZoneNames().find(text, startIdx, ALL_SIMPLE_NAME_TYPES);
                Object var20_29 = null;
                int matchPos = -1;
                if (tzdbNameMatches != null) {
                    for (TimeZoneNames.MatchInfo match : tzdbNameMatches) {
                        if (startIdx + match.matchLength() <= matchPos) continue;
                        TimeZoneNames.MatchInfo matchInfo = match;
                        matchPos = startIdx + match.matchLength();
                    }
                    if (parsedPos < matchPos) {
                        void var20_30;
                        parsedPos = matchPos;
                        parsedID = this.getTimeZoneID(var20_30.tzID(), var20_30.mzID());
                        parsedTimeType = this.getTimeType(var20_30.nameType());
                        parsedOffset = Integer.MAX_VALUE;
                    }
                }
            }
            if (parsedPos < maxPos && (genericMatch = this.getTimeZoneGenericNames().findBestMatch(text, startIdx, ALL_GENERIC_NAME_TYPES)) != null && parsedPos < startIdx + genericMatch.matchLength()) {
                parsedPos = startIdx + genericMatch.matchLength();
                parsedID = genericMatch.tzID();
                parsedTimeType = genericMatch.timeType();
                parsedOffset = Integer.MAX_VALUE;
            }
            if (parsedPos < maxPos && (evaluated & Style.ZONE_ID.flag) == 0) {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                String id3 = TimeZoneFormat.parseZoneID(text, tmpPos);
                if (tmpPos.getErrorIndex() == -1 && parsedPos < tmpPos.getIndex()) {
                    parsedPos = tmpPos.getIndex();
                    parsedID = id3;
                    parsedTimeType = TimeType.UNKNOWN;
                    parsedOffset = Integer.MAX_VALUE;
                }
            }
            if (parsedPos < maxPos && (evaluated & Style.ZONE_ID_SHORT.flag) == 0) {
                tmpPos.setIndex(startIdx);
                tmpPos.setErrorIndex(-1);
                String id3 = TimeZoneFormat.parseShortZoneID(text, tmpPos);
                if (tmpPos.getErrorIndex() == -1 && parsedPos < tmpPos.getIndex()) {
                    parsedPos = tmpPos.getIndex();
                    parsedID = id3;
                    parsedTimeType = TimeType.UNKNOWN;
                    parsedOffset = Integer.MAX_VALUE;
                }
            }
        }
        if (parsedPos > startIdx) {
            TimeZone parsedTZ = null;
            if (parsedID != null) {
                parsedTZ = TimeZone.getTimeZone(parsedID);
            } else {
                if (!$assertionsDisabled && parsedOffset == Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                parsedTZ = this.getTimeZoneForOffset(parsedOffset);
            }
            timeType.value = parsedTimeType;
            pos.setIndex(parsedPos);
            return parsedTZ;
        }
        pos.setErrorIndex(startIdx);
        return null;
    }

    private final TimeZone $$robo$$android_icu_text_TimeZoneFormat$parse(Style style2, String text, ParsePosition pos, Output<TimeType> timeType) {
        return this.parse(style2, text, pos, null, timeType);
    }

    private final TimeZone $$robo$$android_icu_text_TimeZoneFormat$parse(String text, ParsePosition pos) {
        return this.parse(Style.GENERIC_LOCATION, text, pos, EnumSet.of(ParseOption.ALL_STYLES), null);
    }

    private final TimeZone $$robo$$android_icu_text_TimeZoneFormat$parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        TimeZone tz = this.parse(text, pos);
        if (pos.getErrorIndex() >= 0) {
            throw new ParseException("Unparseable time zone: \"" + text + "\"", 0);
        }
        if (!$assertionsDisabled && tz == null) {
            throw new AssertionError();
        }
        return tz;
    }

    private final StringBuffer $$robo$$android_icu_text_TimeZoneFormat$format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        TimeZone tz = null;
        Object date = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (obj instanceof TimeZone) {
            tz = (TimeZone)obj;
        } else if (obj instanceof Calendar) {
            tz = ((Calendar)obj).getTimeZone();
            date = ((Calendar)obj).getTimeInMillis();
        } else {
            throw new IllegalArgumentException("Cannot format given Object (" + obj.getClass().getName() + ") as a time zone");
        }
        if (!$assertionsDisabled && tz == null) {
            throw new AssertionError();
        }
        String result = this.formatOffsetLocalizedGMT(tz.getOffset((long)date));
        toAppendTo.append(result);
        if (pos.getFieldAttribute() == DateFormat.Field.TIME_ZONE || pos.getField() == 17) {
            pos.setBeginIndex(0);
            pos.setEndIndex(result.length());
        }
        return toAppendTo;
    }

    private final AttributedCharacterIterator $$robo$$android_icu_text_TimeZoneFormat$formatToCharacterIterator(Object obj) {
        StringBuffer toAppendTo = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        toAppendTo = this.format(obj, toAppendTo, pos);
        AttributedString as = new AttributedString(toAppendTo.toString());
        as.addAttribute(DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE);
        return as.getIterator();
    }

    private final Object $$robo$$android_icu_text_TimeZoneFormat$parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatOffsetLocalizedGMT(int offset, boolean isShort) {
        if (offset == 0) {
            return this._gmtZeroFormat;
        }
        StringBuilder buf = new StringBuilder();
        boolean positive = true;
        if (offset < 0) {
            offset = -offset;
            positive = false;
        }
        int offsetH = offset / 3600000;
        int offsetM = (offset %= 3600000) / 60000;
        int offsetS = (offset %= 60000) / 1000;
        if (offsetH > 23 || offsetM > 59 || offsetS > 59) {
            throw new IllegalArgumentException("Offset out of range :" + offset);
        }
        Object[] offsetPatternItems = positive ? (offsetS != 0 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_HMS.ordinal()] : (offsetM != 0 || !isShort ? this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_HM.ordinal()] : this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_H.ordinal()])) : (offsetS != 0 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_HMS.ordinal()] : (offsetM != 0 || !isShort ? this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_HM.ordinal()] : this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_H.ordinal()]));
        buf.append(this._gmtPatternPrefix);
        block5: for (Object item : offsetPatternItems) {
            if (item instanceof String) {
                buf.append((String)item);
                continue;
            }
            if (!(item instanceof GMTOffsetField)) continue;
            GMTOffsetField field = (GMTOffsetField)item;
            switch (field.getType()) {
                case 'H': {
                    this.appendOffsetDigits(buf, offsetH, isShort ? 1 : 2);
                    continue block5;
                }
                case 'm': {
                    this.appendOffsetDigits(buf, offsetM, 2);
                    continue block5;
                }
                case 's': {
                    this.appendOffsetDigits(buf, offsetS, 2);
                }
            }
        }
        buf.append(this._gmtPatternSuffix);
        return buf.toString();
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatOffsetISO8601(int offset, boolean isBasic, boolean useUtcIndicator, boolean isShort, boolean ignoreSeconds) {
        int idx;
        int lastIdx;
        Character sep;
        int absOffset;
        int n = absOffset = offset < 0 ? -offset : offset;
        if (useUtcIndicator && (absOffset < 1000 || ignoreSeconds && absOffset < 60000)) {
            return "Z";
        }
        OffsetFields minFields = isShort ? OffsetFields.H : OffsetFields.HM;
        OffsetFields maxFields = ignoreSeconds ? OffsetFields.HM : OffsetFields.HMS;
        Character c = sep = isBasic ? null : Character.valueOf(':');
        if (absOffset >= 86400000) {
            throw new IllegalArgumentException("Offset out of range :" + offset);
        }
        int[] fields = new int[]{absOffset / 3600000, (absOffset %= 3600000) / 60000, (absOffset %= 60000) / 1000};
        if (!($assertionsDisabled || fields[0] >= 0 && fields[0] <= 23)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || fields[1] >= 0 && fields[1] <= 59)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || fields[2] >= 0 && fields[2] <= 59)) {
            throw new AssertionError();
        }
        for (lastIdx = maxFields.ordinal(); lastIdx > minFields.ordinal() && fields[lastIdx] == 0; --lastIdx) {
        }
        StringBuilder buf = new StringBuilder();
        int sign = 43;
        if (offset < 0) {
            for (idx = 0; idx <= lastIdx; ++idx) {
                if (fields[idx] == 0) continue;
                sign = 45;
                break;
            }
        }
        buf.append((char)sign);
        for (idx = 0; idx <= lastIdx; ++idx) {
            if (sep != null && idx != 0) {
                buf.append(sep);
            }
            if (fields[idx] < 10) {
                buf.append('0');
            }
            buf.append(fields[idx]);
        }
        return buf.toString();
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatSpecific(TimeZone tz, TimeZoneNames.NameType stdType, TimeZoneNames.NameType dstType, long date, Output<TimeType> timeType) {
        String name;
        if (!$assertionsDisabled && stdType != TimeZoneNames.NameType.LONG_STANDARD && stdType != TimeZoneNames.NameType.SHORT_STANDARD) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dstType != TimeZoneNames.NameType.LONG_DAYLIGHT && dstType != TimeZoneNames.NameType.SHORT_DAYLIGHT) {
            throw new AssertionError();
        }
        boolean isDaylight = tz.inDaylightTime(new Date(date));
        String string2 = name = isDaylight ? this.getTimeZoneNames().getDisplayName(ZoneMeta.getCanonicalCLDRID(tz), dstType, date) : this.getTimeZoneNames().getDisplayName(ZoneMeta.getCanonicalCLDRID(tz), stdType, date);
        if (name != null && timeType != null) {
            timeType.value = isDaylight ? TimeType.DAYLIGHT : TimeType.STANDARD;
        }
        return name;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$formatExemplarLocation(TimeZone tz) {
        String location = this.getTimeZoneNames().getExemplarLocationName(ZoneMeta.getCanonicalCLDRID(tz));
        if (location == null && (location = this.getTimeZoneNames().getExemplarLocationName("Etc/Unknown")) == null) {
            location = "Unknown";
        }
        return location;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneID(String tzID, String mzID) {
        String id2 = tzID;
        if (id2 == null) {
            if (!$assertionsDisabled && mzID == null) {
                throw new AssertionError();
            }
            id2 = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
            if (id2 == null) {
                throw new IllegalArgumentException("Invalid mzID: " + mzID);
            }
        }
        return id2;
    }

    private final synchronized String $$robo$$android_icu_text_TimeZoneFormat$getTargetRegion() {
        if (this._region == null) {
            this._region = this._locale.getCountry();
            if (this._region.length() == 0) {
                ULocale tmp = ULocale.addLikelySubtags(this._locale);
                this._region = tmp.getCountry();
                if (this._region.length() == 0) {
                    this._region = "001";
                }
            }
        }
        return this._region;
    }

    private final TimeType $$robo$$android_icu_text_TimeZoneFormat$getTimeType(TimeZoneNames.NameType nameType) {
        switch (1.$SwitchMap$android$icu$text$TimeZoneNames$NameType[nameType.ordinal()]) {
            case 1: 
            case 2: {
                return TimeType.STANDARD;
            }
            case 3: 
            case 4: {
                return TimeType.DAYLIGHT;
            }
        }
        return TimeType.UNKNOWN;
    }

    private final void $$robo$$android_icu_text_TimeZoneFormat$initGMTPattern(String gmtPattern) {
        int idx = gmtPattern.indexOf("{0}");
        if (idx < 0) {
            throw new IllegalArgumentException("Bad localized GMT pattern: " + gmtPattern);
        }
        this._gmtPattern = gmtPattern;
        this._gmtPatternPrefix = TimeZoneFormat.unquote(gmtPattern.substring(0, idx));
        this._gmtPatternSuffix = TimeZoneFormat.unquote(gmtPattern.substring(idx + 3));
    }

    private static final String $$robo$$android_icu_text_TimeZoneFormat$unquote(String s) {
        if (s.indexOf(39) < 0) {
            return s;
        }
        boolean isPrevQuote = false;
        boolean inQuote = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                if (isPrevQuote) {
                    buf.append(c);
                    isPrevQuote = false;
                } else {
                    isPrevQuote = true;
                }
                inQuote = !inQuote;
                continue;
            }
            isPrevQuote = false;
            buf.append(c);
        }
        return buf.toString();
    }

    private final void $$robo$$android_icu_text_TimeZoneFormat$initGMTOffsetPatterns(String[] gmtOffsetPatterns) {
        int size = GMTOffsetPatternType.values().length;
        if (gmtOffsetPatterns.length < size) {
            throw new IllegalArgumentException("Insufficient number of elements in gmtOffsetPatterns");
        }
        Object[][] gmtOffsetPatternItems = new Object[size][];
        for (GMTOffsetPatternType t : GMTOffsetPatternType.values()) {
            int idx = t.ordinal();
            Object[] parsedItems = TimeZoneFormat.parseOffsetPattern(gmtOffsetPatterns[idx], t.required());
            gmtOffsetPatternItems[idx] = parsedItems;
        }
        this._gmtOffsetPatterns = new String[size];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)gmtOffsetPatterns, (int)0, (Object)this._gmtOffsetPatterns, (int)0, (int)size);
        this._gmtOffsetPatternItems = gmtOffsetPatternItems;
        this.checkAbuttingHoursAndMinutes();
    }

    private final void $$robo$$android_icu_text_TimeZoneFormat$checkAbuttingHoursAndMinutes() {
        this._abuttingOffsetHoursAndMinutes = false;
        block0: for (Object[] items : this._gmtOffsetPatternItems) {
            boolean afterH = false;
            for (Object item : items) {
                if (item instanceof GMTOffsetField) {
                    GMTOffsetField fld = (GMTOffsetField)item;
                    if (afterH) {
                        this._abuttingOffsetHoursAndMinutes = true;
                        continue;
                    }
                    if (fld.getType() != 'H') continue;
                    afterH = true;
                    continue;
                }
                if (afterH) continue block0;
            }
        }
    }

    private static final Object[] $$robo$$android_icu_text_TimeZoneFormat$parseOffsetPattern(String pattern, String letters) {
        boolean isPrevQuote = false;
        boolean inQuote = false;
        StringBuilder text = new StringBuilder();
        char itemType = '\u0000';
        int itemLength = 1;
        boolean invalidPattern = false;
        ArrayList<Object> items = new ArrayList<Object>();
        BitSet checkBits = new BitSet(letters.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                if (isPrevQuote) {
                    text.append('\'');
                    isPrevQuote = false;
                } else {
                    isPrevQuote = true;
                    if (itemType != '\u0000') {
                        if (!GMTOffsetField.isValid(itemType, itemLength)) {
                            invalidPattern = true;
                            break;
                        }
                        items.add(new GMTOffsetField(itemType, itemLength));
                        itemType = '\u0000';
                    }
                }
                inQuote = !inQuote;
                continue;
            }
            isPrevQuote = false;
            if (inQuote) {
                text.append(ch);
                continue;
            }
            int patFieldIdx = letters.indexOf(ch);
            if (patFieldIdx >= 0) {
                if (ch == itemType) {
                    ++itemLength;
                    continue;
                }
                if (itemType == '\u0000') {
                    if (text.length() > 0) {
                        items.add(text.toString());
                        text.setLength(0);
                    }
                } else if (GMTOffsetField.isValid(itemType, itemLength)) {
                    items.add(new GMTOffsetField(itemType, itemLength));
                } else {
                    invalidPattern = true;
                    break;
                }
                itemType = ch;
                itemLength = 1;
                checkBits.set(patFieldIdx);
                continue;
            }
            if (itemType != '\u0000') {
                if (!GMTOffsetField.isValid(itemType, itemLength)) {
                    invalidPattern = true;
                    break;
                }
                items.add(new GMTOffsetField(itemType, itemLength));
                itemType = '\u0000';
            }
            text.append(ch);
        }
        if (!invalidPattern) {
            if (itemType == '\u0000') {
                if (text.length() > 0) {
                    items.add(text.toString());
                    text.setLength(0);
                }
            } else if (GMTOffsetField.isValid(itemType, itemLength)) {
                items.add(new GMTOffsetField(itemType, itemLength));
            } else {
                invalidPattern = true;
            }
        }
        if (invalidPattern || checkBits.cardinality() != letters.length()) {
            throw new IllegalStateException("Bad localized GMT offset pattern: " + pattern);
        }
        return items.toArray(new Object[items.size()]);
    }

    private static final String $$robo$$android_icu_text_TimeZoneFormat$expandOffsetPattern(String offsetHM) {
        int idx_mm = offsetHM.indexOf("mm");
        if (idx_mm < 0) {
            throw new RuntimeException("Bad time zone hour pattern data");
        }
        String sep = ":";
        int idx_H = offsetHM.substring(0, idx_mm).lastIndexOf("H");
        if (idx_H >= 0) {
            sep = offsetHM.substring(idx_H + 1, idx_mm);
        }
        return offsetHM.substring(0, idx_mm + 2) + sep + "ss" + offsetHM.substring(idx_mm + 2);
    }

    private static final String $$robo$$android_icu_text_TimeZoneFormat$truncateOffsetPattern(String offsetHM) {
        int idx_mm = offsetHM.indexOf("mm");
        if (idx_mm < 0) {
            throw new RuntimeException("Bad time zone hour pattern data");
        }
        int idx_HH = offsetHM.substring(0, idx_mm).lastIndexOf("HH");
        if (idx_HH >= 0) {
            return offsetHM.substring(0, idx_HH + 2);
        }
        int idx_H = offsetHM.substring(0, idx_mm).lastIndexOf("H");
        if (idx_H >= 0) {
            return offsetHM.substring(0, idx_H + 1);
        }
        throw new RuntimeException("Bad time zone hour pattern data");
    }

    private final void $$robo$$android_icu_text_TimeZoneFormat$appendOffsetDigits(StringBuilder buf, int n, int minDigits) {
        if (!($assertionsDisabled || n >= 0 && n < 60)) {
            throw new AssertionError();
        }
        int numDigits = n >= 10 ? 2 : 1;
        for (int i = 0; i < minDigits - numDigits; ++i) {
            buf.append(this._gmtOffsetDigits[0]);
        }
        if (numDigits == 2) {
            buf.append(this._gmtOffsetDigits[n / 10]);
        }
        buf.append(this._gmtOffsetDigits[n % 10]);
    }

    private final TimeZone $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneForOffset(int offset) {
        if (offset == 0) {
            return TimeZone.getTimeZone("Etc/GMT");
        }
        return ZoneMeta.getCustomTimeZone(offset);
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetLocalizedGMT(String text, ParsePosition pos, boolean isShort, Output<Boolean> hasDigitOffset) {
        int start = pos.getIndex();
        int offset = 0;
        int[] parsedLength = new int[]{0};
        if (hasDigitOffset != null) {
            hasDigitOffset.value = false;
        }
        offset = this.parseOffsetLocalizedGMTPattern(text, start, isShort, parsedLength);
        if (parsedLength[0] > 0) {
            if (hasDigitOffset != null) {
                hasDigitOffset.value = true;
            }
            pos.setIndex(start + parsedLength[0]);
            return offset;
        }
        offset = this.parseOffsetDefaultLocalizedGMT(text, start, parsedLength);
        if (parsedLength[0] > 0) {
            if (hasDigitOffset != null) {
                hasDigitOffset.value = true;
            }
            pos.setIndex(start + parsedLength[0]);
            return offset;
        }
        if (text.regionMatches(true, start, this._gmtZeroFormat, 0, this._gmtZeroFormat.length())) {
            pos.setIndex(start + this._gmtZeroFormat.length());
            return 0;
        }
        for (String defGMTZero : ALT_GMT_STRINGS) {
            if (!text.regionMatches(true, start, defGMTZero, 0, defGMTZero.length())) continue;
            pos.setIndex(start + defGMTZero.length());
            return 0;
        }
        pos.setErrorIndex(start);
        return 0;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetLocalizedGMTPattern(String text, int start, boolean isShort, int[] parsedLen) {
        int idx = start;
        int offset = 0;
        boolean parsed = false;
        int len = this._gmtPatternPrefix.length();
        if (len <= 0 || text.regionMatches(true, idx, this._gmtPatternPrefix, 0, len)) {
            int[] offsetLen = new int[1];
            offset = this.parseOffsetFields(text, idx += len, false, offsetLen);
            if (offsetLen[0] != 0 && ((len = this._gmtPatternSuffix.length()) <= 0 || text.regionMatches(true, idx += offsetLen[0], this._gmtPatternSuffix, 0, len))) {
                idx += len;
                parsed = true;
            }
        }
        parsedLen[0] = parsed ? idx - start : 0;
        return offset;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetFields(String text, int start, boolean isShort, int[] parsedLen) {
        int outLen = 0;
        int offset = 0;
        int sign = 1;
        if (parsedLen != null && parsedLen.length >= 1) {
            parsedLen[0] = 0;
        }
        int offsetS = 0;
        int offsetM = 0;
        int offsetH = 0;
        int[] fields = new int[]{0, 0, 0};
        for (GMTOffsetPatternType gmtPatType : PARSE_GMT_OFFSET_TYPES) {
            Object[] items = this._gmtOffsetPatternItems[gmtPatType.ordinal()];
            if (!$assertionsDisabled && items == null) {
                throw new AssertionError();
            }
            outLen = this.parseOffsetFieldsWithPattern(text, start, items, false, fields);
            if (outLen <= 0) continue;
            sign = gmtPatType.isPositive() ? 1 : -1;
            offsetH = fields[0];
            offsetM = fields[1];
            offsetS = fields[2];
            break;
        }
        if (outLen > 0 && this._abuttingOffsetHoursAndMinutes) {
            int tmpLen = 0;
            int tmpSign = 1;
            for (GMTOffsetPatternType gmtPatType : PARSE_GMT_OFFSET_TYPES) {
                Object[] items = this._gmtOffsetPatternItems[gmtPatType.ordinal()];
                if (!$assertionsDisabled && items == null) {
                    throw new AssertionError();
                }
                tmpLen = this.parseOffsetFieldsWithPattern(text, start, items, true, fields);
                if (tmpLen <= 0) continue;
                tmpSign = gmtPatType.isPositive() ? 1 : -1;
                break;
            }
            if (tmpLen > outLen) {
                outLen = tmpLen;
                sign = tmpSign;
                offsetH = fields[0];
                offsetM = fields[1];
                offsetS = fields[2];
            }
        }
        if (parsedLen != null && parsedLen.length >= 1) {
            parsedLen[0] = outLen;
        }
        if (outLen > 0) {
            offset = ((offsetH * 60 + offsetM) * 60 + offsetS) * 1000 * sign;
        }
        return offset;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetFieldsWithPattern(String text, int start, Object[] patternItems, boolean forceSingleHourDigit, int[] fields) {
        if (!($assertionsDisabled || fields != null && fields.length >= 3)) {
            throw new AssertionError();
        }
        fields[2] = 0;
        fields[1] = 0;
        fields[0] = 0;
        boolean failed = false;
        int offsetS = 0;
        int offsetM = 0;
        int offsetH = 0;
        int idx = start;
        int[] tmpParsedLen = new int[]{0};
        for (int i = 0; i < patternItems.length; ++i) {
            if (patternItems[i] instanceof String) {
                String patStr = (String)patternItems[i];
                int len = patStr.length();
                if (!text.regionMatches(true, idx, patStr, 0, len)) {
                    failed = true;
                    break;
                }
                idx += len;
                continue;
            }
            if (!$assertionsDisabled && !(patternItems[i] instanceof GMTOffsetField)) {
                throw new AssertionError();
            }
            GMTOffsetField field = (GMTOffsetField)patternItems[i];
            char fieldType = field.getType();
            if (fieldType == 'H') {
                int maxDigits = forceSingleHourDigit ? 1 : 2;
                offsetH = this.parseOffsetFieldWithLocalizedDigits(text, idx, 1, maxDigits, 0, 23, tmpParsedLen);
            } else if (fieldType == 'm') {
                offsetM = this.parseOffsetFieldWithLocalizedDigits(text, idx, 2, 2, 0, 59, tmpParsedLen);
            } else if (fieldType == 's') {
                offsetS = this.parseOffsetFieldWithLocalizedDigits(text, idx, 2, 2, 0, 59, tmpParsedLen);
            }
            if (tmpParsedLen[0] == 0) {
                failed = true;
                break;
            }
            idx += tmpParsedLen[0];
        }
        if (failed) {
            return 0;
        }
        fields[0] = offsetH;
        fields[1] = offsetM;
        fields[2] = offsetS;
        return idx - start;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetDefaultLocalizedGMT(String text, int start, int[] parsedLen) {
        int parsed;
        int offset;
        block8: {
            int sign;
            int idx;
            block10: {
                char c;
                block9: {
                    idx = start;
                    offset = 0;
                    parsed = 0;
                    int gmtLen = 0;
                    for (String gmt : ALT_GMT_STRINGS) {
                        int len = gmt.length();
                        if (!text.regionMatches(true, idx, gmt, 0, len)) continue;
                        gmtLen = len;
                        break;
                    }
                    if (gmtLen == 0 || (idx += gmtLen) + 1 >= text.length()) break block8;
                    sign = 1;
                    c = text.charAt(idx);
                    if (c != '+') break block9;
                    sign = 1;
                    break block10;
                }
                if (c != '-') break block8;
                sign = -1;
            }
            int[] lenWithSep = new int[]{0};
            int offsetWithSep = this.parseDefaultOffsetFields(text, ++idx, ':', lenWithSep);
            if (lenWithSep[0] == text.length() - idx) {
                offset = offsetWithSep * sign;
                idx += lenWithSep[0];
            } else {
                int[] lenAbut = new int[]{0};
                int offsetAbut = this.parseAbuttingOffsetFields(text, idx, lenAbut);
                if (lenWithSep[0] > lenAbut[0]) {
                    offset = offsetWithSep * sign;
                    idx += lenWithSep[0];
                } else {
                    offset = offsetAbut * sign;
                    idx += lenAbut[0];
                }
            }
            parsed = idx - start;
        }
        parsedLen[0] = parsed;
        return offset;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseDefaultOffsetFields(String text, int start, char separator, int[] parsedLen) {
        int max = text.length();
        int idx = start;
        int[] len = new int[]{0};
        int hour = 0;
        int min = 0;
        int sec = 0;
        hour = this.parseOffsetFieldWithLocalizedDigits(text, idx, 1, 2, 0, 23, len);
        if (len[0] != 0 && (idx += len[0]) + 1 < max && text.charAt(idx) == separator) {
            min = this.parseOffsetFieldWithLocalizedDigits(text, idx + 1, 2, 2, 0, 59, len);
            if (len[0] != 0 && (idx += 1 + len[0]) + 1 < max && text.charAt(idx) == separator) {
                sec = this.parseOffsetFieldWithLocalizedDigits(text, idx + 1, 2, 2, 0, 59, len);
                if (len[0] != 0) {
                    idx += 1 + len[0];
                }
            }
        }
        if (idx == start) {
            parsedLen[0] = 0;
            return 0;
        }
        parsedLen[0] = idx - start;
        return hour * 3600000 + min * 60000 + sec * 1000;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseAbuttingOffsetFields(String text, int start, int[] parsedLen) {
        int MAXDIGITS = 6;
        int[] digits = new int[6];
        int[] parsed = new int[6];
        int idx = start;
        int[] len = new int[]{0};
        int numDigits = 0;
        for (int i = 0; i < 6; ++i) {
            digits[i] = this.parseSingleLocalizedDigit(text, idx, len);
            if (digits[i] < 0) break;
            parsed[i] = (idx += len[0]) - start;
            ++numDigits;
        }
        if (numDigits == 0) {
            parsedLen[0] = 0;
            return 0;
        }
        int offset = 0;
        while (numDigits > 0) {
            int hour = 0;
            int min = 0;
            int sec = 0;
            if (!($assertionsDisabled || numDigits > 0 && numDigits <= 6)) {
                throw new AssertionError();
            }
            switch (numDigits) {
                case 1: {
                    hour = digits[0];
                    break;
                }
                case 2: {
                    hour = digits[0] * 10 + digits[1];
                    break;
                }
                case 3: {
                    hour = digits[0];
                    min = digits[1] * 10 + digits[2];
                    break;
                }
                case 4: {
                    hour = digits[0] * 10 + digits[1];
                    min = digits[2] * 10 + digits[3];
                    break;
                }
                case 5: {
                    hour = digits[0];
                    min = digits[1] * 10 + digits[2];
                    sec = digits[3] * 10 + digits[4];
                    break;
                }
                case 6: {
                    hour = digits[0] * 10 + digits[1];
                    min = digits[2] * 10 + digits[3];
                    sec = digits[4] * 10 + digits[5];
                }
            }
            if (hour <= 23 && min <= 59 && sec <= 59) {
                offset = hour * 3600000 + min * 60000 + sec * 1000;
                parsedLen[0] = parsed[numDigits - 1];
                break;
            }
            --numDigits;
        }
        return offset;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetFieldWithLocalizedDigits(String text, int start, int minDigits, int maxDigits, int minVal, int maxVal, int[] parsedLen) {
        int tmpVal;
        int digit;
        int idx;
        parsedLen[0] = 0;
        int decVal = 0;
        int numDigits = 0;
        int[] digitLen = new int[]{0};
        for (idx = start; idx < text.length() && numDigits < maxDigits && (digit = this.parseSingleLocalizedDigit(text, idx, digitLen)) >= 0 && (tmpVal = decVal * 10 + digit) <= maxVal; ++numDigits, idx += digitLen[0]) {
            decVal = tmpVal;
        }
        if (numDigits < minDigits || decVal < minVal) {
            decVal = -1;
            numDigits = 0;
        } else {
            parsedLen[0] = idx - start;
        }
        return decVal;
    }

    private final int $$robo$$android_icu_text_TimeZoneFormat$parseSingleLocalizedDigit(String text, int start, int[] len) {
        int digit = -1;
        len[0] = 0;
        if (start < text.length()) {
            int cp = Character.codePointAt(text, start);
            for (int i = 0; i < this._gmtOffsetDigits.length; ++i) {
                if (cp != this._gmtOffsetDigits[i].codePointAt(0)) continue;
                digit = i;
                break;
            }
            if (digit < 0) {
                digit = UCharacter.digit(cp);
            }
            if (digit >= 0) {
                len[0] = Character.charCount(cp);
            }
        }
        return digit;
    }

    private static final String[] $$robo$$android_icu_text_TimeZoneFormat$toCodePoints(String str) {
        int len = str.codePointCount(0, str.length());
        String[] codePoints = new String[len];
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            int code = str.codePointAt(offset);
            int codeLen = Character.charCount(code);
            codePoints[i] = str.substring(offset, offset + codeLen);
            offset += codeLen;
        }
        return codePoints;
    }

    private static final int $$robo$$android_icu_text_TimeZoneFormat$parseOffsetISO8601(String text, ParsePosition pos, boolean extendedOnly, Output<Boolean> hasDigitOffset) {
        int sign;
        int start;
        if (hasDigitOffset != null) {
            hasDigitOffset.value = false;
        }
        if ((start = pos.getIndex()) >= text.length()) {
            pos.setErrorIndex(start);
            return 0;
        }
        char firstChar = text.charAt(start);
        if (Character.toUpperCase(firstChar) == "Z".charAt(0)) {
            pos.setIndex(start + 1);
            return 0;
        }
        if (firstChar == '+') {
            sign = 1;
        } else if (firstChar == '-') {
            sign = -1;
        } else {
            pos.setErrorIndex(start);
            return 0;
        }
        ParsePosition posOffset = new ParsePosition(start + 1);
        int offset = TimeZoneFormat.parseAsciiOffsetFields(text, posOffset, ':', OffsetFields.H, OffsetFields.HMS);
        if (posOffset.getErrorIndex() == -1 && !extendedOnly && posOffset.getIndex() - start <= 3) {
            ParsePosition posBasic = new ParsePosition(start + 1);
            int tmpOffset = TimeZoneFormat.parseAbuttingAsciiOffsetFields(text, posBasic, OffsetFields.H, OffsetFields.HMS, false);
            if (posBasic.getErrorIndex() == -1 && posBasic.getIndex() > posOffset.getIndex()) {
                offset = tmpOffset;
                posOffset.setIndex(posBasic.getIndex());
            }
        }
        if (posOffset.getErrorIndex() != -1) {
            pos.setErrorIndex(start);
            return 0;
        }
        pos.setIndex(posOffset.getIndex());
        if (hasDigitOffset != null) {
            hasDigitOffset.value = true;
        }
        return sign * offset;
    }

    private static final int $$robo$$android_icu_text_TimeZoneFormat$parseAbuttingAsciiOffsetFields(String text, ParsePosition pos, OffsetFields minFields, OffsetFields maxFields, boolean fixedHourWidth) {
        int digit;
        int start = pos.getIndex();
        int minDigits = 2 * (minFields.ordinal() + 1) - (fixedHourWidth ? 0 : 1);
        int maxDigits = 2 * (maxFields.ordinal() + 1);
        int[] digits = new int[maxDigits];
        int numDigits = 0;
        for (int idx = start; numDigits < digits.length && idx < text.length() && (digit = "0123456789".indexOf(text.charAt(idx))) >= 0; ++numDigits, ++idx) {
            digits[numDigits] = digit;
        }
        if (fixedHourWidth && (numDigits & 1) != 0) {
            --numDigits;
        }
        if (numDigits < minDigits) {
            pos.setErrorIndex(start);
            return 0;
        }
        int hour = 0;
        int min = 0;
        int sec = 0;
        boolean bParsed = false;
        while (numDigits >= minDigits) {
            switch (numDigits) {
                case 1: {
                    hour = digits[0];
                    break;
                }
                case 2: {
                    hour = digits[0] * 10 + digits[1];
                    break;
                }
                case 3: {
                    hour = digits[0];
                    min = digits[1] * 10 + digits[2];
                    break;
                }
                case 4: {
                    hour = digits[0] * 10 + digits[1];
                    min = digits[2] * 10 + digits[3];
                    break;
                }
                case 5: {
                    hour = digits[0];
                    min = digits[1] * 10 + digits[2];
                    sec = digits[3] * 10 + digits[4];
                    break;
                }
                case 6: {
                    hour = digits[0] * 10 + digits[1];
                    min = digits[2] * 10 + digits[3];
                    sec = digits[4] * 10 + digits[5];
                }
            }
            if (hour <= 23 && min <= 59 && sec <= 59) {
                bParsed = true;
                break;
            }
            numDigits -= fixedHourWidth ? 2 : 1;
            sec = 0;
            min = 0;
            hour = 0;
        }
        if (!bParsed) {
            pos.setErrorIndex(start);
            return 0;
        }
        pos.setIndex(start + numDigits);
        return ((hour * 60 + min) * 60 + sec) * 1000;
    }

    private static final int $$robo$$android_icu_text_TimeZoneFormat$parseAsciiOffsetFields(String text, ParsePosition pos, char sep, OffsetFields minFields, OffsetFields maxFields) {
        int start = pos.getIndex();
        int[] fieldVal = new int[]{0, 0, 0};
        int[] fieldLen = new int[]{0, -1, -1};
        int fieldIdx = 0;
        for (int idx = start; idx < text.length() && fieldIdx <= maxFields.ordinal(); ++idx) {
            int digit;
            char c = text.charAt(idx);
            if (c == sep) {
                if (fieldIdx == 0) {
                    if (fieldLen[0] == 0) break;
                    ++fieldIdx;
                    continue;
                }
                if (fieldLen[fieldIdx] != -1) break;
                fieldLen[fieldIdx] = 0;
                continue;
            }
            if (fieldLen[fieldIdx] == -1 || (digit = "0123456789".indexOf(c)) < 0) break;
            fieldVal[fieldIdx] = fieldVal[fieldIdx] * 10 + digit;
            int n = fieldIdx;
            fieldLen[n] = fieldLen[n] + 1;
            if (fieldLen[fieldIdx] < 2) continue;
            ++fieldIdx;
        }
        int offset = 0;
        int parsedLen = 0;
        Enum parsedFields = null;
        if (fieldLen[0] != 0) {
            if (fieldVal[0] > 23) {
                offset = fieldVal[0] / 10 * 3600000;
                parsedFields = OffsetFields.H;
                parsedLen = 1;
            } else {
                offset = fieldVal[0] * 3600000;
                parsedLen = fieldLen[0];
                parsedFields = OffsetFields.H;
                if (fieldLen[1] == 2 && fieldVal[1] <= 59) {
                    offset += fieldVal[1] * 60000;
                    parsedLen += 1 + fieldLen[1];
                    parsedFields = OffsetFields.HM;
                    if (fieldLen[2] == 2 && fieldVal[2] <= 59) {
                        offset += fieldVal[2] * 1000;
                        parsedLen += 1 + fieldLen[2];
                        parsedFields = OffsetFields.HMS;
                    }
                }
            }
        }
        if (parsedFields == null || parsedFields.ordinal() < minFields.ordinal()) {
            pos.setErrorIndex(start);
            return 0;
        }
        pos.setIndex(start + parsedLen);
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final String $$robo$$android_icu_text_TimeZoneFormat$parseZoneID(String text, ParsePosition pos) {
        String resolvedID = null;
        if (ZONE_ID_TRIE == null) {
            Class<TimeZoneFormat> clazz = TimeZoneFormat.class;
            // MONITORENTER : android.icu.text.TimeZoneFormat.class
            if (ZONE_ID_TRIE == null) {
                String[] ids;
                TextTrieMap<String> trie = new TextTrieMap<String>(true);
                for (String id2 : ids = TimeZone.getAvailableIDs()) {
                    trie.put(id2, id2);
                }
                ZONE_ID_TRIE = trie;
            }
            // MONITOREXIT : clazz
        }
        int[] matchLen = new int[]{0};
        Iterator<String> itr = ZONE_ID_TRIE.get(text, pos.getIndex(), matchLen);
        if (itr != null) {
            resolvedID = itr.next();
            pos.setIndex(pos.getIndex() + matchLen[0]);
            return resolvedID;
        }
        pos.setErrorIndex(pos.getIndex());
        return resolvedID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final String $$robo$$android_icu_text_TimeZoneFormat$parseShortZoneID(String text, ParsePosition pos) {
        String resolvedID = null;
        if (SHORT_ZONE_ID_TRIE == null) {
            Class<TimeZoneFormat> clazz = TimeZoneFormat.class;
            // MONITORENTER : android.icu.text.TimeZoneFormat.class
            if (SHORT_ZONE_ID_TRIE == null) {
                TextTrieMap<String> trie = new TextTrieMap<String>(true);
                Set<String> canonicalIDs = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
                for (String id2 : canonicalIDs) {
                    String shortID = ZoneMeta.getShortID(id2);
                    if (shortID == null) continue;
                    trie.put(shortID, id2);
                }
                trie.put("unk", "Etc/Unknown");
                SHORT_ZONE_ID_TRIE = trie;
            }
            // MONITOREXIT : clazz
        }
        int[] matchLen = new int[]{0};
        Iterator<String> itr = SHORT_ZONE_ID_TRIE.get(text, pos.getIndex(), matchLen);
        if (itr != null) {
            resolvedID = itr.next();
            pos.setIndex(pos.getIndex() + matchLen[0]);
            return resolvedID;
        }
        pos.setErrorIndex(pos.getIndex());
        return resolvedID;
    }

    private final String $$robo$$android_icu_text_TimeZoneFormat$parseExemplarLocation(String text, ParsePosition pos) {
        int startIdx = pos.getIndex();
        int parsedPos = -1;
        String tzID = null;
        EnumSet<TimeZoneNames.NameType> nameTypes = EnumSet.of(TimeZoneNames.NameType.EXEMPLAR_LOCATION);
        Collection<TimeZoneNames.MatchInfo> exemplarMatches = this._tznames.find(text, startIdx, nameTypes);
        if (exemplarMatches != null) {
            TimeZoneNames.MatchInfo exemplarMatch = null;
            for (TimeZoneNames.MatchInfo match : exemplarMatches) {
                if (startIdx + match.matchLength() <= parsedPos) continue;
                exemplarMatch = match;
                parsedPos = startIdx + match.matchLength();
            }
            if (exemplarMatch != null) {
                tzID = this.getTimeZoneID(exemplarMatch.tzID(), exemplarMatch.mzID());
                pos.setIndex(parsedPos);
            }
        }
        if (tzID == null) {
            pos.setErrorIndex(startIdx);
        }
        return tzID;
    }

    private final void $$robo$$android_icu_text_TimeZoneFormat$writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("_locale", this._locale);
        fields.put("_tznames", this._tznames);
        fields.put("_gmtPattern", this._gmtPattern);
        fields.put("_gmtOffsetPatterns", this._gmtOffsetPatterns);
        fields.put("_gmtOffsetDigits", this._gmtOffsetDigits);
        fields.put("_gmtZeroFormat", this._gmtZeroFormat);
        fields.put("_parseAllStyles", this._parseAllStyles);
        oos.writeFields();
    }

    private final void $$robo$$android_icu_text_TimeZoneFormat$readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        this._locale = (ULocale)fields.get("_locale", null);
        if (this._locale == null) {
            throw new InvalidObjectException("Missing field: locale");
        }
        this._tznames = (TimeZoneNames)fields.get("_tznames", null);
        if (this._tznames == null) {
            throw new InvalidObjectException("Missing field: tznames");
        }
        this._gmtPattern = (String)fields.get("_gmtPattern", null);
        if (this._gmtPattern == null) {
            throw new InvalidObjectException("Missing field: gmtPattern");
        }
        String[] tmpGmtOffsetPatterns = (String[])fields.get("_gmtOffsetPatterns", null);
        if (tmpGmtOffsetPatterns == null) {
            throw new InvalidObjectException("Missing field: gmtOffsetPatterns");
        }
        if (tmpGmtOffsetPatterns.length < 4) {
            throw new InvalidObjectException("Incompatible field: gmtOffsetPatterns");
        }
        this._gmtOffsetPatterns = new String[6];
        if (tmpGmtOffsetPatterns.length == 4) {
            for (int i = 0; i < 4; ++i) {
                this._gmtOffsetPatterns[i] = tmpGmtOffsetPatterns[i];
            }
            this._gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern(this._gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_HM.ordinal()]);
            this._gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_H.ordinal()] = TimeZoneFormat.truncateOffsetPattern(this._gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_HM.ordinal()]);
        } else {
            this._gmtOffsetPatterns = tmpGmtOffsetPatterns;
        }
        this._gmtOffsetDigits = (String[])fields.get("_gmtOffsetDigits", null);
        if (this._gmtOffsetDigits == null) {
            throw new InvalidObjectException("Missing field: gmtOffsetDigits");
        }
        if (this._gmtOffsetDigits.length != 10) {
            throw new InvalidObjectException("Incompatible field: gmtOffsetDigits");
        }
        this._gmtZeroFormat = (String)fields.get("_gmtZeroFormat", null);
        if (this._gmtZeroFormat == null) {
            throw new InvalidObjectException("Missing field: gmtZeroFormat");
        }
        this._parseAllStyles = fields.get("_parseAllStyles", false);
        if (fields.defaulted("_parseAllStyles")) {
            throw new InvalidObjectException("Missing field: parseAllStyles");
        }
        if (this._tznames instanceof TimeZoneNamesImpl) {
            this._tznames = TimeZoneNames.getInstance(this._locale);
            this._gnames = null;
        } else {
            this._gnames = new TimeZoneGenericNames(this._locale, this._tznames);
        }
        this.initGMTPattern(this._gmtPattern);
        this.initGMTOffsetPatterns(this._gmtOffsetPatterns);
    }

    private final boolean $$robo$$android_icu_text_TimeZoneFormat$isFrozen() {
        return this._frozen;
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$freeze() {
        this._frozen = true;
        return this;
    }

    private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat$cloneAsThawed() {
        TimeZoneFormat copy = (TimeZoneFormat)super.clone();
        copy._frozen = false;
        return copy;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !TimeZoneFormat.class.desiredAssertionStatus();
        ALT_GMT_STRINGS = new String[]{"GMT", "UTC", "UT"};
        DEFAULT_GMT_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        PARSE_GMT_OFFSET_TYPES = new GMTOffsetPatternType[]{GMTOffsetPatternType.POSITIVE_HMS, GMTOffsetPatternType.NEGATIVE_HMS, GMTOffsetPatternType.POSITIVE_HM, GMTOffsetPatternType.NEGATIVE_HM, GMTOffsetPatternType.POSITIVE_H, GMTOffsetPatternType.NEGATIVE_H};
        _tzfCache = new TimeZoneFormatCache();
        ALL_SIMPLE_NAME_TYPES = EnumSet.of(TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT, TimeZoneNames.NameType.EXEMPLAR_LOCATION);
        ALL_GENERIC_NAME_TYPES = EnumSet.of(TimeZoneGenericNames.GenericNameType.LOCATION, TimeZoneGenericNames.GenericNameType.LONG, TimeZoneGenericNames.GenericNameType.SHORT);
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("_locale", ULocale.class), new ObjectStreamField("_tznames", TimeZoneNames.class), new ObjectStreamField("_gmtPattern", String.class), new ObjectStreamField("_gmtOffsetPatterns", String[].class), new ObjectStreamField("_gmtOffsetDigits", String[].class), new ObjectStreamField("_gmtZeroFormat", String.class), new ObjectStreamField("_parseAllStyles", Boolean.TYPE)};
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_TimeZoneFormat$__constructor__(uLocale);
    }

    protected TimeZoneFormat(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static TimeZoneFormat getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_TimeZoneFormat$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static TimeZoneFormat getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_TimeZoneFormat$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public TimeZoneNames getTimeZoneNames() {
        return InvokeDynamicSupport.bootstrap("getTimeZoneNames", $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneNames(), 0, this);
    }

    private TimeZoneGenericNames getTimeZoneGenericNames() {
        return InvokeDynamicSupport.bootstrap("getTimeZoneGenericNames", $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneGenericNames(), 0, this);
    }

    private TimeZoneNames getTZDBTimeZoneNames() {
        return InvokeDynamicSupport.bootstrap("getTZDBTimeZoneNames", $$robo$$android_icu_text_TimeZoneFormat$getTZDBTimeZoneNames(), 0, this);
    }

    public TimeZoneFormat setTimeZoneNames(TimeZoneNames timeZoneNames) {
        return InvokeDynamicSupport.bootstrap("setTimeZoneNames", $$robo$$android_icu_text_TimeZoneFormat$setTimeZoneNames(android.icu.text.TimeZoneNames ), 0, this, timeZoneNames);
    }

    public String getGMTPattern() {
        return InvokeDynamicSupport.bootstrap("getGMTPattern", $$robo$$android_icu_text_TimeZoneFormat$getGMTPattern(), 0, this);
    }

    public TimeZoneFormat setGMTPattern(String string2) {
        return InvokeDynamicSupport.bootstrap("setGMTPattern", $$robo$$android_icu_text_TimeZoneFormat$setGMTPattern(java.lang.String ), 0, this, string2);
    }

    public String getGMTOffsetPattern(GMTOffsetPatternType gMTOffsetPatternType) {
        return InvokeDynamicSupport.bootstrap("getGMTOffsetPattern", $$robo$$android_icu_text_TimeZoneFormat$getGMTOffsetPattern(android.icu.text.TimeZoneFormat$GMTOffsetPatternType ), 0, this, gMTOffsetPatternType);
    }

    public TimeZoneFormat setGMTOffsetPattern(GMTOffsetPatternType gMTOffsetPatternType, String string2) {
        return InvokeDynamicSupport.bootstrap("setGMTOffsetPattern", $$robo$$android_icu_text_TimeZoneFormat$setGMTOffsetPattern(android.icu.text.TimeZoneFormat$GMTOffsetPatternType java.lang.String ), 0, this, gMTOffsetPatternType, string2);
    }

    public String getGMTOffsetDigits() {
        return InvokeDynamicSupport.bootstrap("getGMTOffsetDigits", $$robo$$android_icu_text_TimeZoneFormat$getGMTOffsetDigits(), 0, this);
    }

    public TimeZoneFormat setGMTOffsetDigits(String string2) {
        return InvokeDynamicSupport.bootstrap("setGMTOffsetDigits", $$robo$$android_icu_text_TimeZoneFormat$setGMTOffsetDigits(java.lang.String ), 0, this, string2);
    }

    public String getGMTZeroFormat() {
        return InvokeDynamicSupport.bootstrap("getGMTZeroFormat", $$robo$$android_icu_text_TimeZoneFormat$getGMTZeroFormat(), 0, this);
    }

    public TimeZoneFormat setGMTZeroFormat(String string2) {
        return InvokeDynamicSupport.bootstrap("setGMTZeroFormat", $$robo$$android_icu_text_TimeZoneFormat$setGMTZeroFormat(java.lang.String ), 0, this, string2);
    }

    public TimeZoneFormat setDefaultParseOptions(EnumSet<ParseOption> enumSet) {
        return InvokeDynamicSupport.bootstrap("setDefaultParseOptions", $$robo$$android_icu_text_TimeZoneFormat$setDefaultParseOptions(java.util.EnumSet<android.icu.text.TimeZoneFormat$ParseOption> ), 0, this, enumSet);
    }

    public EnumSet<ParseOption> getDefaultParseOptions() {
        return InvokeDynamicSupport.bootstrap("getDefaultParseOptions", $$robo$$android_icu_text_TimeZoneFormat$getDefaultParseOptions(), 0, this);
    }

    public String formatOffsetISO8601Basic(int n, boolean bl, boolean bl2, boolean bl3) {
        return InvokeDynamicSupport.bootstrap("formatOffsetISO8601Basic", $$robo$$android_icu_text_TimeZoneFormat$formatOffsetISO8601Basic(int boolean boolean boolean ), 0, this, n, bl, bl2, bl3);
    }

    public String formatOffsetISO8601Extended(int n, boolean bl, boolean bl2, boolean bl3) {
        return InvokeDynamicSupport.bootstrap("formatOffsetISO8601Extended", $$robo$$android_icu_text_TimeZoneFormat$formatOffsetISO8601Extended(int boolean boolean boolean ), 0, this, n, bl, bl2, bl3);
    }

    public String formatOffsetLocalizedGMT(int n) {
        return InvokeDynamicSupport.bootstrap("formatOffsetLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$formatOffsetLocalizedGMT(int ), 0, this, n);
    }

    public String formatOffsetShortLocalizedGMT(int n) {
        return InvokeDynamicSupport.bootstrap("formatOffsetShortLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$formatOffsetShortLocalizedGMT(int ), 0, this, n);
    }

    public String format(Style style2, TimeZone timeZone, long l) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_TimeZoneFormat$format(android.icu.text.TimeZoneFormat$Style android.icu.util.TimeZone long ), 0, this, style2, timeZone, l);
    }

    public String format(Style style2, TimeZone timeZone, long l, Output<TimeType> output) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_TimeZoneFormat$format(android.icu.text.TimeZoneFormat$Style android.icu.util.TimeZone long android.icu.util.Output<android.icu.text.TimeZoneFormat$TimeType> ), 0, this, style2, timeZone, l, output);
    }

    public int parseOffsetISO8601(String string2, ParsePosition parsePosition) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetISO8601", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetISO8601(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public int parseOffsetLocalizedGMT(String string2, ParsePosition parsePosition) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetLocalizedGMT(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public int parseOffsetShortLocalizedGMT(String string2, ParsePosition parsePosition) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetShortLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetShortLocalizedGMT(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public TimeZone parse(Style style2, String string2, ParsePosition parsePosition, EnumSet<ParseOption> enumSet, Output<TimeType> output) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_TimeZoneFormat$parse(android.icu.text.TimeZoneFormat$Style java.lang.String java.text.ParsePosition java.util.EnumSet<android.icu.text.TimeZoneFormat$ParseOption> android.icu.util.Output<android.icu.text.TimeZoneFormat$TimeType> ), 0, this, style2, string2, parsePosition, enumSet, output);
    }

    public TimeZone parse(Style style2, String string2, ParsePosition parsePosition, Output<TimeType> output) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_TimeZoneFormat$parse(android.icu.text.TimeZoneFormat$Style java.lang.String java.text.ParsePosition android.icu.util.Output<android.icu.text.TimeZoneFormat$TimeType> ), 0, this, style2, string2, parsePosition, output);
    }

    public TimeZone parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_TimeZoneFormat$parse(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public TimeZone parse(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_TimeZoneFormat$parse(java.lang.String ), 0, this, string2);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_TimeZoneFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), 0, this, object, stringBuffer, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return InvokeDynamicSupport.bootstrap("formatToCharacterIterator", $$robo$$android_icu_text_TimeZoneFormat$formatToCharacterIterator(java.lang.Object ), 0, this, object);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_TimeZoneFormat$parseObject(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    private String formatOffsetLocalizedGMT(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("formatOffsetLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$formatOffsetLocalizedGMT(int boolean ), 0, this, n, bl);
    }

    private String formatOffsetISO8601(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return InvokeDynamicSupport.bootstrap("formatOffsetISO8601", $$robo$$android_icu_text_TimeZoneFormat$formatOffsetISO8601(int boolean boolean boolean boolean ), 0, this, n, bl, bl2, bl3, bl4);
    }

    private String formatSpecific(TimeZone timeZone, TimeZoneNames.NameType nameType, TimeZoneNames.NameType nameType2, long l, Output<TimeType> output) {
        return InvokeDynamicSupport.bootstrap("formatSpecific", $$robo$$android_icu_text_TimeZoneFormat$formatSpecific(android.icu.util.TimeZone android.icu.text.TimeZoneNames$NameType android.icu.text.TimeZoneNames$NameType long android.icu.util.Output<android.icu.text.TimeZoneFormat$TimeType> ), 0, this, timeZone, nameType, nameType2, l, output);
    }

    private String formatExemplarLocation(TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrap("formatExemplarLocation", $$robo$$android_icu_text_TimeZoneFormat$formatExemplarLocation(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    private String getTimeZoneID(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getTimeZoneID", $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneID(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private synchronized String getTargetRegion() {
        return InvokeDynamicSupport.bootstrap("getTargetRegion", $$robo$$android_icu_text_TimeZoneFormat$getTargetRegion(), 0, this);
    }

    private TimeType getTimeType(TimeZoneNames.NameType nameType) {
        return InvokeDynamicSupport.bootstrap("getTimeType", $$robo$$android_icu_text_TimeZoneFormat$getTimeType(android.icu.text.TimeZoneNames$NameType ), 0, this, nameType);
    }

    private void initGMTPattern(String string2) {
        InvokeDynamicSupport.bootstrap("initGMTPattern", $$robo$$android_icu_text_TimeZoneFormat$initGMTPattern(java.lang.String ), 0, this, string2);
    }

    private static String unquote(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("unquote", $$robo$$android_icu_text_TimeZoneFormat$unquote(java.lang.String ), 0, (String)string2);
    }

    private void initGMTOffsetPatterns(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("initGMTOffsetPatterns", $$robo$$android_icu_text_TimeZoneFormat$initGMTOffsetPatterns(java.lang.String[] ), 0, this, stringArray);
    }

    private void checkAbuttingHoursAndMinutes() {
        InvokeDynamicSupport.bootstrap("checkAbuttingHoursAndMinutes", $$robo$$android_icu_text_TimeZoneFormat$checkAbuttingHoursAndMinutes(), 0, this);
    }

    private static Object[] parseOffsetPattern(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("parseOffsetPattern", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetPattern(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static String expandOffsetPattern(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("expandOffsetPattern", $$robo$$android_icu_text_TimeZoneFormat$expandOffsetPattern(java.lang.String ), 0, (String)string2);
    }

    private static String truncateOffsetPattern(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("truncateOffsetPattern", $$robo$$android_icu_text_TimeZoneFormat$truncateOffsetPattern(java.lang.String ), 0, (String)string2);
    }

    private void appendOffsetDigits(StringBuilder stringBuilder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("appendOffsetDigits", $$robo$$android_icu_text_TimeZoneFormat$appendOffsetDigits(java.lang.StringBuilder int int ), 0, this, stringBuilder, n, n2);
    }

    private TimeZone getTimeZoneForOffset(int n) {
        return InvokeDynamicSupport.bootstrap("getTimeZoneForOffset", $$robo$$android_icu_text_TimeZoneFormat$getTimeZoneForOffset(int ), 0, this, n);
    }

    private int parseOffsetLocalizedGMT(String string2, ParsePosition parsePosition, boolean bl, Output<Boolean> output) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetLocalizedGMT(java.lang.String java.text.ParsePosition boolean android.icu.util.Output<java.lang.Boolean> ), 0, this, string2, parsePosition, bl, output);
    }

    private int parseOffsetLocalizedGMTPattern(String string2, int n, boolean bl, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetLocalizedGMTPattern", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetLocalizedGMTPattern(java.lang.String int boolean int[] ), 0, this, string2, n, bl, nArray);
    }

    private int parseOffsetFields(String string2, int n, boolean bl, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetFields", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetFields(java.lang.String int boolean int[] ), 0, this, string2, n, bl, nArray);
    }

    private int parseOffsetFieldsWithPattern(String string2, int n, Object[] objectArray, boolean bl, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetFieldsWithPattern", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetFieldsWithPattern(java.lang.String int java.lang.Object[] boolean int[] ), 0, this, string2, n, objectArray, bl, nArray);
    }

    private int parseOffsetDefaultLocalizedGMT(String string2, int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetDefaultLocalizedGMT", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetDefaultLocalizedGMT(java.lang.String int int[] ), 0, this, string2, n, nArray);
    }

    private int parseDefaultOffsetFields(String string2, int n, char c, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseDefaultOffsetFields", $$robo$$android_icu_text_TimeZoneFormat$parseDefaultOffsetFields(java.lang.String int char int[] ), 0, this, string2, n, c, nArray);
    }

    private int parseAbuttingOffsetFields(String string2, int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseAbuttingOffsetFields", $$robo$$android_icu_text_TimeZoneFormat$parseAbuttingOffsetFields(java.lang.String int int[] ), 0, this, string2, n, nArray);
    }

    private int parseOffsetFieldWithLocalizedDigits(String string2, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseOffsetFieldWithLocalizedDigits", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetFieldWithLocalizedDigits(java.lang.String int int int int int int[] ), 0, this, string2, n, n2, n3, n4, n5, nArray);
    }

    private int parseSingleLocalizedDigit(String string2, int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("parseSingleLocalizedDigit", $$robo$$android_icu_text_TimeZoneFormat$parseSingleLocalizedDigit(java.lang.String int int[] ), 0, this, string2, n, nArray);
    }

    private static String[] toCodePoints(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toCodePoints", $$robo$$android_icu_text_TimeZoneFormat$toCodePoints(java.lang.String ), 0, (String)string2);
    }

    private static int parseOffsetISO8601(String string2, ParsePosition parsePosition, boolean bl, Output<Boolean> output) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseOffsetISO8601", $$robo$$android_icu_text_TimeZoneFormat$parseOffsetISO8601(java.lang.String java.text.ParsePosition boolean android.icu.util.Output<java.lang.Boolean> ), 0, (String)string2, (ParsePosition)parsePosition, (boolean)bl, output);
    }

    private static int parseAbuttingAsciiOffsetFields(String string2, ParsePosition parsePosition, OffsetFields offsetFields, OffsetFields offsetFields2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseAbuttingAsciiOffsetFields", $$robo$$android_icu_text_TimeZoneFormat$parseAbuttingAsciiOffsetFields(java.lang.String java.text.ParsePosition android.icu.text.TimeZoneFormat$OffsetFields android.icu.text.TimeZoneFormat$OffsetFields boolean ), 0, (String)string2, (ParsePosition)parsePosition, (OffsetFields)offsetFields, (OffsetFields)offsetFields2, (boolean)bl);
    }

    private static int parseAsciiOffsetFields(String string2, ParsePosition parsePosition, char c, OffsetFields offsetFields, OffsetFields offsetFields2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseAsciiOffsetFields", $$robo$$android_icu_text_TimeZoneFormat$parseAsciiOffsetFields(java.lang.String java.text.ParsePosition char android.icu.text.TimeZoneFormat$OffsetFields android.icu.text.TimeZoneFormat$OffsetFields ), 0, (String)string2, (ParsePosition)parsePosition, (char)c, (OffsetFields)offsetFields, (OffsetFields)offsetFields2);
    }

    private static String parseZoneID(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrapStatic("parseZoneID", $$robo$$android_icu_text_TimeZoneFormat$parseZoneID(java.lang.String java.text.ParsePosition ), 0, (String)string2, (ParsePosition)parsePosition);
    }

    private static String parseShortZoneID(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrapStatic("parseShortZoneID", $$robo$$android_icu_text_TimeZoneFormat$parseShortZoneID(java.lang.String java.text.ParsePosition ), 0, (String)string2, (ParsePosition)parsePosition);
    }

    private String parseExemplarLocation(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseExemplarLocation", $$robo$$android_icu_text_TimeZoneFormat$parseExemplarLocation(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_TimeZoneFormat$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_TimeZoneFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_TimeZoneFormat$isFrozen(), 0, this);
    }

    @Override
    public TimeZoneFormat freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_TimeZoneFormat$freeze(), 0, this);
    }

    @Override
    public TimeZoneFormat cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_TimeZoneFormat$cloneAsThawed(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TimeZoneFormat.class);
    }

    public /* synthetic */ TimeZoneFormat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TimeZoneFormatCache
    extends SoftCache<ULocale, TimeZoneFormat, ULocale> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$__constructor__() {
        }

        private final TimeZoneFormat $$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$createInstance(ULocale key, ULocale data) {
            TimeZoneFormat fmt = new TimeZoneFormat(data);
            fmt.freeze();
            return fmt;
        }

        private /* synthetic */ void $$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$__constructor__();
        }

        private TimeZoneFormatCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$__constructor__(), 0, this);
        }

        @Override
        protected TimeZoneFormat createInstance(ULocale uLocale, ULocale uLocale2) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$createInstance(android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_TimeZoneFormat_TimeZoneFormatCache$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneFormatCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class GMTOffsetField
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        char _type;
        int _width;

        private void $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$__constructor__(char type, int width) {
            this._type = type;
            this._width = width;
        }

        private final char $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$getType() {
            return this._type;
        }

        private final int $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$getWidth() {
            return this._width;
        }

        private static final boolean $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$isValid(char type, int width) {
            return width == 1 || width == 2;
        }

        private void __constructor__(char c, int n) {
            this.$$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$__constructor__(c, n);
        }

        GMTOffsetField(char c, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$__constructor__(char int ), 0, this, c, n);
        }

        char getType() {
            return (char)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$getType(), 0, this);
        }

        int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$getWidth(), 0, this);
        }

        static boolean isValid(char c, int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isValid", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetField$isValid(char int ), 0, (char)c, (int)n);
        }

        public /* synthetic */ GMTOffsetField() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GMTOffsetField)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class OffsetFields
    extends Enum<OffsetFields> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ OffsetFields H;
        public static /* enum */ OffsetFields HM;
        public static /* enum */ OffsetFields HMS;
        private static /* synthetic */ OffsetFields[] $VALUES;

        private static final OffsetFields[] $$robo$$android_icu_text_TimeZoneFormat_OffsetFields$values() {
            return (OffsetFields[])$VALUES.clone();
        }

        private static final OffsetFields $$robo$$android_icu_text_TimeZoneFormat_OffsetFields$valueOf(String name) {
            return Enum.valueOf(OffsetFields.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_TimeZoneFormat_OffsetFields$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            H = new OffsetFields();
            HM = new OffsetFields();
            HMS = new OffsetFields();
            $VALUES = new OffsetFields[]{H, HM, HMS};
        }

        public static OffsetFields[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_TimeZoneFormat_OffsetFields$values(), 0);
        }

        public static OffsetFields valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_TimeZoneFormat_OffsetFields$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_TimeZoneFormat_OffsetFields$__constructor__(string2, n);
        }

        private OffsetFields() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_OffsetFields$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(OffsetFields.class);
        }

        public /* synthetic */ OffsetFields() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OffsetFields)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ParseOption
    extends Enum<ParseOption> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ParseOption ALL_STYLES;
        public static /* enum */ ParseOption TZ_DATABASE_ABBREVIATIONS;
        private static /* synthetic */ ParseOption[] $VALUES;

        private static final ParseOption[] $$robo$$android_icu_text_TimeZoneFormat_ParseOption$values() {
            return (ParseOption[])$VALUES.clone();
        }

        private static final ParseOption $$robo$$android_icu_text_TimeZoneFormat_ParseOption$valueOf(String name) {
            return Enum.valueOf(ParseOption.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_TimeZoneFormat_ParseOption$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ALL_STYLES = new ParseOption();
            TZ_DATABASE_ABBREVIATIONS = new ParseOption();
            $VALUES = new ParseOption[]{ALL_STYLES, TZ_DATABASE_ABBREVIATIONS};
        }

        public static ParseOption[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_TimeZoneFormat_ParseOption$values(), 0);
        }

        public static ParseOption valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_TimeZoneFormat_ParseOption$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_TimeZoneFormat_ParseOption$__constructor__(string2, n);
        }

        private ParseOption() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_ParseOption$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ParseOption.class);
        }

        public /* synthetic */ ParseOption() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseOption)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class TimeType
    extends Enum<TimeType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ TimeType UNKNOWN;
        public static /* enum */ TimeType STANDARD;
        public static /* enum */ TimeType DAYLIGHT;
        private static /* synthetic */ TimeType[] $VALUES;

        private static final TimeType[] $$robo$$android_icu_text_TimeZoneFormat_TimeType$values() {
            return (TimeType[])$VALUES.clone();
        }

        private static final TimeType $$robo$$android_icu_text_TimeZoneFormat_TimeType$valueOf(String name) {
            return Enum.valueOf(TimeType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_TimeZoneFormat_TimeType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            UNKNOWN = new TimeType();
            STANDARD = new TimeType();
            DAYLIGHT = new TimeType();
            $VALUES = new TimeType[]{UNKNOWN, STANDARD, DAYLIGHT};
        }

        public static TimeType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_TimeZoneFormat_TimeType$values(), 0);
        }

        public static TimeType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_TimeZoneFormat_TimeType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_TimeZoneFormat_TimeType$__constructor__(string2, n);
        }

        private TimeType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_TimeType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(TimeType.class);
        }

        public /* synthetic */ TimeType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class GMTOffsetPatternType
    extends Enum<GMTOffsetPatternType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ GMTOffsetPatternType POSITIVE_HM;
        public static /* enum */ GMTOffsetPatternType POSITIVE_HMS;
        public static /* enum */ GMTOffsetPatternType NEGATIVE_HM;
        public static /* enum */ GMTOffsetPatternType NEGATIVE_HMS;
        public static /* enum */ GMTOffsetPatternType POSITIVE_H;
        public static /* enum */ GMTOffsetPatternType NEGATIVE_H;
        private String _defaultPattern;
        private String _required;
        private boolean _isPositive;
        private static /* synthetic */ GMTOffsetPatternType[] $VALUES;

        private static final GMTOffsetPatternType[] $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$values() {
            return (GMTOffsetPatternType[])$VALUES.clone();
        }

        private static final GMTOffsetPatternType $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$valueOf(String name) {
            return Enum.valueOf(GMTOffsetPatternType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$__constructor__(String string2, int n, String defaultPattern, String required, boolean isPositive) {
            this._defaultPattern = defaultPattern;
            this._required = required;
            this._isPositive = isPositive;
        }

        private final String $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$defaultPattern() {
            return this._defaultPattern;
        }

        private final String $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$required() {
            return this._required;
        }

        private final boolean $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$isPositive() {
            return this._isPositive;
        }

        static void __staticInitializer__() {
            POSITIVE_HM = new GMTOffsetPatternType("+H:mm", "Hm", true);
            POSITIVE_HMS = new GMTOffsetPatternType("+H:mm:ss", "Hms", true);
            NEGATIVE_HM = new GMTOffsetPatternType("-H:mm", "Hm", false);
            NEGATIVE_HMS = new GMTOffsetPatternType("-H:mm:ss", "Hms", false);
            POSITIVE_H = new GMTOffsetPatternType("+H", "H", true);
            NEGATIVE_H = new GMTOffsetPatternType("-H", "H", false);
            $VALUES = new GMTOffsetPatternType[]{POSITIVE_HM, POSITIVE_HMS, NEGATIVE_HM, NEGATIVE_HMS, POSITIVE_H, NEGATIVE_H};
        }

        public static GMTOffsetPatternType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$values(), 0);
        }

        public static GMTOffsetPatternType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3, String string4, boolean bl) {
            this.$$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$__constructor__(string2, n, string3, string4, bl);
        }

        private GMTOffsetPatternType(String string3, String string4, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$__constructor__(java.lang.String int java.lang.String java.lang.String boolean ), 0, this, string2, n, string3, string4, bl);
        }

        private String defaultPattern() {
            return InvokeDynamicSupport.bootstrap("defaultPattern", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$defaultPattern(), 0, this);
        }

        private String required() {
            return InvokeDynamicSupport.bootstrap("required", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$required(), 0, this);
        }

        private boolean isPositive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPositive", $$robo$$android_icu_text_TimeZoneFormat_GMTOffsetPatternType$isPositive(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(GMTOffsetPatternType.class);
        }

        public /* synthetic */ GMTOffsetPatternType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GMTOffsetPatternType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Style
    extends Enum<Style> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Style GENERIC_LOCATION;
        public static /* enum */ Style GENERIC_LONG;
        public static /* enum */ Style GENERIC_SHORT;
        public static /* enum */ Style SPECIFIC_LONG;
        public static /* enum */ Style SPECIFIC_SHORT;
        public static /* enum */ Style LOCALIZED_GMT;
        public static /* enum */ Style LOCALIZED_GMT_SHORT;
        public static /* enum */ Style ISO_BASIC_SHORT;
        public static /* enum */ Style ISO_BASIC_LOCAL_SHORT;
        public static /* enum */ Style ISO_BASIC_FIXED;
        public static /* enum */ Style ISO_BASIC_LOCAL_FIXED;
        public static /* enum */ Style ISO_BASIC_FULL;
        public static /* enum */ Style ISO_BASIC_LOCAL_FULL;
        public static /* enum */ Style ISO_EXTENDED_FIXED;
        public static /* enum */ Style ISO_EXTENDED_LOCAL_FIXED;
        public static /* enum */ Style ISO_EXTENDED_FULL;
        public static /* enum */ Style ISO_EXTENDED_LOCAL_FULL;
        public static /* enum */ Style ZONE_ID;
        public static /* enum */ Style ZONE_ID_SHORT;
        public static /* enum */ Style EXEMPLAR_LOCATION;
        int flag;
        private static /* synthetic */ Style[] $VALUES;

        private static final Style[] $$robo$$android_icu_text_TimeZoneFormat_Style$values() {
            return (Style[])$VALUES.clone();
        }

        private static final Style $$robo$$android_icu_text_TimeZoneFormat_Style$valueOf(String name) {
            return Enum.valueOf(Style.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_TimeZoneFormat_Style$__constructor__(String string2, int n, int flag) {
            this.flag = flag;
        }

        static void __staticInitializer__() {
            GENERIC_LOCATION = new Style(1);
            GENERIC_LONG = new Style(2);
            GENERIC_SHORT = new Style(4);
            SPECIFIC_LONG = new Style(8);
            SPECIFIC_SHORT = new Style(16);
            LOCALIZED_GMT = new Style(32);
            LOCALIZED_GMT_SHORT = new Style(64);
            ISO_BASIC_SHORT = new Style(128);
            ISO_BASIC_LOCAL_SHORT = new Style(256);
            ISO_BASIC_FIXED = new Style(128);
            ISO_BASIC_LOCAL_FIXED = new Style(256);
            ISO_BASIC_FULL = new Style(128);
            ISO_BASIC_LOCAL_FULL = new Style(256);
            ISO_EXTENDED_FIXED = new Style(128);
            ISO_EXTENDED_LOCAL_FIXED = new Style(256);
            ISO_EXTENDED_FULL = new Style(128);
            ISO_EXTENDED_LOCAL_FULL = new Style(256);
            ZONE_ID = new Style(512);
            ZONE_ID_SHORT = new Style(1024);
            EXEMPLAR_LOCATION = new Style(2048);
            $VALUES = new Style[]{GENERIC_LOCATION, GENERIC_LONG, GENERIC_SHORT, SPECIFIC_LONG, SPECIFIC_SHORT, LOCALIZED_GMT, LOCALIZED_GMT_SHORT, ISO_BASIC_SHORT, ISO_BASIC_LOCAL_SHORT, ISO_BASIC_FIXED, ISO_BASIC_LOCAL_FIXED, ISO_BASIC_FULL, ISO_BASIC_LOCAL_FULL, ISO_EXTENDED_FIXED, ISO_EXTENDED_LOCAL_FIXED, ISO_EXTENDED_FULL, ISO_EXTENDED_LOCAL_FULL, ZONE_ID, ZONE_ID_SHORT, EXEMPLAR_LOCATION};
        }

        public static Style[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_TimeZoneFormat_Style$values(), 0);
        }

        public static Style valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_TimeZoneFormat_Style$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_icu_text_TimeZoneFormat_Style$__constructor__(string2, n, n2);
        }

        private Style(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TimeZoneFormat_Style$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Style.class);
        }

        public /* synthetic */ Style() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

