/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2;
import android.icu.impl.Trie2Writable;
import android.icu.lang.UCharacter;
import android.icu.lang.UScript;
import android.icu.text.IdentifierInfo;
import android.icu.text.Normalizer2;
import android.icu.text.UnicodeSet;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SpoofChecker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static UnicodeSet INCLUSION;
    @Deprecated
    public static UnicodeSet RECOMMENDED;
    public static int SINGLE_SCRIPT_CONFUSABLE = 1;
    public static int MIXED_SCRIPT_CONFUSABLE = 2;
    public static int WHOLE_SCRIPT_CONFUSABLE = 4;
    public static int ANY_CASE = 8;
    @Deprecated
    public static int RESTRICTION_LEVEL = 16;
    @Deprecated
    public static int SINGLE_SCRIPT = 16;
    public static int INVISIBLE = 32;
    public static int CHAR_LIMIT = 64;
    @Deprecated
    public static int MIXED_NUMBERS = 128;
    public static int ALL_CHECKS = -1;
    static int MAGIC = 944111087;
    private IdentifierInfo fCachedIdentifierInfo;
    private int fChecks;
    private SpoofData fSpoofData;
    private Set<ULocale> fAllowedLocales;
    private UnicodeSet fAllowedCharsSet;
    private RestrictionLevel fRestrictionLevel;
    private static Normalizer2 nfdNormalizer;
    static int SL_TABLE_FLAG = 0x1000000;
    static int SA_TABLE_FLAG = 0x2000000;
    static int ML_TABLE_FLAG = 0x4000000;
    static int MA_TABLE_FLAG = 0x8000000;
    static int KEY_MULTIPLE_VALUES = 0x10000000;
    static int KEY_LENGTH_SHIFT = 29;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_SpoofChecker$__constructor__() {
        this.fCachedIdentifierInfo = null;
    }

    @Deprecated
    private final RestrictionLevel $$robo$$android_icu_text_SpoofChecker$getRestrictionLevel() {
        return this.fRestrictionLevel;
    }

    private final int $$robo$$android_icu_text_SpoofChecker$getChecks() {
        return this.fChecks;
    }

    private final Set<ULocale> $$robo$$android_icu_text_SpoofChecker$getAllowedLocales() {
        return Collections.unmodifiableSet(this.fAllowedLocales);
    }

    private final Set<Locale> $$robo$$android_icu_text_SpoofChecker$getAllowedJavaLocales() {
        HashSet<Locale> locales = new HashSet<Locale>(this.fAllowedLocales.size());
        for (ULocale uloc : this.fAllowedLocales) {
            locales.add(uloc.toLocale());
        }
        return locales;
    }

    private final UnicodeSet $$robo$$android_icu_text_SpoofChecker$getAllowedChars() {
        return this.fAllowedCharsSet;
    }

    private final boolean $$robo$$android_icu_text_SpoofChecker$failsChecks(String text, CheckResult checkResult) {
        int length = text.length();
        int result = 0;
        if (checkResult != null) {
            checkResult.position = 0;
            checkResult.numerics = null;
            checkResult.restrictionLevel = null;
        }
        IdentifierInfo identifierInfo = null;
        if (0 != (this.fChecks & 0x90)) {
            identifierInfo = this.getIdentifierInfo().setIdentifier(text).setIdentifierProfile(this.fAllowedCharsSet);
        }
        if (0 != (this.fChecks & 0x10)) {
            RestrictionLevel textRestrictionLevel = identifierInfo.getRestrictionLevel();
            if (textRestrictionLevel.compareTo(this.fRestrictionLevel) > 0) {
                result |= 0x10;
            }
            if (checkResult != null) {
                checkResult.restrictionLevel = textRestrictionLevel;
            }
        }
        if (0 != (this.fChecks & 0x80)) {
            UnicodeSet numerics = identifierInfo.getNumerics();
            if (numerics.size() > 1) {
                result |= 0x80;
            }
            if (checkResult != null) {
                checkResult.numerics = numerics;
            }
        }
        if (0 != (this.fChecks & 0x40)) {
            int i = 0;
            while (i < length) {
                int c = Character.codePointAt(text, i);
                i = Character.offsetByCodePoints(text, i, 1);
                if (this.fAllowedCharsSet.contains(c)) continue;
                result |= 0x40;
                break;
            }
        }
        if (0 != (this.fChecks & 0x26)) {
            String nfdText = nfdNormalizer.normalize(text);
            if (0 != (this.fChecks & 0x20)) {
                int firstNonspacingMark = 0;
                boolean haveMultipleMarks = false;
                UnicodeSet marksSeenSoFar = new UnicodeSet();
                int i = 0;
                while (i < length) {
                    int c = Character.codePointAt(nfdText, i);
                    i = Character.offsetByCodePoints(nfdText, i, 1);
                    if (Character.getType(c) != 6) {
                        firstNonspacingMark = 0;
                        if (!haveMultipleMarks) continue;
                        marksSeenSoFar.clear();
                        haveMultipleMarks = false;
                        continue;
                    }
                    if (firstNonspacingMark == 0) {
                        firstNonspacingMark = c;
                        continue;
                    }
                    if (!haveMultipleMarks) {
                        marksSeenSoFar.add(firstNonspacingMark);
                        haveMultipleMarks = true;
                    }
                    if (marksSeenSoFar.contains(c)) {
                        result |= 0x20;
                        break;
                    }
                    marksSeenSoFar.add(c);
                }
            }
            if (0 != (this.fChecks & 6)) {
                if (identifierInfo == null) {
                    identifierInfo = this.getIdentifierInfo();
                    identifierInfo.setIdentifier(text);
                }
                int scriptCount = identifierInfo.getScriptCount();
                ScriptSet scripts = new ScriptSet();
                this.wholeScriptCheck(nfdText, scripts);
                int confusableScriptCount = scripts.countMembers();
                if (0 != (this.fChecks & 4) && confusableScriptCount >= 2 && scriptCount == 1) {
                    result |= 4;
                }
                if (0 != (this.fChecks & 2) && confusableScriptCount >= 1 && scriptCount > 1) {
                    result |= 2;
                }
            }
        }
        if (checkResult != null) {
            checkResult.checks = result;
        }
        this.releaseIdentifierInfo(identifierInfo);
        return 0 != result;
    }

    private final boolean $$robo$$android_icu_text_SpoofChecker$failsChecks(String text) {
        return this.failsChecks(text, null);
    }

    private final int $$robo$$android_icu_text_SpoofChecker$areConfusable(String s1, String s2) {
        String s2Skeleton;
        String s1Skeleton;
        boolean possiblyWholeScriptConfusables;
        String s2Skeleton2;
        String s1Skeleton2;
        if ((this.fChecks & 7) == 0) {
            throw new IllegalArgumentException("No confusable checks are enabled.");
        }
        int flagsForSkeleton = this.fChecks & 8;
        int result = 0;
        IdentifierInfo identifierInfo = this.getIdentifierInfo();
        identifierInfo.setIdentifier(s1);
        int s1ScriptCount = identifierInfo.getScriptCount();
        int s1FirstScript = identifierInfo.getScripts().nextSetBit(0);
        identifierInfo.setIdentifier(s2);
        int s2ScriptCount = identifierInfo.getScriptCount();
        int s2FirstScript = identifierInfo.getScripts().nextSetBit(0);
        this.releaseIdentifierInfo(identifierInfo);
        if (0 != (this.fChecks & 1) && s1ScriptCount <= 1 && s2ScriptCount <= 1 && s1FirstScript == s2FirstScript && (s1Skeleton2 = this.getSkeleton(flagsForSkeleton |= 1, s1)).equals(s2Skeleton2 = this.getSkeleton(flagsForSkeleton, s2))) {
            result |= 1;
        }
        if (result & true) {
            return result;
        }
        boolean bl = possiblyWholeScriptConfusables = s1ScriptCount <= 1 && s2ScriptCount <= 1 && 0 != (this.fChecks & 4);
        if ((0 != (this.fChecks & 2) || possiblyWholeScriptConfusables) && (s1Skeleton = this.getSkeleton(flagsForSkeleton &= 0xFFFFFFFE, s1)).equals(s2Skeleton = this.getSkeleton(flagsForSkeleton, s2))) {
            result |= 2;
            if (possiblyWholeScriptConfusables) {
                result |= 4;
            }
        }
        return result;
    }

    private final String $$robo$$android_icu_text_SpoofChecker$getSkeleton(int type, String id2) {
        int c;
        int tableMask = 0;
        switch (type) {
            case 0: {
                tableMask = 0x4000000;
                break;
            }
            case 1: {
                tableMask = 0x1000000;
                break;
            }
            case 8: {
                tableMask = 0x8000000;
                break;
            }
            case 9: {
                tableMask = 0x2000000;
                break;
            }
            default: {
                throw new IllegalArgumentException("SpoofChecker.getSkeleton(), bad type value.");
            }
        }
        String nfdId = nfdNormalizer.normalize(id2);
        int normalizedLen = nfdId.length();
        StringBuilder skelSB = new StringBuilder();
        for (int inputIndex = 0; inputIndex < normalizedLen; inputIndex += Character.charCount(c)) {
            c = Character.codePointAt(nfdId, inputIndex);
            this.confusableLookup(c, tableMask, skelSB);
        }
        String skelStr = skelSB.toString();
        skelStr = nfdNormalizer.normalize(skelStr);
        return skelStr;
    }

    @Deprecated
    private final boolean $$robo$$android_icu_text_SpoofChecker$equals(Object other) {
        if (!(other instanceof SpoofChecker)) {
            return false;
        }
        SpoofChecker otherSC = (SpoofChecker)other;
        if (this.fSpoofData != otherSC.fSpoofData && this.fSpoofData != null && !this.fSpoofData.equals(otherSC.fSpoofData)) {
            return false;
        }
        if (this.fChecks != otherSC.fChecks) {
            return false;
        }
        if (this.fAllowedLocales != otherSC.fAllowedLocales && this.fAllowedLocales != null && !this.fAllowedLocales.equals(otherSC.fAllowedLocales)) {
            return false;
        }
        if (this.fAllowedCharsSet != otherSC.fAllowedCharsSet && this.fAllowedCharsSet != null && !this.fAllowedCharsSet.equals(otherSC.fAllowedCharsSet)) {
            return false;
        }
        return this.fRestrictionLevel == otherSC.fRestrictionLevel;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_SpoofChecker$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 1234;
    }

    private final void $$robo$$android_icu_text_SpoofChecker$confusableLookup(int inChar, int tableMask, StringBuilder dest) {
        int low = 0;
        int mid = 0;
        int limit = this.fSpoofData.fCFUKeys.length;
        boolean foundChar = false;
        do {
            int delta;
            int midc;
            if (inChar == (midc = this.fSpoofData.fCFUKeys[mid = low + (delta = (limit - low) / 2)] & 0x1FFFFF)) {
                foundChar = true;
                break;
            }
            if (inChar < midc) {
                limit = mid;
                continue;
            }
            low = mid + 1;
        } while (low < limit);
        if (!foundChar) {
            dest.appendCodePoint(inChar);
            return;
        }
        boolean foundKey = false;
        int keyFlags = this.fSpoofData.fCFUKeys[mid] & 0xFF000000;
        if ((keyFlags & tableMask) == 0) {
            if (0 != (keyFlags & 0x10000000)) {
                int altMid = mid - 1;
                while ((this.fSpoofData.fCFUKeys[altMid] & 0xFFFFFF) == inChar) {
                    keyFlags = this.fSpoofData.fCFUKeys[altMid] & 0xFF000000;
                    if (0 != (keyFlags & tableMask)) {
                        mid = altMid;
                        foundKey = true;
                        break;
                    }
                    --altMid;
                }
                if (!foundKey) {
                    altMid = mid + 1;
                    while ((this.fSpoofData.fCFUKeys[altMid] & 0xFFFFFF) == inChar) {
                        keyFlags = this.fSpoofData.fCFUKeys[altMid] & 0xFF000000;
                        if (0 != (keyFlags & tableMask)) {
                            mid = altMid;
                            foundKey = true;
                            break;
                        }
                        ++altMid;
                    }
                }
            }
            if (!foundKey) {
                dest.appendCodePoint(inChar);
                return;
            }
        }
        int stringLen = SpoofChecker.getKeyLength(keyFlags) + 1;
        int keyTableIndex = mid;
        short value = this.fSpoofData.fCFUValues[keyTableIndex];
        if (stringLen == 1) {
            dest.append((char)value);
            return;
        }
        if (stringLen == 4) {
            boolean dataOK = false;
            for (SpoofData.SpoofStringLengthsElement el : this.fSpoofData.fCFUStringLengths) {
                if (el.fLastString < value) continue;
                stringLen = el.fStrLength;
                dataOK = true;
                break;
            }
            if (!$assertionsDisabled && !dataOK) {
                throw new AssertionError();
            }
        }
        dest.append(this.fSpoofData.fCFUStrings, (int)value, value + stringLen);
    }

    private final void $$robo$$android_icu_text_SpoofChecker$wholeScriptCheck(CharSequence text, ScriptSet result) {
        int inputIdx = 0;
        Trie2 table = 0 != (this.fChecks & 8) ? this.fSpoofData.fAnyCaseTrie : this.fSpoofData.fLowerCaseTrie;
        result.setAll();
        while (inputIdx < text.length()) {
            int c = Character.codePointAt(text, inputIdx);
            inputIdx = Character.offsetByCodePoints(text, inputIdx, 1);
            int index = table.get(c);
            if (index == 0) {
                int cpScript = UScript.getScript(c);
                if (!$assertionsDisabled && cpScript <= 1) {
                    throw new AssertionError();
                }
                result.intersect(cpScript);
                continue;
            }
            if (index == 1) continue;
            result.intersect(this.fSpoofData.fScriptSets[index]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IdentifierInfo $$robo$$android_icu_text_SpoofChecker$getIdentifierInfo() {
        IdentifierInfo returnIdInfo = null;
        SpoofChecker spoofChecker = this;
        synchronized (spoofChecker) {
            returnIdInfo = this.fCachedIdentifierInfo;
            this.fCachedIdentifierInfo = null;
        }
        if (returnIdInfo == null) {
            returnIdInfo = new IdentifierInfo();
        }
        return returnIdInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_icu_text_SpoofChecker$releaseIdentifierInfo(IdentifierInfo idInfo) {
        if (idInfo != null) {
            SpoofChecker spoofChecker = this;
            synchronized (spoofChecker) {
                if (this.fCachedIdentifierInfo == null) {
                    this.fCachedIdentifierInfo = idInfo;
                }
            }
        }
    }

    private static final int $$robo$$android_icu_text_SpoofChecker$getKeyLength(int x) {
        return x >> 29 & 3;
    }

    private /* synthetic */ void $$robo$$android_icu_text_SpoofChecker$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !SpoofChecker.class.desiredAssertionStatus();
        INCLUSION = new UnicodeSet("[\\u0027\\u002D-\\u002E\\u003A\\u00B7\\u0375\\u058A\\u05F3-\\u05F4\\u06FD-\\u06FE\\u0F0B\\u200C-\\u200D\\u2010\\u2019\\u2027\\u30A0\\u30FB]").freeze();
        RECOMMENDED = new UnicodeSet("[\\u0030-\\u0039\\u0041-\\u005A\\u005F\\u0061-\\u007A\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u0131\\u0134-\\u013E\\u0141-\\u0148\\u014A-\\u017E\\u018F\\u01A0-\\u01A1\\u01AF-\\u01B0\\u01CD-\\u01DC\\u01DE-\\u01E3\\u01E6-\\u01F0\\u01F4-\\u01F5\\u01F8-\\u021B\\u021E-\\u021F\\u0226-\\u0233\\u0259\\u02BB-\\u02BC\\u02EC\\u0300-\\u0304\\u0306-\\u030C\\u030F-\\u0311\\u0313-\\u0314\\u031B\\u0323-\\u0328\\u032D-\\u032E\\u0330-\\u0331\\u0335\\u0338-\\u0339\\u0342\\u0345\\u037B-\\u037D\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03CE\\u03FC-\\u045F\\u048A-\\u0529\\u052E-\\u052F\\u0531-\\u0556\\u0559\\u0561-\\u0586\\u05B4\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0620-\\u063F\\u0641-\\u0655\\u0660-\\u0669\\u0670-\\u0672\\u0674\\u0679-\\u068D\\u068F-\\u06D3\\u06D5\\u06E5-\\u06E6\\u06EE-\\u06FC\\u06FF\\u0750-\\u07B1\\u08A0-\\u08AC\\u08B2\\u0901-\\u094D\\u094F-\\u0950\\u0956-\\u0957\\u0960-\\u0963\\u0966-\\u096F\\u0971-\\u0977\\u0979-\\u097F\\u0981-\\u0983\\u0985-\\u098C\\u098F-\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BC-\\u09C4\\u09C7-\\u09C8\\u09CB-\\u09CE\\u09D7\\u09E0-\\u09E3\\u09E6-\\u09F1\\u0A01-\\u0A03\\u0A05-\\u0A0A\\u0A0F-\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A35\\u0A38-\\u0A39\\u0A3C\\u0A3E-\\u0A42\\u0A47-\\u0A48\\u0A4B-\\u0A4D\\u0A5C\\u0A66-\\u0A74\\u0A81-\\u0A83\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2-\\u0AB3\\u0AB5-\\u0AB9\\u0ABC-\\u0AC5\\u0AC7-\\u0AC9\\u0ACB-\\u0ACD\\u0AD0\\u0AE0-\\u0AE3\\u0AE6-\\u0AEF\\u0B01-\\u0B03\\u0B05-\\u0B0C\\u0B0F-\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32-\\u0B33\\u0B35-\\u0B39\\u0B3C-\\u0B43\\u0B47-\\u0B48\\u0B4B-\\u0B4D\\u0B56-\\u0B57\\u0B5F-\\u0B61\\u0B66-\\u0B6F\\u0B71\\u0B82-\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99-\\u0B9A\\u0B9C\\u0B9E-\\u0B9F\\u0BA3-\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BBE-\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCD\\u0BD0\\u0BD7\\u0BE6-\\u0BEF\\u0C01-\\u0C03\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C33\\u0C35-\\u0C39\\u0C3D-\\u0C44\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55-\\u0C56\\u0C60-\\u0C61\\u0C66-\\u0C6F\\u0C82-\\u0C83\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBC-\\u0CC4\\u0CC6-\\u0CC8\\u0CCA-\\u0CCD\\u0CD5-\\u0CD6\\u0CE0-\\u0CE3\\u0CE6-\\u0CEF\\u0CF1-\\u0CF2\\u0D02-\\u0D03\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D3A\\u0D3D-\\u0D43\\u0D46-\\u0D48\\u0D4A-\\u0D4E\\u0D57\\u0D60-\\u0D61\\u0D66-\\u0D6F\\u0D7A-\\u0D7F\\u0D82-\\u0D83\\u0D85-\\u0D8E\\u0D91-\\u0D96\\u0D9A-\\u0DA5\\u0DA7-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0DCA\\u0DCF-\\u0DD4\\u0DD6\\u0DD8-\\u0DDE\\u0DF2\\u0E01-\\u0E32\\u0E34-\\u0E3A\\u0E40-\\u0E4E\\u0E50-\\u0E59\\u0E81-\\u0E82\\u0E84\\u0E87-\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA-\\u0EAB\\u0EAD-\\u0EB2\\u0EB4-\\u0EB9\\u0EBB-\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EC8-\\u0ECD\\u0ED0-\\u0ED9\\u0EDE-\\u0EDF\\u0F00\\u0F20-\\u0F29\\u0F35\\u0F37\\u0F3E-\\u0F42\\u0F44-\\u0F47\\u0F49-\\u0F4C\\u0F4E-\\u0F51\\u0F53-\\u0F56\\u0F58-\\u0F5B\\u0F5D-\\u0F68\\u0F6A-\\u0F6C\\u0F71-\\u0F72\\u0F74\\u0F7A-\\u0F80\\u0F82-\\u0F84\\u0F86-\\u0F92\\u0F94-\\u0F97\\u0F99-\\u0F9C\\u0F9E-\\u0FA1\\u0FA3-\\u0FA6\\u0FA8-\\u0FAB\\u0FAD-\\u0FB8\\u0FBA-\\u0FBC\\u0FC6\\u1000-\\u1049\\u1050-\\u109D\\u10C7\\u10CD\\u10D0-\\u10F0\\u10F7-\\u10FA\\u10FD-\\u10FF\\u1200-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u135D-\\u135F\\u1380-\\u138F\\u1780-\\u17A2\\u17A5-\\u17A7\\u17A9-\\u17B3\\u17B6-\\u17CA\\u17D2\\u17D7\\u17DC\\u17E0-\\u17E9\\u1E00-\\u1E99\\u1E9E\\u1EA0-\\u1EF9\\u1F00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F70\\u1F72\\u1F74\\u1F76\\u1F78\\u1F7A\\u1F7C\\u1F80-\\u1FB4\\u1FB6-\\u1FBA\\u1FBC\\u1FC2-\\u1FC4\\u1FC6-\\u1FC8\\u1FCA\\u1FCC\\u1FD0-\\u1FD2\\u1FD6-\\u1FDA\\u1FE0-\\u1FE2\\u1FE4-\\u1FEA\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FF8\\u1FFA\\u1FFC\\u2D27\\u2D2D\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u3005-\\u3007\\u3041-\\u3096\\u3099-\\u309A\\u309D-\\u309E\\u30A1-\\u30FA\\u30FC-\\u30FE\\u3105-\\u312D\\u31A0-\\u31BA\\u3400-\\u4DB5\\u4E00-\\u9FD5\\uA660-\\uA661\\uA674-\\uA67B\\uA67F\\uA69F\\uA717-\\uA71F\\uA788\\uA78D-\\uA78E\\uA790-\\uA793\\uA7A0-\\uA7AA\\uA7FA\\uA9E7-\\uA9FE\\uAA60-\\uAA76\\uAA7A-\\uAA7F\\uAB01-\\uAB06\\uAB09-\\uAB0E\\uAB11-\\uAB16\\uAB20-\\uAB26\\uAB28-\\uAB2E\\uAC00-\\uD7A3\\uFA0E-\\uFA0F\\uFA11\\uFA13-\\uFA14\\uFA1F\\uFA21\\uFA23-\\uFA24\\uFA27-\\uFA29\\U00020000-\\U0002A6D6\\U0002A700-\\U0002B734\\U0002B740-\\U0002B81D\\U0002B820-\\U0002CEA1]").freeze();
        nfdNormalizer = Normalizer2.getNFDInstance();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_SpoofChecker$__constructor__();
    }

    private SpoofChecker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker$__constructor__(), 0, this);
    }

    @Deprecated
    public RestrictionLevel getRestrictionLevel() {
        return InvokeDynamicSupport.bootstrap("getRestrictionLevel", $$robo$$android_icu_text_SpoofChecker$getRestrictionLevel(), 0, this);
    }

    public int getChecks() {
        return (int)InvokeDynamicSupport.bootstrap("getChecks", $$robo$$android_icu_text_SpoofChecker$getChecks(), 0, this);
    }

    public Set<ULocale> getAllowedLocales() {
        return InvokeDynamicSupport.bootstrap("getAllowedLocales", $$robo$$android_icu_text_SpoofChecker$getAllowedLocales(), 0, this);
    }

    public Set<Locale> getAllowedJavaLocales() {
        return InvokeDynamicSupport.bootstrap("getAllowedJavaLocales", $$robo$$android_icu_text_SpoofChecker$getAllowedJavaLocales(), 0, this);
    }

    public UnicodeSet getAllowedChars() {
        return InvokeDynamicSupport.bootstrap("getAllowedChars", $$robo$$android_icu_text_SpoofChecker$getAllowedChars(), 0, this);
    }

    public boolean failsChecks(String string2, CheckResult checkResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("failsChecks", $$robo$$android_icu_text_SpoofChecker$failsChecks(java.lang.String android.icu.text.SpoofChecker$CheckResult ), 0, this, string2, checkResult);
    }

    public boolean failsChecks(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("failsChecks", $$robo$$android_icu_text_SpoofChecker$failsChecks(java.lang.String ), 0, this, string2);
    }

    public int areConfusable(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("areConfusable", $$robo$$android_icu_text_SpoofChecker$areConfusable(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getSkeleton(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getSkeleton", $$robo$$android_icu_text_SpoofChecker$getSkeleton(int java.lang.String ), 0, this, n, string2);
    }

    @Deprecated
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_SpoofChecker$equals(java.lang.Object ), 0, this, object);
    }

    @Deprecated
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_SpoofChecker$hashCode(), 0, this);
    }

    private void confusableLookup(int n, int n2, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("confusableLookup", $$robo$$android_icu_text_SpoofChecker$confusableLookup(int int java.lang.StringBuilder ), 0, this, n, n2, stringBuilder);
    }

    private void wholeScriptCheck(CharSequence charSequence, ScriptSet scriptSet) {
        InvokeDynamicSupport.bootstrap("wholeScriptCheck", $$robo$$android_icu_text_SpoofChecker$wholeScriptCheck(java.lang.CharSequence android.icu.text.SpoofChecker$ScriptSet ), 0, this, charSequence, scriptSet);
    }

    private IdentifierInfo getIdentifierInfo() {
        return InvokeDynamicSupport.bootstrap("getIdentifierInfo", $$robo$$android_icu_text_SpoofChecker$getIdentifierInfo(), 0, this);
    }

    private void releaseIdentifierInfo(IdentifierInfo identifierInfo) {
        InvokeDynamicSupport.bootstrap("releaseIdentifierInfo", $$robo$$android_icu_text_SpoofChecker$releaseIdentifierInfo(android.icu.text.IdentifierInfo ), 0, this, identifierInfo);
    }

    static int getKeyLength(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getKeyLength", $$robo$$android_icu_text_SpoofChecker$getKeyLength(int ), 0, (int)n);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_icu_text_SpoofChecker$__constructor__(var1_1);
    }

    static {
        RobolectricInternals.classInitializing(SpoofChecker.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpoofChecker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ScriptSet
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] bits;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_SpoofChecker_ScriptSet$__constructor__() {
            this.bits = new int[6];
        }

        private void $$robo$$android_icu_text_SpoofChecker_ScriptSet$__constructor__(ByteBuffer bytes) throws IOException {
            this.bits = new int[6];
            for (int j = 0; j < this.bits.length; ++j) {
                this.bits[j] = bytes.getInt();
            }
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$output(DataOutputStream os) throws IOException {
            for (int i = 0; i < this.bits.length; ++i) {
                os.writeInt(this.bits[i]);
            }
        }

        private final boolean $$robo$$android_icu_text_SpoofChecker_ScriptSet$equals(Object other) {
            if (!(other instanceof ScriptSet)) {
                return false;
            }
            ScriptSet otherSet = (ScriptSet)other;
            return Arrays.equals(this.bits, otherSet.bits);
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$Union(int script) {
            int index = script / 32;
            int bit = 1 << (script & 0x1F);
            if (!$assertionsDisabled && index >= this.bits.length * 4 * 4) {
                throw new AssertionError();
            }
            int n = index;
            this.bits[n] = this.bits[n] | bit;
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$Union(ScriptSet other) {
            for (int i = 0; i < this.bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | other.bits[i];
            }
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$intersect(ScriptSet other) {
            for (int i = 0; i < this.bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & other.bits[i];
            }
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$intersect(int script) {
            int i;
            int index = script / 32;
            int bit = 1 << (script & 0x1F);
            if (!$assertionsDisabled && index >= this.bits.length * 4 * 4) {
                throw new AssertionError();
            }
            for (i = 0; i < index; ++i) {
                this.bits[i] = 0;
            }
            int n = index;
            this.bits[n] = this.bits[n] & bit;
            for (i = index + 1; i < this.bits.length; ++i) {
                this.bits[i] = 0;
            }
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$setAll() {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = -1;
            }
        }

        private final void $$robo$$android_icu_text_SpoofChecker_ScriptSet$resetAll() {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0;
            }
        }

        private final int $$robo$$android_icu_text_SpoofChecker_ScriptSet$countMembers() {
            int count = 0;
            for (int i = 0; i < this.bits.length; ++i) {
                for (int x = this.bits[i]; x != 0; x &= x - 1) {
                    ++count;
                }
            }
            return count;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !SpoofChecker.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_SpoofChecker_ScriptSet$__constructor__();
        }

        public ScriptSet() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_ScriptSet$__constructor__(), 0, this);
        }

        private void __constructor__(ByteBuffer byteBuffer) throws IOException {
            this.$$robo$$android_icu_text_SpoofChecker_ScriptSet$__constructor__(byteBuffer);
        }

        public ScriptSet(ByteBuffer byteBuffer) throws IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_ScriptSet$__constructor__(java.nio.ByteBuffer ), 0, this, byteBuffer);
        }

        public void output(DataOutputStream dataOutputStream) throws IOException {
            InvokeDynamicSupport.bootstrap("output", $$robo$$android_icu_text_SpoofChecker_ScriptSet$output(java.io.DataOutputStream ), 0, this, dataOutputStream);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_SpoofChecker_ScriptSet$equals(java.lang.Object ), 0, this, object);
        }

        public void Union(int n) {
            InvokeDynamicSupport.bootstrap("Union", $$robo$$android_icu_text_SpoofChecker_ScriptSet$Union(int ), 0, this, n);
        }

        public void Union(ScriptSet scriptSet) {
            InvokeDynamicSupport.bootstrap("Union", $$robo$$android_icu_text_SpoofChecker_ScriptSet$Union(android.icu.text.SpoofChecker$ScriptSet ), 0, this, scriptSet);
        }

        public void intersect(ScriptSet scriptSet) {
            InvokeDynamicSupport.bootstrap("intersect", $$robo$$android_icu_text_SpoofChecker_ScriptSet$intersect(android.icu.text.SpoofChecker$ScriptSet ), 0, this, scriptSet);
        }

        public void intersect(int n) {
            InvokeDynamicSupport.bootstrap("intersect", $$robo$$android_icu_text_SpoofChecker_ScriptSet$intersect(int ), 0, this, n);
        }

        public void setAll() {
            InvokeDynamicSupport.bootstrap("setAll", $$robo$$android_icu_text_SpoofChecker_ScriptSet$setAll(), 0, this);
        }

        public void resetAll() {
            InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_icu_text_SpoofChecker_ScriptSet$resetAll(), 0, this);
        }

        public int countMembers() {
            return (int)InvokeDynamicSupport.bootstrap("countMembers", $$robo$$android_icu_text_SpoofChecker_ScriptSet$countMembers(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ScriptSet.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScriptSet)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SpoofData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] fCFUKeys;
        short[] fCFUValues;
        SpoofStringLengthsElement[] fCFUStringLengths;
        String fCFUStrings;
        Trie2 fAnyCaseTrie;
        Trie2 fLowerCaseTrie;
        ScriptSet[] fScriptSets;
        private static int DATA_FORMAT = 1130788128;
        private static IsAcceptable IS_ACCEPTABLE;

        private static final SpoofData $$robo$$android_icu_text_SpoofChecker_SpoofData$getDefault() {
            return DefaultData.INSTANCE;
        }

        private void $$robo$$android_icu_text_SpoofChecker_SpoofData$__constructor__() {
        }

        private void $$robo$$android_icu_text_SpoofChecker_SpoofData$__constructor__(ByteBuffer bytes) throws IOException {
            ICUBinary.readHeader(bytes, 1130788128, IS_ACCEPTABLE);
            bytes.mark();
            this.readData(bytes);
        }

        private final boolean $$robo$$android_icu_text_SpoofChecker_SpoofData$equals(Object other) {
            if (!(other instanceof SpoofData)) {
                return false;
            }
            SpoofData otherData = (SpoofData)other;
            if (!Arrays.equals(this.fCFUKeys, otherData.fCFUKeys)) {
                return false;
            }
            if (!Arrays.equals(this.fCFUValues, otherData.fCFUValues)) {
                return false;
            }
            if (!Arrays.deepEquals(this.fCFUStringLengths, otherData.fCFUStringLengths)) {
                return false;
            }
            if (this.fCFUStrings != otherData.fCFUStrings && this.fCFUStrings != null && !this.fCFUStrings.equals(otherData.fCFUStrings)) {
                return false;
            }
            if (this.fAnyCaseTrie != otherData.fAnyCaseTrie && this.fAnyCaseTrie != null && !this.fAnyCaseTrie.equals(otherData.fAnyCaseTrie)) {
                return false;
            }
            if (this.fLowerCaseTrie != otherData.fLowerCaseTrie && this.fLowerCaseTrie != null && !this.fLowerCaseTrie.equals(otherData.fLowerCaseTrie)) {
                return false;
            }
            return Arrays.deepEquals(this.fScriptSets, otherData.fScriptSets);
        }

        private final void $$robo$$android_icu_text_SpoofChecker_SpoofData$readData(ByteBuffer bytes) throws IOException {
            int i;
            int magic = bytes.getInt();
            if (magic != 944111087) {
                throw new IllegalArgumentException("Bad Spoof Check Data.");
            }
            int dataFormatVersion = bytes.getInt();
            int dataLength = bytes.getInt();
            int CFUKeysOffset = bytes.getInt();
            int CFUKeysSize = bytes.getInt();
            int CFUValuesOffset = bytes.getInt();
            int CFUValuesSize = bytes.getInt();
            int CFUStringTableOffset = bytes.getInt();
            int CFUStringTableSize = bytes.getInt();
            int CFUStringLengthsOffset = bytes.getInt();
            int CFUStringLengthsSize = bytes.getInt();
            int anyCaseTrieOffset = bytes.getInt();
            int anyCaseTrieSize = bytes.getInt();
            int lowerCaseTrieOffset = bytes.getInt();
            int lowerCaseTrieLength = bytes.getInt();
            int scriptSetsOffset = bytes.getInt();
            int scriptSetslength = bytes.getInt();
            this.fCFUKeys = null;
            this.fCFUValues = null;
            this.fCFUStringLengths = null;
            this.fCFUStrings = null;
            bytes.reset();
            ICUBinary.skipBytes(bytes, CFUKeysOffset);
            this.fCFUKeys = ICUBinary.getInts(bytes, CFUKeysSize, 0);
            bytes.reset();
            ICUBinary.skipBytes(bytes, CFUValuesOffset);
            this.fCFUValues = ICUBinary.getShorts(bytes, CFUValuesSize, 0);
            bytes.reset();
            ICUBinary.skipBytes(bytes, CFUStringTableOffset);
            this.fCFUStrings = ICUBinary.getString(bytes, CFUStringTableSize, 0);
            bytes.reset();
            ICUBinary.skipBytes(bytes, CFUStringLengthsOffset);
            this.fCFUStringLengths = new SpoofStringLengthsElement[CFUStringLengthsSize];
            for (i = 0; i < CFUStringLengthsSize; ++i) {
                this.fCFUStringLengths[i] = new SpoofStringLengthsElement();
                this.fCFUStringLengths[i].fLastString = bytes.getShort();
                this.fCFUStringLengths[i].fStrLength = bytes.getShort();
            }
            bytes.reset();
            ICUBinary.skipBytes(bytes, anyCaseTrieOffset);
            this.fAnyCaseTrie = Trie2.createFromSerialized(bytes);
            bytes.reset();
            ICUBinary.skipBytes(bytes, lowerCaseTrieOffset);
            this.fLowerCaseTrie = Trie2.createFromSerialized(bytes);
            bytes.reset();
            ICUBinary.skipBytes(bytes, scriptSetsOffset);
            this.fScriptSets = new ScriptSet[scriptSetslength];
            for (i = 0; i < scriptSetslength; ++i) {
                this.fScriptSets[i] = new ScriptSet(bytes);
            }
        }

        static void __staticInitializer__() {
            IS_ACCEPTABLE = new IsAcceptable();
        }

        static SpoofData getDefault() {
            return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_text_SpoofChecker_SpoofData$getDefault(), 0);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_SpoofChecker_SpoofData$__constructor__();
        }

        SpoofData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_SpoofData$__constructor__(), 0, this);
        }

        private void __constructor__(ByteBuffer byteBuffer) throws IOException {
            this.$$robo$$android_icu_text_SpoofChecker_SpoofData$__constructor__(byteBuffer);
        }

        SpoofData(ByteBuffer byteBuffer) throws IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_SpoofData$__constructor__(java.nio.ByteBuffer ), 0, this, byteBuffer);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_SpoofChecker_SpoofData$equals(java.lang.Object ), 0, this, object);
        }

        void readData(ByteBuffer byteBuffer) throws IOException {
            InvokeDynamicSupport.bootstrap("readData", $$robo$$android_icu_text_SpoofChecker_SpoofData$readData(java.nio.ByteBuffer ), 0, this, byteBuffer);
        }

        static {
            RobolectricInternals.classInitializing(SpoofData.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpoofData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class DefaultData
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private static SpoofData INSTANCE;

            private void $$robo$$android_icu_text_SpoofChecker_SpoofData_DefaultData$__constructor__() {
            }

            static void __staticInitializer__() {
                INSTANCE = null;
                try {
                    INSTANCE = new SpoofData(ICUBinary.getRequiredData("confusables.cfu"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_SpoofChecker_SpoofData_DefaultData$__constructor__();
            }

            private DefaultData() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_SpoofData_DefaultData$__constructor__(), 0, this);
            }

            static {
                RobolectricInternals.classInitializing(DefaultData.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultData)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class IsAcceptable
        implements ICUBinary.Authenticate,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$__constructor__() {
            }

            private final boolean $$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$isDataVersionAcceptable(byte[] version) {
                return version[0] == 1;
            }

            private /* synthetic */ void $$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$__constructor__();
            }

            private IsAcceptable() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$__constructor__(), 0, this);
            }

            @Override
            public boolean isDataVersionAcceptable(byte[] byArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_text_SpoofChecker_SpoofData_IsAcceptable$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class SpoofStringLengthsElement
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int fLastString;
            int fStrLength;

            private void $$robo$$android_icu_text_SpoofChecker_SpoofData_SpoofStringLengthsElement$__constructor__() {
            }

            private final boolean $$robo$$android_icu_text_SpoofChecker_SpoofData_SpoofStringLengthsElement$equals(Object other) {
                if (!(other instanceof SpoofStringLengthsElement)) {
                    return false;
                }
                SpoofStringLengthsElement otherEl = (SpoofStringLengthsElement)other;
                return this.fLastString == otherEl.fLastString && this.fStrLength == otherEl.fStrLength;
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_SpoofChecker_SpoofData_SpoofStringLengthsElement$__constructor__();
            }

            SpoofStringLengthsElement() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_SpoofData_SpoofStringLengthsElement$__constructor__(), 0, this);
            }

            public boolean equals(Object object) {
                return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_SpoofChecker_SpoofData_SpoofStringLengthsElement$equals(java.lang.Object ), 0, this, object);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpoofStringLengthsElement)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class CheckResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int checks;
        @Deprecated
        public int position;
        @Deprecated
        public UnicodeSet numerics;
        @Deprecated
        public RestrictionLevel restrictionLevel;

        private void $$robo$$android_icu_text_SpoofChecker_CheckResult$__constructor__() {
            this.checks = 0;
            this.position = 0;
        }

        private final String $$robo$$android_icu_text_SpoofChecker_CheckResult$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("checks:");
            if (this.checks == 0) {
                sb.append(" none");
            } else if (this.checks == -1) {
                sb.append(" all");
            } else {
                if ((this.checks & 1) != 0) {
                    sb.append(" SINGLE_SCRIPT_CONFUSABLE");
                }
                if ((this.checks & 2) != 0) {
                    sb.append(" MIXED_SCRIPT_CONFUSABLE");
                }
                if ((this.checks & 4) != 0) {
                    sb.append(" WHOLE_SCRIPT_CONFUSABLE");
                }
                if ((this.checks & 8) != 0) {
                    sb.append(" ANY_CASE");
                }
                if ((this.checks & 0x10) != 0) {
                    sb.append(" RESTRICTION_LEVEL");
                }
                if ((this.checks & 0x20) != 0) {
                    sb.append(" INVISIBLE");
                }
                if ((this.checks & 0x40) != 0) {
                    sb.append(" CHAR_LIMIT");
                }
                if ((this.checks & 0x80) != 0) {
                    sb.append(" MIXED_NUMBERS");
                }
            }
            sb.append(", numerics: ").append(this.numerics.toPattern(false));
            sb.append(", position: ").append(this.position);
            sb.append(", restrictionLevel: ").append((Object)this.restrictionLevel);
            return sb.toString();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_SpoofChecker_CheckResult$__constructor__();
        }

        public CheckResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_CheckResult$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_SpoofChecker_CheckResult$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int fChecks;
        SpoofData fSpoofData;
        UnicodeSet fAllowedCharsSet;
        Set<ULocale> fAllowedLocales;
        private RestrictionLevel fRestrictionLevel;

        private void $$robo$$android_icu_text_SpoofChecker_Builder$__constructor__() {
            this.fAllowedCharsSet = new UnicodeSet(0, 0x10FFFF);
            this.fAllowedLocales = new LinkedHashSet<ULocale>();
            this.fChecks = -1;
            this.fSpoofData = null;
            this.fRestrictionLevel = RestrictionLevel.HIGHLY_RESTRICTIVE;
        }

        private void $$robo$$android_icu_text_SpoofChecker_Builder$__constructor__(SpoofChecker src) {
            this.fAllowedCharsSet = new UnicodeSet(0, 0x10FFFF);
            this.fAllowedLocales = new LinkedHashSet<ULocale>();
            this.fChecks = src.fChecks;
            this.fSpoofData = src.fSpoofData;
            this.fAllowedCharsSet.set(src.fAllowedCharsSet);
            this.fAllowedLocales.addAll(src.fAllowedLocales);
            this.fRestrictionLevel = src.fRestrictionLevel;
        }

        private final SpoofChecker $$robo$$android_icu_text_SpoofChecker_Builder$build() {
            if (this.fSpoofData == null) {
                this.fSpoofData = SpoofData.getDefault();
            }
            SpoofChecker result = new SpoofChecker();
            result.fChecks = this.fChecks;
            result.fSpoofData = this.fSpoofData;
            result.fAllowedCharsSet = (UnicodeSet)this.fAllowedCharsSet.clone();
            result.fAllowedCharsSet.freeze();
            result.fAllowedLocales = new HashSet<ULocale>(this.fAllowedLocales);
            result.fRestrictionLevel = this.fRestrictionLevel;
            return result;
        }

        private final Builder $$robo$$android_icu_text_SpoofChecker_Builder$setData(Reader confusables, Reader confusablesWholeScript) throws ParseException, IOException {
            this.fSpoofData = new SpoofData();
            ConfusabledataBuilder.buildConfusableData(confusables, this.fSpoofData);
            WSConfusableDataBuilder.buildWSConfusableData(confusablesWholeScript, this.fSpoofData);
            return this;
        }

        private final Builder $$robo$$android_icu_text_SpoofChecker_Builder$setChecks(int checks) {
            if (0 != (checks & 0)) {
                throw new IllegalArgumentException("Bad Spoof Checks value.");
            }
            this.fChecks = checks & 0xFFFFFFFF;
            return this;
        }

        private final Builder $$robo$$android_icu_text_SpoofChecker_Builder$setAllowedLocales(Set<ULocale> locales) {
            this.fAllowedCharsSet.clear();
            for (ULocale locale : locales) {
                this.addScriptChars(locale, this.fAllowedCharsSet);
            }
            this.fAllowedLocales.clear();
            if (locales.size() == 0) {
                this.fAllowedCharsSet.add(0, 0x10FFFF);
                this.fChecks &= 0xFFFFFFBF;
                return this;
            }
            UnicodeSet tempSet = new UnicodeSet();
            tempSet.applyIntPropertyValue(4106, 0);
            this.fAllowedCharsSet.addAll(tempSet);
            tempSet.applyIntPropertyValue(4106, 1);
            this.fAllowedCharsSet.addAll(tempSet);
            this.fAllowedLocales.clear();
            this.fAllowedLocales.addAll(locales);
            this.fChecks |= 0x40;
            return this;
        }

        private final Builder $$robo$$android_icu_text_SpoofChecker_Builder$setAllowedJavaLocales(Set<Locale> locales) {
            HashSet<ULocale> ulocales = new HashSet<ULocale>(locales.size());
            for (Locale locale : locales) {
                ulocales.add(ULocale.forLocale(locale));
            }
            return this.setAllowedLocales(ulocales);
        }

        private final void $$robo$$android_icu_text_SpoofChecker_Builder$addScriptChars(ULocale locale, UnicodeSet allowedChars) {
            int[] scripts = UScript.getCode(locale);
            UnicodeSet tmpSet = new UnicodeSet();
            for (int i = 0; i < scripts.length; ++i) {
                tmpSet.applyIntPropertyValue(4106, scripts[i]);
                allowedChars.addAll(tmpSet);
            }
        }

        private final Builder $$robo$$android_icu_text_SpoofChecker_Builder$setAllowedChars(UnicodeSet chars) {
            this.fAllowedCharsSet.set(chars);
            this.fAllowedLocales.clear();
            this.fChecks |= 0x40;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_icu_text_SpoofChecker_Builder$setRestrictionLevel(RestrictionLevel restrictionLevel) {
            this.fRestrictionLevel = restrictionLevel;
            this.fChecks |= 0x10;
            return this;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_SpoofChecker_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder$__constructor__(), 0, this);
        }

        private void __constructor__(SpoofChecker spoofChecker) {
            this.$$robo$$android_icu_text_SpoofChecker_Builder$__constructor__(spoofChecker);
        }

        public Builder(SpoofChecker spoofChecker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder$__constructor__(android.icu.text.SpoofChecker ), 0, this, spoofChecker);
        }

        public SpoofChecker build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_text_SpoofChecker_Builder$build(), 0, this);
        }

        public Builder setData(Reader reader, Reader reader2) throws ParseException, IOException {
            return InvokeDynamicSupport.bootstrap("setData", $$robo$$android_icu_text_SpoofChecker_Builder$setData(java.io.Reader java.io.Reader ), 0, this, reader, reader2);
        }

        public Builder setChecks(int n) {
            return InvokeDynamicSupport.bootstrap("setChecks", $$robo$$android_icu_text_SpoofChecker_Builder$setChecks(int ), 0, this, n);
        }

        public Builder setAllowedLocales(Set<ULocale> set) {
            return InvokeDynamicSupport.bootstrap("setAllowedLocales", $$robo$$android_icu_text_SpoofChecker_Builder$setAllowedLocales(java.util.Set<android.icu.util.ULocale> ), 0, this, set);
        }

        public Builder setAllowedJavaLocales(Set<Locale> set) {
            return InvokeDynamicSupport.bootstrap("setAllowedJavaLocales", $$robo$$android_icu_text_SpoofChecker_Builder$setAllowedJavaLocales(java.util.Set<java.util.Locale> ), 0, this, set);
        }

        private void addScriptChars(ULocale uLocale, UnicodeSet unicodeSet) {
            InvokeDynamicSupport.bootstrap("addScriptChars", $$robo$$android_icu_text_SpoofChecker_Builder$addScriptChars(android.icu.util.ULocale android.icu.text.UnicodeSet ), 0, this, uLocale, unicodeSet);
        }

        public Builder setAllowedChars(UnicodeSet unicodeSet) {
            return InvokeDynamicSupport.bootstrap("setAllowedChars", $$robo$$android_icu_text_SpoofChecker_Builder$setAllowedChars(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
        }

        @Deprecated
        public Builder setRestrictionLevel(RestrictionLevel restrictionLevel) {
            return InvokeDynamicSupport.bootstrap("setRestrictionLevel", $$robo$$android_icu_text_SpoofChecker_Builder$setRestrictionLevel(android.icu.text.SpoofChecker$RestrictionLevel ), 0, this, restrictionLevel);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class ConfusabledataBuilder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Hashtable<Integer, SPUString> fSLTable;
            private Hashtable<Integer, SPUString> fSATable;
            private Hashtable<Integer, SPUString> fMLTable;
            private Hashtable<Integer, SPUString> fMATable;
            private UnicodeSet fKeySet;
            private StringBuffer fStringTable;
            private ArrayList<Integer> fKeyVec;
            private ArrayList<Integer> fValueVec;
            private ArrayList<Integer> fStringLengthsTable;
            private SPUStringPool stringPool;
            private Pattern fParseLine;
            private Pattern fParseHexNum;
            private int fLineNum;
            static /* synthetic */ boolean $assertionsDisabled;

            private void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$__constructor__() {
                this.fSLTable = new Hashtable();
                this.fSATable = new Hashtable();
                this.fMLTable = new Hashtable();
                this.fMATable = new Hashtable();
                this.fKeySet = new UnicodeSet();
                this.fKeyVec = new ArrayList();
                this.fValueVec = new ArrayList();
                this.stringPool = new SPUStringPool();
            }

            private final void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$build(Reader confusables, SpoofData dest) throws ParseException, IOException {
                int i;
                StringBuffer fInput = new StringBuffer();
                WSConfusableDataBuilder.readWholeFileToString(confusables, fInput);
                this.fParseLine = Pattern.compile("(?m)^[ \\t]*([0-9A-Fa-f]+)[ \\t]+;[ \\t]*([0-9A-Fa-f]+(?:[ \\t]+[0-9A-Fa-f]+)*)[ \\t]*;\\s*(?:(SL)|(SA)|(ML)|(MA))[ \\t]*(?:#.*?)?$|^([ \\t]*(?:#.*?)?)$|^(.*?)$");
                this.fParseHexNum = Pattern.compile("\\s*([0-9A-F]+)");
                if (fInput.charAt(0) == '\ufeff') {
                    fInput.setCharAt(0, ' ');
                }
                Matcher matcher = this.fParseLine.matcher(fInput);
                while (matcher.find()) {
                    Hashtable<Integer, SPUString> table;
                    ++this.fLineNum;
                    if (matcher.start(7) >= 0) continue;
                    if (matcher.start(8) >= 0) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Unrecognized Line: " + matcher.group(8), matcher.start(8));
                    }
                    int keyChar = Integer.parseInt(matcher.group(1), 16);
                    if (keyChar > 0x10FFFF) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Bad code point: " + matcher.group(1), matcher.start(1));
                    }
                    Matcher m = this.fParseHexNum.matcher(matcher.group(2));
                    StringBuilder mapString = new StringBuilder();
                    while (m.find()) {
                        int c = Integer.parseInt(m.group(1), 16);
                        if (keyChar > 0x10FFFF) {
                            throw new ParseException("Confusables, line " + this.fLineNum + ": Bad code point: " + Integer.toString(c, 16), matcher.start(2));
                        }
                        mapString.appendCodePoint(c);
                    }
                    if (!$assertionsDisabled && mapString.length() < 1) {
                        throw new AssertionError();
                    }
                    SPUString smapString = this.stringPool.addString(mapString.toString());
                    Hashtable<Integer, SPUString> hashtable = matcher.start(3) >= 0 ? this.fSLTable : (matcher.start(4) >= 0 ? this.fSATable : (matcher.start(5) >= 0 ? this.fMLTable : (table = matcher.start(6) >= 0 ? this.fMATable : null)));
                    if (!$assertionsDisabled && table == null) {
                        throw new AssertionError();
                    }
                    if (table != this.fMATable) {
                        throw new ParseException("Confusables, line " + this.fLineNum + ": Table must be 'MA'.", 0);
                    }
                    this.fSLTable.put(keyChar, smapString);
                    this.fSATable.put(keyChar, smapString);
                    this.fMLTable.put(keyChar, smapString);
                    this.fMATable.put(keyChar, smapString);
                    this.fKeySet.add(keyChar);
                }
                this.stringPool.sort();
                this.fStringTable = new StringBuffer();
                this.fStringLengthsTable = new ArrayList();
                int previousStringLength = 0;
                int previousStringIndex = 0;
                int poolSize = this.stringPool.size();
                for (i = 0; i < poolSize; ++i) {
                    SPUString s = this.stringPool.getByIndex(i);
                    int strLen = s.fStr.length();
                    int strIndex = this.fStringTable.length();
                    if (!$assertionsDisabled && strLen < previousStringLength) {
                        throw new AssertionError();
                    }
                    if (strLen == 1) {
                        s.fStrTableIndex = s.fStr.charAt(0);
                    } else {
                        if (strLen > previousStringLength && previousStringLength >= 4) {
                            this.fStringLengthsTable.add(previousStringIndex);
                            this.fStringLengthsTable.add(previousStringLength);
                        }
                        s.fStrTableIndex = strIndex;
                        this.fStringTable.append(s.fStr);
                    }
                    previousStringLength = strLen;
                    previousStringIndex = strIndex;
                }
                if (previousStringLength >= 4) {
                    this.fStringLengthsTable.add(previousStringIndex);
                    this.fStringLengthsTable.add(previousStringLength);
                }
                for (String keyCharStr : this.fKeySet) {
                    int keyChar = keyCharStr.codePointAt(0);
                    this.addKeyEntry(keyChar, this.fSLTable, 0x1000000);
                    this.addKeyEntry(keyChar, this.fSATable, 0x2000000);
                    this.addKeyEntry(keyChar, this.fMLTable, 0x4000000);
                    this.addKeyEntry(keyChar, this.fMATable, 0x8000000);
                }
                int numKeys = this.fKeyVec.size();
                dest.fCFUKeys = new int[numKeys];
                int previousKey = 0;
                for (i = 0; i < numKeys; ++i) {
                    int key = this.fKeyVec.get(i);
                    if (!$assertionsDisabled && (key & 0xFFFFFF) < (previousKey & 0xFFFFFF)) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && (key & 0xFF000000) == 0) {
                        throw new AssertionError();
                    }
                    dest.fCFUKeys[i] = key;
                    previousKey = key;
                }
                int numValues = this.fValueVec.size();
                if (!$assertionsDisabled && numKeys != numValues) {
                    throw new AssertionError();
                }
                dest.fCFUValues = new short[numValues];
                i = 0;
                for (int value : this.fValueVec) {
                    if (!$assertionsDisabled && value >= 65535) {
                        throw new AssertionError();
                    }
                    dest.fCFUValues[i++] = (short)value;
                }
                dest.fCFUStrings = this.fStringTable.toString();
                int lengthTableLength = this.fStringLengthsTable.size();
                int previousLength = 0;
                int stringLengthsSize = lengthTableLength / 2;
                dest.fCFUStringLengths = new SpoofData.SpoofStringLengthsElement[stringLengthsSize];
                for (i = 0; i < stringLengthsSize; ++i) {
                    int offset = this.fStringLengthsTable.get(i * 2);
                    int length = this.fStringLengthsTable.get(i * 2 + 1);
                    if (!$assertionsDisabled && offset >= dest.fCFUStrings.length()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && length >= 40) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && length <= previousLength) {
                        throw new AssertionError();
                    }
                    dest.fCFUStringLengths[i] = new SpoofData.SpoofStringLengthsElement();
                    dest.fCFUStringLengths[i].fLastString = offset;
                    dest.fCFUStringLengths[i].fStrLength = length;
                    previousLength = length;
                }
            }

            private final void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$addKeyEntry(int keyChar, Hashtable<Integer, SPUString> table, int tableFlag) {
                int adjustedMappingLength;
                int key;
                SPUString targetMapping = table.get(keyChar);
                if (targetMapping == null) {
                    return;
                }
                boolean keyHasMultipleValues = false;
                for (int i = this.fKeyVec.size() - 1; i >= 0 && ((key = this.fKeyVec.get(i).intValue()) & 0xFFFFFF) == keyChar; --i) {
                    String mapping = this.getMapping(i);
                    if (mapping.equals(targetMapping.fStr)) {
                        this.fKeyVec.set(i, key |= tableFlag);
                        return;
                    }
                    keyHasMultipleValues = true;
                }
                int newKey = keyChar | tableFlag;
                if (keyHasMultipleValues) {
                    newKey |= 0x10000000;
                }
                if ((adjustedMappingLength = targetMapping.fStr.length() - 1) > 3) {
                    adjustedMappingLength = 3;
                }
                int newData = targetMapping.fStrTableIndex;
                this.fKeyVec.add(newKey |= adjustedMappingLength << 29);
                this.fValueVec.add(newData);
                if (keyHasMultipleValues) {
                    int previousKeyIndex = this.fKeyVec.size() - 2;
                    int previousKey = this.fKeyVec.get(previousKeyIndex);
                    this.fKeyVec.set(previousKeyIndex, previousKey |= 0x10000000);
                }
            }

            private final String $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$getMapping(int index) {
                int key = this.fKeyVec.get(index);
                int value = this.fValueVec.get(index);
                int length = SpoofChecker.getKeyLength(key);
                switch (length) {
                    case 0: {
                        char[] cs = new char[]{(char)value};
                        return new String(cs);
                    }
                    case 1: 
                    case 2: {
                        return this.fStringTable.substring(value, value + length + 1);
                    }
                    case 3: {
                        length = 0;
                        for (int i = 0; i < this.fStringLengthsTable.size(); i += 2) {
                            int lastIndexWithLen = this.fStringLengthsTable.get(i);
                            if (value > lastIndexWithLen) continue;
                            length = this.fStringLengthsTable.get(i + 1);
                            break;
                        }
                        if (!$assertionsDisabled && length < 3) {
                            throw new AssertionError();
                        }
                        return this.fStringTable.substring(value, value + length);
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return "";
            }

            private static final void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$buildConfusableData(Reader confusables, SpoofData dest) throws IOException, ParseException {
                ConfusabledataBuilder builder = new ConfusabledataBuilder();
                builder.build(confusables, dest);
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !SpoofChecker.class.desiredAssertionStatus();
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$__constructor__();
            }

            ConfusabledataBuilder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$__constructor__(), 0, this);
            }

            void build(Reader reader, SpoofData spoofData) throws ParseException, IOException {
                InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$build(java.io.Reader android.icu.text.SpoofChecker$SpoofData ), 0, this, reader, spoofData);
            }

            void addKeyEntry(int n, Hashtable<Integer, SPUString> hashtable, int n2) {
                InvokeDynamicSupport.bootstrap("addKeyEntry", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$addKeyEntry(int java.util.Hashtable<java.lang.Integer, android.icu.text.SpoofChecker$Builder$ConfusabledataBuilder$SPUString> int ), 0, this, n, hashtable, n2);
            }

            String getMapping(int n) {
                return InvokeDynamicSupport.bootstrap("getMapping", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$getMapping(int ), 0, this, n);
            }

            public static void buildConfusableData(Reader reader, SpoofData spoofData) throws IOException, ParseException {
                InvokeDynamicSupport.bootstrapStatic("buildConfusableData", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder$buildConfusableData(java.io.Reader android.icu.text.SpoofChecker$SpoofData ), 0, (Reader)reader, (SpoofData)spoofData);
            }

            static {
                RobolectricInternals.classInitializing(ConfusabledataBuilder.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfusabledataBuilder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            private static class SPUStringPool
            implements ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;
                private Vector<SPUString> fVec;
                private Hashtable<String, SPUString> fHash;

                private void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$__constructor__() {
                    this.fVec = new Vector();
                    this.fHash = new Hashtable();
                }

                private final int $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$size() {
                    return this.fVec.size();
                }

                private final SPUString $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$getByIndex(int index) {
                    SPUString retString = this.fVec.elementAt(index);
                    return retString;
                }

                private final SPUString $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$addString(String src) {
                    SPUString hashedString = this.fHash.get(src);
                    if (hashedString == null) {
                        hashedString = new SPUString(src);
                        this.fHash.put(src, hashedString);
                        this.fVec.addElement(hashedString);
                    }
                    return hashedString;
                }

                private final void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$sort() {
                    Collections.sort(this.fVec, new SPUStringComparator());
                }

                private void __constructor__() {
                    this.$$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$__constructor__();
                }

                public SPUStringPool() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$__constructor__(), 0, this);
                }

                public int size() {
                    return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$size(), 0, this);
                }

                public SPUString getByIndex(int n) {
                    return InvokeDynamicSupport.bootstrap("getByIndex", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$getByIndex(int ), 0, this, n);
                }

                public SPUString addString(String string2) {
                    return InvokeDynamicSupport.bootstrap("addString", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$addString(java.lang.String ), 0, this, string2);
                }

                public void sort() {
                    InvokeDynamicSupport.bootstrap("sort", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringPool$sort(), 0, this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SPUStringPool)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }

            private static class SPUStringComparator
            implements Comparator<SPUString> {
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$__constructor__() {
                }

                private final int $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$compare(SPUString sL, SPUString sR) {
                    int lenR;
                    int lenL = sL.fStr.length();
                    if (lenL < (lenR = sR.fStr.length())) {
                        return -1;
                    }
                    if (lenL > lenR) {
                        return 1;
                    }
                    return sL.fStr.compareTo(sR.fStr);
                }

                private /* synthetic */ void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$__constructor__(1 x0) {
                }

                private void __constructor__() {
                    this.$$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$__constructor__();
                }

                private SPUStringComparator() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$__constructor__(), 0, this);
                }

                @Override
                public int compare(SPUString sPUString, SPUString sPUString2) {
                    return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$compare(android.icu.text.SpoofChecker$Builder$ConfusabledataBuilder$SPUString android.icu.text.SpoofChecker$Builder$ConfusabledataBuilder$SPUString ), 0, this, sPUString, sPUString2);
                }

                private /* synthetic */ void __constructor__(1 var1_1) {
                    this.$$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUStringComparator$__constructor__(var1_1);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SPUStringComparator)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }

            private static class SPUString
            implements ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;
                String fStr;
                int fStrTableIndex;

                private void $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUString$__constructor__(String s) {
                    this.fStr = s;
                    this.fStrTableIndex = 0;
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUString$__constructor__(string2);
                }

                SPUString(String string2) {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder_ConfusabledataBuilder_SPUString$__constructor__(java.lang.String ), 0, this, string2);
                }

                public /* synthetic */ SPUString() {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SPUString)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }

        private static class WSConfusableDataBuilder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            static String parseExp;
            static /* synthetic */ boolean $assertionsDisabled;

            private void $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$__constructor__() {
            }

            private static final void $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$readWholeFileToString(Reader reader, StringBuffer buffer) throws IOException {
                String line;
                LineNumberReader lnr = new LineNumberReader(reader);
                while ((line = lnr.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
            }

            private static final void $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$buildWSConfusableData(Reader confusablesWS, SpoofData dest) throws ParseException, IOException {
                Pattern parseRegexp = null;
                StringBuffer input = new StringBuffer();
                int lineNum = 0;
                ArrayList<BuilderScriptSet> scriptSets = null;
                int rtScriptSetsCount = 2;
                Trie2Writable anyCaseTrie = new Trie2Writable(0, 0);
                Trie2Writable lowerCaseTrie = new Trie2Writable(0, 0);
                scriptSets = new ArrayList<BuilderScriptSet>();
                scriptSets.add(null);
                scriptSets.add(null);
                WSConfusableDataBuilder.readWholeFileToString(confusablesWS, input);
                parseRegexp = Pattern.compile(parseExp);
                if (input.charAt(0) == '\ufeff') {
                    input.setCharAt(0, ' ');
                }
                Matcher matcher = parseRegexp.matcher(input);
                while (matcher.find()) {
                    ++lineNum;
                    if (matcher.start(1) >= 0) continue;
                    if (matcher.start(8) >= 0) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Unrecognized input: " + matcher.group(), matcher.start());
                    }
                    int startCodePoint = Integer.parseInt(matcher.group(2), 16);
                    if (startCodePoint > 0x10FFFF) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": out of range code point: " + matcher.group(2), matcher.start(2));
                    }
                    int endCodePoint = startCodePoint;
                    if (matcher.start(3) >= 0) {
                        endCodePoint = Integer.parseInt(matcher.group(3), 16);
                    }
                    if (endCodePoint > 0x10FFFF) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": out of range code point: " + matcher.group(3), matcher.start(3));
                    }
                    String srcScriptName = matcher.group(4);
                    String targScriptName = matcher.group(5);
                    int srcScript = UCharacter.getPropertyValueEnum(4106, srcScriptName);
                    int targScript = UCharacter.getPropertyValueEnum(4106, targScriptName);
                    if (srcScript == -1) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Invalid script code t: " + matcher.group(4), matcher.start(4));
                    }
                    if (targScript == -1) {
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Invalid script code t: " + matcher.group(5), matcher.start(5));
                    }
                    Trie2Writable table = anyCaseTrie;
                    if (matcher.start(7) >= 0) {
                        table = lowerCaseTrie;
                    }
                    for (int cp = startCodePoint; cp <= endCodePoint; ++cp) {
                        int setIndex = table.get(cp);
                        BuilderScriptSet bsset = null;
                        if (setIndex > 0) {
                            if (!$assertionsDisabled && setIndex >= scriptSets.size()) {
                                throw new AssertionError();
                            }
                            bsset = (BuilderScriptSet)scriptSets.get(setIndex);
                        } else {
                            bsset = new BuilderScriptSet();
                            bsset.codePoint = cp;
                            bsset.trie = table;
                            bsset.sset = new ScriptSet();
                            bsset.index = setIndex = scriptSets.size();
                            bsset.rindex = 0;
                            scriptSets.add(bsset);
                            table.set(cp, setIndex);
                        }
                        bsset.sset.Union(targScript);
                        bsset.sset.Union(srcScript);
                        int cpScript = UScript.getScript(cp);
                        if (cpScript == srcScript) continue;
                        throw new ParseException("ConfusablesWholeScript, line " + lineNum + ": Mismatch between source script and code point " + Integer.toString(cp, 16), matcher.start(5));
                    }
                }
                rtScriptSetsCount = 2;
                for (int outeri = 2; outeri < scriptSets.size(); ++outeri) {
                    BuilderScriptSet outerSet = (BuilderScriptSet)scriptSets.get(outeri);
                    if (outerSet.index != outeri) continue;
                    outerSet.rindex = rtScriptSetsCount++;
                    for (int inneri = outeri + 1; inneri < scriptSets.size(); ++inneri) {
                        BuilderScriptSet innerSet = (BuilderScriptSet)scriptSets.get(inneri);
                        if (!outerSet.sset.equals(innerSet.sset) || outerSet.sset == innerSet.sset) continue;
                        innerSet.sset = outerSet.sset;
                        innerSet.index = outeri;
                        innerSet.rindex = outerSet.rindex;
                    }
                }
                for (int i = 2; i < scriptSets.size(); ++i) {
                    BuilderScriptSet bSet = (BuilderScriptSet)scriptSets.get(i);
                    if (bSet.rindex == i) continue;
                    bSet.trie.set(bSet.codePoint, bSet.rindex);
                }
                UnicodeSet ignoreSet = new UnicodeSet();
                ignoreSet.applyIntPropertyValue(4106, 0);
                UnicodeSet inheritedSet = new UnicodeSet();
                inheritedSet.applyIntPropertyValue(4106, 1);
                ignoreSet.addAll(inheritedSet);
                for (int rn = 0; rn < ignoreSet.getRangeCount(); ++rn) {
                    int rangeStart = ignoreSet.getRangeStart(rn);
                    int rangeEnd = ignoreSet.getRangeEnd(rn);
                    anyCaseTrie.setRange(rangeStart, rangeEnd, 1, true);
                    lowerCaseTrie.setRange(rangeStart, rangeEnd, 1, true);
                }
                dest.fAnyCaseTrie = anyCaseTrie.toTrie2_16();
                dest.fLowerCaseTrie = lowerCaseTrie.toTrie2_16();
                dest.fScriptSets = new ScriptSet[rtScriptSetsCount];
                dest.fScriptSets[0] = new ScriptSet();
                dest.fScriptSets[1] = new ScriptSet();
                int rindex = 2;
                for (int i = 2; i < scriptSets.size(); ++i) {
                    BuilderScriptSet bSet = (BuilderScriptSet)scriptSets.get(i);
                    if (bSet.rindex < rindex) continue;
                    if (!$assertionsDisabled && rindex != bSet.rindex) {
                        throw new AssertionError();
                    }
                    dest.fScriptSets[rindex] = bSet.sset;
                    ++rindex;
                }
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !SpoofChecker.class.desiredAssertionStatus();
                parseExp = "(?m)^([ \\t]*(?:#.*?)?)$|^(?:\\s*([0-9A-F]{4,})(?:..([0-9A-F]{4,}))?\\s*;\\s*([A-Za-z]+)\\s*;\\s*([A-Za-z]+)\\s*;\\s*(?:(A)|(L))[ \\t]*(?:#.*?)?)$|^(.*?)$";
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$__constructor__();
            }

            private WSConfusableDataBuilder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$__constructor__(), 0, this);
            }

            static void readWholeFileToString(Reader reader, StringBuffer stringBuffer) throws IOException {
                InvokeDynamicSupport.bootstrapStatic("readWholeFileToString", $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$readWholeFileToString(java.io.Reader java.lang.StringBuffer ), 0, (Reader)reader, (StringBuffer)stringBuffer);
            }

            static void buildWSConfusableData(Reader reader, SpoofData spoofData) throws ParseException, IOException {
                InvokeDynamicSupport.bootstrapStatic("buildWSConfusableData", $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder$buildWSConfusableData(java.io.Reader android.icu.text.SpoofChecker$SpoofData ), 0, (Reader)reader, (SpoofData)spoofData);
            }

            static {
                RobolectricInternals.classInitializing(WSConfusableDataBuilder.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WSConfusableDataBuilder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            public static class BuilderScriptSet
            implements ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;
                int codePoint;
                Trie2Writable trie;
                ScriptSet sset;
                int index;
                int rindex;

                private void $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder_BuilderScriptSet$__constructor__() {
                    this.codePoint = -1;
                    this.trie = null;
                    this.sset = null;
                    this.index = 0;
                    this.rindex = 0;
                }

                private void __constructor__() {
                    this.$$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder_BuilderScriptSet$__constructor__();
                }

                BuilderScriptSet() {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_Builder_WSConfusableDataBuilder_BuilderScriptSet$__constructor__(), 0, this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BuilderScriptSet)this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class RestrictionLevel
    extends Enum<RestrictionLevel> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ RestrictionLevel ASCII;
        public static /* enum */ RestrictionLevel SINGLE_SCRIPT_RESTRICTIVE;
        public static /* enum */ RestrictionLevel HIGHLY_RESTRICTIVE;
        public static /* enum */ RestrictionLevel MODERATELY_RESTRICTIVE;
        public static /* enum */ RestrictionLevel MINIMALLY_RESTRICTIVE;
        public static /* enum */ RestrictionLevel UNRESTRICTIVE;
        private static /* synthetic */ RestrictionLevel[] $VALUES;

        private static final RestrictionLevel[] $$robo$$android_icu_text_SpoofChecker_RestrictionLevel$values() {
            return (RestrictionLevel[])$VALUES.clone();
        }

        private static final RestrictionLevel $$robo$$android_icu_text_SpoofChecker_RestrictionLevel$valueOf(String name) {
            return Enum.valueOf(RestrictionLevel.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_SpoofChecker_RestrictionLevel$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ASCII = new RestrictionLevel();
            SINGLE_SCRIPT_RESTRICTIVE = new RestrictionLevel();
            HIGHLY_RESTRICTIVE = new RestrictionLevel();
            MODERATELY_RESTRICTIVE = new RestrictionLevel();
            MINIMALLY_RESTRICTIVE = new RestrictionLevel();
            UNRESTRICTIVE = new RestrictionLevel();
            $VALUES = new RestrictionLevel[]{ASCII, SINGLE_SCRIPT_RESTRICTIVE, HIGHLY_RESTRICTIVE, MODERATELY_RESTRICTIVE, MINIMALLY_RESTRICTIVE, UNRESTRICTIVE};
        }

        public static RestrictionLevel[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_SpoofChecker_RestrictionLevel$values(), 0);
        }

        public static RestrictionLevel valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_SpoofChecker_RestrictionLevel$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_SpoofChecker_RestrictionLevel$__constructor__(string2, n);
        }

        private RestrictionLevel() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_SpoofChecker_RestrictionLevel$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(RestrictionLevel.class);
        }

        public /* synthetic */ RestrictionLevel() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RestrictionLevel)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

