/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.UCaseProps;
import android.icu.text.Replaceable;
import android.icu.text.UTF16;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ReplaceableContextIterator
implements UCaseProps.ContextIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected Replaceable rep;
    protected int index;
    protected int limit;
    protected int cpStart;
    protected int cpLimit;
    protected int contextStart;
    protected int contextLimit;
    protected int dir;
    protected boolean reachedLimit;

    private void $$robo$$android_icu_text_ReplaceableContextIterator$__constructor__() {
        this.rep = null;
        this.contextLimit = 0;
        this.contextStart = 0;
        this.index = 0;
        this.cpLimit = 0;
        this.cpStart = 0;
        this.limit = 0;
        this.dir = 0;
        this.reachedLimit = false;
    }

    private final void $$robo$$android_icu_text_ReplaceableContextIterator$setText(Replaceable rep) {
        this.rep = rep;
        this.limit = this.contextLimit = rep.length();
        this.contextStart = 0;
        this.index = 0;
        this.cpLimit = 0;
        this.cpStart = 0;
        this.dir = 0;
        this.reachedLimit = false;
    }

    private final void $$robo$$android_icu_text_ReplaceableContextIterator$setIndex(int index) {
        this.cpStart = this.cpLimit = index;
        this.index = 0;
        this.dir = 0;
        this.reachedLimit = false;
    }

    private final int $$robo$$android_icu_text_ReplaceableContextIterator$getCaseMapCPStart() {
        return this.cpStart;
    }

    private final void $$robo$$android_icu_text_ReplaceableContextIterator$setLimit(int lim) {
        this.limit = 0 <= lim && lim <= this.rep.length() ? lim : this.rep.length();
        this.reachedLimit = false;
    }

    private final void $$robo$$android_icu_text_ReplaceableContextIterator$setContextLimits(int contextStart, int contextLimit) {
        this.contextStart = contextStart < 0 ? 0 : (contextStart <= this.rep.length() ? contextStart : this.rep.length());
        this.contextLimit = contextLimit < this.contextStart ? this.contextStart : (contextLimit <= this.rep.length() ? contextLimit : this.rep.length());
        this.reachedLimit = false;
    }

    private final int $$robo$$android_icu_text_ReplaceableContextIterator$nextCaseMapCP() {
        if (this.cpLimit < this.limit) {
            this.cpStart = this.cpLimit;
            int c = this.rep.char32At(this.cpLimit);
            this.cpLimit += UTF16.getCharCount(c);
            return c;
        }
        return -1;
    }

    private final int $$robo$$android_icu_text_ReplaceableContextIterator$replace(String text) {
        int delta = text.length() - (this.cpLimit - this.cpStart);
        this.rep.replace(this.cpStart, this.cpLimit, text);
        this.cpLimit += delta;
        this.limit += delta;
        this.contextLimit += delta;
        return delta;
    }

    private final boolean $$robo$$android_icu_text_ReplaceableContextIterator$didReachLimit() {
        return this.reachedLimit;
    }

    private final void $$robo$$android_icu_text_ReplaceableContextIterator$reset(int direction) {
        if (direction > 0) {
            this.dir = 1;
            this.index = this.cpLimit;
        } else if (direction < 0) {
            this.dir = -1;
            this.index = this.cpStart;
        } else {
            this.dir = 0;
            this.index = 0;
        }
        this.reachedLimit = false;
    }

    private final int $$robo$$android_icu_text_ReplaceableContextIterator$next() {
        if (this.dir > 0) {
            if (this.index < this.contextLimit) {
                int c = this.rep.char32At(this.index);
                this.index += UTF16.getCharCount(c);
                return c;
            }
            this.reachedLimit = true;
        } else if (this.dir < 0 && this.index > this.contextStart) {
            int c = this.rep.char32At(this.index - 1);
            this.index -= UTF16.getCharCount(c);
            return c;
        }
        return -1;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_ReplaceableContextIterator$__constructor__();
    }

    ReplaceableContextIterator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_ReplaceableContextIterator$__constructor__(), 0, this);
    }

    public void setText(Replaceable replaceable) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_ReplaceableContextIterator$setText(android.icu.text.Replaceable ), 0, this, replaceable);
    }

    public void setIndex(int n) {
        InvokeDynamicSupport.bootstrap("setIndex", $$robo$$android_icu_text_ReplaceableContextIterator$setIndex(int ), 0, this, n);
    }

    public int getCaseMapCPStart() {
        return (int)InvokeDynamicSupport.bootstrap("getCaseMapCPStart", $$robo$$android_icu_text_ReplaceableContextIterator$getCaseMapCPStart(), 0, this);
    }

    public void setLimit(int n) {
        InvokeDynamicSupport.bootstrap("setLimit", $$robo$$android_icu_text_ReplaceableContextIterator$setLimit(int ), 0, this, n);
    }

    public void setContextLimits(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setContextLimits", $$robo$$android_icu_text_ReplaceableContextIterator$setContextLimits(int int ), 0, this, n, n2);
    }

    public int nextCaseMapCP() {
        return (int)InvokeDynamicSupport.bootstrap("nextCaseMapCP", $$robo$$android_icu_text_ReplaceableContextIterator$nextCaseMapCP(), 0, this);
    }

    public int replace(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("replace", $$robo$$android_icu_text_ReplaceableContextIterator$replace(java.lang.String ), 0, this, string2);
    }

    public boolean didReachLimit() {
        return (boolean)InvokeDynamicSupport.bootstrap("didReachLimit", $$robo$$android_icu_text_ReplaceableContextIterator$didReachLimit(), 0, this);
    }

    @Override
    public void reset(int n) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_ReplaceableContextIterator$reset(int ), 0, this, n);
    }

    @Override
    public int next() {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_ReplaceableContextIterator$next(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReplaceableContextIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

