/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CalendarData;
import android.icu.impl.DontCareFieldPosition;
import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.SimplePatternFormatter;
import android.icu.impl.StandardPlural;
import android.icu.impl.UResource;
import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.icu.text.DateFormatSymbols;
import android.icu.text.DisplayContext;
import android.icu.text.MessageFormat;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.text.QuantityFormatter;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.text.FieldPosition;
import java.util.EnumMap;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class RelativeDateTimeFormatter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int[] styleToDateFormatSymbolsWidth;
    private EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap;
    private EnumMap<Style, EnumMap<RelativeUnit, String[][]>> patternMap;
    private MessageFormat combinedDateAndTime;
    private PluralRules pluralRules;
    private NumberFormat numberFormat;
    private Style style;
    private DisplayContext capitalizationContext;
    private BreakIterator breakIterator;
    private ULocale locale;
    private DateFormatSymbols dateFormatSymbols;
    private static Style[] fallbackCache;
    private static Cache cache;

    private static final RelativeDateTimeFormatter $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance() {
        return RelativeDateTimeFormatter.getInstance(ULocale.getDefault(), null, Style.LONG, DisplayContext.CAPITALIZATION_NONE);
    }

    private static final RelativeDateTimeFormatter $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(ULocale locale) {
        return RelativeDateTimeFormatter.getInstance(locale, null, Style.LONG, DisplayContext.CAPITALIZATION_NONE);
    }

    private static final RelativeDateTimeFormatter $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(Locale locale) {
        return RelativeDateTimeFormatter.getInstance(ULocale.forLocale(locale));
    }

    private static final RelativeDateTimeFormatter $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(ULocale locale, NumberFormat nf) {
        return RelativeDateTimeFormatter.getInstance(locale, nf, Style.LONG, DisplayContext.CAPITALIZATION_NONE);
    }

    private static final RelativeDateTimeFormatter $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(ULocale locale, NumberFormat nf, Style style2, DisplayContext capitalizationContext) {
        RelativeDateTimeFormatterData data = cache.get(locale);
        nf = nf == null ? NumberFormat.getInstance(locale) : (NumberFormat)nf.clone();
        return new RelativeDateTimeFormatter(data.qualitativeUnitMap, data.relUnitPatternMap, new MessageFormat(data.dateTimePattern), PluralRules.forLocale(locale), nf, style2, capitalizationContext, capitalizationContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE ? BreakIterator.getSentenceInstance(locale) : null, locale);
    }

    private static final RelativeDateTimeFormatter $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(Locale locale, NumberFormat nf) {
        return RelativeDateTimeFormatter.getInstance(ULocale.forLocale(locale), nf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$format(double quantity, Direction direction, RelativeUnit unit) {
        String result;
        if (direction != Direction.LAST && direction != Direction.NEXT) {
            throw new IllegalArgumentException("direction must be NEXT or LAST");
        }
        int pastFutureIndex = direction == Direction.NEXT ? 1 : 0;
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            StringBuffer formatStr = new StringBuffer();
            DontCareFieldPosition fieldPosition = DontCareFieldPosition.INSTANCE;
            StandardPlural pluralForm = QuantityFormatter.selectPlural(quantity, this.numberFormat, this.pluralRules, formatStr, fieldPosition);
            String formatter = this.getRelativeUnitPluralPattern(this.style, unit, pastFutureIndex, pluralForm);
            result = SimplePatternFormatter.formatCompiledPattern(formatter, formatStr);
        }
        return this.adjustForContext(result);
    }

    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$format(Direction direction, AbsoluteUnit unit) {
        String result;
        if (unit == AbsoluteUnit.NOW && direction != Direction.PLAIN) {
            throw new IllegalArgumentException("NOW can only accept direction PLAIN.");
        }
        if (direction == Direction.PLAIN && AbsoluteUnit.SUNDAY.ordinal() <= unit.ordinal() && unit.ordinal() <= AbsoluteUnit.SATURDAY.ordinal()) {
            int dateSymbolsDayOrdinal = unit.ordinal() - AbsoluteUnit.SUNDAY.ordinal() + 1;
            String[] dayNames = this.dateFormatSymbols.getWeekdays(1, this.styleToDateFormatSymbolsWidth[this.style.ordinal()]);
            result = dayNames[dateSymbolsDayOrdinal];
        } else {
            result = this.getAbsoluteUnitString(this.style, unit, direction);
        }
        return result != null ? this.adjustForContext(result) : null;
    }

    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$getAbsoluteUnitString(Style style2, AbsoluteUnit unit, Direction direction) {
        do {
            String result;
            EnumMap<Direction, String> dirMap;
            EnumMap<AbsoluteUnit, EnumMap<Direction, String>> unitMap;
            if ((unitMap = this.qualitativeUnitMap.get((Object)style2)) == null || (dirMap = unitMap.get((Object)unit)) == null || (result = dirMap.get((Object)direction)) == null) continue;
            return result;
        } while ((style2 = fallbackCache[style2.ordinal()]) != null);
        return null;
    }

    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$combineDateAndTime(String relativeDateString, String timeString) {
        return this.combinedDateAndTime.format(new Object[]{timeString, relativeDateString}, new StringBuffer(), (FieldPosition)null).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NumberFormat $$robo$$android_icu_text_RelativeDateTimeFormatter$getNumberFormat() {
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return (NumberFormat)this.numberFormat.clone();
        }
    }

    private final DisplayContext $$robo$$android_icu_text_RelativeDateTimeFormatter$getCapitalizationContext() {
        return this.capitalizationContext;
    }

    private final Style $$robo$$android_icu_text_RelativeDateTimeFormatter$getFormatStyle() {
        return this.style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$adjustForContext(String originalFormattedString) {
        if (this.breakIterator == null || originalFormattedString.length() == 0 || !UCharacter.isLowerCase(UCharacter.codePointAt(originalFormattedString, 0))) {
            return originalFormattedString;
        }
        BreakIterator breakIterator = this.breakIterator;
        synchronized (breakIterator) {
            return UCharacter.toTitleCase(this.locale, originalFormattedString, this.breakIterator, 768);
        }
    }

    private void $$robo$$android_icu_text_RelativeDateTimeFormatter$__constructor__(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap, EnumMap<Style, EnumMap<RelativeUnit, String[][]>> patternMap, MessageFormat combinedDateAndTime, PluralRules pluralRules, NumberFormat numberFormat, Style style2, DisplayContext capitalizationContext, BreakIterator breakIterator, ULocale locale) {
        this.styleToDateFormatSymbolsWidth = new int[]{1, 3, 2};
        this.qualitativeUnitMap = qualitativeUnitMap;
        this.patternMap = patternMap;
        this.combinedDateAndTime = combinedDateAndTime;
        this.pluralRules = pluralRules;
        this.numberFormat = numberFormat;
        this.style = style2;
        if (capitalizationContext.type() != DisplayContext.Type.CAPITALIZATION) {
            throw new IllegalArgumentException(capitalizationContext.toString());
        }
        this.capitalizationContext = capitalizationContext;
        this.breakIterator = breakIterator;
        this.locale = locale;
        this.dateFormatSymbols = new DateFormatSymbols(locale);
    }

    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$getRelativeUnitPluralPattern(Style style2, RelativeUnit unit, int pastFutureIndex, StandardPlural pluralForm) {
        String formatter;
        if (pluralForm != StandardPlural.OTHER && (formatter = this.getRelativeUnitPattern(style2, unit, pastFutureIndex, pluralForm)) != null) {
            return formatter;
        }
        return this.getRelativeUnitPattern(style2, unit, pastFutureIndex, StandardPlural.OTHER);
    }

    private final String $$robo$$android_icu_text_RelativeDateTimeFormatter$getRelativeUnitPattern(Style style2, RelativeUnit unit, int pastFutureIndex, StandardPlural pluralForm) {
        int pluralIndex = pluralForm.ordinal();
        do {
            String[][] spfCompiledPatterns;
            EnumMap<RelativeUnit, String[][]> unitMap;
            if ((unitMap = this.patternMap.get((Object)style2)) == null || (spfCompiledPatterns = unitMap.get((Object)unit)) == null || spfCompiledPatterns[pastFutureIndex][pluralIndex] == null) continue;
            return spfCompiledPatterns[pastFutureIndex][pluralIndex];
        } while ((style2 = fallbackCache[style2.ordinal()]) != null);
        return null;
    }

    private static final Direction $$robo$$android_icu_text_RelativeDateTimeFormatter$keyToDirection(UResource.Key key) {
        if (key.contentEquals("-2")) {
            return Direction.LAST_2;
        }
        if (key.contentEquals("-1")) {
            return Direction.LAST;
        }
        if (key.contentEquals("0")) {
            return Direction.THIS;
        }
        if (key.contentEquals("1")) {
            return Direction.NEXT;
        }
        if (key.contentEquals("2")) {
            return Direction.NEXT_2;
        }
        return null;
    }

    static void __staticInitializer__() {
        fallbackCache = new Style[3];
        cache = new Cache();
    }

    public static RelativeDateTimeFormatter getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(), 0);
    }

    public static RelativeDateTimeFormatter getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static RelativeDateTimeFormatter getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static RelativeDateTimeFormatter getInstance(ULocale uLocale, NumberFormat numberFormat) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(android.icu.util.ULocale android.icu.text.NumberFormat ), 0, (ULocale)uLocale, (NumberFormat)numberFormat);
    }

    public static RelativeDateTimeFormatter getInstance(ULocale uLocale, NumberFormat numberFormat, Style style2, DisplayContext displayContext) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(android.icu.util.ULocale android.icu.text.NumberFormat android.icu.text.RelativeDateTimeFormatter$Style android.icu.text.DisplayContext ), 0, (ULocale)uLocale, (NumberFormat)numberFormat, (Style)style2, (DisplayContext)displayContext);
    }

    public static RelativeDateTimeFormatter getInstance(Locale locale, NumberFormat numberFormat) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_RelativeDateTimeFormatter$getInstance(java.util.Locale android.icu.text.NumberFormat ), 0, (Locale)locale, (NumberFormat)numberFormat);
    }

    public String format(double d, Direction direction, RelativeUnit relativeUnit) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RelativeDateTimeFormatter$format(double android.icu.text.RelativeDateTimeFormatter$Direction android.icu.text.RelativeDateTimeFormatter$RelativeUnit ), 0, this, d, direction, relativeUnit);
    }

    public String format(Direction direction, AbsoluteUnit absoluteUnit) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_RelativeDateTimeFormatter$format(android.icu.text.RelativeDateTimeFormatter$Direction android.icu.text.RelativeDateTimeFormatter$AbsoluteUnit ), 0, this, direction, absoluteUnit);
    }

    private String getAbsoluteUnitString(Style style2, AbsoluteUnit absoluteUnit, Direction direction) {
        return InvokeDynamicSupport.bootstrap("getAbsoluteUnitString", $$robo$$android_icu_text_RelativeDateTimeFormatter$getAbsoluteUnitString(android.icu.text.RelativeDateTimeFormatter$Style android.icu.text.RelativeDateTimeFormatter$AbsoluteUnit android.icu.text.RelativeDateTimeFormatter$Direction ), 0, this, style2, absoluteUnit, direction);
    }

    public String combineDateAndTime(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("combineDateAndTime", $$robo$$android_icu_text_RelativeDateTimeFormatter$combineDateAndTime(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public NumberFormat getNumberFormat() {
        return InvokeDynamicSupport.bootstrap("getNumberFormat", $$robo$$android_icu_text_RelativeDateTimeFormatter$getNumberFormat(), 0, this);
    }

    public DisplayContext getCapitalizationContext() {
        return InvokeDynamicSupport.bootstrap("getCapitalizationContext", $$robo$$android_icu_text_RelativeDateTimeFormatter$getCapitalizationContext(), 0, this);
    }

    public Style getFormatStyle() {
        return InvokeDynamicSupport.bootstrap("getFormatStyle", $$robo$$android_icu_text_RelativeDateTimeFormatter$getFormatStyle(), 0, this);
    }

    private String adjustForContext(String string2) {
        return InvokeDynamicSupport.bootstrap("adjustForContext", $$robo$$android_icu_text_RelativeDateTimeFormatter$adjustForContext(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> enumMap, EnumMap<Style, EnumMap<RelativeUnit, String[][]>> enumMap2, MessageFormat messageFormat, PluralRules pluralRules, NumberFormat numberFormat, Style style2, DisplayContext displayContext, BreakIterator breakIterator, ULocale uLocale) {
        this.$$robo$$android_icu_text_RelativeDateTimeFormatter$__constructor__(enumMap, enumMap2, messageFormat, pluralRules, numberFormat, style2, displayContext, breakIterator, uLocale);
    }

    private RelativeDateTimeFormatter(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> enumMap, EnumMap<Style, EnumMap<RelativeUnit, String[][]>> enumMap2, MessageFormat messageFormat, PluralRules pluralRules, NumberFormat numberFormat, Style style2, DisplayContext displayContext, BreakIterator breakIterator, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter$__constructor__(java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$Style, java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$AbsoluteUnit, java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$Direction, java.lang.String>>> java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$Style, java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$RelativeUnit, java.lang.String[][]>> android.icu.text.MessageFormat android.icu.text.PluralRules android.icu.text.NumberFormat android.icu.text.RelativeDateTimeFormatter$Style android.icu.text.DisplayContext android.icu.text.BreakIterator android.icu.util.ULocale ), 0, this, enumMap, enumMap2, messageFormat, pluralRules, numberFormat, style2, displayContext, breakIterator, uLocale);
    }

    private String getRelativeUnitPluralPattern(Style style2, RelativeUnit relativeUnit, int n, StandardPlural standardPlural) {
        return InvokeDynamicSupport.bootstrap("getRelativeUnitPluralPattern", $$robo$$android_icu_text_RelativeDateTimeFormatter$getRelativeUnitPluralPattern(android.icu.text.RelativeDateTimeFormatter$Style android.icu.text.RelativeDateTimeFormatter$RelativeUnit int android.icu.impl.StandardPlural ), 0, this, style2, relativeUnit, n, standardPlural);
    }

    private String getRelativeUnitPattern(Style style2, RelativeUnit relativeUnit, int n, StandardPlural standardPlural) {
        return InvokeDynamicSupport.bootstrap("getRelativeUnitPattern", $$robo$$android_icu_text_RelativeDateTimeFormatter$getRelativeUnitPattern(android.icu.text.RelativeDateTimeFormatter$Style android.icu.text.RelativeDateTimeFormatter$RelativeUnit int android.icu.impl.StandardPlural ), 0, this, style2, relativeUnit, n, standardPlural);
    }

    private static Direction keyToDirection(UResource.Key key) {
        return InvokeDynamicSupport.bootstrapStatic("keyToDirection", $$robo$$android_icu_text_RelativeDateTimeFormatter$keyToDirection(android.icu.impl.UResource$Key ), 0, (UResource.Key)key);
    }

    static {
        RobolectricInternals.classInitializing(RelativeDateTimeFormatter.class);
    }

    public /* synthetic */ RelativeDateTimeFormatter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeDateTimeFormatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Loader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ULocale ulocale;

        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_Loader$__constructor__(ULocale ulocale) {
            this.ulocale = ulocale;
        }

        private final RelativeDateTimeFormatterData $$robo$$android_icu_text_RelativeDateTimeFormatter_Loader$load() {
            RelDateTimeFmtDataSink sink = new RelDateTimeFmtDataSink(this.ulocale);
            ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", this.ulocale);
            r.getAllTableItemsWithFallback("fields", sink);
            for (Style testStyle : Style.values()) {
                Style newStyle2;
                Style newStyle1 = fallbackCache[testStyle.ordinal()];
                if (newStyle1 == null || (newStyle2 = fallbackCache[newStyle1.ordinal()]) == null || fallbackCache[newStyle2.ordinal()] == null) continue;
                throw new IllegalStateException("Style fallback too deep");
            }
            CalendarData calData = new CalendarData(this.ulocale, r.getStringWithFallback("calendar/default"));
            return new RelativeDateTimeFormatterData(sink.qualitativeUnitMap, sink.styleRelUnitPatterns, calData.getDateTimePattern());
        }

        private void __constructor__(ULocale uLocale) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_Loader$__constructor__(uLocale);
        }

        public Loader(ULocale uLocale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_Loader$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
        }

        public RelativeDateTimeFormatterData load() {
            return InvokeDynamicSupport.bootstrap("load", $$robo$$android_icu_text_RelativeDateTimeFormatter_Loader$load(), 0, this);
        }

        public /* synthetic */ Loader() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Loader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class RelDateTimeFmtDataSink
    extends UResource.TableSink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap;
        EnumMap<Style, EnumMap<RelativeUnit, String[][]>> styleRelUnitPatterns;
        private ULocale ulocale;
        StringBuilder sb;
        int pastFutureIndex;
        Style style;
        DateTimeUnit unit;
        RelativeTimeDetailSink relativeTimeDetailSink;
        RelativeTimeSink relativeTimeSink;
        RelativeSink relativeSink;
        UnitSink unitSink;

        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$__constructor__(ULocale locale) {
            this.qualitativeUnitMap = new EnumMap(Style.class);
            this.styleRelUnitPatterns = new EnumMap(Style.class);
            this.ulocale = null;
            this.sb = new StringBuilder();
            this.relativeTimeDetailSink = new RelativeTimeDetailSink(this);
            this.relativeTimeSink = new RelativeTimeSink(this);
            this.relativeSink = new RelativeSink(this);
            this.unitSink = new UnitSink(this);
            this.ulocale = locale;
        }

        private final Style $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$styleFromKey(UResource.Key key) {
            if (key.endsWith("-short")) {
                return Style.SHORT;
            }
            if (key.endsWith("-narrow")) {
                return Style.NARROW;
            }
            return Style.LONG;
        }

        private final Style $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$styleFromAlias(UResource.Value value) {
            String s = value.getAliasString();
            if (s.endsWith("-short")) {
                return Style.SHORT;
            }
            if (s.endsWith("-narrow")) {
                return Style.NARROW;
            }
            return Style.LONG;
        }

        private static final int $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$styleSuffixLength(Style style2) {
            switch (1.$SwitchMap$android$icu$text$RelativeDateTimeFormatter$Style[style2.ordinal()]) {
                case 1: {
                    return 6;
                }
                case 2: {
                    return 7;
                }
            }
            return 0;
        }

        private final void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$put(UResource.Key key, UResource.Value value) {
            if (value.getType() != 3) {
                return;
            }
            Style sourceStyle = this.styleFromKey(key);
            int limit = key.length() - RelDateTimeFmtDataSink.styleSuffixLength(sourceStyle);
            DateTimeUnit unit = DateTimeUnit.orNullFromString(key.substring(0, limit));
            if (unit != null) {
                Style targetStyle = this.styleFromAlias(value);
                if (sourceStyle == targetStyle) {
                    throw new ICUException("Invalid style fallback from " + (Object)((Object)sourceStyle) + " to itself");
                }
                if (fallbackCache[sourceStyle.ordinal()] == null) {
                    fallbackCache[sourceStyle.ordinal()] = targetStyle;
                } else if (fallbackCache[sourceStyle.ordinal()] != targetStyle) {
                    throw new ICUException("Inconsistent style fallback for style " + (Object)((Object)sourceStyle) + " to " + (Object)((Object)targetStyle));
                }
            }
        }

        private final UResource.TableSink $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$getOrCreateTableSink(UResource.Key key, int initialSize) {
            this.style = this.styleFromKey(key);
            int limit = key.length() - RelDateTimeFmtDataSink.styleSuffixLength(this.style);
            String unitString = key.substring(0, limit);
            this.unit = DateTimeUnit.orNullFromString(unitString);
            if (this.unit == null) {
                return null;
            }
            return this.unitSink;
        }

        private void __constructor__(ULocale uLocale) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$__constructor__(uLocale);
        }

        public RelDateTimeFmtDataSink(ULocale uLocale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
        }

        private Style styleFromKey(UResource.Key key) {
            return InvokeDynamicSupport.bootstrap("styleFromKey", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$styleFromKey(android.icu.impl.UResource$Key ), 0, this, key);
        }

        private Style styleFromAlias(UResource.Value value) {
            return InvokeDynamicSupport.bootstrap("styleFromAlias", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$styleFromAlias(android.icu.impl.UResource$Value ), 0, this, value);
        }

        private static int styleSuffixLength(Style style2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("styleSuffixLength", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$styleSuffixLength(android.icu.text.RelativeDateTimeFormatter$Style ), 0, (Style)style2);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
        }

        @Override
        public UResource.TableSink getOrCreateTableSink(UResource.Key key, int n) {
            return InvokeDynamicSupport.bootstrap("getOrCreateTableSink", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink$getOrCreateTableSink(android.icu.impl.UResource$Key int ), 0, this, key, n);
        }

        public /* synthetic */ RelDateTimeFmtDataSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelDateTimeFmtDataSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class UnitSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RelDateTimeFmtDataSink this$0;

            private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$__constructor__(RelDateTimeFmtDataSink this$0) {
            }

            private final void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$put(UResource.Key key, UResource.Value value) {
                if (key.contentEquals("dn")) {
                    EnumMap<Direction, String> dirMap;
                    AbsoluteUnit absUnit = this.this$0.unit.absUnit;
                    if (absUnit == null) {
                        return;
                    }
                    EnumMap<AbsoluteUnit, EnumMap<Direction, String>> unitMap = this.this$0.qualitativeUnitMap.get((Object)this.this$0.style);
                    if (unitMap == null) {
                        unitMap = new EnumMap(AbsoluteUnit.class);
                        this.this$0.qualitativeUnitMap.put(this.this$0.style, unitMap);
                    }
                    if ((dirMap = unitMap.get((Object)absUnit)) == null) {
                        dirMap = new EnumMap(Direction.class);
                        unitMap.put(absUnit, dirMap);
                    }
                    if (dirMap.get((Object)Direction.PLAIN) == null) {
                        String displayName = value.toString();
                        if (this.this$0.ulocale.getLanguage().equals("en")) {
                            displayName = displayName.toLowerCase(Locale.ROOT);
                        }
                        dirMap.put(Direction.PLAIN, displayName);
                    }
                }
            }

            private final UResource.TableSink $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$getOrCreateTableSink(UResource.Key key, int initialSize) {
                if (key.contentEquals("relative")) {
                    return this.this$0.relativeSink;
                }
                if (key.contentEquals("relativeTime")) {
                    return this.this$0.relativeTimeSink;
                }
                return null;
            }

            private void __constructor__(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$__constructor__(relDateTimeFmtDataSink);
            }

            UnitSink(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.this$0 = relDateTimeFmtDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$__constructor__(android.icu.text.RelativeDateTimeFormatter$RelDateTimeFmtDataSink ), 0, this, relDateTimeFmtDataSink);
            }

            @Override
            public void put(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
            }

            @Override
            public UResource.TableSink getOrCreateTableSink(UResource.Key key, int n) {
                return InvokeDynamicSupport.bootstrap("getOrCreateTableSink", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_UnitSink$getOrCreateTableSink(android.icu.impl.UResource$Key int ), 0, this, key, n);
            }

            public /* synthetic */ UnitSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnitSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class RelativeSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RelDateTimeFmtDataSink this$0;

            private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeSink$__constructor__(RelDateTimeFmtDataSink this$0) {
            }

            private final void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeSink$put(UResource.Key key, UResource.Value value) {
                EnumMap<Direction, String> dirMap;
                EnumMap<AbsoluteUnit, EnumMap<Direction, String>> absMap = this.this$0.qualitativeUnitMap.get((Object)this.this$0.style);
                if (this.this$0.unit.relUnit == RelativeUnit.SECONDS && key.contentEquals("0")) {
                    EnumMap<Direction, String> unitStrings = absMap.get((Object)AbsoluteUnit.NOW);
                    if (unitStrings == null) {
                        unitStrings = new EnumMap(Direction.class);
                        absMap.put(AbsoluteUnit.NOW, unitStrings);
                    }
                    if (unitStrings.get((Object)Direction.PLAIN) == null) {
                        unitStrings.put(Direction.PLAIN, value.getString());
                    }
                    return;
                }
                Direction keyDirection = RelativeDateTimeFormatter.keyToDirection(key);
                if (keyDirection == null) {
                    return;
                }
                AbsoluteUnit absUnit = this.this$0.unit.absUnit;
                if (absUnit == null) {
                    return;
                }
                if (absMap == null) {
                    absMap = new EnumMap(AbsoluteUnit.class);
                    this.this$0.qualitativeUnitMap.put(this.this$0.style, absMap);
                }
                if ((dirMap = absMap.get((Object)absUnit)) == null) {
                    dirMap = new EnumMap(Direction.class);
                    absMap.put(absUnit, dirMap);
                }
                if (dirMap.get((Object)keyDirection) == null) {
                    dirMap.put(keyDirection, value.getString());
                }
            }

            private void __constructor__(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeSink$__constructor__(relDateTimeFmtDataSink);
            }

            RelativeSink(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.this$0 = relDateTimeFmtDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeSink$__constructor__(android.icu.text.RelativeDateTimeFormatter$RelDateTimeFmtDataSink ), 0, this, relDateTimeFmtDataSink);
            }

            @Override
            public void put(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
            }

            public /* synthetic */ RelativeSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class RelativeTimeSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RelDateTimeFmtDataSink this$0;

            private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeSink$__constructor__(RelDateTimeFmtDataSink this$0) {
            }

            private final UResource.TableSink $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeSink$getOrCreateTableSink(UResource.Key key, int initialSize) {
                if (key.contentEquals("past")) {
                    this.this$0.pastFutureIndex = 0;
                } else if (key.contentEquals("future")) {
                    this.this$0.pastFutureIndex = 1;
                } else {
                    return null;
                }
                if (this.this$0.unit.relUnit == null) {
                    return null;
                }
                return this.this$0.relativeTimeDetailSink;
            }

            private void __constructor__(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeSink$__constructor__(relDateTimeFmtDataSink);
            }

            RelativeTimeSink(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.this$0 = relDateTimeFmtDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeSink$__constructor__(android.icu.text.RelativeDateTimeFormatter$RelDateTimeFmtDataSink ), 0, this, relDateTimeFmtDataSink);
            }

            @Override
            public UResource.TableSink getOrCreateTableSink(UResource.Key key, int n) {
                return InvokeDynamicSupport.bootstrap("getOrCreateTableSink", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeSink$getOrCreateTableSink(android.icu.impl.UResource$Key int ), 0, this, key, n);
            }

            public /* synthetic */ RelativeTimeSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeTimeSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class RelativeTimeDetailSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RelDateTimeFmtDataSink this$0;

            private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeDetailSink$__constructor__(RelDateTimeFmtDataSink this$0) {
            }

            private final void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeDetailSink$put(UResource.Key key, UResource.Value value) {
                int pluralIndex;
                String[][] patterns;
                EnumMap<RelativeUnit, Object> unitPatterns = this.this$0.styleRelUnitPatterns.get((Object)this.this$0.style);
                if (unitPatterns == null) {
                    unitPatterns = new EnumMap(RelativeUnit.class);
                    this.this$0.styleRelUnitPatterns.put(this.this$0.style, unitPatterns);
                }
                if ((patterns = unitPatterns.get((Object)this.this$0.unit.relUnit)) == null) {
                    patterns = new String[2][StandardPlural.COUNT];
                    unitPatterns.put(this.this$0.unit.relUnit, (String[][])patterns);
                }
                if (patterns[this.this$0.pastFutureIndex][pluralIndex = StandardPlural.indexFromString(key.toString())] == null) {
                    patterns[this.this$0.pastFutureIndex][pluralIndex] = SimplePatternFormatter.compileToStringMinMaxPlaceholders(value.getString(), this.this$0.sb, 0, 1);
                }
            }

            private void __constructor__(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeDetailSink$__constructor__(relDateTimeFmtDataSink);
            }

            RelativeTimeDetailSink(RelDateTimeFmtDataSink relDateTimeFmtDataSink) {
                this.this$0 = relDateTimeFmtDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeDetailSink$__constructor__(android.icu.text.RelativeDateTimeFormatter$RelDateTimeFmtDataSink ), 0, this, relDateTimeFmtDataSink);
            }

            @Override
            public void put(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_RelativeTimeDetailSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
            }

            public /* synthetic */ RelativeTimeDetailSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeTimeDetailSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class DateTimeUnit
        extends Enum<DateTimeUnit> {
            public transient /* synthetic */ Object __robo_data__;
            public static /* enum */ DateTimeUnit SECOND;
            public static /* enum */ DateTimeUnit MINUTE;
            public static /* enum */ DateTimeUnit HOUR;
            public static /* enum */ DateTimeUnit DAY;
            public static /* enum */ DateTimeUnit WEEK;
            public static /* enum */ DateTimeUnit MONTH;
            public static /* enum */ DateTimeUnit QUARTER;
            public static /* enum */ DateTimeUnit YEAR;
            public static /* enum */ DateTimeUnit SUNDAY;
            public static /* enum */ DateTimeUnit MONDAY;
            public static /* enum */ DateTimeUnit TUESDAY;
            public static /* enum */ DateTimeUnit WEDNESDAY;
            public static /* enum */ DateTimeUnit THURSDAY;
            public static /* enum */ DateTimeUnit FRIDAY;
            public static /* enum */ DateTimeUnit SATURDAY;
            RelativeUnit relUnit;
            AbsoluteUnit absUnit;
            private static /* synthetic */ DateTimeUnit[] $VALUES;

            private static final DateTimeUnit[] $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$values() {
                return (DateTimeUnit[])$VALUES.clone();
            }

            private static final DateTimeUnit $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$valueOf(String name) {
                return Enum.valueOf(DateTimeUnit.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$__constructor__(String string2, int n, RelativeUnit relUnit, AbsoluteUnit absUnit) {
                this.relUnit = relUnit;
                this.absUnit = absUnit;
            }

            private static final DateTimeUnit $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$orNullFromString(CharSequence keyword) {
                switch (keyword.length()) {
                    case 3: {
                        if ("day".contentEquals(keyword)) {
                            return DAY;
                        }
                        if ("sun".contentEquals(keyword)) {
                            return SUNDAY;
                        }
                        if ("mon".contentEquals(keyword)) {
                            return MONDAY;
                        }
                        if ("tue".contentEquals(keyword)) {
                            return TUESDAY;
                        }
                        if ("wed".contentEquals(keyword)) {
                            return WEDNESDAY;
                        }
                        if ("thu".contentEquals(keyword)) {
                            return THURSDAY;
                        }
                        if ("fri".contentEquals(keyword)) {
                            return FRIDAY;
                        }
                        if (!"sat".contentEquals(keyword)) break;
                        return SATURDAY;
                    }
                    case 4: {
                        if ("hour".contentEquals(keyword)) {
                            return HOUR;
                        }
                        if ("week".contentEquals(keyword)) {
                            return WEEK;
                        }
                        if (!"year".contentEquals(keyword)) break;
                        return YEAR;
                    }
                    case 5: {
                        if (!"month".contentEquals(keyword)) break;
                        return MONTH;
                    }
                    case 6: {
                        if ("minute".contentEquals(keyword)) {
                            return MINUTE;
                        }
                        if (!"second".contentEquals(keyword)) break;
                        return SECOND;
                    }
                    case 7: {
                        if (!"quarter".contentEquals(keyword)) break;
                        return QUARTER;
                    }
                }
                return null;
            }

            static void __staticInitializer__() {
                SECOND = new DateTimeUnit(RelativeUnit.SECONDS, null);
                MINUTE = new DateTimeUnit(RelativeUnit.MINUTES, null);
                HOUR = new DateTimeUnit(RelativeUnit.HOURS, null);
                DAY = new DateTimeUnit(RelativeUnit.DAYS, AbsoluteUnit.DAY);
                WEEK = new DateTimeUnit(RelativeUnit.WEEKS, AbsoluteUnit.WEEK);
                MONTH = new DateTimeUnit(RelativeUnit.MONTHS, AbsoluteUnit.MONTH);
                QUARTER = new DateTimeUnit(RelativeUnit.QUARTERS, AbsoluteUnit.QUARTER);
                YEAR = new DateTimeUnit(RelativeUnit.YEARS, AbsoluteUnit.YEAR);
                SUNDAY = new DateTimeUnit(null, AbsoluteUnit.SUNDAY);
                MONDAY = new DateTimeUnit(null, AbsoluteUnit.MONDAY);
                TUESDAY = new DateTimeUnit(null, AbsoluteUnit.TUESDAY);
                WEDNESDAY = new DateTimeUnit(null, AbsoluteUnit.WEDNESDAY);
                THURSDAY = new DateTimeUnit(null, AbsoluteUnit.THURSDAY);
                FRIDAY = new DateTimeUnit(null, AbsoluteUnit.FRIDAY);
                SATURDAY = new DateTimeUnit(null, AbsoluteUnit.SATURDAY);
                $VALUES = new DateTimeUnit[]{SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, YEAR, SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};
            }

            public static DateTimeUnit[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$values(), 0);
            }

            public static DateTimeUnit valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$valueOf(java.lang.String ), 0, (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n, RelativeUnit relativeUnit, AbsoluteUnit absoluteUnit) {
                this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$__constructor__(string2, n, relativeUnit, absoluteUnit);
            }

            private DateTimeUnit(RelativeUnit relativeUnit, AbsoluteUnit absoluteUnit) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$__constructor__(java.lang.String int android.icu.text.RelativeDateTimeFormatter$RelativeUnit android.icu.text.RelativeDateTimeFormatter$AbsoluteUnit ), 0, this, string2, n, relativeUnit, absoluteUnit);
            }

            private static DateTimeUnit orNullFromString(CharSequence charSequence) {
                return InvokeDynamicSupport.bootstrapStatic("orNullFromString", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelDateTimeFmtDataSink_DateTimeUnit$orNullFromString(java.lang.CharSequence ), 0, (CharSequence)charSequence);
            }

            static {
                RobolectricInternals.classInitializing(DateTimeUnit.class);
            }

            public /* synthetic */ DateTimeUnit() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateTimeUnit)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class Cache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ICUCache<String, RelativeDateTimeFormatterData> cache;

        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$__constructor__() {
            this.cache = new SimpleCache<String, RelativeDateTimeFormatterData>();
        }

        private final RelativeDateTimeFormatterData $$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$get(ULocale locale) {
            String key = locale.toString();
            RelativeDateTimeFormatterData result = this.cache.get(key);
            if (result == null) {
                result = new Loader(locale).load();
                this.cache.put(key, result);
            }
            return result;
        }

        private /* synthetic */ void $$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$__constructor__();
        }

        private Cache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$__constructor__(), 0, this);
        }

        public RelativeDateTimeFormatterData get(ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$get(android.icu.util.ULocale ), 0, this, uLocale);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_Cache$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RelativeDateTimeFormatterData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap;
        EnumMap<Style, EnumMap<RelativeUnit, String[][]>> relUnitPatternMap;
        public String dateTimePattern;

        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeDateTimeFormatterData$__constructor__(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> qualitativeUnitMap, EnumMap<Style, EnumMap<RelativeUnit, String[][]>> relUnitPatternMap, String dateTimePattern) {
            this.qualitativeUnitMap = qualitativeUnitMap;
            this.relUnitPatternMap = relUnitPatternMap;
            this.dateTimePattern = dateTimePattern;
        }

        private void __constructor__(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> enumMap, EnumMap<Style, EnumMap<RelativeUnit, String[][]>> enumMap2, String string2) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeDateTimeFormatterData$__constructor__(enumMap, enumMap2, string2);
        }

        public RelativeDateTimeFormatterData(EnumMap<Style, EnumMap<AbsoluteUnit, EnumMap<Direction, String>>> enumMap, EnumMap<Style, EnumMap<RelativeUnit, String[][]>> enumMap2, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeDateTimeFormatterData$__constructor__(java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$Style, java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$AbsoluteUnit, java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$Direction, java.lang.String>>> java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$Style, java.util.EnumMap<android.icu.text.RelativeDateTimeFormatter$RelativeUnit, java.lang.String[][]>> java.lang.String ), 0, this, enumMap, enumMap2, string2);
        }

        public /* synthetic */ RelativeDateTimeFormatterData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeDateTimeFormatterData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Direction
    extends Enum<Direction> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Direction LAST_2;
        public static /* enum */ Direction LAST;
        public static /* enum */ Direction THIS;
        public static /* enum */ Direction NEXT;
        public static /* enum */ Direction NEXT_2;
        public static /* enum */ Direction PLAIN;
        private static /* synthetic */ Direction[] $VALUES;

        private static final Direction[] $$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$values() {
            return (Direction[])$VALUES.clone();
        }

        private static final Direction $$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$valueOf(String name) {
            return Enum.valueOf(Direction.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            LAST_2 = new Direction();
            LAST = new Direction();
            THIS = new Direction();
            NEXT = new Direction();
            NEXT_2 = new Direction();
            PLAIN = new Direction();
            $VALUES = new Direction[]{LAST_2, LAST, THIS, NEXT, NEXT_2, PLAIN};
        }

        public static Direction[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$values(), 0);
        }

        public static Direction valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$__constructor__(string2, n);
        }

        private Direction() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_Direction$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Direction.class);
        }

        public /* synthetic */ Direction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Direction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class AbsoluteUnit
    extends Enum<AbsoluteUnit> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ AbsoluteUnit SUNDAY;
        public static /* enum */ AbsoluteUnit MONDAY;
        public static /* enum */ AbsoluteUnit TUESDAY;
        public static /* enum */ AbsoluteUnit WEDNESDAY;
        public static /* enum */ AbsoluteUnit THURSDAY;
        public static /* enum */ AbsoluteUnit FRIDAY;
        public static /* enum */ AbsoluteUnit SATURDAY;
        public static /* enum */ AbsoluteUnit DAY;
        public static /* enum */ AbsoluteUnit WEEK;
        public static /* enum */ AbsoluteUnit MONTH;
        public static /* enum */ AbsoluteUnit YEAR;
        public static /* enum */ AbsoluteUnit NOW;
        @Deprecated
        public static /* enum */ AbsoluteUnit QUARTER;
        private static /* synthetic */ AbsoluteUnit[] $VALUES;

        private static final AbsoluteUnit[] $$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$values() {
            return (AbsoluteUnit[])$VALUES.clone();
        }

        private static final AbsoluteUnit $$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$valueOf(String name) {
            return Enum.valueOf(AbsoluteUnit.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            SUNDAY = new AbsoluteUnit();
            MONDAY = new AbsoluteUnit();
            TUESDAY = new AbsoluteUnit();
            WEDNESDAY = new AbsoluteUnit();
            THURSDAY = new AbsoluteUnit();
            FRIDAY = new AbsoluteUnit();
            SATURDAY = new AbsoluteUnit();
            DAY = new AbsoluteUnit();
            WEEK = new AbsoluteUnit();
            MONTH = new AbsoluteUnit();
            YEAR = new AbsoluteUnit();
            NOW = new AbsoluteUnit();
            QUARTER = new AbsoluteUnit();
            $VALUES = new AbsoluteUnit[]{SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, DAY, WEEK, MONTH, YEAR, NOW, QUARTER};
        }

        public static AbsoluteUnit[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$values(), 0);
        }

        public static AbsoluteUnit valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$__constructor__(string2, n);
        }

        private AbsoluteUnit() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_AbsoluteUnit$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(AbsoluteUnit.class);
        }

        public /* synthetic */ AbsoluteUnit() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbsoluteUnit)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class RelativeUnit
    extends Enum<RelativeUnit> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ RelativeUnit SECONDS;
        public static /* enum */ RelativeUnit MINUTES;
        public static /* enum */ RelativeUnit HOURS;
        public static /* enum */ RelativeUnit DAYS;
        public static /* enum */ RelativeUnit WEEKS;
        public static /* enum */ RelativeUnit MONTHS;
        public static /* enum */ RelativeUnit YEARS;
        @Deprecated
        public static /* enum */ RelativeUnit QUARTERS;
        private static /* synthetic */ RelativeUnit[] $VALUES;

        private static final RelativeUnit[] $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$values() {
            return (RelativeUnit[])$VALUES.clone();
        }

        private static final RelativeUnit $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$valueOf(String name) {
            return Enum.valueOf(RelativeUnit.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            SECONDS = new RelativeUnit();
            MINUTES = new RelativeUnit();
            HOURS = new RelativeUnit();
            DAYS = new RelativeUnit();
            WEEKS = new RelativeUnit();
            MONTHS = new RelativeUnit();
            YEARS = new RelativeUnit();
            QUARTERS = new RelativeUnit();
            $VALUES = new RelativeUnit[]{SECONDS, MINUTES, HOURS, DAYS, WEEKS, MONTHS, YEARS, QUARTERS};
        }

        public static RelativeUnit[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$values(), 0);
        }

        public static RelativeUnit valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$__constructor__(string2, n);
        }

        private RelativeUnit() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_RelativeUnit$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(RelativeUnit.class);
        }

        public /* synthetic */ RelativeUnit() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeUnit)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Style
    extends Enum<Style> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Style LONG;
        public static /* enum */ Style SHORT;
        public static /* enum */ Style NARROW;
        private static int INDEX_COUNT = 3;
        private static /* synthetic */ Style[] $VALUES;

        private static final Style[] $$robo$$android_icu_text_RelativeDateTimeFormatter_Style$values() {
            return (Style[])$VALUES.clone();
        }

        private static final Style $$robo$$android_icu_text_RelativeDateTimeFormatter_Style$valueOf(String name) {
            return Enum.valueOf(Style.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_RelativeDateTimeFormatter_Style$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            LONG = new Style();
            SHORT = new Style();
            NARROW = new Style();
            $VALUES = new Style[]{LONG, SHORT, NARROW};
        }

        public static Style[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_RelativeDateTimeFormatter_Style$values(), 0);
        }

        public static Style valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_RelativeDateTimeFormatter_Style$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_RelativeDateTimeFormatter_Style$__constructor__(string2, n);
        }

        private Style() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RelativeDateTimeFormatter_Style$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Style.class);
        }

        public /* synthetic */ Style() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

