/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Utility;
import android.icu.text.DecimalFormat;
import android.icu.text.MessagePattern;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.text.RbnfLenientScanner;
import android.icu.text.UFormat;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PluralFormat
extends UFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 1L;
    private ULocale ulocale;
    private PluralRules pluralRules;
    private String pattern;
    private transient MessagePattern msgPattern;
    private Map<String, String> parsedValues;
    private NumberFormat numberFormat;
    private transient double offset;
    private transient PluralSelectorAdapter pluralRulesWrapper;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_PluralFormat$__constructor__() {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, PluralRules.PluralType.CARDINAL, ulocale, null);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(Locale locale) {
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(PluralRules rules) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(rules, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale, PluralRules rules) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(rules, PluralRules.PluralType.CARDINAL, ulocale, null);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(Locale locale, PluralRules rules) {
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale, PluralRules.PluralType type) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, type, ulocale, null);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(Locale locale, PluralRules.PluralType type) {
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(String pattern) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
        this.applyPattern(pattern);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale, String pattern) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, PluralRules.PluralType.CARDINAL, ulocale, null);
        this.applyPattern(pattern);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(PluralRules rules, String pattern) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(rules, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
        this.applyPattern(pattern);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale, PluralRules rules, String pattern) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(rules, PluralRules.PluralType.CARDINAL, ulocale, null);
        this.applyPattern(pattern);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale, PluralRules.PluralType type, String pattern) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, type, ulocale, null);
        this.applyPattern(pattern);
    }

    private void $$robo$$android_icu_text_PluralFormat$__constructor__(ULocale ulocale, PluralRules.PluralType type, String pattern, NumberFormat numberFormat) {
        this.ulocale = null;
        this.pluralRules = null;
        this.pattern = null;
        this.parsedValues = null;
        this.numberFormat = null;
        this.offset = 0.0;
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.init(null, type, ulocale, numberFormat);
        this.applyPattern(pattern);
    }

    private final void $$robo$$android_icu_text_PluralFormat$init(PluralRules rules, PluralRules.PluralType type, ULocale locale, NumberFormat numberFormat) {
        this.ulocale = locale;
        this.pluralRules = rules == null ? PluralRules.forLocale(this.ulocale, type) : rules;
        this.resetPattern();
        this.numberFormat = numberFormat == null ? NumberFormat.getInstance(this.ulocale) : numberFormat;
    }

    private final void $$robo$$android_icu_text_PluralFormat$resetPattern() {
        this.pattern = null;
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        this.offset = 0.0;
    }

    private final void $$robo$$android_icu_text_PluralFormat$applyPattern(String pattern) {
        this.pattern = pattern;
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        try {
            this.msgPattern.parsePluralStyle(pattern);
            this.offset = this.msgPattern.getPluralOffset(0);
        }
        catch (RuntimeException e) {
            this.resetPattern();
            throw e;
        }
    }

    private final String $$robo$$android_icu_text_PluralFormat$toPattern() {
        return this.pattern;
    }

    private static final int $$robo$$android_icu_text_PluralFormat$findSubMessage(MessagePattern pattern, int partIndex, PluralSelector selector, Object context, double number) {
        int count = pattern.countParts();
        MessagePattern.Part part = pattern.getPart(partIndex);
        double offset = part.getType().hasNumericValue() ? pattern.getNumericValue(part) : 0.0;
        String keyword = null;
        boolean haveKeywordMatch = false;
        int msgStart = 0;
        do {
            int n = ++partIndex;
            ++partIndex;
            part = pattern.getPart(n);
            MessagePattern.Part.Type type = part.getType();
            if (type == MessagePattern.Part.Type.ARG_LIMIT) break;
            if (!$assertionsDisabled && type != MessagePattern.Part.Type.ARG_SELECTOR) {
                throw new AssertionError();
            }
            if (pattern.getPartType(partIndex).hasNumericValue()) {
                if (number == pattern.getNumericValue(part = pattern.getPart(partIndex++))) {
                    return partIndex;
                }
            } else if (!haveKeywordMatch) {
                if (pattern.partSubstringMatches(part, "other")) {
                    if (msgStart == 0) {
                        msgStart = partIndex;
                        if (keyword != null && keyword.equals("other")) {
                            haveKeywordMatch = true;
                        }
                    }
                } else {
                    if (keyword == null) {
                        keyword = selector.select(context, number - offset);
                        if (msgStart != 0 && keyword.equals("other")) {
                            haveKeywordMatch = true;
                        }
                    }
                    if (!haveKeywordMatch && pattern.partSubstringMatches(part, keyword)) {
                        msgStart = partIndex;
                        haveKeywordMatch = true;
                    }
                }
            }
            partIndex = pattern.getLimitPartIndex(partIndex);
        } while (++partIndex < count);
        return msgStart;
    }

    private final String $$robo$$android_icu_text_PluralFormat$format(double number) {
        return this.format(number, number);
    }

    private final StringBuffer $$robo$$android_icu_text_PluralFormat$format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(number instanceof Number)) {
            throw new IllegalArgumentException("'" + number + "' is not a Number");
        }
        Number numberObject = (Number)number;
        toAppendTo.append(this.format(numberObject, numberObject.doubleValue()));
        return toAppendTo;
    }

    private final String $$robo$$android_icu_text_PluralFormat$format(Number numberObject, double number) {
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            return this.numberFormat.format(numberObject);
        }
        double numberMinusOffset = number - this.offset;
        String numberString = this.offset == 0.0 ? this.numberFormat.format(numberObject) : this.numberFormat.format(numberMinusOffset);
        PluralRules.FixedDecimal dec = this.numberFormat instanceof DecimalFormat ? ((DecimalFormat)this.numberFormat).getFixedDecimal(numberMinusOffset) : new PluralRules.FixedDecimal(numberMinusOffset);
        int partIndex = PluralFormat.findSubMessage(this.msgPattern, 0, this.pluralRulesWrapper, dec, number);
        StringBuilder result = null;
        int prevIndex = this.msgPattern.getPart(partIndex).getLimit();
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++partIndex);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                if (result == null) {
                    return this.pattern.substring(prevIndex, index);
                }
                return result.append(this.pattern, prevIndex, index).toString();
            }
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER || type == MessagePattern.Part.Type.SKIP_SYNTAX && this.msgPattern.jdkAposMode()) {
                if (result == null) {
                    result = new StringBuilder();
                }
                result.append(this.pattern, prevIndex, index);
                if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                    result.append(numberString);
                }
                prevIndex = part.getLimit();
                continue;
            }
            if (type != MessagePattern.Part.Type.ARG_START) continue;
            if (result == null) {
                result = new StringBuilder();
            }
            result.append(this.pattern, prevIndex, index);
            prevIndex = index;
            partIndex = this.msgPattern.getLimitPartIndex(partIndex);
            index = this.msgPattern.getPart(partIndex).getLimit();
            MessagePattern.appendReducedApostrophes(this.pattern, prevIndex, index, result);
            prevIndex = index;
        }
    }

    private final Number $$robo$$android_icu_text_PluralFormat$parse(String text, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private final Object $$robo$$android_icu_text_PluralFormat$parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    private final String $$robo$$android_icu_text_PluralFormat$parseType(String source, RbnfLenientScanner scanner, FieldPosition pos) {
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            pos.setBeginIndex(-1);
            pos.setEndIndex(-1);
            return null;
        }
        int partIndex = 0;
        int count = this.msgPattern.countParts();
        int startingAt = pos.getBeginIndex();
        if (startingAt < 0) {
            startingAt = 0;
        }
        String keyword = null;
        String matchedWord = null;
        int matchedIndex = -1;
        while (partIndex < count) {
            int currMatchIndex;
            MessagePattern.Part partLimit;
            MessagePattern.Part partStart;
            MessagePattern.Part partSelector;
            if ((partSelector = this.msgPattern.getPart(partIndex++)).getType() != MessagePattern.Part.Type.ARG_SELECTOR || (partStart = this.msgPattern.getPart(partIndex++)).getType() != MessagePattern.Part.Type.MSG_START || (partLimit = this.msgPattern.getPart(partIndex++)).getType() != MessagePattern.Part.Type.MSG_LIMIT) continue;
            String currArg = this.pattern.substring(partStart.getLimit(), partLimit.getIndex());
            if (scanner != null) {
                int[] scannerMatchResult = scanner.findText(source, currArg, startingAt);
                currMatchIndex = scannerMatchResult[0];
            } else {
                currMatchIndex = source.indexOf(currArg, startingAt);
            }
            if (currMatchIndex < 0 || currMatchIndex < matchedIndex || matchedWord != null && currArg.length() <= matchedWord.length()) continue;
            matchedIndex = currMatchIndex;
            matchedWord = currArg;
            keyword = this.pattern.substring(partStart.getLimit(), partLimit.getIndex());
        }
        if (keyword != null) {
            pos.setBeginIndex(matchedIndex);
            pos.setEndIndex(matchedIndex + matchedWord.length());
            return keyword;
        }
        pos.setBeginIndex(-1);
        pos.setEndIndex(-1);
        return null;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_PluralFormat$setLocale(ULocale ulocale) {
        if (ulocale == null) {
            ulocale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        this.init(null, PluralRules.PluralType.CARDINAL, ulocale, null);
    }

    private final void $$robo$$android_icu_text_PluralFormat$setNumberFormat(NumberFormat format) {
        this.numberFormat = format;
    }

    private final boolean $$robo$$android_icu_text_PluralFormat$equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return false;
        }
        PluralFormat pf = (PluralFormat)rhs;
        return Utility.objectEquals(this.ulocale, pf.ulocale) && Utility.objectEquals(this.pluralRules, pf.pluralRules) && Utility.objectEquals(this.msgPattern, pf.msgPattern) && Utility.objectEquals(this.numberFormat, pf.numberFormat);
    }

    private final boolean $$robo$$android_icu_text_PluralFormat$equals(PluralFormat rhs) {
        return this.equals((Object)rhs);
    }

    private final int $$robo$$android_icu_text_PluralFormat$hashCode() {
        return this.pluralRules.hashCode() ^ this.parsedValues.hashCode();
    }

    private final String $$robo$$android_icu_text_PluralFormat$toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("locale=" + this.ulocale);
        buf.append(", rules='" + this.pluralRules + "'");
        buf.append(", pattern='" + this.pattern + "'");
        buf.append(", format='" + this.numberFormat + "'");
        return buf.toString();
    }

    private final void $$robo$$android_icu_text_PluralFormat$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pluralRulesWrapper = new PluralSelectorAdapter(this);
        this.parsedValues = null;
        if (this.pattern != null) {
            this.applyPattern(this.pattern);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !PluralFormat.class.desiredAssertionStatus();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__();
    }

    public PluralFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(), 0, this);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale);
    }

    public PluralFormat(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(locale);
    }

    public PluralFormat(Locale locale) {
        this(ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void __constructor__(PluralRules pluralRules) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(pluralRules);
    }

    public PluralFormat(PluralRules pluralRules) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.text.PluralRules ), 0, this, pluralRules);
    }

    private void __constructor__(ULocale uLocale, PluralRules pluralRules) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale, pluralRules);
    }

    public PluralFormat(ULocale uLocale, PluralRules pluralRules) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale android.icu.text.PluralRules ), 0, this, uLocale, pluralRules);
    }

    private void __constructor__(Locale locale, PluralRules pluralRules) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(locale, pluralRules);
    }

    public PluralFormat(Locale locale, PluralRules pluralRules) {
        this(ULocale.forLocale(locale), pluralRules);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(java.util.Locale android.icu.text.PluralRules ), 0, this, locale, pluralRules);
    }

    private void __constructor__(ULocale uLocale, PluralRules.PluralType pluralType) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale, pluralType);
    }

    public PluralFormat(ULocale uLocale, PluralRules.PluralType pluralType) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale android.icu.text.PluralRules$PluralType ), 0, this, uLocale, pluralType);
    }

    private void __constructor__(Locale locale, PluralRules.PluralType pluralType) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(locale, pluralType);
    }

    public PluralFormat(Locale locale, PluralRules.PluralType pluralType) {
        this(ULocale.forLocale(locale), pluralType);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(java.util.Locale android.icu.text.PluralRules$PluralType ), 0, this, locale, pluralType);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(string2);
    }

    public PluralFormat(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(ULocale uLocale, String string2) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale, string2);
    }

    public PluralFormat(ULocale uLocale, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale java.lang.String ), 0, this, uLocale, string2);
    }

    private void __constructor__(PluralRules pluralRules, String string2) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(pluralRules, string2);
    }

    public PluralFormat(PluralRules pluralRules, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.text.PluralRules java.lang.String ), 0, this, pluralRules, string2);
    }

    private void __constructor__(ULocale uLocale, PluralRules pluralRules, String string2) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale, pluralRules, string2);
    }

    public PluralFormat(ULocale uLocale, PluralRules pluralRules, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale android.icu.text.PluralRules java.lang.String ), 0, this, uLocale, pluralRules, string2);
    }

    private void __constructor__(ULocale uLocale, PluralRules.PluralType pluralType, String string2) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale, pluralType, string2);
    }

    public PluralFormat(ULocale uLocale, PluralRules.PluralType pluralType, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale android.icu.text.PluralRules$PluralType java.lang.String ), 0, this, uLocale, pluralType, string2);
    }

    private void __constructor__(ULocale uLocale, PluralRules.PluralType pluralType, String string2, NumberFormat numberFormat) {
        this.$$robo$$android_icu_text_PluralFormat$__constructor__(uLocale, pluralType, string2, numberFormat);
    }

    PluralFormat(ULocale uLocale, PluralRules.PluralType pluralType, String string2, NumberFormat numberFormat) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat$__constructor__(android.icu.util.ULocale android.icu.text.PluralRules$PluralType java.lang.String android.icu.text.NumberFormat ), 0, this, uLocale, pluralType, string2, numberFormat);
    }

    private void init(PluralRules pluralRules, PluralRules.PluralType pluralType, ULocale uLocale, NumberFormat numberFormat) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_text_PluralFormat$init(android.icu.text.PluralRules android.icu.text.PluralRules$PluralType android.icu.util.ULocale android.icu.text.NumberFormat ), 0, this, pluralRules, pluralType, uLocale, numberFormat);
    }

    private void resetPattern() {
        InvokeDynamicSupport.bootstrap("resetPattern", $$robo$$android_icu_text_PluralFormat$resetPattern(), 0, this);
    }

    public void applyPattern(String string2) {
        InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_PluralFormat$applyPattern(java.lang.String ), 0, this, string2);
    }

    public String toPattern() {
        return InvokeDynamicSupport.bootstrap("toPattern", $$robo$$android_icu_text_PluralFormat$toPattern(), 0, this);
    }

    static int findSubMessage(MessagePattern messagePattern, int n, PluralSelector pluralSelector, Object object, double d) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findSubMessage", $$robo$$android_icu_text_PluralFormat$findSubMessage(android.icu.text.MessagePattern int android.icu.text.PluralFormat$PluralSelector java.lang.Object double ), 0, (MessagePattern)messagePattern, (int)n, (PluralSelector)pluralSelector, (Object)object, (double)d);
    }

    public String format(double d) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_PluralFormat$format(double ), 0, this, d);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_PluralFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), 0, this, object, stringBuffer, fieldPosition);
    }

    private String format(Number number, double d) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_PluralFormat$format(java.lang.Number double ), 0, this, number, d);
    }

    public Number parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_PluralFormat$parse(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_PluralFormat$parseObject(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    String parseType(String string2, RbnfLenientScanner rbnfLenientScanner, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("parseType", $$robo$$android_icu_text_PluralFormat$parseType(java.lang.String android.icu.text.RbnfLenientScanner java.text.FieldPosition ), 0, this, string2, rbnfLenientScanner, fieldPosition);
    }

    @Deprecated
    public void setLocale(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_PluralFormat$setLocale(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        InvokeDynamicSupport.bootstrap("setNumberFormat", $$robo$$android_icu_text_PluralFormat$setNumberFormat(android.icu.text.NumberFormat ), 0, this, numberFormat);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_PluralFormat$equals(java.lang.Object ), 0, this, object);
    }

    public boolean equals(PluralFormat pluralFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_PluralFormat$equals(android.icu.text.PluralFormat ), 0, this, pluralFormat);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_PluralFormat$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_PluralFormat$toString(), 0, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_PluralFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    static {
        RobolectricInternals.classInitializing(PluralFormat.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class PluralSelectorAdapter
    implements PluralSelector,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ PluralFormat this$0;

        private void $$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$__constructor__(PluralFormat pluralFormat) {
        }

        private final String $$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$select(Object context, double number) {
            PluralRules.FixedDecimal dec = (PluralRules.FixedDecimal)context;
            if (!$assertionsDisabled && dec.source != (dec.isNegative ? -number : number)) {
                throw new AssertionError();
            }
            return this.this$0.pluralRules.select(dec);
        }

        private /* synthetic */ void $$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$__constructor__(PluralFormat x0, 1 x1) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !PluralFormat.class.desiredAssertionStatus();
        }

        private void __constructor__(PluralFormat pluralFormat) {
            this.$$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$__constructor__(pluralFormat);
        }

        private PluralSelectorAdapter(PluralFormat pluralFormat) {
            this.this$0 = pluralFormat;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$__constructor__(android.icu.text.PluralFormat ), 0, this, pluralFormat);
        }

        @Override
        public String select(Object object, double d) {
            return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$select(java.lang.Object double ), 0, this, object, d);
        }

        private /* synthetic */ void __constructor__(PluralFormat pluralFormat, 1 var2_2) {
            this.$$robo$$android_icu_text_PluralFormat_PluralSelectorAdapter$__constructor__(pluralFormat, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(PluralSelectorAdapter.class);
        }

        public /* synthetic */ PluralSelectorAdapter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralSelectorAdapter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface PluralSelector
    extends InstrumentedInterface {
        public String select(Object var1, double var2);
    }
}

