/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.lang.UCharacter;
import android.icu.text.UCharacterIterator;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NumberingSystem
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String desc;
    private int radix;
    private boolean algorithmic;
    private String name;
    private static ICUCache<String, NumberingSystem> cachedLocaleData;
    private static ICUCache<String, NumberingSystem> cachedStringData;

    private void $$robo$$android_icu_text_NumberingSystem$__constructor__() {
        this.radix = 10;
        this.algorithmic = false;
        this.desc = "0123456789";
        this.name = "latn";
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(int radix_in, boolean isAlgorithmic_in, String desc_in) {
        return NumberingSystem.getInstance(null, radix_in, isAlgorithmic_in, desc_in);
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(String name_in, int radix_in, boolean isAlgorithmic_in, String desc_in) {
        if (radix_in < 2) {
            throw new IllegalArgumentException("Invalid radix for numbering system");
        }
        if (!(isAlgorithmic_in || desc_in.length() == radix_in && NumberingSystem.isValidDigitString(desc_in))) {
            throw new IllegalArgumentException("Invalid digit string for numbering system");
        }
        NumberingSystem ns = new NumberingSystem();
        ns.radix = radix_in;
        ns.algorithmic = isAlgorithmic_in;
        ns.desc = desc_in;
        ns.name = name_in;
        return ns;
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(Locale inLocale) {
        return NumberingSystem.getInstance(ULocale.forLocale(inLocale));
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance(ULocale locale) {
        String baseName;
        NumberingSystem ns;
        String[] OTHER_NS_KEYWORDS = new String[]{"native", "traditional", "finance"};
        Boolean nsResolved = true;
        String numbersKeyword = locale.getKeywordValue("numbers");
        if (numbersKeyword != null) {
            for (String keyword : OTHER_NS_KEYWORDS) {
                if (!numbersKeyword.equals(keyword)) continue;
                nsResolved = false;
                break;
            }
        } else {
            numbersKeyword = "default";
            nsResolved = false;
        }
        if (nsResolved.booleanValue()) {
            ns = NumberingSystem.getInstanceByName(numbersKeyword);
            if (ns != null) {
                return ns;
            }
            numbersKeyword = "default";
            nsResolved = false;
        }
        if ((ns = cachedLocaleData.get((baseName = locale.getBaseName()) + "@numbers=" + numbersKeyword)) != null) {
            return ns;
        }
        String originalNumbersKeyword = numbersKeyword;
        String resolvedNumberingSystem = null;
        while (!nsResolved.booleanValue()) {
            try {
                ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", locale);
                rb = rb.getWithFallback("NumberElements");
                resolvedNumberingSystem = rb.getStringWithFallback(numbersKeyword);
                nsResolved = true;
            }
            catch (MissingResourceException ex) {
                if (numbersKeyword.equals("native") || numbersKeyword.equals("finance")) {
                    numbersKeyword = "default";
                    continue;
                }
                if (numbersKeyword.equals("traditional")) {
                    numbersKeyword = "native";
                    continue;
                }
                nsResolved = true;
            }
        }
        if (resolvedNumberingSystem != null) {
            ns = NumberingSystem.getInstanceByName(resolvedNumberingSystem);
        }
        if (ns == null) {
            ns = new NumberingSystem();
        }
        cachedLocaleData.put(baseName + "@numbers=" + originalNumbersKeyword, ns);
        return ns;
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstance() {
        return NumberingSystem.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final NumberingSystem $$robo$$android_icu_text_NumberingSystem$getInstanceByName(String name) {
        boolean isAlgorithmic;
        int radix;
        String description;
        NumberingSystem ns = cachedStringData.get(name);
        if (ns != null) {
            return ns;
        }
        try {
            UResourceBundle numberingSystemsInfo = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", "numberingSystems");
            UResourceBundle nsCurrent = numberingSystemsInfo.get("numberingSystems");
            UResourceBundle nsTop = nsCurrent.get(name);
            description = nsTop.getString("desc");
            UResourceBundle nsRadixBundle = nsTop.get("radix");
            UResourceBundle nsAlgBundle = nsTop.get("algorithmic");
            radix = nsRadixBundle.getInt();
            int algorithmic = nsAlgBundle.getInt();
            isAlgorithmic = algorithmic == 1;
        }
        catch (MissingResourceException ex) {
            return null;
        }
        ns = NumberingSystem.getInstance(name, radix, isAlgorithmic, description);
        cachedStringData.put(name, ns);
        return ns;
    }

    private static final String[] $$robo$$android_icu_text_NumberingSystem$getAvailableNames() {
        UResourceBundle numberingSystemsInfo = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", "numberingSystems");
        UResourceBundle nsCurrent = numberingSystemsInfo.get("numberingSystems");
        ArrayList<String> output = new ArrayList<String>();
        UResourceBundleIterator it = nsCurrent.getIterator();
        while (it.hasNext()) {
            UResourceBundle temp = it.next();
            String nsName = temp.getKey();
            output.add(nsName);
        }
        return output.toArray(new String[output.size()]);
    }

    private static final boolean $$robo$$android_icu_text_NumberingSystem$isValidDigitString(String str) {
        int c;
        int i = 0;
        UCharacterIterator it = UCharacterIterator.getInstance(str);
        it.setToStart();
        while ((c = it.nextCodePoint()) != -1) {
            if (UCharacter.isSupplementary(c)) {
                return false;
            }
            ++i;
        }
        return i == 10;
    }

    private final int $$robo$$android_icu_text_NumberingSystem$getRadix() {
        return this.radix;
    }

    private final String $$robo$$android_icu_text_NumberingSystem$getDescription() {
        return this.desc;
    }

    private final String $$robo$$android_icu_text_NumberingSystem$getName() {
        return this.name;
    }

    private final boolean $$robo$$android_icu_text_NumberingSystem$isAlgorithmic() {
        return this.algorithmic;
    }

    static void __staticInitializer__() {
        cachedLocaleData = new SimpleCache<String, NumberingSystem>();
        cachedStringData = new SimpleCache<String, NumberingSystem>();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_NumberingSystem$__constructor__();
    }

    public NumberingSystem() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberingSystem$__constructor__(), 0, this);
    }

    public static NumberingSystem getInstance(int n, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(int boolean java.lang.String ), 0, (int)n, (boolean)bl, (String)string2);
    }

    private static NumberingSystem getInstance(String string2, int n, boolean bl, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(java.lang.String int boolean java.lang.String ), 0, (String)string2, (int)n, (boolean)bl, (String)string3);
    }

    public static NumberingSystem getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberingSystem getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static NumberingSystem getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberingSystem$getInstance(), 0);
    }

    public static NumberingSystem getInstanceByName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceByName", $$robo$$android_icu_text_NumberingSystem$getInstanceByName(java.lang.String ), 0, (String)string2);
    }

    public static String[] getAvailableNames() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableNames", $$robo$$android_icu_text_NumberingSystem$getAvailableNames(), 0);
    }

    public static boolean isValidDigitString(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDigitString", $$robo$$android_icu_text_NumberingSystem$isValidDigitString(java.lang.String ), 0, (String)string2);
    }

    public int getRadix() {
        return (int)InvokeDynamicSupport.bootstrap("getRadix", $$robo$$android_icu_text_NumberingSystem$getRadix(), 0, this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_icu_text_NumberingSystem$getDescription(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_NumberingSystem$getName(), 0, this);
    }

    public boolean isAlgorithmic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlgorithmic", $$robo$$android_icu_text_NumberingSystem$isAlgorithmic(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(NumberingSystem.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberingSystem)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

