/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.DontCareFieldPosition;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.SimplePatternFormatter;
import android.icu.impl.StandardPlural;
import android.icu.impl.UResource;
import android.icu.text.CurrencyFormat;
import android.icu.text.DateFormat;
import android.icu.text.DecimalFormat;
import android.icu.text.ListFormatter;
import android.icu.text.NumberFormat;
import android.icu.text.NumberingSystem;
import android.icu.text.PluralRanges;
import android.icu.text.PluralRules;
import android.icu.text.QuantityFormatter;
import android.icu.text.SimpleDateFormat;
import android.icu.text.TimeUnitFormat;
import android.icu.text.UFieldPosition;
import android.icu.text.UFormat;
import android.icu.util.Currency;
import android.icu.util.CurrencyAmount;
import android.icu.util.ICUException;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MeasureFormat
extends UFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static long serialVersionUID = -7182021401701778240L;
    private transient MeasureFormatData cache;
    private transient ImmutableNumberFormat numberFormat;
    private transient FormatWidth formatWidth;
    private transient PluralRules rules;
    private transient NumericFormatters numericFormatters;
    private transient ImmutableNumberFormat currencyFormat;
    private transient ImmutableNumberFormat integerFormat;
    private static SimpleCache<ULocale, MeasureFormatData> localeMeasureFormatData;
    private static SimpleCache<ULocale, NumericFormatters> localeToNumericDurationFormatters;
    private static Map<MeasureUnit, Integer> hmsTo012;
    private static int MEASURE_FORMAT = 0;
    private static int TIME_UNIT_FORMAT = 1;
    private static int CURRENCY_FORMAT = 2;
    private static Map<ULocale, String> localeIdToRangeFormat;

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getInstance(ULocale locale, FormatWidth formatWidth) {
        return MeasureFormat.getInstance(locale, formatWidth, NumberFormat.getInstance(locale));
    }

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getInstance(Locale locale, FormatWidth formatWidth) {
        return MeasureFormat.getInstance(ULocale.forLocale(locale), formatWidth);
    }

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getInstance(ULocale locale, FormatWidth formatWidth, NumberFormat format) {
        PluralRules rules = PluralRules.forLocale(locale);
        NumericFormatters formatters = null;
        MeasureFormatData data = localeMeasureFormatData.get(locale);
        if (data == null) {
            data = MeasureFormat.loadLocaleData(locale);
            localeMeasureFormatData.put(locale, data);
        }
        if (formatWidth == FormatWidth.NUMERIC && (formatters = localeToNumericDurationFormatters.get(locale)) == null) {
            formatters = MeasureFormat.loadNumericFormatters(locale);
            localeToNumericDurationFormatters.put(locale, formatters);
        }
        NumberFormat intFormat = NumberFormat.getInstance(locale);
        intFormat.setMaximumFractionDigits(0);
        intFormat.setMinimumFractionDigits(0);
        intFormat.setRoundingMode(1);
        return new MeasureFormat(locale, data, formatWidth, new ImmutableNumberFormat(format), rules, formatters, new ImmutableNumberFormat(NumberFormat.getInstance(locale, formatWidth.getCurrencyStyle())), new ImmutableNumberFormat(intFormat));
    }

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getInstance(Locale locale, FormatWidth formatWidth, NumberFormat format) {
        return MeasureFormat.getInstance(ULocale.forLocale(locale), formatWidth, format);
    }

    private final StringBuffer $$robo$$android_icu_text_MeasureFormat$format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int prevLength = toAppendTo.length();
        FieldPosition fpos = new FieldPosition(pos.getFieldAttribute(), pos.getField());
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            Measure[] measures = new Measure[coll.size()];
            int idx = 0;
            for (Object o : coll) {
                if (!(o instanceof Measure)) {
                    throw new IllegalArgumentException(obj.toString());
                }
                measures[idx++] = (Measure)o;
            }
            toAppendTo.append((CharSequence)this.formatMeasures(new StringBuilder(), fpos, measures));
        } else if (obj instanceof Measure[]) {
            toAppendTo.append((CharSequence)this.formatMeasures(new StringBuilder(), fpos, (Measure[])obj));
        } else if (obj instanceof Measure) {
            toAppendTo.append((CharSequence)this.formatMeasure((Measure)obj, this.numberFormat, new StringBuilder(), fpos));
        } else {
            throw new IllegalArgumentException(obj.toString());
        }
        if (fpos.getBeginIndex() != 0 || fpos.getEndIndex() != 0) {
            pos.setBeginIndex(fpos.getBeginIndex() + prevLength);
            pos.setEndIndex(fpos.getEndIndex() + prevLength);
        }
        return toAppendTo;
    }

    private final Measure $$robo$$android_icu_text_MeasureFormat$parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    private final String $$robo$$android_icu_text_MeasureFormat$formatMeasures(Measure ... measures) {
        return this.formatMeasures(new StringBuilder(), DontCareFieldPosition.INSTANCE, measures).toString();
    }

    @Deprecated
    private final String $$robo$$android_icu_text_MeasureFormat$formatMeasureRange(Measure lowValue, Measure highValue) {
        MeasureUnit unit = lowValue.getUnit();
        if (!unit.equals(highValue.getUnit())) {
            throw new IllegalArgumentException("Units must match: " + unit + " \u2260 " + highValue.getUnit());
        }
        Number lowNumber = lowValue.getNumber();
        Number highNumber = highValue.getNumber();
        boolean isCurrency = unit instanceof Currency;
        UFieldPosition lowFpos = new UFieldPosition();
        UFieldPosition highFpos = new UFieldPosition();
        StringBuffer lowFormatted = null;
        StringBuffer highFormatted = null;
        if (isCurrency) {
            Currency currency = (Currency)unit;
            int fracDigits = currency.getDefaultFractionDigits();
            int maxFrac = this.numberFormat.nf.getMaximumFractionDigits();
            int minFrac = this.numberFormat.nf.getMinimumFractionDigits();
            if (fracDigits != maxFrac || fracDigits != minFrac) {
                DecimalFormat currentNumberFormat = (DecimalFormat)this.numberFormat.get();
                currentNumberFormat.setMaximumFractionDigits(fracDigits);
                currentNumberFormat.setMinimumFractionDigits(fracDigits);
                lowFormatted = currentNumberFormat.format(lowNumber, new StringBuffer(), (FieldPosition)lowFpos);
                highFormatted = currentNumberFormat.format(highNumber, new StringBuffer(), (FieldPosition)highFpos);
            }
        }
        if (lowFormatted == null) {
            lowFormatted = this.numberFormat.format(lowNumber, new StringBuffer(), (FieldPosition)lowFpos);
            highFormatted = this.numberFormat.format(highNumber, new StringBuffer(), (FieldPosition)highFpos);
        }
        double lowDouble = lowNumber.doubleValue();
        String keywordLow = this.rules.select(new PluralRules.FixedDecimal(lowDouble, lowFpos.getCountVisibleFractionDigits(), lowFpos.getFractionDigits()));
        double highDouble = highNumber.doubleValue();
        String keywordHigh = this.rules.select(new PluralRules.FixedDecimal(highDouble, highFpos.getCountVisibleFractionDigits(), highFpos.getFractionDigits()));
        PluralRanges pluralRanges = PluralRules.Factory.getDefaultFactory().getPluralRanges(this.getLocale());
        StandardPlural resolvedPlural = pluralRanges.get(StandardPlural.fromString(keywordLow), StandardPlural.fromString(keywordHigh));
        String rangeFormatter = MeasureFormat.getRangeFormat(this.getLocale(), this.formatWidth);
        String formattedNumber = SimplePatternFormatter.formatCompiledPattern(rangeFormatter, lowFormatted, highFormatted);
        if (isCurrency) {
            this.currencyFormat.format(1.0);
            Currency currencyUnit = (Currency)unit;
            StringBuilder result = new StringBuilder();
            this.appendReplacingCurrency(this.currencyFormat.getPrefix(lowDouble >= 0.0), currencyUnit, resolvedPlural, result);
            result.append(formattedNumber);
            this.appendReplacingCurrency(this.currencyFormat.getSuffix(highDouble >= 0.0), currencyUnit, resolvedPlural, result);
            return result.toString();
        }
        String formatter = this.getPluralFormatter(lowValue.getUnit(), this.formatWidth, resolvedPlural.ordinal());
        return SimplePatternFormatter.formatCompiledPattern(formatter, formattedNumber);
    }

    private final void $$robo$$android_icu_text_MeasureFormat$appendReplacingCurrency(String affix, Currency unit, StandardPlural resolvedPlural, StringBuilder result) {
        String replacement = "\u00a4";
        int pos = affix.indexOf(replacement);
        if (pos < 0) {
            replacement = "XXX";
            pos = affix.indexOf(replacement);
        }
        if (pos < 0) {
            result.append(affix);
        } else {
            result.append(affix.substring(0, pos));
            int currentStyle = this.formatWidth.getCurrencyStyle();
            if (currentStyle == 5) {
                result.append(unit.getCurrencyCode());
            } else {
                result.append(unit.getName(this.currencyFormat.nf.getLocale(ULocale.ACTUAL_LOCALE), currentStyle == 1 ? 0 : 2, resolvedPlural.getKeyword(), null));
            }
            result.append(affix.substring(pos + replacement.length()));
        }
    }

    private final StringBuilder $$robo$$android_icu_text_MeasureFormat$formatMeasurePerUnit(Measure measure, MeasureUnit perUnit, StringBuilder appendTo, FieldPosition pos) {
        MeasureUnit resolvedUnit = MeasureUnit.resolveUnitPerUnit(measure.getUnit(), perUnit);
        if (resolvedUnit != null) {
            Measure newMeasure = new Measure(measure.getNumber(), resolvedUnit);
            return this.formatMeasure(newMeasure, this.numberFormat, appendTo, pos);
        }
        FieldPosition fpos = new FieldPosition(pos.getFieldAttribute(), pos.getField());
        int offset = this.withPerUnitAndAppend(this.formatMeasure(measure, this.numberFormat, new StringBuilder(), fpos), perUnit, appendTo);
        if (fpos.getBeginIndex() != 0 || fpos.getEndIndex() != 0) {
            pos.setBeginIndex(fpos.getBeginIndex() + offset);
            pos.setEndIndex(fpos.getEndIndex() + offset);
        }
        return appendTo;
    }

    private final StringBuilder $$robo$$android_icu_text_MeasureFormat$formatMeasures(StringBuilder appendTo, FieldPosition fieldPosition, Measure ... measures) {
        Number[] hms;
        if (measures.length == 0) {
            return appendTo;
        }
        if (measures.length == 1) {
            return this.formatMeasure(measures[0], this.numberFormat, appendTo, fieldPosition);
        }
        if (this.formatWidth == FormatWidth.NUMERIC && (hms = MeasureFormat.toHMS(measures)) != null) {
            return this.formatNumeric(hms, appendTo);
        }
        ListFormatter listFormatter = ListFormatter.getInstance(this.getLocale(), this.formatWidth.getListFormatterStyle());
        if (fieldPosition != DontCareFieldPosition.INSTANCE) {
            return this.formatMeasuresSlowTrack(listFormatter, appendTo, fieldPosition, measures);
        }
        String[] results = new String[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            results[i] = this.formatMeasure(measures[i], i == measures.length - 1 ? this.numberFormat : this.integerFormat);
        }
        return appendTo.append(listFormatter.format(results));
    }

    private final boolean $$robo$$android_icu_text_MeasureFormat$equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeasureFormat)) {
            return false;
        }
        MeasureFormat rhs = (MeasureFormat)other;
        return this.getWidth() == rhs.getWidth() && this.getLocale().equals(rhs.getLocale()) && this.getNumberFormat().equals(rhs.getNumberFormat());
    }

    private final int $$robo$$android_icu_text_MeasureFormat$hashCode() {
        return (this.getLocale().hashCode() * 31 + this.getNumberFormat().hashCode()) * 31 + this.getWidth().hashCode();
    }

    private final FormatWidth $$robo$$android_icu_text_MeasureFormat$getWidth() {
        return this.formatWidth;
    }

    private final ULocale $$robo$$android_icu_text_MeasureFormat$getLocale() {
        return this.getLocale(ULocale.VALID_LOCALE);
    }

    private final NumberFormat $$robo$$android_icu_text_MeasureFormat$getNumberFormat() {
        return this.numberFormat.get();
    }

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getCurrencyFormat(ULocale locale) {
        return new CurrencyFormat(locale);
    }

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getCurrencyFormat(Locale locale) {
        return MeasureFormat.getCurrencyFormat(ULocale.forLocale(locale));
    }

    private static final MeasureFormat $$robo$$android_icu_text_MeasureFormat$getCurrencyFormat() {
        return MeasureFormat.getCurrencyFormat(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private final MeasureFormat $$robo$$android_icu_text_MeasureFormat$withLocale(ULocale locale) {
        return MeasureFormat.getInstance(locale, this.getWidth());
    }

    private final MeasureFormat $$robo$$android_icu_text_MeasureFormat$withNumberFormat(NumberFormat format) {
        return new MeasureFormat(this.getLocale(), this.cache, this.formatWidth, new ImmutableNumberFormat(format), this.rules, this.numericFormatters, this.currencyFormat, this.integerFormat);
    }

    private void $$robo$$android_icu_text_MeasureFormat$__constructor__(ULocale locale, MeasureFormatData data, FormatWidth formatWidth, ImmutableNumberFormat format, PluralRules rules, NumericFormatters formatters, ImmutableNumberFormat currencyFormat, ImmutableNumberFormat integerFormat) {
        this.setLocale(locale, locale);
        this.cache = data;
        this.formatWidth = formatWidth;
        this.numberFormat = format;
        this.rules = rules;
        this.numericFormatters = formatters;
        this.currencyFormat = currencyFormat;
        this.integerFormat = integerFormat;
    }

    private void $$robo$$android_icu_text_MeasureFormat$__constructor__() {
        this.cache = null;
        this.formatWidth = null;
        this.numberFormat = null;
        this.rules = null;
        this.numericFormatters = null;
        this.currencyFormat = null;
        this.integerFormat = null;
    }

    private static final NumericFormatters $$robo$$android_icu_text_MeasureFormat$loadNumericFormatters(ULocale locale) {
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b/unit", locale);
        return new NumericFormatters(MeasureFormat.loadNumericDurationFormat(r, "hm"), MeasureFormat.loadNumericDurationFormat(r, "ms"), MeasureFormat.loadNumericDurationFormat(r, "hms"));
    }

    private static final MeasureFormatData $$robo$$android_icu_text_MeasureFormat$loadLocaleData(ULocale locale) {
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b/unit", locale);
        MeasureFormatData cacheData = new MeasureFormatData();
        UnitDataSink sink = new UnitDataSink(cacheData);
        resource.getAllTableItemsWithFallback("", sink);
        return cacheData;
    }

    private static final FormatWidth $$robo$$android_icu_text_MeasureFormat$getRegularWidth(FormatWidth width) {
        if (width == FormatWidth.NUMERIC) {
            return FormatWidth.NARROW;
        }
        return width;
    }

    private final String $$robo$$android_icu_text_MeasureFormat$getFormatterOrNull(MeasureUnit unit, FormatWidth width, int index) {
        width = MeasureFormat.getRegularWidth(width);
        Map styleToPatterns = this.cache.unitToStyleToPatterns.get(unit);
        String[] patterns = (String[])styleToPatterns.get((Object)width);
        if (patterns != null && patterns[index] != null) {
            return patterns[index];
        }
        FormatWidth fallbackWidth = this.cache.widthFallback[width.ordinal()];
        if (fallbackWidth != null && (patterns = (String[])styleToPatterns.get((Object)fallbackWidth)) != null && patterns[index] != null) {
            return patterns[index];
        }
        return null;
    }

    private final String $$robo$$android_icu_text_MeasureFormat$getFormatter(MeasureUnit unit, FormatWidth width, int index) {
        String pattern = this.getFormatterOrNull(unit, width, index);
        if (pattern == null) {
            throw new MissingResourceException("no formatting pattern for " + unit + ", width " + (Object)((Object)width) + ", index " + index, null, null);
        }
        return pattern;
    }

    private final String $$robo$$android_icu_text_MeasureFormat$getPluralFormatter(MeasureUnit unit, FormatWidth width, int index) {
        String pattern;
        if (index != StandardPlural.OTHER_INDEX && (pattern = this.getFormatterOrNull(unit, width, index)) != null) {
            return pattern;
        }
        return this.getFormatter(unit, width, StandardPlural.OTHER_INDEX);
    }

    private final String $$robo$$android_icu_text_MeasureFormat$getPerFormatter(FormatWidth width) {
        String perPattern = this.cache.styleToPerPattern.get((Object)(width = MeasureFormat.getRegularWidth(width)));
        if (perPattern != null) {
            return perPattern;
        }
        FormatWidth fallbackWidth = this.cache.widthFallback[width.ordinal()];
        if (fallbackWidth != null && (perPattern = this.cache.styleToPerPattern.get((Object)fallbackWidth)) != null) {
            return perPattern;
        }
        throw new MissingResourceException("no x-per-y pattern for width " + (Object)((Object)width), null, null);
    }

    private final int $$robo$$android_icu_text_MeasureFormat$withPerUnitAndAppend(CharSequence formatted, MeasureUnit perUnit, StringBuilder appendTo) {
        int[] offsets = new int[1];
        String perUnitPattern = this.getFormatterOrNull(perUnit, this.formatWidth, MeasureFormatData.PER_UNIT_INDEX);
        if (perUnitPattern != null) {
            SimplePatternFormatter.formatAndAppend(perUnitPattern, appendTo, offsets, formatted);
            return offsets[0];
        }
        String perPattern = this.getPerFormatter(this.formatWidth);
        String pattern = this.getPluralFormatter(perUnit, this.formatWidth, StandardPlural.ONE.ordinal());
        String perUnitString = SimplePatternFormatter.getTextWithNoPlaceholders(pattern).trim();
        SimplePatternFormatter.formatAndAppend(perPattern, appendTo, offsets, formatted, perUnitString);
        return offsets[0];
    }

    private final String $$robo$$android_icu_text_MeasureFormat$formatMeasure(Measure measure, ImmutableNumberFormat nf) {
        return this.formatMeasure(measure, nf, new StringBuilder(), DontCareFieldPosition.INSTANCE).toString();
    }

    private final StringBuilder $$robo$$android_icu_text_MeasureFormat$formatMeasure(Measure measure, ImmutableNumberFormat nf, StringBuilder appendTo, FieldPosition fieldPosition) {
        Number n = measure.getNumber();
        MeasureUnit unit = measure.getUnit();
        if (unit instanceof Currency) {
            return appendTo.append(this.currencyFormat.format(new CurrencyAmount(n, (Currency)unit), new StringBuffer(), fieldPosition));
        }
        StringBuffer formattedNumber = new StringBuffer();
        StandardPlural pluralForm = QuantityFormatter.selectPlural(n, nf.nf, this.rules, formattedNumber, fieldPosition);
        String formatter = this.getPluralFormatter(unit, this.formatWidth, pluralForm.ordinal());
        return QuantityFormatter.format(formatter, formattedNumber, appendTo, fieldPosition);
    }

    private final Object $$robo$$android_icu_text_MeasureFormat$toTimeUnitProxy() {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.numberFormat.get(), 1);
    }

    private final Object $$robo$$android_icu_text_MeasureFormat$toCurrencyProxy() {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.numberFormat.get(), 2);
    }

    private final StringBuilder $$robo$$android_icu_text_MeasureFormat$formatMeasuresSlowTrack(ListFormatter listFormatter, StringBuilder appendTo, FieldPosition fieldPosition, Measure ... measures) {
        String[] results = new String[measures.length];
        FieldPosition fpos = new FieldPosition(fieldPosition.getFieldAttribute(), fieldPosition.getField());
        int fieldPositionFoundIndex = -1;
        for (int i = 0; i < measures.length; ++i) {
            ImmutableNumberFormat nf;
            ImmutableNumberFormat immutableNumberFormat = nf = i == measures.length - 1 ? this.numberFormat : this.integerFormat;
            if (fieldPositionFoundIndex == -1) {
                results[i] = this.formatMeasure(measures[i], nf, new StringBuilder(), fpos).toString();
                if (fpos.getBeginIndex() == 0 && fpos.getEndIndex() == 0) continue;
                fieldPositionFoundIndex = i;
                continue;
            }
            results[i] = this.formatMeasure(measures[i], nf);
        }
        ListFormatter.FormattedListBuilder builder = listFormatter.format(Arrays.asList(results), fieldPositionFoundIndex);
        if (builder.getOffset() != -1) {
            fieldPosition.setBeginIndex(fpos.getBeginIndex() + builder.getOffset() + appendTo.length());
            fieldPosition.setEndIndex(fpos.getEndIndex() + builder.getOffset() + appendTo.length());
        }
        return appendTo.append(builder.toString());
    }

    private static final DateFormat $$robo$$android_icu_text_MeasureFormat$loadNumericDurationFormat(ICUResourceBundle r, String type) {
        r = r.getWithFallback(String.format("durationUnits/%s", type));
        SimpleDateFormat result = new SimpleDateFormat(r.getString().replace("h", "H"));
        result.setTimeZone(TimeZone.GMT_ZONE);
        return result;
    }

    private static final Number[] $$robo$$android_icu_text_MeasureFormat$toHMS(Measure[] measures) {
        Number[] result = new Number[3];
        int lastIdx = -1;
        for (Measure m : measures) {
            if (m.getNumber().doubleValue() < 0.0) {
                return null;
            }
            Integer idxObj = hmsTo012.get(m.getUnit());
            if (idxObj == null) {
                return null;
            }
            int idx = idxObj;
            if (idx <= lastIdx) {
                return null;
            }
            lastIdx = idx;
            result[idx] = m.getNumber();
        }
        return result;
    }

    private final StringBuilder $$robo$$android_icu_text_MeasureFormat$formatNumeric(Number[] hms, StringBuilder appendable) {
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < hms.length; ++i) {
            if (hms[i] != null) {
                endIndex = i;
                if (startIndex != -1) continue;
                startIndex = endIndex;
                continue;
            }
            hms[i] = 0;
        }
        long millis = (long)(((Math.floor(hms[0].doubleValue()) * 60.0 + Math.floor(hms[1].doubleValue())) * 60.0 + Math.floor(hms[2].doubleValue())) * 1000.0);
        Date d = new Date(millis);
        if (startIndex == 0 && endIndex == 2) {
            return this.formatNumeric(d, this.numericFormatters.getHourMinuteSecond(), DateFormat.Field.SECOND, hms[endIndex], appendable);
        }
        if (startIndex == 1 && endIndex == 2) {
            return this.formatNumeric(d, this.numericFormatters.getMinuteSecond(), DateFormat.Field.SECOND, hms[endIndex], appendable);
        }
        if (startIndex == 0 && endIndex == 1) {
            return this.formatNumeric(d, this.numericFormatters.getHourMinute(), DateFormat.Field.MINUTE, hms[endIndex], appendable);
        }
        throw new IllegalStateException();
    }

    private final StringBuilder $$robo$$android_icu_text_MeasureFormat$formatNumeric(Date duration, DateFormat formatter, DateFormat.Field smallestField, Number smallestAmount, StringBuilder appendTo) {
        FieldPosition intFieldPosition = new FieldPosition(0);
        String smallestAmountFormatted = this.numberFormat.format(smallestAmount, new StringBuffer(), intFieldPosition).toString();
        if (intFieldPosition.getBeginIndex() == 0 && intFieldPosition.getEndIndex() == 0) {
            throw new IllegalStateException();
        }
        FieldPosition smallestFieldPosition = new FieldPosition(smallestField);
        String draft = formatter.format(duration, new StringBuffer(), smallestFieldPosition).toString();
        if (smallestFieldPosition.getBeginIndex() != 0 || smallestFieldPosition.getEndIndex() != 0) {
            appendTo.append(draft, 0, smallestFieldPosition.getBeginIndex());
            appendTo.append(smallestAmountFormatted, 0, intFieldPosition.getBeginIndex());
            appendTo.append(draft, smallestFieldPosition.getBeginIndex(), smallestFieldPosition.getEndIndex());
            appendTo.append(smallestAmountFormatted, intFieldPosition.getEndIndex(), smallestAmountFormatted.length());
            appendTo.append(draft, smallestFieldPosition.getEndIndex(), draft.length());
        } else {
            appendTo.append(draft);
        }
        return appendTo;
    }

    private final Object $$robo$$android_icu_text_MeasureFormat$writeReplace() throws ObjectStreamException {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.numberFormat.get(), 0);
    }

    private static final FormatWidth $$robo$$android_icu_text_MeasureFormat$fromFormatWidthOrdinal(int ordinal) {
        FormatWidth[] values = FormatWidth.values();
        if (ordinal < 0 || ordinal >= values.length) {
            return FormatWidth.SHORT;
        }
        return values[ordinal];
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_MeasureFormat$getRangeFormat(ULocale forLocale, FormatWidth width) {
        if (forLocale.getLanguage().equals("fr")) {
            return MeasureFormat.getRangeFormat(ULocale.ROOT, width);
        }
        String result = localeIdToRangeFormat.get(forLocale);
        if (result == null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", forLocale);
            ULocale realLocale = rb.getULocale();
            if (!forLocale.equals(realLocale) && (result = localeIdToRangeFormat.get(forLocale)) != null) {
                localeIdToRangeFormat.put(forLocale, result);
                return result;
            }
            NumberingSystem ns = NumberingSystem.getInstance(forLocale);
            String resultString = null;
            try {
                resultString = rb.getStringWithFallback("NumberElements/" + ns.getName() + "/miscPatterns/range");
            }
            catch (MissingResourceException ex) {
                resultString = rb.getStringWithFallback("NumberElements/latn/patterns/range");
            }
            result = SimplePatternFormatter.compileToStringMinMaxPlaceholders(resultString, new StringBuilder(), 2, 2);
            localeIdToRangeFormat.put(forLocale, result);
            if (!forLocale.equals(realLocale)) {
                localeIdToRangeFormat.put(realLocale, result);
            }
        }
        return result;
    }

    static void __staticInitializer__() {
        localeMeasureFormatData = new SimpleCache();
        localeToNumericDurationFormatters = new SimpleCache();
        hmsTo012 = new HashMap<MeasureUnit, Integer>();
        hmsTo012.put(MeasureUnit.HOUR, 0);
        hmsTo012.put(MeasureUnit.MINUTE, 1);
        hmsTo012.put(MeasureUnit.SECOND, 2);
        localeIdToRangeFormat = new ConcurrentHashMap<ULocale, String>();
    }

    public static MeasureFormat getInstance(ULocale uLocale, FormatWidth formatWidth) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_MeasureFormat$getInstance(android.icu.util.ULocale android.icu.text.MeasureFormat$FormatWidth ), 0, (ULocale)uLocale, (FormatWidth)formatWidth);
    }

    public static MeasureFormat getInstance(Locale locale, FormatWidth formatWidth) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_MeasureFormat$getInstance(java.util.Locale android.icu.text.MeasureFormat$FormatWidth ), 0, (Locale)locale, (FormatWidth)formatWidth);
    }

    public static MeasureFormat getInstance(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_MeasureFormat$getInstance(android.icu.util.ULocale android.icu.text.MeasureFormat$FormatWidth android.icu.text.NumberFormat ), 0, (ULocale)uLocale, (FormatWidth)formatWidth, (NumberFormat)numberFormat);
    }

    public static MeasureFormat getInstance(Locale locale, FormatWidth formatWidth, NumberFormat numberFormat) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_MeasureFormat$getInstance(java.util.Locale android.icu.text.MeasureFormat$FormatWidth android.icu.text.NumberFormat ), 0, (Locale)locale, (FormatWidth)formatWidth, (NumberFormat)numberFormat);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MeasureFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), 0, this, object, stringBuffer, fieldPosition);
    }

    @Override
    public Measure parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_MeasureFormat$parseObject(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public String formatMeasures(Measure ... measureArray) {
        return InvokeDynamicSupport.bootstrap("formatMeasures", $$robo$$android_icu_text_MeasureFormat$formatMeasures(android.icu.util.Measure[] ), 0, this, measureArray);
    }

    @Deprecated
    public String formatMeasureRange(Measure measure, Measure measure2) {
        return InvokeDynamicSupport.bootstrap("formatMeasureRange", $$robo$$android_icu_text_MeasureFormat$formatMeasureRange(android.icu.util.Measure android.icu.util.Measure ), 0, this, measure, measure2);
    }

    private void appendReplacingCurrency(String string2, Currency currency, StandardPlural standardPlural, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendReplacingCurrency", $$robo$$android_icu_text_MeasureFormat$appendReplacingCurrency(java.lang.String android.icu.util.Currency android.icu.impl.StandardPlural java.lang.StringBuilder ), 0, this, string2, currency, standardPlural, stringBuilder);
    }

    public StringBuilder formatMeasurePerUnit(Measure measure, MeasureUnit measureUnit, StringBuilder stringBuilder, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("formatMeasurePerUnit", $$robo$$android_icu_text_MeasureFormat$formatMeasurePerUnit(android.icu.util.Measure android.icu.util.MeasureUnit java.lang.StringBuilder java.text.FieldPosition ), 0, this, measure, measureUnit, stringBuilder, fieldPosition);
    }

    public StringBuilder formatMeasures(StringBuilder stringBuilder, FieldPosition fieldPosition, Measure ... measureArray) {
        return InvokeDynamicSupport.bootstrap("formatMeasures", $$robo$$android_icu_text_MeasureFormat$formatMeasures(java.lang.StringBuilder java.text.FieldPosition android.icu.util.Measure[] ), 0, this, stringBuilder, fieldPosition, measureArray);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_MeasureFormat$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_MeasureFormat$hashCode(), 0, this);
    }

    public FormatWidth getWidth() {
        return InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_icu_text_MeasureFormat$getWidth(), 0, this);
    }

    public ULocale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_MeasureFormat$getLocale(), 0, this);
    }

    public NumberFormat getNumberFormat() {
        return InvokeDynamicSupport.bootstrap("getNumberFormat", $$robo$$android_icu_text_MeasureFormat$getNumberFormat(), 0, this);
    }

    public static MeasureFormat getCurrencyFormat(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyFormat", $$robo$$android_icu_text_MeasureFormat$getCurrencyFormat(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static MeasureFormat getCurrencyFormat(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyFormat", $$robo$$android_icu_text_MeasureFormat$getCurrencyFormat(java.util.Locale ), 0, (Locale)locale);
    }

    public static MeasureFormat getCurrencyFormat() {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyFormat", $$robo$$android_icu_text_MeasureFormat$getCurrencyFormat(), 0);
    }

    MeasureFormat withLocale(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("withLocale", $$robo$$android_icu_text_MeasureFormat$withLocale(android.icu.util.ULocale ), 0, this, uLocale);
    }

    MeasureFormat withNumberFormat(NumberFormat numberFormat) {
        return InvokeDynamicSupport.bootstrap("withNumberFormat", $$robo$$android_icu_text_MeasureFormat$withNumberFormat(android.icu.text.NumberFormat ), 0, this, numberFormat);
    }

    private void __constructor__(ULocale uLocale, MeasureFormatData measureFormatData, FormatWidth formatWidth, ImmutableNumberFormat immutableNumberFormat, PluralRules pluralRules, NumericFormatters numericFormatters, ImmutableNumberFormat immutableNumberFormat2, ImmutableNumberFormat immutableNumberFormat3) {
        this.$$robo$$android_icu_text_MeasureFormat$__constructor__(uLocale, measureFormatData, formatWidth, immutableNumberFormat, pluralRules, numericFormatters, immutableNumberFormat2, immutableNumberFormat3);
    }

    private MeasureFormat(ULocale uLocale, MeasureFormatData measureFormatData, FormatWidth formatWidth, ImmutableNumberFormat immutableNumberFormat, PluralRules pluralRules, NumericFormatters numericFormatters, ImmutableNumberFormat immutableNumberFormat2, ImmutableNumberFormat immutableNumberFormat3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat$__constructor__(android.icu.util.ULocale android.icu.text.MeasureFormat$MeasureFormatData android.icu.text.MeasureFormat$FormatWidth android.icu.text.MeasureFormat$ImmutableNumberFormat android.icu.text.PluralRules android.icu.text.MeasureFormat$NumericFormatters android.icu.text.MeasureFormat$ImmutableNumberFormat android.icu.text.MeasureFormat$ImmutableNumberFormat ), 0, this, uLocale, measureFormatData, formatWidth, immutableNumberFormat, pluralRules, numericFormatters, immutableNumberFormat2, immutableNumberFormat3);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_MeasureFormat$__constructor__();
    }

    MeasureFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat$__constructor__(), 0, this);
    }

    private static NumericFormatters loadNumericFormatters(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("loadNumericFormatters", $$robo$$android_icu_text_MeasureFormat$loadNumericFormatters(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static MeasureFormatData loadLocaleData(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("loadLocaleData", $$robo$$android_icu_text_MeasureFormat$loadLocaleData(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static FormatWidth getRegularWidth(FormatWidth formatWidth) {
        return InvokeDynamicSupport.bootstrapStatic("getRegularWidth", $$robo$$android_icu_text_MeasureFormat$getRegularWidth(android.icu.text.MeasureFormat$FormatWidth ), 0, (FormatWidth)formatWidth);
    }

    private String getFormatterOrNull(MeasureUnit measureUnit, FormatWidth formatWidth, int n) {
        return InvokeDynamicSupport.bootstrap("getFormatterOrNull", $$robo$$android_icu_text_MeasureFormat$getFormatterOrNull(android.icu.util.MeasureUnit android.icu.text.MeasureFormat$FormatWidth int ), 0, this, measureUnit, formatWidth, n);
    }

    private String getFormatter(MeasureUnit measureUnit, FormatWidth formatWidth, int n) {
        return InvokeDynamicSupport.bootstrap("getFormatter", $$robo$$android_icu_text_MeasureFormat$getFormatter(android.icu.util.MeasureUnit android.icu.text.MeasureFormat$FormatWidth int ), 0, this, measureUnit, formatWidth, n);
    }

    private String getPluralFormatter(MeasureUnit measureUnit, FormatWidth formatWidth, int n) {
        return InvokeDynamicSupport.bootstrap("getPluralFormatter", $$robo$$android_icu_text_MeasureFormat$getPluralFormatter(android.icu.util.MeasureUnit android.icu.text.MeasureFormat$FormatWidth int ), 0, this, measureUnit, formatWidth, n);
    }

    private String getPerFormatter(FormatWidth formatWidth) {
        return InvokeDynamicSupport.bootstrap("getPerFormatter", $$robo$$android_icu_text_MeasureFormat$getPerFormatter(android.icu.text.MeasureFormat$FormatWidth ), 0, this, formatWidth);
    }

    private int withPerUnitAndAppend(CharSequence charSequence, MeasureUnit measureUnit, StringBuilder stringBuilder) {
        return (int)InvokeDynamicSupport.bootstrap("withPerUnitAndAppend", $$robo$$android_icu_text_MeasureFormat$withPerUnitAndAppend(java.lang.CharSequence android.icu.util.MeasureUnit java.lang.StringBuilder ), 0, this, charSequence, measureUnit, stringBuilder);
    }

    private String formatMeasure(Measure measure, ImmutableNumberFormat immutableNumberFormat) {
        return InvokeDynamicSupport.bootstrap("formatMeasure", $$robo$$android_icu_text_MeasureFormat$formatMeasure(android.icu.util.Measure android.icu.text.MeasureFormat$ImmutableNumberFormat ), 0, this, measure, immutableNumberFormat);
    }

    private StringBuilder formatMeasure(Measure measure, ImmutableNumberFormat immutableNumberFormat, StringBuilder stringBuilder, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("formatMeasure", $$robo$$android_icu_text_MeasureFormat$formatMeasure(android.icu.util.Measure android.icu.text.MeasureFormat$ImmutableNumberFormat java.lang.StringBuilder java.text.FieldPosition ), 0, this, measure, immutableNumberFormat, stringBuilder, fieldPosition);
    }

    Object toTimeUnitProxy() {
        return InvokeDynamicSupport.bootstrap("toTimeUnitProxy", $$robo$$android_icu_text_MeasureFormat$toTimeUnitProxy(), 0, this);
    }

    Object toCurrencyProxy() {
        return InvokeDynamicSupport.bootstrap("toCurrencyProxy", $$robo$$android_icu_text_MeasureFormat$toCurrencyProxy(), 0, this);
    }

    private StringBuilder formatMeasuresSlowTrack(ListFormatter listFormatter, StringBuilder stringBuilder, FieldPosition fieldPosition, Measure ... measureArray) {
        return InvokeDynamicSupport.bootstrap("formatMeasuresSlowTrack", $$robo$$android_icu_text_MeasureFormat$formatMeasuresSlowTrack(android.icu.text.ListFormatter java.lang.StringBuilder java.text.FieldPosition android.icu.util.Measure[] ), 0, this, listFormatter, stringBuilder, fieldPosition, measureArray);
    }

    private static DateFormat loadNumericDurationFormat(ICUResourceBundle iCUResourceBundle, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadNumericDurationFormat", $$robo$$android_icu_text_MeasureFormat$loadNumericDurationFormat(android.icu.impl.ICUResourceBundle java.lang.String ), 0, (ICUResourceBundle)iCUResourceBundle, (String)string2);
    }

    private static Number[] toHMS(Measure[] measureArray) {
        return InvokeDynamicSupport.bootstrapStatic("toHMS", $$robo$$android_icu_text_MeasureFormat$toHMS(android.icu.util.Measure[] ), 0, (Measure[])measureArray);
    }

    private StringBuilder formatNumeric(Number[] numberArray, StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("formatNumeric", $$robo$$android_icu_text_MeasureFormat$formatNumeric(java.lang.Number[] java.lang.StringBuilder ), 0, this, numberArray, stringBuilder);
    }

    private StringBuilder formatNumeric(Date date, DateFormat dateFormat, DateFormat.Field field, Number number, StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("formatNumeric", $$robo$$android_icu_text_MeasureFormat$formatNumeric(java.util.Date android.icu.text.DateFormat android.icu.text.DateFormat$Field java.lang.Number java.lang.StringBuilder ), 0, this, date, dateFormat, field, number, stringBuilder);
    }

    private Object writeReplace() throws ObjectStreamException {
        return InvokeDynamicSupport.bootstrap("writeReplace", $$robo$$android_icu_text_MeasureFormat$writeReplace(), 0, this);
    }

    private static FormatWidth fromFormatWidthOrdinal(int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromFormatWidthOrdinal", $$robo$$android_icu_text_MeasureFormat$fromFormatWidthOrdinal(int ), 0, (int)n);
    }

    @Deprecated
    public static String getRangeFormat(ULocale uLocale, FormatWidth formatWidth) {
        return InvokeDynamicSupport.bootstrapStatic("getRangeFormat", $$robo$$android_icu_text_MeasureFormat$getRangeFormat(android.icu.util.ULocale android.icu.text.MeasureFormat$FormatWidth ), 0, (ULocale)uLocale, (FormatWidth)formatWidth);
    }

    static {
        RobolectricInternals.classInitializing(MeasureFormat.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeasureFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MeasureProxy
    implements Externalizable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = -6033308329886716770L;
        private ULocale locale;
        private FormatWidth formatWidth;
        private NumberFormat numberFormat;
        private int subClass;
        private HashMap<Object, Object> keyValues;

        private void $$robo$$android_icu_text_MeasureFormat_MeasureProxy$__constructor__(ULocale locale, FormatWidth width, NumberFormat numberFormat, int subClass) {
            this.locale = locale;
            this.formatWidth = width;
            this.numberFormat = numberFormat;
            this.subClass = subClass;
            this.keyValues = new HashMap();
        }

        private void $$robo$$android_icu_text_MeasureFormat_MeasureProxy$__constructor__() {
        }

        private final void $$robo$$android_icu_text_MeasureFormat_MeasureProxy$writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeUTF(this.locale.toLanguageTag());
            out.writeByte(this.formatWidth.ordinal());
            out.writeObject(this.numberFormat);
            out.writeByte(this.subClass);
            out.writeObject(this.keyValues);
        }

        private final void $$robo$$android_icu_text_MeasureFormat_MeasureProxy$readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            in.readByte();
            this.locale = ULocale.forLanguageTag(in.readUTF());
            this.formatWidth = MeasureFormat.fromFormatWidthOrdinal(in.readByte() & 0xFF);
            this.numberFormat = (NumberFormat)in.readObject();
            if (this.numberFormat == null) {
                throw new InvalidObjectException("Missing number format.");
            }
            this.subClass = in.readByte() & 0xFF;
            this.keyValues = (HashMap)in.readObject();
            if (this.keyValues == null) {
                throw new InvalidObjectException("Missing optional values map.");
            }
        }

        private final TimeUnitFormat $$robo$$android_icu_text_MeasureFormat_MeasureProxy$createTimeUnitFormat() throws InvalidObjectException {
            int style2;
            if (this.formatWidth == FormatWidth.WIDE) {
                style2 = 0;
            } else if (this.formatWidth == FormatWidth.SHORT) {
                style2 = 1;
            } else {
                throw new InvalidObjectException("Bad width: " + (Object)((Object)this.formatWidth));
            }
            TimeUnitFormat result = new TimeUnitFormat(this.locale, style2);
            result.setNumberFormat(this.numberFormat);
            return result;
        }

        private final Object $$robo$$android_icu_text_MeasureFormat_MeasureProxy$readResolve() throws ObjectStreamException {
            switch (this.subClass) {
                case 0: {
                    return MeasureFormat.getInstance(this.locale, this.formatWidth, this.numberFormat);
                }
                case 1: {
                    return this.createTimeUnitFormat();
                }
                case 2: {
                    return new CurrencyFormat(this.locale);
                }
            }
            throw new InvalidObjectException("Unknown subclass: " + this.subClass);
        }

        private void __constructor__(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat, int n) {
            this.$$robo$$android_icu_text_MeasureFormat_MeasureProxy$__constructor__(uLocale, formatWidth, numberFormat, n);
        }

        public MeasureProxy(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_MeasureProxy$__constructor__(android.icu.util.ULocale android.icu.text.MeasureFormat$FormatWidth android.icu.text.NumberFormat int ), 0, this, uLocale, formatWidth, numberFormat, n);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_MeasureFormat_MeasureProxy$__constructor__();
        }

        public MeasureProxy() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_MeasureProxy$__constructor__(), 0, this);
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            InvokeDynamicSupport.bootstrap("writeExternal", $$robo$$android_icu_text_MeasureFormat_MeasureProxy$writeExternal(java.io.ObjectOutput ), 0, this, objectOutput);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            InvokeDynamicSupport.bootstrap("readExternal", $$robo$$android_icu_text_MeasureFormat_MeasureProxy$readExternal(java.io.ObjectInput ), 0, this, objectInput);
        }

        private TimeUnitFormat createTimeUnitFormat() throws InvalidObjectException {
            return InvokeDynamicSupport.bootstrap("createTimeUnitFormat", $$robo$$android_icu_text_MeasureFormat_MeasureProxy$createTimeUnitFormat(), 0, this);
        }

        private Object readResolve() throws ObjectStreamException {
            return InvokeDynamicSupport.bootstrap("readResolve", $$robo$$android_icu_text_MeasureFormat_MeasureProxy$readResolve(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeasureProxy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PatternData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String prefix;
        String suffix;

        private void $$robo$$android_icu_text_MeasureFormat_PatternData$__constructor__(String pattern) {
            int pos = pattern.indexOf("{0}");
            if (pos < 0) {
                this.prefix = pattern;
                this.suffix = null;
            } else {
                this.prefix = pattern.substring(0, pos);
                this.suffix = pattern.substring(pos + 3);
            }
        }

        private final String $$robo$$android_icu_text_MeasureFormat_PatternData$toString() {
            return this.prefix + "; " + this.suffix;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_MeasureFormat_PatternData$__constructor__(string2);
        }

        public PatternData(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_PatternData$__constructor__(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MeasureFormat_PatternData$toString(), 0, this);
        }

        public /* synthetic */ PatternData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ImmutableNumberFormat
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NumberFormat nf;

        private void $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$__constructor__(NumberFormat nf) {
            this.nf = (NumberFormat)nf.clone();
        }

        private final synchronized NumberFormat $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$get() {
            return (NumberFormat)this.nf.clone();
        }

        private final synchronized StringBuffer $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$format(Number n, StringBuffer buffer, FieldPosition pos) {
            return this.nf.format(n, buffer, pos);
        }

        private final synchronized StringBuffer $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$format(CurrencyAmount n, StringBuffer buffer, FieldPosition pos) {
            return this.nf.format(n, buffer, pos);
        }

        private final synchronized String $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$format(Number number) {
            return this.nf.format(number);
        }

        private final String $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$getPrefix(boolean positive) {
            return positive ? ((DecimalFormat)this.nf).getPositivePrefix() : ((DecimalFormat)this.nf).getNegativePrefix();
        }

        private final String $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$getSuffix(boolean positive) {
            return positive ? ((DecimalFormat)this.nf).getPositiveSuffix() : ((DecimalFormat)this.nf).getPositiveSuffix();
        }

        private void __constructor__(NumberFormat numberFormat) {
            this.$$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$__constructor__(numberFormat);
        }

        public ImmutableNumberFormat(NumberFormat numberFormat) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$__constructor__(android.icu.text.NumberFormat ), 0, this, numberFormat);
        }

        public synchronized NumberFormat get() {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$get(), 0, this);
        }

        public synchronized StringBuffer format(Number number, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$format(java.lang.Number java.lang.StringBuffer java.text.FieldPosition ), 0, this, number, stringBuffer, fieldPosition);
        }

        public synchronized StringBuffer format(CurrencyAmount currencyAmount, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$format(android.icu.util.CurrencyAmount java.lang.StringBuffer java.text.FieldPosition ), 0, this, currencyAmount, stringBuffer, fieldPosition);
        }

        public synchronized String format(Number number) {
            return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$format(java.lang.Number ), 0, this, number);
        }

        public String getPrefix(boolean bl) {
            return InvokeDynamicSupport.bootstrap("getPrefix", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$getPrefix(boolean ), 0, this, bl);
        }

        public String getSuffix(boolean bl) {
            return InvokeDynamicSupport.bootstrap("getSuffix", $$robo$$android_icu_text_MeasureFormat_ImmutableNumberFormat$getSuffix(boolean ), 0, this, bl);
        }

        public /* synthetic */ ImmutableNumberFormat() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImmutableNumberFormat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class MeasureFormatData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int PER_UNIT_INDEX;
        static int PATTERN_COUNT;
        FormatWidth[] widthFallback;
        Map<MeasureUnit, EnumMap<FormatWidth, String[]>> unitToStyleToPatterns;
        EnumMap<FormatWidth, String> styleToPerPattern;

        private void $$robo$$android_icu_text_MeasureFormat_MeasureFormatData$__constructor__() {
            this.widthFallback = new FormatWidth[3];
            this.unitToStyleToPatterns = new HashMap<MeasureUnit, EnumMap<FormatWidth, String[]>>();
            this.styleToPerPattern = new EnumMap(FormatWidth.class);
        }

        private final boolean $$robo$$android_icu_text_MeasureFormat_MeasureFormatData$hasPerFormatter(FormatWidth width) {
            return this.styleToPerPattern.containsKey((Object)width);
        }

        private /* synthetic */ void $$robo$$android_icu_text_MeasureFormat_MeasureFormatData$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            PER_UNIT_INDEX = StandardPlural.COUNT;
            PATTERN_COUNT = PER_UNIT_INDEX + 1;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_MeasureFormat_MeasureFormatData$__constructor__();
        }

        private MeasureFormatData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_MeasureFormatData$__constructor__(), 0, this);
        }

        boolean hasPerFormatter(FormatWidth formatWidth) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPerFormatter", $$robo$$android_icu_text_MeasureFormat_MeasureFormatData$hasPerFormatter(android.icu.text.MeasureFormat$FormatWidth ), 0, this, formatWidth);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_MeasureFormat_MeasureFormatData$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(MeasureFormatData.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeasureFormatData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class UnitDataSink
    extends UResource.TableSink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        UnitPatternSink patternSink;
        UnitSubtypeSink subtypeSink;
        UnitCompoundSink compoundSink;
        UnitTypeSink typeSink;
        MeasureFormatData cacheData;
        FormatWidth width;
        String type;
        MeasureUnit unit;
        StringBuilder sb;

        private void $$robo$$android_icu_text_MeasureFormat_UnitDataSink$__constructor__(MeasureFormatData outputData) {
            this.patternSink = new UnitPatternSink(this);
            this.subtypeSink = new UnitSubtypeSink(this);
            this.compoundSink = new UnitCompoundSink(this);
            this.typeSink = new UnitTypeSink(this);
            this.sb = new StringBuilder();
            this.cacheData = outputData;
        }

        private final void $$robo$$android_icu_text_MeasureFormat_UnitDataSink$put(UResource.Key key, UResource.Value value) {
            if (value.getType() != 3) {
                return;
            }
            FormatWidth sourceWidth = UnitDataSink.widthFromKey(key);
            if (sourceWidth == null) {
                return;
            }
            FormatWidth targetWidth = UnitDataSink.widthFromAlias(value);
            if (targetWidth == null) {
                throw new ICUException("Units data fallback from " + key + " to unknown " + value.getAliasString());
            }
            if (this.cacheData.widthFallback[targetWidth.ordinal()] != null) {
                throw new ICUException("Units data fallback from " + key + " to " + value.getAliasString() + " which falls back to something else");
            }
            this.cacheData.widthFallback[sourceWidth.ordinal()] = targetWidth;
        }

        private final UResource.TableSink $$robo$$android_icu_text_MeasureFormat_UnitDataSink$getOrCreateTableSink(UResource.Key key, int initialSize) {
            this.width = UnitDataSink.widthFromKey(key);
            if (this.width != null) {
                return this.typeSink;
            }
            return null;
        }

        private static final FormatWidth $$robo$$android_icu_text_MeasureFormat_UnitDataSink$widthFromKey(UResource.Key key) {
            if (key.startsWith("units")) {
                if (key.length() == 5) {
                    return FormatWidth.WIDE;
                }
                if (key.regionMatches(5, "Short")) {
                    return FormatWidth.SHORT;
                }
                if (key.regionMatches(5, "Narrow")) {
                    return FormatWidth.NARROW;
                }
            }
            return null;
        }

        private static final FormatWidth $$robo$$android_icu_text_MeasureFormat_UnitDataSink$widthFromAlias(UResource.Value value) {
            String s = value.getAliasString();
            if (s.startsWith("/LOCALE/units")) {
                if (s.length() == 13) {
                    return FormatWidth.WIDE;
                }
                if (s.length() == 18 && s.endsWith("Short")) {
                    return FormatWidth.SHORT;
                }
                if (s.length() == 19 && s.endsWith("Narrow")) {
                    return FormatWidth.NARROW;
                }
            }
            return null;
        }

        private void __constructor__(MeasureFormatData measureFormatData) {
            this.$$robo$$android_icu_text_MeasureFormat_UnitDataSink$__constructor__(measureFormatData);
        }

        UnitDataSink(MeasureFormatData measureFormatData) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_UnitDataSink$__constructor__(android.icu.text.MeasureFormat$MeasureFormatData ), 0, this, measureFormatData);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_MeasureFormat_UnitDataSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
        }

        @Override
        public UResource.TableSink getOrCreateTableSink(UResource.Key key, int n) {
            return InvokeDynamicSupport.bootstrap("getOrCreateTableSink", $$robo$$android_icu_text_MeasureFormat_UnitDataSink$getOrCreateTableSink(android.icu.impl.UResource$Key int ), 0, this, key, n);
        }

        static FormatWidth widthFromKey(UResource.Key key) {
            return InvokeDynamicSupport.bootstrapStatic("widthFromKey", $$robo$$android_icu_text_MeasureFormat_UnitDataSink$widthFromKey(android.icu.impl.UResource$Key ), 0, (UResource.Key)key);
        }

        static FormatWidth widthFromAlias(UResource.Value value) {
            return InvokeDynamicSupport.bootstrapStatic("widthFromAlias", $$robo$$android_icu_text_MeasureFormat_UnitDataSink$widthFromAlias(android.icu.impl.UResource$Value ), 0, (UResource.Value)value);
        }

        public /* synthetic */ UnitDataSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnitDataSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class UnitTypeSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UnitDataSink this$0;

            private void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitTypeSink$__constructor__(UnitDataSink this$0) {
            }

            private final UResource.TableSink $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitTypeSink$getOrCreateTableSink(UResource.Key key, int initialSize) {
                if (!key.contentEquals("currency")) {
                    if (key.contentEquals("compound")) {
                        if (!this.this$0.cacheData.hasPerFormatter(this.this$0.width)) {
                            return this.this$0.compoundSink;
                        }
                    } else {
                        this.this$0.type = key.toString();
                        return this.this$0.subtypeSink;
                    }
                }
                return null;
            }

            private void __constructor__(UnitDataSink unitDataSink) {
                this.$$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitTypeSink$__constructor__(unitDataSink);
            }

            UnitTypeSink(UnitDataSink unitDataSink) {
                this.this$0 = unitDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitTypeSink$__constructor__(android.icu.text.MeasureFormat$UnitDataSink ), 0, this, unitDataSink);
            }

            @Override
            public UResource.TableSink getOrCreateTableSink(UResource.Key key, int n) {
                return InvokeDynamicSupport.bootstrap("getOrCreateTableSink", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitTypeSink$getOrCreateTableSink(android.icu.impl.UResource$Key int ), 0, this, key, n);
            }

            public /* synthetic */ UnitTypeSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnitTypeSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class UnitCompoundSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UnitDataSink this$0;

            private void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitCompoundSink$__constructor__(UnitDataSink this$0) {
            }

            private final void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitCompoundSink$put(UResource.Key key, UResource.Value value) {
                if (key.contentEquals("per")) {
                    this.this$0.cacheData.styleToPerPattern.put(this.this$0.width, SimplePatternFormatter.compileToStringMinMaxPlaceholders(value.getString(), this.this$0.sb, 2, 2));
                }
            }

            private void __constructor__(UnitDataSink unitDataSink) {
                this.$$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitCompoundSink$__constructor__(unitDataSink);
            }

            UnitCompoundSink(UnitDataSink unitDataSink) {
                this.this$0 = unitDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitCompoundSink$__constructor__(android.icu.text.MeasureFormat$UnitDataSink ), 0, this, unitDataSink);
            }

            @Override
            public void put(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitCompoundSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
            }

            public /* synthetic */ UnitCompoundSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnitCompoundSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class UnitSubtypeSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UnitDataSink this$0;

            private void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitSubtypeSink$__constructor__(UnitDataSink this$0) {
            }

            private final UResource.TableSink $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitSubtypeSink$getOrCreateTableSink(UResource.Key key, int initialSize) {
                this.this$0.unit = MeasureUnit.internalGetInstance(this.this$0.type, key.toString());
                this.this$0.patternSink.patterns = null;
                return this.this$0.patternSink;
            }

            private void __constructor__(UnitDataSink unitDataSink) {
                this.$$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitSubtypeSink$__constructor__(unitDataSink);
            }

            UnitSubtypeSink(UnitDataSink unitDataSink) {
                this.this$0 = unitDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitSubtypeSink$__constructor__(android.icu.text.MeasureFormat$UnitDataSink ), 0, this, unitDataSink);
            }

            @Override
            public UResource.TableSink getOrCreateTableSink(UResource.Key key, int n) {
                return InvokeDynamicSupport.bootstrap("getOrCreateTableSink", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitSubtypeSink$getOrCreateTableSink(android.icu.impl.UResource$Key int ), 0, this, key, n);
            }

            public /* synthetic */ UnitSubtypeSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnitSubtypeSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class UnitPatternSink
        extends UResource.TableSink
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            String[] patterns;
            /* synthetic */ UnitDataSink this$0;

            private void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$__constructor__(UnitDataSink this$0) {
            }

            private final void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$setFormatterIfAbsent(int index, UResource.Value value, int minPlaceholders) {
                if (this.patterns == null) {
                    EnumMap<FormatWidth, Object> styleToPatterns = this.this$0.cacheData.unitToStyleToPatterns.get(this.this$0.unit);
                    if (styleToPatterns == null) {
                        styleToPatterns = new EnumMap(FormatWidth.class);
                        this.this$0.cacheData.unitToStyleToPatterns.put(this.this$0.unit, styleToPatterns);
                    } else {
                        this.patterns = styleToPatterns.get((Object)this.this$0.width);
                    }
                    if (this.patterns == null) {
                        this.patterns = new String[MeasureFormatData.PATTERN_COUNT];
                        styleToPatterns.put(this.this$0.width, (String[])this.patterns);
                    }
                }
                if (this.patterns[index] == null) {
                    this.patterns[index] = SimplePatternFormatter.compileToStringMinMaxPlaceholders(value.getString(), this.this$0.sb, minPlaceholders, 1);
                }
            }

            private final void $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$put(UResource.Key key, UResource.Value value) {
                if (!key.contentEquals("dnam")) {
                    if (key.contentEquals("per")) {
                        this.setFormatterIfAbsent(MeasureFormatData.PER_UNIT_INDEX, value, 0);
                    } else {
                        this.setFormatterIfAbsent(StandardPlural.indexFromString(key), value, 0);
                    }
                }
            }

            private void __constructor__(UnitDataSink unitDataSink) {
                this.$$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$__constructor__(unitDataSink);
            }

            UnitPatternSink(UnitDataSink unitDataSink) {
                this.this$0 = unitDataSink;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$__constructor__(android.icu.text.MeasureFormat$UnitDataSink ), 0, this, unitDataSink);
            }

            void setFormatterIfAbsent(int n, UResource.Value value, int n2) {
                InvokeDynamicSupport.bootstrap("setFormatterIfAbsent", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$setFormatterIfAbsent(int android.icu.impl.UResource$Value int ), 0, this, n, value, n2);
            }

            @Override
            public void put(UResource.Key key, UResource.Value value) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_MeasureFormat_UnitDataSink_UnitPatternSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
            }

            public /* synthetic */ UnitPatternSink() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnitPatternSink)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class NumericFormatters
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DateFormat hourMinute;
        private DateFormat minuteSecond;
        private DateFormat hourMinuteSecond;

        private void $$robo$$android_icu_text_MeasureFormat_NumericFormatters$__constructor__(DateFormat hourMinute, DateFormat minuteSecond, DateFormat hourMinuteSecond) {
            this.hourMinute = hourMinute;
            this.minuteSecond = minuteSecond;
            this.hourMinuteSecond = hourMinuteSecond;
        }

        private final DateFormat $$robo$$android_icu_text_MeasureFormat_NumericFormatters$getHourMinute() {
            return this.hourMinute;
        }

        private final DateFormat $$robo$$android_icu_text_MeasureFormat_NumericFormatters$getMinuteSecond() {
            return this.minuteSecond;
        }

        private final DateFormat $$robo$$android_icu_text_MeasureFormat_NumericFormatters$getHourMinuteSecond() {
            return this.hourMinuteSecond;
        }

        private void __constructor__(DateFormat dateFormat, DateFormat dateFormat2, DateFormat dateFormat3) {
            this.$$robo$$android_icu_text_MeasureFormat_NumericFormatters$__constructor__(dateFormat, dateFormat2, dateFormat3);
        }

        public NumericFormatters(DateFormat dateFormat, DateFormat dateFormat2, DateFormat dateFormat3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_NumericFormatters$__constructor__(android.icu.text.DateFormat android.icu.text.DateFormat android.icu.text.DateFormat ), 0, this, dateFormat, dateFormat2, dateFormat3);
        }

        public DateFormat getHourMinute() {
            return InvokeDynamicSupport.bootstrap("getHourMinute", $$robo$$android_icu_text_MeasureFormat_NumericFormatters$getHourMinute(), 0, this);
        }

        public DateFormat getMinuteSecond() {
            return InvokeDynamicSupport.bootstrap("getMinuteSecond", $$robo$$android_icu_text_MeasureFormat_NumericFormatters$getMinuteSecond(), 0, this);
        }

        public DateFormat getHourMinuteSecond() {
            return InvokeDynamicSupport.bootstrap("getHourMinuteSecond", $$robo$$android_icu_text_MeasureFormat_NumericFormatters$getHourMinuteSecond(), 0, this);
        }

        public /* synthetic */ NumericFormatters() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumericFormatters)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class FormatWidth
    extends Enum<FormatWidth> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ FormatWidth WIDE;
        public static /* enum */ FormatWidth SHORT;
        public static /* enum */ FormatWidth NARROW;
        public static /* enum */ FormatWidth NUMERIC;
        private static int INDEX_COUNT = 3;
        private ListFormatter.Style listFormatterStyle;
        private int currencyStyle;
        private static /* synthetic */ FormatWidth[] $VALUES;

        private static final FormatWidth[] $$robo$$android_icu_text_MeasureFormat_FormatWidth$values() {
            return (FormatWidth[])$VALUES.clone();
        }

        private static final FormatWidth $$robo$$android_icu_text_MeasureFormat_FormatWidth$valueOf(String name) {
            return Enum.valueOf(FormatWidth.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_MeasureFormat_FormatWidth$__constructor__(String string2, int n, ListFormatter.Style style2, int currencyStyle) {
            this.listFormatterStyle = style2;
            this.currencyStyle = currencyStyle;
        }

        private final ListFormatter.Style $$robo$$android_icu_text_MeasureFormat_FormatWidth$getListFormatterStyle() {
            return this.listFormatterStyle;
        }

        private final int $$robo$$android_icu_text_MeasureFormat_FormatWidth$getCurrencyStyle() {
            return this.currencyStyle;
        }

        static void __staticInitializer__() {
            WIDE = new FormatWidth(ListFormatter.Style.DURATION, 6);
            SHORT = new FormatWidth(ListFormatter.Style.DURATION_SHORT, 5);
            NARROW = new FormatWidth(ListFormatter.Style.DURATION_NARROW, 1);
            NUMERIC = new FormatWidth(ListFormatter.Style.DURATION_NARROW, 1);
            $VALUES = new FormatWidth[]{WIDE, SHORT, NARROW, NUMERIC};
        }

        public static FormatWidth[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_MeasureFormat_FormatWidth$values(), 0);
        }

        public static FormatWidth valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_MeasureFormat_FormatWidth$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, ListFormatter.Style style2, int n2) {
            this.$$robo$$android_icu_text_MeasureFormat_FormatWidth$__constructor__(string2, n, style2, n2);
        }

        private FormatWidth(ListFormatter.Style style2, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MeasureFormat_FormatWidth$__constructor__(java.lang.String int android.icu.text.ListFormatter$Style int ), 0, this, string2, n, style2, n2);
        }

        ListFormatter.Style getListFormatterStyle() {
            return InvokeDynamicSupport.bootstrap("getListFormatterStyle", $$robo$$android_icu_text_MeasureFormat_FormatWidth$getListFormatterStyle(), 0, this);
        }

        int getCurrencyStyle() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrencyStyle", $$robo$$android_icu_text_MeasureFormat_FormatWidth$getCurrencyStyle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(FormatWidth.class);
        }

        public /* synthetic */ FormatWidth() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FormatWidth)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

