/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.lang.UCharacter;
import android.icu.text.DictionaryBreakEngine;
import android.icu.text.DictionaryData;
import android.icu.text.DictionaryMatcher;
import android.icu.text.UnicodeSet;
import java.io.IOException;
import java.text.CharacterIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KhmerBreakEngine
extends DictionaryBreakEngine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static byte KHMER_LOOKAHEAD = 3;
    private static byte KHMER_ROOT_COMBINE_THRESHOLD = 3;
    private static byte KHMER_PREFIX_COMBINE_THRESHOLD = 3;
    private static byte KHMER_MIN_WORD = 2;
    private static byte KHMER_MIN_WORD_SPAN = 4;
    private DictionaryMatcher fDictionary;
    private static UnicodeSet fKhmerWordSet;
    private static UnicodeSet fEndWordSet;
    private static UnicodeSet fBeginWordSet;
    private static UnicodeSet fMarkSet;

    private void $$robo$$android_icu_text_KhmerBreakEngine$__constructor__() throws IOException {
        this.setCharacters(fKhmerWordSet);
        this.fDictionary = DictionaryData.loadDictionaryFor("Khmr");
    }

    private final boolean $$robo$$android_icu_text_KhmerBreakEngine$equals(Object obj) {
        return obj instanceof KhmerBreakEngine;
    }

    private final int $$robo$$android_icu_text_KhmerBreakEngine$hashCode() {
        return this.getClass().hashCode();
    }

    private final boolean $$robo$$android_icu_text_KhmerBreakEngine$handles(int c, int breakType) {
        if (breakType == 1 || breakType == 2) {
            int script = UCharacter.getIntPropertyValue(c, 4106);
            return script == 23;
        }
        return false;
    }

    private final int $$robo$$android_icu_text_KhmerBreakEngine$divideUpDictionaryRange(CharacterIterator fIter, int rangeStart, int rangeEnd, DictionaryBreakEngine.DequeI foundBreaks) {
        int current;
        if (rangeEnd - rangeStart < 4) {
            return 0;
        }
        int wordsFound = 0;
        DictionaryBreakEngine.PossibleWord[] words = new DictionaryBreakEngine.PossibleWord[3];
        for (int i = 0; i < 3; ++i) {
            words[i] = new DictionaryBreakEngine.PossibleWord();
        }
        fIter.setIndex(rangeStart);
        while ((current = fIter.getIndex()) < rangeEnd) {
            int currPos;
            int wordLength = 0;
            int candidates = words[wordsFound % 3].candidates(fIter, this.fDictionary, rangeEnd);
            if (candidates == 1) {
                wordLength = words[wordsFound % 3].acceptMarked(fIter);
                ++wordsFound;
            } else if (candidates > 1) {
                boolean foundBest = false;
                if (fIter.getIndex() < rangeEnd) {
                    block2: do {
                        int wordsMatched = 1;
                        if (words[(wordsFound + 1) % 3].candidates(fIter, this.fDictionary, rangeEnd) <= 0) continue;
                        if (wordsMatched < 2) {
                            words[wordsFound % 3].markCurrent();
                            wordsMatched = 2;
                        }
                        if (fIter.getIndex() >= rangeEnd) break;
                        do {
                            if (words[(wordsFound + 2) % 3].candidates(fIter, this.fDictionary, rangeEnd) <= 0) continue;
                            words[wordsFound % 3].markCurrent();
                            foundBest = true;
                            continue block2;
                        } while (words[(wordsFound + 1) % 3].backUp(fIter));
                    } while (words[wordsFound % 3].backUp(fIter) && !foundBest);
                }
                wordLength = words[wordsFound % 3].acceptMarked(fIter);
                ++wordsFound;
            }
            if (fIter.getIndex() < rangeEnd && wordLength < 3) {
                if (words[wordsFound % 3].candidates(fIter, this.fDictionary, rangeEnd) <= 0 && (wordLength == 0 || words[wordsFound % 3].longestPrefix() < 3)) {
                    int remaining = rangeEnd - (current + wordLength);
                    char pc = fIter.current();
                    int chars = 0;
                    while (true) {
                        fIter.next();
                        char uc = fIter.current();
                        ++chars;
                        if (--remaining <= 0) break;
                        if (fEndWordSet.contains(pc) && fBeginWordSet.contains(uc)) {
                            int candidate = words[(wordsFound + 1) % 3].candidates(fIter, this.fDictionary, rangeEnd);
                            fIter.setIndex(current + wordLength + chars);
                            if (candidate > 0) break;
                        }
                        pc = uc;
                    }
                    if (wordLength <= 0) {
                        ++wordsFound;
                    }
                    wordLength += chars;
                } else {
                    fIter.setIndex(current + wordLength);
                }
            }
            while ((currPos = fIter.getIndex()) < rangeEnd && fMarkSet.contains(fIter.current())) {
                fIter.next();
                wordLength += fIter.getIndex() - currPos;
            }
            if (wordLength <= 0) continue;
            foundBreaks.push(current + wordLength);
        }
        if (foundBreaks.peek() >= rangeEnd) {
            foundBreaks.pop();
            --wordsFound;
        }
        return wordsFound;
    }

    static void __staticInitializer__() {
        fKhmerWordSet = new UnicodeSet();
        fMarkSet = new UnicodeSet();
        fBeginWordSet = new UnicodeSet();
        fKhmerWordSet.applyPattern("[[:Khmer:]&[:LineBreak=SA:]]");
        fKhmerWordSet.compact();
        fMarkSet.applyPattern("[[:Khmer:]&[:LineBreak=SA:]&[:M:]]");
        fMarkSet.add(32);
        fEndWordSet = new UnicodeSet(fKhmerWordSet);
        fBeginWordSet.add(6016, 6067);
        fEndWordSet.remove(6098);
        fMarkSet.compact();
        fEndWordSet.compact();
        fBeginWordSet.compact();
        fKhmerWordSet.freeze();
        fMarkSet.freeze();
        fEndWordSet.freeze();
        fBeginWordSet.freeze();
    }

    private void __constructor__() throws IOException {
        this.$$robo$$android_icu_text_KhmerBreakEngine$__constructor__();
    }

    public KhmerBreakEngine() throws IOException {
        super(1, 2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_KhmerBreakEngine$__constructor__(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_KhmerBreakEngine$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_KhmerBreakEngine$hashCode(), 0, this);
    }

    @Override
    public boolean handles(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handles", $$robo$$android_icu_text_KhmerBreakEngine$handles(int int ), 0, this, n, n2);
    }

    @Override
    public int divideUpDictionaryRange(CharacterIterator characterIterator, int n, int n2, DictionaryBreakEngine.DequeI dequeI) {
        return (int)InvokeDynamicSupport.bootstrap("divideUpDictionaryRange", $$robo$$android_icu_text_KhmerBreakEngine$divideUpDictionaryRange(java.text.CharacterIterator int int android.icu.text.DictionaryBreakEngine$DequeI ), 0, this, characterIterator, n, n2, dequeI);
    }

    static {
        RobolectricInternals.classInitializing(KhmerBreakEngine.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KhmerBreakEngine)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

