/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.text.DecimalFormat;
import android.icu.text.NumberingSystem;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CompactDecimalDataCache
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String SHORT_STYLE = "short";
    private static String LONG_STYLE = "long";
    private static String NUMBER_ELEMENTS = "NumberElements";
    private static String PATTERN_LONG_PATH = "patternsLong/decimalFormat";
    private static String PATTERNS_SHORT_PATH = "patternsShort/decimalFormat";
    static String OTHER = "other";
    static int MAX_DIGITS = 15;
    private static String LATIN_NUMBERING_SYSTEM = "latn";
    private ICUCache<ULocale, DataBundle> cache;

    private void $$robo$$android_icu_text_CompactDecimalDataCache$__constructor__() {
        this.cache = new SimpleCache<ULocale, DataBundle>();
    }

    private final DataBundle $$robo$$android_icu_text_CompactDecimalDataCache$get(ULocale locale) {
        DataBundle result = this.cache.get(locale);
        if (result == null) {
            result = CompactDecimalDataCache.load(locale);
            this.cache.put(locale, result);
        }
        return result;
    }

    private static final DataBundle $$robo$$android_icu_text_CompactDecimalDataCache$load(ULocale ulocale) {
        ICUResourceBundle bundle;
        NumberingSystem ns = NumberingSystem.getInstance(ulocale);
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", ulocale);
        r = r.getWithFallback("NumberElements");
        String numberingSystemName = ns.getName();
        ICUResourceBundle shortDataBundle = null;
        ICUResourceBundle longDataBundle = null;
        if (!"latn".equals(numberingSystemName)) {
            bundle = CompactDecimalDataCache.findWithFallback(r, numberingSystemName, UResFlags.NOT_ROOT);
            shortDataBundle = CompactDecimalDataCache.findWithFallback(bundle, "patternsShort/decimalFormat", UResFlags.NOT_ROOT);
            longDataBundle = CompactDecimalDataCache.findWithFallback(bundle, "patternsLong/decimalFormat", UResFlags.NOT_ROOT);
        }
        if (shortDataBundle == null) {
            bundle = CompactDecimalDataCache.getWithFallback(r, "latn", UResFlags.ANY);
            shortDataBundle = CompactDecimalDataCache.getWithFallback(bundle, "patternsShort/decimalFormat", UResFlags.ANY);
            if (longDataBundle == null && (longDataBundle = CompactDecimalDataCache.findWithFallback(bundle, "patternsLong/decimalFormat", UResFlags.ANY)) != null && CompactDecimalDataCache.isRoot(longDataBundle) && !CompactDecimalDataCache.isRoot(shortDataBundle)) {
                longDataBundle = null;
            }
        }
        Data shortData = CompactDecimalDataCache.loadStyle(shortDataBundle, ulocale, "short");
        Data longData = longDataBundle == null ? shortData : CompactDecimalDataCache.loadStyle(longDataBundle, ulocale, "long");
        return new DataBundle(shortData, longData);
    }

    private static final ICUResourceBundle $$robo$$android_icu_text_CompactDecimalDataCache$findWithFallback(ICUResourceBundle r, String path, UResFlags flags) {
        if (r == null) {
            return null;
        }
        ICUResourceBundle result = r.findWithFallback(path);
        if (result == null) {
            return null;
        }
        switch (1.$SwitchMap$android$icu$text$CompactDecimalDataCache$UResFlags[flags.ordinal()]) {
            case 1: {
                return CompactDecimalDataCache.isRoot(result) ? null : result;
            }
            case 2: {
                return result;
            }
        }
        throw new IllegalArgumentException();
    }

    private static final ICUResourceBundle $$robo$$android_icu_text_CompactDecimalDataCache$getWithFallback(ICUResourceBundle r, String path, UResFlags flags) {
        ICUResourceBundle result = CompactDecimalDataCache.findWithFallback(r, path, flags);
        if (result == null) {
            throw new MissingResourceException("Cannot find " + path, ICUResourceBundle.class.getName(), path);
        }
        return result;
    }

    private static final boolean $$robo$$android_icu_text_CompactDecimalDataCache$isRoot(ICUResourceBundle r) {
        ULocale bundleLocale = r.getULocale();
        return bundleLocale.equals(ULocale.ROOT) || bundleLocale.toString().equals("root");
    }

    private static final Data $$robo$$android_icu_text_CompactDecimalDataCache$loadStyle(ICUResourceBundle r, ULocale locale, String style2) {
        int size = r.getSize();
        Data result = new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>());
        for (int i = 0; i < size; ++i) {
            CompactDecimalDataCache.populateData(r.get(i), locale, style2, result);
        }
        CompactDecimalDataCache.fillInMissing(result);
        return result;
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$populateData(UResourceBundle divisorData, ULocale locale, String style2, Data result) {
        long magnitude = Long.parseLong(divisorData.getKey());
        int thisIndex = (int)Math.log10(magnitude);
        if (thisIndex >= 15) {
            return;
        }
        int size = divisorData.getSize();
        int numZeros = 0;
        boolean otherVariantDefined = false;
        for (int i = 0; i < size; ++i) {
            int nz;
            UResourceBundle pluralVariantData = divisorData.get(i);
            String pluralVariant = pluralVariantData.getKey();
            String template = pluralVariantData.getString();
            if (pluralVariant.equals("other")) {
                otherVariantDefined = true;
            }
            if ((nz = CompactDecimalDataCache.populatePrefixSuffix(pluralVariant, thisIndex, template, locale, style2, result)) == numZeros) continue;
            if (numZeros != 0) {
                throw new IllegalArgumentException("Plural variant '" + pluralVariant + "' template '" + template + "' for 10^" + thisIndex + " has wrong number of zeros in " + CompactDecimalDataCache.localeAndStyle(locale, style2));
            }
            numZeros = nz;
        }
        if (!otherVariantDefined) {
            throw new IllegalArgumentException("No 'other' plural variant defined for 10^" + thisIndex + "in " + CompactDecimalDataCache.localeAndStyle(locale, style2));
        }
        long divisor = magnitude;
        for (int i = 1; i < numZeros; ++i) {
            divisor /= 10L;
        }
        result.divisors[thisIndex] = divisor;
    }

    private static final int $$robo$$android_icu_text_CompactDecimalDataCache$populatePrefixSuffix(String pluralVariant, int idx, String template, ULocale locale, String style2, Data result) {
        int i;
        int firstIdx = template.indexOf("0");
        int lastIdx = template.lastIndexOf("0");
        if (firstIdx == -1) {
            throw new IllegalArgumentException("Expect at least one zero in template '" + template + "' for variant '" + pluralVariant + "' for 10^" + idx + " in " + CompactDecimalDataCache.localeAndStyle(locale, style2));
        }
        String prefix = CompactDecimalDataCache.fixQuotes(template.substring(0, firstIdx));
        String suffix = CompactDecimalDataCache.fixQuotes(template.substring(lastIdx + 1));
        CompactDecimalDataCache.saveUnit(new DecimalFormat.Unit(prefix, suffix), pluralVariant, idx, result.units);
        if (prefix.trim().length() == 0 && suffix.trim().length() == 0) {
            return idx + 1;
        }
        for (i = firstIdx + 1; i <= lastIdx && template.charAt(i) == '0'; ++i) {
        }
        return i - firstIdx;
    }

    private static final String $$robo$$android_icu_text_CompactDecimalDataCache$fixQuotes(String prefixOrSuffix) {
        StringBuilder result = new StringBuilder();
        int len = prefixOrSuffix.length();
        QuoteState state = QuoteState.OUTSIDE;
        block4: for (int idx = 0; idx < len; ++idx) {
            char ch = prefixOrSuffix.charAt(idx);
            if (ch == '\'') {
                if (state == QuoteState.INSIDE_EMPTY) {
                    result.append('\'');
                }
            } else {
                result.append(ch);
            }
            switch (1.$SwitchMap$android$icu$text$CompactDecimalDataCache$QuoteState[state.ordinal()]) {
                case 1: {
                    state = ch == '\'' ? QuoteState.INSIDE_EMPTY : QuoteState.OUTSIDE;
                    continue block4;
                }
                case 2: 
                case 3: {
                    state = ch == '\'' ? QuoteState.OUTSIDE : QuoteState.INSIDE_FULL;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return result.toString();
    }

    private static final String $$robo$$android_icu_text_CompactDecimalDataCache$localeAndStyle(ULocale locale, String style2) {
        return "locale '" + locale + "' style '" + style2 + "'";
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$fillInMissing(Data result) {
        long lastDivisor = 1L;
        for (int i = 0; i < result.divisors.length; ++i) {
            if (result.units.get("other")[i] == null) {
                result.divisors[i] = lastDivisor;
                CompactDecimalDataCache.copyFromPreviousIndex(i, result.units);
                continue;
            }
            lastDivisor = result.divisors[i];
            CompactDecimalDataCache.propagateOtherToMissing(i, result.units);
        }
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$propagateOtherToMissing(int idx, Map<String, DecimalFormat.Unit[]> units) {
        DecimalFormat.Unit otherVariantValue = units.get("other")[idx];
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (byBase[idx] != null) continue;
            byBase[idx] = otherVariantValue;
        }
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$copyFromPreviousIndex(int idx, Map<String, DecimalFormat.Unit[]> units) {
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (idx == 0) {
                byBase[idx] = DecimalFormat.NULL_UNIT;
                continue;
            }
            byBase[idx] = byBase[idx - 1];
        }
    }

    private static final void $$robo$$android_icu_text_CompactDecimalDataCache$saveUnit(DecimalFormat.Unit unit, String pluralVariant, int idx, Map<String, DecimalFormat.Unit[]> units) {
        DecimalFormat.Unit[] byBase = units.get(pluralVariant);
        if (byBase == null) {
            byBase = new DecimalFormat.Unit[15];
            units.put(pluralVariant, byBase);
        }
        byBase[idx] = unit;
    }

    private static final DecimalFormat.Unit $$robo$$android_icu_text_CompactDecimalDataCache$getUnit(Map<String, DecimalFormat.Unit[]> units, String variant, int base) {
        DecimalFormat.Unit[] byBase = units.get(variant);
        if (byBase == null) {
            byBase = units.get("other");
        }
        return byBase[base];
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_CompactDecimalDataCache$__constructor__();
    }

    CompactDecimalDataCache() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache$__constructor__(), 0, this);
    }

    DataBundle get(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_CompactDecimalDataCache$get(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private static DataBundle load(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("load", $$robo$$android_icu_text_CompactDecimalDataCache$load(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static ICUResourceBundle findWithFallback(ICUResourceBundle iCUResourceBundle, String string2, UResFlags uResFlags) {
        return InvokeDynamicSupport.bootstrapStatic("findWithFallback", $$robo$$android_icu_text_CompactDecimalDataCache$findWithFallback(android.icu.impl.ICUResourceBundle java.lang.String android.icu.text.CompactDecimalDataCache$UResFlags ), 0, (ICUResourceBundle)iCUResourceBundle, (String)string2, (UResFlags)uResFlags);
    }

    private static ICUResourceBundle getWithFallback(ICUResourceBundle iCUResourceBundle, String string2, UResFlags uResFlags) {
        return InvokeDynamicSupport.bootstrapStatic("getWithFallback", $$robo$$android_icu_text_CompactDecimalDataCache$getWithFallback(android.icu.impl.ICUResourceBundle java.lang.String android.icu.text.CompactDecimalDataCache$UResFlags ), 0, (ICUResourceBundle)iCUResourceBundle, (String)string2, (UResFlags)uResFlags);
    }

    private static boolean isRoot(ICUResourceBundle iCUResourceBundle) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRoot", $$robo$$android_icu_text_CompactDecimalDataCache$isRoot(android.icu.impl.ICUResourceBundle ), 0, (ICUResourceBundle)iCUResourceBundle);
    }

    private static Data loadStyle(ICUResourceBundle iCUResourceBundle, ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadStyle", $$robo$$android_icu_text_CompactDecimalDataCache$loadStyle(android.icu.impl.ICUResourceBundle android.icu.util.ULocale java.lang.String ), 0, (ICUResourceBundle)iCUResourceBundle, (ULocale)uLocale, (String)string2);
    }

    private static void populateData(UResourceBundle uResourceBundle, ULocale uLocale, String string2, Data data) {
        InvokeDynamicSupport.bootstrapStatic("populateData", $$robo$$android_icu_text_CompactDecimalDataCache$populateData(android.icu.util.UResourceBundle android.icu.util.ULocale java.lang.String android.icu.text.CompactDecimalDataCache$Data ), 0, (UResourceBundle)uResourceBundle, (ULocale)uLocale, (String)string2, (Data)data);
    }

    private static int populatePrefixSuffix(String string2, int n, String string3, ULocale uLocale, String string4, Data data) {
        return (int)InvokeDynamicSupport.bootstrapStatic("populatePrefixSuffix", $$robo$$android_icu_text_CompactDecimalDataCache$populatePrefixSuffix(java.lang.String int java.lang.String android.icu.util.ULocale java.lang.String android.icu.text.CompactDecimalDataCache$Data ), 0, (String)string2, (int)n, (String)string3, (ULocale)uLocale, (String)string4, (Data)data);
    }

    private static String fixQuotes(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fixQuotes", $$robo$$android_icu_text_CompactDecimalDataCache$fixQuotes(java.lang.String ), 0, (String)string2);
    }

    private static String localeAndStyle(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("localeAndStyle", $$robo$$android_icu_text_CompactDecimalDataCache$localeAndStyle(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    private static void fillInMissing(Data data) {
        InvokeDynamicSupport.bootstrapStatic("fillInMissing", $$robo$$android_icu_text_CompactDecimalDataCache$fillInMissing(android.icu.text.CompactDecimalDataCache$Data ), 0, (Data)data);
    }

    private static void propagateOtherToMissing(int n, Map<String, DecimalFormat.Unit[]> map) {
        InvokeDynamicSupport.bootstrapStatic("propagateOtherToMissing", $$robo$$android_icu_text_CompactDecimalDataCache$propagateOtherToMissing(int java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, (int)n, map);
    }

    private static void copyFromPreviousIndex(int n, Map<String, DecimalFormat.Unit[]> map) {
        InvokeDynamicSupport.bootstrapStatic("copyFromPreviousIndex", $$robo$$android_icu_text_CompactDecimalDataCache$copyFromPreviousIndex(int java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, (int)n, map);
    }

    private static void saveUnit(DecimalFormat.Unit unit, String string2, int n, Map<String, DecimalFormat.Unit[]> map) {
        InvokeDynamicSupport.bootstrapStatic("saveUnit", $$robo$$android_icu_text_CompactDecimalDataCache$saveUnit(android.icu.text.DecimalFormat$Unit java.lang.String int java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, (DecimalFormat.Unit)unit, (String)string2, (int)n, map);
    }

    static DecimalFormat.Unit getUnit(Map<String, DecimalFormat.Unit[]> map, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUnit", $$robo$$android_icu_text_CompactDecimalDataCache$getUnit(java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> java.lang.String int ), 0, map, (String)string2, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompactDecimalDataCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class UResFlags
    extends Enum<UResFlags> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ UResFlags ANY;
        public static /* enum */ UResFlags NOT_ROOT;
        private static /* synthetic */ UResFlags[] $VALUES;

        private static final UResFlags[] $$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$values() {
            return (UResFlags[])$VALUES.clone();
        }

        private static final UResFlags $$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$valueOf(String name) {
            return Enum.valueOf(UResFlags.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ANY = new UResFlags();
            NOT_ROOT = new UResFlags();
            $VALUES = new UResFlags[]{ANY, NOT_ROOT};
        }

        public static UResFlags[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$values(), 0);
        }

        public static UResFlags valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$__constructor__(string2, n);
        }

        private UResFlags() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_UResFlags$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(UResFlags.class);
        }

        public /* synthetic */ UResFlags() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UResFlags)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class QuoteState
    extends Enum<QuoteState> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ QuoteState OUTSIDE;
        public static /* enum */ QuoteState INSIDE_EMPTY;
        public static /* enum */ QuoteState INSIDE_FULL;
        private static /* synthetic */ QuoteState[] $VALUES;

        private static final QuoteState[] $$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$values() {
            return (QuoteState[])$VALUES.clone();
        }

        private static final QuoteState $$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$valueOf(String name) {
            return Enum.valueOf(QuoteState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            OUTSIDE = new QuoteState();
            INSIDE_EMPTY = new QuoteState();
            INSIDE_FULL = new QuoteState();
            $VALUES = new QuoteState[]{OUTSIDE, INSIDE_EMPTY, INSIDE_FULL};
        }

        public static QuoteState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$values(), 0);
        }

        public static QuoteState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$__constructor__(string2, n);
        }

        private QuoteState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_QuoteState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(QuoteState.class);
        }

        public /* synthetic */ QuoteState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QuoteState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DataBundle
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Data shortData;
        Data longData;

        private void $$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$__constructor__(Data shortData, Data longData) {
            this.shortData = shortData;
            this.longData = longData;
        }

        private void __constructor__(Data data, Data data2) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$__constructor__(data, data2);
        }

        DataBundle(Data data, Data data2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_DataBundle$__constructor__(android.icu.text.CompactDecimalDataCache$Data android.icu.text.CompactDecimalDataCache$Data ), 0, this, data, data2);
        }

        public /* synthetic */ DataBundle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataBundle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Data
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long[] divisors;
        Map<String, DecimalFormat.Unit[]> units;

        private void $$robo$$android_icu_text_CompactDecimalDataCache_Data$__constructor__(long[] divisors, Map<String, DecimalFormat.Unit[]> units) {
            this.divisors = divisors;
            this.units = units;
        }

        private void __constructor__(long[] lArray, Map<String, DecimalFormat.Unit[]> map) {
            this.$$robo$$android_icu_text_CompactDecimalDataCache_Data$__constructor__(lArray, map);
        }

        Data(long[] lArray, Map<String, DecimalFormat.Unit[]> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_CompactDecimalDataCache_Data$__constructor__(long[] java.util.Map<java.lang.String, android.icu.text.DecimalFormat$Unit[]> ), 0, this, lArray, map);
        }

        public /* synthetic */ Data() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Data)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

