/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.Trie2;
import android.icu.impl.coll.Collation;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.UTF16CollationIterator;
import android.icu.text.UnicodeSet;
import android.icu.util.CharsTrie;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ContractionsAndExpansions
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CollationData data;
    private UnicodeSet contractions;
    private UnicodeSet expansions;
    private CESink sink;
    private boolean addPrefixes;
    private int checkTailored;
    private UnicodeSet tailored;
    private UnicodeSet ranges;
    private StringBuilder unreversedPrefix;
    private String suffix;
    private long[] ces;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$__constructor__(UnicodeSet con, UnicodeSet exp, CESink s, boolean prefixes) {
        this.checkTailored = 0;
        this.tailored = new UnicodeSet();
        this.unreversedPrefix = new StringBuilder();
        this.ces = new long[31];
        this.contractions = con;
        this.expansions = exp;
        this.sink = s;
        this.addPrefixes = prefixes;
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$forData(CollationData d) {
        if (d.base != null) {
            this.checkTailored = -1;
        }
        this.data = d;
        for (Trie2.Range range : this.data.trie) {
            if (range.leadSurrogate) break;
            this.enumCnERange(range.startCodePoint, range.endCodePoint, range.value, this);
        }
        if (d.base == null) {
            return;
        }
        this.tailored.freeze();
        this.checkTailored = 1;
        this.data = d.base;
        for (Trie2.Range range : this.data.trie) {
            if (range.leadSurrogate) break;
            this.enumCnERange(range.startCodePoint, range.endCodePoint, range.value, this);
        }
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$enumCnERange(int start, int end, int ce32, ContractionsAndExpansions cne) {
        if (cne.checkTailored != 0) {
            if (cne.checkTailored < 0) {
                if (ce32 == 192) {
                    return;
                }
                cne.tailored.add(start, end);
            } else if (start == end) {
                if (cne.tailored.contains(start)) {
                    return;
                }
            } else if (cne.tailored.containsSome(start, end)) {
                if (cne.ranges == null) {
                    cne.ranges = new UnicodeSet();
                }
                cne.ranges.set(start, end).removeAll(cne.tailored);
                int count = cne.ranges.getRangeCount();
                for (int i = 0; i < count; ++i) {
                    cne.handleCE32(cne.ranges.getRangeStart(i), cne.ranges.getRangeEnd(i), ce32);
                }
            }
        }
        cne.handleCE32(start, end, ce32);
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$forCodePoint(CollationData d, int c) {
        int ce32 = d.getCE32(c);
        if (ce32 == 192) {
            d = d.base;
            ce32 = d.getCE32(c);
        }
        this.data = d;
        this.handleCE32(c, c, ce32);
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$handleCE32(int start, int end, int ce32) {
        while (true) {
            if ((ce32 & 0xFF) < 192) {
                if (this.sink != null) {
                    this.sink.handleCE(Collation.ceFromSimpleCE32(ce32));
                }
                return;
            }
            switch (Collation.tagFromCE32(ce32)) {
                case 0: {
                    return;
                }
                case 3: 
                case 7: 
                case 13: {
                    throw new AssertionError((Object)String.format("Unexpected CE32 tag type %d for ce32=0x%08x", Collation.tagFromCE32(ce32), ce32));
                }
                case 1: {
                    if (this.sink != null) {
                        this.sink.handleCE(Collation.ceFromLongPrimaryCE32(ce32));
                    }
                    return;
                }
                case 2: {
                    if (this.sink != null) {
                        this.sink.handleCE(Collation.ceFromLongSecondaryCE32(ce32));
                    }
                    return;
                }
                case 4: {
                    if (this.sink != null) {
                        this.ces[0] = Collation.latinCE0FromCE32(ce32);
                        this.ces[1] = Collation.latinCE1FromCE32(ce32);
                        this.sink.handleExpansion(this.ces, 0, 2);
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(start, end);
                    }
                    return;
                }
                case 5: {
                    if (this.sink != null) {
                        int idx = Collation.indexFromCE32(ce32);
                        int length = Collation.lengthFromCE32(ce32);
                        for (int i = 0; i < length; ++i) {
                            this.ces[i] = Collation.ceFromCE32(this.data.ce32s[idx + i]);
                        }
                        this.sink.handleExpansion(this.ces, 0, length);
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(start, end);
                    }
                    return;
                }
                case 6: {
                    if (this.sink != null) {
                        int idx = Collation.indexFromCE32(ce32);
                        int length = Collation.lengthFromCE32(ce32);
                        this.sink.handleExpansion(this.data.ces, idx, length);
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(start, end);
                    }
                    return;
                }
                case 8: {
                    this.handlePrefixes(start, end, ce32);
                    return;
                }
                case 9: {
                    this.handleContractions(start, end, ce32);
                    return;
                }
                case 10: {
                    ce32 = this.data.ce32s[Collation.indexFromCE32(ce32)];
                    break;
                }
                case 11: {
                    if (!($assertionsDisabled || start == 0 && end == 0)) {
                        throw new AssertionError();
                    }
                    ce32 = this.data.ce32s[0];
                    break;
                }
                case 12: {
                    if (this.sink != null) {
                        UTF16CollationIterator iter = new UTF16CollationIterator(this.data);
                        StringBuilder hangul = new StringBuilder(1);
                        for (int c = start; c <= end; ++c) {
                            hangul.setLength(0);
                            hangul.appendCodePoint(c);
                            iter.setText(false, hangul, 0);
                            int length = iter.fetchCEs();
                            if (!($assertionsDisabled || length >= 2 && iter.getCE(length - 1) == 0x101000100L)) {
                                throw new AssertionError();
                            }
                            this.sink.handleExpansion(iter.getCEs(), 0, length - 1);
                        }
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(start, end);
                    }
                    return;
                }
                case 14: {
                    return;
                }
                case 15: {
                    return;
                }
            }
        }
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$handlePrefixes(int start, int end, int ce32) {
        int index = Collation.indexFromCE32(ce32);
        ce32 = this.data.getCE32FromContexts(index);
        this.handleCE32(start, end, ce32);
        if (!this.addPrefixes) {
            return;
        }
        for (Object e : new CharsTrie(this.data.contexts, index + 2)) {
            this.setPrefix(((CharsTrie.Entry)e).chars);
            this.addStrings(start, end, this.contractions);
            this.addStrings(start, end, this.expansions);
            this.handleCE32(start, end, ((CharsTrie.Entry)e).value);
        }
        this.resetPrefix();
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$handleContractions(int start, int end, int ce32) {
        int index = Collation.indexFromCE32(ce32);
        if ((ce32 & 0x100) != 0) {
            if (!$assertionsDisabled && this.unreversedPrefix.length() == 0) {
                throw new AssertionError();
            }
        } else {
            ce32 = this.data.getCE32FromContexts(index);
            if (!$assertionsDisabled && Collation.isContractionCE32(ce32)) {
                throw new AssertionError();
            }
            this.handleCE32(start, end, ce32);
        }
        for (Object e : new CharsTrie(this.data.contexts, index + 2)) {
            this.suffix = ((CharsTrie.Entry)e).chars.toString();
            this.addStrings(start, end, this.contractions);
            if (this.unreversedPrefix.length() != 0) {
                this.addStrings(start, end, this.expansions);
            }
            this.handleCE32(start, end, ((CharsTrie.Entry)e).value);
        }
        this.suffix = null;
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$addExpansions(int start, int end) {
        if (this.unreversedPrefix.length() == 0 && this.suffix == null) {
            if (this.expansions != null) {
                this.expansions.add(start, end);
            }
        } else {
            this.addStrings(start, end, this.expansions);
        }
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$addStrings(int start, int end, UnicodeSet set) {
        if (set == null) {
            return;
        }
        StringBuilder s = new StringBuilder(this.unreversedPrefix);
        do {
            s.appendCodePoint(start);
            if (this.suffix != null) {
                s.append(this.suffix);
            }
            set.add(s);
            s.setLength(this.unreversedPrefix.length());
        } while (++start <= end);
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$setPrefix(CharSequence pfx) {
        this.unreversedPrefix.setLength(0);
        this.unreversedPrefix.append(pfx).reverse();
    }

    private final void $$robo$$android_icu_impl_coll_ContractionsAndExpansions$resetPrefix() {
        this.unreversedPrefix.setLength(0);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !ContractionsAndExpansions.class.desiredAssertionStatus();
    }

    private void __constructor__(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, CESink cESink, boolean bl) {
        this.$$robo$$android_icu_impl_coll_ContractionsAndExpansions$__constructor__(unicodeSet, unicodeSet2, cESink, bl);
    }

    public ContractionsAndExpansions(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, CESink cESink, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$__constructor__(android.icu.text.UnicodeSet android.icu.text.UnicodeSet android.icu.impl.coll.ContractionsAndExpansions$CESink boolean ), 0, this, unicodeSet, unicodeSet2, cESink, bl);
    }

    public void forData(CollationData collationData) {
        InvokeDynamicSupport.bootstrap("forData", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$forData(android.icu.impl.coll.CollationData ), 0, this, collationData);
    }

    private void enumCnERange(int n, int n2, int n3, ContractionsAndExpansions contractionsAndExpansions) {
        InvokeDynamicSupport.bootstrap("enumCnERange", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$enumCnERange(int int int android.icu.impl.coll.ContractionsAndExpansions ), 0, this, n, n2, n3, contractionsAndExpansions);
    }

    public void forCodePoint(CollationData collationData, int n) {
        InvokeDynamicSupport.bootstrap("forCodePoint", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$forCodePoint(android.icu.impl.coll.CollationData int ), 0, this, collationData, n);
    }

    private void handleCE32(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("handleCE32", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$handleCE32(int int int ), 0, this, n, n2, n3);
    }

    private void handlePrefixes(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("handlePrefixes", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$handlePrefixes(int int int ), 0, this, n, n2, n3);
    }

    void handleContractions(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("handleContractions", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$handleContractions(int int int ), 0, this, n, n2, n3);
    }

    void addExpansions(int n, int n2) {
        InvokeDynamicSupport.bootstrap("addExpansions", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$addExpansions(int int ), 0, this, n, n2);
    }

    void addStrings(int n, int n2, UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addStrings", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$addStrings(int int android.icu.text.UnicodeSet ), 0, this, n, n2, unicodeSet);
    }

    private void setPrefix(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setPrefix", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$setPrefix(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void resetPrefix() {
        InvokeDynamicSupport.bootstrap("resetPrefix", $$robo$$android_icu_impl_coll_ContractionsAndExpansions$resetPrefix(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ContractionsAndExpansions.class);
    }

    public /* synthetic */ ContractionsAndExpansions() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContractionsAndExpansions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface CESink
    extends InstrumentedInterface {
        public void handleCE(long var1);

        public void handleExpansion(long[] var1, int var2, int var3);
    }
}

