/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.SharedObject;
import android.icu.impl.coll.UVector32;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CollationSettings
extends SharedObject
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int CHECK_FCD = 1;
    public static int NUMERIC = 2;
    static int SHIFTED = 4;
    static int ALTERNATE_MASK = 12;
    static int MAX_VARIABLE_SHIFT = 4;
    static int MAX_VARIABLE_MASK = 112;
    static int UPPER_FIRST = 256;
    public static int CASE_FIRST = 512;
    public static int CASE_FIRST_AND_UPPER_MASK = 768;
    public static int CASE_LEVEL = 1024;
    public static int BACKWARD_SECONDARY = 2048;
    static int STRENGTH_SHIFT = 12;
    static int STRENGTH_MASK = 61440;
    static int MAX_VAR_SPACE = 0;
    static int MAX_VAR_PUNCT = 1;
    static int MAX_VAR_SYMBOL = 2;
    static int MAX_VAR_CURRENCY = 3;
    public int options;
    public long variableTop;
    public byte[] reorderTable;
    long minHighNoReorder;
    long[] reorderRanges;
    public int[] reorderCodes;
    private static int[] EMPTY_INT_ARRAY;
    public int fastLatinOptions;
    public char[] fastLatinPrimaries;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_CollationSettings$__constructor__() {
        this.options = 8208;
        this.reorderCodes = EMPTY_INT_ARRAY;
        this.fastLatinOptions = -1;
        this.fastLatinPrimaries = new char[384];
    }

    private final CollationSettings $$robo$$android_icu_impl_coll_CollationSettings$clone() {
        CollationSettings newSettings = (CollationSettings)super.clone();
        newSettings.fastLatinPrimaries = (char[])this.fastLatinPrimaries.clone();
        return newSettings;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        CollationSettings o = (CollationSettings)other;
        if (this.options != o.options) {
            return false;
        }
        if ((this.options & 0xC) != 0 && this.variableTop != o.variableTop) {
            return false;
        }
        return Arrays.equals(this.reorderCodes, o.reorderCodes);
    }

    private final int $$robo$$android_icu_impl_coll_CollationSettings$hashCode() {
        int h = this.options << 8;
        if ((this.options & 0xC) != 0) {
            h = (int)((long)h ^ this.variableTop);
        }
        h ^= this.reorderCodes.length;
        for (int i = 0; i < this.reorderCodes.length; ++i) {
            h ^= this.reorderCodes[i] << i;
        }
        return h;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$resetReordering() {
        this.reorderTable = null;
        this.minHighNoReorder = 0L;
        this.reorderRanges = null;
        this.reorderCodes = EMPTY_INT_ARRAY;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$aliasReordering(CollationData data, int[] codesAndRanges, int codesLength, byte[] table) {
        int[] codes;
        if (codesLength == codesAndRanges.length) {
            codes = codesAndRanges;
        } else {
            codes = new int[codesLength];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])codesAndRanges, (int)0, (int[])codes, (int)0, (int)codesLength);
        }
        int rangesStart = codesLength;
        int rangesLimit = codesAndRanges.length;
        int rangesLength = rangesLimit - rangesStart;
        if (table != null && (rangesLength == 0 ? !CollationSettings.reorderTableHasSplitBytes(table) : rangesLength >= 2 && (codesAndRanges[rangesStart] & 0xFFFF) == 0 && (codesAndRanges[rangesLimit - 1] & 0xFFFF) != 0)) {
            int firstSplitByteRangeIndex;
            this.reorderTable = table;
            this.reorderCodes = codes;
            for (firstSplitByteRangeIndex = rangesStart; firstSplitByteRangeIndex < rangesLimit && (codesAndRanges[firstSplitByteRangeIndex] & 0xFF0000) == 0; ++firstSplitByteRangeIndex) {
            }
            if (firstSplitByteRangeIndex == rangesLimit) {
                if (!$assertionsDisabled && CollationSettings.reorderTableHasSplitBytes(table)) {
                    throw new AssertionError();
                }
                this.minHighNoReorder = 0L;
                this.reorderRanges = null;
            } else {
                if (!$assertionsDisabled && table[codesAndRanges[firstSplitByteRangeIndex] >>> 24] != 0) {
                    throw new AssertionError();
                }
                this.minHighNoReorder = (long)codesAndRanges[rangesLimit - 1] & 0xFFFF0000L;
                this.setReorderRanges(codesAndRanges, firstSplitByteRangeIndex, rangesLimit - firstSplitByteRangeIndex);
            }
            return;
        }
        this.setReordering(data, codes);
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setReordering(CollationData data, int[] codes) {
        int rangesStart;
        if (codes.length == 0 || codes.length == 1 && codes[0] == 103) {
            this.resetReordering();
            return;
        }
        UVector32 rangesList = new UVector32();
        data.makeReorderRanges(codes, rangesList);
        int rangesLength = rangesList.size();
        if (rangesLength == 0) {
            this.resetReordering();
            return;
        }
        int[] ranges = rangesList.getBuffer();
        if (!$assertionsDisabled && rangesLength < 2) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || (ranges[0] & 0xFFFF) == 0 && (ranges[rangesLength - 1] & 0xFFFF) != 0)) {
            throw new AssertionError();
        }
        this.minHighNoReorder = (long)ranges[rangesLength - 1] & 0xFFFF0000L;
        byte[] table = new byte[256];
        int b = 0;
        int firstSplitByteRangeIndex = -1;
        for (int i = 0; i < rangesLength; ++i) {
            int pair = ranges[i];
            int limit1 = pair >>> 24;
            while (b < limit1) {
                table[b] = (byte)(b + pair);
                ++b;
            }
            if ((pair & 0xFF0000) == 0) continue;
            table[limit1] = 0;
            b = limit1 + 1;
            if (firstSplitByteRangeIndex >= 0) continue;
            firstSplitByteRangeIndex = i;
        }
        while (b <= 255) {
            table[b] = (byte)b;
            ++b;
        }
        if (firstSplitByteRangeIndex < 0) {
            rangesLength = 0;
            rangesStart = 0;
        } else {
            rangesStart = firstSplitByteRangeIndex;
            rangesLength -= firstSplitByteRangeIndex;
        }
        this.setReorderArrays(codes, ranges, rangesStart, rangesLength, table);
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setReorderArrays(int[] codes, int[] ranges, int rangesStart, int rangesLength, byte[] table) {
        if (codes == null) {
            codes = EMPTY_INT_ARRAY;
        }
        if (!$assertionsDisabled && codes.length == 0 != (table == null)) {
            throw new AssertionError();
        }
        this.reorderTable = table;
        this.reorderCodes = codes;
        this.setReorderRanges(ranges, rangesStart, rangesLength);
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setReorderRanges(int[] ranges, int rangesStart, int rangesLength) {
        if (rangesLength == 0) {
            this.reorderRanges = null;
        } else {
            this.reorderRanges = new long[rangesLength];
            int i = 0;
            do {
                this.reorderRanges[i++] = (long)ranges[rangesStart++] & 0xFFFFFFFFL;
            } while (i < rangesLength);
        }
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$copyReorderingFrom(CollationSettings other) {
        if (!other.hasReordering()) {
            this.resetReordering();
            return;
        }
        this.minHighNoReorder = other.minHighNoReorder;
        this.reorderTable = other.reorderTable;
        this.reorderRanges = other.reorderRanges;
        this.reorderCodes = other.reorderCodes;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$hasReordering() {
        return this.reorderTable != null;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationSettings$reorderTableHasSplitBytes(byte[] table) {
        if (!$assertionsDisabled && table[0] != 0) {
            throw new AssertionError();
        }
        for (int i = 1; i < 256; ++i) {
            if (table[i] != 0) continue;
            return true;
        }
        return false;
    }

    private final long $$robo$$android_icu_impl_coll_CollationSettings$reorder(long p) {
        byte b = this.reorderTable[(int)p >>> 24];
        if (b != 0 || p <= 1L) {
            return ((long)b & 0xFFL) << 24 | p & 0xFFFFFFL;
        }
        return this.reorderEx(p);
    }

    private final long $$robo$$android_icu_impl_coll_CollationSettings$reorderEx(long p) {
        long r;
        if (!$assertionsDisabled && this.minHighNoReorder <= 0L) {
            throw new AssertionError();
        }
        if (p >= this.minHighNoReorder) {
            return p;
        }
        long q = p | 0xFFFFL;
        int i = 0;
        while (q >= (r = this.reorderRanges[i])) {
            ++i;
        }
        return p + ((long)((short)r) << 24);
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setStrength(int value) {
        int noStrength = this.options & 0xFFFF0FFF;
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 15: {
                this.options = noStrength | value << 12;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal strength value " + value);
            }
        }
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setStrengthDefault(int defaultOptions) {
        int noStrength = this.options & 0xFFFF0FFF;
        this.options = noStrength | defaultOptions & 0xF000;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationSettings$getStrength(int options) {
        return options >> 12;
    }

    private final int $$robo$$android_icu_impl_coll_CollationSettings$getStrength() {
        return CollationSettings.getStrength(this.options);
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setFlag(int bit, boolean value) {
        this.options = value ? (this.options |= bit) : (this.options &= ~bit);
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setFlagDefault(int bit, int defaultOptions) {
        this.options = this.options & ~bit | defaultOptions & bit;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$getFlag(int bit) {
        return (this.options & bit) != 0;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setCaseFirst(int value) {
        if (!$assertionsDisabled && value != 0 && value != 512 && value != 768) {
            throw new AssertionError();
        }
        int noCaseFirst = this.options & 0xFFFFFCFF;
        this.options = noCaseFirst | value;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setCaseFirstDefault(int defaultOptions) {
        int noCaseFirst = this.options & 0xFFFFFCFF;
        this.options = noCaseFirst | defaultOptions & 0x300;
    }

    private final int $$robo$$android_icu_impl_coll_CollationSettings$getCaseFirst() {
        return this.options & 0x300;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setAlternateHandlingShifted(boolean value) {
        int noAlternate = this.options & 0xFFFFFFF3;
        this.options = value ? noAlternate | 4 : noAlternate;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setAlternateHandlingDefault(int defaultOptions) {
        int noAlternate = this.options & 0xFFFFFFF3;
        this.options = noAlternate | defaultOptions & 0xC;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$getAlternateHandling() {
        return (this.options & 0xC) != 0;
    }

    private final void $$robo$$android_icu_impl_coll_CollationSettings$setMaxVariable(int value, int defaultOptions) {
        int noMax = this.options & 0xFFFFFF8F;
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.options = noMax | value << 4;
                break;
            }
            case -1: {
                this.options = noMax | defaultOptions & 0x70;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal maxVariable value " + value);
            }
        }
    }

    private final int $$robo$$android_icu_impl_coll_CollationSettings$getMaxVariable() {
        return (this.options & 0x70) >> 4;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationSettings$isTertiaryWithCaseBits(int options) {
        return (options & 0x600) == 512;
    }

    private static final int $$robo$$android_icu_impl_coll_CollationSettings$getTertiaryMask(int options) {
        return CollationSettings.isTertiaryWithCaseBits(options) ? 65343 : 16191;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationSettings$sortsTertiaryUpperCaseFirst(int options) {
        return (options & 0x700) == 768;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$dontCheckFCD() {
        return (this.options & 1) == 0;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$hasBackwardSecondary() {
        return (this.options & 0x800) != 0;
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationSettings$isNumeric() {
        return (this.options & 2) != 0;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationSettings.class.desiredAssertionStatus();
        EMPTY_INT_ARRAY = new int[0];
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_coll_CollationSettings$__constructor__();
    }

    CollationSettings() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationSettings$__constructor__(), 0, this);
    }

    @Override
    public CollationSettings clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_impl_coll_CollationSettings$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_coll_CollationSettings$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_coll_CollationSettings$hashCode(), 0, this);
    }

    public void resetReordering() {
        InvokeDynamicSupport.bootstrap("resetReordering", $$robo$$android_icu_impl_coll_CollationSettings$resetReordering(), 0, this);
    }

    void aliasReordering(CollationData collationData, int[] nArray, int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("aliasReordering", $$robo$$android_icu_impl_coll_CollationSettings$aliasReordering(android.icu.impl.coll.CollationData int[] int byte[] ), 0, this, collationData, nArray, n, byArray);
    }

    public void setReordering(CollationData collationData, int[] nArray) {
        InvokeDynamicSupport.bootstrap("setReordering", $$robo$$android_icu_impl_coll_CollationSettings$setReordering(android.icu.impl.coll.CollationData int[] ), 0, this, collationData, nArray);
    }

    private void setReorderArrays(int[] nArray, int[] nArray2, int n, int n2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setReorderArrays", $$robo$$android_icu_impl_coll_CollationSettings$setReorderArrays(int[] int[] int int byte[] ), 0, this, nArray, nArray2, n, n2, byArray);
    }

    private void setReorderRanges(int[] nArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setReorderRanges", $$robo$$android_icu_impl_coll_CollationSettings$setReorderRanges(int[] int int ), 0, this, nArray, n, n2);
    }

    public void copyReorderingFrom(CollationSettings collationSettings) {
        InvokeDynamicSupport.bootstrap("copyReorderingFrom", $$robo$$android_icu_impl_coll_CollationSettings$copyReorderingFrom(android.icu.impl.coll.CollationSettings ), 0, this, collationSettings);
    }

    public boolean hasReordering() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasReordering", $$robo$$android_icu_impl_coll_CollationSettings$hasReordering(), 0, this);
    }

    private static boolean reorderTableHasSplitBytes(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("reorderTableHasSplitBytes", $$robo$$android_icu_impl_coll_CollationSettings$reorderTableHasSplitBytes(byte[] ), 0, (byte[])byArray);
    }

    public long reorder(long l) {
        return (long)InvokeDynamicSupport.bootstrap("reorder", $$robo$$android_icu_impl_coll_CollationSettings$reorder(long ), 0, this, l);
    }

    private long reorderEx(long l) {
        return (long)InvokeDynamicSupport.bootstrap("reorderEx", $$robo$$android_icu_impl_coll_CollationSettings$reorderEx(long ), 0, this, l);
    }

    public void setStrength(int n) {
        InvokeDynamicSupport.bootstrap("setStrength", $$robo$$android_icu_impl_coll_CollationSettings$setStrength(int ), 0, this, n);
    }

    public void setStrengthDefault(int n) {
        InvokeDynamicSupport.bootstrap("setStrengthDefault", $$robo$$android_icu_impl_coll_CollationSettings$setStrengthDefault(int ), 0, this, n);
    }

    static int getStrength(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getStrength", $$robo$$android_icu_impl_coll_CollationSettings$getStrength(int ), 0, (int)n);
    }

    public int getStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getStrength", $$robo$$android_icu_impl_coll_CollationSettings$getStrength(), 0, this);
    }

    public void setFlag(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_icu_impl_coll_CollationSettings$setFlag(int boolean ), 0, this, n, bl);
    }

    public void setFlagDefault(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFlagDefault", $$robo$$android_icu_impl_coll_CollationSettings$setFlagDefault(int int ), 0, this, n, n2);
    }

    public boolean getFlag(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFlag", $$robo$$android_icu_impl_coll_CollationSettings$getFlag(int ), 0, this, n);
    }

    public void setCaseFirst(int n) {
        InvokeDynamicSupport.bootstrap("setCaseFirst", $$robo$$android_icu_impl_coll_CollationSettings$setCaseFirst(int ), 0, this, n);
    }

    public void setCaseFirstDefault(int n) {
        InvokeDynamicSupport.bootstrap("setCaseFirstDefault", $$robo$$android_icu_impl_coll_CollationSettings$setCaseFirstDefault(int ), 0, this, n);
    }

    public int getCaseFirst() {
        return (int)InvokeDynamicSupport.bootstrap("getCaseFirst", $$robo$$android_icu_impl_coll_CollationSettings$getCaseFirst(), 0, this);
    }

    public void setAlternateHandlingShifted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAlternateHandlingShifted", $$robo$$android_icu_impl_coll_CollationSettings$setAlternateHandlingShifted(boolean ), 0, this, bl);
    }

    public void setAlternateHandlingDefault(int n) {
        InvokeDynamicSupport.bootstrap("setAlternateHandlingDefault", $$robo$$android_icu_impl_coll_CollationSettings$setAlternateHandlingDefault(int ), 0, this, n);
    }

    public boolean getAlternateHandling() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAlternateHandling", $$robo$$android_icu_impl_coll_CollationSettings$getAlternateHandling(), 0, this);
    }

    public void setMaxVariable(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setMaxVariable", $$robo$$android_icu_impl_coll_CollationSettings$setMaxVariable(int int ), 0, this, n, n2);
    }

    public int getMaxVariable() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxVariable", $$robo$$android_icu_impl_coll_CollationSettings$getMaxVariable(), 0, this);
    }

    static boolean isTertiaryWithCaseBits(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTertiaryWithCaseBits", $$robo$$android_icu_impl_coll_CollationSettings$isTertiaryWithCaseBits(int ), 0, (int)n);
    }

    static int getTertiaryMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTertiaryMask", $$robo$$android_icu_impl_coll_CollationSettings$getTertiaryMask(int ), 0, (int)n);
    }

    static boolean sortsTertiaryUpperCaseFirst(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("sortsTertiaryUpperCaseFirst", $$robo$$android_icu_impl_coll_CollationSettings$sortsTertiaryUpperCaseFirst(int ), 0, (int)n);
    }

    public boolean dontCheckFCD() {
        return (boolean)InvokeDynamicSupport.bootstrap("dontCheckFCD", $$robo$$android_icu_impl_coll_CollationSettings$dontCheckFCD(), 0, this);
    }

    boolean hasBackwardSecondary() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBackwardSecondary", $$robo$$android_icu_impl_coll_CollationSettings$hasBackwardSecondary(), 0, this);
    }

    public boolean isNumeric() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNumeric", $$robo$$android_icu_impl_coll_CollationSettings$isNumeric(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CollationSettings.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationSettings)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

