/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.Trie2_32;
import android.icu.impl.coll.Collation;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationFCD;
import android.icu.impl.coll.UVector32;
import android.icu.util.BytesTrie;
import android.icu.util.CharsTrie;
import android.icu.util.ICUException;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CollationIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static long NO_CP_AND_CE32 = -4294967104L;
    protected Trie2_32 trie;
    protected CollationData data;
    private CEBuffer ceBuffer;
    private int cesIndex;
    private SkippedState skipped;
    private int numCpFwd;
    private boolean isNumeric;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_CollationIterator$__constructor__(CollationData d) {
        this.trie = d.trie;
        this.data = d;
        this.numCpFwd = -1;
        this.isNumeric = false;
        this.ceBuffer = null;
    }

    private void $$robo$$android_icu_impl_coll_CollationIterator$__constructor__(CollationData d, boolean numeric) {
        this.trie = d.trie;
        this.data = d;
        this.numCpFwd = -1;
        this.isNumeric = numeric;
        this.ceBuffer = new CEBuffer();
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationIterator$equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        CollationIterator o = (CollationIterator)other;
        if (this.ceBuffer.length != o.ceBuffer.length || this.cesIndex != o.cesIndex || this.numCpFwd != o.numCpFwd || this.isNumeric != o.isNumeric) {
            return false;
        }
        for (int i = 0; i < this.ceBuffer.length; ++i) {
            if (this.ceBuffer.get(i) == o.ceBuffer.get(i)) continue;
            return false;
        }
        return true;
    }

    public abstract void resetToOffset(int var1);

    public abstract int getOffset();

    private final long $$robo$$android_icu_impl_coll_CollationIterator$nextCE() {
        CollationData d;
        if (this.cesIndex < this.ceBuffer.length) {
            return this.ceBuffer.get(this.cesIndex++);
        }
        if (!$assertionsDisabled && this.cesIndex != this.ceBuffer.length) {
            throw new AssertionError();
        }
        this.ceBuffer.incLength();
        long cAndCE32 = this.handleNextCE32();
        int c = (int)(cAndCE32 >> 32);
        int ce32 = (int)cAndCE32;
        int t = ce32 & 0xFF;
        if (t < 192) {
            return this.ceBuffer.set(this.cesIndex++, (long)(ce32 & 0xFFFF0000) << 32 | (long)(ce32 & 0xFF00) << 16 | (long)(t << 8));
        }
        if (t == 192) {
            if (c < 0) {
                return this.ceBuffer.set(this.cesIndex++, 0x101000100L);
            }
            d = this.data.base;
            ce32 = d.getCE32(c);
            t = ce32 & 0xFF;
            if (t < 192) {
                return this.ceBuffer.set(this.cesIndex++, (long)(ce32 & 0xFFFF0000) << 32 | (long)(ce32 & 0xFF00) << 16 | (long)(t << 8));
            }
        } else {
            d = this.data;
        }
        if (t == 193) {
            return this.ceBuffer.set(this.cesIndex++, (long)(ce32 - t) << 32 | 0x5000500L);
        }
        return this.nextCEFromCE32(d, c, ce32);
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$fetchCEs() {
        while (this.nextCE() != 0x101000100L) {
            this.cesIndex = this.ceBuffer.length;
        }
        return this.ceBuffer.length;
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$setCurrentCE(long ce) {
        if (!$assertionsDisabled && this.cesIndex <= 0) {
            throw new AssertionError();
        }
        this.ceBuffer.set(this.cesIndex - 1, ce);
    }

    private final long $$robo$$android_icu_impl_coll_CollationIterator$previousCE(UVector32 offsets) {
        CollationData d;
        if (this.ceBuffer.length > 0) {
            return this.ceBuffer.get(--this.ceBuffer.length);
        }
        offsets.removeAllElements();
        int limitOffset = this.getOffset();
        int c = this.previousCodePoint();
        if (c < 0) {
            return 0x101000100L;
        }
        if (this.data.isUnsafeBackward(c, this.isNumeric)) {
            return this.previousCEUnsafe(c, offsets);
        }
        int ce32 = this.data.getCE32(c);
        if (ce32 == 192) {
            d = this.data.base;
            ce32 = d.getCE32(c);
        } else {
            d = this.data;
        }
        if (Collation.isSimpleOrLongCE32(ce32)) {
            return Collation.ceFromCE32(ce32);
        }
        this.appendCEsFromCE32(d, c, ce32, false);
        if (this.ceBuffer.length > 1) {
            offsets.addElement(this.getOffset());
            while (offsets.size() <= this.ceBuffer.length) {
                offsets.addElement(limitOffset);
            }
        }
        return this.ceBuffer.get(--this.ceBuffer.length);
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$getCEsLength() {
        return this.ceBuffer.length;
    }

    private final long $$robo$$android_icu_impl_coll_CollationIterator$getCE(int i) {
        return this.ceBuffer.get(i);
    }

    private final long[] $$robo$$android_icu_impl_coll_CollationIterator$getCEs() {
        return this.ceBuffer.getCEs();
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$clearCEs() {
        this.ceBuffer.length = 0;
        this.cesIndex = 0;
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$clearCEsIfNoneRemaining() {
        if (this.cesIndex == this.ceBuffer.length) {
            this.clearCEs();
        }
    }

    public abstract int nextCodePoint();

    public abstract int previousCodePoint();

    private final void $$robo$$android_icu_impl_coll_CollationIterator$reset() {
        this.ceBuffer.length = 0;
        this.cesIndex = 0;
        if (this.skipped != null) {
            this.skipped.clear();
        }
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$reset(boolean numeric) {
        if (this.ceBuffer == null) {
            this.ceBuffer = new CEBuffer();
        }
        this.reset();
        this.isNumeric = numeric;
    }

    private final long $$robo$$android_icu_impl_coll_CollationIterator$handleNextCE32() {
        int c = this.nextCodePoint();
        if (c < 0) {
            return -4294967104L;
        }
        return this.makeCodePointAndCE32Pair(c, this.data.getCE32(c));
    }

    private final long $$robo$$android_icu_impl_coll_CollationIterator$makeCodePointAndCE32Pair(int c, int ce32) {
        return (long)c << 32 | (long)ce32 & 0xFFFFFFFFL;
    }

    private final char $$robo$$android_icu_impl_coll_CollationIterator$handleGetTrailSurrogate() {
        return '\u0000';
    }

    private final boolean $$robo$$android_icu_impl_coll_CollationIterator$forbidSurrogateCodePoints() {
        return false;
    }

    protected abstract void forwardNumCodePoints(int var1);

    protected abstract void backwardNumCodePoints(int var1);

    private final int $$robo$$android_icu_impl_coll_CollationIterator$getDataCE32(int c) {
        return this.data.getCE32(c);
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$getCE32FromBuilderData(int ce32) {
        throw new ICUException("internal program error: should be unreachable");
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$appendCEsFromCE32(CollationData d, int c, int ce32, boolean forward) {
        while (Collation.isSpecialCE32(ce32)) {
            switch (Collation.tagFromCE32(ce32)) {
                case 0: 
                case 3: {
                    throw new ICUException("internal program error: should be unreachable");
                }
                case 1: {
                    this.ceBuffer.append(Collation.ceFromLongPrimaryCE32(ce32));
                    return;
                }
                case 2: {
                    this.ceBuffer.append(Collation.ceFromLongSecondaryCE32(ce32));
                    return;
                }
                case 4: {
                    this.ceBuffer.ensureAppendCapacity(2);
                    this.ceBuffer.set(this.ceBuffer.length, Collation.latinCE0FromCE32(ce32));
                    this.ceBuffer.set(this.ceBuffer.length + 1, Collation.latinCE1FromCE32(ce32));
                    this.ceBuffer.length += 2;
                    return;
                }
                case 5: {
                    int index = Collation.indexFromCE32(ce32);
                    int length = Collation.lengthFromCE32(ce32);
                    this.ceBuffer.ensureAppendCapacity(length);
                    do {
                        this.ceBuffer.appendUnsafe(Collation.ceFromCE32(d.ce32s[index++]));
                    } while (--length > 0);
                    return;
                }
                case 6: {
                    int index = Collation.indexFromCE32(ce32);
                    int length = Collation.lengthFromCE32(ce32);
                    this.ceBuffer.ensureAppendCapacity(length);
                    do {
                        this.ceBuffer.appendUnsafe(d.ces[index++]);
                    } while (--length > 0);
                    return;
                }
                case 7: {
                    ce32 = this.getCE32FromBuilderData(ce32);
                    if (ce32 != 192) break;
                    d = this.data.base;
                    ce32 = d.getCE32(c);
                    break;
                }
                case 8: {
                    if (forward) {
                        this.backwardNumCodePoints(1);
                    }
                    ce32 = this.getCE32FromPrefix(d, ce32);
                    if (!forward) break;
                    this.forwardNumCodePoints(1);
                    break;
                }
                case 9: {
                    int nextCp;
                    int index = Collation.indexFromCE32(ce32);
                    int defaultCE32 = d.getCE32FromContexts(index);
                    if (!forward) {
                        ce32 = defaultCE32;
                        break;
                    }
                    if (this.skipped == null && this.numCpFwd < 0) {
                        nextCp = this.nextCodePoint();
                        if (nextCp < 0) {
                            ce32 = defaultCE32;
                            break;
                        }
                        if ((ce32 & 0x200) != 0 && !CollationFCD.mayHaveLccc(nextCp)) {
                            this.backwardNumCodePoints(1);
                            ce32 = defaultCE32;
                            break;
                        }
                    } else {
                        nextCp = this.nextSkippedCodePoint();
                        if (nextCp < 0) {
                            ce32 = defaultCE32;
                            break;
                        }
                        if ((ce32 & 0x200) != 0 && !CollationFCD.mayHaveLccc(nextCp)) {
                            this.backwardNumSkipped(1);
                            ce32 = defaultCE32;
                            break;
                        }
                    }
                    if ((ce32 = this.nextCE32FromContraction(d, ce32, d.contexts, index + 2, defaultCE32, nextCp)) != 1) break;
                    return;
                }
                case 10: {
                    if (this.isNumeric) {
                        this.appendNumericCEs(ce32, forward);
                        return;
                    }
                    ce32 = d.ce32s[Collation.indexFromCE32(ce32)];
                    break;
                }
                case 11: {
                    if (!$assertionsDisabled && c != 0) {
                        throw new AssertionError();
                    }
                    ce32 = d.ce32s[0];
                    break;
                }
                case 12: {
                    int[] jamoCE32s = d.jamoCE32s;
                    int t = (c -= 44032) % 28;
                    int v = (c /= 28) % 21;
                    c /= 21;
                    if ((ce32 & 0x100) != 0) {
                        this.ceBuffer.ensureAppendCapacity(t == 0 ? 2 : 3);
                        this.ceBuffer.set(this.ceBuffer.length, Collation.ceFromCE32(jamoCE32s[c]));
                        this.ceBuffer.set(this.ceBuffer.length + 1, Collation.ceFromCE32(jamoCE32s[19 + v]));
                        this.ceBuffer.length += 2;
                        if (t != 0) {
                            this.ceBuffer.appendUnsafe(Collation.ceFromCE32(jamoCE32s[39 + t]));
                        }
                        return;
                    }
                    this.appendCEsFromCE32(d, -1, jamoCE32s[c], forward);
                    this.appendCEsFromCE32(d, -1, jamoCE32s[19 + v], forward);
                    if (t == 0) {
                        return;
                    }
                    ce32 = jamoCE32s[39 + t];
                    c = -1;
                    break;
                }
                case 13: {
                    if (!$assertionsDisabled && !forward) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !CollationIterator.isLeadSurrogate(c)) {
                        throw new AssertionError();
                    }
                    char trail = this.handleGetTrailSurrogate();
                    if (Character.isLowSurrogate(trail)) {
                        c = Character.toCodePoint((char)c, trail);
                        if ((ce32 &= 0x300) == 0) {
                            ce32 = -1;
                            break;
                        }
                        if (ce32 != 256 && (ce32 = d.getCE32FromSupplementary(c)) != 192) break;
                        d = d.base;
                        ce32 = d.getCE32FromSupplementary(c);
                        break;
                    }
                    ce32 = -1;
                    break;
                }
                case 14: {
                    if (!$assertionsDisabled && c < 0) {
                        throw new AssertionError();
                    }
                    this.ceBuffer.append(d.getCEFromOffsetCE32(c, ce32));
                    return;
                }
                case 15: {
                    if (!$assertionsDisabled && c < 0) {
                        throw new AssertionError();
                    }
                    if (CollationIterator.isSurrogate(c) && this.forbidSurrogateCodePoints()) {
                        ce32 = -195323;
                        break;
                    }
                    this.ceBuffer.append(Collation.unassignedCEFromCodePoint(c));
                    return;
                }
            }
        }
        this.ceBuffer.append(Collation.ceFromSimpleCE32(ce32));
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationIterator$isSurrogate(int c) {
        return (c & 0xFFFFF800) == 55296;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationIterator$isLeadSurrogate(int c) {
        return (c & 0xFFFFFC00) == 55296;
    }

    private static final boolean $$robo$$android_icu_impl_coll_CollationIterator$isTrailSurrogate(int c) {
        return (c & 0xFFFFFC00) == 56320;
    }

    private final long $$robo$$android_icu_impl_coll_CollationIterator$nextCEFromCE32(CollationData d, int c, int ce32) {
        --this.ceBuffer.length;
        this.appendCEsFromCE32(d, c, ce32, true);
        return this.ceBuffer.get(this.cesIndex++);
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$getCE32FromPrefix(CollationData d, int ce32) {
        int c;
        int index = Collation.indexFromCE32(ce32);
        ce32 = d.getCE32FromContexts(index);
        int lookBehind = 0;
        CharsTrie prefixes = new CharsTrie(d.contexts, index += 2);
        while ((c = this.previousCodePoint()) >= 0) {
            ++lookBehind;
            BytesTrie.Result match = prefixes.nextForCodePoint(c);
            if (match.hasValue()) {
                ce32 = prefixes.getValue();
            }
            if (match.hasNext()) continue;
            break;
        }
        this.forwardNumCodePoints(lookBehind);
        return ce32;
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$nextSkippedCodePoint() {
        if (this.skipped != null && this.skipped.hasNext()) {
            return this.skipped.next();
        }
        if (this.numCpFwd == 0) {
            return -1;
        }
        int c = this.nextCodePoint();
        if (this.skipped != null && !this.skipped.isEmpty() && c >= 0) {
            this.skipped.incBeyond();
        }
        if (this.numCpFwd > 0 && c >= 0) {
            --this.numCpFwd;
        }
        return c;
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$backwardNumSkipped(int n) {
        if (this.skipped != null && !this.skipped.isEmpty()) {
            n = this.skipped.backwardNumCodePoints(n);
        }
        this.backwardNumCodePoints(n);
        if (this.numCpFwd >= 0) {
            this.numCpFwd += n;
        }
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$nextCE32FromContraction(CollationData d, int contractionCE32, CharSequence trieChars, int trieOffset, int ce32, int c) {
        int lookAhead = 1;
        int sinceMatch = 1;
        CharsTrie suffixes = new CharsTrie(trieChars, trieOffset);
        if (this.skipped != null && !this.skipped.isEmpty()) {
            this.skipped.saveTrieState(suffixes);
        }
        BytesTrie.Result match = suffixes.firstForCodePoint(c);
        while (true) {
            if (match.hasValue()) {
                ce32 = suffixes.getValue();
                if (!match.hasNext() || (c = this.nextSkippedCodePoint()) < 0) {
                    return ce32;
                }
                if (this.skipped != null && !this.skipped.isEmpty()) {
                    this.skipped.saveTrieState(suffixes);
                }
                sinceMatch = 1;
            } else {
                int nextCp;
                if (match == BytesTrie.Result.NO_MATCH || (nextCp = this.nextSkippedCodePoint()) < 0) {
                    if ((contractionCE32 & 0x400) == 0 || (contractionCE32 & 0x100) != 0 && sinceMatch >= lookAhead) break;
                    if (sinceMatch > 1) {
                        this.backwardNumSkipped(sinceMatch);
                        c = this.nextSkippedCodePoint();
                        lookAhead -= sinceMatch - 1;
                        sinceMatch = 1;
                    }
                    if (d.getFCD16(c) <= 255) break;
                    return this.nextCE32FromDiscontiguousContraction(d, suffixes, ce32, lookAhead, c);
                }
                c = nextCp;
                ++sinceMatch;
            }
            ++lookAhead;
            match = suffixes.nextForCodePoint(c);
        }
        this.backwardNumSkipped(sinceMatch);
        return ce32;
    }

    private final int $$robo$$android_icu_impl_coll_CollationIterator$nextCE32FromDiscontiguousContraction(CollationData d, CharsTrie suffixes, int ce32, int lookAhead, int c) {
        int fcd16 = d.getFCD16(c);
        if (!$assertionsDisabled && fcd16 <= 255) {
            throw new AssertionError();
        }
        int nextCp = this.nextSkippedCodePoint();
        if (nextCp < 0) {
            this.backwardNumSkipped(1);
            return ce32;
        }
        ++lookAhead;
        int prevCC = fcd16 & 0xFF;
        fcd16 = d.getFCD16(nextCp);
        if (fcd16 <= 255) {
            this.backwardNumSkipped(2);
            return ce32;
        }
        if (this.skipped == null || this.skipped.isEmpty()) {
            if (this.skipped == null) {
                this.skipped = new SkippedState();
            }
            suffixes.reset();
            if (lookAhead > 2) {
                this.backwardNumCodePoints(lookAhead);
                suffixes.firstForCodePoint(this.nextCodePoint());
                for (int i = 3; i < lookAhead; ++i) {
                    suffixes.nextForCodePoint(this.nextCodePoint());
                }
                this.forwardNumCodePoints(2);
            }
            this.skipped.saveTrieState(suffixes);
        } else {
            this.skipped.resetToTrieState(suffixes);
        }
        this.skipped.setFirstSkipped(c);
        int sinceMatch = 2;
        c = nextCp;
        do {
            BytesTrie.Result match;
            if (prevCC < fcd16 >> 8 && (match = suffixes.nextForCodePoint(c)).hasValue()) {
                ce32 = suffixes.getValue();
                sinceMatch = 0;
                this.skipped.recordMatch();
                if (!match.hasNext()) break;
                this.skipped.saveTrieState(suffixes);
            } else {
                this.skipped.skip(c);
                this.skipped.resetToTrieState(suffixes);
                prevCC = fcd16 & 0xFF;
            }
            c = this.nextSkippedCodePoint();
            if (c < 0) break;
            ++sinceMatch;
        } while ((fcd16 = d.getFCD16(c)) > 255);
        this.backwardNumSkipped(sinceMatch);
        boolean isTopDiscontiguous = this.skipped.isEmpty();
        this.skipped.replaceMatch();
        if (isTopDiscontiguous && !this.skipped.isEmpty()) {
            c = -1;
            while (true) {
                this.appendCEsFromCE32(d, c, ce32, true);
                if (!this.skipped.hasNext()) break;
                c = this.skipped.next();
                ce32 = this.getDataCE32(c);
                if (ce32 == 192) {
                    d = this.data.base;
                    ce32 = d.getCE32(c);
                    continue;
                }
                d = this.data;
            }
            this.skipped.clear();
            ce32 = 1;
        }
        return ce32;
    }

    private final long $$robo$$android_icu_impl_coll_CollationIterator$previousCEUnsafe(int c, UVector32 offsets) {
        int numBackward = 1;
        while ((c = this.previousCodePoint()) >= 0) {
            ++numBackward;
            if (this.data.isUnsafeBackward(c, this.isNumeric)) continue;
        }
        this.numCpFwd = numBackward;
        this.cesIndex = 0;
        if (!$assertionsDisabled && this.ceBuffer.length != 0) {
            throw new AssertionError();
        }
        int offset = this.getOffset();
        while (this.numCpFwd > 0) {
            --this.numCpFwd;
            this.nextCE();
            if (!$assertionsDisabled && this.ceBuffer.get(this.ceBuffer.length - 1) == 0x101000100L) {
                throw new AssertionError();
            }
            this.cesIndex = this.ceBuffer.length;
            if (!$assertionsDisabled && offsets.size() >= this.ceBuffer.length) {
                throw new AssertionError();
            }
            offsets.addElement(offset);
            offset = this.getOffset();
            while (offsets.size() < this.ceBuffer.length) {
                offsets.addElement(offset);
            }
        }
        if (!$assertionsDisabled && offsets.size() != this.ceBuffer.length) {
            throw new AssertionError();
        }
        offsets.addElement(offset);
        this.numCpFwd = -1;
        this.backwardNumCodePoints(numBackward);
        this.cesIndex = 0;
        return this.ceBuffer.get(--this.ceBuffer.length);
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$appendNumericCEs(int ce32, boolean forward) {
        StringBuilder digits;
        block8: {
            block9: {
                int c;
                char digit;
                digits = new StringBuilder();
                if (forward) {
                    while (true) {
                        digit = Collation.digitFromCE32(ce32);
                        digits.append(digit);
                        if (this.numCpFwd == 0 || (c = this.nextCodePoint()) < 0) break block8;
                        ce32 = this.data.getCE32(c);
                        if (ce32 == 192) {
                            ce32 = this.data.base.getCE32(c);
                        }
                        if (!Collation.hasCE32Tag(ce32, 10)) {
                            this.backwardNumCodePoints(1);
                            break block8;
                        }
                        if (this.numCpFwd <= 0) continue;
                        --this.numCpFwd;
                    }
                }
                do {
                    digit = Collation.digitFromCE32(ce32);
                    digits.append(digit);
                    c = this.previousCodePoint();
                    if (c < 0) break block9;
                    ce32 = this.data.getCE32(c);
                    if (ce32 != 192) continue;
                    ce32 = this.data.base.getCE32(c);
                } while (Collation.hasCE32Tag(ce32, 10));
                this.forwardNumCodePoints(1);
            }
            digits.reverse();
        }
        int pos = 0;
        while (true) {
            if (pos < digits.length() - 1 && digits.charAt(pos) == '\u0000') {
                ++pos;
                continue;
            }
            int segmentLength = digits.length() - pos;
            if (segmentLength > 254) {
                segmentLength = 254;
            }
            this.appendNumericSegmentCEs(digits.subSequence(pos, pos + segmentLength));
            if ((pos += segmentLength) >= digits.length()) break;
        }
    }

    private final void $$robo$$android_icu_impl_coll_CollationIterator$appendNumericSegmentCEs(CharSequence digits) {
        int pos;
        int pair;
        int length = digits.length();
        if (!($assertionsDisabled || 1 <= length && length <= 254)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && length != 1 && digits.charAt(0) == '\u0000') {
            throw new AssertionError();
        }
        long numericPrimary = this.data.numericPrimary;
        if (length <= 7) {
            int value = digits.charAt(0);
            for (int i = 1; i < length; ++i) {
                value = value * 10 + digits.charAt(i);
            }
            int firstByte = 2;
            int numBytes = 74;
            if (value < numBytes) {
                long primary = numericPrimary | (long)(firstByte + value << 16);
                this.ceBuffer.append(Collation.makeCE(primary));
                return;
            }
            value -= numBytes;
            firstByte += numBytes;
            numBytes = 40;
            if (value < numBytes * 254) {
                long primary = numericPrimary | (long)(firstByte + value / 254 << 16) | (long)(2 + value % 254 << 8);
                this.ceBuffer.append(Collation.makeCE(primary));
                return;
            }
            value -= numBytes * 254;
            firstByte += numBytes;
            numBytes = 16;
            if (value < numBytes * 254 * 254) {
                long primary = numericPrimary | (long)(2 + value % 254);
                primary |= (long)(2 + (value /= 254) % 254 << 8);
                this.ceBuffer.append(Collation.makeCE(primary |= (long)(firstByte + (value /= 254) % 254 << 16)));
                return;
            }
        }
        if (!$assertionsDisabled && length < 7) {
            throw new AssertionError();
        }
        int numPairs = (length + 1) / 2;
        long primary = numericPrimary | (long)(128 + numPairs << 16);
        while (digits.charAt(length - 1) == '\u0000' && digits.charAt(length - 2) == '\u0000') {
            length -= 2;
        }
        if ((length & 1) != 0) {
            pair = digits.charAt(0);
            pos = 1;
        } else {
            pair = digits.charAt(0) * 10 + digits.charAt(1);
            pos = 2;
        }
        pair = 11 + 2 * pair;
        int shift = 8;
        while (pos < length) {
            if (shift == 0) {
                this.ceBuffer.append(Collation.makeCE(primary |= (long)pair));
                primary = numericPrimary;
                shift = 16;
            } else {
                primary |= (long)(pair << shift);
                shift -= 8;
            }
            pair = 11 + 2 * (digits.charAt(pos) * 10 + digits.charAt(pos + 1));
            pos += 2;
        }
        this.ceBuffer.append(Collation.makeCE(primary |= (long)(pair - 1 << shift)));
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CollationIterator.class.desiredAssertionStatus();
    }

    private void __constructor__(CollationData collationData) {
        this.$$robo$$android_icu_impl_coll_CollationIterator$__constructor__(collationData);
    }

    public CollationIterator(CollationData collationData) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationIterator$__constructor__(android.icu.impl.coll.CollationData ), 0, this, collationData);
    }

    private void __constructor__(CollationData collationData, boolean bl) {
        this.$$robo$$android_icu_impl_coll_CollationIterator$__constructor__(collationData, bl);
    }

    public CollationIterator(CollationData collationData, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationIterator$__constructor__(android.icu.impl.coll.CollationData boolean ), 0, this, collationData, bl);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_coll_CollationIterator$equals(java.lang.Object ), 0, this, object);
    }

    public long nextCE() {
        return (long)InvokeDynamicSupport.bootstrap("nextCE", $$robo$$android_icu_impl_coll_CollationIterator$nextCE(), 0, this);
    }

    public int fetchCEs() {
        return (int)InvokeDynamicSupport.bootstrap("fetchCEs", $$robo$$android_icu_impl_coll_CollationIterator$fetchCEs(), 0, this);
    }

    void setCurrentCE(long l) {
        InvokeDynamicSupport.bootstrap("setCurrentCE", $$robo$$android_icu_impl_coll_CollationIterator$setCurrentCE(long ), 0, this, l);
    }

    public long previousCE(UVector32 uVector32) {
        return (long)InvokeDynamicSupport.bootstrap("previousCE", $$robo$$android_icu_impl_coll_CollationIterator$previousCE(android.icu.impl.coll.UVector32 ), 0, this, uVector32);
    }

    public int getCEsLength() {
        return (int)InvokeDynamicSupport.bootstrap("getCEsLength", $$robo$$android_icu_impl_coll_CollationIterator$getCEsLength(), 0, this);
    }

    public long getCE(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getCE", $$robo$$android_icu_impl_coll_CollationIterator$getCE(int ), 0, this, n);
    }

    public long[] getCEs() {
        return InvokeDynamicSupport.bootstrap("getCEs", $$robo$$android_icu_impl_coll_CollationIterator$getCEs(), 0, this);
    }

    void clearCEs() {
        InvokeDynamicSupport.bootstrap("clearCEs", $$robo$$android_icu_impl_coll_CollationIterator$clearCEs(), 0, this);
    }

    public void clearCEsIfNoneRemaining() {
        InvokeDynamicSupport.bootstrap("clearCEsIfNoneRemaining", $$robo$$android_icu_impl_coll_CollationIterator$clearCEsIfNoneRemaining(), 0, this);
    }

    protected void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_impl_coll_CollationIterator$reset(), 0, this);
    }

    protected void reset(boolean bl) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_impl_coll_CollationIterator$reset(boolean ), 0, this, bl);
    }

    protected long handleNextCE32() {
        return (long)InvokeDynamicSupport.bootstrap("handleNextCE32", $$robo$$android_icu_impl_coll_CollationIterator$handleNextCE32(), 0, this);
    }

    protected long makeCodePointAndCE32Pair(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("makeCodePointAndCE32Pair", $$robo$$android_icu_impl_coll_CollationIterator$makeCodePointAndCE32Pair(int int ), 0, this, n, n2);
    }

    protected char handleGetTrailSurrogate() {
        return (char)InvokeDynamicSupport.bootstrap("handleGetTrailSurrogate", $$robo$$android_icu_impl_coll_CollationIterator$handleGetTrailSurrogate(), 0, this);
    }

    protected boolean forbidSurrogateCodePoints() {
        return (boolean)InvokeDynamicSupport.bootstrap("forbidSurrogateCodePoints", $$robo$$android_icu_impl_coll_CollationIterator$forbidSurrogateCodePoints(), 0, this);
    }

    protected int getDataCE32(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDataCE32", $$robo$$android_icu_impl_coll_CollationIterator$getDataCE32(int ), 0, this, n);
    }

    protected int getCE32FromBuilderData(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCE32FromBuilderData", $$robo$$android_icu_impl_coll_CollationIterator$getCE32FromBuilderData(int ), 0, this, n);
    }

    protected void appendCEsFromCE32(CollationData collationData, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("appendCEsFromCE32", $$robo$$android_icu_impl_coll_CollationIterator$appendCEsFromCE32(android.icu.impl.coll.CollationData int int boolean ), 0, this, collationData, n, n2, bl);
    }

    private static boolean isSurrogate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSurrogate", $$robo$$android_icu_impl_coll_CollationIterator$isSurrogate(int ), 0, (int)n);
    }

    protected static boolean isLeadSurrogate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLeadSurrogate", $$robo$$android_icu_impl_coll_CollationIterator$isLeadSurrogate(int ), 0, (int)n);
    }

    protected static boolean isTrailSurrogate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTrailSurrogate", $$robo$$android_icu_impl_coll_CollationIterator$isTrailSurrogate(int ), 0, (int)n);
    }

    private long nextCEFromCE32(CollationData collationData, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("nextCEFromCE32", $$robo$$android_icu_impl_coll_CollationIterator$nextCEFromCE32(android.icu.impl.coll.CollationData int int ), 0, this, collationData, n, n2);
    }

    private int getCE32FromPrefix(CollationData collationData, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCE32FromPrefix", $$robo$$android_icu_impl_coll_CollationIterator$getCE32FromPrefix(android.icu.impl.coll.CollationData int ), 0, this, collationData, n);
    }

    private int nextSkippedCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("nextSkippedCodePoint", $$robo$$android_icu_impl_coll_CollationIterator$nextSkippedCodePoint(), 0, this);
    }

    private void backwardNumSkipped(int n) {
        InvokeDynamicSupport.bootstrap("backwardNumSkipped", $$robo$$android_icu_impl_coll_CollationIterator$backwardNumSkipped(int ), 0, this, n);
    }

    private int nextCE32FromContraction(CollationData collationData, int n, CharSequence charSequence, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrap("nextCE32FromContraction", $$robo$$android_icu_impl_coll_CollationIterator$nextCE32FromContraction(android.icu.impl.coll.CollationData int java.lang.CharSequence int int int ), 0, this, collationData, n, charSequence, n2, n3, n4);
    }

    private int nextCE32FromDiscontiguousContraction(CollationData collationData, CharsTrie charsTrie, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("nextCE32FromDiscontiguousContraction", $$robo$$android_icu_impl_coll_CollationIterator$nextCE32FromDiscontiguousContraction(android.icu.impl.coll.CollationData android.icu.util.CharsTrie int int int ), 0, this, collationData, charsTrie, n, n2, n3);
    }

    private long previousCEUnsafe(int n, UVector32 uVector32) {
        return (long)InvokeDynamicSupport.bootstrap("previousCEUnsafe", $$robo$$android_icu_impl_coll_CollationIterator$previousCEUnsafe(int android.icu.impl.coll.UVector32 ), 0, this, n, uVector32);
    }

    private void appendNumericCEs(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("appendNumericCEs", $$robo$$android_icu_impl_coll_CollationIterator$appendNumericCEs(int boolean ), 0, this, n, bl);
    }

    private void appendNumericSegmentCEs(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("appendNumericSegmentCEs", $$robo$$android_icu_impl_coll_CollationIterator$appendNumericSegmentCEs(java.lang.CharSequence ), 0, this, charSequence);
    }

    static {
        RobolectricInternals.classInitializing(CollationIterator.class);
    }

    public /* synthetic */ CollationIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SkippedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private StringBuilder oldBuffer;
        private StringBuilder newBuffer;
        private int pos;
        private int skipLengthAtMatch;
        private CharsTrie.State state;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$__constructor__() {
            this.oldBuffer = new StringBuilder();
            this.newBuffer = new StringBuilder();
            this.state = new CharsTrie.State();
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$clear() {
            this.oldBuffer.setLength(0);
            this.pos = 0;
        }

        private final boolean $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$isEmpty() {
            return this.oldBuffer.length() == 0;
        }

        private final boolean $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$hasNext() {
            return this.pos < this.oldBuffer.length();
        }

        private final int $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$next() {
            int c = this.oldBuffer.codePointAt(this.pos);
            this.pos += Character.charCount(c);
            return c;
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$incBeyond() {
            if (!$assertionsDisabled && this.hasNext()) {
                throw new AssertionError();
            }
            ++this.pos;
        }

        private final int $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$backwardNumCodePoints(int n) {
            int length = this.oldBuffer.length();
            int beyond = this.pos - length;
            if (beyond > 0) {
                if (beyond >= n) {
                    this.pos -= n;
                    return n;
                }
                this.pos = this.oldBuffer.offsetByCodePoints(length, beyond - n);
                return beyond;
            }
            this.pos = this.oldBuffer.offsetByCodePoints(this.pos, -n);
            return 0;
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$setFirstSkipped(int c) {
            this.skipLengthAtMatch = 0;
            this.newBuffer.setLength(0);
            this.newBuffer.appendCodePoint(c);
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$skip(int c) {
            this.newBuffer.appendCodePoint(c);
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$recordMatch() {
            this.skipLengthAtMatch = this.newBuffer.length();
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$replaceMatch() {
            int oldLength = this.oldBuffer.length();
            if (this.pos > oldLength) {
                this.pos = oldLength;
            }
            this.oldBuffer.delete(0, this.pos).insert(0, this.newBuffer, 0, this.skipLengthAtMatch);
            this.pos = 0;
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$saveTrieState(CharsTrie trie) {
            trie.saveState(this.state);
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$resetToTrieState(CharsTrie trie) {
            trie.resetToState(this.state);
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !CollationIterator.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_coll_CollationIterator_SkippedState$__constructor__();
        }

        SkippedState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$__constructor__(), 0, this);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$clear(), 0, this);
        }

        boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$isEmpty(), 0, this);
        }

        boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$hasNext(), 0, this);
        }

        int next() {
            return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$next(), 0, this);
        }

        void incBeyond() {
            InvokeDynamicSupport.bootstrap("incBeyond", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$incBeyond(), 0, this);
        }

        int backwardNumCodePoints(int n) {
            return (int)InvokeDynamicSupport.bootstrap("backwardNumCodePoints", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$backwardNumCodePoints(int ), 0, this, n);
        }

        void setFirstSkipped(int n) {
            InvokeDynamicSupport.bootstrap("setFirstSkipped", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$setFirstSkipped(int ), 0, this, n);
        }

        void skip(int n) {
            InvokeDynamicSupport.bootstrap("skip", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$skip(int ), 0, this, n);
        }

        void recordMatch() {
            InvokeDynamicSupport.bootstrap("recordMatch", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$recordMatch(), 0, this);
        }

        void replaceMatch() {
            InvokeDynamicSupport.bootstrap("replaceMatch", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$replaceMatch(), 0, this);
        }

        void saveTrieState(CharsTrie charsTrie) {
            InvokeDynamicSupport.bootstrap("saveTrieState", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$saveTrieState(android.icu.util.CharsTrie ), 0, this, charsTrie);
        }

        void resetToTrieState(CharsTrie charsTrie) {
            InvokeDynamicSupport.bootstrap("resetToTrieState", $$robo$$android_icu_impl_coll_CollationIterator_SkippedState$resetToTrieState(android.icu.util.CharsTrie ), 0, this, charsTrie);
        }

        static {
            RobolectricInternals.classInitializing(SkippedState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SkippedState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class CEBuffer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INITIAL_CAPACITY = 40;
        int length;
        private long[] buffer;

        private void $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$__constructor__() {
            this.length = 0;
            this.buffer = new long[40];
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$append(long ce) {
            if (this.length >= 40) {
                this.ensureAppendCapacity(1);
            }
            this.buffer[this.length++] = ce;
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$appendUnsafe(long ce) {
            this.buffer[this.length++] = ce;
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$ensureAppendCapacity(int appCap) {
            int capacity = this.buffer.length;
            if (this.length + appCap <= capacity) {
                return;
            }
            do {
                if (capacity < 1000) {
                    capacity *= 4;
                    continue;
                }
                capacity *= 2;
            } while (capacity < this.length + appCap);
            long[] newBuffer = new long[capacity];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.buffer, (int)0, (long[])newBuffer, (int)0, (int)this.length);
            this.buffer = newBuffer;
        }

        private final void $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$incLength() {
            if (this.length >= 40) {
                this.ensureAppendCapacity(1);
            }
            ++this.length;
        }

        private final long $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$set(int i, long ce) {
            this.buffer[i] = ce;
            return this.buffer[i];
        }

        private final long $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$get(int i) {
            return this.buffer[i];
        }

        private final long[] $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$getCEs() {
            return this.buffer;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$__constructor__();
        }

        CEBuffer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$__constructor__(), 0, this);
        }

        void append(long l) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$append(long ), 0, this, l);
        }

        void appendUnsafe(long l) {
            InvokeDynamicSupport.bootstrap("appendUnsafe", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$appendUnsafe(long ), 0, this, l);
        }

        void ensureAppendCapacity(int n) {
            InvokeDynamicSupport.bootstrap("ensureAppendCapacity", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$ensureAppendCapacity(int ), 0, this, n);
        }

        void incLength() {
            InvokeDynamicSupport.bootstrap("incLength", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$incLength(), 0, this);
        }

        long set(int n, long l) {
            return (long)InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$set(int long ), 0, this, n, l);
        }

        long get(int n) {
            return (long)InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$get(int ), 0, this, n);
        }

        long[] getCEs() {
            return InvokeDynamicSupport.bootstrap("getCEs", $$robo$$android_icu_impl_coll_CollationIterator_CEBuffer$getCEs(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CEBuffer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

