/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.IllegalIcuArgumentException;
import android.icu.util.BytesTrie;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class UPropertyAliases
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int IX_VALUE_MAPS_OFFSET = 0;
    private static int IX_BYTE_TRIES_OFFSET = 1;
    private static int IX_NAME_GROUPS_OFFSET = 2;
    private static int IX_RESERVED3_OFFSET = 3;
    private int[] valueMaps;
    private byte[] bytesTries;
    private String nameGroups;
    private static IsAcceptable IS_ACCEPTABLE;
    private static int DATA_FORMAT = 1886282093;
    public static UPropertyAliases INSTANCE;

    private final void $$robo$$android_icu_impl_UPropertyAliases$load(ByteBuffer bytes) throws IOException {
        ICUBinary.readHeader(bytes, 1886282093, IS_ACCEPTABLE);
        int indexesLength = bytes.getInt() / 4;
        if (indexesLength < 8) {
            throw new IOException("pnames.icu: not enough indexes");
        }
        int[] inIndexes = new int[indexesLength];
        inIndexes[0] = indexesLength * 4;
        for (int i = 1; i < indexesLength; ++i) {
            inIndexes[i] = bytes.getInt();
        }
        int offset = inIndexes[0];
        int nextOffset = inIndexes[1];
        int numInts = (nextOffset - offset) / 4;
        this.valueMaps = ICUBinary.getInts(bytes, numInts, 0);
        offset = nextOffset;
        nextOffset = inIndexes[2];
        int numBytes = nextOffset - offset;
        this.bytesTries = new byte[numBytes];
        bytes.get(this.bytesTries);
        offset = nextOffset;
        nextOffset = inIndexes[3];
        numBytes = nextOffset - offset;
        StringBuilder sb = new StringBuilder(numBytes);
        for (int i = 0; i < numBytes; ++i) {
            sb.append((char)bytes.get());
        }
        this.nameGroups = sb.toString();
    }

    private void $$robo$$android_icu_impl_UPropertyAliases$__constructor__() throws IOException {
        ByteBuffer bytes = ICUBinary.getRequiredData("pnames.icu");
        this.load(bytes);
    }

    private final int $$robo$$android_icu_impl_UPropertyAliases$findProperty(int property) {
        int i = 1;
        for (int numRanges = this.valueMaps[0]; numRanges > 0; --numRanges) {
            int start = this.valueMaps[i];
            int limit = this.valueMaps[i + 1];
            i += 2;
            if (property < start) break;
            if (property < limit) {
                return i + (property - start) * 2;
            }
            i += (limit - start) * 2;
        }
        return 0;
    }

    private final int $$robo$$android_icu_impl_UPropertyAliases$findPropertyValueNameGroup(int valueMapIndex, int value) {
        if (valueMapIndex == 0) {
            return 0;
        }
        int n = ++valueMapIndex;
        ++valueMapIndex;
        int numRanges = this.valueMaps[n];
        if (numRanges < 16) {
            while (numRanges > 0) {
                int start = this.valueMaps[valueMapIndex];
                int limit = this.valueMaps[valueMapIndex + 1];
                valueMapIndex += 2;
                if (value >= start) {
                    if (value < limit) {
                        return this.valueMaps[valueMapIndex + value - start];
                    }
                    valueMapIndex += limit - start;
                    --numRanges;
                    continue;
                }
                break;
            }
        } else {
            int v;
            int valuesStart = valueMapIndex;
            int nameGroupOffsetsStart = valueMapIndex + numRanges - 16;
            while (value >= (v = this.valueMaps[valueMapIndex])) {
                if (value == v) {
                    return this.valueMaps[nameGroupOffsetsStart + valueMapIndex - valuesStart];
                }
                if (++valueMapIndex < nameGroupOffsetsStart) continue;
            }
        }
        return 0;
    }

    private final String $$robo$$android_icu_impl_UPropertyAliases$getName(int nameGroupsIndex, int nameIndex) {
        char numNames = this.nameGroups.charAt(nameGroupsIndex++);
        if (nameIndex < 0 || numNames <= nameIndex) {
            throw new IllegalIcuArgumentException("Invalid property (value) name choice");
        }
        while (nameIndex > 0) {
            while ('\u0000' != this.nameGroups.charAt(nameGroupsIndex++)) {
            }
            --nameIndex;
        }
        int nameStart = nameGroupsIndex;
        while ('\u0000' != this.nameGroups.charAt(nameGroupsIndex)) {
            ++nameGroupsIndex;
        }
        if (nameStart == nameGroupsIndex) {
            return null;
        }
        return this.nameGroups.substring(nameStart, nameGroupsIndex);
    }

    private static final int $$robo$$android_icu_impl_UPropertyAliases$asciiToLowercase(int c) {
        return 65 <= c && c <= 90 ? c + 32 : c;
    }

    private final boolean $$robo$$android_icu_impl_UPropertyAliases$containsName(BytesTrie trie, CharSequence name) {
        BytesTrie.Result result = BytesTrie.Result.NO_VALUE;
        for (int i = 0; i < name.length(); ++i) {
            int c = name.charAt(i);
            if (c == 45 || c == 95 || c == 32 || 9 <= c && c <= 13) continue;
            if (!result.hasNext()) {
                return false;
            }
            c = UPropertyAliases.asciiToLowercase(c);
            result = trie.next(c);
        }
        return result.hasValue();
    }

    private final String $$robo$$android_icu_impl_UPropertyAliases$getPropertyName(int property, int nameChoice) {
        int valueMapIndex = this.findProperty(property);
        if (valueMapIndex == 0) {
            throw new IllegalArgumentException("Invalid property enum " + property + " (0x" + Integer.toHexString(property) + ")");
        }
        return this.getName(this.valueMaps[valueMapIndex], nameChoice);
    }

    private final String $$robo$$android_icu_impl_UPropertyAliases$getPropertyValueName(int property, int value, int nameChoice) {
        int valueMapIndex = this.findProperty(property);
        if (valueMapIndex == 0) {
            throw new IllegalArgumentException("Invalid property enum " + property + " (0x" + Integer.toHexString(property) + ")");
        }
        int nameGroupOffset = this.findPropertyValueNameGroup(this.valueMaps[valueMapIndex + 1], value);
        if (nameGroupOffset == 0) {
            throw new IllegalArgumentException("Property " + property + " (0x" + Integer.toHexString(property) + ") does not have named values");
        }
        return this.getName(nameGroupOffset, nameChoice);
    }

    private final int $$robo$$android_icu_impl_UPropertyAliases$getPropertyOrValueEnum(int bytesTrieOffset, CharSequence alias) {
        BytesTrie trie = new BytesTrie(this.bytesTries, bytesTrieOffset);
        if (this.containsName(trie, alias)) {
            return trie.getValue();
        }
        return -1;
    }

    private final int $$robo$$android_icu_impl_UPropertyAliases$getPropertyEnum(CharSequence alias) {
        return this.getPropertyOrValueEnum(0, alias);
    }

    private final int $$robo$$android_icu_impl_UPropertyAliases$getPropertyValueEnum(int property, CharSequence alias) {
        int valueMapIndex = this.findProperty(property);
        if (valueMapIndex == 0) {
            throw new IllegalArgumentException("Invalid property enum " + property + " (0x" + Integer.toHexString(property) + ")");
        }
        if ((valueMapIndex = this.valueMaps[valueMapIndex + 1]) == 0) {
            throw new IllegalArgumentException("Property " + property + " (0x" + Integer.toHexString(property) + ") does not have named values");
        }
        return this.getPropertyOrValueEnum(this.valueMaps[valueMapIndex], alias);
    }

    private final int $$robo$$android_icu_impl_UPropertyAliases$getPropertyValueEnumNoThrow(int property, CharSequence alias) {
        int valueMapIndex = this.findProperty(property);
        if (valueMapIndex == 0) {
            return -1;
        }
        if ((valueMapIndex = this.valueMaps[valueMapIndex + 1]) == 0) {
            return -1;
        }
        return this.getPropertyOrValueEnum(this.valueMaps[valueMapIndex], alias);
    }

    private static final int $$robo$$android_icu_impl_UPropertyAliases$compare(String stra, String strb) {
        int istra = 0;
        int istrb = 0;
        char cstra = '\u0000';
        char cstrb = '\u0000';
        block6: while (true) {
            boolean endstrb;
            if (istra < stra.length()) {
                cstra = stra.charAt(istra);
                switch (cstra) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '-': 
                    case '_': {
                        ++istra;
                        continue block6;
                    }
                }
            }
            block7: while (istrb < strb.length()) {
                cstrb = strb.charAt(istrb);
                switch (cstrb) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '-': 
                    case '_': {
                        ++istrb;
                        continue block7;
                    }
                }
            }
            boolean endstra = istra == stra.length();
            boolean bl = endstrb = istrb == strb.length();
            if (endstra) {
                if (endstrb) {
                    return 0;
                }
                cstra = '\u0000';
            } else if (endstrb) {
                cstrb = '\u0000';
            }
            int rc = UPropertyAliases.asciiToLowercase(cstra) - UPropertyAliases.asciiToLowercase(cstrb);
            if (rc != 0) {
                return rc;
            }
            ++istra;
            ++istrb;
        }
    }

    static void __staticInitializer__() {
        IS_ACCEPTABLE = new IsAcceptable();
        try {
            INSTANCE = new UPropertyAliases();
        }
        catch (IOException e) {
            MissingResourceException mre = new MissingResourceException("Could not construct UPropertyAliases. Missing pnames.icu", "", "");
            mre.initCause(e);
            throw mre;
        }
    }

    private void load(ByteBuffer byteBuffer) throws IOException {
        InvokeDynamicSupport.bootstrap("load", $$robo$$android_icu_impl_UPropertyAliases$load(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    private void __constructor__() throws IOException {
        this.$$robo$$android_icu_impl_UPropertyAliases$__constructor__();
    }

    private UPropertyAliases() throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UPropertyAliases$__constructor__(), 0, this);
    }

    private int findProperty(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findProperty", $$robo$$android_icu_impl_UPropertyAliases$findProperty(int ), 0, this, n);
    }

    private int findPropertyValueNameGroup(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findPropertyValueNameGroup", $$robo$$android_icu_impl_UPropertyAliases$findPropertyValueNameGroup(int int ), 0, this, n, n2);
    }

    private String getName(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_impl_UPropertyAliases$getName(int int ), 0, this, n, n2);
    }

    private static int asciiToLowercase(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("asciiToLowercase", $$robo$$android_icu_impl_UPropertyAliases$asciiToLowercase(int ), 0, (int)n);
    }

    private boolean containsName(BytesTrie bytesTrie, CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsName", $$robo$$android_icu_impl_UPropertyAliases$containsName(android.icu.util.BytesTrie java.lang.CharSequence ), 0, this, bytesTrie, charSequence);
    }

    public String getPropertyName(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPropertyName", $$robo$$android_icu_impl_UPropertyAliases$getPropertyName(int int ), 0, this, n, n2);
    }

    public String getPropertyValueName(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("getPropertyValueName", $$robo$$android_icu_impl_UPropertyAliases$getPropertyValueName(int int int ), 0, this, n, n2, n3);
    }

    private int getPropertyOrValueEnum(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("getPropertyOrValueEnum", $$robo$$android_icu_impl_UPropertyAliases$getPropertyOrValueEnum(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public int getPropertyEnum(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("getPropertyEnum", $$robo$$android_icu_impl_UPropertyAliases$getPropertyEnum(java.lang.CharSequence ), 0, this, charSequence);
    }

    public int getPropertyValueEnum(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("getPropertyValueEnum", $$robo$$android_icu_impl_UPropertyAliases$getPropertyValueEnum(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public int getPropertyValueEnumNoThrow(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrap("getPropertyValueEnumNoThrow", $$robo$$android_icu_impl_UPropertyAliases$getPropertyValueEnumNoThrow(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public static int compare(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_impl_UPropertyAliases$compare(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    static {
        RobolectricInternals.classInitializing(UPropertyAliases.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UPropertyAliases)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$isDataVersionAcceptable(byte[] version) {
            return version[0] == 2;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$__constructor__();
        }

        private IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$__constructor__(), 0, this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_UPropertyAliases_IsAcceptable$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

