/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2;
import android.icu.impl.Trie2_16;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUUncheckedIOException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class UBiDiProps
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int[] indexes;
    private int[] mirrors;
    private byte[] jgArray;
    private byte[] jgArray2;
    private Trie2_16 trie;
    private static String DATA_NAME = "ubidi";
    private static String DATA_TYPE = "icu";
    private static String DATA_FILE_NAME = "ubidi.icu";
    private static int FMT = 1114195049;
    private static int IX_TRIE_SIZE = 2;
    private static int IX_MIRROR_LENGTH = 3;
    private static int IX_JG_START = 4;
    private static int IX_JG_LIMIT = 5;
    private static int IX_JG_START2 = 6;
    private static int IX_JG_LIMIT2 = 7;
    private static int IX_MAX_VALUES = 15;
    private static int IX_TOP = 16;
    private static int JT_SHIFT = 5;
    private static int BPT_SHIFT = 8;
    private static int JOIN_CONTROL_SHIFT = 10;
    private static int BIDI_CONTROL_SHIFT = 11;
    private static int IS_MIRRORED_SHIFT = 12;
    private static int MIRROR_DELTA_SHIFT = 13;
    private static int MAX_JG_SHIFT = 16;
    private static int CLASS_MASK = 31;
    private static int JT_MASK = 224;
    private static int BPT_MASK = 768;
    private static int MAX_JG_MASK = 0xFF0000;
    private static int ESC_MIRROR_DELTA = -4;
    private static int MIRROR_INDEX_SHIFT = 21;
    public static UBiDiProps INSTANCE;

    private void $$robo$$android_icu_impl_UBiDiProps$__constructor__() throws IOException {
        ByteBuffer bytes = ICUBinary.getData("ubidi.icu");
        this.readData(bytes);
    }

    private final void $$robo$$android_icu_impl_UBiDiProps$readData(ByteBuffer bytes) throws IOException {
        ICUBinary.readHeader(bytes, 1114195049, new IsAcceptable());
        int count = bytes.getInt();
        if (count < 16) {
            throw new IOException("indexes[0] too small in ubidi.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        for (int i = 1; i < count; ++i) {
            this.indexes[i] = bytes.getInt();
        }
        this.trie = Trie2_16.createFromSerialized(bytes);
        int expectedTrieLength = this.indexes[2];
        int trieLength = this.trie.getSerializedLength();
        if (trieLength > expectedTrieLength) {
            throw new IOException("ubidi.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(bytes, expectedTrieLength - trieLength);
        count = this.indexes[3];
        if (count > 0) {
            this.mirrors = ICUBinary.getInts(bytes, count, 0);
        }
        count = this.indexes[5] - this.indexes[4];
        this.jgArray = new byte[count];
        bytes.get(this.jgArray);
        count = this.indexes[7] - this.indexes[6];
        this.jgArray2 = new byte[count];
        bytes.get(this.jgArray2);
    }

    private final void $$robo$$android_icu_impl_UBiDiProps$addPropertyStarts(UnicodeSet set) {
        int i;
        for (Trie2.Range range : this.trie) {
            if (range.leadSurrogate) break;
            set.add(range.startCodePoint);
        }
        int length = this.indexes[3];
        for (i = 0; i < length; ++i) {
            int c = UBiDiProps.getMirrorCodePoint(this.mirrors[i]);
            set.add(c, c + 1);
        }
        int start = this.indexes[4];
        int limit = this.indexes[5];
        byte[] jga = this.jgArray;
        while (true) {
            length = limit - start;
            byte prev = 0;
            for (i = 0; i < length; ++i) {
                byte jg = jga[i];
                if (jg != prev) {
                    set.add(start);
                    prev = jg;
                }
                ++start;
            }
            if (prev != 0) {
                set.add(limit);
            }
            if (limit != this.indexes[5]) break;
            start = this.indexes[6];
            limit = this.indexes[7];
            jga = this.jgArray2;
        }
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getMaxValue(int which) {
        int max = this.indexes[15];
        switch (which) {
            case 4096: {
                return max & 0x1F;
            }
            case 4102: {
                return (max & 0xFF0000) >> 16;
            }
            case 4103: {
                return (max & 0xE0) >> 5;
            }
            case 4117: {
                return (max & 0x300) >> 8;
            }
        }
        return -1;
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getClass(int c) {
        return UBiDiProps.getClassFromProps(this.trie.get(c));
    }

    private final boolean $$robo$$android_icu_impl_UBiDiProps$isMirrored(int c) {
        return UBiDiProps.getFlagFromProps(this.trie.get(c), 12);
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getMirror(int c, int props) {
        int delta = UBiDiProps.getMirrorDeltaFromProps(props);
        if (delta != -4) {
            return c + delta;
        }
        int length = this.indexes[3];
        for (int i = 0; i < length; ++i) {
            int m = this.mirrors[i];
            int c2 = UBiDiProps.getMirrorCodePoint(m);
            if (c == c2) {
                return UBiDiProps.getMirrorCodePoint(this.mirrors[UBiDiProps.getMirrorIndex(m)]);
            }
            if (c < c2) break;
        }
        return c;
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getMirror(int c) {
        int props = this.trie.get(c);
        return this.getMirror(c, props);
    }

    private final boolean $$robo$$android_icu_impl_UBiDiProps$isBidiControl(int c) {
        return UBiDiProps.getFlagFromProps(this.trie.get(c), 11);
    }

    private final boolean $$robo$$android_icu_impl_UBiDiProps$isJoinControl(int c) {
        return UBiDiProps.getFlagFromProps(this.trie.get(c), 10);
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getJoiningType(int c) {
        return (this.trie.get(c) & 0xE0) >> 5;
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getJoiningGroup(int c) {
        int start = this.indexes[4];
        int limit = this.indexes[5];
        if (start <= c && c < limit) {
            return this.jgArray[c - start] & 0xFF;
        }
        start = this.indexes[6];
        limit = this.indexes[7];
        if (start <= c && c < limit) {
            return this.jgArray2[c - start] & 0xFF;
        }
        return 0;
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getPairedBracketType(int c) {
        return (this.trie.get(c) & 0x300) >> 8;
    }

    private final int $$robo$$android_icu_impl_UBiDiProps$getPairedBracket(int c) {
        int props = this.trie.get(c);
        if ((props & 0x300) == 0) {
            return c;
        }
        return this.getMirror(c, props);
    }

    private static final int $$robo$$android_icu_impl_UBiDiProps$getClassFromProps(int props) {
        return props & 0x1F;
    }

    private static final boolean $$robo$$android_icu_impl_UBiDiProps$getFlagFromProps(int props, int shift) {
        return (props >> shift & 1) != 0;
    }

    private static final int $$robo$$android_icu_impl_UBiDiProps$getMirrorDeltaFromProps(int props) {
        return (short)props >> 13;
    }

    private static final int $$robo$$android_icu_impl_UBiDiProps$getMirrorCodePoint(int m) {
        return m & 0x1FFFFF;
    }

    private static final int $$robo$$android_icu_impl_UBiDiProps$getMirrorIndex(int m) {
        return m >>> 21;
    }

    static void __staticInitializer__() {
        try {
            INSTANCE = new UBiDiProps();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void __constructor__() throws IOException {
        this.$$robo$$android_icu_impl_UBiDiProps$__constructor__();
    }

    private UBiDiProps() throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UBiDiProps$__constructor__(), 0, this);
    }

    private void readData(ByteBuffer byteBuffer) throws IOException {
        InvokeDynamicSupport.bootstrap("readData", $$robo$$android_icu_impl_UBiDiProps$readData(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    public void addPropertyStarts(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addPropertyStarts", $$robo$$android_icu_impl_UBiDiProps$addPropertyStarts(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public int getMaxValue(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxValue", $$robo$$android_icu_impl_UBiDiProps$getMaxValue(int ), 0, this, n);
    }

    public int getClass(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getClass", $$robo$$android_icu_impl_UBiDiProps$getClass(int ), 0, this, n);
    }

    public boolean isMirrored(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMirrored", $$robo$$android_icu_impl_UBiDiProps$isMirrored(int ), 0, this, n);
    }

    private int getMirror(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getMirror", $$robo$$android_icu_impl_UBiDiProps$getMirror(int int ), 0, this, n, n2);
    }

    public int getMirror(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMirror", $$robo$$android_icu_impl_UBiDiProps$getMirror(int ), 0, this, n);
    }

    public boolean isBidiControl(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBidiControl", $$robo$$android_icu_impl_UBiDiProps$isBidiControl(int ), 0, this, n);
    }

    public boolean isJoinControl(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isJoinControl", $$robo$$android_icu_impl_UBiDiProps$isJoinControl(int ), 0, this, n);
    }

    public int getJoiningType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getJoiningType", $$robo$$android_icu_impl_UBiDiProps$getJoiningType(int ), 0, this, n);
    }

    public int getJoiningGroup(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getJoiningGroup", $$robo$$android_icu_impl_UBiDiProps$getJoiningGroup(int ), 0, this, n);
    }

    public int getPairedBracketType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPairedBracketType", $$robo$$android_icu_impl_UBiDiProps$getPairedBracketType(int ), 0, this, n);
    }

    public int getPairedBracket(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPairedBracket", $$robo$$android_icu_impl_UBiDiProps$getPairedBracket(int ), 0, this, n);
    }

    private static int getClassFromProps(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getClassFromProps", $$robo$$android_icu_impl_UBiDiProps$getClassFromProps(int ), 0, (int)n);
    }

    private static boolean getFlagFromProps(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getFlagFromProps", $$robo$$android_icu_impl_UBiDiProps$getFlagFromProps(int int ), 0, (int)n, (int)n2);
    }

    private static int getMirrorDeltaFromProps(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMirrorDeltaFromProps", $$robo$$android_icu_impl_UBiDiProps$getMirrorDeltaFromProps(int ), 0, (int)n);
    }

    private static int getMirrorCodePoint(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMirrorCodePoint", $$robo$$android_icu_impl_UBiDiProps$getMirrorCodePoint(int ), 0, (int)n);
    }

    private static int getMirrorIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMirrorIndex", $$robo$$android_icu_impl_UBiDiProps$getMirrorIndex(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(UBiDiProps.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UBiDiProps)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_UBiDiProps_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_UBiDiProps_IsAcceptable$isDataVersionAcceptable(byte[] version) {
            return version[0] == 2;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_UBiDiProps_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_UBiDiProps_IsAcceptable$__constructor__();
        }

        private IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UBiDiProps_IsAcceptable$__constructor__(), 0, this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_UBiDiProps_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_UBiDiProps_IsAcceptable$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

