/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.lang.UCharacter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextTrieMap<V> {
    public transient /* synthetic */ Object __robo_data__;
    private Node _root;
    boolean _ignoreCase;

    private void $$robo$$android_icu_impl_TextTrieMap$__constructor__(boolean ignoreCase) {
        this._root = new Node(this);
        this._ignoreCase = ignoreCase;
    }

    private final TextTrieMap<V> $$robo$$android_icu_impl_TextTrieMap$put(CharSequence text, V val) {
        CharIterator chitr = new CharIterator(text, 0, this._ignoreCase);
        this._root.add(chitr, val);
        return this;
    }

    private final Iterator<V> $$robo$$android_icu_impl_TextTrieMap$get(String text) {
        return this.get(text, 0);
    }

    private final Iterator<V> $$robo$$android_icu_impl_TextTrieMap$get(CharSequence text, int start) {
        return this.get(text, start, null);
    }

    private final Iterator<V> $$robo$$android_icu_impl_TextTrieMap$get(CharSequence text, int start, int[] matchLen) {
        LongestMatchHandler handler = new LongestMatchHandler();
        this.find(text, start, handler);
        if (matchLen != null && matchLen.length > 0) {
            matchLen[0] = handler.getMatchLength();
        }
        return handler.getMatches();
    }

    private final void $$robo$$android_icu_impl_TextTrieMap$find(CharSequence text, ResultHandler<V> handler) {
        this.find(text, 0, handler);
    }

    private final void $$robo$$android_icu_impl_TextTrieMap$find(CharSequence text, int offset, ResultHandler<V> handler) {
        CharIterator chitr = new CharIterator(text, offset, this._ignoreCase);
        this.find(this._root, chitr, handler);
    }

    private final synchronized void $$robo$$android_icu_impl_TextTrieMap$find(Node node, CharIterator chitr, ResultHandler<V> handler) {
        Iterator values = node.values();
        if (values != null && !handler.handlePrefixMatch(chitr.processedLength(), values)) {
            return;
        }
        Node nextMatch = node.findMatch(chitr);
        if (nextMatch != null) {
            this.find(nextMatch, chitr, handler);
        }
    }

    private static final char[] $$robo$$android_icu_impl_TextTrieMap$toCharArray(CharSequence text) {
        char[] array2 = new char[text.length()];
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = text.charAt(i);
        }
        return array2;
    }

    private static final char[] $$robo$$android_icu_impl_TextTrieMap$subArray(char[] array2, int start) {
        if (start == 0) {
            return array2;
        }
        char[] sub = new char[array2.length - start];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])array2, (int)start, (char[])sub, (int)0, (int)sub.length);
        return sub;
    }

    private static final char[] $$robo$$android_icu_impl_TextTrieMap$subArray(char[] array2, int start, int limit) {
        if (start == 0 && limit == array2.length) {
            return array2;
        }
        char[] sub = new char[limit - start];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])array2, (int)start, (char[])sub, (int)0, (int)(limit - start));
        return sub;
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_icu_impl_TextTrieMap$__constructor__(bl);
    }

    public TextTrieMap(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TextTrieMap$__constructor__(boolean ), 0, this, bl);
    }

    public TextTrieMap<V> put(CharSequence charSequence, V v) {
        return InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_TextTrieMap$put(java.lang.CharSequence V ), 0, this, charSequence, v);
    }

    public Iterator<V> get(String string2) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_TextTrieMap$get(java.lang.String ), 0, this, string2);
    }

    public Iterator<V> get(CharSequence charSequence, int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_TextTrieMap$get(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    public Iterator<V> get(CharSequence charSequence, int n, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_TextTrieMap$get(java.lang.CharSequence int int[] ), 0, this, charSequence, n, nArray);
    }

    public void find(CharSequence charSequence, ResultHandler<V> resultHandler) {
        InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_impl_TextTrieMap$find(java.lang.CharSequence android.icu.impl.TextTrieMap$ResultHandler<V> ), 0, this, charSequence, resultHandler);
    }

    public void find(CharSequence charSequence, int n, ResultHandler<V> resultHandler) {
        InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_impl_TextTrieMap$find(java.lang.CharSequence int android.icu.impl.TextTrieMap$ResultHandler<V> ), 0, this, charSequence, n, resultHandler);
    }

    private synchronized void find(Node node, CharIterator charIterator, ResultHandler<V> resultHandler) {
        InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_impl_TextTrieMap$find(android.icu.impl.TextTrieMap$Node android.icu.impl.TextTrieMap$CharIterator android.icu.impl.TextTrieMap$ResultHandler<V> ), 0, this, node, charIterator, resultHandler);
    }

    private static char[] toCharArray(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("toCharArray", $$robo$$android_icu_impl_TextTrieMap$toCharArray(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    private static char[] subArray(char[] cArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("subArray", $$robo$$android_icu_impl_TextTrieMap$subArray(char[] int ), 0, (char[])cArray, (int)n);
    }

    private static char[] subArray(char[] cArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("subArray", $$robo$$android_icu_impl_TextTrieMap$subArray(char[] int int ), 0, (char[])cArray, (int)n, (int)n2);
    }

    public /* synthetic */ TextTrieMap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextTrieMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private char[] _text;
        private List<V> _values;
        private List<Node> _children;
        /* synthetic */ TextTrieMap this$0;

        private void $$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(TextTrieMap textTrieMap) {
        }

        private void $$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(TextTrieMap textTrieMap, char[] text, List<V> values, List<Node> children) {
            this._text = text;
            this._values = values;
            this._children = children;
        }

        private final Iterator<V> $$robo$$android_icu_impl_TextTrieMap_Node$values() {
            if (this._values == null) {
                return null;
            }
            return this._values.iterator();
        }

        private final void $$robo$$android_icu_impl_TextTrieMap_Node$add(CharIterator chitr, V value) {
            StringBuilder buf = new StringBuilder();
            while (chitr.hasNext()) {
                buf.append(chitr.next());
            }
            this.add(TextTrieMap.toCharArray(buf), 0, value);
        }

        private final Node $$robo$$android_icu_impl_TextTrieMap_Node$findMatch(CharIterator chitr) {
            if (this._children == null) {
                return null;
            }
            if (!chitr.hasNext()) {
                return null;
            }
            Node match = null;
            Object ch = chitr.next();
            for (Node child : this._children) {
                if (((Character)ch).charValue() < child._text[0]) break;
                if (((Character)ch).charValue() != child._text[0]) continue;
                if (!child.matchFollowing(chitr)) break;
                match = child;
                break;
            }
            return match;
        }

        private final void $$robo$$android_icu_impl_TextTrieMap_Node$add(char[] text, int offset, V value) {
            if (text.length == offset) {
                this._values = this.addValue(this._values, value);
                return;
            }
            if (this._children == null) {
                this._children = new LinkedList<Node>();
                Node child = new Node(this.this$0, TextTrieMap.subArray(text, offset), this.addValue(null, value), null);
                this._children.add(child);
                return;
            }
            ListIterator<Node> litr = this._children.listIterator();
            while (litr.hasNext()) {
                Node next = litr.next();
                if (text[offset] < next._text[0]) {
                    litr.previous();
                    break;
                }
                if (text[offset] != next._text[0]) continue;
                int matchLen = next.lenMatches(text, offset);
                if (matchLen == next._text.length) {
                    next.add(text, offset + matchLen, value);
                } else {
                    next.split(matchLen);
                    next.add(text, offset + matchLen, value);
                }
                return;
            }
            litr.add(new Node(this.this$0, TextTrieMap.subArray(text, offset), this.addValue(null, value), null));
        }

        private final boolean $$robo$$android_icu_impl_TextTrieMap_Node$matchFollowing(CharIterator chitr) {
            boolean matched = true;
            for (int idx = 1; idx < this._text.length; ++idx) {
                if (!chitr.hasNext()) {
                    matched = false;
                    break;
                }
                Object ch = chitr.next();
                if (((Character)ch).charValue() == this._text[idx]) continue;
                matched = false;
                break;
            }
            return matched;
        }

        private final int $$robo$$android_icu_impl_TextTrieMap_Node$lenMatches(char[] text, int offset) {
            int len;
            int textLen = text.length - offset;
            int limit = this._text.length < textLen ? this._text.length : textLen;
            for (len = 0; len < limit && this._text[len] == text[offset + len]; ++len) {
            }
            return len;
        }

        private final void $$robo$$android_icu_impl_TextTrieMap_Node$split(int offset) {
            char[] childText = TextTrieMap.subArray(this._text, offset);
            this._text = TextTrieMap.subArray(this._text, 0, offset);
            Node child = new Node(this.this$0, childText, this._values, this._children);
            this._values = null;
            this._children = new LinkedList<Node>();
            this._children.add(child);
        }

        private final List<V> $$robo$$android_icu_impl_TextTrieMap_Node$addValue(List<V> list, V value) {
            if (list == null) {
                list = new LinkedList();
            }
            list.add(value);
            return list;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(TextTrieMap x0, 1 x1) {
        }

        private void __constructor__(TextTrieMap textTrieMap) {
            this.$$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(textTrieMap);
        }

        private Node(TextTrieMap textTrieMap) {
            this.this$0 = textTrieMap;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(android.icu.impl.TextTrieMap ), 0, this, textTrieMap);
        }

        private void __constructor__(TextTrieMap textTrieMap, char[] cArray, List<V> list, List<Node> list2) {
            this.$$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(textTrieMap, cArray, list, list2);
        }

        private Node(TextTrieMap textTrieMap, char[] cArray, List<V> list, List<Node> list2) {
            this.this$0 = textTrieMap;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(android.icu.impl.TextTrieMap char[] java.util.List<V> java.util.List<android.icu.impl.TextTrieMap$Node> ), 0, this, textTrieMap, cArray, list, list2);
        }

        public Iterator<V> values() {
            return InvokeDynamicSupport.bootstrap("values", $$robo$$android_icu_impl_TextTrieMap_Node$values(), 0, this);
        }

        public void add(CharIterator charIterator, V v) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_TextTrieMap_Node$add(android.icu.impl.TextTrieMap$CharIterator V ), 0, this, charIterator, v);
        }

        public Node findMatch(CharIterator charIterator) {
            return InvokeDynamicSupport.bootstrap("findMatch", $$robo$$android_icu_impl_TextTrieMap_Node$findMatch(android.icu.impl.TextTrieMap$CharIterator ), 0, this, charIterator);
        }

        private void add(char[] cArray, int n, V v) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_TextTrieMap_Node$add(char[] int V ), 0, this, cArray, n, v);
        }

        private boolean matchFollowing(CharIterator charIterator) {
            return (boolean)InvokeDynamicSupport.bootstrap("matchFollowing", $$robo$$android_icu_impl_TextTrieMap_Node$matchFollowing(android.icu.impl.TextTrieMap$CharIterator ), 0, this, charIterator);
        }

        private int lenMatches(char[] cArray, int n) {
            return (int)InvokeDynamicSupport.bootstrap("lenMatches", $$robo$$android_icu_impl_TextTrieMap_Node$lenMatches(char[] int ), 0, this, cArray, n);
        }

        private void split(int n) {
            InvokeDynamicSupport.bootstrap("split", $$robo$$android_icu_impl_TextTrieMap_Node$split(int ), 0, this, n);
        }

        private List<V> addValue(List<V> list, V v) {
            return InvokeDynamicSupport.bootstrap("addValue", $$robo$$android_icu_impl_TextTrieMap_Node$addValue(java.util.List<V> V ), 0, this, list, v);
        }

        private /* synthetic */ void __constructor__(TextTrieMap textTrieMap, 1 var2_2) {
            this.$$robo$$android_icu_impl_TextTrieMap_Node$__constructor__(textTrieMap, var2_2);
        }

        public /* synthetic */ Node() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LongestMatchHandler<V>
    implements ResultHandler<V> {
        public transient /* synthetic */ Object __robo_data__;
        private Iterator<V> matches;
        private int length;

        private void $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$__constructor__() {
            this.matches = null;
            this.length = 0;
        }

        private final boolean $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$handlePrefixMatch(int matchLength, Iterator<V> values) {
            if (matchLength > this.length) {
                this.length = matchLength;
                this.matches = values;
            }
            return true;
        }

        private final Iterator<V> $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$getMatches() {
            return this.matches;
        }

        private final int $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$getMatchLength() {
            return this.length;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$__constructor__();
        }

        private LongestMatchHandler() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$__constructor__(), 0, this);
        }

        @Override
        public boolean handlePrefixMatch(int n, Iterator<V> iterator) {
            return (boolean)InvokeDynamicSupport.bootstrap("handlePrefixMatch", $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$handlePrefixMatch(int java.util.Iterator<V> ), 0, this, n, iterator);
        }

        public Iterator<V> getMatches() {
            return InvokeDynamicSupport.bootstrap("getMatches", $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$getMatches(), 0, this);
        }

        public int getMatchLength() {
            return (int)InvokeDynamicSupport.bootstrap("getMatchLength", $$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$getMatchLength(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_TextTrieMap_LongestMatchHandler$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LongestMatchHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ResultHandler<V> {
        public boolean handlePrefixMatch(int var1, Iterator<V> var2);
    }

    public static class CharIterator
    implements Iterator<Character> {
        public transient /* synthetic */ Object __robo_data__;
        private boolean _ignoreCase;
        private CharSequence _text;
        private int _nextIdx;
        private int _startIdx;
        private Character _remainingChar;

        private void $$robo$$android_icu_impl_TextTrieMap_CharIterator$__constructor__(CharSequence text, int offset, boolean ignoreCase) {
            this._text = text;
            this._nextIdx = this._startIdx = offset;
            this._ignoreCase = ignoreCase;
        }

        private final boolean $$robo$$android_icu_impl_TextTrieMap_CharIterator$hasNext() {
            return this._nextIdx != this._text.length() || this._remainingChar != null;
        }

        private final Character $$robo$$android_icu_impl_TextTrieMap_CharIterator$next() {
            Character next;
            if (this._nextIdx == this._text.length() && this._remainingChar == null) {
                return null;
            }
            if (this._remainingChar != null) {
                next = this._remainingChar;
                this._remainingChar = null;
            } else if (this._ignoreCase) {
                int cp = UCharacter.foldCase(Character.codePointAt(this._text, this._nextIdx), true);
                this._nextIdx += Character.charCount(cp);
                char[] chars = Character.toChars(cp);
                next = Character.valueOf(chars[0]);
                if (chars.length == 2) {
                    this._remainingChar = Character.valueOf(chars[1]);
                }
            } else {
                next = Character.valueOf(this._text.charAt(this._nextIdx));
                ++this._nextIdx;
            }
            return next;
        }

        private final void $$robo$$android_icu_impl_TextTrieMap_CharIterator$remove() {
            throw new UnsupportedOperationException("remove() not supproted");
        }

        private final int $$robo$$android_icu_impl_TextTrieMap_CharIterator$nextIndex() {
            return this._nextIdx;
        }

        private final int $$robo$$android_icu_impl_TextTrieMap_CharIterator$processedLength() {
            if (this._remainingChar != null) {
                throw new IllegalStateException("In the middle of surrogate pair");
            }
            return this._nextIdx - this._startIdx;
        }

        private void __constructor__(CharSequence charSequence, int n, boolean bl) {
            this.$$robo$$android_icu_impl_TextTrieMap_CharIterator$__constructor__(charSequence, n, bl);
        }

        CharIterator(CharSequence charSequence, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TextTrieMap_CharIterator$__constructor__(java.lang.CharSequence int boolean ), 0, this, charSequence, n, bl);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_impl_TextTrieMap_CharIterator$hasNext(), 0, this);
        }

        @Override
        public Character next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_TextTrieMap_CharIterator$next(), 0, this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_impl_TextTrieMap_CharIterator$remove(), 0, this);
        }

        public int nextIndex() {
            return (int)InvokeDynamicSupport.bootstrap("nextIndex", $$robo$$android_icu_impl_TextTrieMap_CharIterator$nextIndex(), 0, this);
        }

        public int processedLength() {
            return (int)InvokeDynamicSupport.bootstrap("processedLength", $$robo$$android_icu_impl_TextTrieMap_CharIterator$processedLength(), 0, this);
        }

        public /* synthetic */ CharIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

