/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.CalendarData;
import android.icu.impl.ICUResourceBundle;
import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.icu.text.DateFormat;
import android.icu.text.DisplayContext;
import android.icu.text.MessageFormat;
import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RelativeDateFormat
extends DateFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 1131984966440549435L;
    private DateFormat fDateFormat;
    private DateFormat fTimeFormat;
    private MessageFormat fCombinedFormat;
    private SimpleDateFormat fDateTimeFormat;
    private String fDatePattern;
    private String fTimePattern;
    int fDateStyle;
    int fTimeStyle;
    ULocale fLocale;
    private transient URelativeString[] fDates;
    private boolean combinedFormatHasDateAtStart;
    private boolean capitalizationInfoIsSet;
    private boolean capitalizationOfRelativeUnitsForListOrMenu;
    private boolean capitalizationOfRelativeUnitsForStandAlone;
    private transient BreakIterator capitalizationBrkIter;

    private void $$robo$$android_icu_impl_RelativeDateFormat$__constructor__(int timeStyle, int dateStyle, ULocale locale, Calendar cal) {
        this.fDateTimeFormat = null;
        this.fDatePattern = null;
        this.fTimePattern = null;
        this.fDates = null;
        this.combinedFormatHasDateAtStart = false;
        this.capitalizationInfoIsSet = false;
        this.capitalizationOfRelativeUnitsForListOrMenu = false;
        this.capitalizationOfRelativeUnitsForStandAlone = false;
        this.capitalizationBrkIter = null;
        this.calendar = cal;
        this.fLocale = locale;
        this.fTimeStyle = timeStyle;
        this.fDateStyle = dateStyle;
        if (this.fDateStyle != -1) {
            int newStyle = this.fDateStyle & 0xFFFFFF7F;
            DateFormat df = DateFormat.getDateInstance(newStyle, locale);
            if (!(df instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("Can't create SimpleDateFormat for date style");
            }
            this.fDateTimeFormat = (SimpleDateFormat)df;
            this.fDatePattern = this.fDateTimeFormat.toPattern();
            if (this.fTimeStyle != -1 && (df = DateFormat.getTimeInstance(newStyle = this.fTimeStyle & 0xFFFFFF7F, locale)) instanceof SimpleDateFormat) {
                this.fTimePattern = ((SimpleDateFormat)df).toPattern();
            }
        } else {
            int newStyle = this.fTimeStyle & 0xFFFFFF7F;
            DateFormat df = DateFormat.getTimeInstance(newStyle, locale);
            if (!(df instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("Can't create SimpleDateFormat for time style");
            }
            this.fDateTimeFormat = (SimpleDateFormat)df;
            this.fTimePattern = this.fDateTimeFormat.toPattern();
        }
        this.initializeCalendar(null, this.fLocale);
        this.loadDates();
        this.initializeCombinedFormat(this.calendar, this.fLocale);
    }

    private final StringBuffer $$robo$$android_icu_impl_RelativeDateFormat$format(Calendar cal, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        String relativeDayString = null;
        DisplayContext capitalizationContext = this.getContext(DisplayContext.Type.CAPITALIZATION);
        if (this.fDateStyle != -1) {
            int dayDiff = RelativeDateFormat.dayDifference(cal);
            relativeDayString = this.getStringForDay(dayDiff);
        }
        if (this.fDateTimeFormat != null) {
            if (relativeDayString != null && this.fDatePattern != null && (this.fTimePattern == null || this.fCombinedFormat == null || this.combinedFormatHasDateAtStart)) {
                if (relativeDayString.length() > 0 && UCharacter.isLowerCase(relativeDayString.codePointAt(0)) && (capitalizationContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || capitalizationContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationOfRelativeUnitsForListOrMenu || capitalizationContext == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationOfRelativeUnitsForStandAlone)) {
                    if (this.capitalizationBrkIter == null) {
                        this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.fLocale);
                    }
                    relativeDayString = UCharacter.toTitleCase(this.fLocale, relativeDayString, this.capitalizationBrkIter, 768);
                }
                this.fDateTimeFormat.setContext(DisplayContext.CAPITALIZATION_NONE);
            } else {
                this.fDateTimeFormat.setContext(capitalizationContext);
            }
        }
        if (this.fDateTimeFormat != null && (this.fDatePattern != null || this.fTimePattern != null)) {
            if (this.fDatePattern == null) {
                this.fDateTimeFormat.applyPattern(this.fTimePattern);
                this.fDateTimeFormat.format(cal, toAppendTo, fieldPosition);
            } else if (this.fTimePattern == null) {
                if (relativeDayString != null) {
                    toAppendTo.append(relativeDayString);
                } else {
                    this.fDateTimeFormat.applyPattern(this.fDatePattern);
                    this.fDateTimeFormat.format(cal, toAppendTo, fieldPosition);
                }
            } else {
                String datePattern = this.fDatePattern;
                if (relativeDayString != null) {
                    datePattern = "'" + relativeDayString.replace("'", "''") + "'";
                }
                StringBuffer combinedPattern = new StringBuffer("");
                this.fCombinedFormat.format(new Object[]{this.fTimePattern, datePattern}, combinedPattern, new FieldPosition(0));
                this.fDateTimeFormat.applyPattern(combinedPattern.toString());
                this.fDateTimeFormat.format(cal, toAppendTo, fieldPosition);
            }
        } else if (this.fDateFormat != null) {
            if (relativeDayString != null) {
                toAppendTo.append(relativeDayString);
            } else {
                this.fDateFormat.format(cal, toAppendTo, fieldPosition);
            }
        }
        return toAppendTo;
    }

    private final void $$robo$$android_icu_impl_RelativeDateFormat$parse(String text, Calendar cal, ParsePosition pos) {
        throw new UnsupportedOperationException("Relative Date parse is not implemented yet");
    }

    private final void $$robo$$android_icu_impl_RelativeDateFormat$setContext(DisplayContext context) {
        super.setContext(context);
        if (!(this.capitalizationInfoIsSet || context != DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && context != DisplayContext.CAPITALIZATION_FOR_STANDALONE)) {
            this.initCapitalizationContextInfo(this.fLocale);
            this.capitalizationInfoIsSet = true;
        }
        if (this.capitalizationBrkIter == null && (context == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || context == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationOfRelativeUnitsForListOrMenu || context == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationOfRelativeUnitsForStandAlone)) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.fLocale);
        }
    }

    private final String $$robo$$android_icu_impl_RelativeDateFormat$getStringForDay(int day) {
        if (this.fDates == null) {
            this.loadDates();
        }
        for (int i = 0; i < this.fDates.length; ++i) {
            if (this.fDates[i].offset != day) continue;
            return this.fDates[i].string;
        }
        return null;
    }

    private final synchronized void $$robo$$android_icu_impl_RelativeDateFormat$loadDates() {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", this.fLocale);
        ICUResourceBundle rdb = rb.getWithFallback("fields/day/relative");
        TreeSet<URelativeString> datesSet = new TreeSet<URelativeString>(new Comparator<URelativeString>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RelativeDateFormat this$0;

            private void $$robo$$android_icu_impl_RelativeDateFormat_1$__constructor__(RelativeDateFormat this$0) {
            }

            private final int $$robo$$android_icu_impl_RelativeDateFormat_1$compare(URelativeString r1, URelativeString r2) {
                if (r1.offset == r2.offset) {
                    return 0;
                }
                if (r1.offset < r2.offset) {
                    return -1;
                }
                return 1;
            }

            private void __constructor__(RelativeDateFormat relativeDateFormat) {
                this.$$robo$$android_icu_impl_RelativeDateFormat_1$__constructor__(relativeDateFormat);
            }
            {
                this.this$0 = relativeDateFormat;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_RelativeDateFormat_1$__constructor__(android.icu.impl.RelativeDateFormat ), 0, this, relativeDateFormat);
            }

            @Override
            public int compare(URelativeString uRelativeString, URelativeString uRelativeString2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_icu_impl_RelativeDateFormat_1$compare(android.icu.impl.RelativeDateFormat$URelativeString android.icu.impl.RelativeDateFormat$URelativeString ), 0, this, uRelativeString, uRelativeString2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        UResourceBundleIterator i = rdb.getIterator();
        while (i.hasNext()) {
            UResourceBundle line = i.next();
            String k = line.getKey();
            String v = line.getString();
            URelativeString rs = new URelativeString(k, v);
            datesSet.add(rs);
        }
        this.fDates = datesSet.toArray(new URelativeString[0]);
    }

    private final void $$robo$$android_icu_impl_RelativeDateFormat$initCapitalizationContextInfo(ULocale locale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", locale);
        try {
            ICUResourceBundle rdb = rb.getWithFallback("contextTransforms/relative");
            int[] intVector = rdb.getIntVector();
            if (intVector.length >= 2) {
                this.capitalizationOfRelativeUnitsForListOrMenu = intVector[0] != 0;
                this.capitalizationOfRelativeUnitsForStandAlone = intVector[1] != 0;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static final int $$robo$$android_icu_impl_RelativeDateFormat$dayDifference(Calendar until) {
        Calendar nowCal = (Calendar)until.clone();
        Date nowDate = new Date((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        nowCal.clear();
        nowCal.setTime(nowDate);
        int dayDiff = until.get(20) - nowCal.get(20);
        return dayDiff;
    }

    private final Calendar $$robo$$android_icu_impl_RelativeDateFormat$initializeCalendar(TimeZone zone, ULocale locale) {
        if (this.calendar == null) {
            this.calendar = zone == null ? Calendar.getInstance(locale) : Calendar.getInstance(zone, locale);
        }
        return this.calendar;
    }

    private final MessageFormat $$robo$$android_icu_impl_RelativeDateFormat$initializeCombinedFormat(Calendar cal, ULocale locale) {
        String pattern = "{1} {0}";
        try {
            CalendarData calData = new CalendarData(locale, cal.getType());
            String[] patterns = calData.getDateTimePatterns();
            if (patterns != null && patterns.length >= 9) {
                int glueIndex = 8;
                if (patterns.length >= 13) {
                    switch (this.fDateStyle) {
                        case 0: 
                        case 128: {
                            ++glueIndex;
                            break;
                        }
                        case 1: 
                        case 129: {
                            glueIndex += 2;
                            break;
                        }
                        case 2: 
                        case 130: {
                            glueIndex += 3;
                            break;
                        }
                        case 3: 
                        case 131: {
                            glueIndex += 4;
                            break;
                        }
                    }
                }
                pattern = patterns[glueIndex];
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.combinedFormatHasDateAtStart = pattern.startsWith("{1}");
        this.fCombinedFormat = new MessageFormat(pattern, locale);
        return this.fCombinedFormat;
    }

    private void __constructor__(int n, int n2, ULocale uLocale, Calendar calendar) {
        this.$$robo$$android_icu_impl_RelativeDateFormat$__constructor__(n, n2, uLocale, calendar);
    }

    public RelativeDateFormat(int n, int n2, ULocale uLocale, Calendar calendar) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_RelativeDateFormat$__constructor__(int int android.icu.util.ULocale android.icu.util.Calendar ), 0, this, n, n2, uLocale, calendar);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_impl_RelativeDateFormat$format(android.icu.util.Calendar java.lang.StringBuffer java.text.FieldPosition ), 0, this, calendar, stringBuffer, fieldPosition);
    }

    @Override
    public void parse(String string2, Calendar calendar, ParsePosition parsePosition) {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_impl_RelativeDateFormat$parse(java.lang.String android.icu.util.Calendar java.text.ParsePosition ), 0, this, string2, calendar, parsePosition);
    }

    @Override
    public void setContext(DisplayContext displayContext) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_icu_impl_RelativeDateFormat$setContext(android.icu.text.DisplayContext ), 0, this, displayContext);
    }

    private String getStringForDay(int n) {
        return InvokeDynamicSupport.bootstrap("getStringForDay", $$robo$$android_icu_impl_RelativeDateFormat$getStringForDay(int ), 0, this, n);
    }

    private synchronized void loadDates() {
        InvokeDynamicSupport.bootstrap("loadDates", $$robo$$android_icu_impl_RelativeDateFormat$loadDates(), 0, this);
    }

    private void initCapitalizationContextInfo(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initCapitalizationContextInfo", $$robo$$android_icu_impl_RelativeDateFormat$initCapitalizationContextInfo(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private static int dayDifference(Calendar calendar) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dayDifference", $$robo$$android_icu_impl_RelativeDateFormat$dayDifference(android.icu.util.Calendar ), 0, (Calendar)calendar);
    }

    private Calendar initializeCalendar(TimeZone timeZone, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("initializeCalendar", $$robo$$android_icu_impl_RelativeDateFormat$initializeCalendar(android.icu.util.TimeZone android.icu.util.ULocale ), 0, this, timeZone, uLocale);
    }

    private MessageFormat initializeCombinedFormat(Calendar calendar, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("initializeCombinedFormat", $$robo$$android_icu_impl_RelativeDateFormat$initializeCombinedFormat(android.icu.util.Calendar android.icu.util.ULocale ), 0, this, calendar, uLocale);
    }

    public /* synthetic */ RelativeDateFormat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelativeDateFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class URelativeString
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int offset;
        public String string;

        private void $$robo$$android_icu_impl_RelativeDateFormat_URelativeString$__constructor__(int offset, String string2) {
            this.offset = offset;
            this.string = string2;
        }

        private void $$robo$$android_icu_impl_RelativeDateFormat_URelativeString$__constructor__(String offset, String string2) {
            this.offset = Integer.parseInt(offset);
            this.string = string2;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_icu_impl_RelativeDateFormat_URelativeString$__constructor__(n, string2);
        }

        URelativeString(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_RelativeDateFormat_URelativeString$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_icu_impl_RelativeDateFormat_URelativeString$__constructor__(string2, string3);
        }

        URelativeString(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_RelativeDateFormat_URelativeString$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public /* synthetic */ URelativeString() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (URelativeString)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

