/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2;
import android.icu.impl.Trie2Writable;
import android.icu.impl.Trie2_16;
import android.icu.impl.Trie2_32;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Normalizer2Impl
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static IsAcceptable IS_ACCEPTABLE;
    private static int DATA_FORMAT = 1316121906;
    private static Trie2.ValueMapper segmentStarterMapper;
    public static int MIN_CCC_LCCC_CP = 768;
    public static int MIN_YES_YES_WITH_CC = 65281;
    public static int JAMO_VT = 65280;
    public static int MIN_NORMAL_MAYBE_YES = 65024;
    public static int JAMO_L = 1;
    public static int MAX_DELTA = 64;
    public static int IX_NORM_TRIE_OFFSET = 0;
    public static int IX_EXTRA_DATA_OFFSET = 1;
    public static int IX_SMALL_FCD_OFFSET = 2;
    public static int IX_RESERVED3_OFFSET = 3;
    public static int IX_TOTAL_SIZE = 7;
    public static int IX_MIN_DECOMP_NO_CP = 8;
    public static int IX_MIN_COMP_NO_MAYBE_CP = 9;
    public static int IX_MIN_YES_NO = 10;
    public static int IX_MIN_NO_NO = 11;
    public static int IX_LIMIT_NO_NO = 12;
    public static int IX_MIN_MAYBE_YES = 13;
    public static int IX_MIN_YES_NO_MAPPINGS_ONLY = 14;
    public static int IX_COUNT = 16;
    public static int MAPPING_HAS_CCC_LCCC_WORD = 128;
    public static int MAPPING_HAS_RAW_MAPPING = 64;
    public static int MAPPING_NO_COMP_BOUNDARY_AFTER = 32;
    public static int MAPPING_LENGTH_MASK = 31;
    public static int COMP_1_LAST_TUPLE = 32768;
    public static int COMP_1_TRIPLE = 1;
    public static int COMP_1_TRAIL_LIMIT = 13312;
    public static int COMP_1_TRAIL_MASK = 32766;
    public static int COMP_1_TRAIL_SHIFT = 9;
    public static int COMP_2_TRAIL_SHIFT = 6;
    public static int COMP_2_TRAIL_MASK = 65472;
    private VersionInfo dataVersion;
    private int minDecompNoCP;
    private int minCompNoMaybeCP;
    private int minYesNo;
    private int minYesNoMappingsOnly;
    private int minNoNo;
    private int limitNoNo;
    private int minMaybeYes;
    private Trie2_16 normTrie;
    private String maybeYesCompositions;
    private String extraData;
    private byte[] smallFCD;
    private int[] tccc180;
    private Trie2_32 canonIterData;
    private ArrayList<UnicodeSet> canonStartSets;
    private static int CANON_NOT_SEGMENT_STARTER = Integer.MIN_VALUE;
    private static int CANON_HAS_COMPOSITIONS = 0x40000000;
    private static int CANON_HAS_SET = 0x200000;
    private static int CANON_VALUE_MASK = 0x1FFFFF;

    private void $$robo$$android_icu_impl_Normalizer2Impl$__constructor__() {
    }

    private final Normalizer2Impl $$robo$$android_icu_impl_Normalizer2Impl$load(ByteBuffer bytes) {
        try {
            this.dataVersion = ICUBinary.readHeaderAndDataVersion(bytes, 1316121906, IS_ACCEPTABLE);
            int indexesLength = bytes.getInt() / 4;
            if (indexesLength <= 13) {
                throw new ICUUncheckedIOException("Normalizer2 data: not enough indexes");
            }
            int[] inIndexes = new int[indexesLength];
            inIndexes[0] = indexesLength * 4;
            for (int i = 1; i < indexesLength; ++i) {
                inIndexes[i] = bytes.getInt();
            }
            this.minDecompNoCP = inIndexes[8];
            this.minCompNoMaybeCP = inIndexes[9];
            this.minYesNo = inIndexes[10];
            this.minYesNoMappingsOnly = inIndexes[14];
            this.minNoNo = inIndexes[11];
            this.limitNoNo = inIndexes[12];
            this.minMaybeYes = inIndexes[13];
            int offset = inIndexes[0];
            int nextOffset = inIndexes[1];
            this.normTrie = Trie2_16.createFromSerialized(bytes);
            int trieLength = this.normTrie.getSerializedLength();
            if (trieLength > nextOffset - offset) {
                throw new ICUUncheckedIOException("Normalizer2 data: not enough bytes for normTrie");
            }
            ICUBinary.skipBytes(bytes, nextOffset - offset - trieLength);
            offset = nextOffset;
            nextOffset = inIndexes[2];
            int numChars = (nextOffset - offset) / 2;
            if (numChars != 0) {
                this.maybeYesCompositions = ICUBinary.getString(bytes, numChars, 0);
                this.extraData = this.maybeYesCompositions.substring(65024 - this.minMaybeYes);
            }
            offset = nextOffset;
            this.smallFCD = new byte[256];
            bytes.get(this.smallFCD);
            this.tccc180 = new int[384];
            int bits = 0;
            int c = 0;
            while (c < 384) {
                if ((c & 0xFF) == 0) {
                    bits = this.smallFCD[c >> 8];
                }
                if (bits & true) {
                    int i = 0;
                    while (i < 32) {
                        this.tccc180[c] = this.getFCD16FromNormData(c) & 0xFF;
                        ++i;
                        ++c;
                    }
                } else {
                    c += 32;
                }
                bits >>= 1;
            }
            return this;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private final Normalizer2Impl $$robo$$android_icu_impl_Normalizer2Impl$load(String name) {
        return this.load(ICUBinary.getRequiredData(name));
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$enumLcccRange(int start, int end, int norm16, UnicodeSet set) {
        if (this.isAlgorithmicNoNo(norm16)) {
            do {
                int fcd16;
                if ((fcd16 = this.getFCD16(start)) <= 255) continue;
                set.add(start);
            } while (++start <= end);
        } else {
            int fcd16 = this.getFCD16(start);
            if (fcd16 > 255) {
                set.add(start, end);
            }
        }
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$enumNorm16PropertyStartsRange(int start, int end, int value, UnicodeSet set) {
        set.add(start);
        if (start != end && this.isAlgorithmicNoNo(value)) {
            int prevFCD16 = this.getFCD16(start);
            while (++start <= end) {
                int fcd16 = this.getFCD16(start);
                if (fcd16 == prevFCD16) continue;
                set.add(start);
                prevFCD16 = fcd16;
            }
        }
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$addLcccChars(UnicodeSet set) {
        for (Trie2.Range range : this.normTrie) {
            if (range.leadSurrogate) break;
            this.enumLcccRange(range.startCodePoint, range.endCodePoint, range.value, set);
        }
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$addPropertyStarts(UnicodeSet set) {
        for (Trie2.Range range : this.normTrie) {
            if (range.leadSurrogate) break;
            this.enumNorm16PropertyStartsRange(range.startCodePoint, range.endCodePoint, range.value, set);
        }
        for (int c = 44032; c < 55204; c += 28) {
            set.add(c);
            set.add(c + 1);
        }
        set.add(55204);
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$addCanonIterPropertyStarts(UnicodeSet set) {
        this.ensureCanonIterData();
        Iterator<Trie2.Range> trieIterator = this.canonIterData.iterator(segmentStarterMapper);
        while (trieIterator.hasNext()) {
            Trie2.Range range = trieIterator.next();
            if (range.leadSurrogate) break;
            set.add(range.startCodePoint);
        }
    }

    private final Trie2_16 $$robo$$android_icu_impl_Normalizer2Impl$getNormTrie() {
        return this.normTrie;
    }

    private final synchronized Normalizer2Impl $$robo$$android_icu_impl_Normalizer2Impl$ensureCanonIterData() {
        if (this.canonIterData == null) {
            Trie2Writable newData = new Trie2Writable(0, 0);
            this.canonStartSets = new ArrayList();
            for (Trie2.Range range : this.normTrie) {
                if (range.leadSurrogate) break;
                int norm16 = range.value;
                if (norm16 == 0 || this.minYesNo <= norm16 && norm16 < this.minNoNo) continue;
                for (int c = range.startCodePoint; c <= range.endCodePoint; ++c) {
                    int oldValue;
                    int newValue = oldValue = newData.get(c);
                    if (norm16 >= this.minMaybeYes) {
                        newValue |= Integer.MIN_VALUE;
                        if (norm16 < 65024) {
                            newValue |= 0x40000000;
                        }
                    } else if (norm16 < this.minYesNo) {
                        newValue |= 0x40000000;
                    } else {
                        int c2 = c;
                        int norm16_2 = norm16;
                        while (this.limitNoNo <= norm16_2 && norm16_2 < this.minMaybeYes) {
                            c2 = this.mapAlgorithmic(c2, norm16_2);
                            norm16_2 = this.getNorm16(c2);
                        }
                        if (this.minYesNo <= norm16_2 && norm16_2 < this.limitNoNo) {
                            char firstUnit = this.extraData.charAt(norm16_2);
                            int length = firstUnit & 0x1F;
                            if ((firstUnit & 0x80) != 0 && c == c2 && (this.extraData.charAt(norm16_2 - 1) & 0xFF) != 0) {
                                newValue |= Integer.MIN_VALUE;
                            }
                            if (length != 0) {
                                int limit = ++norm16_2 + length;
                                c2 = this.extraData.codePointAt(norm16_2);
                                this.addToStartSet(newData, c, c2);
                                if (norm16_2 >= this.minNoNo) {
                                    while ((norm16_2 += Character.charCount(c2)) < limit) {
                                        c2 = this.extraData.codePointAt(norm16_2);
                                        int c2Value = newData.get(c2);
                                        if ((c2Value & Integer.MIN_VALUE) != 0) continue;
                                        newData.set(c2, c2Value | Integer.MIN_VALUE);
                                    }
                                }
                            }
                        } else {
                            this.addToStartSet(newData, c, c2);
                        }
                    }
                    if (newValue == oldValue) continue;
                    newData.set(c, newValue);
                }
            }
            this.canonIterData = newData.toTrie2_32();
        }
        return this;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getNorm16(int c) {
        return this.normTrie.get(c);
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getCompQuickCheck(int norm16) {
        if (norm16 < this.minNoNo || 65281 <= norm16) {
            return 1;
        }
        if (this.minMaybeYes <= norm16) {
            return 2;
        }
        return 0;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isAlgorithmicNoNo(int norm16) {
        return this.limitNoNo <= norm16 && norm16 < this.minMaybeYes;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isCompNo(int norm16) {
        return this.minNoNo <= norm16 && norm16 < this.minMaybeYes;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isDecompYes(int norm16) {
        return norm16 < this.minYesNo || this.minMaybeYes <= norm16;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getCC(int norm16) {
        if (norm16 >= 65024) {
            return norm16 & 0xFF;
        }
        if (norm16 < this.minNoNo || this.limitNoNo <= norm16) {
            return 0;
        }
        return this.getCCFromNoNo(norm16);
    }

    private static final int $$robo$$android_icu_impl_Normalizer2Impl$getCCFromYesOrMaybe(int norm16) {
        return norm16 >= 65024 ? norm16 & 0xFF : 0;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getFCD16(int c) {
        if (c < 0) {
            return 0;
        }
        if (c < 384) {
            return this.tccc180[c];
        }
        if (c <= 65535 && !this.singleLeadMightHaveNonZeroFCD16(c)) {
            return 0;
        }
        return this.getFCD16FromNormData(c);
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getFCD16FromBelow180(int c) {
        return this.tccc180[c];
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$singleLeadMightHaveNonZeroFCD16(int lead) {
        byte bits = this.smallFCD[lead >> 8];
        if (bits == 0) {
            return false;
        }
        return (bits >> (lead >> 5 & 7) & 1) != 0;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getFCD16FromNormData(int c) {
        int norm16;
        while (true) {
            if ((norm16 = this.getNorm16(c)) <= this.minYesNo) {
                return 0;
            }
            if (norm16 >= 65024) {
                return (norm16 &= 0xFF) | norm16 << 8;
            }
            if (norm16 >= this.minMaybeYes) {
                return 0;
            }
            if (!this.isDecompNoAlgorithmic(norm16)) break;
            c = this.mapAlgorithmic(c, norm16);
        }
        char firstUnit = this.extraData.charAt(norm16);
        if ((firstUnit & 0x1F) == 0) {
            return 511;
        }
        int fcd16 = firstUnit >> 8;
        if ((firstUnit & 0x80) != 0) {
            fcd16 |= this.extraData.charAt(norm16 - 1) & 0xFF00;
        }
        return fcd16;
    }

    private final String $$robo$$android_icu_impl_Normalizer2Impl$getDecomposition(int c) {
        int norm16;
        int decomp = -1;
        while (c >= this.minDecompNoCP && !this.isDecompYes(norm16 = this.getNorm16(c))) {
            if (this.isHangul(norm16)) {
                StringBuilder buffer = new StringBuilder();
                Hangul.decompose(c, buffer);
                return buffer.toString();
            }
            if (this.isDecompNoAlgorithmic(norm16)) {
                decomp = c = this.mapAlgorithmic(c, norm16);
                continue;
            }
            int length = this.extraData.charAt(norm16++) & 0x1F;
            return this.extraData.substring(norm16, norm16 + length);
        }
        if (decomp < 0) {
            return null;
        }
        return UTF16.valueOf(decomp);
    }

    private final String $$robo$$android_icu_impl_Normalizer2Impl$getRawDecomposition(int c) {
        int norm16;
        if (c < this.minDecompNoCP || this.isDecompYes(norm16 = this.getNorm16(c))) {
            return null;
        }
        if (this.isHangul(norm16)) {
            StringBuilder buffer = new StringBuilder();
            Hangul.getRawDecomposition(c, buffer);
            return buffer.toString();
        }
        if (this.isDecompNoAlgorithmic(norm16)) {
            return UTF16.valueOf(this.mapAlgorithmic(c, norm16));
        }
        char firstUnit = this.extraData.charAt(norm16);
        int mLength = firstUnit & 0x1F;
        if ((firstUnit & 0x40) != 0) {
            int rawMapping = norm16 - (firstUnit >> 7 & 1) - 1;
            char rm0 = this.extraData.charAt(rawMapping);
            if (rm0 <= '\u001f') {
                return this.extraData.substring(rawMapping - rm0, rawMapping);
            }
            StringBuilder buffer = new StringBuilder(mLength - 1).append(rm0);
            return buffer.append(this.extraData, norm16 += 3, norm16 + mLength - 2).toString();
        }
        return this.extraData.substring(++norm16, norm16 + mLength);
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isCanonSegmentStarter(int c) {
        return this.canonIterData.get(c) >= 0;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$getCanonStartSet(int c, UnicodeSet set) {
        int canonValue = this.canonIterData.get(c) & Integer.MAX_VALUE;
        if (canonValue == 0) {
            return false;
        }
        set.clear();
        int value = canonValue & 0x1FFFFF;
        if ((canonValue & 0x200000) != 0) {
            set.addAll(this.canonStartSets.get(value));
        } else if (value != 0) {
            set.add(value);
        }
        if ((canonValue & 0x40000000) != 0) {
            int norm16 = this.getNorm16(c);
            if (norm16 == 1) {
                int syllable = 44032 + (c - 4352) * 588;
                set.add(syllable, syllable + 588 - 1);
            } else {
                this.addComposites(this.getCompositionsList(norm16), set);
            }
        }
        return true;
    }

    private final Appendable $$robo$$android_icu_impl_Normalizer2Impl$decompose(CharSequence s, StringBuilder dest) {
        this.decompose(s, 0, s.length(), dest, s.length());
        return dest;
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$decompose(CharSequence s, int src, int limit, StringBuilder dest, int destLengthEstimate) {
        if (destLengthEstimate < 0) {
            destLengthEstimate = limit - src;
        }
        dest.setLength(0);
        ReorderingBuffer buffer = new ReorderingBuffer(this, dest, destLengthEstimate);
        this.decompose(s, src, limit, buffer);
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$decompose(CharSequence s, int src, int limit, ReorderingBuffer buffer) {
        block11: {
            int minNoCP = this.minDecompNoCP;
            int c = 0;
            int norm16 = 0;
            int prevBoundary = src;
            int prevCC = 0;
            while (true) {
                int cc;
                int prevSrc = src;
                while (src != limit) {
                    char c2;
                    c = s.charAt(src);
                    if (c < minNoCP || this.isMostDecompYesAndZeroCC(norm16 = this.normTrie.getFromU16SingleLead((char)c))) {
                        ++src;
                        continue;
                    }
                    if (!UTF16.isSurrogate((char)c)) break;
                    if (UTF16Plus.isSurrogateLead(c)) {
                        if (src + 1 != limit && Character.isLowSurrogate(c2 = s.charAt(src + 1))) {
                            c = Character.toCodePoint((char)c, c2);
                        }
                    } else if (prevSrc < src && Character.isHighSurrogate(c2 = s.charAt(src - 1))) {
                        --src;
                        c = Character.toCodePoint(c2, (char)c);
                    }
                    if (!this.isMostDecompYesAndZeroCC(norm16 = this.getNorm16(c))) break;
                    src += Character.charCount(c);
                }
                if (src != prevSrc) {
                    if (buffer != null) {
                        buffer.flushAndAppendZeroCC(s, prevSrc, src);
                    } else {
                        prevCC = 0;
                        prevBoundary = src;
                    }
                }
                if (src == limit) break block11;
                src += Character.charCount(c);
                if (buffer != null) {
                    this.decompose(c, norm16, buffer);
                    continue;
                }
                if (!this.isDecompYes(norm16) || prevCC > (cc = Normalizer2Impl.getCCFromYesOrMaybe(norm16)) && cc != 0) break;
                prevCC = cc;
                if (cc > 1) continue;
                prevBoundary = src;
            }
            return prevBoundary;
        }
        return src;
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$decomposeAndAppend(CharSequence s, boolean doDecompose, ReorderingBuffer buffer) {
        int cc;
        int limit = s.length();
        if (limit == 0) {
            return;
        }
        if (doDecompose) {
            this.decompose(s, 0, limit, buffer);
            return;
        }
        int c = Character.codePointAt(s, 0);
        int src = 0;
        int prevCC = cc = this.getCC(this.getNorm16(c));
        int firstCC = cc;
        while (cc != 0) {
            prevCC = cc;
            if ((src += Character.charCount(c)) >= limit) break;
            c = Character.codePointAt(s, src);
            cc = this.getCC(this.getNorm16(c));
        }
        buffer.append(s, 0, src, firstCC, prevCC);
        buffer.append(s, src, limit);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$compose(CharSequence s, int src, int limit, boolean onlyContiguous, boolean doCompose, ReorderingBuffer buffer) {
        int minNoMaybeCP = this.minCompNoMaybeCP;
        int prevBoundary = src;
        int c = 0;
        int norm16 = 0;
        int prevCC = 0;
        while (true) {
            int prevSrc;
            block35: {
                prevSrc = src;
                while (src != limit) {
                    char c2;
                    c = s.charAt(src);
                    if (c < minNoMaybeCP || this.isCompYesAndZeroCC(norm16 = this.normTrie.getFromU16SingleLead((char)c))) {
                        ++src;
                        continue;
                    }
                    if (!UTF16.isSurrogate((char)c)) break;
                    if (UTF16Plus.isSurrogateLead(c)) {
                        if (src + 1 != limit && Character.isLowSurrogate(c2 = s.charAt(src + 1))) {
                            c = Character.toCodePoint((char)c, c2);
                        }
                    } else if (prevSrc < src && Character.isHighSurrogate(c2 = s.charAt(src - 1))) {
                        --src;
                        c = Character.toCodePoint(c2, (char)c);
                    }
                    if (!this.isCompYesAndZeroCC(norm16 = this.getNorm16(c))) break;
                    src += Character.charCount(c);
                }
                if (src != prevSrc) {
                    if (src == limit) {
                        if (!doCompose) return true;
                        buffer.flushAndAppendZeroCC(s, prevSrc, src);
                        return true;
                    }
                    prevBoundary = src - 1;
                    if (Character.isLowSurrogate(s.charAt(prevBoundary)) && prevSrc < prevBoundary && Character.isHighSurrogate(s.charAt(prevBoundary - 1))) {
                        --prevBoundary;
                    }
                    if (doCompose) {
                        buffer.flushAndAppendZeroCC(s, prevSrc, prevBoundary);
                        buffer.append(s, prevBoundary, src);
                    } else {
                        prevCC = 0;
                    }
                    prevSrc = src;
                } else if (src == limit) {
                    return true;
                }
                src += Character.charCount(c);
                if (Normalizer2Impl.isJamoVT(norm16) && prevBoundary != prevSrc) {
                    char prev = s.charAt(prevSrc - 1);
                    boolean needToDecompose = false;
                    if (c < 4519) {
                        if ((prev = (char)(prev - 4352)) < '\u0013') {
                            char t;
                            if (!doCompose) {
                                return false;
                            }
                            char syllable = (char)(44032 + (prev * 21 + (c - 4449)) * 28);
                            if (src != limit && (t = (char)(s.charAt(src) - 4519)) < '\u001c') {
                                syllable = (char)(syllable + t);
                                prevBoundary = ++src;
                                buffer.setLastChar(syllable);
                                continue;
                            }
                            needToDecompose = true;
                        }
                    } else if (Hangul.isHangulWithoutJamoT(prev)) {
                        if (!doCompose) {
                            return false;
                        }
                        buffer.setLastChar((char)(prev + c - 4519));
                        prevBoundary = src;
                        continue;
                    }
                    if (!needToDecompose) {
                        if (doCompose) {
                            buffer.append((char)c);
                            continue;
                        }
                        prevCC = 0;
                        continue;
                    }
                }
                if (norm16 >= 65281) {
                    int cc = norm16 & 0xFF;
                    if (onlyContiguous && (doCompose ? buffer.getLastCC() : prevCC) == 0 && prevBoundary < prevSrc && this.getTrailCCFromCompYesAndZeroCC(s, prevBoundary, prevSrc) > cc) {
                        if (!doCompose) {
                            return false;
                        }
                        break block35;
                    } else {
                        if (doCompose) {
                            buffer.append(c, cc);
                            continue;
                        }
                        if (prevCC > cc) return false;
                        prevCC = cc;
                        continue;
                    }
                }
                if (!doCompose && !this.isMaybeOrNonZeroCC(norm16)) {
                    return false;
                }
            }
            if (this.hasCompBoundaryBefore(c, norm16)) {
                prevBoundary = prevSrc;
            } else if (doCompose) {
                buffer.removeSuffix(prevSrc - prevBoundary);
            }
            src = this.findNextCompBoundary(s, src, limit);
            int recomposeStartIndex = buffer.length();
            this.decomposeShort(s, prevBoundary, src, buffer);
            this.recompose(buffer, recomposeStartIndex, onlyContiguous);
            if (!doCompose) {
                if (!buffer.equals(s, prevBoundary, src)) {
                    return false;
                }
                buffer.remove();
                prevCC = 0;
            }
            prevBoundary = src;
        }
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$composeQuickCheck(CharSequence s, int src, int limit, boolean onlyContiguous, boolean doSpan) {
        int prevBoundary;
        block10: {
            int qcResult = 0;
            int minNoMaybeCP = this.minCompNoMaybeCP;
            prevBoundary = src;
            int c = 0;
            int norm16 = 0;
            int prevCC = 0;
            while (true) {
                int prevSrc = src;
                while (true) {
                    char c2;
                    if (src == limit) {
                        return src << 1 | qcResult;
                    }
                    c = s.charAt(src);
                    if (c < minNoMaybeCP || this.isCompYesAndZeroCC(norm16 = this.normTrie.getFromU16SingleLead((char)c))) {
                        ++src;
                        continue;
                    }
                    if (!UTF16.isSurrogate((char)c)) break;
                    if (UTF16Plus.isSurrogateLead(c)) {
                        if (src + 1 != limit && Character.isLowSurrogate(c2 = s.charAt(src + 1))) {
                            c = Character.toCodePoint((char)c, c2);
                        }
                    } else if (prevSrc < src && Character.isHighSurrogate(c2 = s.charAt(src - 1))) {
                        --src;
                        c = Character.toCodePoint(c2, (char)c);
                    }
                    if (!this.isCompYesAndZeroCC(norm16 = this.getNorm16(c))) break;
                    src += Character.charCount(c);
                }
                if (src != prevSrc) {
                    prevBoundary = src - 1;
                    if (Character.isLowSurrogate(s.charAt(prevBoundary)) && prevSrc < prevBoundary && Character.isHighSurrogate(s.charAt(prevBoundary - 1))) {
                        --prevBoundary;
                    }
                    prevCC = 0;
                    prevSrc = src;
                }
                src += Character.charCount(c);
                if (!this.isMaybeOrNonZeroCC(norm16)) break block10;
                int cc = Normalizer2Impl.getCCFromYesOrMaybe(norm16);
                if (onlyContiguous && cc != 0 && prevCC == 0 && prevBoundary < prevSrc && this.getTrailCCFromCompYesAndZeroCC(s, prevBoundary, prevSrc) > cc || prevCC > cc && cc != 0) break block10;
                prevCC = cc;
                if (norm16 >= 65281) continue;
                if (doSpan) break;
                qcResult = 1;
            }
            return prevBoundary << 1;
        }
        return prevBoundary << 1;
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$composeAndAppend(CharSequence s, boolean doCompose, boolean onlyContiguous, ReorderingBuffer buffer) {
        int firstStarterInSrc;
        int src = 0;
        int limit = s.length();
        if (!buffer.isEmpty() && 0 != (firstStarterInSrc = this.findNextCompBoundary(s, 0, limit))) {
            int lastStarterInDest = this.findPreviousCompBoundary(buffer.getStringBuilder(), buffer.length());
            StringBuilder middle = new StringBuilder(buffer.length() - lastStarterInDest + firstStarterInSrc + 16);
            middle.append(buffer.getStringBuilder(), lastStarterInDest, buffer.length());
            buffer.removeSuffix(buffer.length() - lastStarterInDest);
            middle.append(s, 0, firstStarterInSrc);
            this.compose(middle, 0, middle.length(), onlyContiguous, true, buffer);
            src = firstStarterInSrc;
        }
        if (doCompose) {
            this.compose(s, src, limit, onlyContiguous, true, buffer);
        } else {
            buffer.append(s, src, limit);
        }
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$makeFCD(CharSequence s, int src, int limit, ReorderingBuffer buffer) {
        int prevBoundary = src;
        int c = 0;
        int prevFCD16 = 0;
        int fcd16 = 0;
        while (true) {
            int prevSrc = src;
            while (src != limit) {
                c = s.charAt(src);
                if (c < 768) {
                    prevFCD16 = ~c;
                    ++src;
                    continue;
                }
                if (!this.singleLeadMightHaveNonZeroFCD16(c)) {
                    prevFCD16 = 0;
                    ++src;
                    continue;
                }
                if (UTF16.isSurrogate((char)c)) {
                    char c2;
                    if (UTF16Plus.isSurrogateLead(c)) {
                        if (src + 1 != limit && Character.isLowSurrogate(c2 = s.charAt(src + 1))) {
                            c = Character.toCodePoint((char)c, c2);
                        }
                    } else if (prevSrc < src && Character.isHighSurrogate(c2 = s.charAt(src - 1))) {
                        --src;
                        c = Character.toCodePoint(c2, (char)c);
                    }
                }
                if ((fcd16 = this.getFCD16FromNormData(c)) > 255) break;
                prevFCD16 = fcd16;
                src += Character.charCount(c);
            }
            if (src != prevSrc) {
                if (src == limit) {
                    if (buffer == null) break;
                    buffer.flushAndAppendZeroCC(s, prevSrc, src);
                    break;
                }
                prevBoundary = src;
                if (prevFCD16 < 0) {
                    int prev = ~prevFCD16;
                    int n = prevFCD16 = prev < 384 ? this.tccc180[prev] : this.getFCD16FromNormData(prev);
                    if (prevFCD16 > 1) {
                        --prevBoundary;
                    }
                } else {
                    int p = src - 1;
                    if (Character.isLowSurrogate(s.charAt(p)) && prevSrc < p && Character.isHighSurrogate(s.charAt(p - 1))) {
                        prevFCD16 = this.getFCD16FromNormData(Character.toCodePoint(s.charAt(--p), s.charAt(p + 1)));
                    }
                    if (prevFCD16 > 1) {
                        prevBoundary = p;
                    }
                }
                if (buffer != null) {
                    buffer.flushAndAppendZeroCC(s, prevSrc, prevBoundary);
                    buffer.append(s, prevBoundary, src);
                }
                prevSrc = src;
            } else if (src == limit) break;
            src += Character.charCount(c);
            if ((prevFCD16 & 0xFF) <= fcd16 >> 8) {
                if ((fcd16 & 0xFF) <= 1) {
                    prevBoundary = src;
                }
                if (buffer != null) {
                    buffer.appendZeroCC(c);
                }
                prevFCD16 = fcd16;
                continue;
            }
            if (buffer == null) {
                return prevBoundary;
            }
            buffer.removeSuffix(prevSrc - prevBoundary);
            src = this.findNextFCDBoundary(s, src, limit);
            this.decomposeShort(s, prevBoundary, src, buffer);
            prevBoundary = src;
            prevFCD16 = 0;
        }
        return src;
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$makeFCDAndAppend(CharSequence s, boolean doMakeFCD, ReorderingBuffer buffer) {
        int firstBoundaryInSrc;
        int src = 0;
        int limit = s.length();
        if (!buffer.isEmpty() && 0 != (firstBoundaryInSrc = this.findNextFCDBoundary(s, 0, limit))) {
            int lastBoundaryInDest = this.findPreviousFCDBoundary(buffer.getStringBuilder(), buffer.length());
            StringBuilder middle = new StringBuilder(buffer.length() - lastBoundaryInDest + firstBoundaryInSrc + 16);
            middle.append(buffer.getStringBuilder(), lastBoundaryInDest, buffer.length());
            buffer.removeSuffix(buffer.length() - lastBoundaryInDest);
            middle.append(s, 0, firstBoundaryInSrc);
            this.makeFCD(middle, 0, middle.length(), buffer);
            src = firstBoundaryInSrc;
        }
        if (doMakeFCD) {
            this.makeFCD(s, src, limit, buffer);
        } else {
            buffer.append(s, src, limit);
        }
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$hasDecompBoundary(int c, boolean before) {
        int norm16;
        while (true) {
            if (c < this.minDecompNoCP) {
                return true;
            }
            norm16 = this.getNorm16(c);
            if (this.isHangul(norm16) || this.isDecompYesAndZeroCC(norm16)) {
                return true;
            }
            if (norm16 > 65024) {
                return false;
            }
            if (!this.isDecompNoAlgorithmic(norm16)) break;
            c = this.mapAlgorithmic(c, norm16);
        }
        char firstUnit = this.extraData.charAt(norm16);
        if ((firstUnit & 0x1F) == 0) {
            return false;
        }
        if (!before) {
            if (firstUnit > '\u01ff') {
                return false;
            }
            if (firstUnit <= '\u00ff') {
                return true;
            }
        }
        return (firstUnit & 0x80) == 0 || (this.extraData.charAt(norm16 - 1) & 0xFF00) == 0;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isDecompInert(int c) {
        return this.isDecompYesAndZeroCC(this.getNorm16(c));
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$hasCompBoundaryBefore(int c) {
        return c < this.minCompNoMaybeCP || this.hasCompBoundaryBefore(c, this.getNorm16(c));
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$hasCompBoundaryAfter(int c, boolean onlyContiguous, boolean testInert) {
        int norm16;
        while (true) {
            if (Normalizer2Impl.isInert(norm16 = this.getNorm16(c))) {
                return true;
            }
            if (norm16 <= this.minYesNo) {
                return this.isHangul(norm16) && !Hangul.isHangulWithoutJamoT((char)c);
            }
            if (norm16 >= (testInert ? this.minNoNo : this.minMaybeYes)) {
                return false;
            }
            if (!this.isDecompNoAlgorithmic(norm16)) break;
            c = this.mapAlgorithmic(c, norm16);
        }
        char firstUnit = this.extraData.charAt(norm16);
        return (firstUnit & 0x20) == 0 && (!onlyContiguous || firstUnit <= '\u01ff');
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$hasFCDBoundaryBefore(int c) {
        return c < 768 || this.getFCD16(c) <= 255;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$hasFCDBoundaryAfter(int c) {
        int fcd16 = this.getFCD16(c);
        return fcd16 <= 1 || (fcd16 & 0xFF) == 0;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isFCDInert(int c) {
        return this.getFCD16(c) <= 1;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isMaybe(int norm16) {
        return this.minMaybeYes <= norm16 && norm16 <= 65280;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isMaybeOrNonZeroCC(int norm16) {
        return norm16 >= this.minMaybeYes;
    }

    private static final boolean $$robo$$android_icu_impl_Normalizer2Impl$isInert(int norm16) {
        return norm16 == 0;
    }

    private static final boolean $$robo$$android_icu_impl_Normalizer2Impl$isJamoL(int norm16) {
        return norm16 == 1;
    }

    private static final boolean $$robo$$android_icu_impl_Normalizer2Impl$isJamoVT(int norm16) {
        return norm16 == 65280;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isHangul(int norm16) {
        return norm16 == this.minYesNo;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isCompYesAndZeroCC(int norm16) {
        return norm16 < this.minNoNo;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isDecompYesAndZeroCC(int norm16) {
        return norm16 < this.minYesNo || norm16 == 65280 || this.minMaybeYes <= norm16 && norm16 <= 65024;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isMostDecompYesAndZeroCC(int norm16) {
        return norm16 < this.minYesNo || norm16 == 65024 || norm16 == 65280;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$isDecompNoAlgorithmic(int norm16) {
        return norm16 >= this.limitNoNo;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getCCFromNoNo(int norm16) {
        if ((this.extraData.charAt(norm16) & 0x80) != 0) {
            return this.extraData.charAt(norm16 - 1) & 0xFF;
        }
        return 0;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getTrailCCFromCompYesAndZeroCC(CharSequence s, int cpStart, int cpLimit) {
        int c = cpStart == cpLimit - 1 ? s.charAt(cpStart) : Character.codePointAt(s, cpStart);
        int prevNorm16 = this.getNorm16(c);
        if (prevNorm16 <= this.minYesNo) {
            return 0;
        }
        return this.extraData.charAt(prevNorm16) >> 8;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$mapAlgorithmic(int c, int norm16) {
        return c + norm16 - (this.minMaybeYes - 64 - 1);
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getCompositionsListForDecompYes(int norm16) {
        if (norm16 == 0 || 65024 <= norm16) {
            return -1;
        }
        if ((norm16 -= this.minMaybeYes) < 0) {
            norm16 += 65024;
        }
        return norm16;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getCompositionsListForComposite(int norm16) {
        char firstUnit = this.extraData.charAt(norm16);
        return 65024 - this.minMaybeYes + norm16 + 1 + (firstUnit & 0x1F);
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$getCompositionsList(int norm16) {
        return this.isDecompYes(norm16) ? this.getCompositionsListForDecompYes(norm16) : this.getCompositionsListForComposite(norm16);
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$decomposeShort(CharSequence s, int src, int limit, ReorderingBuffer buffer) {
        while (src < limit) {
            int c = Character.codePointAt(s, src);
            src += Character.charCount(c);
            this.decompose(c, this.getNorm16(c), buffer);
        }
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$decompose(int c, int norm16, ReorderingBuffer buffer) {
        block3: {
            while (true) {
                if (this.isDecompYes(norm16)) {
                    buffer.append(c, Normalizer2Impl.getCCFromYesOrMaybe(norm16));
                    break block3;
                }
                if (this.isHangul(norm16)) {
                    Hangul.decompose(c, buffer);
                    break block3;
                }
                if (!this.isDecompNoAlgorithmic(norm16)) break;
                c = this.mapAlgorithmic(c, norm16);
                norm16 = this.getNorm16(c);
            }
            char firstUnit = this.extraData.charAt(norm16);
            int length = firstUnit & 0x1F;
            int trailCC = firstUnit >> 8;
            int leadCC = (firstUnit & 0x80) != 0 ? this.extraData.charAt(norm16 - 1) >> 8 : 0;
            buffer.append(this.extraData, ++norm16, norm16 + length, leadCC, trailCC);
        }
    }

    private static final int $$robo$$android_icu_impl_Normalizer2Impl$combine(String compositions, int list, int trail) {
        block9: {
            if (trail < 13312) {
                char firstUnit;
                int key1 = trail << 1;
                while (key1 > (firstUnit = compositions.charAt(list))) {
                    list += 2 + (firstUnit & '\u0001');
                }
                if (key1 == (firstUnit & 0x7FFE)) {
                    if ((firstUnit & '\u0001') != 0) {
                        return compositions.charAt(list + 1) << 16 | compositions.charAt(list + 2);
                    }
                    return compositions.charAt(list + 1);
                }
            } else {
                char secondUnit;
                int key1 = 13312 + (trail >> 9 & 0xFFFFFFFE);
                int key2 = trail << 6 & 0xFFFF;
                while (true) {
                    char firstUnit;
                    if (key1 > (firstUnit = compositions.charAt(list))) {
                        list += 2 + (firstUnit & '\u0001');
                        continue;
                    }
                    if (key1 != (firstUnit & 0x7FFE)) break block9;
                    secondUnit = compositions.charAt(list + 1);
                    if (key2 <= secondUnit) break;
                    if ((firstUnit & 0x8000) == 0) {
                        list += 3;
                        continue;
                    }
                    break block9;
                    break;
                }
                if (key2 == (secondUnit & 0xFFC0)) {
                    return (secondUnit & 0xFFFF003F) << 16 | compositions.charAt(list + 2);
                }
            }
        }
        return -1;
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$addComposites(int list, UnicodeSet set) {
        char firstUnit;
        do {
            int compositeAndFwd;
            if (((firstUnit = this.maybeYesCompositions.charAt(list)) & '\u0001') == 0) {
                compositeAndFwd = this.maybeYesCompositions.charAt(list + 1);
                list += 2;
            } else {
                compositeAndFwd = (this.maybeYesCompositions.charAt(list + 1) & 0xFFFF003F) << 16 | this.maybeYesCompositions.charAt(list + 2);
                list += 3;
            }
            int composite = compositeAndFwd >> 1;
            if ((compositeAndFwd & '\u0001') != 0) {
                this.addComposites(this.getCompositionsListForComposite(this.getNorm16(composite)), set);
            }
            set.add(composite);
        } while ((firstUnit & 0x8000) == 0);
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$recompose(ReorderingBuffer buffer, int recomposeStartIndex, boolean onlyContiguous) {
        int p = recomposeStartIndex;
        StringBuilder sb = buffer.getStringBuilder();
        if (p == sb.length()) {
            return;
        }
        int compositionsList = -1;
        int starter = -1;
        boolean starterIsSupplementary = false;
        int prevCC = 0;
        while (true) {
            int c = sb.codePointAt(p);
            p += Character.charCount(c);
            int norm16 = this.getNorm16(c);
            int cc = Normalizer2Impl.getCCFromYesOrMaybe(norm16);
            if (this.isMaybe(norm16) && compositionsList >= 0 && (prevCC < cc || prevCC == 0)) {
                int pRemove;
                if (Normalizer2Impl.isJamoVT(norm16)) {
                    char prev;
                    if (c < 4519 && (prev = (char)(sb.charAt(starter) - 4352)) < '\u0013') {
                        char t;
                        pRemove = p - 1;
                        char syllable = (char)(44032 + (prev * 21 + (c - 4449)) * 28);
                        if (p != sb.length() && (t = (char)(sb.charAt(p) - 4519)) < '\u001c') {
                            ++p;
                            syllable = (char)(syllable + t);
                        }
                        sb.setCharAt(starter, syllable);
                        sb.delete(pRemove, p);
                        p = pRemove;
                    }
                    if (p == sb.length()) break;
                    compositionsList = -1;
                    continue;
                }
                int compositeAndFwd = Normalizer2Impl.combine(this.maybeYesCompositions, compositionsList, c);
                if (compositeAndFwd >= 0) {
                    int composite = compositeAndFwd >> 1;
                    pRemove = p - Character.charCount(c);
                    sb.delete(pRemove, p);
                    p = pRemove;
                    if (starterIsSupplementary) {
                        if (composite > 65535) {
                            sb.setCharAt(starter, UTF16.getLeadSurrogate(composite));
                            sb.setCharAt(starter + 1, UTF16.getTrailSurrogate(composite));
                        } else {
                            sb.setCharAt(starter, (char)c);
                            sb.deleteCharAt(starter + 1);
                            starterIsSupplementary = false;
                            --p;
                        }
                    } else if (composite > 65535) {
                        starterIsSupplementary = true;
                        sb.setCharAt(starter, UTF16.getLeadSurrogate(composite));
                        sb.insert(starter + 1, UTF16.getTrailSurrogate(composite));
                        ++p;
                    } else {
                        sb.setCharAt(starter, (char)composite);
                    }
                    if (p == sb.length()) break;
                    if ((compositeAndFwd & 1) != 0) {
                        compositionsList = this.getCompositionsListForComposite(this.getNorm16(composite));
                        continue;
                    }
                    compositionsList = -1;
                    continue;
                }
            }
            prevCC = cc;
            if (p == sb.length()) break;
            if (cc == 0) {
                compositionsList = this.getCompositionsListForDecompYes(norm16);
                if (compositionsList < 0) continue;
                if (c <= 65535) {
                    starterIsSupplementary = false;
                    starter = p - 1;
                    continue;
                }
                starterIsSupplementary = true;
                starter = p - 2;
                continue;
            }
            if (!onlyContiguous) continue;
            compositionsList = -1;
        }
        buffer.flush();
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$composePair(int a, int b) {
        int list;
        int norm16 = this.getNorm16(a);
        if (Normalizer2Impl.isInert(norm16)) {
            return -1;
        }
        if (norm16 < this.minYesNoMappingsOnly) {
            if (Normalizer2Impl.isJamoL(norm16)) {
                if (0 <= (b -= 4449) && b < 21) {
                    return 44032 + ((a - 4352) * 21 + b) * 28;
                }
                return -1;
            }
            if (this.isHangul(norm16)) {
                if (Hangul.isHangulWithoutJamoT((char)a) && 0 < (b -= 4519) && b < 28) {
                    return a + b;
                }
                return -1;
            }
            list = norm16;
            if (norm16 > this.minYesNo) {
                list += 1 + (this.extraData.charAt(list) & 0x1F);
            }
            list += 65024 - this.minMaybeYes;
        } else {
            if (norm16 < this.minMaybeYes || 65024 <= norm16) {
                return -1;
            }
            list = norm16 - this.minMaybeYes;
        }
        if (b < 0 || 0x10FFFF < b) {
            return -1;
        }
        return Normalizer2Impl.combine(this.maybeYesCompositions, list, b) >> 1;
    }

    private final boolean $$robo$$android_icu_impl_Normalizer2Impl$hasCompBoundaryBefore(int c, int norm16) {
        while (true) {
            if (this.isCompYesAndZeroCC(norm16)) {
                return true;
            }
            if (this.isMaybeOrNonZeroCC(norm16)) {
                return false;
            }
            if (!this.isDecompNoAlgorithmic(norm16)) break;
            c = this.mapAlgorithmic(c, norm16);
            norm16 = this.getNorm16(c);
        }
        char firstUnit = this.extraData.charAt(norm16);
        if ((firstUnit & 0x1F) == 0) {
            return false;
        }
        if ((firstUnit & 0x80) != 0 && (this.extraData.charAt(norm16 - 1) & 0xFF00) != 0) {
            return false;
        }
        return this.isCompYesAndZeroCC(this.getNorm16(Character.codePointAt(this.extraData, norm16 + 1)));
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$findPreviousCompBoundary(CharSequence s, int p) {
        while (p > 0) {
            int c = Character.codePointBefore(s, p);
            p -= Character.charCount(c);
            if (!this.hasCompBoundaryBefore(c)) continue;
            break;
        }
        return p;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$findNextCompBoundary(CharSequence s, int p, int limit) {
        int norm16;
        int c;
        while (p < limit && !this.hasCompBoundaryBefore(c = Character.codePointAt(s, p), norm16 = this.normTrie.get(c))) {
            p += Character.charCount(c);
        }
        return p;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$findPreviousFCDBoundary(CharSequence s, int p) {
        while (p > 0) {
            int c = Character.codePointBefore(s, p);
            p -= Character.charCount(c);
            if (c >= 768 && this.getFCD16(c) > 255) continue;
            break;
        }
        return p;
    }

    private final int $$robo$$android_icu_impl_Normalizer2Impl$findNextFCDBoundary(CharSequence s, int p, int limit) {
        int c;
        while (p < limit && (c = Character.codePointAt(s, p)) >= 768 && this.getFCD16(c) > 255) {
            p += Character.charCount(c);
        }
        return p;
    }

    private final void $$robo$$android_icu_impl_Normalizer2Impl$addToStartSet(Trie2Writable newData, int origin, int decompLead) {
        int canonValue = newData.get(decompLead);
        if ((canonValue & 0x3FFFFF) == 0 && origin != 0) {
            newData.set(decompLead, canonValue | origin);
        } else {
            UnicodeSet set;
            if ((canonValue & 0x200000) == 0) {
                int firstOrigin = canonValue & 0x1FFFFF;
                canonValue = canonValue & 0xFFE00000 | 0x200000 | this.canonStartSets.size();
                newData.set(decompLead, canonValue);
                set = new UnicodeSet();
                this.canonStartSets.add(set);
                if (firstOrigin != 0) {
                    set.add(firstOrigin);
                }
            } else {
                set = this.canonStartSets.get(canonValue & 0x1FFFFF);
            }
            set.add(origin);
        }
    }

    static void __staticInitializer__() {
        IS_ACCEPTABLE = new IsAcceptable();
        segmentStarterMapper = new Trie2.ValueMapper(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_impl_Normalizer2Impl_1$__constructor__() {
            }

            private final int $$robo$$android_icu_impl_Normalizer2Impl_1$map(int in) {
                return in & Integer.MIN_VALUE;
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_Normalizer2Impl_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Normalizer2Impl_1$__constructor__(), 0, this);
            }

            @Override
            public int map(int n) {
                return (int)InvokeDynamicSupport.bootstrap("map", $$robo$$android_icu_impl_Normalizer2Impl_1$map(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_Normalizer2Impl$__constructor__();
    }

    public Normalizer2Impl() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Normalizer2Impl$__constructor__(), 0, this);
    }

    public Normalizer2Impl load(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrap("load", $$robo$$android_icu_impl_Normalizer2Impl$load(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    public Normalizer2Impl load(String string2) {
        return InvokeDynamicSupport.bootstrap("load", $$robo$$android_icu_impl_Normalizer2Impl$load(java.lang.String ), 0, this, string2);
    }

    private void enumLcccRange(int n, int n2, int n3, UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("enumLcccRange", $$robo$$android_icu_impl_Normalizer2Impl$enumLcccRange(int int int android.icu.text.UnicodeSet ), 0, this, n, n2, n3, unicodeSet);
    }

    private void enumNorm16PropertyStartsRange(int n, int n2, int n3, UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("enumNorm16PropertyStartsRange", $$robo$$android_icu_impl_Normalizer2Impl$enumNorm16PropertyStartsRange(int int int android.icu.text.UnicodeSet ), 0, this, n, n2, n3, unicodeSet);
    }

    public void addLcccChars(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addLcccChars", $$robo$$android_icu_impl_Normalizer2Impl$addLcccChars(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public void addPropertyStarts(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addPropertyStarts", $$robo$$android_icu_impl_Normalizer2Impl$addPropertyStarts(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public void addCanonIterPropertyStarts(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addCanonIterPropertyStarts", $$robo$$android_icu_impl_Normalizer2Impl$addCanonIterPropertyStarts(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public Trie2_16 getNormTrie() {
        return InvokeDynamicSupport.bootstrap("getNormTrie", $$robo$$android_icu_impl_Normalizer2Impl$getNormTrie(), 0, this);
    }

    public synchronized Normalizer2Impl ensureCanonIterData() {
        return InvokeDynamicSupport.bootstrap("ensureCanonIterData", $$robo$$android_icu_impl_Normalizer2Impl$ensureCanonIterData(), 0, this);
    }

    public int getNorm16(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNorm16", $$robo$$android_icu_impl_Normalizer2Impl$getNorm16(int ), 0, this, n);
    }

    public int getCompQuickCheck(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCompQuickCheck", $$robo$$android_icu_impl_Normalizer2Impl$getCompQuickCheck(int ), 0, this, n);
    }

    public boolean isAlgorithmicNoNo(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlgorithmicNoNo", $$robo$$android_icu_impl_Normalizer2Impl$isAlgorithmicNoNo(int ), 0, this, n);
    }

    public boolean isCompNo(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompNo", $$robo$$android_icu_impl_Normalizer2Impl$isCompNo(int ), 0, this, n);
    }

    public boolean isDecompYes(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecompYes", $$robo$$android_icu_impl_Normalizer2Impl$isDecompYes(int ), 0, this, n);
    }

    public int getCC(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCC", $$robo$$android_icu_impl_Normalizer2Impl$getCC(int ), 0, this, n);
    }

    public static int getCCFromYesOrMaybe(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCCFromYesOrMaybe", $$robo$$android_icu_impl_Normalizer2Impl$getCCFromYesOrMaybe(int ), 0, (int)n);
    }

    public int getFCD16(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFCD16", $$robo$$android_icu_impl_Normalizer2Impl$getFCD16(int ), 0, this, n);
    }

    public int getFCD16FromBelow180(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFCD16FromBelow180", $$robo$$android_icu_impl_Normalizer2Impl$getFCD16FromBelow180(int ), 0, this, n);
    }

    public boolean singleLeadMightHaveNonZeroFCD16(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("singleLeadMightHaveNonZeroFCD16", $$robo$$android_icu_impl_Normalizer2Impl$singleLeadMightHaveNonZeroFCD16(int ), 0, this, n);
    }

    public int getFCD16FromNormData(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFCD16FromNormData", $$robo$$android_icu_impl_Normalizer2Impl$getFCD16FromNormData(int ), 0, this, n);
    }

    public String getDecomposition(int n) {
        return InvokeDynamicSupport.bootstrap("getDecomposition", $$robo$$android_icu_impl_Normalizer2Impl$getDecomposition(int ), 0, this, n);
    }

    public String getRawDecomposition(int n) {
        return InvokeDynamicSupport.bootstrap("getRawDecomposition", $$robo$$android_icu_impl_Normalizer2Impl$getRawDecomposition(int ), 0, this, n);
    }

    public boolean isCanonSegmentStarter(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCanonSegmentStarter", $$robo$$android_icu_impl_Normalizer2Impl$isCanonSegmentStarter(int ), 0, this, n);
    }

    public boolean getCanonStartSet(int n, UnicodeSet unicodeSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("getCanonStartSet", $$robo$$android_icu_impl_Normalizer2Impl$getCanonStartSet(int android.icu.text.UnicodeSet ), 0, this, n, unicodeSet);
    }

    public Appendable decompose(CharSequence charSequence, StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("decompose", $$robo$$android_icu_impl_Normalizer2Impl$decompose(java.lang.CharSequence java.lang.StringBuilder ), 0, this, charSequence, stringBuilder);
    }

    public void decompose(CharSequence charSequence, int n, int n2, StringBuilder stringBuilder, int n3) {
        InvokeDynamicSupport.bootstrap("decompose", $$robo$$android_icu_impl_Normalizer2Impl$decompose(java.lang.CharSequence int int java.lang.StringBuilder int ), 0, this, charSequence, n, n2, stringBuilder, n3);
    }

    public int decompose(CharSequence charSequence, int n, int n2, ReorderingBuffer reorderingBuffer) {
        return (int)InvokeDynamicSupport.bootstrap("decompose", $$robo$$android_icu_impl_Normalizer2Impl$decompose(java.lang.CharSequence int int android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, n, n2, reorderingBuffer);
    }

    public void decomposeAndAppend(CharSequence charSequence, boolean bl, ReorderingBuffer reorderingBuffer) {
        InvokeDynamicSupport.bootstrap("decomposeAndAppend", $$robo$$android_icu_impl_Normalizer2Impl$decomposeAndAppend(java.lang.CharSequence boolean android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, bl, reorderingBuffer);
    }

    public boolean compose(CharSequence charSequence, int n, int n2, boolean bl, boolean bl2, ReorderingBuffer reorderingBuffer) {
        return (boolean)InvokeDynamicSupport.bootstrap("compose", $$robo$$android_icu_impl_Normalizer2Impl$compose(java.lang.CharSequence int int boolean boolean android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, n, n2, bl, bl2, reorderingBuffer);
    }

    public int composeQuickCheck(CharSequence charSequence, int n, int n2, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("composeQuickCheck", $$robo$$android_icu_impl_Normalizer2Impl$composeQuickCheck(java.lang.CharSequence int int boolean boolean ), 0, this, charSequence, n, n2, bl, bl2);
    }

    public void composeAndAppend(CharSequence charSequence, boolean bl, boolean bl2, ReorderingBuffer reorderingBuffer) {
        InvokeDynamicSupport.bootstrap("composeAndAppend", $$robo$$android_icu_impl_Normalizer2Impl$composeAndAppend(java.lang.CharSequence boolean boolean android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, bl, bl2, reorderingBuffer);
    }

    public int makeFCD(CharSequence charSequence, int n, int n2, ReorderingBuffer reorderingBuffer) {
        return (int)InvokeDynamicSupport.bootstrap("makeFCD", $$robo$$android_icu_impl_Normalizer2Impl$makeFCD(java.lang.CharSequence int int android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, n, n2, reorderingBuffer);
    }

    public void makeFCDAndAppend(CharSequence charSequence, boolean bl, ReorderingBuffer reorderingBuffer) {
        InvokeDynamicSupport.bootstrap("makeFCDAndAppend", $$robo$$android_icu_impl_Normalizer2Impl$makeFCDAndAppend(java.lang.CharSequence boolean android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, bl, reorderingBuffer);
    }

    public boolean hasDecompBoundary(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDecompBoundary", $$robo$$android_icu_impl_Normalizer2Impl$hasDecompBoundary(int boolean ), 0, this, n, bl);
    }

    public boolean isDecompInert(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecompInert", $$robo$$android_icu_impl_Normalizer2Impl$isDecompInert(int ), 0, this, n);
    }

    public boolean hasCompBoundaryBefore(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCompBoundaryBefore", $$robo$$android_icu_impl_Normalizer2Impl$hasCompBoundaryBefore(int ), 0, this, n);
    }

    public boolean hasCompBoundaryAfter(int n, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCompBoundaryAfter", $$robo$$android_icu_impl_Normalizer2Impl$hasCompBoundaryAfter(int boolean boolean ), 0, this, n, bl, bl2);
    }

    public boolean hasFCDBoundaryBefore(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFCDBoundaryBefore", $$robo$$android_icu_impl_Normalizer2Impl$hasFCDBoundaryBefore(int ), 0, this, n);
    }

    public boolean hasFCDBoundaryAfter(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFCDBoundaryAfter", $$robo$$android_icu_impl_Normalizer2Impl$hasFCDBoundaryAfter(int ), 0, this, n);
    }

    public boolean isFCDInert(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFCDInert", $$robo$$android_icu_impl_Normalizer2Impl$isFCDInert(int ), 0, this, n);
    }

    private boolean isMaybe(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMaybe", $$robo$$android_icu_impl_Normalizer2Impl$isMaybe(int ), 0, this, n);
    }

    private boolean isMaybeOrNonZeroCC(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMaybeOrNonZeroCC", $$robo$$android_icu_impl_Normalizer2Impl$isMaybeOrNonZeroCC(int ), 0, this, n);
    }

    private static boolean isInert(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInert", $$robo$$android_icu_impl_Normalizer2Impl$isInert(int ), 0, (int)n);
    }

    private static boolean isJamoL(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJamoL", $$robo$$android_icu_impl_Normalizer2Impl$isJamoL(int ), 0, (int)n);
    }

    private static boolean isJamoVT(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJamoVT", $$robo$$android_icu_impl_Normalizer2Impl$isJamoVT(int ), 0, (int)n);
    }

    private boolean isHangul(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHangul", $$robo$$android_icu_impl_Normalizer2Impl$isHangul(int ), 0, this, n);
    }

    private boolean isCompYesAndZeroCC(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompYesAndZeroCC", $$robo$$android_icu_impl_Normalizer2Impl$isCompYesAndZeroCC(int ), 0, this, n);
    }

    private boolean isDecompYesAndZeroCC(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecompYesAndZeroCC", $$robo$$android_icu_impl_Normalizer2Impl$isDecompYesAndZeroCC(int ), 0, this, n);
    }

    private boolean isMostDecompYesAndZeroCC(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMostDecompYesAndZeroCC", $$robo$$android_icu_impl_Normalizer2Impl$isMostDecompYesAndZeroCC(int ), 0, this, n);
    }

    private boolean isDecompNoAlgorithmic(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecompNoAlgorithmic", $$robo$$android_icu_impl_Normalizer2Impl$isDecompNoAlgorithmic(int ), 0, this, n);
    }

    private int getCCFromNoNo(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCCFromNoNo", $$robo$$android_icu_impl_Normalizer2Impl$getCCFromNoNo(int ), 0, this, n);
    }

    int getTrailCCFromCompYesAndZeroCC(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getTrailCCFromCompYesAndZeroCC", $$robo$$android_icu_impl_Normalizer2Impl$getTrailCCFromCompYesAndZeroCC(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    private int mapAlgorithmic(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("mapAlgorithmic", $$robo$$android_icu_impl_Normalizer2Impl$mapAlgorithmic(int int ), 0, this, n, n2);
    }

    private int getCompositionsListForDecompYes(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCompositionsListForDecompYes", $$robo$$android_icu_impl_Normalizer2Impl$getCompositionsListForDecompYes(int ), 0, this, n);
    }

    private int getCompositionsListForComposite(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCompositionsListForComposite", $$robo$$android_icu_impl_Normalizer2Impl$getCompositionsListForComposite(int ), 0, this, n);
    }

    private int getCompositionsList(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCompositionsList", $$robo$$android_icu_impl_Normalizer2Impl$getCompositionsList(int ), 0, this, n);
    }

    public void decomposeShort(CharSequence charSequence, int n, int n2, ReorderingBuffer reorderingBuffer) {
        InvokeDynamicSupport.bootstrap("decomposeShort", $$robo$$android_icu_impl_Normalizer2Impl$decomposeShort(java.lang.CharSequence int int android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, charSequence, n, n2, reorderingBuffer);
    }

    private void decompose(int n, int n2, ReorderingBuffer reorderingBuffer) {
        InvokeDynamicSupport.bootstrap("decompose", $$robo$$android_icu_impl_Normalizer2Impl$decompose(int int android.icu.impl.Normalizer2Impl$ReorderingBuffer ), 0, this, n, n2, reorderingBuffer);
    }

    private static int combine(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("combine", $$robo$$android_icu_impl_Normalizer2Impl$combine(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    private void addComposites(int n, UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addComposites", $$robo$$android_icu_impl_Normalizer2Impl$addComposites(int android.icu.text.UnicodeSet ), 0, this, n, unicodeSet);
    }

    private void recompose(ReorderingBuffer reorderingBuffer, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("recompose", $$robo$$android_icu_impl_Normalizer2Impl$recompose(android.icu.impl.Normalizer2Impl$ReorderingBuffer int boolean ), 0, this, reorderingBuffer, n, bl);
    }

    public int composePair(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("composePair", $$robo$$android_icu_impl_Normalizer2Impl$composePair(int int ), 0, this, n, n2);
    }

    private boolean hasCompBoundaryBefore(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCompBoundaryBefore", $$robo$$android_icu_impl_Normalizer2Impl$hasCompBoundaryBefore(int int ), 0, this, n, n2);
    }

    private int findPreviousCompBoundary(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findPreviousCompBoundary", $$robo$$android_icu_impl_Normalizer2Impl$findPreviousCompBoundary(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    private int findNextCompBoundary(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findNextCompBoundary", $$robo$$android_icu_impl_Normalizer2Impl$findNextCompBoundary(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    private int findPreviousFCDBoundary(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findPreviousFCDBoundary", $$robo$$android_icu_impl_Normalizer2Impl$findPreviousFCDBoundary(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    private int findNextFCDBoundary(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findNextFCDBoundary", $$robo$$android_icu_impl_Normalizer2Impl$findNextFCDBoundary(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    private void addToStartSet(Trie2Writable trie2Writable, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addToStartSet", $$robo$$android_icu_impl_Normalizer2Impl$addToStartSet(android.icu.impl.Trie2Writable int int ), 0, this, trie2Writable, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(Normalizer2Impl.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Normalizer2Impl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$isDataVersionAcceptable(byte[] version) {
            return version[0] == 2;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$__constructor__();
        }

        private IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$__constructor__(), 0, this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_Normalizer2Impl_IsAcceptable$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class UTF16Plus
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$__constructor__() {
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$isSurrogateLead(int c) {
            return (c & 0x400) == 0;
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$equal(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return true;
            }
            int length = s1.length();
            if (length != s2.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$equal(CharSequence s1, int start1, int limit1, CharSequence s2, int start2, int limit2) {
            if (limit1 - start1 != limit2 - start2) {
                return false;
            }
            if (s1 == s2 && start1 == start2) {
                return true;
            }
            while (start1 < limit1) {
                if (s1.charAt(start1++) == s2.charAt(start2++)) continue;
                return false;
            }
            return true;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$__constructor__();
        }

        public UTF16Plus() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$__constructor__(), 0, this);
        }

        public static boolean isSurrogateLead(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isSurrogateLead", $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$isSurrogateLead(int ), 0, (int)n);
        }

        public static boolean equal(CharSequence charSequence, CharSequence charSequence2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("equal", $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$equal(java.lang.CharSequence java.lang.CharSequence ), 0, (CharSequence)charSequence, (CharSequence)charSequence2);
        }

        public static boolean equal(CharSequence charSequence, int n, int n2, CharSequence charSequence2, int n3, int n4) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("equal", $$robo$$android_icu_impl_Normalizer2Impl_UTF16Plus$equal(java.lang.CharSequence int int java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2, (CharSequence)charSequence2, (int)n3, (int)n4);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UTF16Plus)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ReorderingBuffer
    implements Appendable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Normalizer2Impl impl;
        private Appendable app;
        private StringBuilder str;
        private boolean appIsStringBuilder;
        private int reorderStart;
        private int lastCC;
        private int codePointStart;
        private int codePointLimit;

        private void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$__constructor__(Normalizer2Impl ni, Appendable dest, int destCapacity) {
            this.impl = ni;
            this.app = dest;
            if (this.app instanceof StringBuilder) {
                this.appIsStringBuilder = true;
                this.str = (StringBuilder)dest;
                this.str.ensureCapacity(destCapacity);
                this.reorderStart = 0;
                if (this.str.length() == 0) {
                    this.lastCC = 0;
                } else {
                    this.setIterator();
                    this.lastCC = this.previousCC();
                    if (this.lastCC > 1) {
                        while (this.previousCC() > 1) {
                        }
                    }
                    this.reorderStart = this.codePointLimit;
                }
            } else {
                this.appIsStringBuilder = false;
                this.str = new StringBuilder();
                this.reorderStart = 0;
                this.lastCC = 0;
            }
        }

        private final boolean $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$isEmpty() {
            return this.str.length() == 0;
        }

        private final int $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$length() {
            return this.str.length();
        }

        private final int $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$getLastCC() {
            return this.lastCC;
        }

        private final StringBuilder $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$getStringBuilder() {
            return this.str;
        }

        private final boolean $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$equals(CharSequence s, int start, int limit) {
            return UTF16Plus.equal(this.str, 0, this.str.length(), s, start, limit);
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$setLastChar(char c) {
            this.str.setCharAt(this.str.length() - 1, c);
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(int c, int cc) {
            if (this.lastCC <= cc || cc == 0) {
                this.str.appendCodePoint(c);
                this.lastCC = cc;
                if (cc <= 1) {
                    this.reorderStart = this.str.length();
                }
            } else {
                this.insert(c, cc);
            }
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(CharSequence s, int start, int limit, int leadCC, int trailCC) {
            if (start == limit) {
                return;
            }
            if (this.lastCC <= leadCC || leadCC == 0) {
                if (trailCC <= 1) {
                    this.reorderStart = this.str.length() + (limit - start);
                } else if (leadCC <= 1) {
                    this.reorderStart = this.str.length() + 1;
                }
                this.str.append(s, start, limit);
                this.lastCC = trailCC;
            } else {
                int c = Character.codePointAt(s, start);
                start += Character.charCount(c);
                this.insert(c, leadCC);
                while (start < limit) {
                    leadCC = (start += Character.charCount(c = Character.codePointAt(s, start))) < limit ? Normalizer2Impl.getCCFromYesOrMaybe(this.impl.getNorm16(c)) : trailCC;
                    this.append(c, leadCC);
                }
            }
        }

        private final ReorderingBuffer $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(char c) {
            this.str.append(c);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
            return this;
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$appendZeroCC(int c) {
            this.str.appendCodePoint(c);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
        }

        private final ReorderingBuffer $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(CharSequence s) {
            if (s.length() != 0) {
                this.str.append(s);
                this.lastCC = 0;
                this.reorderStart = this.str.length();
            }
            return this;
        }

        private final ReorderingBuffer $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(CharSequence s, int start, int limit) {
            if (start != limit) {
                this.str.append(s, start, limit);
                this.lastCC = 0;
                this.reorderStart = this.str.length();
            }
            return this;
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$flush() {
            if (this.appIsStringBuilder) {
                this.reorderStart = this.str.length();
            } else {
                try {
                    this.app.append(this.str);
                    this.str.setLength(0);
                    this.reorderStart = 0;
                }
                catch (IOException e) {
                    throw new ICUUncheckedIOException(e);
                }
            }
            this.lastCC = 0;
        }

        private final ReorderingBuffer $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$flushAndAppendZeroCC(CharSequence s, int start, int limit) {
            if (this.appIsStringBuilder) {
                this.str.append(s, start, limit);
                this.reorderStart = this.str.length();
            } else {
                try {
                    this.app.append(this.str).append(s, start, limit);
                    this.str.setLength(0);
                    this.reorderStart = 0;
                }
                catch (IOException e) {
                    throw new ICUUncheckedIOException(e);
                }
            }
            this.lastCC = 0;
            return this;
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$remove() {
            this.str.setLength(0);
            this.lastCC = 0;
            this.reorderStart = 0;
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$removeSuffix(int suffixLength) {
            int oldLength = this.str.length();
            this.str.delete(oldLength - suffixLength, oldLength);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$insert(int c, int cc) {
            this.setIterator();
            this.skipPrevious();
            while (this.previousCC() > cc) {
            }
            if (c <= 65535) {
                this.str.insert(this.codePointLimit, (char)c);
                if (cc <= 1) {
                    this.reorderStart = this.codePointLimit + 1;
                }
            } else {
                this.str.insert(this.codePointLimit, Character.toChars(c));
                if (cc <= 1) {
                    this.reorderStart = this.codePointLimit + 2;
                }
            }
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$setIterator() {
            this.codePointStart = this.str.length();
        }

        private final void $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$skipPrevious() {
            this.codePointLimit = this.codePointStart;
            this.codePointStart = this.str.offsetByCodePoints(this.codePointStart, -1);
        }

        private final int $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$previousCC() {
            this.codePointLimit = this.codePointStart;
            if (this.reorderStart >= this.codePointStart) {
                return 0;
            }
            int c = this.str.codePointBefore(this.codePointStart);
            this.codePointStart -= Character.charCount(c);
            if (c < 768) {
                return 0;
            }
            return Normalizer2Impl.getCCFromYesOrMaybe(this.impl.getNorm16(c));
        }

        private void __constructor__(Normalizer2Impl normalizer2Impl, Appendable appendable, int n) {
            this.$$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$__constructor__(normalizer2Impl, appendable, n);
        }

        public ReorderingBuffer(Normalizer2Impl normalizer2Impl, Appendable appendable, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$__constructor__(android.icu.impl.Normalizer2Impl java.lang.Appendable int ), 0, this, normalizer2Impl, appendable, n);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$isEmpty(), 0, this);
        }

        public int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$length(), 0, this);
        }

        public int getLastCC() {
            return (int)InvokeDynamicSupport.bootstrap("getLastCC", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$getLastCC(), 0, this);
        }

        public StringBuilder getStringBuilder() {
            return InvokeDynamicSupport.bootstrap("getStringBuilder", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$getStringBuilder(), 0, this);
        }

        public boolean equals(CharSequence charSequence, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$equals(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        public void setLastChar(char c) {
            InvokeDynamicSupport.bootstrap("setLastChar", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$setLastChar(char ), 0, this, c);
        }

        public void append(int n, int n2) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(int int ), 0, this, n, n2);
        }

        public void append(CharSequence charSequence, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(java.lang.CharSequence int int int int ), 0, this, charSequence, n, n2, n3, n4);
        }

        @Override
        public ReorderingBuffer append(char c) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(char ), 0, this, c);
        }

        public void appendZeroCC(int n) {
            InvokeDynamicSupport.bootstrap("appendZeroCC", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$appendZeroCC(int ), 0, this, n);
        }

        @Override
        public ReorderingBuffer append(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public ReorderingBuffer append(CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$append(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        public void flush() {
            InvokeDynamicSupport.bootstrap("flush", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$flush(), 0, this);
        }

        public ReorderingBuffer flushAndAppendZeroCC(CharSequence charSequence, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("flushAndAppendZeroCC", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$flushAndAppendZeroCC(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$remove(), 0, this);
        }

        public void removeSuffix(int n) {
            InvokeDynamicSupport.bootstrap("removeSuffix", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$removeSuffix(int ), 0, this, n);
        }

        private void insert(int n, int n2) {
            InvokeDynamicSupport.bootstrap("insert", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$insert(int int ), 0, this, n, n2);
        }

        private void setIterator() {
            InvokeDynamicSupport.bootstrap("setIterator", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$setIterator(), 0, this);
        }

        private void skipPrevious() {
            InvokeDynamicSupport.bootstrap("skipPrevious", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$skipPrevious(), 0, this);
        }

        private int previousCC() {
            return (int)InvokeDynamicSupport.bootstrap("previousCC", $$robo$$android_icu_impl_Normalizer2Impl_ReorderingBuffer$previousCC(), 0, this);
        }

        public /* synthetic */ ReorderingBuffer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReorderingBuffer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Hangul
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int JAMO_L_BASE = 4352;
        public static int JAMO_L_END = 4370;
        public static int JAMO_V_BASE = 4449;
        public static int JAMO_V_END = 4469;
        public static int JAMO_T_BASE = 4519;
        public static int JAMO_T_END = 4546;
        public static int HANGUL_BASE = 44032;
        public static int HANGUL_END = 55203;
        public static int JAMO_L_COUNT = 19;
        public static int JAMO_V_COUNT = 21;
        public static int JAMO_T_COUNT = 28;
        public static int JAMO_L_LIMIT = 4371;
        public static int JAMO_V_LIMIT = 4470;
        public static int JAMO_VT_COUNT = 588;
        public static int HANGUL_COUNT = 11172;
        public static int HANGUL_LIMIT = 55204;

        private void $$robo$$android_icu_impl_Normalizer2Impl_Hangul$__constructor__() {
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isHangul(int c) {
            return 44032 <= c && c < 55204;
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isHangulWithoutJamoT(char c) {
            return (c = (char)(c - 44032)) < '\u2ba4' && c % 28 == 0;
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isJamoL(int c) {
            return 4352 <= c && c < 4371;
        }

        private static final boolean $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isJamoV(int c) {
            return 4449 <= c && c < 4470;
        }

        private static final int $$robo$$android_icu_impl_Normalizer2Impl_Hangul$decompose(int c, Appendable buffer) {
            try {
                int c2 = (c -= 44032) % 28;
                buffer.append((char)(4352 + (c /= 28) / 21));
                buffer.append((char)(4449 + c % 21));
                if (c2 == 0) {
                    return 2;
                }
                buffer.append((char)(4519 + c2));
                return 3;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        private static final void $$robo$$android_icu_impl_Normalizer2Impl_Hangul$getRawDecomposition(int c, Appendable buffer) {
            try {
                int orig = c;
                int c2 = (c -= 44032) % 28;
                if (c2 == 0) {
                    buffer.append((char)(4352 + (c /= 28) / 21));
                    buffer.append((char)(4449 + c % 21));
                } else {
                    buffer.append((char)(orig - c2));
                    buffer.append((char)(4519 + c2));
                }
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_Normalizer2Impl_Hangul$__constructor__();
        }

        public Hangul() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$__constructor__(), 0, this);
        }

        public static boolean isHangul(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isHangul", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isHangul(int ), 0, (int)n);
        }

        public static boolean isHangulWithoutJamoT(char c) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isHangulWithoutJamoT", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isHangulWithoutJamoT(char ), 0, (char)c);
        }

        public static boolean isJamoL(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isJamoL", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isJamoL(int ), 0, (int)n);
        }

        public static boolean isJamoV(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isJamoV", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$isJamoV(int ), 0, (int)n);
        }

        public static int decompose(int n, Appendable appendable) {
            return (int)InvokeDynamicSupport.bootstrapStatic("decompose", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$decompose(int java.lang.Appendable ), 0, (int)n, (Appendable)appendable);
        }

        public static void getRawDecomposition(int n, Appendable appendable) {
            InvokeDynamicSupport.bootstrapStatic("getRawDecomposition", $$robo$$android_icu_impl_Normalizer2Impl_Hangul$getRawDecomposition(int java.lang.Appendable ), 0, (int)n, (Appendable)appendable);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Hangul)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

