/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CharTrie
extends Trie
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private char m_initialValue_;
    private char[] m_data_;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_CharTrie$__constructor__(ByteBuffer bytes, Trie.DataManipulate dataManipulate) {
        if (!this.isCharTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a char trie.");
        }
    }

    private void $$robo$$android_icu_impl_CharTrie$__constructor__(int initialValue, int leadUnitValue, Trie.DataManipulate dataManipulate) {
        int i;
        int latin1Length = 256;
        int dataLength = 256;
        if (leadUnitValue != initialValue) {
            dataLength += 32;
        }
        this.m_data_ = new char[dataLength];
        this.m_dataLength_ = dataLength;
        this.m_initialValue_ = (char)initialValue;
        for (i = 0; i < latin1Length; ++i) {
            this.m_data_[i] = (char)initialValue;
        }
        if (leadUnitValue != initialValue) {
            char block = (char)(latin1Length >> 2);
            int limit = 1760;
            for (i = 1728; i < limit; ++i) {
                this.m_index_[i] = block;
            }
            limit = latin1Length + 32;
            for (i = latin1Length; i < limit; ++i) {
                this.m_data_[i] = (char)leadUnitValue;
            }
        }
    }

    private final char $$robo$$android_icu_impl_CharTrie$getCodePointValue(int ch) {
        if (0 <= ch && ch < 55296) {
            int offset = (this.m_index_[ch >> 5] << 2) + (ch & 0x1F);
            return this.m_data_[offset];
        }
        int offset = this.getCodePointOffset(ch);
        return offset >= 0 ? this.m_data_[offset] : this.m_initialValue_;
    }

    private final char $$robo$$android_icu_impl_CharTrie$getLeadValue(char ch) {
        return this.m_data_[this.getLeadOffset(ch)];
    }

    private final char $$robo$$android_icu_impl_CharTrie$getBMPValue(char ch) {
        return this.m_data_[this.getBMPOffset(ch)];
    }

    private final char $$robo$$android_icu_impl_CharTrie$getSurrogateValue(char lead, char trail) {
        int offset = this.getSurrogateOffset(lead, trail);
        if (offset > 0) {
            return this.m_data_[offset];
        }
        return this.m_initialValue_;
    }

    private final char $$robo$$android_icu_impl_CharTrie$getTrailValue(int leadvalue, char trail) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int offset = this.m_dataManipulate_.getFoldingOffset(leadvalue);
        if (offset > 0) {
            return this.m_data_[this.getRawOffset(offset, (char)(trail & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    private final char $$robo$$android_icu_impl_CharTrie$getLatin1LinearValue(char ch) {
        return this.m_data_[32 + this.m_dataOffset_ + ch];
    }

    private final boolean $$robo$$android_icu_impl_CharTrie$equals(Object other) {
        boolean result = super.equals(other);
        if (result && other instanceof CharTrie) {
            CharTrie othertrie = (CharTrie)other;
            return this.m_initialValue_ == othertrie.m_initialValue_;
        }
        return false;
    }

    private final int $$robo$$android_icu_impl_CharTrie$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final void $$robo$$android_icu_impl_CharTrie$unserialize(ByteBuffer bytes) {
        int indexDataLength = this.m_dataOffset_ + this.m_dataLength_;
        this.m_index_ = ICUBinary.getChars(bytes, indexDataLength, 0);
        this.m_data_ = this.m_index_;
        this.m_initialValue_ = this.m_data_[this.m_dataOffset_];
    }

    private final int $$robo$$android_icu_impl_CharTrie$getSurrogateOffset(char lead, char trail) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int offset = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(lead));
        if (offset > 0) {
            return this.getRawOffset(offset, (char)(trail & 0x3FF));
        }
        return -1;
    }

    private final int $$robo$$android_icu_impl_CharTrie$getValue(int index) {
        return this.m_data_[index];
    }

    private final int $$robo$$android_icu_impl_CharTrie$getInitialValue() {
        return this.m_initialValue_;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !CharTrie.class.desiredAssertionStatus();
    }

    private void __constructor__(ByteBuffer byteBuffer, Trie.DataManipulate dataManipulate) {
        this.$$robo$$android_icu_impl_CharTrie$__constructor__(byteBuffer, dataManipulate);
    }

    public CharTrie(ByteBuffer byteBuffer, Trie.DataManipulate dataManipulate) {
        super(byteBuffer, dataManipulate);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CharTrie$__constructor__(java.nio.ByteBuffer android.icu.impl.Trie$DataManipulate ), 0, this, byteBuffer, dataManipulate);
    }

    private void __constructor__(int n, int n2, Trie.DataManipulate dataManipulate) {
        this.$$robo$$android_icu_impl_CharTrie$__constructor__(n, n2, dataManipulate);
    }

    public CharTrie(int n, int n2, Trie.DataManipulate dataManipulate) {
        super(new char[2080], 512, dataManipulate);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CharTrie$__constructor__(int int android.icu.impl.Trie$DataManipulate ), 0, this, n, n2, dataManipulate);
    }

    public char getCodePointValue(int n) {
        return (char)InvokeDynamicSupport.bootstrap("getCodePointValue", $$robo$$android_icu_impl_CharTrie$getCodePointValue(int ), 0, this, n);
    }

    public char getLeadValue(char c) {
        return (char)InvokeDynamicSupport.bootstrap("getLeadValue", $$robo$$android_icu_impl_CharTrie$getLeadValue(char ), 0, this, c);
    }

    public char getBMPValue(char c) {
        return (char)InvokeDynamicSupport.bootstrap("getBMPValue", $$robo$$android_icu_impl_CharTrie$getBMPValue(char ), 0, this, c);
    }

    public char getSurrogateValue(char c, char c2) {
        return (char)InvokeDynamicSupport.bootstrap("getSurrogateValue", $$robo$$android_icu_impl_CharTrie$getSurrogateValue(char char ), 0, this, c, c2);
    }

    public char getTrailValue(int n, char c) {
        return (char)InvokeDynamicSupport.bootstrap("getTrailValue", $$robo$$android_icu_impl_CharTrie$getTrailValue(int char ), 0, this, n, c);
    }

    public char getLatin1LinearValue(char c) {
        return (char)InvokeDynamicSupport.bootstrap("getLatin1LinearValue", $$robo$$android_icu_impl_CharTrie$getLatin1LinearValue(char ), 0, this, c);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_CharTrie$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_CharTrie$hashCode(), 0, this);
    }

    @Override
    protected void unserialize(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("unserialize", $$robo$$android_icu_impl_CharTrie$unserialize(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    @Override
    protected int getSurrogateOffset(char c, char c2) {
        return (int)InvokeDynamicSupport.bootstrap("getSurrogateOffset", $$robo$$android_icu_impl_CharTrie$getSurrogateOffset(char char ), 0, this, c, c2);
    }

    @Override
    protected int getValue(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_impl_CharTrie$getValue(int ), 0, this, n);
    }

    @Override
    protected int getInitialValue() {
        return (int)InvokeDynamicSupport.bootstrap("getInitialValue", $$robo$$android_icu_impl_CharTrie$getInitialValue(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CharTrie.class);
    }

    public /* synthetic */ CharTrie() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharTrie)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

