/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContextHubService
extends IContextHubService.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String CONTEXTHUB_SERVICE = "contexthub_service";
    private static String TAG = "ContextHubService";
    private static String HARDWARE_PERMISSION = "android.permission.LOCATION_HARDWARE";
    private static String ENFORCE_HW_PERMISSION_MESSAGE = "Permission 'android.permission.LOCATION_HARDWARE' not granted to access ContextHub Hardware";
    public static int ANY_HUB = -1;
    public static int MSG_LOAD_NANO_APP = 3;
    public static int MSG_UNLOAD_NANO_APP = 4;
    private static String PRE_LOADED_GENERIC_UNKNOWN = "Preloaded app, unknown";
    private static String PRE_LOADED_APP_NAME = "Preloaded app, unknown";
    private static String PRE_LOADED_APP_PUBLISHER = "Preloaded app, unknown";
    private static int PRE_LOADED_APP_MEM_REQ = 0;
    private static int MSG_HEADER_SIZE = 4;
    private static int MSG_FIELD_TYPE = 0;
    private static int MSG_FIELD_VERSION = 1;
    private static int MSG_FIELD_HUB_HANDLE = 2;
    private static int MSG_FIELD_APP_INSTANCE = 3;
    private static int OS_APP_INSTANCE = -1;
    private static long APP_ID_ACTIVITY_RECOGNITION = 5147455389092024320L;
    private Context mContext;
    private ConcurrentHashMap<Integer, NanoAppInstanceInfo> mNanoAppHash;
    private ContextHubInfo[] mContextHubInfo;
    private RemoteCallbackList<IContextHubCallback> mCallbacksList;
    private IVrStateCallbacks mVrStateCallbacks;

    private final int $$robo$$android_hardware_location_ContextHubService$nativeSendMessage(int[] nArray, byte[] byArray) {
        return 0;
    }

    private final ContextHubInfo[] $$robo$$android_hardware_location_ContextHubService$nativeInitialize() {
        return null;
    }

    private void $$robo$$android_hardware_location_ContextHubService$__constructor__(Context context) {
        IVrManager vrManager;
        this.mNanoAppHash = new ConcurrentHashMap();
        this.mCallbacksList = new RemoteCallbackList();
        this.mVrStateCallbacks = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ContextHubService this$0;

            private void $$robo$$android_hardware_location_ContextHubService_1$__constructor__(ContextHubService this$0) {
            }

            private final void $$robo$$android_hardware_location_ContextHubService_1$onVrStateChanged(boolean enabled) {
                for (NanoAppInstanceInfo app : this.this$0.mNanoAppHash.values()) {
                    if (app.getAppId() != 5147455389092024320L) continue;
                    this.this$0.sendVrStateChangeMessageToApp(app, enabled);
                    break;
                }
            }

            private void __constructor__(ContextHubService contextHubService) {
                this.$$robo$$android_hardware_location_ContextHubService_1$__constructor__(contextHubService);
            }
            {
                this.this$0 = contextHubService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubService_1$__constructor__(android.hardware.location.ContextHubService ), 0, this, contextHubService);
            }

            @Override
            public void onVrStateChanged(boolean bl) {
                InvokeDynamicSupport.bootstrap("onVrStateChanged", $$robo$$android_hardware_location_ContextHubService_1$onVrStateChanged(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mContextHubInfo = this.nativeInitialize();
        for (int i = 0; i < this.mContextHubInfo.length; ++i) {
            Log.d("ContextHubService", "ContextHub[" + i + "] id: " + this.mContextHubInfo[i].getId() + ", name:  " + this.mContextHubInfo[i].getName());
        }
        if (context.getPackageManager().hasSystemFeature("android.software.vr.mode") && (vrManager = IVrManager.Stub.asInterface(ServiceManager.getService("vrmanager"))) != null) {
            try {
                vrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Log.e("ContextHubService", "VR state listener registration failed", e);
            }
        }
    }

    private final int $$robo$$android_hardware_location_ContextHubService$registerCallback(IContextHubCallback callback) throws RemoteException {
        this.checkPermissions();
        this.mCallbacksList.register(callback);
        return 0;
    }

    private final int[] $$robo$$android_hardware_location_ContextHubService$getContextHubHandles() throws RemoteException {
        this.checkPermissions();
        int[] returnArray = new int[this.mContextHubInfo.length];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = i;
            Log.d("ContextHubService", String.format("Hub %s is mapped to %d", this.mContextHubInfo[i].getName(), returnArray[i]));
        }
        return returnArray;
    }

    private final ContextHubInfo $$robo$$android_hardware_location_ContextHubService$getContextHubInfo(int contextHubHandle) throws RemoteException {
        this.checkPermissions();
        if (contextHubHandle < 0 || contextHubHandle >= this.mContextHubInfo.length) {
            return null;
        }
        return this.mContextHubInfo[contextHubHandle];
    }

    private final int $$robo$$android_hardware_location_ContextHubService$loadNanoApp(int contextHubHandle, NanoApp app) throws RemoteException {
        this.checkPermissions();
        if (contextHubHandle < 0 || contextHubHandle >= this.mContextHubInfo.length) {
            Log.e("ContextHubService", "Invalid contextHubhandle " + contextHubHandle);
            return -1;
        }
        int[] msgHeader = new int[4];
        msgHeader[2] = contextHubHandle;
        msgHeader[3] = -1;
        msgHeader[1] = 0;
        msgHeader[0] = 3;
        if (this.nativeSendMessage(msgHeader, app.getAppBinary()) != 0) {
            return -1;
        }
        return 0;
    }

    private final int $$robo$$android_hardware_location_ContextHubService$unloadNanoApp(int nanoAppInstanceHandle) throws RemoteException {
        this.checkPermissions();
        NanoAppInstanceInfo info = this.mNanoAppHash.get(nanoAppInstanceHandle);
        if (info == null) {
            return -1;
        }
        int[] msgHeader = new int[4];
        msgHeader[2] = -1;
        msgHeader[3] = -1;
        msgHeader[1] = 0;
        msgHeader[0] = 4;
        if (this.nativeSendMessage(msgHeader, null) != 0) {
            return -1;
        }
        return 0;
    }

    private final NanoAppInstanceInfo $$robo$$android_hardware_location_ContextHubService$getNanoAppInstanceInfo(int nanoAppInstanceHandle) throws RemoteException {
        this.checkPermissions();
        if (this.mNanoAppHash.containsKey(nanoAppInstanceHandle)) {
            return this.mNanoAppHash.get(nanoAppInstanceHandle);
        }
        return null;
    }

    private final int[] $$robo$$android_hardware_location_ContextHubService$findNanoAppOnHub(int hubHandle, NanoAppFilter filter) throws RemoteException {
        this.checkPermissions();
        ArrayList<Integer> foundInstances = new ArrayList<Integer>();
        for (Integer nanoAppInstance : this.mNanoAppHash.keySet()) {
            NanoAppInstanceInfo info = this.mNanoAppHash.get(nanoAppInstance);
            if (!filter.testMatch(info)) continue;
            foundInstances.add(nanoAppInstance);
        }
        int[] retArray = new int[foundInstances.size()];
        for (int i = 0; i < foundInstances.size(); ++i) {
            retArray[i] = (Integer)foundInstances.get(i);
        }
        return retArray;
    }

    private final int $$robo$$android_hardware_location_ContextHubService$sendMessage(int hubHandle, int nanoAppHandle, ContextHubMessage msg) throws RemoteException {
        this.checkPermissions();
        int[] msgHeader = new int[4];
        msgHeader[2] = hubHandle;
        msgHeader[3] = nanoAppHandle;
        msgHeader[1] = msg.getVersion();
        msgHeader[0] = msg.getMsgType();
        return this.nativeSendMessage(msgHeader, msg.getData());
    }

    private final void $$robo$$android_hardware_location_ContextHubService$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump contexthub_service");
            return;
        }
        pw.println("Dumping ContextHub Service");
        pw.println("");
        pw.println("=================== CONTEXT HUBS ====================");
        for (int i = 0; i < this.mContextHubInfo.length; ++i) {
            pw.println("Handle " + i + " : " + this.mContextHubInfo[i].toString());
        }
        pw.println("");
        pw.println("=================== NANOAPPS ====================");
        for (Integer nanoAppInstance : this.mNanoAppHash.keySet()) {
            pw.println(nanoAppInstance + " : " + this.mNanoAppHash.get(nanoAppInstance).toString());
        }
    }

    private final void $$robo$$android_hardware_location_ContextHubService$checkPermissions() {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Permission 'android.permission.LOCATION_HARDWARE' not granted to access ContextHub Hardware");
    }

    private final int $$robo$$android_hardware_location_ContextHubService$onMessageReceipt(int[] header, byte[] data) {
        if (header == null || data == null || header.length < 4) {
            return -1;
        }
        int callbacksCount = this.mCallbacksList.beginBroadcast();
        if (callbacksCount < 1) {
            Log.v("ContextHubService", "No message callbacks registered.");
            return 0;
        }
        ContextHubMessage message = new ContextHubMessage(header[0], header[1], data);
        for (int i = 0; i < callbacksCount; ++i) {
            IContextHubCallback callback = this.mCallbacksList.getBroadcastItem(i);
            try {
                callback.onMessageReceipt(header[2], header[3], message);
                continue;
            }
            catch (RemoteException e) {
                Log.i("ContextHubService", "Exception (" + e + ") calling remote callback (" + callback + ").");
            }
        }
        this.mCallbacksList.finishBroadcast();
        return 0;
    }

    private final int $$robo$$android_hardware_location_ContextHubService$addAppInstance(int hubHandle, int appInstanceHandle, long appId, int appVersion) {
        NanoAppInstanceInfo appInfo = new NanoAppInstanceInfo();
        appInfo.setAppId(appId);
        appInfo.setAppVersion(appVersion);
        appInfo.setName("Preloaded app, unknown");
        appInfo.setContexthubId(hubHandle);
        appInfo.setHandle(appInstanceHandle);
        appInfo.setPublisher("Preloaded app, unknown");
        appInfo.setNeededExecMemBytes(0);
        appInfo.setNeededReadMemBytes(0);
        appInfo.setNeededWriteMemBytes(0);
        this.mNanoAppHash.put(appInstanceHandle, appInfo);
        Log.d("ContextHubService", "Added app instance " + appInstanceHandle + " with id " + appId + " version " + appVersion);
        return 0;
    }

    private final void $$robo$$android_hardware_location_ContextHubService$sendVrStateChangeMessageToApp(NanoAppInstanceInfo app, boolean vrModeEnabled) {
        int[] msgHeader = new int[]{0, 0, -1, app.getHandle()};
        byte[] data = new byte[]{(byte)(vrModeEnabled ? 1 : 0)};
        int ret = this.nativeSendMessage(msgHeader, data);
        if (ret != 0) {
            Log.e("ContextHubService", "Couldn't send VR state change notification (" + ret + ")!");
        }
    }

    private final native /* synthetic */ int $$robo$$nativeSendMessage$nativeBinding(int[] var1, byte[] var2);

    private int nativeSendMessage(int[] nArray, byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("nativeSendMessage", $$robo$$android_hardware_location_ContextHubService$nativeSendMessage(int[] byte[] ), 1, this, nArray, byArray);
    }

    private final native /* synthetic */ ContextHubInfo[] $$robo$$nativeInitialize$nativeBinding();

    private ContextHubInfo[] nativeInitialize() {
        return InvokeDynamicSupport.bootstrap("nativeInitialize", $$robo$$android_hardware_location_ContextHubService$nativeInitialize(), 1, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_hardware_location_ContextHubService$__constructor__(context);
    }

    public ContextHubService(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubService$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public int registerCallback(IContextHubCallback iContextHubCallback) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubService$registerCallback(android.hardware.location.IContextHubCallback ), 0, this, iContextHubCallback);
    }

    @Override
    public int[] getContextHubHandles() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getContextHubHandles", $$robo$$android_hardware_location_ContextHubService$getContextHubHandles(), 0, this);
    }

    @Override
    public ContextHubInfo getContextHubInfo(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getContextHubInfo", $$robo$$android_hardware_location_ContextHubService$getContextHubInfo(int ), 0, this, n);
    }

    @Override
    public int loadNanoApp(int n, NanoApp nanoApp) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("loadNanoApp", $$robo$$android_hardware_location_ContextHubService$loadNanoApp(int android.hardware.location.NanoApp ), 0, this, n, nanoApp);
    }

    @Override
    public int unloadNanoApp(int n) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("unloadNanoApp", $$robo$$android_hardware_location_ContextHubService$unloadNanoApp(int ), 0, this, n);
    }

    @Override
    public NanoAppInstanceInfo getNanoAppInstanceInfo(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getNanoAppInstanceInfo", $$robo$$android_hardware_location_ContextHubService$getNanoAppInstanceInfo(int ), 0, this, n);
    }

    @Override
    public int[] findNanoAppOnHub(int n, NanoAppFilter nanoAppFilter) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("findNanoAppOnHub", $$robo$$android_hardware_location_ContextHubService$findNanoAppOnHub(int android.hardware.location.NanoAppFilter ), 0, this, n, nanoAppFilter);
    }

    @Override
    public int sendMessage(int n, int n2, ContextHubMessage contextHubMessage) throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_hardware_location_ContextHubService$sendMessage(int int android.hardware.location.ContextHubMessage ), 0, this, n, n2, contextHubMessage);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_hardware_location_ContextHubService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private void checkPermissions() {
        InvokeDynamicSupport.bootstrap("checkPermissions", $$robo$$android_hardware_location_ContextHubService$checkPermissions(), 0, this);
    }

    private int onMessageReceipt(int[] nArray, byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("onMessageReceipt", $$robo$$android_hardware_location_ContextHubService$onMessageReceipt(int[] byte[] ), 0, this, nArray, byArray);
    }

    private int addAppInstance(int n, int n2, long l, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("addAppInstance", $$robo$$android_hardware_location_ContextHubService$addAppInstance(int int long int ), 0, this, n, n2, l, n3);
    }

    private void sendVrStateChangeMessageToApp(NanoAppInstanceInfo nanoAppInstanceInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendVrStateChangeMessageToApp", $$robo$$android_hardware_location_ContextHubService$sendVrStateChangeMessageToApp(android.hardware.location.NanoAppInstanceInfo boolean ), 0, this, nanoAppInstanceInfo, bl);
    }

    public /* synthetic */ ContextHubService() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextHubService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

