/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiRecordListener;
import android.hardware.hdmi.HdmiRecordSources;
import android.hardware.hdmi.HdmiTimerRecordSources;
import android.hardware.hdmi.IHdmiControlCallback;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiInputChangeListener;
import android.hardware.hdmi.IHdmiMhlVendorCommandListener;
import android.hardware.hdmi.IHdmiRecordListener;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.List;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class HdmiTvClient
extends HdmiClient
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "HdmiTvClient";
    public static int VENDOR_DATA_SIZE = 16;

    private void $$robo$$android_hardware_hdmi_HdmiTvClient$__constructor__(IHdmiControlService service) {
    }

    private static final HdmiTvClient $$robo$$android_hardware_hdmi_HdmiTvClient$create(IHdmiControlService service) {
        return new HdmiTvClient(service);
    }

    private final int $$robo$$android_hardware_hdmi_HdmiTvClient$getDeviceType() {
        return 0;
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$deviceSelect(int logicalAddress, SelectCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        try {
            this.mService.deviceSelect(logicalAddress, HdmiTvClient.getCallbackWrapper(callback));
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to select device: ", e);
        }
    }

    private static final IHdmiControlCallback $$robo$$android_hardware_hdmi_HdmiTvClient$getCallbackWrapper(SelectCallback callback) {
        return new ShadowedObject(callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SelectCallback val$callback;

            private void $$robo$$android_hardware_hdmi_HdmiTvClient_1$__constructor__(SelectCallback selectCallback) {
            }

            private final void $$robo$$android_hardware_hdmi_HdmiTvClient_1$onComplete(int result) {
                this.val$callback.onComplete(result);
            }

            private void __constructor__(SelectCallback selectCallback) {
                this.$$robo$$android_hardware_hdmi_HdmiTvClient_1$__constructor__(selectCallback);
            }
            {
                this.val$callback = selectCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTvClient_1$__constructor__(android.hardware.hdmi.HdmiTvClient$SelectCallback ), 0, this, selectCallback);
            }

            @Override
            public void onComplete(int n) {
                InvokeDynamicSupport.bootstrap("onComplete", $$robo$$android_hardware_hdmi_HdmiTvClient_1$onComplete(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$portSelect(int portId, SelectCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback must not be null");
        }
        try {
            this.mService.portSelect(portId, HdmiTvClient.getCallbackWrapper(callback));
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to select port: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$setInputChangeListener(InputChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        try {
            this.mService.setInputChangeListener(HdmiTvClient.getListenerWrapper(listener));
        }
        catch (RemoteException e) {
            Log.e("TAG", "Failed to set InputChangeListener:", e);
        }
    }

    private static final IHdmiInputChangeListener $$robo$$android_hardware_hdmi_HdmiTvClient$getListenerWrapper(InputChangeListener listener) {
        return new ShadowedObject(listener){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ InputChangeListener val$listener;

            private void $$robo$$android_hardware_hdmi_HdmiTvClient_2$__constructor__(InputChangeListener inputChangeListener) {
            }

            private final void $$robo$$android_hardware_hdmi_HdmiTvClient_2$onChanged(HdmiDeviceInfo info) {
                this.val$listener.onChanged(info);
            }

            private void __constructor__(InputChangeListener inputChangeListener) {
                this.$$robo$$android_hardware_hdmi_HdmiTvClient_2$__constructor__(inputChangeListener);
            }
            {
                this.val$listener = inputChangeListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTvClient_2$__constructor__(android.hardware.hdmi.HdmiTvClient$InputChangeListener ), 0, this, inputChangeListener);
            }

            @Override
            public void onChanged(HdmiDeviceInfo hdmiDeviceInfo) {
                InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_hardware_hdmi_HdmiTvClient_2$onChanged(android.hardware.hdmi.HdmiDeviceInfo ), 0, this, hdmiDeviceInfo);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final List<HdmiDeviceInfo> $$robo$$android_hardware_hdmi_HdmiTvClient$getDeviceList() {
        try {
            return this.mService.getDeviceList();
        }
        catch (RemoteException e) {
            Log.e("TAG", "Failed to call getDeviceList():", e);
            return Collections.emptyList();
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$setSystemAudioMode(boolean enabled, SelectCallback callback) {
        try {
            this.mService.setSystemAudioMode(enabled, HdmiTvClient.getCallbackWrapper(callback));
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to set system audio mode:", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$setSystemAudioVolume(int oldIndex, int newIndex, int maxIndex) {
        try {
            this.mService.setSystemAudioVolume(oldIndex, newIndex, maxIndex);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to set volume: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$setSystemAudioMute(boolean mute) {
        try {
            this.mService.setSystemAudioMute(mute);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to set mute: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$setRecordListener(HdmiRecordListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        try {
            this.mService.setHdmiRecordListener(HdmiTvClient.getListenerWrapper(listener));
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to set record listener.", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$sendStandby(int deviceId) {
        try {
            this.mService.sendStandby(this.getDeviceType(), deviceId);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "sendStandby threw exception ", e);
        }
    }

    private static final IHdmiRecordListener $$robo$$android_hardware_hdmi_HdmiTvClient$getListenerWrapper(HdmiRecordListener callback) {
        return new ShadowedObject(callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ HdmiRecordListener val$callback;

            private void $$robo$$android_hardware_hdmi_HdmiTvClient_3$__constructor__(HdmiRecordListener hdmiRecordListener) {
            }

            private final byte[] $$robo$$android_hardware_hdmi_HdmiTvClient_3$getOneTouchRecordSource(int recorderAddress) {
                HdmiRecordSources.RecordSource source = this.val$callback.onOneTouchRecordSourceRequested(recorderAddress);
                if (source == null) {
                    return EmptyArray.BYTE;
                }
                byte[] data = new byte[source.getDataSize(true)];
                source.toByteArray(true, data, 0);
                return data;
            }

            private final void $$robo$$android_hardware_hdmi_HdmiTvClient_3$onOneTouchRecordResult(int recorderAddress, int result) {
                this.val$callback.onOneTouchRecordResult(recorderAddress, result);
            }

            private final void $$robo$$android_hardware_hdmi_HdmiTvClient_3$onTimerRecordingResult(int recorderAddress, int result) {
                this.val$callback.onTimerRecordingResult(recorderAddress, HdmiRecordListener.TimerStatusData.parseFrom(result));
            }

            private final void $$robo$$android_hardware_hdmi_HdmiTvClient_3$onClearTimerRecordingResult(int recorderAddress, int result) {
                this.val$callback.onClearTimerRecordingResult(recorderAddress, result);
            }

            private void __constructor__(HdmiRecordListener hdmiRecordListener) {
                this.$$robo$$android_hardware_hdmi_HdmiTvClient_3$__constructor__(hdmiRecordListener);
            }
            {
                this.val$callback = hdmiRecordListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTvClient_3$__constructor__(android.hardware.hdmi.HdmiRecordListener ), 0, this, hdmiRecordListener);
            }

            @Override
            public byte[] getOneTouchRecordSource(int n) {
                return InvokeDynamicSupport.bootstrap("getOneTouchRecordSource", $$robo$$android_hardware_hdmi_HdmiTvClient_3$getOneTouchRecordSource(int ), 0, this, n);
            }

            @Override
            public void onOneTouchRecordResult(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onOneTouchRecordResult", $$robo$$android_hardware_hdmi_HdmiTvClient_3$onOneTouchRecordResult(int int ), 0, this, n, n2);
            }

            @Override
            public void onTimerRecordingResult(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onTimerRecordingResult", $$robo$$android_hardware_hdmi_HdmiTvClient_3$onTimerRecordingResult(int int ), 0, this, n, n2);
            }

            @Override
            public void onClearTimerRecordingResult(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onClearTimerRecordingResult", $$robo$$android_hardware_hdmi_HdmiTvClient_3$onClearTimerRecordingResult(int int ), 0, this, n, n2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$startOneTouchRecord(int recorderAddress, HdmiRecordSources.RecordSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null.");
        }
        try {
            byte[] data = new byte[source.getDataSize(true)];
            source.toByteArray(true, data, 0);
            this.mService.startOneTouchRecord(recorderAddress, data);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to start record: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$stopOneTouchRecord(int recorderAddress) {
        try {
            this.mService.stopOneTouchRecord(recorderAddress);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to stop record: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$startTimerRecording(int recorderAddress, int sourceType, HdmiTimerRecordSources.TimerRecordSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null.");
        }
        this.checkTimerRecordingSourceType(sourceType);
        try {
            byte[] data = new byte[source.getDataSize()];
            source.toByteArray(data, 0);
            this.mService.startTimerRecording(recorderAddress, sourceType, data);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to start record: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$checkTimerRecordingSourceType(int sourceType) {
        switch (sourceType) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid source type:" + sourceType);
            }
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$clearTimerRecording(int recorderAddress, int sourceType, HdmiTimerRecordSources.TimerRecordSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null.");
        }
        this.checkTimerRecordingSourceType(sourceType);
        try {
            byte[] data = new byte[source.getDataSize()];
            source.toByteArray(data, 0);
            this.mService.clearTimerRecording(recorderAddress, sourceType, data);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to start record: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$setHdmiMhlVendorCommandListener(HdmiMhlVendorCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        try {
            this.mService.addHdmiMhlVendorCommandListener(this.getListenerWrapper(listener));
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to set hdmi mhl vendor command listener: ", e);
        }
    }

    private final IHdmiMhlVendorCommandListener $$robo$$android_hardware_hdmi_HdmiTvClient$getListenerWrapper(HdmiMhlVendorCommandListener listener) {
        return new ShadowedObject(this, listener){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ HdmiMhlVendorCommandListener val$listener;
            /* synthetic */ HdmiTvClient this$0;

            private void $$robo$$android_hardware_hdmi_HdmiTvClient_4$__constructor__(HdmiTvClient this$0, HdmiMhlVendorCommandListener hdmiMhlVendorCommandListener) {
            }

            private final void $$robo$$android_hardware_hdmi_HdmiTvClient_4$onReceived(int portId, int offset, int length, byte[] data) {
                this.val$listener.onReceived(portId, offset, length, data);
            }

            private void __constructor__(HdmiTvClient hdmiTvClient, HdmiMhlVendorCommandListener hdmiMhlVendorCommandListener) {
                this.$$robo$$android_hardware_hdmi_HdmiTvClient_4$__constructor__(hdmiTvClient, hdmiMhlVendorCommandListener);
            }
            {
                this.this$0 = hdmiTvClient;
                this.val$listener = hdmiMhlVendorCommandListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTvClient_4$__constructor__(android.hardware.hdmi.HdmiTvClient android.hardware.hdmi.HdmiTvClient$HdmiMhlVendorCommandListener ), 0, this, hdmiTvClient, hdmiMhlVendorCommandListener);
            }

            @Override
            public void onReceived(int n, int n2, int n3, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onReceived", $$robo$$android_hardware_hdmi_HdmiTvClient_4$onReceived(int int int byte[] ), 0, this, n, n2, n3, byArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_hardware_hdmi_HdmiTvClient$sendMhlVendorCommand(int portId, int offset, int length, byte[] data) {
        if (data == null || data.length != 16) {
            throw new IllegalArgumentException("Invalid vendor command data.");
        }
        if (offset < 0 || offset >= 16) {
            throw new IllegalArgumentException("Invalid offset:" + offset);
        }
        if (length < 0 || offset + length > 16) {
            throw new IllegalArgumentException("Invalid length:" + length);
        }
        try {
            this.mService.sendMhlVendorCommand(portId, offset, length, data);
        }
        catch (RemoteException e) {
            Log.e("HdmiTvClient", "failed to send vendor command: ", e);
        }
    }

    private void __constructor__(IHdmiControlService iHdmiControlService) {
        this.$$robo$$android_hardware_hdmi_HdmiTvClient$__constructor__(iHdmiControlService);
    }

    HdmiTvClient(IHdmiControlService iHdmiControlService) {
        super(iHdmiControlService);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiTvClient$__constructor__(android.hardware.hdmi.IHdmiControlService ), 0, this, iHdmiControlService);
    }

    static HdmiTvClient create(IHdmiControlService iHdmiControlService) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_hardware_hdmi_HdmiTvClient$create(android.hardware.hdmi.IHdmiControlService ), 0, (IHdmiControlService)iHdmiControlService);
    }

    @Override
    public int getDeviceType() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceType", $$robo$$android_hardware_hdmi_HdmiTvClient$getDeviceType(), 0, this);
    }

    public void deviceSelect(int n, SelectCallback selectCallback) {
        InvokeDynamicSupport.bootstrap("deviceSelect", $$robo$$android_hardware_hdmi_HdmiTvClient$deviceSelect(int android.hardware.hdmi.HdmiTvClient$SelectCallback ), 0, this, n, selectCallback);
    }

    private static IHdmiControlCallback getCallbackWrapper(SelectCallback selectCallback) {
        return InvokeDynamicSupport.bootstrapStatic("getCallbackWrapper", $$robo$$android_hardware_hdmi_HdmiTvClient$getCallbackWrapper(android.hardware.hdmi.HdmiTvClient$SelectCallback ), 0, (SelectCallback)selectCallback);
    }

    public void portSelect(int n, SelectCallback selectCallback) {
        InvokeDynamicSupport.bootstrap("portSelect", $$robo$$android_hardware_hdmi_HdmiTvClient$portSelect(int android.hardware.hdmi.HdmiTvClient$SelectCallback ), 0, this, n, selectCallback);
    }

    public void setInputChangeListener(InputChangeListener inputChangeListener) {
        InvokeDynamicSupport.bootstrap("setInputChangeListener", $$robo$$android_hardware_hdmi_HdmiTvClient$setInputChangeListener(android.hardware.hdmi.HdmiTvClient$InputChangeListener ), 0, this, inputChangeListener);
    }

    private static IHdmiInputChangeListener getListenerWrapper(InputChangeListener inputChangeListener) {
        return InvokeDynamicSupport.bootstrapStatic("getListenerWrapper", $$robo$$android_hardware_hdmi_HdmiTvClient$getListenerWrapper(android.hardware.hdmi.HdmiTvClient$InputChangeListener ), 0, (InputChangeListener)inputChangeListener);
    }

    public List<HdmiDeviceInfo> getDeviceList() {
        return InvokeDynamicSupport.bootstrap("getDeviceList", $$robo$$android_hardware_hdmi_HdmiTvClient$getDeviceList(), 0, this);
    }

    public void setSystemAudioMode(boolean bl, SelectCallback selectCallback) {
        InvokeDynamicSupport.bootstrap("setSystemAudioMode", $$robo$$android_hardware_hdmi_HdmiTvClient$setSystemAudioMode(boolean android.hardware.hdmi.HdmiTvClient$SelectCallback ), 0, this, bl, selectCallback);
    }

    public void setSystemAudioVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setSystemAudioVolume", $$robo$$android_hardware_hdmi_HdmiTvClient$setSystemAudioVolume(int int int ), 0, this, n, n2, n3);
    }

    public void setSystemAudioMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSystemAudioMute", $$robo$$android_hardware_hdmi_HdmiTvClient$setSystemAudioMute(boolean ), 0, this, bl);
    }

    public void setRecordListener(HdmiRecordListener hdmiRecordListener) {
        InvokeDynamicSupport.bootstrap("setRecordListener", $$robo$$android_hardware_hdmi_HdmiTvClient$setRecordListener(android.hardware.hdmi.HdmiRecordListener ), 0, this, hdmiRecordListener);
    }

    public void sendStandby(int n) {
        InvokeDynamicSupport.bootstrap("sendStandby", $$robo$$android_hardware_hdmi_HdmiTvClient$sendStandby(int ), 0, this, n);
    }

    private static IHdmiRecordListener getListenerWrapper(HdmiRecordListener hdmiRecordListener) {
        return InvokeDynamicSupport.bootstrapStatic("getListenerWrapper", $$robo$$android_hardware_hdmi_HdmiTvClient$getListenerWrapper(android.hardware.hdmi.HdmiRecordListener ), 0, (HdmiRecordListener)hdmiRecordListener);
    }

    public void startOneTouchRecord(int n, HdmiRecordSources.RecordSource recordSource) {
        InvokeDynamicSupport.bootstrap("startOneTouchRecord", $$robo$$android_hardware_hdmi_HdmiTvClient$startOneTouchRecord(int android.hardware.hdmi.HdmiRecordSources$RecordSource ), 0, this, n, recordSource);
    }

    public void stopOneTouchRecord(int n) {
        InvokeDynamicSupport.bootstrap("stopOneTouchRecord", $$robo$$android_hardware_hdmi_HdmiTvClient$stopOneTouchRecord(int ), 0, this, n);
    }

    public void startTimerRecording(int n, int n2, HdmiTimerRecordSources.TimerRecordSource timerRecordSource) {
        InvokeDynamicSupport.bootstrap("startTimerRecording", $$robo$$android_hardware_hdmi_HdmiTvClient$startTimerRecording(int int android.hardware.hdmi.HdmiTimerRecordSources$TimerRecordSource ), 0, this, n, n2, timerRecordSource);
    }

    private void checkTimerRecordingSourceType(int n) {
        InvokeDynamicSupport.bootstrap("checkTimerRecordingSourceType", $$robo$$android_hardware_hdmi_HdmiTvClient$checkTimerRecordingSourceType(int ), 0, this, n);
    }

    public void clearTimerRecording(int n, int n2, HdmiTimerRecordSources.TimerRecordSource timerRecordSource) {
        InvokeDynamicSupport.bootstrap("clearTimerRecording", $$robo$$android_hardware_hdmi_HdmiTvClient$clearTimerRecording(int int android.hardware.hdmi.HdmiTimerRecordSources$TimerRecordSource ), 0, this, n, n2, timerRecordSource);
    }

    public void setHdmiMhlVendorCommandListener(HdmiMhlVendorCommandListener hdmiMhlVendorCommandListener) {
        InvokeDynamicSupport.bootstrap("setHdmiMhlVendorCommandListener", $$robo$$android_hardware_hdmi_HdmiTvClient$setHdmiMhlVendorCommandListener(android.hardware.hdmi.HdmiTvClient$HdmiMhlVendorCommandListener ), 0, this, hdmiMhlVendorCommandListener);
    }

    private IHdmiMhlVendorCommandListener getListenerWrapper(HdmiMhlVendorCommandListener hdmiMhlVendorCommandListener) {
        return InvokeDynamicSupport.bootstrap("getListenerWrapper", $$robo$$android_hardware_hdmi_HdmiTvClient$getListenerWrapper(android.hardware.hdmi.HdmiTvClient$HdmiMhlVendorCommandListener ), 0, this, hdmiMhlVendorCommandListener);
    }

    public void sendMhlVendorCommand(int n, int n2, int n3, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("sendMhlVendorCommand", $$robo$$android_hardware_hdmi_HdmiTvClient$sendMhlVendorCommand(int int int byte[] ), 0, this, n, n2, n3, byArray);
    }

    public /* synthetic */ HdmiTvClient() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiTvClient)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface HdmiMhlVendorCommandListener
    extends InstrumentedInterface {
        public void onReceived(int var1, int var2, int var3, byte[] var4);
    }

    public static interface InputChangeListener
    extends InstrumentedInterface {
        public void onChanged(HdmiDeviceInfo var1);
    }

    public static interface SelectCallback
    extends InstrumentedInterface {
        public void onComplete(int var1);
    }
}

