/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CaptureRequest;
import android.util.Rational;
import android.util.Size;
import com.android.internal.util.Preconditions;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ParamsUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int RATIONAL_DENOMINATOR = 1000000;

    private static final Rect $$robo$$android_hardware_camera2_utils_ParamsUtils$createRect(Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        return new Rect(0, 0, size.getWidth(), size.getHeight());
    }

    private static final Rect $$robo$$android_hardware_camera2_utils_ParamsUtils$createRect(RectF rect) {
        Preconditions.checkNotNull(rect, "rect must not be null");
        Rect r = new Rect();
        rect.roundOut(r);
        return r;
    }

    private static final Rect $$robo$$android_hardware_camera2_utils_ParamsUtils$mapRect(Matrix transform, Rect rect) {
        Preconditions.checkNotNull(transform, "transform must not be null");
        Preconditions.checkNotNull(rect, "rect must not be null");
        RectF rectF = new RectF(rect);
        transform.mapRect(rectF);
        return ParamsUtils.createRect(rectF);
    }

    private static final Size $$robo$$android_hardware_camera2_utils_ParamsUtils$createSize(Rect rect) {
        Preconditions.checkNotNull(rect, "rect must not be null");
        return new Size(rect.width(), rect.height());
    }

    private static final Rational $$robo$$android_hardware_camera2_utils_ParamsUtils$createRational(float value) {
        int den;
        float numF;
        if (Float.isNaN(value)) {
            return Rational.NaN;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return Rational.POSITIVE_INFINITY;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return Rational.NEGATIVE_INFINITY;
        }
        if (value == 0.0f) {
            return Rational.ZERO;
        }
        for (den = 1000000; !((numF = value * (float)den) > -2.1474836E9f && numF < 2.1474836E9f || den == 1); den /= 10) {
        }
        int num = (int)numF;
        return new Rational(num, den);
    }

    private static final void $$robo$$android_hardware_camera2_utils_ParamsUtils$convertRectF(Rect source, RectF destination) {
        Preconditions.checkNotNull(source, "source must not be null");
        Preconditions.checkNotNull(destination, "destination must not be null");
        destination.left = source.left;
        destination.right = source.right;
        destination.bottom = source.bottom;
        destination.top = source.top;
    }

    private static final <T> T $$robo$$android_hardware_camera2_utils_ParamsUtils$getOrDefault(CaptureRequest r, CaptureRequest.Key<T> key, T defaultValue) {
        Preconditions.checkNotNull(r, "r must not be null");
        Preconditions.checkNotNull(key, "key must not be null");
        Preconditions.checkNotNull(defaultValue, "defaultValue must not be null");
        T value = r.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private void $$robo$$android_hardware_camera2_utils_ParamsUtils$__constructor__() {
        throw new AssertionError();
    }

    public static Rect createRect(Size size) {
        return InvokeDynamicSupport.bootstrapStatic("createRect", $$robo$$android_hardware_camera2_utils_ParamsUtils$createRect(android.util.Size ), 0, (Size)size);
    }

    public static Rect createRect(RectF rectF) {
        return InvokeDynamicSupport.bootstrapStatic("createRect", $$robo$$android_hardware_camera2_utils_ParamsUtils$createRect(android.graphics.RectF ), 0, (RectF)rectF);
    }

    public static Rect mapRect(Matrix matrix, Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("mapRect", $$robo$$android_hardware_camera2_utils_ParamsUtils$mapRect(android.graphics.Matrix android.graphics.Rect ), 0, (Matrix)matrix, (Rect)rect);
    }

    public static Size createSize(Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("createSize", $$robo$$android_hardware_camera2_utils_ParamsUtils$createSize(android.graphics.Rect ), 0, (Rect)rect);
    }

    public static Rational createRational(float f) {
        return InvokeDynamicSupport.bootstrapStatic("createRational", $$robo$$android_hardware_camera2_utils_ParamsUtils$createRational(float ), 0, (float)f);
    }

    public static void convertRectF(Rect rect, RectF rectF) {
        InvokeDynamicSupport.bootstrapStatic("convertRectF", $$robo$$android_hardware_camera2_utils_ParamsUtils$convertRectF(android.graphics.Rect android.graphics.RectF ), 0, (Rect)rect, (RectF)rectF);
    }

    public static <T> T getOrDefault(CaptureRequest captureRequest, CaptureRequest.Key<T> key, T t) {
        return (T)InvokeDynamicSupport.bootstrapStatic("getOrDefault", $$robo$$android_hardware_camera2_utils_ParamsUtils$getOrDefault(android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureRequest$Key<T> T ), 0, (CaptureRequest)captureRequest, key, t);
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_utils_ParamsUtils$__constructor__();
    }

    private ParamsUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_utils_ParamsUtils$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParamsUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

