/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class OutputConfiguration
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ROTATION_0 = 0;
    public static int ROTATION_90 = 1;
    public static int ROTATION_180 = 2;
    public static int ROTATION_270 = 3;
    public static int SURFACE_GROUP_ID_NONE = -1;
    public static Parcelable.Creator<OutputConfiguration> CREATOR;
    private static String TAG = "OutputConfiguration";
    private Surface mSurface;
    private int mRotation;
    private int mSurfaceGroupId;
    private Size mConfiguredSize;
    private int mConfiguredFormat;
    private int mConfiguredDataspace;
    private int mConfiguredGenerationId;

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Surface surface) {
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int surfaceGroupId, Surface surface) {
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Surface surface, int rotation) {
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int surfaceGroupId, Surface surface, int rotation) {
        Preconditions.checkNotNull(surface, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceGroupId;
        this.mSurface = surface;
        this.mRotation = rotation;
        this.mConfiguredSize = SurfaceUtils.getSurfaceSize(surface);
        this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(surface);
        this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(surface);
        this.mConfiguredGenerationId = surface.getGenerationId();
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(OutputConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("OutputConfiguration shouldn't be null");
        }
        this.mSurface = other.mSurface;
        this.mRotation = other.mRotation;
        this.mSurfaceGroupId = other.mSurfaceGroupId;
        this.mConfiguredDataspace = other.mConfiguredDataspace;
        this.mConfiguredFormat = other.mConfiguredFormat;
        this.mConfiguredSize = other.mConfiguredSize;
        this.mConfiguredGenerationId = other.mConfiguredGenerationId;
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Parcel source) {
        int rotation = source.readInt();
        int surfaceSetId = source.readInt();
        Surface surface = Surface.CREATOR.createFromParcel(source);
        Preconditions.checkNotNull(surface, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceSetId;
        this.mSurface = surface;
        this.mRotation = rotation;
        this.mConfiguredSize = SurfaceUtils.getSurfaceSize(this.mSurface);
        this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(this.mSurface);
        this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(this.mSurface);
        this.mConfiguredGenerationId = this.mSurface.getGenerationId();
    }

    private final Surface $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurface() {
        return this.mSurface;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$getRotation() {
        return this.mRotation;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurfaceGroupId() {
        return this.mSurfaceGroupId;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_camera2_params_OutputConfiguration$writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mRotation);
        dest.writeInt(this.mSurfaceGroupId);
        this.mSurface.writeToParcel(dest, flags);
    }

    private final boolean $$robo$$android_hardware_camera2_params_OutputConfiguration$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutputConfiguration) {
            OutputConfiguration other = (OutputConfiguration)obj;
            return this.mRotation == other.mRotation && this.mSurface == other.mSurface && this.mConfiguredGenerationId == other.mConfiguredGenerationId && this.mConfiguredSize.equals(other.mConfiguredSize) && this.mConfiguredFormat == other.mConfiguredFormat && this.mConfiguredDataspace == other.mConfiguredDataspace && this.mSurfaceGroupId == other.mSurfaceGroupId;
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$hashCode() {
        return HashCodeHelpers.hashCode(this.mRotation, this.mSurface.hashCode(), this.mConfiguredGenerationId, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId);
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<OutputConfiguration>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_params_OutputConfiguration_1$__constructor__() {
            }

            private final OutputConfiguration $$robo$$android_hardware_camera2_params_OutputConfiguration_1$createFromParcel(Parcel source) {
                try {
                    OutputConfiguration outputConfiguration = new OutputConfiguration(source);
                    return outputConfiguration;
                }
                catch (Exception e) {
                    Log.e("OutputConfiguration", "Exception creating OutputConfiguration from parcel", e);
                    return null;
                }
            }

            private final OutputConfiguration[] $$robo$$android_hardware_camera2_params_OutputConfiguration_1$newArray(int size) {
                return new OutputConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_params_OutputConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration_1$__constructor__(), 0, this);
            }

            @Override
            public OutputConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_camera2_params_OutputConfiguration_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public OutputConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_camera2_params_OutputConfiguration_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Surface surface) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(surface);
    }

    public OutputConfiguration(Surface surface) {
        this(-1, surface, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.view.Surface ), 0, this, surface);
    }

    private void __constructor__(int n, Surface surface) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(n, surface);
    }

    public OutputConfiguration(int n, Surface surface) {
        this(n, surface, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int android.view.Surface ), 0, this, n, surface);
    }

    private void __constructor__(Surface surface, int n) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(surface, n);
    }

    public OutputConfiguration(Surface surface, int n) {
        this(-1, surface, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.view.Surface int ), 0, this, surface, n);
    }

    private void __constructor__(int n, Surface surface, int n2) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(n, surface, n2);
    }

    public OutputConfiguration(int n, Surface surface, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int android.view.Surface int ), 0, this, n, surface, n2);
    }

    private void __constructor__(OutputConfiguration outputConfiguration) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(outputConfiguration);
    }

    public OutputConfiguration(OutputConfiguration outputConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.hardware.camera2.params.OutputConfiguration ), 0, this, outputConfiguration);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(parcel);
    }

    private OutputConfiguration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurface(), 0, this);
    }

    public int getRotation() {
        return (int)InvokeDynamicSupport.bootstrap("getRotation", $$robo$$android_hardware_camera2_params_OutputConfiguration$getRotation(), 0, this);
    }

    public int getSurfaceGroupId() {
        return (int)InvokeDynamicSupport.bootstrap("getSurfaceGroupId", $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurfaceGroupId(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_camera2_params_OutputConfiguration$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_camera2_params_OutputConfiguration$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_OutputConfiguration$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_OutputConfiguration$hashCode(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(OutputConfiguration.class);
    }

    public /* synthetic */ OutputConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OutputConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

