/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestHolder
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RequestHolder";
    private boolean mRepeating;
    private CaptureRequest mRequest;
    private int mRequestId;
    private int mSubsequeceId;
    private long mFrameNumber;
    private int mNumJpegTargets;
    private int mNumPreviewTargets;
    private volatile boolean mFailed;
    private boolean mOutputAbandoned;
    private Collection<Long> mJpegSurfaceIds;

    private void $$robo$$android_hardware_camera2_legacy_RequestHolder$__constructor__(int requestId, int subsequenceId, CaptureRequest request, boolean repeating, long frameNumber, int numJpegTargets, int numPreviewTargets, Collection<Long> jpegSurfaceIds) {
        this.mFailed = false;
        this.mOutputAbandoned = false;
        this.mRepeating = repeating;
        this.mRequest = request;
        this.mRequestId = requestId;
        this.mSubsequeceId = subsequenceId;
        this.mFrameNumber = frameNumber;
        this.mNumJpegTargets = numJpegTargets;
        this.mNumPreviewTargets = numPreviewTargets;
        this.mJpegSurfaceIds = jpegSurfaceIds;
    }

    private final int $$robo$$android_hardware_camera2_legacy_RequestHolder$getRequestId() {
        return this.mRequestId;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder$isRepeating() {
        return this.mRepeating;
    }

    private final int $$robo$$android_hardware_camera2_legacy_RequestHolder$getSubsequeceId() {
        return this.mSubsequeceId;
    }

    private final long $$robo$$android_hardware_camera2_legacy_RequestHolder$getFrameNumber() {
        return this.mFrameNumber;
    }

    private final CaptureRequest $$robo$$android_hardware_camera2_legacy_RequestHolder$getRequest() {
        return this.mRequest;
    }

    private final Collection<Surface> $$robo$$android_hardware_camera2_legacy_RequestHolder$getHolderTargets() {
        return this.getRequest().getTargets();
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder$hasJpegTargets() {
        return this.mNumJpegTargets > 0;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder$hasPreviewTargets() {
        return this.mNumPreviewTargets > 0;
    }

    private final int $$robo$$android_hardware_camera2_legacy_RequestHolder$numJpegTargets() {
        return this.mNumJpegTargets;
    }

    private final int $$robo$$android_hardware_camera2_legacy_RequestHolder$numPreviewTargets() {
        return this.mNumPreviewTargets;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder$jpegType(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return LegacyCameraDevice.containsSurfaceId(s, this.mJpegSurfaceIds);
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestHolder$failRequest() {
        Log.w("RequestHolder", "Capture failed for request: " + this.getRequestId());
        this.mFailed = true;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder$requestFailed() {
        return this.mFailed;
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestHolder$setOutputAbandoned() {
        this.mOutputAbandoned = true;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder$isOutputAbandoned() {
        return this.mOutputAbandoned;
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_legacy_RequestHolder$__constructor__(int x0, int x1, CaptureRequest x2, boolean x3, long x4, int x5, int x6, Collection x7, 1 x8) {
    }

    private void __constructor__(int n, int n2, CaptureRequest captureRequest, boolean bl, long l, int n3, int n4, Collection<Long> collection) {
        this.$$robo$$android_hardware_camera2_legacy_RequestHolder$__constructor__(n, n2, captureRequest, bl, l, n3, n4, collection);
    }

    private RequestHolder(int n, int n2, CaptureRequest captureRequest, boolean bl, long l, int n3, int n4, Collection<Long> collection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestHolder$__constructor__(int int android.hardware.camera2.CaptureRequest boolean long int int java.util.Collection<java.lang.Long> ), 0, this, n, n2, captureRequest, bl, l, n3, n4, collection);
    }

    public int getRequestId() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestId", $$robo$$android_hardware_camera2_legacy_RequestHolder$getRequestId(), 0, this);
    }

    public boolean isRepeating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRepeating", $$robo$$android_hardware_camera2_legacy_RequestHolder$isRepeating(), 0, this);
    }

    public int getSubsequeceId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubsequeceId", $$robo$$android_hardware_camera2_legacy_RequestHolder$getSubsequeceId(), 0, this);
    }

    public long getFrameNumber() {
        return (long)InvokeDynamicSupport.bootstrap("getFrameNumber", $$robo$$android_hardware_camera2_legacy_RequestHolder$getFrameNumber(), 0, this);
    }

    public CaptureRequest getRequest() {
        return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_hardware_camera2_legacy_RequestHolder$getRequest(), 0, this);
    }

    public Collection<Surface> getHolderTargets() {
        return InvokeDynamicSupport.bootstrap("getHolderTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder$getHolderTargets(), 0, this);
    }

    public boolean hasJpegTargets() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasJpegTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder$hasJpegTargets(), 0, this);
    }

    public boolean hasPreviewTargets() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPreviewTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder$hasPreviewTargets(), 0, this);
    }

    public int numJpegTargets() {
        return (int)InvokeDynamicSupport.bootstrap("numJpegTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder$numJpegTargets(), 0, this);
    }

    public int numPreviewTargets() {
        return (int)InvokeDynamicSupport.bootstrap("numPreviewTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder$numPreviewTargets(), 0, this);
    }

    public boolean jpegType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (boolean)InvokeDynamicSupport.bootstrap("jpegType", $$robo$$android_hardware_camera2_legacy_RequestHolder$jpegType(android.view.Surface ), 0, this, surface);
    }

    public void failRequest() {
        InvokeDynamicSupport.bootstrap("failRequest", $$robo$$android_hardware_camera2_legacy_RequestHolder$failRequest(), 0, this);
    }

    public boolean requestFailed() {
        return (boolean)InvokeDynamicSupport.bootstrap("requestFailed", $$robo$$android_hardware_camera2_legacy_RequestHolder$requestFailed(), 0, this);
    }

    public void setOutputAbandoned() {
        InvokeDynamicSupport.bootstrap("setOutputAbandoned", $$robo$$android_hardware_camera2_legacy_RequestHolder$setOutputAbandoned(), 0, this);
    }

    public boolean isOutputAbandoned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutputAbandoned", $$robo$$android_hardware_camera2_legacy_RequestHolder$isOutputAbandoned(), 0, this);
    }

    private /* synthetic */ void __constructor__(int n, int n2, CaptureRequest captureRequest, boolean bl, long l, int n3, int n4, Collection collection, 1 var10_9) {
        this.$$robo$$android_hardware_camera2_legacy_RequestHolder$__constructor__(n, n2, captureRequest, bl, l, n3, n4, collection, var10_9);
    }

    public /* synthetic */ RequestHolder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestHolder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mRequestId;
        private int mSubsequenceId;
        private CaptureRequest mRequest;
        private boolean mRepeating;
        private int mNumJpegTargets;
        private int mNumPreviewTargets;
        private Collection<Long> mJpegSurfaceIds;

        private void $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$__constructor__(int requestId, int subsequenceId, CaptureRequest request, boolean repeating, Collection<Long> jpegSurfaceIds) {
            Preconditions.checkNotNull(request, "request must not be null");
            this.mRequestId = requestId;
            this.mSubsequenceId = subsequenceId;
            this.mRequest = request;
            this.mRepeating = repeating;
            this.mJpegSurfaceIds = jpegSurfaceIds;
            this.mNumJpegTargets = this.numJpegTargets(this.mRequest);
            this.mNumPreviewTargets = this.numPreviewTargets(this.mRequest);
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$jpegType(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return LegacyCameraDevice.containsSurfaceId(s, this.mJpegSurfaceIds);
        }

        private final boolean $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$previewType(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return !this.jpegType(s);
        }

        private final int $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$numJpegTargets(CaptureRequest request) {
            int count = 0;
            for (Surface s : request.getTargets()) {
                try {
                    if (!this.jpegType(s)) continue;
                    ++count;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.d("RequestHolder", "Surface abandoned, skipping...", e);
                }
            }
            return count;
        }

        private final int $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$numPreviewTargets(CaptureRequest request) {
            int count = 0;
            for (Surface s : request.getTargets()) {
                try {
                    if (!this.previewType(s)) continue;
                    ++count;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.d("RequestHolder", "Surface abandoned, skipping...", e);
                }
            }
            return count;
        }

        private final RequestHolder $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$build(long frameNumber) {
            return new RequestHolder(this.mRequestId, this.mSubsequenceId, this.mRequest, this.mRepeating, frameNumber, this.mNumJpegTargets, this.mNumPreviewTargets, this.mJpegSurfaceIds);
        }

        private void __constructor__(int n, int n2, CaptureRequest captureRequest, boolean bl, Collection<Long> collection) {
            this.$$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$__constructor__(n, n2, captureRequest, bl, collection);
        }

        public Builder(int n, int n2, CaptureRequest captureRequest, boolean bl, Collection<Long> collection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$__constructor__(int int android.hardware.camera2.CaptureRequest boolean java.util.Collection<java.lang.Long> ), 0, this, n, n2, captureRequest, bl, collection);
        }

        private boolean jpegType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return (boolean)InvokeDynamicSupport.bootstrap("jpegType", $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$jpegType(android.view.Surface ), 0, this, surface);
        }

        private boolean previewType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return (boolean)InvokeDynamicSupport.bootstrap("previewType", $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$previewType(android.view.Surface ), 0, this, surface);
        }

        private int numJpegTargets(CaptureRequest captureRequest) {
            return (int)InvokeDynamicSupport.bootstrap("numJpegTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$numJpegTargets(android.hardware.camera2.CaptureRequest ), 0, this, captureRequest);
        }

        private int numPreviewTargets(CaptureRequest captureRequest) {
            return (int)InvokeDynamicSupport.bootstrap("numPreviewTargets", $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$numPreviewTargets(android.hardware.camera2.CaptureRequest ), 0, this, captureRequest);
        }

        public RequestHolder build(long l) {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_camera2_legacy_RequestHolder_Builder$build(long ), 0, this, l);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

