/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.os.SystemClock;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PerfMeasurement
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PerfMeasurement";
    public static int DEFAULT_MAX_QUERIES = 3;
    private long mNativeContext;
    private int mCompletedQueryCount;
    private ArrayList<Long> mCollectedGpuDurations;
    private ArrayList<Long> mCollectedCpuDurations;
    private ArrayList<Long> mCollectedTimestamps;
    private Queue<Long> mTimestampQueue;
    private Queue<Long> mCpuDurationsQueue;
    private long mStartTimeNs;
    private static long NO_DURATION_YET = -1L;
    private static long FAILED_TIMING = -2L;

    private void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$__constructor__() {
        this.mCompletedQueryCount = 0;
        this.mCollectedGpuDurations = new ArrayList();
        this.mCollectedCpuDurations = new ArrayList();
        this.mCollectedTimestamps = new ArrayList();
        this.mTimestampQueue = new LinkedList<Long>();
        this.mCpuDurationsQueue = new LinkedList<Long>();
        this.mNativeContext = PerfMeasurement.nativeCreateContext(3);
    }

    private void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$__constructor__(int maxQueries) {
        this.mCompletedQueryCount = 0;
        this.mCollectedGpuDurations = new ArrayList();
        this.mCollectedCpuDurations = new ArrayList();
        this.mCollectedTimestamps = new ArrayList();
        this.mTimestampQueue = new LinkedList<Long>();
        this.mCpuDurationsQueue = new LinkedList<Long>();
        if (maxQueries < 1) {
            throw new IllegalArgumentException("maxQueries is less than 1");
        }
        this.mNativeContext = PerfMeasurement.nativeCreateContext(maxQueries);
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_PerfMeasurement$isGlTimingSupported() {
        return PerfMeasurement.nativeQuerySupport();
    }

    private final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$dumpPerformanceData(String path) {
        try (BufferedWriter dump = new BufferedWriter(new FileWriter(path));){
            dump.write("timestamp gpu_duration cpu_duration\n");
            for (int i = 0; i < this.mCollectedGpuDurations.size(); ++i) {
                dump.write(String.format("%d %d %d\n", this.mCollectedTimestamps.get(i), this.mCollectedGpuDurations.get(i), this.mCollectedCpuDurations.get(i)));
            }
            this.mCollectedTimestamps.clear();
            this.mCollectedGpuDurations.clear();
            this.mCollectedCpuDurations.clear();
        }
        catch (IOException e) {
            Log.e("PerfMeasurement", "Error writing data dump to " + path + ":" + e);
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$startTimer() {
        PerfMeasurement.nativeStartGlTimer(this.mNativeContext);
        this.mStartTimeNs = SystemClock.elapsedRealtimeNanos();
    }

    private final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$stopTimer() {
        long endTimeNs = SystemClock.elapsedRealtimeNanos();
        this.mCpuDurationsQueue.add(endTimeNs - this.mStartTimeNs);
        PerfMeasurement.nativeStopGlTimer(this.mNativeContext);
        long duration = this.getNextGlDuration();
        if (duration > 0L) {
            this.mCollectedGpuDurations.add(duration);
            this.mCollectedTimestamps.add(this.mTimestampQueue.isEmpty() ? Long.valueOf(-1L) : this.mTimestampQueue.poll());
            this.mCollectedCpuDurations.add(this.mCpuDurationsQueue.isEmpty() ? Long.valueOf(-1L) : this.mCpuDurationsQueue.poll());
        }
        if (duration == -2L) {
            if (!this.mTimestampQueue.isEmpty()) {
                this.mTimestampQueue.poll();
            }
            if (!this.mCpuDurationsQueue.isEmpty()) {
                this.mCpuDurationsQueue.poll();
            }
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$addTimestamp(long timestamp) {
        this.mTimestampQueue.add(timestamp);
    }

    private final long $$robo$$android_hardware_camera2_legacy_PerfMeasurement$getNextGlDuration() {
        long duration = PerfMeasurement.nativeGetNextGlDuration(this.mNativeContext);
        if (duration > 0L) {
            ++this.mCompletedQueryCount;
        }
        return duration;
    }

    private final int $$robo$$android_hardware_camera2_legacy_PerfMeasurement$getCompletedQueryCount() {
        return this.mCompletedQueryCount;
    }

    private final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$finalize() {
        PerfMeasurement.nativeDeleteContext(this.mNativeContext);
    }

    private static final long $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeCreateContext(int n) {
        return 0L;
    }

    private static final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeDeleteContext(long l) {
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeQuerySupport() {
        return false;
    }

    private static final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeStartGlTimer(long l) {
    }

    private static final void $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeStopGlTimer(long l) {
    }

    private static final long $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeGetNextGlDuration(long l) {
        return 0L;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_legacy_PerfMeasurement$__constructor__();
    }

    public PerfMeasurement() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_hardware_camera2_legacy_PerfMeasurement$__constructor__(n);
    }

    public PerfMeasurement(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$__constructor__(int ), 0, this, n);
    }

    public static boolean isGlTimingSupported() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGlTimingSupported", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$isGlTimingSupported(), 0);
    }

    public void dumpPerformanceData(String string2) {
        InvokeDynamicSupport.bootstrap("dumpPerformanceData", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$dumpPerformanceData(java.lang.String ), 0, this, string2);
    }

    public void startTimer() {
        InvokeDynamicSupport.bootstrap("startTimer", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$startTimer(), 0, this);
    }

    public void stopTimer() {
        InvokeDynamicSupport.bootstrap("stopTimer", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$stopTimer(), 0, this);
    }

    public void addTimestamp(long l) {
        InvokeDynamicSupport.bootstrap("addTimestamp", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$addTimestamp(long ), 0, this, l);
    }

    private long getNextGlDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getNextGlDuration", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$getNextGlDuration(), 0, this);
    }

    public int getCompletedQueryCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCompletedQueryCount", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$getCompletedQueryCount(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$finalize(), 0, this);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateContext$nativeBinding(int var0);

    private static long nativeCreateContext(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateContext", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeCreateContext(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeDeleteContext$nativeBinding(long var0);

    private static void nativeDeleteContext(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDeleteContext", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeDeleteContext(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeQuerySupport$nativeBinding();

    private static boolean nativeQuerySupport() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeQuerySupport", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeQuerySupport(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nativeStartGlTimer$nativeBinding(long var0);

    protected static void nativeStartGlTimer(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeStartGlTimer", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeStartGlTimer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeStopGlTimer$nativeBinding(long var0);

    protected static void nativeStopGlTimer(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeStopGlTimer", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeStopGlTimer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetNextGlDuration$nativeBinding(long var0);

    protected static long nativeGetNextGlDuration(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetNextGlDuration", $$robo$$android_hardware_camera2_legacy_PerfMeasurement$nativeGetNextGlDuration(long ), 1, (long)l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PerfMeasurement)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

