/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.GetCommand;
import android.hardware.camera2.impl.SetCommand;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.marshal.impl.MarshalQueryableArray;
import android.hardware.camera2.marshal.impl.MarshalQueryableBlackLevelPattern;
import android.hardware.camera2.marshal.impl.MarshalQueryableBoolean;
import android.hardware.camera2.marshal.impl.MarshalQueryableColorSpaceTransform;
import android.hardware.camera2.marshal.impl.MarshalQueryableEnum;
import android.hardware.camera2.marshal.impl.MarshalQueryableHighSpeedVideoConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableMeteringRectangle;
import android.hardware.camera2.marshal.impl.MarshalQueryableNativeByteToInteger;
import android.hardware.camera2.marshal.impl.MarshalQueryablePair;
import android.hardware.camera2.marshal.impl.MarshalQueryableParcelable;
import android.hardware.camera2.marshal.impl.MarshalQueryablePrimitive;
import android.hardware.camera2.marshal.impl.MarshalQueryableRange;
import android.hardware.camera2.marshal.impl.MarshalQueryableRect;
import android.hardware.camera2.marshal.impl.MarshalQueryableReprocessFormatsMap;
import android.hardware.camera2.marshal.impl.MarshalQueryableRggbChannelVector;
import android.hardware.camera2.marshal.impl.MarshalQueryableSize;
import android.hardware.camera2.marshal.impl.MarshalQueryableSizeF;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfigurationDuration;
import android.hardware.camera2.marshal.impl.MarshalQueryableString;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.LensShadingMap;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Size;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraMetadataNative
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraMetadataJV";
    private static boolean DEBUG = false;
    public static int NATIVE_JPEG_FORMAT = 33;
    private static String CELLID_PROCESS = "CELLID";
    private static String GPS_PROCESS = "GPS";
    private static int FACE_LANDMARK_SIZE = 6;
    public static Parcelable.Creator<CameraMetadataNative> CREATOR;
    public static int TYPE_BYTE = 0;
    public static int TYPE_INT32 = 1;
    public static int TYPE_FLOAT = 2;
    public static int TYPE_INT64 = 3;
    public static int TYPE_DOUBLE = 4;
    public static int TYPE_RATIONAL = 5;
    public static int NUM_TYPES = 6;
    private static HashMap<Key<?>, GetCommand> sGetCommandMap;
    private static HashMap<Key<?>, SetCommand> sSetCommandMap;
    private long mMetadataPtr;

    private static final String $$robo$$android_hardware_camera2_impl_CameraMetadataNative$translateLocationProviderToProcess(String provider) {
        if (provider == null) {
            return null;
        }
        switch (provider) {
            case "gps": {
                return "GPS";
            }
            case "network": {
                return "CELLID";
            }
        }
        return null;
    }

    private static final String $$robo$$android_hardware_camera2_impl_CameraMetadataNative$translateProcessToLocationProvider(String process) {
        if (process == null) {
            return null;
        }
        switch (process) {
            case "GPS": {
                return "gps";
            }
            case "CELLID": {
                return "network";
            }
        }
        return null;
    }

    private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$__constructor__() {
        this.mMetadataPtr = this.nativeAllocate();
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$__constructor__(CameraMetadataNative other) {
        this.mMetadataPtr = this.nativeAllocateCopy(other);
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    private static final CameraMetadataNative $$robo$$android_hardware_camera2_impl_CameraMetadataNative$move(CameraMetadataNative other) {
        CameraMetadataNative newObject = new CameraMetadataNative();
        newObject.swap(other);
        return newObject;
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$writeToParcel(Parcel dest, int flags) {
        this.nativeWriteToParcel(dest);
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(CameraCharacteristics.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(CaptureResult.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(CaptureRequest.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(Key<T> key) {
        Preconditions.checkNotNull(key, "key must not be null");
        GetCommand g = sGetCommandMap.get(key);
        if (g != null) {
            return g.getValue(this, key);
        }
        return this.getBase(key);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$readFromParcel(Parcel in) {
        this.nativeReadFromParcel(in);
    }

    private static final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setupGlobalVendorTagDescriptor() throws ServiceSpecificException {
        int err = CameraMetadataNative.nativeSetupGlobalVendorTagDescriptor();
        if (err != 0) {
            throw new ServiceSpecificException(err, "Failure to set up global vendor tags");
        }
    }

    private static final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeSetupGlobalVendorTagDescriptor() {
        return 0;
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(Key<T> key, T value) {
        SetCommand s = sSetCommandMap.get(key);
        if (s != null) {
            s.setValue(this, value);
            return;
        }
        this.setBase(key, value);
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(CaptureRequest.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(CaptureResult.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(CameraCharacteristics.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$close() {
        this.nativeClose();
        this.mMetadataPtr = 0L;
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(CameraCharacteristics.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(CaptureResult.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(CaptureRequest.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(Key<T> key) {
        int tag = key.getTag();
        byte[] values = this.readValues(tag);
        if (values == null) {
            return null;
        }
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key);
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        return marshaler.unmarshal(buffer);
    }

    private final int[] $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getAvailableFormats() {
        int[] availableFormats = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS);
        if (availableFormats != null) {
            for (int i = 0; i < availableFormats.length; ++i) {
                if (availableFormats[i] != 33) continue;
                availableFormats[i] = 256;
            }
        }
        return availableFormats;
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setFaces(Face[] faces) {
        if (faces == null) {
            return false;
        }
        int numFaces = faces.length;
        boolean fullMode = true;
        for (Face face : faces) {
            if (face == null) {
                --numFaces;
                Log.w("CameraMetadataJV", "setFaces - null face detected, skipping");
                continue;
            }
            if (face.getId() != -1) continue;
            fullMode = false;
        }
        Rect[] faceRectangles = new Rect[numFaces];
        byte[] faceScores = new byte[numFaces];
        int[] faceIds = null;
        int[] faceLandmarks = null;
        if (fullMode) {
            faceIds = new int[numFaces];
            faceLandmarks = new int[numFaces * 6];
        }
        int i = 0;
        for (Face face : faces) {
            if (face == null) continue;
            faceRectangles[i] = face.getBounds();
            faceScores[i] = (byte)face.getScore();
            if (fullMode) {
                faceIds[i] = face.getId();
                int j = 0;
                faceLandmarks[i * 6 + j++] = face.getLeftEyePosition().x;
                faceLandmarks[i * 6 + j++] = face.getLeftEyePosition().y;
                faceLandmarks[i * 6 + j++] = face.getRightEyePosition().x;
                faceLandmarks[i * 6 + j++] = face.getRightEyePosition().y;
                faceLandmarks[i * 6 + j++] = face.getMouthPosition().x;
                faceLandmarks[i * 6 + j++] = face.getMouthPosition().y;
            }
            ++i;
        }
        this.set(CaptureResult.STATISTICS_FACE_RECTANGLES, faceRectangles);
        this.set(CaptureResult.STATISTICS_FACE_IDS, faceIds);
        this.set(CaptureResult.STATISTICS_FACE_LANDMARKS, faceLandmarks);
        this.set(CaptureResult.STATISTICS_FACE_SCORES, faceScores);
        return true;
    }

    private final Face[] $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getFaces() {
        int i;
        int[] faceLandmarks;
        int[] faceIds;
        Rect[] faceRectangles;
        byte[] faceScores;
        Integer faceDetectMode = this.get(CaptureResult.STATISTICS_FACE_DETECT_MODE);
        if (CameraMetadataNative.areValuesAllNull(faceDetectMode, faceScores = this.get(CaptureResult.STATISTICS_FACE_SCORES), faceRectangles = this.get(CaptureResult.STATISTICS_FACE_RECTANGLES), faceIds = this.get(CaptureResult.STATISTICS_FACE_IDS), faceLandmarks = this.get(CaptureResult.STATISTICS_FACE_LANDMARKS))) {
            return null;
        }
        if (faceDetectMode == null) {
            Log.w("CameraMetadataJV", "Face detect mode metadata is null, assuming the mode is SIMPLE");
            faceDetectMode = 1;
        } else {
            if (faceDetectMode == 0) {
                return new Face[0];
            }
            if (faceDetectMode != 1 && faceDetectMode != 2) {
                Log.w("CameraMetadataJV", "Unknown face detect mode: " + faceDetectMode);
                return new Face[0];
            }
        }
        if (faceScores == null || faceRectangles == null) {
            Log.w("CameraMetadataJV", "Expect face scores and rectangles to be non-null");
            return new Face[0];
        }
        if (faceScores.length != faceRectangles.length) {
            Log.w("CameraMetadataJV", String.format("Face score size(%d) doesn match face rectangle size(%d)!", faceScores.length, faceRectangles.length));
        }
        int numFaces = Math.min(faceScores.length, faceRectangles.length);
        if (faceDetectMode == 2) {
            if (faceIds == null || faceLandmarks == null) {
                Log.w("CameraMetadataJV", "Expect face ids and landmarks to be non-null for FULL mode,fallback to SIMPLE mode");
                faceDetectMode = 1;
            } else {
                if (faceIds.length != numFaces || faceLandmarks.length != numFaces * 6) {
                    Log.w("CameraMetadataJV", String.format("Face id size(%d), or face landmark size(%d) don'tmatch face number(%d)!", faceIds.length, faceLandmarks.length * 6, numFaces));
                }
                numFaces = Math.min(numFaces, faceIds.length);
                numFaces = Math.min(numFaces, faceLandmarks.length / 6);
            }
        }
        ArrayList<Face> faceList = new ArrayList<Face>();
        if (faceDetectMode == 1) {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1) continue;
                faceList.add(new Face(faceRectangles[i], faceScores[i]));
            }
        } else {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1 || faceIds[i] < 0) continue;
                Point leftEye = new Point(faceLandmarks[i * 6], faceLandmarks[i * 6 + 1]);
                Point rightEye = new Point(faceLandmarks[i * 6 + 2], faceLandmarks[i * 6 + 3]);
                Point mouth = new Point(faceLandmarks[i * 6 + 4], faceLandmarks[i * 6 + 5]);
                Face face = new Face(faceRectangles[i], faceScores[i], faceIds[i], leftEye, rightEye, mouth);
                faceList.add(face);
            }
        }
        Face[] faces = new Face[faceList.size()];
        faceList.toArray(faces);
        return faces;
    }

    private final Rect[] $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getFaceRectangles() {
        Rect[] faceRectangles = this.getBase(CaptureResult.STATISTICS_FACE_RECTANGLES);
        if (faceRectangles == null) {
            return null;
        }
        Rect[] fixedFaceRectangles = new Rect[faceRectangles.length];
        for (int i = 0; i < faceRectangles.length; ++i) {
            fixedFaceRectangles[i] = new Rect(faceRectangles[i].left, faceRectangles[i].top, faceRectangles[i].right - faceRectangles[i].left, faceRectangles[i].bottom - faceRectangles[i].top);
        }
        return fixedFaceRectangles;
    }

    private final LensShadingMap $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getLensShadingMap() {
        float[] lsmArray = this.getBase(CaptureResult.STATISTICS_LENS_SHADING_MAP);
        Size s = this.get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE);
        if (lsmArray == null) {
            return null;
        }
        if (s == null) {
            Log.w("CameraMetadataJV", "getLensShadingMap - Lens shading map size was null.");
            return null;
        }
        LensShadingMap map = new LensShadingMap(lsmArray, s.getHeight(), s.getWidth());
        return map;
    }

    private final Location $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getGpsLocation() {
        String processingMethod = this.get(CaptureResult.JPEG_GPS_PROCESSING_METHOD);
        double[] coords = this.get(CaptureResult.JPEG_GPS_COORDINATES);
        Long timeStamp = this.get(CaptureResult.JPEG_GPS_TIMESTAMP);
        if (CameraMetadataNative.areValuesAllNull(processingMethod, coords, timeStamp)) {
            return null;
        }
        Location l = new Location(CameraMetadataNative.translateProcessToLocationProvider(processingMethod));
        if (timeStamp != null) {
            l.setTime(timeStamp);
        } else {
            Log.w("CameraMetadataJV", "getGpsLocation - No timestamp for GPS location.");
        }
        if (coords != null) {
            l.setLatitude(coords[0]);
            l.setLongitude(coords[1]);
            l.setAltitude(coords[2]);
        } else {
            Log.w("CameraMetadataJV", "getGpsLocation - No coordinates for GPS location");
        }
        return l;
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setGpsLocation(Location l) {
        if (l == null) {
            return false;
        }
        double[] coords = new double[]{l.getLatitude(), l.getLongitude(), l.getAltitude()};
        String processMethod = CameraMetadataNative.translateLocationProviderToProcess(l.getProvider());
        long timestamp = l.getTime();
        this.set(CaptureRequest.JPEG_GPS_TIMESTAMP, Long.valueOf(timestamp));
        this.set(CaptureRequest.JPEG_GPS_COORDINATES, coords);
        if (processMethod == null) {
            Log.w("CameraMetadataJV", "setGpsLocation - No process method, Location is not from a GPS or NETWORKprovider");
        } else {
            this.setBase(CaptureRequest.JPEG_GPS_PROCESSING_METHOD, processMethod);
        }
        return true;
    }

    private final StreamConfigurationMap $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getStreamConfigurationMap() {
        StreamConfiguration[] configurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] minFrameDurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] stallDurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STALL_DURATIONS);
        StreamConfiguration[] depthConfigurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] depthMinFrameDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] depthStallDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_STALL_DURATIONS);
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurations = this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS);
        ReprocessFormatsMap inputOutputFormatsMap = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP);
        int[] capabilities = this.getBase(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean listHighResolution = false;
        for (int capability : capabilities) {
            if (capability != 6) continue;
            listHighResolution = true;
            break;
        }
        return new StreamConfigurationMap(configurations, minFrameDurations, stallDurations, depthConfigurations, depthMinFrameDurations, depthStallDurations, highSpeedVideoConfigurations, inputOutputFormatsMap, listHighResolution);
    }

    private final <T> Integer $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getMaxRegions(Key<T> key) {
        boolean AE = false;
        boolean AWB = true;
        int AF = 2;
        int[] maxRegions = this.getBase(CameraCharacteristics.CONTROL_MAX_REGIONS);
        if (maxRegions == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AE)) {
            return maxRegions[0];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB)) {
            return maxRegions[1];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AF)) {
            return maxRegions[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private final <T> Integer $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getMaxNumOutputs(Key<T> key) {
        boolean RAW = false;
        boolean PROC = true;
        int PROC_STALLING = 2;
        int[] maxNumOutputs = this.getBase(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_STREAMS);
        if (maxNumOutputs == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW)) {
            return maxNumOutputs[0];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC)) {
            return maxNumOutputs[1];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING)) {
            return maxNumOutputs[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private final <T> TonemapCurve $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getTonemapCurve() {
        float[] blue;
        float[] green;
        float[] red = this.getBase(CaptureRequest.TONEMAP_CURVE_RED);
        if (CameraMetadataNative.areValuesAllNull(red, green = this.getBase(CaptureRequest.TONEMAP_CURVE_GREEN), blue = this.getBase(CaptureRequest.TONEMAP_CURVE_BLUE))) {
            return null;
        }
        if (red == null || green == null || blue == null) {
            Log.w("CameraMetadataJV", "getTonemapCurve - missing tone curve components");
            return null;
        }
        TonemapCurve tc = new TonemapCurve(red, green, blue);
        return tc;
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(CameraCharacteristics.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(CaptureResult.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(CaptureRequest.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(Key<T> key, T value) {
        int tag = key.getTag();
        if (value == null) {
            this.writeValues(tag, null);
            return;
        }
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key);
        int size = marshaler.calculateMarshalSize(value);
        byte[] values = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        marshaler.marshal(value, buffer);
        this.writeValues(tag, values);
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setAvailableFormats(int[] value) {
        int[] availableFormat = value;
        if (value == null) {
            return false;
        }
        int[] newValues = new int[availableFormat.length];
        for (int i = 0; i < availableFormat.length; ++i) {
            newValues[i] = availableFormat[i];
            if (availableFormat[i] != 256) continue;
            newValues[i] = 33;
        }
        this.setBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS, newValues);
        return true;
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setFaceRectangles(Rect[] faceRects) {
        if (faceRects == null) {
            return false;
        }
        Rect[] newFaceRects = new Rect[faceRects.length];
        for (int i = 0; i < newFaceRects.length; ++i) {
            newFaceRects[i] = new Rect(faceRects[i].left, faceRects[i].top, faceRects[i].right + faceRects[i].left, faceRects[i].bottom + faceRects[i].top);
        }
        this.setBase(CaptureResult.STATISTICS_FACE_RECTANGLES, newFaceRects);
        return true;
    }

    private final <T> boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setTonemapCurve(TonemapCurve tc) {
        if (tc == null) {
            return false;
        }
        float[][] curve = new float[3][];
        for (int i = 0; i <= 2; ++i) {
            int pointCount = tc.getPointCount(i);
            curve[i] = new float[pointCount * 2];
            tc.copyColorCurve(i, curve[i], 0);
        }
        this.setBase(CaptureRequest.TONEMAP_CURVE_RED, curve[0]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_GREEN, curve[1]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_BLUE, curve[2]);
        return true;
    }

    private final long $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeAllocate() {
        return 0L;
    }

    private final long $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeAllocateCopy(CameraMetadataNative cameraMetadataNative) throws NullPointerException {
        return 0L;
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeWriteToParcel(Parcel parcel) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeReadFromParcel(Parcel parcel) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeSwap(CameraMetadataNative cameraMetadataNative) throws NullPointerException {
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeClose() {
    }

    private final synchronized boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeIsEmpty() {
        return false;
    }

    private final synchronized int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetEntryCount() {
        return 0;
    }

    private final synchronized byte[] $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeReadValues(int n) {
        return null;
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeWriteValues(int n, byte[] byArray) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeDump() throws IOException {
    }

    private static final ArrayList $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetAllVendorKeys(Class clazz) {
        return null;
    }

    private static final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetTagFromKey(String string2) throws IllegalArgumentException {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetTypeFromTag(int n) throws IllegalArgumentException {
        return 0;
    }

    private static final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeClassInit() {
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$swap(CameraMetadataNative other) {
        this.nativeSwap(other);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getEntryCount() {
        return this.nativeGetEntryCount();
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$isEmpty() {
        return this.nativeIsEmpty();
    }

    private static final <K> ArrayList<K> $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getAllVendorKeys(Class<K> keyClass) {
        if (keyClass == null) {
            throw new NullPointerException();
        }
        return CameraMetadataNative.nativeGetAllVendorKeys(keyClass);
    }

    private static final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getTag(String key) {
        return CameraMetadataNative.nativeGetTagFromKey(key);
    }

    private static final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getNativeType(int tag) {
        return CameraMetadataNative.nativeGetTypeFromTag(tag);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$writeValues(int tag, byte[] src) {
        this.nativeWriteValues(tag, src);
    }

    private final byte[] $$robo$$android_hardware_camera2_impl_CameraMetadataNative$readValues(int tag) {
        return this.nativeReadValues(tag);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$dumpToLog() {
        try {
            this.nativeDump();
        }
        catch (IOException e) {
            Log.wtf("CameraMetadataJV", "Dump logging failed", e);
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static final <T> Marshaler<T> $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getMarshalerForKey(Key<T> key) {
        return MarshalRegistry.getMarshaler(key.getTypeReference(), CameraMetadataNative.getNativeType(key.getTag()));
    }

    private static final void $$robo$$android_hardware_camera2_impl_CameraMetadataNative$registerAllMarshalers() {
        MarshalQueryable[] queryList;
        for (MarshalQueryable query : queryList = new MarshalQueryable[]{new MarshalQueryablePrimitive(), new MarshalQueryableEnum(), new MarshalQueryableArray(), new MarshalQueryableBoolean(), new MarshalQueryableNativeByteToInteger(), new MarshalQueryableRect(), new MarshalQueryableSize(), new MarshalQueryableSizeF(), new MarshalQueryableString(), new MarshalQueryableReprocessFormatsMap(), new MarshalQueryableRange(), new MarshalQueryablePair(), new MarshalQueryableMeteringRectangle(), new MarshalQueryableColorSpaceTransform(), new MarshalQueryableStreamConfiguration(), new MarshalQueryableStreamConfigurationDuration(), new MarshalQueryableRggbChannelVector(), new MarshalQueryableBlackLevelPattern(), new MarshalQueryableHighSpeedVideoConfiguration(), new MarshalQueryableParcelable()}) {
            MarshalRegistry.registerMarshalQueryable(query);
        }
    }

    private static final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative$areValuesAllNull(Object ... objs) {
        for (Object o : objs) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<CameraMetadataNative>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$__constructor__() {
            }

            private final CameraMetadataNative $$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$createFromParcel(Parcel in) {
                CameraMetadataNative metadata = new CameraMetadataNative();
                metadata.readFromParcel(in);
                return metadata;
            }

            private final CameraMetadataNative[] $$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$newArray(int size) {
                return new CameraMetadataNative[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$__constructor__(), 0, this);
            }

            @Override
            public CameraMetadataNative createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public CameraMetadataNative[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sGetCommandMap = new HashMap();
        sGetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_2$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_2$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getAvailableFormats();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_2$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_2$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_3$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_3$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getFaces();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_3$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_3$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_4$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_4$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getFaceRectangles();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_4$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_4$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_4$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_5$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_5$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getStreamConfigurationMap();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_5$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_5$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_5$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AE.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_6$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_6$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_6$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_6$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_6$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_7$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_7$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_7$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_7$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_7$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AF.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_8$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_8$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_8$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_8$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_8$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_9$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_9$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_9$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_9$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_9$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_10$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_10$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_10$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_10$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_10$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_11$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_11$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_11$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_11$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_11$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_12$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_12$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getTonemapCurve();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_12$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_12$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_12$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_13$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_13$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getGpsLocation();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_13$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_13$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_13$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_LENS_SHADING_CORRECTION_MAP.getNativeKey(), new GetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_14$__constructor__() {
            }

            private final <T> T $$robo$$android_hardware_camera2_impl_CameraMetadataNative_14$getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getLensShadingMap();
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_14$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_14$__constructor__(), 0, this);
            }

            @Override
            public <T> T getValue(CameraMetadataNative cameraMetadataNative, Key<T> key) {
                return (T)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_14$getValue(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, cameraMetadataNative, key);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sSetCommandMap = new HashMap();
        sSetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new SetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_15$__constructor__() {
            }

            private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_15$setValue(CameraMetadataNative metadata, T value) {
                metadata.setAvailableFormats((int[])value);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_15$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_15$__constructor__(), 0, this);
            }

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_15$setValue(android.hardware.camera2.impl.CameraMetadataNative T ), 0, this, cameraMetadataNative, t);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new SetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_16$__constructor__() {
            }

            private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_16$setValue(CameraMetadataNative metadata, T value) {
                metadata.setFaceRectangles((Rect[])value);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_16$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_16$__constructor__(), 0, this);
            }

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_16$setValue(android.hardware.camera2.impl.CameraMetadataNative T ), 0, this, cameraMetadataNative, t);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new SetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_17$__constructor__() {
            }

            private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_17$setValue(CameraMetadataNative metadata, T value) {
                metadata.setFaces((Face[])value);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_17$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_17$__constructor__(), 0, this);
            }

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_17$setValue(android.hardware.camera2.impl.CameraMetadataNative T ), 0, this, cameraMetadataNative, t);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sSetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new SetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_18$__constructor__() {
            }

            private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_18$setValue(CameraMetadataNative metadata, T value) {
                metadata.setTonemapCurve((TonemapCurve)value);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_18$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_18$__constructor__(), 0, this);
            }

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_18$setValue(android.hardware.camera2.impl.CameraMetadataNative T ), 0, this, cameraMetadataNative, t);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        sSetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new SetCommand(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_19$__constructor__() {
            }

            private final <T> void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_19$setValue(CameraMetadataNative metadata, T value) {
                metadata.setGpsLocation((Location)value);
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_19$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_19$__constructor__(), 0, this);
            }

            @Override
            public <T> void setValue(CameraMetadataNative cameraMetadataNative, T t) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_19$setValue(android.hardware.camera2.impl.CameraMetadataNative T ), 0, this, cameraMetadataNative, t);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        CameraMetadataNative.nativeClassInit();
        CameraMetadataNative.registerAllMarshalers();
    }

    private static String translateLocationProviderToProcess(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("translateLocationProviderToProcess", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$translateLocationProviderToProcess(java.lang.String ), 0, (String)string2);
    }

    private static String translateProcessToLocationProvider(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("translateProcessToLocationProvider", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$translateProcessToLocationProvider(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative$__constructor__();
    }

    public CameraMetadataNative() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$__constructor__(), 0, this);
    }

    private void __constructor__(CameraMetadataNative cameraMetadataNative) {
        this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative$__constructor__(cameraMetadataNative);
    }

    public CameraMetadataNative(CameraMetadataNative cameraMetadataNative) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$__constructor__(android.hardware.camera2.impl.CameraMetadataNative ), 0, this, cameraMetadataNative);
    }

    public static CameraMetadataNative move(CameraMetadataNative cameraMetadataNative) {
        return InvokeDynamicSupport.bootstrapStatic("move", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$move(android.hardware.camera2.impl.CameraMetadataNative ), 0, (CameraMetadataNative)cameraMetadataNative);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public <T> T get(CameraCharacteristics.Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(android.hardware.camera2.CameraCharacteristics$Key<T> ), 0, this, key);
    }

    public <T> T get(CaptureResult.Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(android.hardware.camera2.CaptureResult$Key<T> ), 0, this, key);
    }

    public <T> T get(CaptureRequest.Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(android.hardware.camera2.CaptureRequest$Key<T> ), 0, this, key);
    }

    public <T> T get(Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$get(android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, key);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public static void setupGlobalVendorTagDescriptor() throws ServiceSpecificException {
        InvokeDynamicSupport.bootstrapStatic("setupGlobalVendorTagDescriptor", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setupGlobalVendorTagDescriptor(), 0);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetupGlobalVendorTagDescriptor$nativeBinding();

    private static int nativeSetupGlobalVendorTagDescriptor() {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetupGlobalVendorTagDescriptor", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeSetupGlobalVendorTagDescriptor(), 1);
    }

    public <T> void set(Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(android.hardware.camera2.impl.CameraMetadataNative$Key<T> T ), 0, this, key, t);
    }

    public <T> void set(CaptureRequest.Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(android.hardware.camera2.CaptureRequest$Key<T> T ), 0, this, key, t);
    }

    public <T> void set(CaptureResult.Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(android.hardware.camera2.CaptureResult$Key<T> T ), 0, this, key, t);
    }

    public <T> void set(CameraCharacteristics.Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$set(android.hardware.camera2.CameraCharacteristics$Key<T> T ), 0, this, key, t);
    }

    private void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$close(), 0, this);
    }

    private <T> T getBase(CameraCharacteristics.Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("getBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(android.hardware.camera2.CameraCharacteristics$Key<T> ), 0, this, key);
    }

    private <T> T getBase(CaptureResult.Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("getBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(android.hardware.camera2.CaptureResult$Key<T> ), 0, this, key);
    }

    private <T> T getBase(CaptureRequest.Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("getBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(android.hardware.camera2.CaptureRequest$Key<T> ), 0, this, key);
    }

    private <T> T getBase(Key<T> key) {
        return (T)InvokeDynamicSupport.bootstrap("getBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getBase(android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, key);
    }

    private int[] getAvailableFormats() {
        return InvokeDynamicSupport.bootstrap("getAvailableFormats", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getAvailableFormats(), 0, this);
    }

    private boolean setFaces(Face[] faceArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFaces", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setFaces(android.hardware.camera2.params.Face[] ), 0, this, faceArray);
    }

    private Face[] getFaces() {
        return InvokeDynamicSupport.bootstrap("getFaces", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getFaces(), 0, this);
    }

    private Rect[] getFaceRectangles() {
        return InvokeDynamicSupport.bootstrap("getFaceRectangles", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getFaceRectangles(), 0, this);
    }

    private LensShadingMap getLensShadingMap() {
        return InvokeDynamicSupport.bootstrap("getLensShadingMap", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getLensShadingMap(), 0, this);
    }

    private Location getGpsLocation() {
        return InvokeDynamicSupport.bootstrap("getGpsLocation", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getGpsLocation(), 0, this);
    }

    private boolean setGpsLocation(Location location) {
        return (boolean)InvokeDynamicSupport.bootstrap("setGpsLocation", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setGpsLocation(android.location.Location ), 0, this, location);
    }

    private StreamConfigurationMap getStreamConfigurationMap() {
        return InvokeDynamicSupport.bootstrap("getStreamConfigurationMap", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getStreamConfigurationMap(), 0, this);
    }

    private <T> Integer getMaxRegions(Key<T> key) {
        return InvokeDynamicSupport.bootstrap("getMaxRegions", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getMaxRegions(android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, key);
    }

    private <T> Integer getMaxNumOutputs(Key<T> key) {
        return InvokeDynamicSupport.bootstrap("getMaxNumOutputs", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getMaxNumOutputs(android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, this, key);
    }

    private <T> TonemapCurve getTonemapCurve() {
        return InvokeDynamicSupport.bootstrap("getTonemapCurve", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getTonemapCurve(), 0, this);
    }

    private <T> void setBase(CameraCharacteristics.Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("setBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(android.hardware.camera2.CameraCharacteristics$Key<T> T ), 0, this, key, t);
    }

    private <T> void setBase(CaptureResult.Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("setBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(android.hardware.camera2.CaptureResult$Key<T> T ), 0, this, key, t);
    }

    private <T> void setBase(CaptureRequest.Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("setBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(android.hardware.camera2.CaptureRequest$Key<T> T ), 0, this, key, t);
    }

    private <T> void setBase(Key<T> key, T t) {
        InvokeDynamicSupport.bootstrap("setBase", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setBase(android.hardware.camera2.impl.CameraMetadataNative$Key<T> T ), 0, this, key, t);
    }

    private boolean setAvailableFormats(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setAvailableFormats", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setAvailableFormats(int[] ), 0, this, nArray);
    }

    private boolean setFaceRectangles(Rect[] rectArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFaceRectangles", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setFaceRectangles(android.graphics.Rect[] ), 0, this, rectArray);
    }

    private <T> boolean setTonemapCurve(TonemapCurve tonemapCurve) {
        return (boolean)InvokeDynamicSupport.bootstrap("setTonemapCurve", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$setTonemapCurve(android.hardware.camera2.params.TonemapCurve ), 0, this, tonemapCurve);
    }

    private final native /* synthetic */ long $$robo$$nativeAllocate$nativeBinding();

    private long nativeAllocate() {
        return (long)InvokeDynamicSupport.bootstrap("nativeAllocate", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeAllocate(), 1, this);
    }

    private final native /* synthetic */ long $$robo$$nativeAllocateCopy$nativeBinding(CameraMetadataNative var1) throws NullPointerException;

    private long nativeAllocateCopy(CameraMetadataNative cameraMetadataNative) throws NullPointerException {
        return (long)InvokeDynamicSupport.bootstrap("nativeAllocateCopy", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeAllocateCopy(android.hardware.camera2.impl.CameraMetadataNative ), 1, this, cameraMetadataNative);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeWriteToParcel$nativeBinding(Parcel var1);

    private synchronized void nativeWriteToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("nativeWriteToParcel", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeWriteToParcel(android.os.Parcel ), 1, this, parcel);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeReadFromParcel$nativeBinding(Parcel var1);

    private synchronized void nativeReadFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("nativeReadFromParcel", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeReadFromParcel(android.os.Parcel ), 1, this, parcel);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeSwap$nativeBinding(CameraMetadataNative var1) throws NullPointerException;

    private synchronized void nativeSwap(CameraMetadataNative cameraMetadataNative) throws NullPointerException {
        InvokeDynamicSupport.bootstrap("nativeSwap", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeSwap(android.hardware.camera2.impl.CameraMetadataNative ), 1, this, cameraMetadataNative);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeClose$nativeBinding();

    private synchronized void nativeClose() {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeClose(), 1, this);
    }

    private final synchronized native /* synthetic */ boolean $$robo$$nativeIsEmpty$nativeBinding();

    private synchronized boolean nativeIsEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeIsEmpty", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeIsEmpty(), 1, this);
    }

    private final synchronized native /* synthetic */ int $$robo$$nativeGetEntryCount$nativeBinding();

    private synchronized int nativeGetEntryCount() {
        return (int)InvokeDynamicSupport.bootstrap("nativeGetEntryCount", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetEntryCount(), 1, this);
    }

    private final synchronized native /* synthetic */ byte[] $$robo$$nativeReadValues$nativeBinding(int var1);

    private synchronized byte[] nativeReadValues(int n) {
        return InvokeDynamicSupport.bootstrap("nativeReadValues", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeReadValues(int ), 1, this, n);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeWriteValues$nativeBinding(int var1, byte[] var2);

    private synchronized void nativeWriteValues(int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("nativeWriteValues", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeWriteValues(int byte[] ), 1, this, n, byArray);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeDump$nativeBinding() throws IOException;

    private synchronized void nativeDump() throws IOException {
        InvokeDynamicSupport.bootstrap("nativeDump", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeDump(), 1, this);
    }

    private static final native /* synthetic */ ArrayList $$robo$$nativeGetAllVendorKeys$nativeBinding(Class var0);

    private static ArrayList nativeGetAllVendorKeys(Class clazz) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetAllVendorKeys", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetAllVendorKeys(java.lang.Class ), 1, (Class)clazz);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetTagFromKey$nativeBinding(String var0) throws IllegalArgumentException;

    private static int nativeGetTagFromKey(String string2) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetTagFromKey", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetTagFromKey(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetTypeFromTag$nativeBinding(int var0) throws IllegalArgumentException;

    private static int nativeGetTypeFromTag(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetTypeFromTag", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeGetTypeFromTag(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeClassInit$nativeBinding();

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$nativeClassInit(), 1);
    }

    public void swap(CameraMetadataNative cameraMetadataNative) {
        InvokeDynamicSupport.bootstrap("swap", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$swap(android.hardware.camera2.impl.CameraMetadataNative ), 0, this, cameraMetadataNative);
    }

    public int getEntryCount() {
        return (int)InvokeDynamicSupport.bootstrap("getEntryCount", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getEntryCount(), 0, this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$isEmpty(), 0, this);
    }

    public static <K> ArrayList<K> getAllVendorKeys(Class<K> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getAllVendorKeys", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getAllVendorKeys(java.lang.Class<K> ), 0, clazz);
    }

    public static int getTag(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTag", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getTag(java.lang.String ), 0, (String)string2);
    }

    public static int getNativeType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNativeType", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getNativeType(int ), 0, (int)n);
    }

    public void writeValues(int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("writeValues", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$writeValues(int byte[] ), 0, this, n, byArray);
    }

    public byte[] readValues(int n) {
        return InvokeDynamicSupport.bootstrap("readValues", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$readValues(int ), 0, this, n);
    }

    public void dumpToLog() {
        InvokeDynamicSupport.bootstrap("dumpToLog", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$dumpToLog(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$finalize(), 0, this);
    }

    private static <T> Marshaler<T> getMarshalerForKey(Key<T> key) {
        return InvokeDynamicSupport.bootstrapStatic("getMarshalerForKey", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$getMarshalerForKey(android.hardware.camera2.impl.CameraMetadataNative$Key<T> ), 0, key);
    }

    private static void registerAllMarshalers() {
        InvokeDynamicSupport.bootstrapStatic("registerAllMarshalers", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$registerAllMarshalers(), 0);
    }

    private static boolean areValuesAllNull(Object ... objectArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areValuesAllNull", $$robo$$android_hardware_camera2_impl_CameraMetadataNative$areValuesAllNull(java.lang.Object[] ), 0, (Object[])objectArray);
    }

    static {
        RobolectricInternals.classInitializing(CameraMetadataNative.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraMetadataNative)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Key<T> {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mHasTag;
        private int mTag;
        private Class<T> mType;
        private TypeReference<T> mTypeReference;
        private String mName;
        private int mHash;

        private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$__constructor__(String name, Class<T> type) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (type == null) {
                throw new NullPointerException("Type needs to be non-null");
            }
            this.mName = name;
            this.mType = type;
            this.mTypeReference = TypeReference.createSpecializedTypeReference(type);
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        private void $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$__constructor__(String name, TypeReference<T> typeReference) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (typeReference == null) {
                throw new NullPointerException("TypeReference needs to be non-null");
            }
            this.mName = name;
            this.mType = typeReference.getRawType();
            this.mTypeReference = typeReference;
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        private final String $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getName() {
            return this.mName;
        }

        private final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$hashCode() {
            return this.mHash;
        }

        private final boolean $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$equals(Object o) {
            Key lhs;
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            if (o instanceof CaptureResult.Key) {
                lhs = ((CaptureResult.Key)o).getNativeKey();
            } else if (o instanceof CaptureRequest.Key) {
                lhs = ((CaptureRequest.Key)o).getNativeKey();
            } else if (o instanceof CameraCharacteristics.Key) {
                lhs = ((CameraCharacteristics.Key)o).getNativeKey();
            } else if (o instanceof Key) {
                lhs = (Key)o;
            } else {
                return false;
            }
            return this.mName.equals(lhs.mName) && this.mTypeReference.equals(lhs.mTypeReference);
        }

        private final int $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getTag() {
            if (!this.mHasTag) {
                this.mTag = CameraMetadataNative.getTag(this.mName);
                this.mHasTag = true;
            }
            return this.mTag;
        }

        private final Class<T> $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getType() {
            return this.mType;
        }

        private final TypeReference<T> $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getTypeReference() {
            return this.mTypeReference;
        }

        private void __constructor__(String string2, Class<T> clazz) {
            this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$__constructor__(string2, clazz);
        }

        public Key(String string2, Class<T> clazz) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$__constructor__(java.lang.String java.lang.Class<T> ), 0, this, string2, clazz);
        }

        private void __constructor__(String string2, TypeReference<T> typeReference) {
            this.$$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$__constructor__(string2, typeReference);
        }

        public Key(String string2, TypeReference<T> typeReference) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$__constructor__(java.lang.String android.hardware.camera2.utils.TypeReference<T> ), 0, this, string2, typeReference);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getName(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$equals(java.lang.Object ), 0, this, object);
        }

        public int getTag() {
            return (int)InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getTag(), 0, this);
        }

        public Class<T> getType() {
            return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getType(), 0, this);
        }

        public TypeReference<T> getTypeReference() {
            return InvokeDynamicSupport.bootstrap("getTypeReference", $$robo$$android_hardware_camera2_impl_CameraMetadataNative_Key$getTypeReference(), 0, this);
        }

        public /* synthetic */ Key() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Key)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

