/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraConstrainedHighSpeedCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Handler;
import android.util.Range;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraConstrainedHighSpeedCaptureSessionImpl
extends CameraConstrainedHighSpeedCaptureSession
implements CameraCaptureSessionCore,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CameraCharacteristics mCharacteristics;
    private CameraCaptureSessionImpl mSessionImpl;

    private void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$__constructor__(int id2, List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler stateHandler, CameraDeviceImpl deviceImpl, Handler deviceStateHandler, boolean configureSuccess, CameraCharacteristics characteristics) {
        this.mCharacteristics = characteristics;
        WrapperCallback wrapperCallback = new WrapperCallback(this, callback);
        this.mSessionImpl = new CameraCaptureSessionImpl(id2, null, outputs, wrapperCallback, stateHandler, deviceImpl, deviceStateHandler, configureSuccess);
    }

    private final List<CaptureRequest> $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$createHighSpeedRequestList(CaptureRequest request) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("Input capture request must not be null");
        }
        Collection<Surface> outputSurfaces = request.getTargets();
        Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
        StreamConfigurationMap config = this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        SurfaceUtils.checkConstrainedHighSpeedSurfaces(outputSurfaces, fpsRange, config);
        int requestListSize = fpsRange.getUpper() / 30;
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        CameraMetadataNative requestMetadata = new CameraMetadataNative(request.getNativeCopy());
        CaptureRequest.Builder singleTargetRequestBuilder = new CaptureRequest.Builder(requestMetadata, false, -1);
        Iterator<Surface> iterator = outputSurfaces.iterator();
        Surface firstSurface = iterator.next();
        Surface secondSurface = null;
        if (outputSurfaces.size() == 1 && SurfaceUtils.isSurfaceForHwVideoEncoder(firstSurface)) {
            singleTargetRequestBuilder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, 1);
        } else {
            singleTargetRequestBuilder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, 3);
        }
        singleTargetRequestBuilder.setPartOfCHSRequestList(true);
        CaptureRequest.Builder doubleTargetRequestBuilder = null;
        if (outputSurfaces.size() == 2) {
            requestMetadata = new CameraMetadataNative(request.getNativeCopy());
            doubleTargetRequestBuilder = new CaptureRequest.Builder(requestMetadata, false, -1);
            doubleTargetRequestBuilder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, 3);
            doubleTargetRequestBuilder.addTarget(firstSurface);
            secondSurface = iterator.next();
            doubleTargetRequestBuilder.addTarget(secondSurface);
            doubleTargetRequestBuilder.setPartOfCHSRequestList(true);
            Surface recordingSurface = firstSurface;
            if (!SurfaceUtils.isSurfaceForHwVideoEncoder(recordingSurface)) {
                recordingSurface = secondSurface;
            }
            singleTargetRequestBuilder.addTarget(recordingSurface);
        } else {
            singleTargetRequestBuilder.addTarget(firstSurface);
        }
        for (int i = 0; i < requestListSize; ++i) {
            if (i == 0 && doubleTargetRequestBuilder != null) {
                requestList.add(doubleTargetRequestBuilder.build());
                continue;
            }
            requestList.add(singleTargetRequestBuilder.build());
        }
        return Collections.unmodifiableList(requestList);
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$isConstrainedHighSpeedRequestList(List<CaptureRequest> requestList) {
        Preconditions.checkCollectionNotEmpty(requestList, "High speed request list");
        for (CaptureRequest request : requestList) {
            if (request.isPartOfCRequestList()) continue;
            return false;
        }
        return true;
    }

    private final CameraDevice $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$getDevice() {
        return this.mSessionImpl.getDevice();
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$prepare(Surface surface) throws CameraAccessException {
        this.mSessionImpl.prepare(surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$prepare(int maxCount, Surface surface) throws CameraAccessException {
        this.mSessionImpl.prepare(maxCount, surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$tearDown(Surface surface) throws CameraAccessException {
        this.mSessionImpl.tearDown(surface);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$capture(CaptureRequest request, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Constrained high speed session doesn't support this method");
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        if (!this.isConstrainedHighSpeedRequestList(requests)) {
            throw new IllegalArgumentException("Only request lists created by createHighSpeedRequestList() can be submitted to a constrained high speed capture session");
        }
        return this.mSessionImpl.captureBurst(requests, listener, handler);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        throw new UnsupportedOperationException("Constrained high speed session doesn't support this method");
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback listener, Handler handler) throws CameraAccessException {
        if (!this.isConstrainedHighSpeedRequestList(requests)) {
            throw new IllegalArgumentException("Only request lists created by createHighSpeedRequestList() can be submitted to a constrained high speed capture session");
        }
        return this.mSessionImpl.setRepeatingBurst(requests, listener, handler);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$stopRepeating() throws CameraAccessException {
        this.mSessionImpl.stopRepeating();
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$abortCaptures() throws CameraAccessException {
        this.mSessionImpl.abortCaptures();
    }

    private final Surface $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$getInputSurface() {
        return null;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$close() {
        this.mSessionImpl.close();
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$isReprocessable() {
        return false;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$replaceSessionClose() {
        this.mSessionImpl.replaceSessionClose();
    }

    private final CameraDeviceImpl.StateCallbackKK $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$getDeviceStateCallback() {
        return this.mSessionImpl.getDeviceStateCallback();
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$isAborting() {
        return this.mSessionImpl.isAborting();
    }

    private void __constructor__(int n, List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler, CameraDeviceImpl cameraDeviceImpl, Handler handler2, boolean bl, CameraCharacteristics cameraCharacteristics) {
        this.$$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$__constructor__(n, list, stateCallback, handler, cameraDeviceImpl, handler2, bl, cameraCharacteristics);
    }

    CameraConstrainedHighSpeedCaptureSessionImpl(int n, List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler, CameraDeviceImpl cameraDeviceImpl, Handler handler2, boolean bl, CameraCharacteristics cameraCharacteristics) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$__constructor__(int java.util.List<android.view.Surface> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler android.hardware.camera2.impl.CameraDeviceImpl android.os.Handler boolean android.hardware.camera2.CameraCharacteristics ), 0, this, n, list, stateCallback, handler, cameraDeviceImpl, handler2, bl, cameraCharacteristics);
    }

    @Override
    public List<CaptureRequest> createHighSpeedRequestList(CaptureRequest captureRequest) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("createHighSpeedRequestList", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$createHighSpeedRequestList(android.hardware.camera2.CaptureRequest ), 0, this, captureRequest);
    }

    private boolean isConstrainedHighSpeedRequestList(List<CaptureRequest> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConstrainedHighSpeedRequestList", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$isConstrainedHighSpeedRequestList(java.util.List<android.hardware.camera2.CaptureRequest> ), 0, this, list);
    }

    @Override
    public CameraDevice getDevice() {
        return InvokeDynamicSupport.bootstrap("getDevice", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$getDevice(), 0, this);
    }

    @Override
    public void prepare(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$prepare(android.view.Surface ), 0, this, surface);
    }

    @Override
    public void prepare(int n, Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$prepare(int android.view.Surface ), 0, this, n, surface);
    }

    @Override
    public void tearDown(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$tearDown(android.view.Surface ), 0, this, surface);
    }

    @Override
    public int capture(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("capture", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$capture(android.hardware.camera2.CaptureRequest android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    @Override
    public int captureBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureBurst", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$captureBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    @Override
    public int setRepeatingRequest(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$setRepeatingRequest(android.hardware.camera2.CaptureRequest android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    @Override
    public int setRepeatingBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingBurst", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$setRepeatingBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    @Override
    public void stopRepeating() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$stopRepeating(), 0, this);
    }

    @Override
    public void abortCaptures() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("abortCaptures", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$abortCaptures(), 0, this);
    }

    @Override
    public Surface getInputSurface() {
        return InvokeDynamicSupport.bootstrap("getInputSurface", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$getInputSurface(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$close(), 0, this);
    }

    @Override
    public boolean isReprocessable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReprocessable", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$isReprocessable(), 0, this);
    }

    @Override
    public void replaceSessionClose() {
        InvokeDynamicSupport.bootstrap("replaceSessionClose", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$replaceSessionClose(), 0, this);
    }

    @Override
    public CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        return InvokeDynamicSupport.bootstrap("getDeviceStateCallback", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$getDeviceStateCallback(), 0, this);
    }

    @Override
    public boolean isAborting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAborting", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl$isAborting(), 0, this);
    }

    public /* synthetic */ CameraConstrainedHighSpeedCaptureSessionImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraConstrainedHighSpeedCaptureSessionImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class WrapperCallback
    extends CameraCaptureSession.StateCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CameraCaptureSession.StateCallback mCallback;
        /* synthetic */ CameraConstrainedHighSpeedCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$__constructor__(CameraConstrainedHighSpeedCaptureSessionImpl cameraConstrainedHighSpeedCaptureSessionImpl, CameraCaptureSession.StateCallback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onConfigured(CameraCaptureSession session) {
            this.mCallback.onConfigured(this.this$0);
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onConfigureFailed(CameraCaptureSession session) {
            this.mCallback.onConfigureFailed(this.this$0);
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onReady(CameraCaptureSession session) {
            this.mCallback.onReady(this.this$0);
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onActive(CameraCaptureSession session) {
            this.mCallback.onActive(this.this$0);
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onClosed(CameraCaptureSession session) {
            this.mCallback.onClosed(this.this$0);
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onSurfacePrepared(CameraCaptureSession session, Surface surface) {
            this.mCallback.onSurfacePrepared(this.this$0, surface);
        }

        private void __constructor__(CameraConstrainedHighSpeedCaptureSessionImpl cameraConstrainedHighSpeedCaptureSessionImpl, CameraCaptureSession.StateCallback stateCallback) {
            this.$$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$__constructor__(cameraConstrainedHighSpeedCaptureSessionImpl, stateCallback);
        }

        public WrapperCallback(CameraConstrainedHighSpeedCaptureSessionImpl cameraConstrainedHighSpeedCaptureSessionImpl, CameraCaptureSession.StateCallback stateCallback) {
            this.this$0 = cameraConstrainedHighSpeedCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$__constructor__(android.hardware.camera2.impl.CameraConstrainedHighSpeedCaptureSessionImpl android.hardware.camera2.CameraCaptureSession$StateCallback ), 0, this, cameraConstrainedHighSpeedCaptureSessionImpl, stateCallback);
        }

        @Override
        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            InvokeDynamicSupport.bootstrap("onConfigured", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onConfigured(android.hardware.camera2.CameraCaptureSession ), 0, this, cameraCaptureSession);
        }

        @Override
        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            InvokeDynamicSupport.bootstrap("onConfigureFailed", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onConfigureFailed(android.hardware.camera2.CameraCaptureSession ), 0, this, cameraCaptureSession);
        }

        @Override
        public void onReady(CameraCaptureSession cameraCaptureSession) {
            InvokeDynamicSupport.bootstrap("onReady", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onReady(android.hardware.camera2.CameraCaptureSession ), 0, this, cameraCaptureSession);
        }

        @Override
        public void onActive(CameraCaptureSession cameraCaptureSession) {
            InvokeDynamicSupport.bootstrap("onActive", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onActive(android.hardware.camera2.CameraCaptureSession ), 0, this, cameraCaptureSession);
        }

        @Override
        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            InvokeDynamicSupport.bootstrap("onClosed", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onClosed(android.hardware.camera2.CameraCaptureSession ), 0, this, cameraCaptureSession);
        }

        @Override
        public void onSurfacePrepared(CameraCaptureSession cameraCaptureSession, Surface surface) {
            InvokeDynamicSupport.bootstrap("onSurfacePrepared", $$robo$$android_hardware_camera2_impl_CameraConstrainedHighSpeedCaptureSessionImpl_WrapperCallback$onSurfacePrepared(android.hardware.camera2.CameraCaptureSession android.view.Surface ), 0, this, cameraCaptureSession, surface);
        }

        public /* synthetic */ WrapperCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WrapperCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

