/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.dispatch.ArgumentReplacingDispatcher;
import android.hardware.camera2.dispatch.BroadcastDispatcher;
import android.hardware.camera2.dispatch.DuckTypingDispatcher;
import android.hardware.camera2.dispatch.HandlerDispatcher;
import android.hardware.camera2.dispatch.InvokeDispatcher;
import android.hardware.camera2.impl.CallbackProxies;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.utils.TaskDrainer;
import android.hardware.camera2.utils.TaskSingleDrainer;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraCaptureSessionImpl
extends CameraCaptureSession
implements CameraCaptureSessionCore,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraCaptureSession";
    private static boolean DEBUG = false;
    private int mId;
    private String mIdString;
    private Surface mInput;
    private List<Surface> mOutputs;
    private CameraCaptureSession.StateCallback mStateCallback;
    private Handler mStateHandler;
    private CameraDeviceImpl mDeviceImpl;
    private Handler mDeviceHandler;
    private TaskDrainer<Integer> mSequenceDrainer;
    private TaskSingleDrainer mIdleDrainer;
    private TaskSingleDrainer mAbortDrainer;
    private boolean mClosed;
    private boolean mConfigureSuccess;
    private boolean mSkipUnconfigure;
    private volatile boolean mAborting;

    private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$__constructor__(int id2, Surface input, List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler stateHandler, CameraDeviceImpl deviceImpl, Handler deviceStateHandler, boolean configureSuccess) {
        this.mClosed = false;
        this.mSkipUnconfigure = false;
        if (outputs == null || outputs.isEmpty()) {
            throw new IllegalArgumentException("outputs must be a non-null, non-empty list");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.mId = id2;
        this.mIdString = String.format("Session %d: ", this.mId);
        this.mOutputs = outputs;
        this.mInput = input;
        this.mStateHandler = CameraDeviceImpl.checkHandler(stateHandler);
        this.mStateCallback = this.createUserStateCallbackProxy(this.mStateHandler, callback);
        this.mDeviceHandler = Preconditions.checkNotNull(deviceStateHandler, "deviceStateHandler must not be null");
        this.mDeviceImpl = Preconditions.checkNotNull(deviceImpl, "deviceImpl must not be null");
        this.mSequenceDrainer = new TaskDrainer(this.mDeviceHandler, new SequenceDrainListener(this), "seq");
        this.mIdleDrainer = new TaskSingleDrainer(this.mDeviceHandler, new IdleDrainListener(this), "idle");
        this.mAbortDrainer = new TaskSingleDrainer(this.mDeviceHandler, new AbortDrainListener(this), "abort");
        if (configureSuccess) {
            this.mStateCallback.onConfigured(this);
            this.mConfigureSuccess = true;
        } else {
            this.mStateCallback.onConfigureFailed(this);
            this.mClosed = true;
            Log.e("CameraCaptureSession", this.mIdString + "Failed to create capture session; configuration failed");
            this.mConfigureSuccess = false;
        }
    }

    private final CameraDevice $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDevice() {
        return this.mDeviceImpl;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(Surface surface) throws CameraAccessException {
        this.mDeviceImpl.prepare(surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(int maxCount, Surface surface) throws CameraAccessException {
        this.mDeviceImpl.prepare(maxCount, surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$tearDown(Surface surface) throws CameraAccessException {
        this.mDeviceImpl.tearDown(surface);
    }

    private final synchronized int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$capture(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isReprocess() && !this.isReprocessable()) {
            throw new IllegalArgumentException("this capture session cannot handle reprocess requests");
        }
        if (request.isReprocess() && request.getReprocessableSessionId() != this.mId) {
            throw new IllegalArgumentException("capture request was created for another session");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.capture(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    private final synchronized int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null) {
            throw new IllegalArgumentException("Requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("Requests must have at least one element");
        }
        for (CaptureRequest request : requests) {
            if (!request.isReprocess()) continue;
            if (!this.isReprocessable()) {
                throw new IllegalArgumentException("This capture session cannot handle reprocess requests");
            }
            if (request.getReprocessableSessionId() == this.mId) continue;
            throw new IllegalArgumentException("Capture request was created for another session");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.captureBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    private final synchronized int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isReprocess()) {
            throw new IllegalArgumentException("repeating reprocess requests are not supported");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    private final synchronized int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("requests must have at least one element");
        }
        for (CaptureRequest r : requests) {
            if (!r.isReprocess()) continue;
            throw new IllegalArgumentException("repeating reprocess burst requests are not supported");
        }
        this.checkNotClosed();
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceHandler));
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$stopRepeating() throws CameraAccessException {
        this.checkNotClosed();
        this.mDeviceImpl.stopRepeating();
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$abortCaptures() throws CameraAccessException {
        this.checkNotClosed();
        if (this.mAborting) {
            Log.w("CameraCaptureSession", this.mIdString + "abortCaptures - Session is already aborting; doing nothing");
            return;
        }
        this.mAborting = true;
        this.mAbortDrainer.taskStarted();
        this.mDeviceImpl.flush();
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isReprocessable() {
        return this.mInput != null;
    }

    private final Surface $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getInputSurface() {
        return this.mInput;
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$replaceSessionClose() {
        this.mSkipUnconfigure = true;
        this.close();
    }

    private final synchronized void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$close() {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            this.mDeviceImpl.stopRepeating();
        }
        catch (IllegalStateException e) {
            this.mStateCallback.onClosed(this);
            return;
        }
        catch (CameraAccessException e) {
            Log.e("CameraCaptureSession", this.mIdString + "Exception while stopping repeating: ", e);
        }
        this.mSequenceDrainer.beginDrain();
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isAborting() {
        return this.mAborting;
    }

    private final CameraCaptureSession.StateCallback $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createUserStateCallbackProxy(Handler handler, CameraCaptureSession.StateCallback callback) {
        InvokeDispatcher<CameraCaptureSession.StateCallback> userCallbackSink = new InvokeDispatcher<CameraCaptureSession.StateCallback>(callback);
        HandlerDispatcher<CameraCaptureSession.StateCallback> handlerPassthrough = new HandlerDispatcher<CameraCaptureSession.StateCallback>(userCallbackSink, handler);
        return new CallbackProxies.SessionStateCallbackProxy(handlerPassthrough);
    }

    private final CameraDeviceImpl.CaptureCallback $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback callback) {
        ShadowedObject localCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraCaptureSessionImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$__constructor__(CameraCaptureSessionImpl this$0) {
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
                this.this$0.finishPendingSequence(sequenceId);
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
                this.this$0.finishPendingSequence(sequenceId);
            }

            private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$__constructor__(cameraCaptureSessionImpl);
            }
            {
                this.this$0 = cameraCaptureSessionImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
            }

            @Override
            public void onCaptureSequenceCompleted(CameraDevice cameraDevice, int n, long l) {
                InvokeDynamicSupport.bootstrap("onCaptureSequenceCompleted", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceCompleted(android.hardware.camera2.CameraDevice int long ), 0, this, cameraDevice, n, l);
            }

            @Override
            public void onCaptureSequenceAborted(CameraDevice cameraDevice, int n) {
                InvokeDynamicSupport.bootstrap("onCaptureSequenceAborted", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceAborted(android.hardware.camera2.CameraDevice int ), 0, this, cameraDevice, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (callback == null) {
            return localCallback;
        }
        InvokeDispatcher<1> localSink = new InvokeDispatcher<1>(localCallback);
        InvokeDispatcher<CameraCaptureSession.CaptureCallback> userCallbackSink = new InvokeDispatcher<CameraCaptureSession.CaptureCallback>(callback);
        HandlerDispatcher<CameraCaptureSession.CaptureCallback> handlerPassthrough = new HandlerDispatcher<CameraCaptureSession.CaptureCallback>(userCallbackSink, handler);
        DuckTypingDispatcher duckToSession = new DuckTypingDispatcher(handlerPassthrough, CameraCaptureSession.CaptureCallback.class);
        ArgumentReplacingDispatcher replaceDeviceWithSession = new ArgumentReplacingDispatcher(duckToSession, 0, this);
        BroadcastDispatcher<CameraDeviceImpl.CaptureCallback> broadcaster = new BroadcastDispatcher<CameraDeviceImpl.CaptureCallback>(replaceDeviceWithSession, localSink);
        return new CallbackProxies.DeviceCaptureCallbackProxy(broadcaster);
    }

    private final CameraDeviceImpl.StateCallbackKK $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDeviceStateCallback() {
        CameraCaptureSessionImpl session = this;
        return new ShadowedObject(this, session){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mBusy;
            private boolean mActive;
            /* synthetic */ CameraCaptureSession val$session;
            /* synthetic */ CameraCaptureSessionImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$__constructor__(CameraCaptureSessionImpl this$0, CameraCaptureSession cameraCaptureSession) {
                this.mBusy = false;
                this.mActive = false;
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onOpened(CameraDevice camera) {
                throw new AssertionError((Object)"Camera must already be open before creating a session");
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onDisconnected(CameraDevice camera) {
                this.this$0.close();
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onError(CameraDevice camera, int error) {
                Log.wtf("CameraCaptureSession", this.this$0.mIdString + "Got device error " + error);
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onActive(CameraDevice camera) {
                this.this$0.mIdleDrainer.taskStarted();
                this.mActive = true;
                this.this$0.mStateCallback.onActive(this.val$session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onIdle(CameraDevice camera) {
                boolean isAborting;
                CameraCaptureSession cameraCaptureSession = this.val$session;
                synchronized (cameraCaptureSession) {
                    isAborting = this.this$0.mAborting;
                }
                if (this.mBusy && isAborting) {
                    this.this$0.mAbortDrainer.taskFinished();
                    cameraCaptureSession = this.val$session;
                    synchronized (cameraCaptureSession) {
                        this.this$0.mAborting = false;
                    }
                }
                if (this.mActive) {
                    this.this$0.mIdleDrainer.taskFinished();
                }
                this.mBusy = false;
                this.mActive = false;
                this.this$0.mStateCallback.onReady(this.val$session);
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onBusy(CameraDevice camera) {
                this.mBusy = true;
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onUnconfigured(CameraDevice camera) {
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onSurfacePrepared(Surface surface) {
                this.this$0.mStateCallback.onSurfacePrepared(this.val$session, surface);
            }

            private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, CameraCaptureSession cameraCaptureSession) {
                this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$__constructor__(cameraCaptureSessionImpl, cameraCaptureSession);
            }
            {
                this.this$0 = cameraCaptureSessionImpl;
                this.val$session = cameraCaptureSession;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl android.hardware.camera2.CameraCaptureSession ), 0, this, cameraCaptureSessionImpl, cameraCaptureSession);
            }

            @Override
            public void onOpened(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onOpened", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onOpened(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onDisconnected(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onDisconnected(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onError(CameraDevice cameraDevice, int n) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onError(android.hardware.camera2.CameraDevice int ), 0, this, cameraDevice, n);
            }

            @Override
            public void onActive(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onActive", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onActive(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onIdle(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onIdle", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onIdle(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onBusy(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onBusy", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onBusy(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onUnconfigured(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onUnconfigured", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onUnconfigured(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onSurfacePrepared(Surface surface) {
                InvokeDynamicSupport.bootstrap("onSurfacePrepared", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onSurfacePrepared(android.view.Surface ), 0, this, surface);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Session has been closed; further changes are illegal.");
        }
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$addPendingSequence(int sequenceId) {
        this.mSequenceDrainer.taskStarted(sequenceId);
        return sequenceId;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finishPendingSequence(int sequenceId) {
        try {
            this.mSequenceDrainer.taskFinished(sequenceId);
        }
        catch (IllegalStateException e) {
            Log.w("CameraCaptureSession", e.getMessage());
        }
    }

    private void __constructor__(int n, Surface surface, List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler, CameraDeviceImpl cameraDeviceImpl, Handler handler2, boolean bl) {
        this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$__constructor__(n, surface, list, stateCallback, handler, cameraDeviceImpl, handler2, bl);
    }

    CameraCaptureSessionImpl(int n, Surface surface, List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler, CameraDeviceImpl cameraDeviceImpl, Handler handler2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$__constructor__(int android.view.Surface java.util.List<android.view.Surface> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler android.hardware.camera2.impl.CameraDeviceImpl android.os.Handler boolean ), 0, this, n, surface, list, stateCallback, handler, cameraDeviceImpl, handler2, bl);
    }

    @Override
    public CameraDevice getDevice() {
        return InvokeDynamicSupport.bootstrap("getDevice", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDevice(), 0, this);
    }

    @Override
    public void prepare(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(android.view.Surface ), 0, this, surface);
    }

    @Override
    public void prepare(int n, Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(int android.view.Surface ), 0, this, n, surface);
    }

    @Override
    public void tearDown(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$tearDown(android.view.Surface ), 0, this, surface);
    }

    @Override
    public synchronized int capture(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("capture", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$capture(android.hardware.camera2.CaptureRequest android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    @Override
    public synchronized int captureBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureBurst", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    @Override
    public synchronized int setRepeatingRequest(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingRequest(android.hardware.camera2.CaptureRequest android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    @Override
    public synchronized int setRepeatingBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingBurst", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    @Override
    public synchronized void stopRepeating() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$stopRepeating(), 0, this);
    }

    @Override
    public synchronized void abortCaptures() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("abortCaptures", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$abortCaptures(), 0, this);
    }

    @Override
    public boolean isReprocessable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReprocessable", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isReprocessable(), 0, this);
    }

    @Override
    public Surface getInputSurface() {
        return InvokeDynamicSupport.bootstrap("getInputSurface", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getInputSurface(), 0, this);
    }

    @Override
    public synchronized void replaceSessionClose() {
        InvokeDynamicSupport.bootstrap("replaceSessionClose", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$replaceSessionClose(), 0, this);
    }

    @Override
    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$close(), 0, this);
    }

    @Override
    public boolean isAborting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAborting", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isAborting(), 0, this);
    }

    private CameraCaptureSession.StateCallback createUserStateCallbackProxy(Handler handler, CameraCaptureSession.StateCallback stateCallback) {
        return InvokeDynamicSupport.bootstrap("createUserStateCallbackProxy", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createUserStateCallbackProxy(android.os.Handler android.hardware.camera2.CameraCaptureSession$StateCallback ), 0, this, handler, stateCallback);
    }

    private CameraDeviceImpl.CaptureCallback createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback captureCallback) {
        return InvokeDynamicSupport.bootstrap("createCaptureCallbackProxy", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createCaptureCallbackProxy(android.os.Handler android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, handler, captureCallback);
    }

    @Override
    public CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        return InvokeDynamicSupport.bootstrap("getDeviceStateCallback", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDeviceStateCallback(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finalize(), 0, this);
    }

    private void checkNotClosed() {
        InvokeDynamicSupport.bootstrap("checkNotClosed", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkNotClosed(), 0, this);
    }

    private int addPendingSequence(int n) {
        return (int)InvokeDynamicSupport.bootstrap("addPendingSequence", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$addPendingSequence(int ), 0, this, n);
    }

    private void finishPendingSequence(int n) {
        InvokeDynamicSupport.bootstrap("finishPendingSequence", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finishPendingSequence(int ), 0, this, n);
    }

    public /* synthetic */ CameraCaptureSessionImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraCaptureSessionImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IdleDrainListener
    implements TaskDrainer.DrainListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$onDrained() {
            Object object = ((CameraCaptureSessionImpl)this.this$0).mDeviceImpl.mInterfaceLock;
            synchronized (object) {
                CameraCaptureSessionImpl cameraCaptureSessionImpl = this.this$0;
                synchronized (cameraCaptureSessionImpl) {
                    if (this.this$0.mSkipUnconfigure) {
                        return;
                    }
                    try {
                        this.this$0.mDeviceImpl.configureStreamsChecked(null, null, false);
                    }
                    catch (CameraAccessException e) {
                        Log.e("CameraCaptureSession", this.this$0.mIdString + "Exception while unconfiguring outputs: ", e);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(CameraCaptureSessionImpl x0, 1 x1) {
        }

        private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(cameraCaptureSessionImpl);
        }

        private IdleDrainListener(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.this$0 = cameraCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
        }

        @Override
        public void onDrained() {
            InvokeDynamicSupport.bootstrap("onDrained", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$onDrained(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(cameraCaptureSessionImpl, var2_2);
        }

        public /* synthetic */ IdleDrainListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleDrainListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AbortDrainListener
    implements TaskDrainer.DrainListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$onDrained() {
            CameraCaptureSessionImpl cameraCaptureSessionImpl = this.this$0;
            synchronized (cameraCaptureSessionImpl) {
                if (this.this$0.mSkipUnconfigure) {
                    return;
                }
                this.this$0.mIdleDrainer.beginDrain();
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(CameraCaptureSessionImpl x0, 1 x1) {
        }

        private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(cameraCaptureSessionImpl);
        }

        private AbortDrainListener(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.this$0 = cameraCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
        }

        @Override
        public void onDrained() {
            InvokeDynamicSupport.bootstrap("onDrained", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$onDrained(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(cameraCaptureSessionImpl, var2_2);
        }

        public /* synthetic */ AbortDrainListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbortDrainListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SequenceDrainListener
    implements TaskDrainer.DrainListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$onDrained() {
            this.this$0.mStateCallback.onClosed(this.this$0);
            if (this.this$0.mSkipUnconfigure) {
                return;
            }
            this.this$0.mAbortDrainer.beginDrain();
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(CameraCaptureSessionImpl x0, 1 x1) {
        }

        private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(cameraCaptureSessionImpl);
        }

        private SequenceDrainListener(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.this$0 = cameraCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
        }

        @Override
        public void onDrained() {
            InvokeDynamicSupport.bootstrap("onDrained", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$onDrained(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(cameraCaptureSessionImpl, var2_2);
        }

        public /* synthetic */ SequenceDrainListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SequenceDrainListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

