/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class PdfEditor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CloseGuard mCloseGuard;
    private long mNativeDocument;
    private int mPageCount;
    private ParcelFileDescriptor mInput;

    private void $$robo$$android_graphics_pdf_PdfEditor$__constructor__(ParcelFileDescriptor input) throws IOException {
        long size;
        this.mCloseGuard = CloseGuard.get();
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Libcore.os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        this.mNativeDocument = PdfEditor.nativeOpen(this.mInput.getFd(), size);
        this.mPageCount = PdfEditor.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    private final int $$robo$$android_graphics_pdf_PdfEditor$getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$removePage(int pageIndex) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.mPageCount = PdfEditor.nativeRemovePage(this.mNativeDocument, pageIndex);
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$setTransformAndClip(int pageIndex, Matrix transform, Rect clip) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.throwIfNotNullAndNotAfine(transform);
        if (transform == null) {
            transform = Matrix.IDENTITY_MATRIX;
        }
        if (clip == null) {
            Point size = new Point();
            this.getPageSize(pageIndex, size);
            PdfEditor.nativeSetTransformAndClip(this.mNativeDocument, pageIndex, transform.native_instance, 0, 0, size.x, size.y);
        } else {
            PdfEditor.nativeSetTransformAndClip(this.mNativeDocument, pageIndex, transform.native_instance, clip.left, clip.top, clip.right, clip.bottom);
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$getPageSize(int pageIndex, Point outSize) {
        this.throwIfClosed();
        this.throwIfOutSizeNull(outSize);
        this.throwIfPageNotInDocument(pageIndex);
        PdfEditor.nativeGetPageSize(this.mNativeDocument, pageIndex, outSize);
    }

    private final boolean $$robo$$android_graphics_pdf_PdfEditor$getPageMediaBox(int pageIndex, Rect outMediaBox) {
        this.throwIfClosed();
        this.throwIfOutMediaBoxNull(outMediaBox);
        this.throwIfPageNotInDocument(pageIndex);
        return PdfEditor.nativeGetPageMediaBox(this.mNativeDocument, pageIndex, outMediaBox);
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$setPageMediaBox(int pageIndex, Rect mediaBox) {
        this.throwIfClosed();
        this.throwIfMediaBoxNull(mediaBox);
        this.throwIfPageNotInDocument(pageIndex);
        PdfEditor.nativeSetPageMediaBox(this.mNativeDocument, pageIndex, mediaBox);
    }

    private final boolean $$robo$$android_graphics_pdf_PdfEditor$getPageCropBox(int pageIndex, Rect outCropBox) {
        this.throwIfClosed();
        this.throwIfOutCropBoxNull(outCropBox);
        this.throwIfPageNotInDocument(pageIndex);
        return PdfEditor.nativeGetPageCropBox(this.mNativeDocument, pageIndex, outCropBox);
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$setPageCropBox(int pageIndex, Rect cropBox) {
        this.throwIfClosed();
        this.throwIfCropBoxNull(cropBox);
        this.throwIfPageNotInDocument(pageIndex);
        PdfEditor.nativeSetPageCropBox(this.mNativeDocument, pageIndex, cropBox);
    }

    private final boolean $$robo$$android_graphics_pdf_PdfEditor$shouldScaleForPrinting() {
        this.throwIfClosed();
        return PdfEditor.nativeScaleForPrinting(this.mNativeDocument);
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$write(ParcelFileDescriptor output) throws IOException {
        try {
            this.throwIfClosed();
            PdfEditor.nativeWrite(this.mNativeDocument, output.getFd());
        }
        finally {
            IoUtils.closeQuietly(output);
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$close() {
        this.throwIfClosed();
        this.doClose();
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$doClose() {
        PdfEditor.nativeClose(this.mNativeDocument);
        IoUtils.closeQuietly(this.mInput);
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfNotNullAndNotAfine(Matrix matrix) {
        if (matrix != null && !matrix.isAffine()) {
            throw new IllegalStateException("Matrix must be afine");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfOutSizeNull(Point outSize) {
        if (outSize == null) {
            throw new NullPointerException("outSize cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfOutMediaBoxNull(Rect outMediaBox) {
        if (outMediaBox == null) {
            throw new NullPointerException("outMediaBox cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfMediaBoxNull(Rect mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfOutCropBoxNull(Rect outCropBox) {
        if (outCropBox == null) {
            throw new NullPointerException("outCropBox cannot be null");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfCropBoxNull(Rect cropBox) {
        if (cropBox == null) {
            throw new NullPointerException("cropBox cannot be null");
        }
    }

    private static final long $$robo$$android_graphics_pdf_PdfEditor$nativeOpen(int n, long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeClose(long l) {
    }

    private static final int $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCount(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_pdf_PdfEditor$nativeRemovePage(long l, int n) {
        return 0;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeWrite(long l, int n) {
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeSetTransformAndClip(long l, int n, long l2, int n2, int n3, int n4, int n5) {
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageSize(long l, int n, Point point) {
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageMediaBox(long l, int n, Rect rect) {
        return false;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageMediaBox(long l, int n, Rect rect) {
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCropBox(long l, int n, Rect rect) {
        return false;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageCropBox(long l, int n, Rect rect) {
    }

    private static final boolean $$robo$$android_graphics_pdf_PdfEditor$nativeScaleForPrinting(long l) {
        return false;
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$$android_graphics_pdf_PdfEditor$__constructor__(parcelFileDescriptor);
    }

    public PdfEditor(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfEditor$__constructor__(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    public int getPageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPageCount", $$robo$$android_graphics_pdf_PdfEditor$getPageCount(), 0, this);
    }

    public void removePage(int n) {
        InvokeDynamicSupport.bootstrap("removePage", $$robo$$android_graphics_pdf_PdfEditor$removePage(int ), 0, this, n);
    }

    public void setTransformAndClip(int n, Matrix matrix, Rect rect) {
        InvokeDynamicSupport.bootstrap("setTransformAndClip", $$robo$$android_graphics_pdf_PdfEditor$setTransformAndClip(int android.graphics.Matrix android.graphics.Rect ), 0, this, n, matrix, rect);
    }

    public void getPageSize(int n, Point point) {
        InvokeDynamicSupport.bootstrap("getPageSize", $$robo$$android_graphics_pdf_PdfEditor$getPageSize(int android.graphics.Point ), 0, this, n, point);
    }

    public boolean getPageMediaBox(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$getPageMediaBox(int android.graphics.Rect ), 0, this, n, rect);
    }

    public void setPageMediaBox(int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("setPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$setPageMediaBox(int android.graphics.Rect ), 0, this, n, rect);
    }

    public boolean getPageCropBox(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$getPageCropBox(int android.graphics.Rect ), 0, this, n, rect);
    }

    public void setPageCropBox(int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("setPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$setPageCropBox(int android.graphics.Rect ), 0, this, n, rect);
    }

    public boolean shouldScaleForPrinting() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldScaleForPrinting", $$robo$$android_graphics_pdf_PdfEditor$shouldScaleForPrinting(), 0, this);
    }

    public void write(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_graphics_pdf_PdfEditor$write(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_pdf_PdfEditor$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_pdf_PdfEditor$finalize(), 0, this);
    }

    private void doClose() {
        InvokeDynamicSupport.bootstrap("doClose", $$robo$$android_graphics_pdf_PdfEditor$doClose(), 0, this);
    }

    private void throwIfClosed() {
        InvokeDynamicSupport.bootstrap("throwIfClosed", $$robo$$android_graphics_pdf_PdfEditor$throwIfClosed(), 0, this);
    }

    private void throwIfPageNotInDocument(int n) {
        InvokeDynamicSupport.bootstrap("throwIfPageNotInDocument", $$robo$$android_graphics_pdf_PdfEditor$throwIfPageNotInDocument(int ), 0, this, n);
    }

    private void throwIfNotNullAndNotAfine(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("throwIfNotNullAndNotAfine", $$robo$$android_graphics_pdf_PdfEditor$throwIfNotNullAndNotAfine(android.graphics.Matrix ), 0, this, matrix);
    }

    private void throwIfOutSizeNull(Point point) {
        InvokeDynamicSupport.bootstrap("throwIfOutSizeNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfOutSizeNull(android.graphics.Point ), 0, this, point);
    }

    private void throwIfOutMediaBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfOutMediaBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfOutMediaBoxNull(android.graphics.Rect ), 0, this, rect);
    }

    private void throwIfMediaBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfMediaBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfMediaBoxNull(android.graphics.Rect ), 0, this, rect);
    }

    private void throwIfOutCropBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfOutCropBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfOutCropBoxNull(android.graphics.Rect ), 0, this, rect);
    }

    private void throwIfCropBoxNull(Rect rect) {
        InvokeDynamicSupport.bootstrap("throwIfCropBoxNull", $$robo$$android_graphics_pdf_PdfEditor$throwIfCropBoxNull(android.graphics.Rect ), 0, this, rect);
    }

    private static final native /* synthetic */ long $$robo$$nativeOpen$nativeBinding(int var0, long var1);

    private static long nativeOpen(int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpen", $$robo$$android_graphics_pdf_PdfEditor$nativeOpen(int long ), 1, (int)n, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(long var0);

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$android_graphics_pdf_PdfEditor$nativeClose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetPageCount$nativeBinding(long var0);

    private static int nativeGetPageCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPageCount", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeRemovePage$nativeBinding(long var0, int var2);

    private static int nativeRemovePage(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeRemovePage", $$robo$$android_graphics_pdf_PdfEditor$nativeRemovePage(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeWrite$nativeBinding(long var0, int var2);

    private static void nativeWrite(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeWrite", $$robo$$android_graphics_pdf_PdfEditor$nativeWrite(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetTransformAndClip$nativeBinding(long var0, int var2, long var3, int var5, int var6, int var7, int var8);

    private static void nativeSetTransformAndClip(long l, int n, long l2, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetTransformAndClip", $$robo$$android_graphics_pdf_PdfEditor$nativeSetTransformAndClip(long int long int int int int ), 1, (long)l, (int)n, (long)l2, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    private static final native /* synthetic */ void $$robo$$nativeGetPageSize$nativeBinding(long var0, int var2, Point var3);

    private static void nativeGetPageSize(long l, int n, Point point) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPageSize", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageSize(long int android.graphics.Point ), 1, (long)l, (int)n, (Point)point);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeGetPageMediaBox$nativeBinding(long var0, int var2, Rect var3);

    private static boolean nativeGetPageMediaBox(long l, int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageMediaBox(long int android.graphics.Rect ), 1, (long)l, (int)n, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetPageMediaBox$nativeBinding(long var0, int var2, Rect var3);

    private static void nativeSetPageMediaBox(long l, int n, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPageMediaBox", $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageMediaBox(long int android.graphics.Rect ), 1, (long)l, (int)n, (Rect)rect);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeGetPageCropBox$nativeBinding(long var0, int var2, Rect var3);

    private static boolean nativeGetPageCropBox(long l, int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCropBox(long int android.graphics.Rect ), 1, (long)l, (int)n, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetPageCropBox$nativeBinding(long var0, int var2, Rect var3);

    private static void nativeSetPageCropBox(long l, int n, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetPageCropBox", $$robo$$android_graphics_pdf_PdfEditor$nativeSetPageCropBox(long int android.graphics.Rect ), 1, (long)l, (int)n, (Rect)rect);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeScaleForPrinting$nativeBinding(long var0);

    private static boolean nativeScaleForPrinting(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeScaleForPrinting", $$robo$$android_graphics_pdf_PdfEditor$nativeScaleForPrinting(long ), 1, (long)l);
    }

    public /* synthetic */ PdfEditor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PdfEditor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

