/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PdfDocument
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] mChunk;
    private CloseGuard mCloseGuard;
    private List<PageInfo> mPages;
    private long mNativeDocument;
    private Page mCurrentPage;

    private void $$robo$$android_graphics_pdf_PdfDocument$__constructor__() {
        this.mChunk = new byte[4096];
        this.mCloseGuard = CloseGuard.get();
        this.mPages = new ArrayList<PageInfo>();
        this.mNativeDocument = this.nativeCreateDocument();
        this.mCloseGuard.open("close");
    }

    private final Page $$robo$$android_graphics_pdf_PdfDocument$startPage(PageInfo pageInfo) {
        this.throwIfClosed();
        this.throwIfCurrentPageNotFinished();
        if (pageInfo == null) {
            throw new IllegalArgumentException("page cannot be null");
        }
        PdfCanvas canvas = new PdfCanvas(this, PdfDocument.nativeStartPage(this.mNativeDocument, pageInfo.mPageWidth, pageInfo.mPageHeight, ((PageInfo)pageInfo).mContentRect.left, ((PageInfo)pageInfo).mContentRect.top, ((PageInfo)pageInfo).mContentRect.right, ((PageInfo)pageInfo).mContentRect.bottom));
        this.mCurrentPage = new Page(canvas, pageInfo);
        return this.mCurrentPage;
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$finishPage(Page page) {
        this.throwIfClosed();
        if (page == null) {
            throw new IllegalArgumentException("page cannot be null");
        }
        if (page != this.mCurrentPage) {
            throw new IllegalStateException("invalid page");
        }
        if (page.isFinished()) {
            throw new IllegalStateException("page already finished");
        }
        this.mPages.add(page.getInfo());
        this.mCurrentPage = null;
        this.nativeFinishPage(this.mNativeDocument);
        page.finish();
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$writeTo(OutputStream out) throws IOException {
        this.throwIfClosed();
        this.throwIfCurrentPageNotFinished();
        if (out == null) {
            throw new IllegalArgumentException("out cannot be null!");
        }
        this.nativeWriteTo(this.mNativeDocument, out, this.mChunk);
    }

    private final List<PageInfo> $$robo$$android_graphics_pdf_PdfDocument$getPages() {
        return Collections.unmodifiableList(this.mPages);
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$close() {
        this.throwIfCurrentPageNotFinished();
        this.dispose();
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$dispose() {
        if (this.mNativeDocument != 0L) {
            this.nativeClose(this.mNativeDocument);
            this.mCloseGuard.close();
            this.mNativeDocument = 0L;
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$throwIfClosed() {
        if (this.mNativeDocument == 0L) {
            throw new IllegalStateException("document is closed!");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$throwIfCurrentPageNotFinished() {
        if (this.mCurrentPage != null) {
            throw new IllegalStateException("Current page not finished!");
        }
    }

    private final long $$robo$$android_graphics_pdf_PdfDocument$nativeCreateDocument() {
        return 0L;
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$nativeClose(long l) {
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$nativeFinishPage(long l) {
    }

    private final void $$robo$$android_graphics_pdf_PdfDocument$nativeWriteTo(long l, OutputStream outputStream, byte[] byArray) {
    }

    private static final long $$robo$$android_graphics_pdf_PdfDocument$nativeStartPage(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        return 0L;
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_pdf_PdfDocument$__constructor__();
    }

    public PdfDocument() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfDocument$__constructor__(), 0, this);
    }

    public Page startPage(PageInfo pageInfo) {
        return InvokeDynamicSupport.bootstrap("startPage", $$robo$$android_graphics_pdf_PdfDocument$startPage(android.graphics.pdf.PdfDocument$PageInfo ), 0, this, pageInfo);
    }

    public void finishPage(Page page) {
        InvokeDynamicSupport.bootstrap("finishPage", $$robo$$android_graphics_pdf_PdfDocument$finishPage(android.graphics.pdf.PdfDocument$Page ), 0, this, page);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeTo", $$robo$$android_graphics_pdf_PdfDocument$writeTo(java.io.OutputStream ), 0, this, outputStream);
    }

    public List<PageInfo> getPages() {
        return InvokeDynamicSupport.bootstrap("getPages", $$robo$$android_graphics_pdf_PdfDocument$getPages(), 0, this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_pdf_PdfDocument$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_pdf_PdfDocument$finalize(), 0, this);
    }

    private void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_graphics_pdf_PdfDocument$dispose(), 0, this);
    }

    private void throwIfClosed() {
        InvokeDynamicSupport.bootstrap("throwIfClosed", $$robo$$android_graphics_pdf_PdfDocument$throwIfClosed(), 0, this);
    }

    private void throwIfCurrentPageNotFinished() {
        InvokeDynamicSupport.bootstrap("throwIfCurrentPageNotFinished", $$robo$$android_graphics_pdf_PdfDocument$throwIfCurrentPageNotFinished(), 0, this);
    }

    private final native /* synthetic */ long $$robo$$nativeCreateDocument$nativeBinding();

    private long nativeCreateDocument() {
        return (long)InvokeDynamicSupport.bootstrap("nativeCreateDocument", $$robo$$android_graphics_pdf_PdfDocument$nativeCreateDocument(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(long var1);

    private void nativeClose(long l) {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_graphics_pdf_PdfDocument$nativeClose(long ), 1, this, l);
    }

    private final native /* synthetic */ void $$robo$$nativeFinishPage$nativeBinding(long var1);

    private void nativeFinishPage(long l) {
        InvokeDynamicSupport.bootstrap("nativeFinishPage", $$robo$$android_graphics_pdf_PdfDocument$nativeFinishPage(long ), 1, this, l);
    }

    private final native /* synthetic */ void $$robo$$nativeWriteTo$nativeBinding(long var1, OutputStream var3, byte[] var4);

    private void nativeWriteTo(long l, OutputStream outputStream, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("nativeWriteTo", $$robo$$android_graphics_pdf_PdfDocument$nativeWriteTo(long java.io.OutputStream byte[] ), 1, this, l, outputStream, byArray);
    }

    private static final native /* synthetic */ long $$robo$$nativeStartPage$nativeBinding(long var0, int var2, int var3, int var4, int var5, int var6, int var7);

    private static long nativeStartPage(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeStartPage", $$robo$$android_graphics_pdf_PdfDocument$nativeStartPage(long int int int int int int ), 1, (long)l, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PdfDocument)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Page
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PageInfo mPageInfo;
        private Canvas mCanvas;

        private void $$robo$$android_graphics_pdf_PdfDocument_Page$__constructor__(Canvas canvas, PageInfo pageInfo) {
            this.mCanvas = canvas;
            this.mPageInfo = pageInfo;
        }

        private final Canvas $$robo$$android_graphics_pdf_PdfDocument_Page$getCanvas() {
            return this.mCanvas;
        }

        private final PageInfo $$robo$$android_graphics_pdf_PdfDocument_Page$getInfo() {
            return this.mPageInfo;
        }

        private final boolean $$robo$$android_graphics_pdf_PdfDocument_Page$isFinished() {
            return this.mCanvas == null;
        }

        private final void $$robo$$android_graphics_pdf_PdfDocument_Page$finish() {
            if (this.mCanvas != null) {
                this.mCanvas.release();
                this.mCanvas = null;
            }
        }

        private /* synthetic */ void $$robo$$android_graphics_pdf_PdfDocument_Page$__constructor__(Canvas x0, PageInfo x1, 1 x2) {
        }

        private void __constructor__(Canvas canvas, PageInfo pageInfo) {
            this.$$robo$$android_graphics_pdf_PdfDocument_Page$__constructor__(canvas, pageInfo);
        }

        private Page(Canvas canvas, PageInfo pageInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfDocument_Page$__constructor__(android.graphics.Canvas android.graphics.pdf.PdfDocument$PageInfo ), 0, this, canvas, pageInfo);
        }

        public Canvas getCanvas() {
            return InvokeDynamicSupport.bootstrap("getCanvas", $$robo$$android_graphics_pdf_PdfDocument_Page$getCanvas(), 0, this);
        }

        public PageInfo getInfo() {
            return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$android_graphics_pdf_PdfDocument_Page$getInfo(), 0, this);
        }

        boolean isFinished() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFinished", $$robo$$android_graphics_pdf_PdfDocument_Page$isFinished(), 0, this);
        }

        private void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_graphics_pdf_PdfDocument_Page$finish(), 0, this);
        }

        private /* synthetic */ void __constructor__(Canvas canvas, PageInfo pageInfo, 1 var3_3) {
            this.$$robo$$android_graphics_pdf_PdfDocument_Page$__constructor__(canvas, pageInfo, var3_3);
        }

        public /* synthetic */ Page() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Page)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PageInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mPageWidth;
        private int mPageHeight;
        private Rect mContentRect;
        private int mPageNumber;

        private void $$robo$$android_graphics_pdf_PdfDocument_PageInfo$__constructor__() {
        }

        private final int $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getPageWidth() {
            return this.mPageWidth;
        }

        private final int $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getPageHeight() {
            return this.mPageHeight;
        }

        private final Rect $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getContentRect() {
            return this.mContentRect;
        }

        private final int $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getPageNumber() {
            return this.mPageNumber;
        }

        private /* synthetic */ void $$robo$$android_graphics_pdf_PdfDocument_PageInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_pdf_PdfDocument_PageInfo$__constructor__();
        }

        private PageInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfDocument_PageInfo$__constructor__(), 0, this);
        }

        public int getPageWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getPageWidth", $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getPageWidth(), 0, this);
        }

        public int getPageHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getPageHeight", $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getPageHeight(), 0, this);
        }

        public Rect getContentRect() {
            return InvokeDynamicSupport.bootstrap("getContentRect", $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getContentRect(), 0, this);
        }

        public int getPageNumber() {
            return (int)InvokeDynamicSupport.bootstrap("getPageNumber", $$robo$$android_graphics_pdf_PdfDocument_PageInfo$getPageNumber(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_pdf_PdfDocument_PageInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PageInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private PageInfo mPageInfo;

            private void $$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$__constructor__(int pageWidth, int pageHeight, int pageNumber) {
                this.mPageInfo = new PageInfo();
                if (pageWidth <= 0) {
                    throw new IllegalArgumentException("page width must be positive");
                }
                if (pageHeight <= 0) {
                    throw new IllegalArgumentException("page width must be positive");
                }
                if (pageNumber < 0) {
                    throw new IllegalArgumentException("pageNumber must be non negative");
                }
                this.mPageInfo.mPageWidth = pageWidth;
                this.mPageInfo.mPageHeight = pageHeight;
                this.mPageInfo.mPageNumber = pageNumber;
            }

            private final Builder $$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$setContentRect(Rect contentRect) {
                if (contentRect != null && (contentRect.left < 0 || contentRect.top < 0 || contentRect.right > this.mPageInfo.mPageWidth || contentRect.bottom > this.mPageInfo.mPageHeight)) {
                    throw new IllegalArgumentException("contentRect does not fit the page");
                }
                this.mPageInfo.mContentRect = contentRect;
                return this;
            }

            private final PageInfo $$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$create() {
                if (this.mPageInfo.mContentRect == null) {
                    this.mPageInfo.mContentRect = new Rect(0, 0, this.mPageInfo.mPageWidth, this.mPageInfo.mPageHeight);
                }
                return this.mPageInfo;
            }

            private void __constructor__(int n, int n2, int n3) {
                this.$$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$__constructor__(n, n2, n3);
            }

            public Builder(int n, int n2, int n3) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$__constructor__(int int int ), 0, this, n, n2, n3);
            }

            public Builder setContentRect(Rect rect) {
                return InvokeDynamicSupport.bootstrap("setContentRect", $$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$setContentRect(android.graphics.Rect ), 0, this, rect);
            }

            public PageInfo create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_graphics_pdf_PdfDocument_PageInfo_Builder$create(), 0, this);
            }

            public /* synthetic */ Builder() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class PdfCanvas
    extends Canvas
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ PdfDocument this$0;

        private void $$robo$$android_graphics_pdf_PdfDocument_PdfCanvas$__constructor__(PdfDocument pdfDocument, long nativeCanvas) {
        }

        private final void $$robo$$android_graphics_pdf_PdfDocument_PdfCanvas$setBitmap(Bitmap bitmap) {
            throw new UnsupportedOperationException();
        }

        private void __constructor__(PdfDocument pdfDocument, long l) {
            this.$$robo$$android_graphics_pdf_PdfDocument_PdfCanvas$__constructor__(pdfDocument, l);
        }

        public PdfCanvas(PdfDocument pdfDocument, long l) {
            this.this$0 = pdfDocument;
            super(l);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfDocument_PdfCanvas$__constructor__(android.graphics.pdf.PdfDocument long ), 0, this, pdfDocument, l);
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_graphics_pdf_PdfDocument_PdfCanvas$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public /* synthetic */ PdfCanvas() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PdfCanvas)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

