/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import java.io.IOException;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PADDING_MODE_NEST = 0;
    public static int PADDING_MODE_STACK = 1;
    public static int INSET_UNDEFINED = Integer.MIN_VALUE;
    LayerState mLayerState;
    private int[] mPaddingL;
    private int[] mPaddingT;
    private int[] mPaddingR;
    private int[] mPaddingB;
    private Rect mTmpRect;
    private Rect mTmpOutRect;
    private Rect mTmpContainer;
    private Rect mHotspotBounds;
    private boolean mMutated;
    private boolean mSuspendChildInvalidation;
    private boolean mChildRequestedInvalidation;

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(Drawable[] layers) {
    }

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(Drawable[] layers, LayerState state) {
        if (layers == null) {
            throw new IllegalArgumentException("layers must be non-null");
        }
        int length = layers.length;
        ChildDrawable[] r = new ChildDrawable[length];
        for (int i = 0; i < length; ++i) {
            r[i] = new ChildDrawable(this.mLayerState.mDensity);
            r[i].mDrawable = layers[i];
            layers[i].setCallback(this);
            this.mLayerState.mChildrenChangingConfigurations |= layers[i].getChangingConfigurations();
        }
        this.mLayerState.mNum = length;
        this.mLayerState.mChildren = r;
        this.ensurePadding();
        this.refreshPadding();
    }

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(LayerState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mTmpOutRect = new Rect();
        this.mTmpContainer = new Rect();
        this.mLayerState = this.createConstantState(state, res);
        if (this.mLayerState.mNum > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
    }

    private final LayerState $$robo$$android_graphics_drawable_LayerDrawable$createConstantState(LayerState state, Resources res) {
        return new LayerState(state, this, res);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        int density = Drawable.resolveDensity(r, 0);
        state.setDensity(density);
        TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        ChildDrawable[] array2 = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable layer = array2[i];
            layer.setDensity(density);
        }
        this.inflateLayers(r, parser, attrs, theme);
        this.ensurePadding();
        this.refreshPadding();
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        int density = Drawable.resolveDensity(t.getResources(), 0);
        state.setDensity(density);
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.LayerDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        ChildDrawable[] array2 = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable d;
            ChildDrawable layer = array2[i];
            layer.setDensity(density);
            if (layer.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(layer.mThemeAttrs, R.styleable.LayerDrawableItem);
                this.updateLayerFromTypedArray(layer, a);
                a.recycle();
            }
            if ((d = layer.mDrawable) == null || !d.canApplyTheme()) continue;
            d.applyTheme(t);
            state.mChildrenChangingConfigurations |= d.getChangingConfigurations();
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$inflateLayers(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        LayerState state = this.mLayerState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            ChildDrawable layer = new ChildDrawable(state.mDensity);
            TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawableItem);
            this.updateLayerFromTypedArray(layer, a);
            a.recycle();
            if (layer.mDrawable == null && (layer.mThemeAttrs == null || layer.mThemeAttrs[4] == 0)) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
                }
                layer.mDrawable = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            if (layer.mDrawable != null) {
                state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
                layer.mDrawable.setCallback(this);
            }
            this.addLayer(layer);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$updateStateFromTypedArray(TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        LayerState.access$002(state, a.extractThemeAttrs());
        int N = a.getIndexCount();
        block11: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 4: {
                    state.mOpacityOverride = a.getInt(attr2, state.mOpacityOverride);
                    continue block11;
                }
                case 1: {
                    state.mPaddingTop = a.getDimensionPixelOffset(attr2, state.mPaddingTop);
                    continue block11;
                }
                case 3: {
                    state.mPaddingBottom = a.getDimensionPixelOffset(attr2, state.mPaddingBottom);
                    continue block11;
                }
                case 0: {
                    state.mPaddingLeft = a.getDimensionPixelOffset(attr2, state.mPaddingLeft);
                    continue block11;
                }
                case 2: {
                    state.mPaddingRight = a.getDimensionPixelOffset(attr2, state.mPaddingRight);
                    continue block11;
                }
                case 5: {
                    state.mPaddingStart = a.getDimensionPixelOffset(attr2, state.mPaddingStart);
                    continue block11;
                }
                case 6: {
                    state.mPaddingEnd = a.getDimensionPixelOffset(attr2, state.mPaddingEnd);
                    continue block11;
                }
                case 7: {
                    state.mAutoMirrored = a.getBoolean(attr2, state.mAutoMirrored);
                    continue block11;
                }
                case 8: {
                    state.mPaddingMode = a.getInteger(attr2, state.mPaddingMode);
                }
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$updateLayerFromTypedArray(ChildDrawable layer, TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChildrenChangingConfigurations |= a.getChangingConfigurations();
        layer.mThemeAttrs = a.extractThemeAttrs();
        int N = a.getIndexCount();
        block12: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 5: {
                    layer.mInsetL = a.getDimensionPixelOffset(attr2, layer.mInsetL);
                    continue block12;
                }
                case 6: {
                    layer.mInsetT = a.getDimensionPixelOffset(attr2, layer.mInsetT);
                    continue block12;
                }
                case 7: {
                    layer.mInsetR = a.getDimensionPixelOffset(attr2, layer.mInsetR);
                    continue block12;
                }
                case 8: {
                    layer.mInsetB = a.getDimensionPixelOffset(attr2, layer.mInsetB);
                    continue block12;
                }
                case 9: {
                    layer.mInsetS = a.getDimensionPixelOffset(attr2, layer.mInsetS);
                    continue block12;
                }
                case 10: {
                    layer.mInsetE = a.getDimensionPixelOffset(attr2, layer.mInsetE);
                    continue block12;
                }
                case 3: {
                    layer.mWidth = a.getDimensionPixelSize(attr2, layer.mWidth);
                    continue block12;
                }
                case 2: {
                    layer.mHeight = a.getDimensionPixelSize(attr2, layer.mHeight);
                    continue block12;
                }
                case 0: {
                    layer.mGravity = a.getInteger(attr2, layer.mGravity);
                    continue block12;
                }
                case 1: {
                    layer.mId = a.getResourceId(attr2, layer.mId);
                }
            }
        }
        Drawable dr = a.getDrawable(4);
        if (dr != null) {
            layer.mDrawable = dr;
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$canApplyTheme() {
        return this.mLayerState != null && this.mLayerState.canApplyTheme() || super.canApplyTheme();
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$isProjected() {
        if (super.isProjected()) {
            return true;
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            if (!layers[i].mDrawable.isProjected()) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$addLayer(ChildDrawable layer) {
        LayerState st = this.mLayerState;
        int i = st.mNum;
        int N = st.mChildren != null ? st.mChildren.length : 0;
        if (i >= N) {
            ChildDrawable[] nu = new ChildDrawable[N + 10];
            if (i > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)st.mChildren, (int)0, (Object)nu, (int)0, (int)i);
            }
            st.mChildren = nu;
        }
        st.mChildren[i] = layer;
        ++st.mNum;
        st.invalidateCache();
        return i;
    }

    private final ChildDrawable $$robo$$android_graphics_drawable_LayerDrawable$addLayer(Drawable dr, int[] themeAttrs, int id2, int left, int top, int right, int bottom) {
        ChildDrawable childDrawable = this.createLayer(dr);
        childDrawable.mId = id2;
        childDrawable.mThemeAttrs = themeAttrs;
        childDrawable.mDrawable.setAutoMirrored(this.isAutoMirrored());
        childDrawable.mInsetL = left;
        childDrawable.mInsetT = top;
        childDrawable.mInsetR = right;
        childDrawable.mInsetB = bottom;
        this.addLayer(childDrawable);
        this.mLayerState.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
        dr.setCallback(this);
        return childDrawable;
    }

    private final ChildDrawable $$robo$$android_graphics_drawable_LayerDrawable$createLayer(Drawable dr) {
        ChildDrawable layer = new ChildDrawable(this.mLayerState.mDensity);
        layer.mDrawable = dr;
        return layer;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$addLayer(Drawable dr) {
        ChildDrawable layer = this.createLayer(dr);
        int index = this.addLayer(layer);
        this.ensurePadding();
        this.refreshChildPadding(index, layer);
        return index;
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$findDrawableByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNum - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            return layers[i].mDrawable;
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setId(int index, int id2) {
        this.mLayerState.mChildren[index].mId = id2;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getId(int index) {
        if (index >= this.mLayerState.mNum) {
            throw new IndexOutOfBoundsException();
        }
        return this.mLayerState.mChildren[index].mId;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$setDrawableByLayerId(int id2, Drawable drawable2) {
        int index = this.findIndexByLayerId(id2);
        if (index < 0) {
            return false;
        }
        this.setDrawable(index, drawable2);
        return true;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$findIndexByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable childDrawable = layers[i];
            if (childDrawable.mId != id2) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setDrawable(int index, Drawable drawable2) {
        if (index >= this.mLayerState.mNum) {
            throw new IndexOutOfBoundsException();
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        ChildDrawable childDrawable = layers[index];
        if (childDrawable.mDrawable != null) {
            if (drawable2 != null) {
                Rect bounds = childDrawable.mDrawable.getBounds();
                drawable2.setBounds(bounds);
            }
            childDrawable.mDrawable.setCallback(null);
        }
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
        childDrawable.mDrawable = drawable2;
        this.mLayerState.invalidateCache();
        this.refreshChildPadding(index, childDrawable);
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$getDrawable(int index) {
        if (index >= this.mLayerState.mNum) {
            throw new IndexOutOfBoundsException();
        }
        return this.mLayerState.mChildren[index].mDrawable;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerSize(int index, int w, int h) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mWidth = w;
        childDrawable.mHeight = h;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerWidth(int index, int w) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mWidth = w;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerWidth(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mWidth;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerHeight(int index, int h) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mHeight = h;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerHeight(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mHeight;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerGravity(int index, int gravity) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mGravity = gravity;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerGravity(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mGravity;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInset(int index, int l, int t, int r, int b) {
        this.setLayerInsetInternal(index, l, t, r, b, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetRelative(int index, int s, int t, int e, int b) {
        this.setLayerInsetInternal(index, 0, t, 0, b, s, e);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetLeft(int index, int l) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetLeft(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetL;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetRight(int index, int r) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetR = r;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetRight(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetR;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetTop(int index, int t) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetT = t;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetTop(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetT;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetBottom(int index, int b) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetB = b;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetBottom(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetB;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetStart(int index, int s) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetS = s;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetStart(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetS;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetEnd(int index, int e) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetE = e;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetEnd(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetE;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetInternal(int index, int l, int t, int r, int b, int s, int e) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
        childDrawable.mInsetT = t;
        childDrawable.mInsetR = r;
        childDrawable.mInsetB = b;
        childDrawable.mInsetS = s;
        childDrawable.mInsetE = e;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setPaddingMode(int mode) {
        if (this.mLayerState.mPaddingMode != mode) {
            this.mLayerState.mPaddingMode = mode;
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getPaddingMode() {
        return this.mLayerState.mPaddingMode;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$suspendChildInvalidation() {
        this.mSuspendChildInvalidation = true;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$resumeChildInvalidation() {
        this.mSuspendChildInvalidation = false;
        if (this.mChildRequestedInvalidation) {
            this.mChildRequestedInvalidation = false;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$invalidateDrawable(Drawable who) {
        if (this.mSuspendChildInvalidation) {
            this.mChildRequestedInvalidation = true;
        } else {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$draw(Canvas canvas) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.draw(canvas);
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$getPadding(Rect padding) {
        int paddingR;
        LayerState layerState = this.mLayerState;
        if (layerState.mPaddingMode == 0) {
            this.computeNestedPadding(padding);
        } else {
            this.computeStackedPadding(padding);
        }
        int paddingT = layerState.mPaddingTop;
        int paddingB = layerState.mPaddingBottom;
        boolean isLayoutRtl = this.getLayoutDirection() == 1;
        int paddingRtlL = isLayoutRtl ? layerState.mPaddingEnd : layerState.mPaddingStart;
        int paddingRtlR = isLayoutRtl ? layerState.mPaddingStart : layerState.mPaddingEnd;
        int paddingL = paddingRtlL >= 0 ? paddingRtlL : layerState.mPaddingLeft;
        int n = paddingR = paddingRtlR >= 0 ? paddingRtlR : layerState.mPaddingRight;
        if (paddingL >= 0) {
            padding.left = paddingL;
        }
        if (paddingT >= 0) {
            padding.top = paddingT;
        }
        if (paddingR >= 0) {
            padding.right = paddingR;
        }
        if (paddingB >= 0) {
            padding.bottom = paddingB;
        }
        return padding.left != 0 || padding.top != 0 || padding.right != 0 || padding.bottom != 0;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setPadding(int left, int top, int right, int bottom) {
        LayerState layerState = this.mLayerState;
        layerState.mPaddingLeft = left;
        layerState.mPaddingTop = top;
        layerState.mPaddingRight = right;
        layerState.mPaddingBottom = bottom;
        layerState.mPaddingStart = -1;
        layerState.mPaddingEnd = -1;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setPaddingRelative(int start, int top, int end, int bottom) {
        LayerState layerState = this.mLayerState;
        layerState.mPaddingStart = start;
        layerState.mPaddingTop = top;
        layerState.mPaddingEnd = end;
        layerState.mPaddingBottom = bottom;
        layerState.mPaddingLeft = -1;
        layerState.mPaddingRight = -1;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getLeftPadding() {
        return this.mLayerState.mPaddingLeft;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getRightPadding() {
        return this.mLayerState.mPaddingRight;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getStartPadding() {
        return this.mLayerState.mPaddingStart;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getEndPadding() {
        return this.mLayerState.mPaddingEnd;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getTopPadding() {
        return this.mLayerState.mPaddingTop;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getBottomPadding() {
        return this.mLayerState.mPaddingBottom;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$computeNestedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
            padding.left += this.mPaddingL[i];
            padding.top += this.mPaddingT[i];
            padding.right += this.mPaddingR[i];
            padding.bottom += this.mPaddingB[i];
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$computeStackedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
            padding.left = Math.max(padding.left, this.mPaddingL[i]);
            padding.top = Math.max(padding.top, this.mPaddingT[i]);
            padding.right = Math.max(padding.right, this.mPaddingR[i]);
            padding.bottom = Math.max(padding.bottom, this.mPaddingB[i]);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$getOutline(Outline outline) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setHotspot(float x, float y) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setHotspotBounds(left, top, right, bottom);
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setVisible(visible, restart);
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setDither(boolean dither) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setDither(dither);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setAlpha(int alpha) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setAlpha(alpha);
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getAlpha() {
        Drawable dr = this.getFirstNonNullDrawable();
        if (dr != null) {
            return dr.getAlpha();
        }
        return super.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setColorFilter(ColorFilter colorFilter) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setColorFilter(colorFilter);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setTintList(ColorStateList tint) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setTintList(tint);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setTintMode(PorterDuff.Mode tintMode) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setTintMode(tintMode);
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$getFirstNonNullDrawable() {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            return dr;
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setOpacity(int opacity) {
        this.mLayerState.mOpacityOverride = opacity;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getOpacity() {
        if (this.mLayerState.mOpacityOverride != 0) {
            return this.mLayerState.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.setAutoMirrored(mirrored);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$jumpToCurrentState() {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.jumpToCurrentState();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$isStateful() {
        return this.mLayerState.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$onStateChange(int[] state) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null || !dr.isStateful() || !dr.setState(state)) continue;
            this.refreshChildPadding(i, array2[i]);
            changed = true;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$onLevelChange(int level) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null || !dr.setLevel(level)) continue;
            this.refreshChildPadding(i, array2[i]);
            changed = true;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$onBoundsChange(Rect bounds) {
        this.updateLayerBounds(bounds);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$updateLayerBounds(Rect bounds) {
        try {
            this.suspendChildInvalidation();
            this.updateLayerBoundsInternal(bounds);
        }
        finally {
            this.resumeChildInvalidation();
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$updateLayerBoundsInternal(Rect bounds) {
        int paddingL = 0;
        int paddingT = 0;
        int paddingR = 0;
        int paddingB = 0;
        Rect outRect = this.mTmpOutRect;
        int layoutDirection = this.getLayoutDirection();
        boolean isLayoutRtl = layoutDirection == 1;
        boolean isPaddingNested = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        for (int i = 0; i < count; ++i) {
            ChildDrawable r = array2[i];
            Drawable d = r.mDrawable;
            if (d == null) continue;
            int insetT = r.mInsetT;
            int insetB = r.mInsetB;
            int insetRtlL = isLayoutRtl ? r.mInsetE : r.mInsetS;
            int insetRtlR = isLayoutRtl ? r.mInsetS : r.mInsetE;
            int insetL = insetRtlL == Integer.MIN_VALUE ? r.mInsetL : insetRtlL;
            int insetR = insetRtlR == Integer.MIN_VALUE ? r.mInsetR : insetRtlR;
            Rect container = this.mTmpContainer;
            container.set(bounds.left + insetL + paddingL, bounds.top + insetT + paddingT, bounds.right - insetR - paddingR, bounds.bottom - insetB - paddingB);
            int intrinsicW = d.getIntrinsicWidth();
            int intrinsicH = d.getIntrinsicHeight();
            int layerW = r.mWidth;
            int layerH = r.mHeight;
            int gravity = LayerDrawable.resolveGravity(r.mGravity, layerW, layerH, intrinsicW, intrinsicH);
            int resolvedW = layerW < 0 ? intrinsicW : layerW;
            int resolvedH = layerH < 0 ? intrinsicH : layerH;
            Gravity.apply(gravity, resolvedW, resolvedH, container, outRect, layoutDirection);
            d.setBounds(outRect);
            if (!isPaddingNested) continue;
            paddingL += this.mPaddingL[i];
            paddingR += this.mPaddingR[i];
            paddingT += this.mPaddingT[i];
            paddingB += this.mPaddingB[i];
        }
    }

    private static final int $$robo$$android_graphics_drawable_LayerDrawable$resolveGravity(int gravity, int width, int height, int intrinsicWidth, int intrinsicHeight) {
        if (!Gravity.isHorizontal(gravity)) {
            gravity = width < 0 ? (gravity |= 7) : (gravity |= 0x800003);
        }
        if (!Gravity.isVertical(gravity)) {
            gravity = height < 0 ? (gravity |= 0x70) : (gravity |= 0x30);
        }
        if (width < 0 && intrinsicWidth < 0) {
            gravity |= 7;
        }
        if (height < 0 && intrinsicHeight < 0) {
            gravity |= 0x70;
        }
        return gravity;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicWidth() {
        int width = -1;
        int padL = 0;
        int padR = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        boolean isLayoutRtl = this.getLayoutDirection() == 1;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            int w;
            ChildDrawable r = array2[i];
            if (r.mDrawable == null) continue;
            int insetRtlL = isLayoutRtl ? r.mInsetE : r.mInsetS;
            int insetRtlR = isLayoutRtl ? r.mInsetS : r.mInsetE;
            int insetL = insetRtlL == Integer.MIN_VALUE ? r.mInsetL : insetRtlL;
            int insetR = insetRtlR == Integer.MIN_VALUE ? r.mInsetR : insetRtlR;
            int minWidth = r.mWidth < 0 ? r.mDrawable.getIntrinsicWidth() : r.mWidth;
            int n = w = minWidth < 0 ? -1 : minWidth + insetL + insetR + padL + padR;
            if (w > width) {
                width = w;
            }
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
        }
        return width;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicHeight() {
        int height = -1;
        int padT = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            int h;
            ChildDrawable r = array2[i];
            if (r.mDrawable == null) continue;
            int minHeight = r.mHeight < 0 ? r.mDrawable.getIntrinsicHeight() : r.mHeight;
            int n = h = minHeight < 0 ? -1 : minHeight + r.mInsetT + r.mInsetB + padT + padB;
            if (h > height) {
                height = h;
            }
            if (!nest) continue;
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
        return height;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$refreshChildPadding(int i, ChildDrawable r) {
        if (r.mDrawable != null) {
            Rect rect = this.mTmpRect;
            r.mDrawable.getPadding(rect);
            if (rect.left != this.mPaddingL[i] || rect.top != this.mPaddingT[i] || rect.right != this.mPaddingR[i] || rect.bottom != this.mPaddingB[i]) {
                this.mPaddingL[i] = rect.left;
                this.mPaddingT[i] = rect.top;
                this.mPaddingR[i] = rect.right;
                this.mPaddingB[i] = rect.bottom;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$ensurePadding() {
        int N = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= N) {
            return;
        }
        this.mPaddingL = new int[N];
        this.mPaddingT = new int[N];
        this.mPaddingR = new int[N];
        this.mPaddingB = new int[N];
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$refreshPadding() {
        int N = this.mLayerState.mNum;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
        }
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_LayerDrawable$getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            ChildDrawable[] array2 = this.mLayerState.mChildren;
            int N = this.mLayerState.mNum;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null) continue;
                dr.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$clearMutated() {
        super.clearMutated();
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            dr.clearMutated();
        }
        this.mMutated = false;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$onLayoutDirectionChanged(int layoutDirection) {
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array2[i].mDrawable;
            if (dr == null) continue;
            changed |= dr.setLayoutDirection(layoutDirection);
        }
        this.updateLayerBounds(this.getBounds());
        return changed;
    }

    private void __constructor__(Drawable[] drawableArray) {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__(drawableArray);
    }

    public LayerDrawable(Drawable[] drawableArray) {
        this(drawableArray, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(android.graphics.drawable.Drawable[] ), 0, this, drawableArray);
    }

    private void __constructor__(Drawable[] drawableArray, LayerState layerState) {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__(drawableArray, layerState);
    }

    LayerDrawable(Drawable[] drawableArray, LayerState layerState) {
        this(layerState, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(android.graphics.drawable.Drawable[] android.graphics.drawable.LayerDrawable$LayerState ), 0, this, drawableArray, layerState);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__();
    }

    LayerDrawable() {
        this((LayerState)null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(LayerState layerState, Resources resources) {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__(layerState, resources);
    }

    LayerDrawable(LayerState layerState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources ), 0, this, layerState, resources);
    }

    LayerState createConstantState(LayerState layerState, Resources resources) {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_graphics_drawable_LayerDrawable$createConstantState(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources ), 0, this, layerState, resources);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_LayerDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_LayerDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void inflateLayers(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateLayers", $$robo$$android_graphics_drawable_LayerDrawable$inflateLayers(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_LayerDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateLayerFromTypedArray(ChildDrawable childDrawable, TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateLayerFromTypedArray", $$robo$$android_graphics_drawable_LayerDrawable$updateLayerFromTypedArray(android.graphics.drawable.LayerDrawable$ChildDrawable android.content.res.TypedArray ), 0, this, childDrawable, typedArray);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_LayerDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public boolean isProjected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProjected", $$robo$$android_graphics_drawable_LayerDrawable$isProjected(), 0, this);
    }

    int addLayer(ChildDrawable childDrawable) {
        return (int)InvokeDynamicSupport.bootstrap("addLayer", $$robo$$android_graphics_drawable_LayerDrawable$addLayer(android.graphics.drawable.LayerDrawable$ChildDrawable ), 0, this, childDrawable);
    }

    ChildDrawable addLayer(Drawable drawable2, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        return InvokeDynamicSupport.bootstrap("addLayer", $$robo$$android_graphics_drawable_LayerDrawable$addLayer(android.graphics.drawable.Drawable int[] int int int int int ), 0, this, drawable2, nArray, n, n2, n3, n4, n5);
    }

    private ChildDrawable createLayer(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("createLayer", $$robo$$android_graphics_drawable_LayerDrawable$createLayer(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public int addLayer(Drawable drawable2) {
        return (int)InvokeDynamicSupport.bootstrap("addLayer", $$robo$$android_graphics_drawable_LayerDrawable$addLayer(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable findDrawableByLayerId(int n) {
        return InvokeDynamicSupport.bootstrap("findDrawableByLayerId", $$robo$$android_graphics_drawable_LayerDrawable$findDrawableByLayerId(int ), 0, this, n);
    }

    public void setId(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setId", $$robo$$android_graphics_drawable_LayerDrawable$setId(int int ), 0, this, n, n2);
    }

    public int getId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_graphics_drawable_LayerDrawable$getId(int ), 0, this, n);
    }

    public int getNumberOfLayers() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfLayers", $$robo$$android_graphics_drawable_LayerDrawable$getNumberOfLayers(), 0, this);
    }

    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDrawableByLayerId", $$robo$$android_graphics_drawable_LayerDrawable$setDrawableByLayerId(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    public int findIndexByLayerId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findIndexByLayerId", $$robo$$android_graphics_drawable_LayerDrawable$findIndexByLayerId(int ), 0, this, n);
    }

    public void setDrawable(int n, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDrawable", $$robo$$android_graphics_drawable_LayerDrawable$setDrawable(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    public Drawable getDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_LayerDrawable$getDrawable(int ), 0, this, n);
    }

    public void setLayerSize(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setLayerSize", $$robo$$android_graphics_drawable_LayerDrawable$setLayerSize(int int int ), 0, this, n, n2, n3);
    }

    public void setLayerWidth(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerWidth", $$robo$$android_graphics_drawable_LayerDrawable$setLayerWidth(int int ), 0, this, n, n2);
    }

    public int getLayerWidth(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerWidth", $$robo$$android_graphics_drawable_LayerDrawable$getLayerWidth(int ), 0, this, n);
    }

    public void setLayerHeight(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerHeight", $$robo$$android_graphics_drawable_LayerDrawable$setLayerHeight(int int ), 0, this, n, n2);
    }

    public int getLayerHeight(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerHeight", $$robo$$android_graphics_drawable_LayerDrawable$getLayerHeight(int ), 0, this, n);
    }

    public void setLayerGravity(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerGravity", $$robo$$android_graphics_drawable_LayerDrawable$setLayerGravity(int int ), 0, this, n, n2);
    }

    public int getLayerGravity(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerGravity", $$robo$$android_graphics_drawable_LayerDrawable$getLayerGravity(int ), 0, this, n);
    }

    public void setLayerInset(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setLayerInset", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInset(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setLayerInsetRelative(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setLayerInsetRelative", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetRelative(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setLayerInsetLeft(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerInsetLeft", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetLeft(int int ), 0, this, n, n2);
    }

    public int getLayerInsetLeft(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerInsetLeft", $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetLeft(int ), 0, this, n);
    }

    public void setLayerInsetRight(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerInsetRight", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetRight(int int ), 0, this, n, n2);
    }

    public int getLayerInsetRight(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerInsetRight", $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetRight(int ), 0, this, n);
    }

    public void setLayerInsetTop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerInsetTop", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetTop(int int ), 0, this, n, n2);
    }

    public int getLayerInsetTop(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerInsetTop", $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetTop(int ), 0, this, n);
    }

    public void setLayerInsetBottom(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerInsetBottom", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetBottom(int int ), 0, this, n, n2);
    }

    public int getLayerInsetBottom(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerInsetBottom", $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetBottom(int ), 0, this, n);
    }

    public void setLayerInsetStart(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerInsetStart", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetStart(int int ), 0, this, n, n2);
    }

    public int getLayerInsetStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerInsetStart", $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetStart(int ), 0, this, n);
    }

    public void setLayerInsetEnd(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayerInsetEnd", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetEnd(int int ), 0, this, n, n2);
    }

    public int getLayerInsetEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLayerInsetEnd", $$robo$$android_graphics_drawable_LayerDrawable$getLayerInsetEnd(int ), 0, this, n);
    }

    private void setLayerInsetInternal(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        InvokeDynamicSupport.bootstrap("setLayerInsetInternal", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInsetInternal(int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7);
    }

    public void setPaddingMode(int n) {
        InvokeDynamicSupport.bootstrap("setPaddingMode", $$robo$$android_graphics_drawable_LayerDrawable$setPaddingMode(int ), 0, this, n);
    }

    public int getPaddingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingMode", $$robo$$android_graphics_drawable_LayerDrawable$getPaddingMode(), 0, this);
    }

    private void suspendChildInvalidation() {
        InvokeDynamicSupport.bootstrap("suspendChildInvalidation", $$robo$$android_graphics_drawable_LayerDrawable$suspendChildInvalidation(), 0, this);
    }

    private void resumeChildInvalidation() {
        InvokeDynamicSupport.bootstrap("resumeChildInvalidation", $$robo$$android_graphics_drawable_LayerDrawable$resumeChildInvalidation(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_LayerDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_LayerDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_LayerDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_LayerDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_LayerDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_LayerDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setPadding", $$robo$$android_graphics_drawable_LayerDrawable$setPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setPaddingRelative(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setPaddingRelative", $$robo$$android_graphics_drawable_LayerDrawable$setPaddingRelative(int int int int ), 0, this, n, n2, n3, n4);
    }

    public int getLeftPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getLeftPadding", $$robo$$android_graphics_drawable_LayerDrawable$getLeftPadding(), 0, this);
    }

    public int getRightPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getRightPadding", $$robo$$android_graphics_drawable_LayerDrawable$getRightPadding(), 0, this);
    }

    public int getStartPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getStartPadding", $$robo$$android_graphics_drawable_LayerDrawable$getStartPadding(), 0, this);
    }

    public int getEndPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getEndPadding", $$robo$$android_graphics_drawable_LayerDrawable$getEndPadding(), 0, this);
    }

    public int getTopPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPadding", $$robo$$android_graphics_drawable_LayerDrawable$getTopPadding(), 0, this);
    }

    public int getBottomPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPadding", $$robo$$android_graphics_drawable_LayerDrawable$getBottomPadding(), 0, this);
    }

    private void computeNestedPadding(Rect rect) {
        InvokeDynamicSupport.bootstrap("computeNestedPadding", $$robo$$android_graphics_drawable_LayerDrawable$computeNestedPadding(android.graphics.Rect ), 0, this, rect);
    }

    private void computeStackedPadding(Rect rect) {
        InvokeDynamicSupport.bootstrap("computeStackedPadding", $$robo$$android_graphics_drawable_LayerDrawable$computeStackedPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_LayerDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_LayerDrawable$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_LayerDrawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_LayerDrawable$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_LayerDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_LayerDrawable$setDither(boolean ), 0, this, bl);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_LayerDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_LayerDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_LayerDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_LayerDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_LayerDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    private Drawable getFirstNonNullDrawable() {
        return InvokeDynamicSupport.bootstrap("getFirstNonNullDrawable", $$robo$$android_graphics_drawable_LayerDrawable$getFirstNonNullDrawable(), 0, this);
    }

    public void setOpacity(int n) {
        InvokeDynamicSupport.bootstrap("setOpacity", $$robo$$android_graphics_drawable_LayerDrawable$setOpacity(int ), 0, this, n);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_LayerDrawable$getOpacity(), 0, this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_LayerDrawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_LayerDrawable$isAutoMirrored(), 0, this);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_LayerDrawable$jumpToCurrentState(), 0, this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_LayerDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_LayerDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_LayerDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_LayerDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    private void updateLayerBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("updateLayerBounds", $$robo$$android_graphics_drawable_LayerDrawable$updateLayerBounds(android.graphics.Rect ), 0, this, rect);
    }

    private void updateLayerBoundsInternal(Rect rect) {
        InvokeDynamicSupport.bootstrap("updateLayerBoundsInternal", $$robo$$android_graphics_drawable_LayerDrawable$updateLayerBoundsInternal(android.graphics.Rect ), 0, this, rect);
    }

    private static int resolveGravity(int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveGravity", $$robo$$android_graphics_drawable_LayerDrawable$resolveGravity(int int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicHeight(), 0, this);
    }

    private boolean refreshChildPadding(int n, ChildDrawable childDrawable) {
        return (boolean)InvokeDynamicSupport.bootstrap("refreshChildPadding", $$robo$$android_graphics_drawable_LayerDrawable$refreshChildPadding(int android.graphics.drawable.LayerDrawable$ChildDrawable ), 0, this, n, childDrawable);
    }

    void ensurePadding() {
        InvokeDynamicSupport.bootstrap("ensurePadding", $$robo$$android_graphics_drawable_LayerDrawable$ensurePadding(), 0, this);
    }

    void refreshPadding() {
        InvokeDynamicSupport.bootstrap("refreshPadding", $$robo$$android_graphics_drawable_LayerDrawable$refreshPadding(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_LayerDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_LayerDrawable$mutate(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_LayerDrawable$clearMutated(), 0, this);
    }

    @Override
    public boolean onLayoutDirectionChanged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLayoutDirectionChanged", $$robo$$android_graphics_drawable_LayerDrawable$onLayoutDirectionChanged(int ), 0, this, n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayerDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayerState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        int mNum;
        ChildDrawable[] mChildren;
        int mDensity;
        int mPaddingTop;
        int mPaddingBottom;
        int mPaddingLeft;
        int mPaddingRight;
        int mPaddingStart;
        int mPaddingEnd;
        int mOpacityOverride;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mHaveOpacity;
        private int mOpacity;
        private boolean mHaveIsStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored;
        private int mPaddingMode;

        private void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$__constructor__(LayerState orig, LayerDrawable owner, Resources res) {
            this.mPaddingTop = -1;
            this.mPaddingBottom = -1;
            this.mPaddingLeft = -1;
            this.mPaddingRight = -1;
            this.mPaddingStart = -1;
            this.mPaddingEnd = -1;
            this.mOpacityOverride = 0;
            this.mAutoMirrored = false;
            this.mPaddingMode = 0;
            this.mDensity = Drawable.resolveDensity(res, orig != null ? orig.mDensity : 0);
            if (orig != null) {
                int N;
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mNum = N = orig.mNum;
                this.mChildren = new ChildDrawable[N];
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < N; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mHaveOpacity = orig.mHaveOpacity;
                this.mOpacity = orig.mOpacity;
                this.mHaveIsStateful = orig.mHaveIsStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mPaddingMode = orig.mPaddingMode;
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mPaddingTop = orig.mPaddingTop;
                this.mPaddingBottom = orig.mPaddingBottom;
                this.mPaddingLeft = orig.mPaddingLeft;
                this.mPaddingRight = orig.mPaddingRight;
                this.mPaddingStart = orig.mPaddingStart;
                this.mPaddingEnd = orig.mPaddingEnd;
                this.mOpacityOverride = orig.mOpacityOverride;
                if (orig.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            } else {
                this.mNum = 0;
                this.mChildren = null;
            }
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.onDensityChanged(sourceDensity, targetDensity);
            }
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$onDensityChanged(int sourceDensity, int targetDensity) {
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mPaddingLeft > 0) {
                this.mPaddingLeft = Drawable.scaleFromDensity(this.mPaddingLeft, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingTop > 0) {
                this.mPaddingTop = Drawable.scaleFromDensity(this.mPaddingTop, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingRight > 0) {
                this.mPaddingRight = Drawable.scaleFromDensity(this.mPaddingRight, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingBottom > 0) {
                this.mPaddingBottom = Drawable.scaleFromDensity(this.mPaddingBottom, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingStart > 0) {
                this.mPaddingStart = Drawable.scaleFromDensity(this.mPaddingStart, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingEnd > 0) {
                this.mPaddingEnd = Drawable.scaleFromDensity(this.mPaddingEnd, sourceDensity, targetDensity, false);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canApplyTheme() {
            if (this.mThemeAttrs != null || super.canApplyTheme()) {
                return true;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                ChildDrawable layer = array2[i];
                if (!layer.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        private final Drawable $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable() {
            return new LayerDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(Resources res) {
            return new LayerDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        private final int $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            int firstIndex = -1;
            for (int i = 0; i < N; ++i) {
                if (array2[i].mDrawable == null) continue;
                firstIndex = i;
                break;
            }
            int op = firstIndex >= 0 ? array2[firstIndex].mDrawable.getOpacity() : -2;
            for (int i = firstIndex + 1; i < N; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null) continue;
                op = Drawable.resolveOpacity(op, dr.getOpacity());
            }
            this.mOpacity = op;
            this.mHaveOpacity = true;
            return op;
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_LayerState$isStateful() {
            if (this.mHaveIsStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            boolean isStateful = false;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || !dr.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mHaveIsStateful = true;
            return isStateful;
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canConstantState() {
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array2[i].mDrawable;
                if (dr == null || dr.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$invalidateCache() {
            this.mHaveOpacity = false;
            this.mHaveIsStateful = false;
        }

        private final int $$robo$$android_graphics_drawable_LayerDrawable_LayerState$addAtlasableBitmaps(Collection<Bitmap> atlasList) {
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            int pixelCount = 0;
            for (int i = 0; i < N; ++i) {
                Drawable.ConstantState state;
                Drawable dr = array2[i].mDrawable;
                if (dr == null || (state = dr.getConstantState()) == null) continue;
                pixelCount += state.addAtlasableBitmaps(atlasList);
            }
            return pixelCount;
        }

        static /* synthetic */ int[] access$002(LayerState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(LayerState layerState, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_LayerDrawable_LayerState$__constructor__(layerState, layerDrawable, resources);
        }

        LayerState(LayerState layerState, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$__constructor__(android.graphics.drawable.LayerDrawable$LayerState android.graphics.drawable.LayerDrawable android.content.res.Resources ), 0, this, layerState, layerDrawable, resources);
        }

        public void setDensity(int n) {
            InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$setDensity(int ), 0, this, n);
        }

        protected void onDensityChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDensityChanged", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$onDensityChanged(int int ), 0, this, n, n2);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$applyDensityScaling(int int ), 0, this, n, n2);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getChangingConfigurations(), 0, this);
        }

        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getOpacity(), 0, this);
        }

        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$isStateful(), 0, this);
        }

        public boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canConstantState(), 0, this);
        }

        public void invalidateCache() {
            InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$invalidateCache(), 0, this);
        }

        @Override
        public int addAtlasableBitmaps(Collection<Bitmap> collection) {
            return (int)InvokeDynamicSupport.bootstrap("addAtlasableBitmaps", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$addAtlasableBitmaps(java.util.Collection<android.graphics.Bitmap> ), 0, this, collection);
        }

        public /* synthetic */ LayerState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayerState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChildDrawable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mDensity;
        public int mInsetL;
        public int mInsetT;
        public int mInsetR;
        public int mInsetB;
        public int mInsetS;
        public int mInsetE;
        public int mWidth;
        public int mHeight;
        public int mGravity;
        public int mId;

        private void $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(int density) {
            this.mDensity = 160;
            this.mInsetS = Integer.MIN_VALUE;
            this.mInsetE = Integer.MIN_VALUE;
            this.mWidth = -1;
            this.mHeight = -1;
            this.mGravity = 0;
            this.mId = -1;
            this.mDensity = density;
        }

        private void $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(ChildDrawable orig, LayerDrawable owner, Resources res) {
            Drawable clone;
            this.mDensity = 160;
            this.mInsetS = Integer.MIN_VALUE;
            this.mInsetE = Integer.MIN_VALUE;
            this.mWidth = -1;
            this.mHeight = -1;
            this.mGravity = 0;
            this.mId = -1;
            Drawable dr = orig.mDrawable;
            if (dr != null) {
                Drawable.ConstantState cs = dr.getConstantState();
                clone = cs == null ? dr : (res != null ? cs.newDrawable(res) : cs.newDrawable());
                clone.setCallback(owner);
                clone.setLayoutDirection(dr.getLayoutDirection());
                clone.setBounds(dr.getBounds());
                clone.setLevel(dr.getLevel());
            } else {
                clone = null;
            }
            this.mDrawable = clone;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mInsetL = orig.mInsetL;
            this.mInsetT = orig.mInsetT;
            this.mInsetR = orig.mInsetR;
            this.mInsetB = orig.mInsetB;
            this.mInsetS = orig.mInsetS;
            this.mInsetE = orig.mInsetE;
            this.mWidth = orig.mWidth;
            this.mHeight = orig.mHeight;
            this.mGravity = orig.mGravity;
            this.mId = orig.mId;
            this.mDensity = Drawable.resolveDensity(res, orig.mDensity);
            if (orig.mDensity != this.mDensity) {
                this.applyDensityScaling(orig.mDensity, this.mDensity);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$canApplyTheme() {
            return this.mThemeAttrs != null || this.mDrawable != null && this.mDrawable.canApplyTheme();
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
            }
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mInsetL = Drawable.scaleFromDensity(this.mInsetL, sourceDensity, targetDensity, false);
            this.mInsetT = Drawable.scaleFromDensity(this.mInsetT, sourceDensity, targetDensity, false);
            this.mInsetR = Drawable.scaleFromDensity(this.mInsetR, sourceDensity, targetDensity, false);
            this.mInsetB = Drawable.scaleFromDensity(this.mInsetB, sourceDensity, targetDensity, false);
            if (this.mInsetS != Integer.MIN_VALUE) {
                this.mInsetS = Drawable.scaleFromDensity(this.mInsetS, sourceDensity, targetDensity, false);
            }
            if (this.mInsetE != Integer.MIN_VALUE) {
                this.mInsetE = Drawable.scaleFromDensity(this.mInsetE, sourceDensity, targetDensity, false);
            }
            if (this.mWidth > 0) {
                this.mWidth = Drawable.scaleFromDensity(this.mWidth, sourceDensity, targetDensity, true);
            }
            if (this.mHeight > 0) {
                this.mHeight = Drawable.scaleFromDensity(this.mHeight, sourceDensity, targetDensity, true);
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(n);
        }

        ChildDrawable(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(int ), 0, this, n);
        }

        private void __constructor__(ChildDrawable childDrawable, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(childDrawable, layerDrawable, resources);
        }

        ChildDrawable(ChildDrawable childDrawable, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(android.graphics.drawable.LayerDrawable$ChildDrawable android.graphics.drawable.LayerDrawable android.content.res.Resources ), 0, this, childDrawable, layerDrawable, resources);
        }

        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$canApplyTheme(), 0, this);
        }

        public void setDensity(int n) {
            InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$setDensity(int ), 0, this, n);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$applyDensityScaling(int int ), 0, this, n, n2);
        }

        public /* synthetic */ ChildDrawable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildDrawable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

