/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends DrawableWrapper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Rect mTmpRect;
    private InsetState mState;

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, int inset) {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this.mState.mInsetLeft = insetLeft;
        this.mState.mInsetTop = insetTop;
        this.mState.mInsetRight = insetRight;
        this.mState.mInsetBottom = insetBottom;
        this.setDrawable(drawable2);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = InsetDrawable.obtainAttributes(r, theme, attrs, R.styleable.InsetDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_InsetDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.InsetDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                InsetDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$updateStateFromTypedArray(TypedArray a) {
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        InsetState.access$002(state, a.extractThemeAttrs());
        if (a.hasValue(6)) {
            int inset;
            state.mInsetLeft = inset = a.getDimensionPixelOffset(6, 0);
            state.mInsetTop = inset;
            state.mInsetRight = inset;
            state.mInsetBottom = inset;
        }
        state.mInsetLeft = a.getDimensionPixelOffset(2, state.mInsetLeft);
        state.mInsetRight = a.getDimensionPixelOffset(3, state.mInsetRight);
        state.mInsetTop = a.getDimensionPixelOffset(4, state.mInsetTop);
        state.mInsetBottom = a.getDimensionPixelOffset(5, state.mInsetBottom);
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$getPadding(Rect padding) {
        boolean pad = super.getPadding(padding);
        padding.left += this.mState.mInsetLeft;
        padding.right += this.mState.mInsetRight;
        padding.top += this.mState.mInsetTop;
        padding.bottom += this.mState.mInsetBottom;
        return pad || (this.mState.mInsetLeft | this.mState.mInsetRight | this.mState.mInsetTop | this.mState.mInsetBottom) != 0;
    }

    private final Insets $$robo$$android_graphics_drawable_InsetDrawable$getOpticalInsets() {
        Insets contentInsets = super.getOpticalInsets();
        return Insets.of(contentInsets.left + this.mState.mInsetLeft, contentInsets.top + this.mState.mInsetTop, contentInsets.right + this.mState.mInsetRight, contentInsets.bottom + this.mState.mInsetBottom);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getOpacity() {
        InsetState state = this.mState;
        int opacity = this.getDrawable().getOpacity();
        if (opacity == -1 && (state.mInsetLeft > 0 || state.mInsetTop > 0 || state.mInsetRight > 0 || state.mInsetBottom > 0)) {
            return -3;
        }
        return opacity;
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mState.mInsetLeft;
        r.top += this.mState.mInsetTop;
        r.right -= this.mState.mInsetRight;
        r.bottom -= this.mState.mInsetBottom;
        super.onBoundsChange(r);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicWidth() {
        int childWidth = this.getDrawable().getIntrinsicWidth();
        if (childWidth < 0) {
            return -1;
        }
        return childWidth + this.mState.mInsetLeft + this.mState.mInsetRight;
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicHeight() {
        int childHeight = this.getDrawable().getIntrinsicHeight();
        if (childHeight < 0) {
            return -1;
        }
        return childHeight + this.mState.mInsetTop + this.mState.mInsetBottom;
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$getOutline(Outline outline) {
        this.getDrawable().getOutline(outline);
    }

    private final DrawableWrapper.DrawableWrapperState $$robo$$android_graphics_drawable_InsetDrawable$mutateConstantState() {
        this.mState = new InsetState(this.mState, null);
        return this.mState;
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(InsetState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mState = state;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(InsetState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__();
    }

    InsetDrawable() {
        this(new InsetState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Drawable drawable2, int n) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, n);
    }

    public InsetDrawable(Drawable drawable2, int n) {
        this(drawable2, n, n, n, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable int ), 0, this, drawable2, n);
    }

    private void __constructor__(Drawable drawable2, int n, int n2, int n3, int n4) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, n, n2, n3, n4);
    }

    public InsetDrawable(Drawable drawable2, int n, int n2, int n3, int n4) {
        this(new InsetState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable int int int int ), 0, this, drawable2, n, n2, n3, n4);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_InsetDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_InsetDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_InsetDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_InsetDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_InsetDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_InsetDrawable$getOpticalInsets(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_InsetDrawable$getOpacity(), 0, this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_InsetDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_InsetDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_InsetDrawable$mutateConstantState(), 0, this);
    }

    private void __constructor__(InsetState insetState, Resources resources) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(insetState, resources);
    }

    private InsetDrawable(InsetState insetState, Resources resources) {
        super(insetState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.InsetDrawable$InsetState android.content.res.Resources ), 0, this, insetState, resources);
    }

    private /* synthetic */ void __constructor__(InsetState insetState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(insetState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class InsetState
    extends DrawableWrapper.DrawableWrapperState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        int mInsetLeft;
        int mInsetTop;
        int mInsetRight;
        int mInsetBottom;

        private void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(InsetState orig, Resources res) {
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mInsetRight = 0;
            this.mInsetBottom = 0;
            if (orig != null) {
                this.mInsetLeft = orig.mInsetLeft;
                this.mInsetTop = orig.mInsetTop;
                this.mInsetRight = orig.mInsetRight;
                this.mInsetBottom = orig.mInsetBottom;
                if (orig.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            }
        }

        private final void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private final void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mInsetLeft = Bitmap.scaleFromDensity(this.mInsetLeft, sourceDensity, targetDensity);
            this.mInsetTop = Bitmap.scaleFromDensity(this.mInsetTop, sourceDensity, targetDensity);
            this.mInsetRight = Bitmap.scaleFromDensity(this.mInsetRight, sourceDensity, targetDensity);
            this.mInsetBottom = Bitmap.scaleFromDensity(this.mInsetBottom, sourceDensity, targetDensity);
        }

        private final Drawable $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(Resources res) {
            InsetState state;
            if (res != null) {
                int density;
                int densityDpi = res.getDisplayMetrics().densityDpi;
                int n = density = densityDpi == 0 ? 160 : densityDpi;
                state = density != this.mDensity ? new InsetState(this, res) : this;
            } else {
                state = this;
            }
            return new InsetDrawable(state, res);
        }

        static /* synthetic */ int[] access$002(InsetState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(InsetState insetState, Resources resources) {
            this.$$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(insetState, resources);
        }

        InsetState(InsetState insetState, Resources resources) {
            super(insetState, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(android.graphics.drawable.InsetDrawable$InsetState android.content.res.Resources ), 0, this, insetState, resources);
        }

        @Override
        void onDensityChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDensityChanged", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$onDensityChanged(int int ), 0, this, n, n2);
        }

        private void applyDensityScaling(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyDensityScaling", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$applyDensityScaling(int int ), 0, this, n, n2);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public /* synthetic */ InsetState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

