/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.os.SystemClock;
import android.util.AttributeSet;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationDrawable
extends DrawableContainer
implements Runnable,
Animatable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private AnimationState mAnimationState;
    private int mCurFrame;
    private boolean mRunning;
    private boolean mAnimating;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_AnimationDrawable$__constructor__() {
    }

    private final boolean $$robo$$android_graphics_drawable_AnimationDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (restart || changed) {
                boolean startFromZero = restart || !this.mRunning && !this.mAnimationState.mOneShot || this.mCurFrame >= this.mAnimationState.getChildCount();
                this.setFrame(startFromZero ? 0 : this.mCurFrame, true, this.mAnimating);
            }
        } else {
            this.unscheduleSelf(this);
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$start() {
        this.mAnimating = true;
        if (!this.isRunning()) {
            this.setFrame(0, false, this.mAnimationState.getChildCount() > 1 || !this.mAnimationState.mOneShot);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$stop() {
        this.mAnimating = false;
        if (this.isRunning()) {
            this.mCurFrame = 0;
            this.unscheduleSelf(this);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimationDrawable$isRunning() {
        return this.mRunning;
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$run() {
        this.nextFrame(false);
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$unscheduleSelf(Runnable what) {
        this.mRunning = false;
        super.unscheduleSelf(what);
    }

    private final int $$robo$$android_graphics_drawable_AnimationDrawable$getNumberOfFrames() {
        return this.mAnimationState.getChildCount();
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimationDrawable$getFrame(int index) {
        return this.mAnimationState.getChild(index);
    }

    private final int $$robo$$android_graphics_drawable_AnimationDrawable$getDuration(int i) {
        return this.mAnimationState.mDurations[i];
    }

    private final boolean $$robo$$android_graphics_drawable_AnimationDrawable$isOneShot() {
        return this.mAnimationState.mOneShot;
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$setOneShot(boolean oneShot) {
        this.mAnimationState.mOneShot = oneShot;
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$addFrame(Drawable frame, int duration) {
        this.mAnimationState.addFrame(frame, duration);
        if (!this.mRunning) {
            this.setFrame(0, true, false);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$nextFrame(boolean unschedule) {
        boolean isLastFrame;
        int nextFrame = this.mCurFrame + 1;
        int numFrames = this.mAnimationState.getChildCount();
        boolean bl = isLastFrame = this.mAnimationState.mOneShot && nextFrame >= numFrames - 1;
        if (!this.mAnimationState.mOneShot && nextFrame >= numFrames) {
            nextFrame = 0;
        }
        this.setFrame(nextFrame, unschedule, !isLastFrame);
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$setFrame(int frame, boolean unschedule, boolean animate) {
        if (frame >= this.mAnimationState.getChildCount()) {
            return;
        }
        this.mAnimating = animate;
        this.mCurFrame = frame;
        this.selectDrawable(frame);
        if (unschedule || animate) {
            this.unscheduleSelf(this);
        }
        if (animate) {
            this.mCurFrame = frame;
            this.mRunning = true;
            this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)this.mAnimationState.mDurations[frame]);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimationDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimationDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        this.updateStateFromTypedArray(a);
        this.updateDensity(r);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.setFrame(0, true, false);
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = AnimationDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimationDrawableItem);
            int duration = a.getInt(0, -1);
            if (duration < 0) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'duration' attribute");
            }
            Drawable dr = a.getDrawable(1);
            a.recycle();
            if (dr == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            this.mAnimationState.addFrame(dr, duration);
            if (dr == null) continue;
            dr.setCallback(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$updateStateFromTypedArray(TypedArray a) {
        this.mAnimationState.mVariablePadding = a.getBoolean(1, this.mAnimationState.mVariablePadding);
        this.mAnimationState.mOneShot = a.getBoolean(2, this.mAnimationState.mOneShot);
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimationDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimationState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private final AnimationState $$robo$$android_graphics_drawable_AnimationDrawable$cloneConstantState() {
        return new AnimationState(this.mAnimationState, this, null);
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private final void $$robo$$android_graphics_drawable_AnimationDrawable$setConstantState(DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimationState) {
            this.mAnimationState = (AnimationState)state;
        }
    }

    private void $$robo$$android_graphics_drawable_AnimationDrawable$__constructor__(AnimationState state, Resources res) {
        this.mCurFrame = 0;
        AnimationState as = new AnimationState(state, this, res);
        this.setConstantState(as);
        if (state != null) {
            this.setFrame(0, true, false);
        }
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimationDrawable$__constructor__(AnimationState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimationDrawable$__constructor__();
    }

    public AnimationDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimationDrawable$__constructor__(), 0, this);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimationDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimationDrawable$start(), 0, this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimationDrawable$stop(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimationDrawable$isRunning(), 0, this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_graphics_drawable_AnimationDrawable$run(), 0, this);
    }

    @Override
    public void unscheduleSelf(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleSelf", $$robo$$android_graphics_drawable_AnimationDrawable$unscheduleSelf(java.lang.Runnable ), 0, this, runnable);
    }

    public int getNumberOfFrames() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfFrames", $$robo$$android_graphics_drawable_AnimationDrawable$getNumberOfFrames(), 0, this);
    }

    public Drawable getFrame(int n) {
        return InvokeDynamicSupport.bootstrap("getFrame", $$robo$$android_graphics_drawable_AnimationDrawable$getFrame(int ), 0, this, n);
    }

    public int getDuration(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_graphics_drawable_AnimationDrawable$getDuration(int ), 0, this, n);
    }

    public boolean isOneShot() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOneShot", $$robo$$android_graphics_drawable_AnimationDrawable$isOneShot(), 0, this);
    }

    public void setOneShot(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOneShot", $$robo$$android_graphics_drawable_AnimationDrawable$setOneShot(boolean ), 0, this, bl);
    }

    public void addFrame(Drawable drawable2, int n) {
        InvokeDynamicSupport.bootstrap("addFrame", $$robo$$android_graphics_drawable_AnimationDrawable$addFrame(android.graphics.drawable.Drawable int ), 0, this, drawable2, n);
    }

    private void nextFrame(boolean bl) {
        InvokeDynamicSupport.bootstrap("nextFrame", $$robo$$android_graphics_drawable_AnimationDrawable$nextFrame(boolean ), 0, this, bl);
    }

    private void setFrame(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_graphics_drawable_AnimationDrawable$setFrame(int boolean boolean ), 0, this, n, bl, bl2);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimationDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_graphics_drawable_AnimationDrawable$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_AnimationDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimationDrawable$mutate(), 0, this);
    }

    @Override
    AnimationState cloneConstantState() {
        return InvokeDynamicSupport.bootstrap("cloneConstantState", $$robo$$android_graphics_drawable_AnimationDrawable$cloneConstantState(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_AnimationDrawable$clearMutated(), 0, this);
    }

    @Override
    protected void setConstantState(DrawableContainer.DrawableContainerState drawableContainerState) {
        InvokeDynamicSupport.bootstrap("setConstantState", $$robo$$android_graphics_drawable_AnimationDrawable$setConstantState(android.graphics.drawable.DrawableContainer$DrawableContainerState ), 0, this, drawableContainerState);
    }

    private void __constructor__(AnimationState animationState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AnimationDrawable$__constructor__(animationState, resources);
    }

    private AnimationDrawable(AnimationState animationState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimationDrawable$__constructor__(android.graphics.drawable.AnimationDrawable$AnimationState android.content.res.Resources ), 0, this, animationState, resources);
    }

    private /* synthetic */ void __constructor__(AnimationState animationState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_AnimationDrawable$__constructor__(animationState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class AnimationState
    extends DrawableContainer.DrawableContainerState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mDurations;
        private boolean mOneShot;

        private void $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$__constructor__(AnimationState orig, AnimationDrawable owner, Resources res) {
            this.mOneShot = false;
            if (orig != null) {
                this.mDurations = orig.mDurations;
                this.mOneShot = orig.mOneShot;
            } else {
                this.mDurations = new int[this.getCapacity()];
                this.mOneShot = false;
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$mutate() {
            this.mDurations = (int[])this.mDurations.clone();
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$newDrawable() {
            return new AnimationDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$newDrawable(Resources res) {
            return new AnimationDrawable(this, res);
        }

        private final void $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$addFrame(Drawable dr, int dur) {
            int pos = super.addChild(dr);
            this.mDurations[pos] = dur;
        }

        private final void $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newDurations = new int[newSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mDurations, (int)0, (int[])newDurations, (int)0, (int)oldSize);
            this.mDurations = newDurations;
        }

        private void __constructor__(AnimationState animationState, AnimationDrawable animationDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$__constructor__(animationState, animationDrawable, resources);
        }

        AnimationState(AnimationState animationState, AnimationDrawable animationDrawable, Resources resources) {
            super(animationState, animationDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$__constructor__(android.graphics.drawable.AnimationDrawable$AnimationState android.graphics.drawable.AnimationDrawable android.content.res.Resources ), 0, this, animationState, animationDrawable, resources);
        }

        private void mutate() {
            InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$mutate(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public void addFrame(Drawable drawable2, int n) {
            InvokeDynamicSupport.bootstrap("addFrame", $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$addFrame(android.graphics.drawable.Drawable int ), 0, this, drawable2, n);
        }

        @Override
        public void growArray(int n, int n2) {
            InvokeDynamicSupport.bootstrap("growArray", $$robo$$android_graphics_drawable_AnimationDrawable_AnimationState$growArray(int int ), 0, this, n, n2);
        }

        public /* synthetic */ AnimationState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

