/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedRotateDrawable
extends DrawableWrapper
implements Animatable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private AnimatedRotateState mState;
    private float mCurrentDegrees;
    private float mIncrement;
    private boolean mRunning;
    private Runnable mNextFrame;

    private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__() {
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$draw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        Rect bounds = drawable2.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        AnimatedRotateState st = this.mState;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        int saveCount = canvas.save();
        canvas.rotate(this.mCurrentDegrees, px + (float)bounds.left, py + (float)bounds.top);
        drawable2.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$start() {
        if (!this.mRunning) {
            this.mRunning = true;
            this.nextFrame();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mNextFrame);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$isRunning() {
        return this.mRunning;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$nextFrame() {
        this.unscheduleSelf(this.mNextFrame);
        this.scheduleSelf(this.mNextFrame, SystemClock.uptimeMillis() + (long)this.mState.mFrameDuration);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (changed || restart) {
                this.mCurrentDegrees = 0.0f;
                this.nextFrame();
            }
        } else {
            this.unscheduleSelf(this.mNextFrame);
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedRotateDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedRotateDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        AnimatedRotateState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.AnimatedRotateDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                AnimatedRotateDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        this.updateLocalState();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <animated-rotate> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$updateStateFromTypedArray(TypedArray a) {
        TypedValue tv;
        AnimatedRotateState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        AnimatedRotateState.access$002(state, a.extractThemeAttrs());
        if (a.hasValue(2)) {
            tv = a.peekValue(2);
            state.mPivotXRel = tv.type == 6;
            float f = state.mPivotX = state.mPivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        if (a.hasValue(3)) {
            tv = a.peekValue(3);
            state.mPivotYRel = tv.type == 6;
            state.mPivotY = state.mPivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        this.setFramesCount(a.getInt(5, state.mFramesCount));
        this.setFramesDuration(a.getInt(4, state.mFrameDuration));
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesCount(int framesCount) {
        this.mState.mFramesCount = framesCount;
        this.mIncrement = 360.0f / (float)this.mState.mFramesCount;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesDuration(int framesDuration) {
        this.mState.mFrameDuration = framesDuration;
    }

    private final DrawableWrapper.DrawableWrapperState $$robo$$android_graphics_drawable_AnimatedRotateDrawable$mutateConstantState() {
        this.mState = new AnimatedRotateState(this.mState, null);
        return this.mState;
    }

    private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(AnimatedRotateState state, Resources res) {
        this.mNextFrame = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AnimatedRotateDrawable this$0;

            private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable_1$__constructor__(AnimatedRotateDrawable this$0) {
            }

            private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable_1$run() {
                this.this$0.mCurrentDegrees = this.this$0.mCurrentDegrees + this.this$0.mIncrement;
                if (this.this$0.mCurrentDegrees > 360.0f - this.this$0.mIncrement) {
                    this.this$0.mCurrentDegrees = 0.0f;
                }
                this.this$0.invalidateSelf();
                this.this$0.nextFrame();
            }

            private void __constructor__(AnimatedRotateDrawable animatedRotateDrawable) {
                this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable_1$__constructor__(animatedRotateDrawable);
            }
            {
                this.this$0 = animatedRotateDrawable;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_1$__constructor__(android.graphics.drawable.AnimatedRotateDrawable ), 0, this, animatedRotateDrawable);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mState = state;
        this.updateLocalState();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$updateLocalState() {
        AnimatedRotateState state = this.mState;
        this.mIncrement = 360.0f / (float)state.mFramesCount;
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setFilterBitmap(true);
            if (drawable2 instanceof BitmapDrawable) {
                ((BitmapDrawable)drawable2).setAntiAlias(true);
            }
        }
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(AnimatedRotateState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__();
    }

    public AnimatedRotateDrawable() {
        this(new AnimatedRotateState(null, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$start(), 0, this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$stop(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$isRunning(), 0, this);
    }

    private void nextFrame() {
        InvokeDynamicSupport.bootstrap("nextFrame", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$nextFrame(), 0, this);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    public void setFramesCount(int n) {
        InvokeDynamicSupport.bootstrap("setFramesCount", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesCount(int ), 0, this, n);
    }

    public void setFramesDuration(int n) {
        InvokeDynamicSupport.bootstrap("setFramesDuration", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesDuration(int ), 0, this, n);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        return InvokeDynamicSupport.bootstrap("mutateConstantState", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$mutateConstantState(), 0, this);
    }

    private void __constructor__(AnimatedRotateState animatedRotateState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(animatedRotateState, resources);
    }

    private AnimatedRotateDrawable(AnimatedRotateState animatedRotateState, Resources resources) {
        super(animatedRotateState, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(android.graphics.drawable.AnimatedRotateDrawable$AnimatedRotateState android.content.res.Resources ), 0, this, animatedRotateState, resources);
    }

    private void updateLocalState() {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$updateLocalState(), 0, this);
    }

    private /* synthetic */ void __constructor__(AnimatedRotateState animatedRotateState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(animatedRotateState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedRotateDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class AnimatedRotateState
    extends DrawableWrapper.DrawableWrapperState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        boolean mPivotXRel;
        float mPivotX;
        boolean mPivotYRel;
        float mPivotY;
        int mFrameDuration;
        int mFramesCount;

        private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$__constructor__(AnimatedRotateState orig, Resources res) {
            this.mPivotXRel = false;
            this.mPivotX = 0.0f;
            this.mPivotYRel = false;
            this.mPivotY = 0.0f;
            this.mFrameDuration = 150;
            this.mFramesCount = 12;
            if (orig != null) {
                this.mPivotXRel = orig.mPivotXRel;
                this.mPivotX = orig.mPivotX;
                this.mPivotYRel = orig.mPivotYRel;
                this.mPivotY = orig.mPivotY;
                this.mFramesCount = orig.mFramesCount;
                this.mFrameDuration = orig.mFrameDuration;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$newDrawable(Resources res) {
            return new AnimatedRotateDrawable(this, res);
        }

        static /* synthetic */ int[] access$002(AnimatedRotateState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }

        private void __constructor__(AnimatedRotateState animatedRotateState, Resources resources) {
            this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$__constructor__(animatedRotateState, resources);
        }

        public AnimatedRotateState(AnimatedRotateState animatedRotateState, Resources resources) {
            super(animatedRotateState, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$__constructor__(android.graphics.drawable.AnimatedRotateDrawable$AnimatedRotateState android.content.res.Resources ), 0, this, animatedRotateState, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public /* synthetic */ AnimatedRotateState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedRotateState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

