/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontListParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Pattern FILENAME_WHITESPACE_PATTERN;
    private static Pattern TAG_PATTERN;
    private static Pattern STYLE_VALUE_PATTERN;

    private void $$robo$$android_graphics_FontListParser$__constructor__() {
    }

    private static final Config $$robo$$android_graphics_FontListParser$parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, null);
            parser.nextTag();
            Config config = FontListParser.readFamilies(parser);
            return config;
        }
        finally {
            in.close();
        }
    }

    private static final Config $$robo$$android_graphics_FontListParser$readFamilies(XmlPullParser parser) throws XmlPullParserException, IOException {
        Config config = new Config();
        parser.require(2, null, "familyset");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                config.families.add(FontListParser.readFamily(parser));
                continue;
            }
            if (tag.equals("alias")) {
                config.aliases.add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        return config;
    }

    private static final Family $$robo$$android_graphics_FontListParser$readFamily(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        String lang = parser.getAttributeValue(null, "lang");
        String variant = parser.getAttributeValue(null, "variant");
        ArrayList<Font> fonts = new ArrayList<Font>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                fonts.add(FontListParser.readFont(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        return new Family(name, fonts, lang, variant);
    }

    private static final Font $$robo$$android_graphics_FontListParser$readFont(XmlPullParser parser) throws XmlPullParserException, IOException {
        String indexStr = parser.getAttributeValue(null, "index");
        int index = indexStr == null ? 0 : Integer.parseInt(indexStr);
        ArrayList<Axis> axes = new ArrayList<Axis>();
        String weightStr = parser.getAttributeValue(null, "weight");
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        boolean isItalic = "italic".equals(parser.getAttributeValue(null, "style"));
        StringBuilder filename = new StringBuilder();
        while (parser.next() != 3) {
            if (parser.getEventType() == 4) {
                filename.append(parser.getText());
            }
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("axis")) {
                axes.add(FontListParser.readAxis(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        String fullFilename = "/system/fonts/" + FILENAME_WHITESPACE_PATTERN.matcher(filename).replaceAll("");
        return new Font(fullFilename, index, axes, weight, isItalic);
    }

    private static final Axis $$robo$$android_graphics_FontListParser$readAxis(XmlPullParser parser) throws XmlPullParserException, IOException {
        int tag = 0;
        String tagStr = parser.getAttributeValue(null, "tag");
        if (tagStr == null || !TAG_PATTERN.matcher(tagStr).matches()) {
            throw new XmlPullParserException("Invalid tag attribute value.", parser, null);
        }
        tag = (tagStr.charAt(0) << 24) + (tagStr.charAt(1) << 16) + (tagStr.charAt(2) << 8) + tagStr.charAt(3);
        float styleValue = 0.0f;
        String styleValueStr = parser.getAttributeValue(null, "stylevalue");
        if (styleValueStr == null || !STYLE_VALUE_PATTERN.matcher(styleValueStr).matches()) {
            throw new XmlPullParserException("Invalid styleValue attribute value.", parser, null);
        }
        styleValue = Float.parseFloat(styleValueStr);
        FontListParser.skip(parser);
        return new Axis(tag, styleValue);
    }

    private static final Alias $$robo$$android_graphics_FontListParser$readAlias(XmlPullParser parser) throws XmlPullParserException, IOException {
        Alias alias = new Alias();
        alias.name = parser.getAttributeValue(null, "name");
        alias.toName = parser.getAttributeValue(null, "to");
        String weightStr = parser.getAttributeValue(null, "weight");
        alias.weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        FontListParser.skip(parser);
        return alias;
    }

    private static final void $$robo$$android_graphics_FontListParser$skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }

    static void __staticInitializer__() {
        FILENAME_WHITESPACE_PATTERN = Pattern.compile("^[ \\n\\r\\t]+|[ \\n\\r\\t]+$");
        TAG_PATTERN = Pattern.compile("[\\x00-\\xFF]{4}");
        STYLE_VALUE_PATTERN = Pattern.compile("-?(([0-9]+(\\.[0-9]+)?)|(\\.[0-9]+))");
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_FontListParser$__constructor__();
    }

    public FontListParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser$__constructor__(), 0, this);
    }

    public static Config parse(InputStream inputStream) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_graphics_FontListParser$parse(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    private static Config readFamilies(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFamilies", $$robo$$android_graphics_FontListParser$readFamilies(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static Family readFamily(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFamily", $$robo$$android_graphics_FontListParser$readFamily(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static Font readFont(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFont", $$robo$$android_graphics_FontListParser$readFont(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static Axis readAxis(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readAxis", $$robo$$android_graphics_FontListParser$readAxis(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static Alias readAlias(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readAlias", $$robo$$android_graphics_FontListParser$readAlias(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("skip", $$robo$$android_graphics_FontListParser$skip(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    static {
        RobolectricInternals.classInitializing(FontListParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontListParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Family
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String name;
        public List<Font> fonts;
        public String lang;
        public String variant;

        private void $$robo$$android_graphics_FontListParser_Family$__constructor__(String name, List<Font> fonts, String lang, String variant) {
            this.name = name;
            this.fonts = fonts;
            this.lang = lang;
            this.variant = variant;
        }

        private void __constructor__(String string2, List<Font> list, String string3, String string4) {
            this.$$robo$$android_graphics_FontListParser_Family$__constructor__(string2, list, string3, string4);
        }

        public Family(String string2, List<Font> list, String string3, String string4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser_Family$__constructor__(java.lang.String java.util.List<android.graphics.FontListParser$Font> java.lang.String java.lang.String ), 0, this, string2, list, string3, string4);
        }

        public /* synthetic */ Family() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Family)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Alias
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String name;
        public String toName;
        public int weight;

        private void $$robo$$android_graphics_FontListParser_Alias$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_FontListParser_Alias$__constructor__();
        }

        public Alias() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser_Alias$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Alias)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Font
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String fontName;
        public int ttcIndex;
        public List<Axis> axes;
        public int weight;
        public boolean isItalic;

        private void $$robo$$android_graphics_FontListParser_Font$__constructor__(String fontName, int ttcIndex, List<Axis> axes, int weight, boolean isItalic) {
            this.fontName = fontName;
            this.ttcIndex = ttcIndex;
            this.axes = axes;
            this.weight = weight;
            this.isItalic = isItalic;
        }

        private void __constructor__(String string2, int n, List<Axis> list, int n2, boolean bl) {
            this.$$robo$$android_graphics_FontListParser_Font$__constructor__(string2, n, list, n2, bl);
        }

        Font(String string2, int n, List<Axis> list, int n2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser_Font$__constructor__(java.lang.String int java.util.List<android.graphics.FontListParser$Axis> int boolean ), 0, this, string2, n, list, n2, bl);
        }

        public /* synthetic */ Font() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Font)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Axis
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int tag;
        public float styleValue;

        private void $$robo$$android_graphics_FontListParser_Axis$__constructor__(int tag, float styleValue) {
            this.tag = tag;
            this.styleValue = styleValue;
        }

        private void __constructor__(int n, float f) {
            this.$$robo$$android_graphics_FontListParser_Axis$__constructor__(n, f);
        }

        Axis(int n, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser_Axis$__constructor__(int float ), 0, this, n, f);
        }

        public /* synthetic */ Axis() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Axis)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Config
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public List<Family> families;
        public List<Alias> aliases;

        private void $$robo$$android_graphics_FontListParser_Config$__constructor__() {
            this.families = new ArrayList<Family>();
            this.aliases = new ArrayList<Alias>();
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_FontListParser_Config$__constructor__();
        }

        Config() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_FontListParser_Config$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Config)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

