/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import javax.microedition.khronos.opengles.GL;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Canvas
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static boolean sCompatibilityRestore;
    protected long mNativeCanvasWrapper;
    private Bitmap mBitmap;
    private DrawFilter mDrawFilter;
    protected int mDensity;
    protected int mScreenDensity;
    private static int MAXMIMUM_BITMAP_SIZE = 32766;
    private static long NATIVE_ALLOCATION_SIZE = 525L;
    private Runnable mFinalizer;
    public static int MATRIX_SAVE_FLAG = 1;
    public static int CLIP_SAVE_FLAG = 2;
    public static int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static int ALL_SAVE_FLAG = 31;

    private final long $$robo$$android_graphics_Canvas$getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    private final boolean $$robo$$android_graphics_Canvas$isRecordingFor(Object o) {
        return false;
    }

    private void $$robo$$android_graphics_Canvas$__constructor__() {
        this.mDensity = 0;
        this.mScreenDensity = 0;
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.initRaster(null);
            this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        } else {
            this.mFinalizer = null;
        }
    }

    private void $$robo$$android_graphics_Canvas$__constructor__(Bitmap bitmap) {
        this.mDensity = 0;
        this.mScreenDensity = 0;
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        this.throwIfCannotDraw(bitmap);
        this.mNativeCanvasWrapper = Canvas.initRaster(bitmap);
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    private void $$robo$$android_graphics_Canvas$__constructor__(long nativeCanvas) {
        this.mDensity = 0;
        this.mScreenDensity = 0;
        if (nativeCanvas == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = nativeCanvas;
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Deprecated
    private final GL $$robo$$android_graphics_Canvas$getGL() {
        return null;
    }

    private final boolean $$robo$$android_graphics_Canvas$isHardwareAccelerated() {
        return false;
    }

    private final void $$robo$$android_graphics_Canvas$setBitmap(Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        if (bitmap == null) {
            Canvas.native_setBitmap(this.mNativeCanvasWrapper, null);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            this.throwIfCannotDraw(bitmap);
            Canvas.native_setBitmap(this.mNativeCanvasWrapper, bitmap);
            this.mDensity = bitmap.mDensity;
        }
        this.mBitmap = bitmap;
    }

    private final void $$robo$$android_graphics_Canvas$setHighContrastText(boolean highContrastText) {
        Canvas.native_setHighContrastText(this.mNativeCanvasWrapper, highContrastText);
    }

    private final void $$robo$$android_graphics_Canvas$insertReorderBarrier() {
    }

    private final void $$robo$$android_graphics_Canvas$insertInorderBarrier() {
    }

    private final boolean $$robo$$android_graphics_Canvas$isOpaque() {
        return Canvas.native_isOpaque(this.mNativeCanvasWrapper);
    }

    private final int $$robo$$android_graphics_Canvas$getWidth() {
        return Canvas.native_getWidth(this.mNativeCanvasWrapper);
    }

    private final int $$robo$$android_graphics_Canvas$getHeight() {
        return Canvas.native_getHeight(this.mNativeCanvasWrapper);
    }

    private final int $$robo$$android_graphics_Canvas$getDensity() {
        return this.mDensity;
    }

    private final void $$robo$$android_graphics_Canvas$setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    private final void $$robo$$android_graphics_Canvas$setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    private final int $$robo$$android_graphics_Canvas$getMaximumBitmapWidth() {
        return 32766;
    }

    private final int $$robo$$android_graphics_Canvas$getMaximumBitmapHeight() {
        return 32766;
    }

    private final int $$robo$$android_graphics_Canvas$save() {
        return Canvas.native_save(this.mNativeCanvasWrapper, 3);
    }

    private final int $$robo$$android_graphics_Canvas$save(int saveFlags) {
        return Canvas.native_save(this.mNativeCanvasWrapper, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(RectF bounds, Paint paint) {
        return this.saveLayer(bounds, paint, 31);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvasWrapper, left, top, right, bottom, paint != null ? paint.getNativeInstance() : 0L, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(float left, float top, float right, float bottom, Paint paint) {
        return this.saveLayer(left, top, right, bottom, paint, 31);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(RectF bounds, int alpha) {
        return this.saveLayerAlpha(bounds, alpha, 31);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvasWrapper, left, top, right, bottom, alpha, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(float left, float top, float right, float bottom, int alpha) {
        return this.saveLayerAlpha(left, top, right, bottom, alpha, 31);
    }

    private final void $$robo$$android_graphics_Canvas$restore() {
        boolean throwOnUnderflow = !sCompatibilityRestore || !this.isHardwareAccelerated();
        Canvas.native_restore(this.mNativeCanvasWrapper, throwOnUnderflow);
    }

    private final int $$robo$$android_graphics_Canvas$getSaveCount() {
        return Canvas.native_getSaveCount(this.mNativeCanvasWrapper);
    }

    private final void $$robo$$android_graphics_Canvas$restoreToCount(int saveCount) {
        boolean throwOnUnderflow = !sCompatibilityRestore || !this.isHardwareAccelerated();
        Canvas.native_restoreToCount(this.mNativeCanvasWrapper, saveCount, throwOnUnderflow);
    }

    private final void $$robo$$android_graphics_Canvas$translate(float dx, float dy) {
        Canvas.native_translate(this.mNativeCanvasWrapper, dx, dy);
    }

    private final void $$robo$$android_graphics_Canvas$scale(float sx, float sy) {
        Canvas.native_scale(this.mNativeCanvasWrapper, sx, sy);
    }

    private final void $$robo$$android_graphics_Canvas$scale(float sx, float sy, float px, float py) {
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    private final void $$robo$$android_graphics_Canvas$rotate(float degrees) {
        Canvas.native_rotate(this.mNativeCanvasWrapper, degrees);
    }

    private final void $$robo$$android_graphics_Canvas$rotate(float degrees, float px, float py) {
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    private final void $$robo$$android_graphics_Canvas$skew(float sx, float sy) {
        Canvas.native_skew(this.mNativeCanvasWrapper, sx, sy);
    }

    private final void $$robo$$android_graphics_Canvas$concat(Matrix matrix) {
        if (matrix != null) {
            Canvas.native_concat(this.mNativeCanvasWrapper, matrix.native_instance);
        }
    }

    private final void $$robo$$android_graphics_Canvas$setMatrix(Matrix matrix) {
        Canvas.native_setMatrix(this.mNativeCanvasWrapper, matrix == null ? 0L : matrix.native_instance);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$getMatrix(Matrix ctm) {
        Canvas.native_getCTM(this.mNativeCanvasWrapper, ctm.native_instance);
    }

    @Deprecated
    private final Matrix $$robo$$android_graphics_Canvas$getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(RectF rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(RectF rect) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(Rect rect) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, left, top, right, bottom, op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(float left, float top, float right, float bottom) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(int left, int top, int right, int bottom) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvasWrapper, path.ni(), op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvasWrapper, region.ni(), op.nativeInt);
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    private final DrawFilter $$robo$$android_graphics_Canvas$getDrawFilter() {
        return this.mDrawFilter;
    }

    private final void $$robo$$android_graphics_Canvas$setDrawFilter(DrawFilter filter) {
        long nativeFilter = 0L;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvasWrapper, nativeFilter);
    }

    private final boolean $$robo$$android_graphics_Canvas$quickReject(RectF rect, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    private final boolean $$robo$$android_graphics_Canvas$quickReject(Path path, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, path.ni());
    }

    private final boolean $$robo$$android_graphics_Canvas$quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    private final boolean $$robo$$android_graphics_Canvas$getClipBounds(Rect bounds) {
        return Canvas.native_getClipBounds(this.mNativeCanvasWrapper, bounds);
    }

    private final Rect $$robo$$android_graphics_Canvas$getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    private final void $$robo$$android_graphics_Canvas$drawRGB(int r, int g, int b) {
        this.drawColor(Color.rgb(r, g, b));
    }

    private final void $$robo$$android_graphics_Canvas$drawARGB(int a, int r, int g, int b) {
        this.drawColor(Color.argb(a, r, g, b));
    }

    private final void $$robo$$android_graphics_Canvas$drawColor(int color2) {
        Canvas.native_drawColor(this.mNativeCanvasWrapper, color2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    private final void $$robo$$android_graphics_Canvas$drawColor(int color2, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvasWrapper, color2, mode.nativeInt);
    }

    private final void $$robo$$android_graphics_Canvas$drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvasWrapper, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawPoints(float[] pts, int offset, int count, Paint paint) {
        Canvas.native_drawPoints(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPoint(float x, float y, Paint paint) {
        Canvas.native_drawPoint(this.mNativeCanvasWrapper, x, y, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvasWrapper, startX, startY, stopX, stopY, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawLines(float[] pts, int offset, int count, Paint paint) {
        Canvas.native_drawLines(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRect(RectF rect, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRect(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        this.drawOval(oval.left, oval.top, oval.right, oval.bottom, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawOval(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawOval(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawCircle(float cx, float cy, float radius, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvasWrapper, cx, cy, radius, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.drawArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        Canvas.native_drawArc(this.mNativeCanvasWrapper, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        Canvas.native_drawRoundRect(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawPath(Path path, Paint paint) {
        if (path.isSimplePath && path.rects != null) {
            Canvas.native_drawRegion(this.mNativeCanvasWrapper, path.rects.mNativeRegion, paint.getNativeInstance());
        } else {
            Canvas.native_drawPath(this.mNativeCanvasWrapper, path.ni(), paint.getNativeInstance());
        }
    }

    private final void $$robo$$android_graphics_Canvas$throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (!bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
    }

    private final void $$robo$$android_graphics_Canvas$drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        this.native_drawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    private final void $$robo$$android_graphics_Canvas$drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        this.native_drawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.throwIfCannotDraw(bitmap);
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, paint != null ? paint.getNativeInstance() : 0L, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        Canvas.native_drawBitmap(this.mNativeCanvasWrapper, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        Canvas.nativeDrawBitmapMatrix(this.mNativeCanvasWrapper, bitmap, matrix.ni(), paint != null ? paint.getNativeInstance() : 0L);
    }

    private static final void $$robo$$android_graphics_Canvas$checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, count);
        }
        Canvas.nativeDrawBitmapMesh(this.mNativeCanvasWrapper, bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.getNativeInstance() : 0L);
    }

    private final void $$robo$$android_graphics_Canvas$drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        Canvas.checkRange(verts.length, vertOffset, vertexCount);
        if (this.isHardwareAccelerated()) {
            return;
        }
        if (texs != null) {
            Canvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            Canvas.checkRange(indices.length, indexOffset, indexCount);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvasWrapper, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_Canvas$drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvasWrapper, text, index, count, x, y, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(String text, float x, float y, Paint paint) {
        Canvas.native_drawText(this.mNativeCanvasWrapper, text, 0, text.length(), x, y, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvasWrapper, text, start, end, x, y, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvasWrapper, text.toString(), start, end, x, y, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            Canvas.native_drawText(this.mNativeCanvasWrapper, buf, 0, end - start, x, y, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    private final void $$robo$$android_graphics_Canvas$drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | contextIndex | contextCount | index - contextIndex | contextIndex + contextCount - (index + count) | text.length - (contextIndex + contextCount)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawTextRun(this.mNativeCanvasWrapper, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.getNativeInstance(), paint.mNativeTypeface);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawTextRun(this.mNativeCanvasWrapper, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.getNativeInstance(), paint.mNativeTypeface);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            Canvas.native_drawTextRun(this.mNativeCanvasWrapper, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.getNativeInstance(), paint.mNativeTypeface);
            TemporaryBuffer.recycle(buf);
        }
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < count; ++i) {
            this.drawText(text, index + i, 1, pos[i * 2], pos[i * 2 + 1], paint);
        }
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawPosText(String text, float[] pos, Paint paint) {
        this.drawPosText(text.toCharArray(), 0, text.length(), pos, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawTextOnPath(this.mNativeCanvasWrapper, text, index, count, path.ni(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvasWrapper, text, path.ni(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance(), paint.mNativeTypeface);
        }
    }

    private final void $$robo$$android_graphics_Canvas$drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    private final void $$robo$$android_graphics_Canvas$drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    private final void $$robo$$android_graphics_Canvas$drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    private final void $$robo$$android_graphics_Canvas$release() {
        this.mNativeCanvasWrapper = 0L;
        if (this.mFinalizer != null) {
            this.mFinalizer.run();
            this.mFinalizer = null;
        }
    }

    private static final void $$robo$$android_graphics_Canvas$freeCaches() {
    }

    private static final void $$robo$$android_graphics_Canvas$freeTextLayoutCaches() {
    }

    private static final long $$robo$$android_graphics_Canvas$initRaster(Bitmap bitmap) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Canvas$native_setBitmap(long l, Bitmap bitmap) {
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_isOpaque(long l) {
        return false;
    }

    private static final void $$robo$$android_graphics_Canvas$native_setHighContrastText(long l, boolean bl) {
    }

    private static final int $$robo$$android_graphics_Canvas$native_getWidth(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Canvas$native_getHeight(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Canvas$native_save(long l, int n) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Canvas$native_saveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Canvas$native_saveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Canvas$native_restore(long l, boolean bl) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_restoreToCount(long l, int n, boolean bl) {
    }

    private static final int $$robo$$android_graphics_Canvas$native_getSaveCount(long l) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Canvas$native_translate(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_scale(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_rotate(long l, float f) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_skew(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_concat(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_setMatrix(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_clipRect(long l, float f, float f2, float f3, float f4, int n) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_clipPath(long l, long l2, int n) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_clipRegion(long l, long l2, int n) {
        return false;
    }

    private static final void $$robo$$android_graphics_Canvas$nativeSetDrawFilter(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_getClipBounds(long l, Rect rect) {
        return false;
    }

    private static final void $$robo$$android_graphics_Canvas$native_getCTM(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_quickReject(long l, long l2) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Canvas$native_quickReject(long l, float f, float f2, float f3, float f4) {
        return false;
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawColor(long l, int n, int n2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawPaint(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawPoint(long l, float f, float f2, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawPoints(long l, float[] fArray, int n, int n2, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawLine(long l, float f, float f2, float f3, float f4, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawLines(long l, float[] fArray, int n, int n2, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawRect(long l, float f, float f2, float f3, float f4, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawOval(long l, float f, float f2, float f3, float f4, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawCircle(long l, float f, float f2, float f3, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawPath(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawRegion(long l, long l2, long l3) {
    }

    private final void $$robo$$android_graphics_Canvas$native_drawNinePatch(long l, long l2, long l3, float f, float f2, float f3, float f4, long l4, int n, int n2) {
    }

    private final void $$robo$$android_graphics_Canvas$native_drawBitmap(long l, Bitmap bitmap, float f, float f2, long l2, int n, int n2, int n3) {
    }

    private final void $$robo$$android_graphics_Canvas$native_drawBitmap(long l, Bitmap bitmap, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l2, int n, int n2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$nativeDrawBitmapMatrix(long l, Bitmap bitmap, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Canvas$nativeDrawBitmapMesh(long l, Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$nativeDrawVertices(long l, int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int[] nArray, int n5, short[] sArray, int n6, int n7, long l2) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3, long l4) {
    }

    private static final void $$robo$$android_graphics_Canvas$native_drawTextOnPath(long l, String string2, long l2, float f, float f2, int n, long l3, long l4) {
    }

    private static final long $$robo$$android_graphics_Canvas$getNativeFinalizer() {
        return 0L;
    }

    static void __staticInitializer__() {
        sCompatibilityRestore = false;
    }

    public long getNativeCanvasWrapper() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeCanvasWrapper", $$robo$$android_graphics_Canvas$getNativeCanvasWrapper(), 0, this);
    }

    public boolean isRecordingFor(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecordingFor", $$robo$$android_graphics_Canvas$isRecordingFor(java.lang.Object ), 0, this, object);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Canvas$__constructor__();
    }

    public Canvas() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas$__constructor__(), 0, this);
    }

    private void __constructor__(Bitmap bitmap) {
        this.$$robo$$android_graphics_Canvas$__constructor__(bitmap);
    }

    public Canvas(Bitmap bitmap) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas$__constructor__(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_graphics_Canvas$__constructor__(l);
    }

    public Canvas(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas$__constructor__(long ), 0, this, l);
    }

    @Deprecated
    protected GL getGL() {
        return InvokeDynamicSupport.bootstrap("getGL", $$robo$$android_graphics_Canvas$getGL(), 0, this);
    }

    public boolean isHardwareAccelerated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareAccelerated", $$robo$$android_graphics_Canvas$isHardwareAccelerated(), 0, this);
    }

    public void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_graphics_Canvas$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void setHighContrastText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHighContrastText", $$robo$$android_graphics_Canvas$setHighContrastText(boolean ), 0, this, bl);
    }

    public void insertReorderBarrier() {
        InvokeDynamicSupport.bootstrap("insertReorderBarrier", $$robo$$android_graphics_Canvas$insertReorderBarrier(), 0, this);
    }

    public void insertInorderBarrier() {
        InvokeDynamicSupport.bootstrap("insertInorderBarrier", $$robo$$android_graphics_Canvas$insertInorderBarrier(), 0, this);
    }

    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_graphics_Canvas$isOpaque(), 0, this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_Canvas$getWidth(), 0, this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_Canvas$getHeight(), 0, this);
    }

    public int getDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_Canvas$getDensity(), 0, this);
    }

    public void setDensity(int n) {
        InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_Canvas$setDensity(int ), 0, this, n);
    }

    public void setScreenDensity(int n) {
        InvokeDynamicSupport.bootstrap("setScreenDensity", $$robo$$android_graphics_Canvas$setScreenDensity(int ), 0, this, n);
    }

    public int getMaximumBitmapWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumBitmapWidth", $$robo$$android_graphics_Canvas$getMaximumBitmapWidth(), 0, this);
    }

    public int getMaximumBitmapHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumBitmapHeight", $$robo$$android_graphics_Canvas$getMaximumBitmapHeight(), 0, this);
    }

    public int save() {
        return (int)InvokeDynamicSupport.bootstrap("save", $$robo$$android_graphics_Canvas$save(), 0, this);
    }

    public int save(int n) {
        return (int)InvokeDynamicSupport.bootstrap("save", $$robo$$android_graphics_Canvas$save(int ), 0, this, n);
    }

    public int saveLayer(RectF rectF, Paint paint, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(android.graphics.RectF android.graphics.Paint int ), 0, this, rectF, paint, n);
    }

    public int saveLayer(RectF rectF, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(android.graphics.RectF android.graphics.Paint ), 0, this, rectF, paint);
    }

    public int saveLayer(float f, float f2, float f3, float f4, Paint paint, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(float float float float android.graphics.Paint int ), 0, this, f, f2, f3, f4, paint, n);
    }

    public int saveLayer(float f, float f2, float f3, float f4, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    public int saveLayerAlpha(RectF rectF, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(android.graphics.RectF int int ), 0, this, rectF, n, n2);
    }

    public int saveLayerAlpha(RectF rectF, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(android.graphics.RectF int ), 0, this, rectF, n);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(float float float float int int ), 0, this, f, f2, f3, f4, n, n2);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(float float float float int ), 0, this, f, f2, f3, f4, n);
    }

    public void restore() {
        InvokeDynamicSupport.bootstrap("restore", $$robo$$android_graphics_Canvas$restore(), 0, this);
    }

    public int getSaveCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSaveCount", $$robo$$android_graphics_Canvas$getSaveCount(), 0, this);
    }

    public void restoreToCount(int n) {
        InvokeDynamicSupport.bootstrap("restoreToCount", $$robo$$android_graphics_Canvas$restoreToCount(int ), 0, this, n);
    }

    public void translate(float f, float f2) {
        InvokeDynamicSupport.bootstrap("translate", $$robo$$android_graphics_Canvas$translate(float float ), 0, this, f, f2);
    }

    public void scale(float f, float f2) {
        InvokeDynamicSupport.bootstrap("scale", $$robo$$android_graphics_Canvas$scale(float float ), 0, this, f, f2);
    }

    public void scale(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("scale", $$robo$$android_graphics_Canvas$scale(float float float float ), 0, this, f, f2, f3, f4);
    }

    public void rotate(float f) {
        InvokeDynamicSupport.bootstrap("rotate", $$robo$$android_graphics_Canvas$rotate(float ), 0, this, f);
    }

    public void rotate(float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("rotate", $$robo$$android_graphics_Canvas$rotate(float float float ), 0, this, f, f2, f3);
    }

    public void skew(float f, float f2) {
        InvokeDynamicSupport.bootstrap("skew", $$robo$$android_graphics_Canvas$skew(float float ), 0, this, f, f2);
    }

    public void concat(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("concat", $$robo$$android_graphics_Canvas$concat(android.graphics.Matrix ), 0, this, matrix);
    }

    public void setMatrix(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("setMatrix", $$robo$$android_graphics_Canvas$setMatrix(android.graphics.Matrix ), 0, this, matrix);
    }

    @Deprecated
    public void getMatrix(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("getMatrix", $$robo$$android_graphics_Canvas$getMatrix(android.graphics.Matrix ), 0, this, matrix);
    }

    @Deprecated
    public Matrix getMatrix() {
        return InvokeDynamicSupport.bootstrap("getMatrix", $$robo$$android_graphics_Canvas$getMatrix(), 0, this);
    }

    public boolean clipRect(RectF rectF, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.RectF android.graphics.Region$Op ), 0, this, rectF, op);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.Rect android.graphics.Region$Op ), 0, this, rect, op);
    }

    public boolean clipRect(RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.RectF ), 0, this, rectF);
    }

    public boolean clipRect(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.Rect ), 0, this, rect);
    }

    public boolean clipRect(float f, float f2, float f3, float f4, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(float float float float android.graphics.Region$Op ), 0, this, f, f2, f3, f4, op);
    }

    public boolean clipRect(float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(float float float float ), 0, this, f, f2, f3, f4);
    }

    public boolean clipRect(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipPath", $$robo$$android_graphics_Canvas$clipPath(android.graphics.Path android.graphics.Region$Op ), 0, this, path, op);
    }

    public boolean clipPath(Path path) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipPath", $$robo$$android_graphics_Canvas$clipPath(android.graphics.Path ), 0, this, path);
    }

    @Deprecated
    public boolean clipRegion(Region region, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRegion", $$robo$$android_graphics_Canvas$clipRegion(android.graphics.Region android.graphics.Region$Op ), 0, this, region, op);
    }

    @Deprecated
    public boolean clipRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRegion", $$robo$$android_graphics_Canvas$clipRegion(android.graphics.Region ), 0, this, region);
    }

    public DrawFilter getDrawFilter() {
        return InvokeDynamicSupport.bootstrap("getDrawFilter", $$robo$$android_graphics_Canvas$getDrawFilter(), 0, this);
    }

    public void setDrawFilter(DrawFilter drawFilter) {
        InvokeDynamicSupport.bootstrap("setDrawFilter", $$robo$$android_graphics_Canvas$setDrawFilter(android.graphics.DrawFilter ), 0, this, drawFilter);
    }

    public boolean quickReject(RectF rectF, EdgeType edgeType) {
        return (boolean)InvokeDynamicSupport.bootstrap("quickReject", $$robo$$android_graphics_Canvas$quickReject(android.graphics.RectF android.graphics.Canvas$EdgeType ), 0, this, rectF, edgeType);
    }

    public boolean quickReject(Path path, EdgeType edgeType) {
        return (boolean)InvokeDynamicSupport.bootstrap("quickReject", $$robo$$android_graphics_Canvas$quickReject(android.graphics.Path android.graphics.Canvas$EdgeType ), 0, this, path, edgeType);
    }

    public boolean quickReject(float f, float f2, float f3, float f4, EdgeType edgeType) {
        return (boolean)InvokeDynamicSupport.bootstrap("quickReject", $$robo$$android_graphics_Canvas$quickReject(float float float float android.graphics.Canvas$EdgeType ), 0, this, f, f2, f3, f4, edgeType);
    }

    public boolean getClipBounds(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getClipBounds", $$robo$$android_graphics_Canvas$getClipBounds(android.graphics.Rect ), 0, this, rect);
    }

    public Rect getClipBounds() {
        return InvokeDynamicSupport.bootstrap("getClipBounds", $$robo$$android_graphics_Canvas$getClipBounds(), 0, this);
    }

    public void drawRGB(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("drawRGB", $$robo$$android_graphics_Canvas$drawRGB(int int int ), 0, this, n, n2, n3);
    }

    public void drawARGB(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("drawARGB", $$robo$$android_graphics_Canvas$drawARGB(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void drawColor(int n) {
        InvokeDynamicSupport.bootstrap("drawColor", $$robo$$android_graphics_Canvas$drawColor(int ), 0, this, n);
    }

    public void drawColor(int n, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("drawColor", $$robo$$android_graphics_Canvas$drawColor(int android.graphics.PorterDuff$Mode ), 0, this, n, mode);
    }

    public void drawPaint(Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPaint", $$robo$$android_graphics_Canvas$drawPaint(android.graphics.Paint ), 0, this, paint);
    }

    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_Canvas$drawPoints(float[] int int android.graphics.Paint ), 0, this, fArray, n, n2, paint);
    }

    public void drawPoints(float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_Canvas$drawPoints(float[] android.graphics.Paint ), 0, this, fArray, paint);
    }

    public void drawPoint(float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoint", $$robo$$android_graphics_Canvas$drawPoint(float float android.graphics.Paint ), 0, this, f, f2, paint);
    }

    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLine", $$robo$$android_graphics_Canvas$drawLine(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLines", $$robo$$android_graphics_Canvas$drawLines(float[] int int android.graphics.Paint ), 0, this, fArray, n, n2, paint);
    }

    public void drawLines(float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLines", $$robo$$android_graphics_Canvas$drawLines(float[] android.graphics.Paint ), 0, this, fArray, paint);
    }

    public void drawRect(RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_Canvas$drawRect(android.graphics.RectF android.graphics.Paint ), 0, this, rectF, paint);
    }

    public void drawRect(Rect rect, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_Canvas$drawRect(android.graphics.Rect android.graphics.Paint ), 0, this, rect, paint);
    }

    public void drawRect(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_Canvas$drawRect(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    public void drawOval(RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$android_graphics_Canvas$drawOval(android.graphics.RectF android.graphics.Paint ), 0, this, rectF, paint);
    }

    public void drawOval(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$android_graphics_Canvas$drawOval(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    public void drawCircle(float f, float f2, float f3, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawCircle", $$robo$$android_graphics_Canvas$drawCircle(float float float android.graphics.Paint ), 0, this, f, f2, f3, paint);
    }

    public void drawArc(RectF rectF, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawArc", $$robo$$android_graphics_Canvas$drawArc(android.graphics.RectF float float boolean android.graphics.Paint ), 0, this, rectF, f, f2, bl, paint);
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawArc", $$robo$$android_graphics_Canvas$drawArc(float float float float float float boolean android.graphics.Paint ), 0, this, f, f2, f3, f4, f5, f6, bl, paint);
    }

    public void drawRoundRect(RectF rectF, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRoundRect", $$robo$$android_graphics_Canvas$drawRoundRect(android.graphics.RectF float float android.graphics.Paint ), 0, this, rectF, f, f2, paint);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRoundRect", $$robo$$android_graphics_Canvas$drawRoundRect(float float float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, f5, f6, paint);
    }

    public void drawPath(Path path, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPath", $$robo$$android_graphics_Canvas$drawPath(android.graphics.Path android.graphics.Paint ), 0, this, path, paint);
    }

    protected void throwIfCannotDraw(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("throwIfCannotDraw", $$robo$$android_graphics_Canvas$throwIfCannotDraw(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void drawPatch(NinePatch ninePatch, Rect rect, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPatch", $$robo$$android_graphics_Canvas$drawPatch(android.graphics.NinePatch android.graphics.Rect android.graphics.Paint ), 0, this, ninePatch, rect, paint);
    }

    public void drawPatch(NinePatch ninePatch, RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPatch", $$robo$$android_graphics_Canvas$drawPatch(android.graphics.NinePatch android.graphics.RectF android.graphics.Paint ), 0, this, ninePatch, rectF, paint);
    }

    public void drawBitmap(Bitmap bitmap, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap float float android.graphics.Paint ), 0, this, bitmap, f, f2, paint);
    }

    public void drawBitmap(Bitmap bitmap, Rect rect, RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap android.graphics.Rect android.graphics.RectF android.graphics.Paint ), 0, this, bitmap, rect, rectF, paint);
    }

    public void drawBitmap(Bitmap bitmap, Rect rect, Rect rect2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap android.graphics.Rect android.graphics.Rect android.graphics.Paint ), 0, this, bitmap, rect, rect2, paint);
    }

    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(int[] int int float float int int boolean android.graphics.Paint ), 0, this, nArray, n, n2, f, f2, n3, n4, bl, paint);
    }

    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(int[] int int int int int int boolean android.graphics.Paint ), 0, this, nArray, n, n2, n3, n4, n5, n6, bl, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap android.graphics.Matrix android.graphics.Paint ), 0, this, bitmap, matrix, paint);
    }

    protected static void checkRange(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("checkRange", $$robo$$android_graphics_Canvas$checkRange(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public void drawBitmapMesh(Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmapMesh", $$robo$$android_graphics_Canvas$drawBitmapMesh(android.graphics.Bitmap int int float[] int int[] int android.graphics.Paint ), 0, this, bitmap, n, n2, fArray, n3, nArray, n4, paint);
    }

    public void drawVertices(VertexMode vertexMode, int n, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, short[] sArray, int n5, int n6, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawVertices", $$robo$$android_graphics_Canvas$drawVertices(android.graphics.Canvas$VertexMode int float[] int float[] int int[] int short[] int int android.graphics.Paint ), 0, this, vertexMode, n, fArray, n2, fArray2, n3, nArray, n4, sArray, n5, n6, paint);
    }

    public void drawText(char[] cArray, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(char[] int int float float android.graphics.Paint ), 0, this, cArray, n, n2, f, f2, paint);
    }

    public void drawText(String string2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(java.lang.String float float android.graphics.Paint ), 0, this, string2, f, f2, paint);
    }

    public void drawText(String string2, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(java.lang.String int int float float android.graphics.Paint ), 0, this, string2, n, n2, f, f2, paint);
    }

    public void drawText(CharSequence charSequence, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(java.lang.CharSequence int int float float android.graphics.Paint ), 0, this, charSequence, n, n2, f, f2, paint);
    }

    public void drawTextRun(char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_graphics_Canvas$drawTextRun(char[] int int int int float float boolean android.graphics.Paint ), 0, this, cArray, n, n2, n3, n4, f, f2, bl, paint);
    }

    public void drawTextRun(CharSequence charSequence, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_graphics_Canvas$drawTextRun(java.lang.CharSequence int int int int float float boolean android.graphics.Paint ), 0, this, charSequence, n, n2, n3, n4, f, f2, bl, paint);
    }

    @Deprecated
    public void drawPosText(char[] cArray, int n, int n2, float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPosText", $$robo$$android_graphics_Canvas$drawPosText(char[] int int float[] android.graphics.Paint ), 0, this, cArray, n, n2, fArray, paint);
    }

    @Deprecated
    public void drawPosText(String string2, float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPosText", $$robo$$android_graphics_Canvas$drawPosText(java.lang.String float[] android.graphics.Paint ), 0, this, string2, fArray, paint);
    }

    public void drawTextOnPath(char[] cArray, int n, int n2, Path path, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextOnPath", $$robo$$android_graphics_Canvas$drawTextOnPath(char[] int int android.graphics.Path float float android.graphics.Paint ), 0, this, cArray, n, n2, path, f, f2, paint);
    }

    public void drawTextOnPath(String string2, Path path, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextOnPath", $$robo$$android_graphics_Canvas$drawTextOnPath(java.lang.String android.graphics.Path float float android.graphics.Paint ), 0, this, string2, path, f, f2, paint);
    }

    public void drawPicture(Picture picture) {
        InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Canvas$drawPicture(android.graphics.Picture ), 0, this, picture);
    }

    public void drawPicture(Picture picture, RectF rectF) {
        InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Canvas$drawPicture(android.graphics.Picture android.graphics.RectF ), 0, this, picture, rectF);
    }

    public void drawPicture(Picture picture, Rect rect) {
        InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Canvas$drawPicture(android.graphics.Picture android.graphics.Rect ), 0, this, picture, rect);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_graphics_Canvas$release(), 0, this);
    }

    private static final native /* synthetic */ void $$robo$$freeCaches$nativeBinding();

    public static void freeCaches() {
        InvokeDynamicSupport.bootstrapStatic("freeCaches", $$robo$$android_graphics_Canvas$freeCaches(), 1);
    }

    private static final native /* synthetic */ void $$robo$$freeTextLayoutCaches$nativeBinding();

    public static void freeTextLayoutCaches() {
        InvokeDynamicSupport.bootstrapStatic("freeTextLayoutCaches", $$robo$$android_graphics_Canvas$freeTextLayoutCaches(), 1);
    }

    private static final native /* synthetic */ long $$robo$$initRaster$nativeBinding(Bitmap var0);

    private static long initRaster(Bitmap bitmap) {
        return (long)InvokeDynamicSupport.bootstrapStatic("initRaster", $$robo$$android_graphics_Canvas$initRaster(android.graphics.Bitmap ), 1, (Bitmap)bitmap);
    }

    private static final native /* synthetic */ void $$robo$$native_setBitmap$nativeBinding(long var0, Bitmap var2);

    private static void native_setBitmap(long l, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrapStatic("native_setBitmap", $$robo$$android_graphics_Canvas$native_setBitmap(long android.graphics.Bitmap ), 1, (long)l, (Bitmap)bitmap);
    }

    private static final native /* synthetic */ boolean $$robo$$native_isOpaque$nativeBinding(long var0);

    private static boolean native_isOpaque(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_isOpaque", $$robo$$android_graphics_Canvas$native_isOpaque(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setHighContrastText$nativeBinding(long var0, boolean var2);

    private static void native_setHighContrastText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("native_setHighContrastText", $$robo$$android_graphics_Canvas$native_setHighContrastText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$native_getWidth$nativeBinding(long var0);

    private static int native_getWidth(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getWidth", $$robo$$android_graphics_Canvas$native_getWidth(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$native_getHeight$nativeBinding(long var0);

    private static int native_getHeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getHeight", $$robo$$android_graphics_Canvas$native_getHeight(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$native_save$nativeBinding(long var0, int var2);

    private static int native_save(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_save", $$robo$$android_graphics_Canvas$native_save(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$native_saveLayer$nativeBinding(long var0, float var2, float var3, float var4, float var5, long var6, int var8);

    private static int native_saveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_saveLayer", $$robo$$android_graphics_Canvas$native_saveLayer(long float float float float long int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$native_saveLayerAlpha$nativeBinding(long var0, float var2, float var3, float var4, float var5, int var6, int var7);

    private static int native_saveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_saveLayerAlpha", $$robo$$android_graphics_Canvas$native_saveLayerAlpha(long float float float float int int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$native_restore$nativeBinding(long var0, boolean var2);

    private static void native_restore(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("native_restore", $$robo$$android_graphics_Canvas$native_restore(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$native_restoreToCount$nativeBinding(long var0, int var2, boolean var3);

    private static void native_restoreToCount(long l, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("native_restoreToCount", $$robo$$android_graphics_Canvas$native_restoreToCount(long int boolean ), 1, (long)l, (int)n, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$native_getSaveCount$nativeBinding(long var0);

    private static int native_getSaveCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getSaveCount", $$robo$$android_graphics_Canvas$native_getSaveCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_translate$nativeBinding(long var0, float var2, float var3);

    private static void native_translate(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_translate", $$robo$$android_graphics_Canvas$native_translate(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_scale$nativeBinding(long var0, float var2, float var3);

    private static void native_scale(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_scale", $$robo$$android_graphics_Canvas$native_scale(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_rotate$nativeBinding(long var0, float var2);

    private static void native_rotate(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("native_rotate", $$robo$$android_graphics_Canvas$native_rotate(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$native_skew$nativeBinding(long var0, float var2, float var3);

    private static void native_skew(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_skew", $$robo$$android_graphics_Canvas$native_skew(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_concat$nativeBinding(long var0, long var2);

    private static void native_concat(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_concat", $$robo$$android_graphics_Canvas$native_concat(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_setMatrix$nativeBinding(long var0, long var2);

    private static void native_setMatrix(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_setMatrix", $$robo$$android_graphics_Canvas$native_setMatrix(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$native_clipRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, int var6);

    private static boolean native_clipRect(long l, float f, float f2, float f3, float f4, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_clipRect", $$robo$$android_graphics_Canvas$native_clipRect(long float float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$native_clipPath$nativeBinding(long var0, long var2, int var4);

    private static boolean native_clipPath(long l, long l2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_clipPath", $$robo$$android_graphics_Canvas$native_clipPath(long long int ), 1, (long)l, (long)l2, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$native_clipRegion$nativeBinding(long var0, long var2, int var4);

    private static boolean native_clipRegion(long l, long l2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_clipRegion", $$robo$$android_graphics_Canvas$native_clipRegion(long long int ), 1, (long)l, (long)l2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetDrawFilter$nativeBinding(long var0, long var2);

    private static void nativeSetDrawFilter(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDrawFilter", $$robo$$android_graphics_Canvas$nativeSetDrawFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$native_getClipBounds$nativeBinding(long var0, Rect var2);

    private static boolean native_getClipBounds(long l, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_getClipBounds", $$robo$$android_graphics_Canvas$native_getClipBounds(long android.graphics.Rect ), 1, (long)l, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$native_getCTM$nativeBinding(long var0, long var2);

    private static void native_getCTM(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_getCTM", $$robo$$android_graphics_Canvas$native_getCTM(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$native_quickReject$nativeBinding(long var0, long var2);

    private static boolean native_quickReject(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_quickReject", $$robo$$android_graphics_Canvas$native_quickReject(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$native_quickReject$nativeBinding(long var0, float var2, float var3, float var4, float var5);

    private static boolean native_quickReject(long l, float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_quickReject", $$robo$$android_graphics_Canvas$native_quickReject(long float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    private static final native /* synthetic */ void $$robo$$native_drawColor$nativeBinding(long var0, int var2, int var3);

    private static void native_drawColor(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawColor", $$robo$$android_graphics_Canvas$native_drawColor(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawPaint$nativeBinding(long var0, long var2);

    private static void native_drawPaint(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawPaint", $$robo$$android_graphics_Canvas$native_drawPaint(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawPoint$nativeBinding(long var0, float var2, float var3, long var4);

    private static void native_drawPoint(long l, float f, float f2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawPoint", $$robo$$android_graphics_Canvas$native_drawPoint(long float float long ), 1, (long)l, (float)f, (float)f2, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawPoints$nativeBinding(long var0, float[] var2, int var3, int var4, long var5);

    private static void native_drawPoints(long l, float[] fArray, int n, int n2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawPoints", $$robo$$android_graphics_Canvas$native_drawPoints(long float[] int int long ), 1, (long)l, (float[])fArray, (int)n, (int)n2, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawLine$nativeBinding(long var0, float var2, float var3, float var4, float var5, long var6);

    private static void native_drawLine(long l, float f, float f2, float f3, float f4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawLine", $$robo$$android_graphics_Canvas$native_drawLine(long float float float float long ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawLines$nativeBinding(long var0, float[] var2, int var3, int var4, long var5);

    private static void native_drawLines(long l, float[] fArray, int n, int n2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawLines", $$robo$$android_graphics_Canvas$native_drawLines(long float[] int int long ), 1, (long)l, (float[])fArray, (int)n, (int)n2, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, long var6);

    private static void native_drawRect(long l, float f, float f2, float f3, float f4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawRect", $$robo$$android_graphics_Canvas$native_drawRect(long float float float float long ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawOval$nativeBinding(long var0, float var2, float var3, float var4, float var5, long var6);

    private static void native_drawOval(long l, float f, float f2, float f3, float f4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawOval", $$robo$$android_graphics_Canvas$native_drawOval(long float float float float long ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawCircle$nativeBinding(long var0, float var2, float var3, float var4, long var5);

    private static void native_drawCircle(long l, float f, float f2, float f3, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawCircle", $$robo$$android_graphics_Canvas$native_drawCircle(long float float float long ), 1, (long)l, (float)f, (float)f2, (float)f3, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawArc$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, long var9);

    private static void native_drawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawArc", $$robo$$android_graphics_Canvas$native_drawArc(long float float float float float float boolean long ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (boolean)bl, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawRoundRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    private static void native_drawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawRoundRect", $$robo$$android_graphics_Canvas$native_drawRoundRect(long float float float float float float long ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawPath$nativeBinding(long var0, long var2, long var4);

    private static void native_drawPath(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_drawPath", $$robo$$android_graphics_Canvas$native_drawPath(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_drawRegion$nativeBinding(long var0, long var2, long var4);

    private static void native_drawRegion(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_drawRegion", $$robo$$android_graphics_Canvas$native_drawRegion(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private final native /* synthetic */ void $$robo$$native_drawNinePatch$nativeBinding(long var1, long var3, long var5, float var7, float var8, float var9, float var10, long var11, int var13, int var14);

    private void native_drawNinePatch(long l, long l2, long l3, float f, float f2, float f3, float f4, long l4, int n, int n2) {
        InvokeDynamicSupport.bootstrap("native_drawNinePatch", $$robo$$android_graphics_Canvas$native_drawNinePatch(long long long float float float float long int int ), 1, this, l, l2, l3, f, f2, f3, f4, l4, n, n2);
    }

    private final native /* synthetic */ void $$robo$$native_drawBitmap$nativeBinding(long var1, Bitmap var3, float var4, float var5, long var6, int var8, int var9, int var10);

    private void native_drawBitmap(long l, Bitmap bitmap, float f, float f2, long l2, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("native_drawBitmap", $$robo$$android_graphics_Canvas$native_drawBitmap(long android.graphics.Bitmap float float long int int int ), 1, this, l, bitmap, f, f2, l2, n, n2, n3);
    }

    private final native /* synthetic */ void $$robo$$native_drawBitmap$nativeBinding(long var1, Bitmap var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, long var12, int var14, int var15);

    private void native_drawBitmap(long l, Bitmap bitmap, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("native_drawBitmap", $$robo$$android_graphics_Canvas$native_drawBitmap(long android.graphics.Bitmap float float float float float float float float long int int ), 1, this, l, bitmap, f, f2, f3, f4, f5, f6, f7, f8, l2, n, n2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawBitmap$nativeBinding(long var0, int[] var2, int var3, int var4, float var5, float var6, int var7, int var8, boolean var9, long var10);

    private static void native_drawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_drawBitmap", $$robo$$android_graphics_Canvas$native_drawBitmap(long int[] int int float float int int boolean long ), 1, (long)l, (int[])nArray, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (int)n4, (boolean)bl, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nativeDrawBitmapMatrix$nativeBinding(long var0, Bitmap var2, long var3, long var5);

    private static void nativeDrawBitmapMatrix(long l, Bitmap bitmap, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nativeDrawBitmapMatrix", $$robo$$android_graphics_Canvas$nativeDrawBitmapMatrix(long android.graphics.Bitmap long long ), 1, (long)l, (Bitmap)bitmap, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$nativeDrawBitmapMesh$nativeBinding(long var0, Bitmap var2, int var3, int var4, float[] var5, int var6, int[] var7, int var8, long var9);

    private static void nativeDrawBitmapMesh(long l, Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeDrawBitmapMesh", $$robo$$android_graphics_Canvas$nativeDrawBitmapMesh(long android.graphics.Bitmap int int float[] int int[] int long ), 1, (long)l, (Bitmap)bitmap, (int)n, (int)n2, (float[])fArray, (int)n3, (int[])nArray, (int)n4, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nativeDrawVertices$nativeBinding(long var0, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int[] var8, int var9, short[] var10, int var11, int var12, long var13);

    private static void nativeDrawVertices(long l, int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int[] nArray, int n5, short[] sArray, int n6, int n7, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeDrawVertices", $$robo$$android_graphics_Canvas$nativeDrawVertices(long int int float[] int float[] int int[] int short[] int int long ), 1, (long)l, (int)n, (int)n2, (float[])fArray, (int)n3, (float[])fArray2, (int)n4, (int[])nArray, (int)n5, (short[])sArray, (int)n6, (int)n7, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_drawText$nativeBinding(long var0, char[] var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    private static void native_drawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_drawText", $$robo$$android_graphics_Canvas$native_drawText(long char[] int int float float int long long ), 1, (long)l, (char[])cArray, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_drawText$nativeBinding(long var0, String var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    private static void native_drawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_drawText", $$robo$$android_graphics_Canvas$native_drawText(long java.lang.String int int float float int long long ), 1, (long)l, (String)string2, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_drawTextRun$nativeBinding(long var0, String var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static void native_drawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_drawTextRun", $$robo$$android_graphics_Canvas$native_drawTextRun(long java.lang.String int int int int float float boolean long long ), 1, (long)l, (String)string2, (int)n, (int)n2, (int)n3, (int)n4, (float)f, (float)f2, (boolean)bl, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_drawTextRun$nativeBinding(long var0, char[] var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static void native_drawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_drawTextRun", $$robo$$android_graphics_Canvas$native_drawTextRun(long char[] int int int int float float boolean long long ), 1, (long)l, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4, (float)f, (float)f2, (boolean)bl, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_drawTextOnPath$nativeBinding(long var0, char[] var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10, long var12);

    private static void native_drawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3, long l4) {
        InvokeDynamicSupport.bootstrapStatic("native_drawTextOnPath", $$robo$$android_graphics_Canvas$native_drawTextOnPath(long char[] int int long float float int long long ), 1, (long)l, (char[])cArray, (int)n, (int)n2, (long)l2, (float)f, (float)f2, (int)n3, (long)l3, (long)l4);
    }

    private static final native /* synthetic */ void $$robo$$native_drawTextOnPath$nativeBinding(long var0, String var2, long var3, float var5, float var6, int var7, long var8, long var10);

    private static void native_drawTextOnPath(long l, String string2, long l2, float f, float f2, int n, long l3, long l4) {
        InvokeDynamicSupport.bootstrapStatic("native_drawTextOnPath", $$robo$$android_graphics_Canvas$native_drawTextOnPath(long java.lang.String long float float int long long ), 1, (long)l, (String)string2, (long)l2, (float)f, (float)f2, (int)n, (long)l3, (long)l4);
    }

    private static final native /* synthetic */ long $$robo$$getNativeFinalizer$nativeBinding();

    private static long getNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeFinalizer", $$robo$$android_graphics_Canvas$getNativeFinalizer(), 1);
    }

    static {
        RobolectricInternals.classInitializing(Canvas.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Canvas)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class VertexMode
    extends Enum<VertexMode> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ VertexMode TRIANGLES;
        public static /* enum */ VertexMode TRIANGLE_STRIP;
        public static /* enum */ VertexMode TRIANGLE_FAN;
        public int nativeInt;
        private static /* synthetic */ VertexMode[] $VALUES;

        private static final VertexMode[] $$robo$$android_graphics_Canvas_VertexMode$values() {
            return (VertexMode[])$VALUES.clone();
        }

        private static final VertexMode $$robo$$android_graphics_Canvas_VertexMode$valueOf(String name) {
            return Enum.valueOf(VertexMode.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Canvas_VertexMode$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            TRIANGLES = new VertexMode(0);
            TRIANGLE_STRIP = new VertexMode(1);
            TRIANGLE_FAN = new VertexMode(2);
            $VALUES = new VertexMode[]{TRIANGLES, TRIANGLE_STRIP, TRIANGLE_FAN};
        }

        public static VertexMode[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Canvas_VertexMode$values(), 0);
        }

        public static VertexMode valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Canvas_VertexMode$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Canvas_VertexMode$__constructor__(string2, n, n2);
        }

        private VertexMode(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas_VertexMode$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(VertexMode.class);
        }

        public /* synthetic */ VertexMode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VertexMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EdgeType
    extends Enum<EdgeType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ EdgeType BW;
        public static /* enum */ EdgeType AA;
        public int nativeInt;
        private static /* synthetic */ EdgeType[] $VALUES;

        private static final EdgeType[] $$robo$$android_graphics_Canvas_EdgeType$values() {
            return (EdgeType[])$VALUES.clone();
        }

        private static final EdgeType $$robo$$android_graphics_Canvas_EdgeType$valueOf(String name) {
            return Enum.valueOf(EdgeType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Canvas_EdgeType$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            BW = new EdgeType(0);
            AA = new EdgeType(1);
            $VALUES = new EdgeType[]{BW, AA};
        }

        public static EdgeType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Canvas_EdgeType$values(), 0);
        }

        public static EdgeType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Canvas_EdgeType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Canvas_EdgeType$__constructor__(string2, n, n2);
        }

        private EdgeType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas_EdgeType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(EdgeType.class);
        }

        public /* synthetic */ EdgeType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EdgeType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NoImagePreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static NativeAllocationRegistry sRegistry;

        private void $$robo$$android_graphics_Canvas_NoImagePreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            sRegistry = new NativeAllocationRegistry(Canvas.class.getClassLoader(), Canvas.getNativeFinalizer(), 525L);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Canvas_NoImagePreloadHolder$__constructor__();
        }

        private NoImagePreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas_NoImagePreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoImagePreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoImagePreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

