/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GestureUtils;
import android.gesture.Instance;
import android.gesture.InstanceLearner;
import android.gesture.Learner;
import android.gesture.Prediction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GestureStore
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int SEQUENCE_INVARIANT = 1;
    public static int SEQUENCE_SENSITIVE = 2;
    public static int ORIENTATION_INVARIANT = 1;
    public static int ORIENTATION_SENSITIVE = 2;
    static int ORIENTATION_SENSITIVE_4 = 4;
    static int ORIENTATION_SENSITIVE_8 = 8;
    private static short FILE_FORMAT_VERSION = 1;
    private static boolean PROFILE_LOADING_SAVING = false;
    private int mSequenceType;
    private int mOrientationStyle;
    private HashMap<String, ArrayList<Gesture>> mNamedGestures;
    private Learner mClassifier;
    private boolean mChanged;

    private void $$robo$$android_gesture_GestureStore$__constructor__() {
        this.mSequenceType = 2;
        this.mOrientationStyle = 2;
        this.mNamedGestures = new HashMap();
        this.mChanged = false;
        this.mClassifier = new InstanceLearner();
    }

    private final void $$robo$$android_gesture_GestureStore$setOrientationStyle(int style2) {
        this.mOrientationStyle = style2;
    }

    private final int $$robo$$android_gesture_GestureStore$getOrientationStyle() {
        return this.mOrientationStyle;
    }

    private final void $$robo$$android_gesture_GestureStore$setSequenceType(int type) {
        this.mSequenceType = type;
    }

    private final int $$robo$$android_gesture_GestureStore$getSequenceType() {
        return this.mSequenceType;
    }

    private final Set<String> $$robo$$android_gesture_GestureStore$getGestureEntries() {
        return this.mNamedGestures.keySet();
    }

    private final ArrayList<Prediction> $$robo$$android_gesture_GestureStore$recognize(Gesture gesture) {
        Instance instance = Instance.createInstance(this.mSequenceType, this.mOrientationStyle, gesture, null);
        return this.mClassifier.classify(this.mSequenceType, this.mOrientationStyle, instance.vector);
    }

    private final void $$robo$$android_gesture_GestureStore$addGesture(String entryName, Gesture gesture) {
        if (entryName == null || entryName.length() == 0) {
            return;
        }
        ArrayList<Gesture> gestures = this.mNamedGestures.get(entryName);
        if (gestures == null) {
            gestures = new ArrayList();
            this.mNamedGestures.put(entryName, gestures);
        }
        gestures.add(gesture);
        this.mClassifier.addInstance(Instance.createInstance(this.mSequenceType, this.mOrientationStyle, gesture, entryName));
        this.mChanged = true;
    }

    private final void $$robo$$android_gesture_GestureStore$removeGesture(String entryName, Gesture gesture) {
        ArrayList<Gesture> gestures = this.mNamedGestures.get(entryName);
        if (gestures == null) {
            return;
        }
        gestures.remove(gesture);
        if (gestures.isEmpty()) {
            this.mNamedGestures.remove(entryName);
        }
        this.mClassifier.removeInstance(gesture.getID());
        this.mChanged = true;
    }

    private final void $$robo$$android_gesture_GestureStore$removeEntry(String entryName) {
        this.mNamedGestures.remove(entryName);
        this.mClassifier.removeInstances(entryName);
        this.mChanged = true;
    }

    private final ArrayList<Gesture> $$robo$$android_gesture_GestureStore$getGestures(String entryName) {
        ArrayList<Gesture> gestures = this.mNamedGestures.get(entryName);
        if (gestures != null) {
            return new ArrayList<Gesture>(gestures);
        }
        return null;
    }

    private final boolean $$robo$$android_gesture_GestureStore$hasChanged() {
        return this.mChanged;
    }

    private final void $$robo$$android_gesture_GestureStore$save(OutputStream stream) throws IOException {
        this.save(stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_gesture_GestureStore$save(OutputStream stream, boolean closeStream) throws IOException {
        DataOutputStream out = null;
        try {
            HashMap<String, ArrayList<Gesture>> maps = this.mNamedGestures;
            out = new DataOutputStream(stream instanceof BufferedOutputStream ? stream : new BufferedOutputStream(stream, 32768));
            out.writeShort(1);
            out.writeInt(maps.size());
            for (Map.Entry<String, ArrayList<Gesture>> entry : maps.entrySet()) {
                String key = entry.getKey();
                ArrayList<Gesture> examples = entry.getValue();
                int count = examples.size();
                out.writeUTF(key);
                out.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    examples.get(i).serialize(out);
                }
            }
            out.flush();
            this.mChanged = false;
            if (!closeStream) return;
        }
        catch (Throwable throwable) {
            if (!closeStream) throw throwable;
            GestureUtils.closeStream(out);
            throw throwable;
        }
        GestureUtils.closeStream(out);
    }

    private final void $$robo$$android_gesture_GestureStore$load(InputStream stream) throws IOException {
        this.load(stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_gesture_GestureStore$load(InputStream stream, boolean closeStream) throws IOException {
        DataInputStream in = null;
        try {
            in = new DataInputStream(stream instanceof BufferedInputStream ? stream : new BufferedInputStream(stream, 32768));
            short versionNumber = in.readShort();
            switch (versionNumber) {
                case 1: {
                    this.readFormatV1(in);
                }
            }
            if (!closeStream) return;
        }
        catch (Throwable throwable) {
            if (!closeStream) throw throwable;
            GestureUtils.closeStream(in);
            throw throwable;
        }
        GestureUtils.closeStream(in);
    }

    private final void $$robo$$android_gesture_GestureStore$readFormatV1(DataInputStream in) throws IOException {
        Learner classifier = this.mClassifier;
        HashMap<String, ArrayList<Gesture>> namedGestures = this.mNamedGestures;
        namedGestures.clear();
        int entriesCount = in.readInt();
        for (int i = 0; i < entriesCount; ++i) {
            String name = in.readUTF();
            int gestureCount = in.readInt();
            ArrayList<Gesture> gestures = new ArrayList<Gesture>(gestureCount);
            for (int j = 0; j < gestureCount; ++j) {
                Gesture gesture = Gesture.deserialize(in);
                gestures.add(gesture);
                classifier.addInstance(Instance.createInstance(this.mSequenceType, this.mOrientationStyle, gesture, name));
            }
            namedGestures.put(name, gestures);
        }
    }

    private final Learner $$robo$$android_gesture_GestureStore$getLearner() {
        return this.mClassifier;
    }

    private void __constructor__() {
        this.$$robo$$android_gesture_GestureStore$__constructor__();
    }

    public GestureStore() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureStore$__constructor__(), 0, this);
    }

    public void setOrientationStyle(int n) {
        InvokeDynamicSupport.bootstrap("setOrientationStyle", $$robo$$android_gesture_GestureStore$setOrientationStyle(int ), 0, this, n);
    }

    public int getOrientationStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientationStyle", $$robo$$android_gesture_GestureStore$getOrientationStyle(), 0, this);
    }

    public void setSequenceType(int n) {
        InvokeDynamicSupport.bootstrap("setSequenceType", $$robo$$android_gesture_GestureStore$setSequenceType(int ), 0, this, n);
    }

    public int getSequenceType() {
        return (int)InvokeDynamicSupport.bootstrap("getSequenceType", $$robo$$android_gesture_GestureStore$getSequenceType(), 0, this);
    }

    public Set<String> getGestureEntries() {
        return InvokeDynamicSupport.bootstrap("getGestureEntries", $$robo$$android_gesture_GestureStore$getGestureEntries(), 0, this);
    }

    public ArrayList<Prediction> recognize(Gesture gesture) {
        return InvokeDynamicSupport.bootstrap("recognize", $$robo$$android_gesture_GestureStore$recognize(android.gesture.Gesture ), 0, this, gesture);
    }

    public void addGesture(String string2, Gesture gesture) {
        InvokeDynamicSupport.bootstrap("addGesture", $$robo$$android_gesture_GestureStore$addGesture(java.lang.String android.gesture.Gesture ), 0, this, string2, gesture);
    }

    public void removeGesture(String string2, Gesture gesture) {
        InvokeDynamicSupport.bootstrap("removeGesture", $$robo$$android_gesture_GestureStore$removeGesture(java.lang.String android.gesture.Gesture ), 0, this, string2, gesture);
    }

    public void removeEntry(String string2) {
        InvokeDynamicSupport.bootstrap("removeEntry", $$robo$$android_gesture_GestureStore$removeEntry(java.lang.String ), 0, this, string2);
    }

    public ArrayList<Gesture> getGestures(String string2) {
        return InvokeDynamicSupport.bootstrap("getGestures", $$robo$$android_gesture_GestureStore$getGestures(java.lang.String ), 0, this, string2);
    }

    public boolean hasChanged() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasChanged", $$robo$$android_gesture_GestureStore$hasChanged(), 0, this);
    }

    public void save(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("save", $$robo$$android_gesture_GestureStore$save(java.io.OutputStream ), 0, this, outputStream);
    }

    public void save(OutputStream outputStream, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrap("save", $$robo$$android_gesture_GestureStore$save(java.io.OutputStream boolean ), 0, this, outputStream, bl);
    }

    public void load(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("load", $$robo$$android_gesture_GestureStore$load(java.io.InputStream ), 0, this, inputStream);
    }

    public void load(InputStream inputStream, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrap("load", $$robo$$android_gesture_GestureStore$load(java.io.InputStream boolean ), 0, this, inputStream, bl);
    }

    private void readFormatV1(DataInputStream dataInputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("readFormatV1", $$robo$$android_gesture_GestureStore$readFormatV1(java.io.DataInputStream ), 0, this, dataInputStream);
    }

    Learner getLearner() {
        return InvokeDynamicSupport.bootstrap("getLearner", $$robo$$android_gesture_GestureStore$getLearner(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

