/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.content.res.TypedArray;
import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GestureOverlayView
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int GESTURE_STROKE_TYPE_SINGLE = 0;
    public static int GESTURE_STROKE_TYPE_MULTIPLE = 1;
    public static int ORIENTATION_HORIZONTAL = 0;
    public static int ORIENTATION_VERTICAL = 1;
    private static int FADE_ANIMATION_RATE = 16;
    private static boolean GESTURE_RENDERING_ANTIALIAS = true;
    private static boolean DITHER_FLAG = true;
    private Paint mGesturePaint;
    private long mFadeDuration;
    private long mFadeOffset;
    private long mFadingStart;
    private boolean mFadingHasStarted;
    private boolean mFadeEnabled;
    private int mCurrentColor;
    private int mCertainGestureColor;
    private int mUncertainGestureColor;
    private float mGestureStrokeWidth;
    private int mInvalidateExtraBorder;
    private int mGestureStrokeType;
    private float mGestureStrokeLengthThreshold;
    private float mGestureStrokeSquarenessTreshold;
    private float mGestureStrokeAngleThreshold;
    private int mOrientation;
    private Rect mInvalidRect;
    private Path mPath;
    private boolean mGestureVisible;
    private float mX;
    private float mY;
    private float mCurveEndX;
    private float mCurveEndY;
    private float mTotalLength;
    private boolean mIsGesturing;
    private boolean mPreviousWasGesturing;
    private boolean mInterceptEvents;
    private boolean mIsListeningForGestures;
    private boolean mResetGesture;
    private Gesture mCurrentGesture;
    private ArrayList<GesturePoint> mStrokeBuffer;
    private ArrayList<OnGestureListener> mOnGestureListeners;
    private ArrayList<OnGesturePerformedListener> mOnGesturePerformedListeners;
    private ArrayList<OnGesturingListener> mOnGesturingListeners;
    private boolean mHandleGestureActions;
    private boolean mIsFadingOut;
    private float mFadingAlpha;
    private AccelerateDecelerateInterpolator mInterpolator;
    private FadeOutRunnable mFadingOut;

    private void $$robo$$android_gesture_GestureOverlayView$__constructor__(Context context) {
        this.mGesturePaint = new Paint();
        this.mFadeDuration = 150L;
        this.mFadeOffset = 420L;
        this.mFadeEnabled = true;
        this.mCertainGestureColor = -256;
        this.mUncertainGestureColor = 1224736512;
        this.mGestureStrokeWidth = 12.0f;
        this.mInvalidateExtraBorder = 10;
        this.mGestureStrokeType = 0;
        this.mGestureStrokeLengthThreshold = 50.0f;
        this.mGestureStrokeSquarenessTreshold = 0.275f;
        this.mGestureStrokeAngleThreshold = 40.0f;
        this.mOrientation = 1;
        this.mInvalidRect = new Rect();
        this.mPath = new Path();
        this.mGestureVisible = true;
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mInterceptEvents = true;
        this.mStrokeBuffer = new ArrayList(100);
        this.mOnGestureListeners = new ArrayList();
        this.mOnGesturePerformedListeners = new ArrayList();
        this.mOnGesturingListeners = new ArrayList();
        this.mIsFadingOut = false;
        this.mFadingAlpha = 1.0f;
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.mFadingOut = new FadeOutRunnable(this);
        this.init();
    }

    private void $$robo$$android_gesture_GestureOverlayView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_gesture_GestureOverlayView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_gesture_GestureOverlayView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mGesturePaint = new Paint();
        this.mFadeDuration = 150L;
        this.mFadeOffset = 420L;
        this.mFadeEnabled = true;
        this.mCertainGestureColor = -256;
        this.mUncertainGestureColor = 1224736512;
        this.mGestureStrokeWidth = 12.0f;
        this.mInvalidateExtraBorder = 10;
        this.mGestureStrokeType = 0;
        this.mGestureStrokeLengthThreshold = 50.0f;
        this.mGestureStrokeSquarenessTreshold = 0.275f;
        this.mGestureStrokeAngleThreshold = 40.0f;
        this.mOrientation = 1;
        this.mInvalidRect = new Rect();
        this.mPath = new Path();
        this.mGestureVisible = true;
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mInterceptEvents = true;
        this.mStrokeBuffer = new ArrayList(100);
        this.mOnGestureListeners = new ArrayList();
        this.mOnGesturePerformedListeners = new ArrayList();
        this.mOnGesturingListeners = new ArrayList();
        this.mIsFadingOut = false;
        this.mFadingAlpha = 1.0f;
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.mFadingOut = new FadeOutRunnable(this);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GestureOverlayView, defStyleAttr, defStyleRes);
        this.mGestureStrokeWidth = a.getFloat(1, this.mGestureStrokeWidth);
        this.mInvalidateExtraBorder = Math.max(1, (int)this.mGestureStrokeWidth - 1);
        this.mCertainGestureColor = a.getColor(2, this.mCertainGestureColor);
        this.mUncertainGestureColor = a.getColor(3, this.mUncertainGestureColor);
        this.mFadeDuration = a.getInt(5, (int)this.mFadeDuration);
        this.mFadeOffset = a.getInt(4, (int)this.mFadeOffset);
        this.mGestureStrokeType = a.getInt(6, this.mGestureStrokeType);
        this.mGestureStrokeLengthThreshold = a.getFloat(7, this.mGestureStrokeLengthThreshold);
        this.mGestureStrokeAngleThreshold = a.getFloat(9, this.mGestureStrokeAngleThreshold);
        this.mGestureStrokeSquarenessTreshold = a.getFloat(8, this.mGestureStrokeSquarenessTreshold);
        this.mInterceptEvents = a.getBoolean(10, this.mInterceptEvents);
        this.mFadeEnabled = a.getBoolean(11, this.mFadeEnabled);
        this.mOrientation = a.getInt(0, this.mOrientation);
        a.recycle();
        this.init();
    }

    private final void $$robo$$android_gesture_GestureOverlayView$init() {
        this.setWillNotDraw(false);
        Paint gesturePaint = this.mGesturePaint;
        gesturePaint.setAntiAlias(true);
        gesturePaint.setColor(this.mCertainGestureColor);
        gesturePaint.setStyle(Paint.Style.STROKE);
        gesturePaint.setStrokeJoin(Paint.Join.ROUND);
        gesturePaint.setStrokeCap(Paint.Cap.ROUND);
        gesturePaint.setStrokeWidth(this.mGestureStrokeWidth);
        gesturePaint.setDither(true);
        this.mCurrentColor = this.mCertainGestureColor;
        this.setPaintAlpha(255);
    }

    private final ArrayList<GesturePoint> $$robo$$android_gesture_GestureOverlayView$getCurrentStroke() {
        return this.mStrokeBuffer;
    }

    private final int $$robo$$android_gesture_GestureOverlayView$getOrientation() {
        return this.mOrientation;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureColor(int color2) {
        this.mCertainGestureColor = color2;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setUncertainGestureColor(int color2) {
        this.mUncertainGestureColor = color2;
    }

    private final int $$robo$$android_gesture_GestureOverlayView$getUncertainGestureColor() {
        return this.mUncertainGestureColor;
    }

    private final int $$robo$$android_gesture_GestureOverlayView$getGestureColor() {
        return this.mCertainGestureColor;
    }

    private final float $$robo$$android_gesture_GestureOverlayView$getGestureStrokeWidth() {
        return this.mGestureStrokeWidth;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureStrokeWidth(float gestureStrokeWidth) {
        this.mGestureStrokeWidth = gestureStrokeWidth;
        this.mInvalidateExtraBorder = Math.max(1, (int)gestureStrokeWidth - 1);
        this.mGesturePaint.setStrokeWidth(gestureStrokeWidth);
    }

    private final int $$robo$$android_gesture_GestureOverlayView$getGestureStrokeType() {
        return this.mGestureStrokeType;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureStrokeType(int gestureStrokeType) {
        this.mGestureStrokeType = gestureStrokeType;
    }

    private final float $$robo$$android_gesture_GestureOverlayView$getGestureStrokeLengthThreshold() {
        return this.mGestureStrokeLengthThreshold;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureStrokeLengthThreshold(float gestureStrokeLengthThreshold) {
        this.mGestureStrokeLengthThreshold = gestureStrokeLengthThreshold;
    }

    private final float $$robo$$android_gesture_GestureOverlayView$getGestureStrokeSquarenessTreshold() {
        return this.mGestureStrokeSquarenessTreshold;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureStrokeSquarenessTreshold(float gestureStrokeSquarenessTreshold) {
        this.mGestureStrokeSquarenessTreshold = gestureStrokeSquarenessTreshold;
    }

    private final float $$robo$$android_gesture_GestureOverlayView$getGestureStrokeAngleThreshold() {
        return this.mGestureStrokeAngleThreshold;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureStrokeAngleThreshold(float gestureStrokeAngleThreshold) {
        this.mGestureStrokeAngleThreshold = gestureStrokeAngleThreshold;
    }

    private final boolean $$robo$$android_gesture_GestureOverlayView$isEventsInterceptionEnabled() {
        return this.mInterceptEvents;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setEventsInterceptionEnabled(boolean enabled) {
        this.mInterceptEvents = enabled;
    }

    private final boolean $$robo$$android_gesture_GestureOverlayView$isFadeEnabled() {
        return this.mFadeEnabled;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setFadeEnabled(boolean fadeEnabled) {
        this.mFadeEnabled = fadeEnabled;
    }

    private final Gesture $$robo$$android_gesture_GestureOverlayView$getGesture() {
        return this.mCurrentGesture;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGesture(Gesture gesture) {
        if (this.mCurrentGesture != null) {
            this.clear(false);
        }
        this.setCurrentColor(this.mCertainGestureColor);
        this.mCurrentGesture = gesture;
        Path path = this.mCurrentGesture.toPath();
        RectF bounds = new RectF();
        path.computeBounds(bounds, true);
        this.mPath.rewind();
        this.mPath.addPath(path, -bounds.left + ((float)this.getWidth() - bounds.width()) / 2.0f, -bounds.top + ((float)this.getHeight() - bounds.height()) / 2.0f);
        this.mResetGesture = true;
        this.invalidate();
    }

    private final Path $$robo$$android_gesture_GestureOverlayView$getGesturePath() {
        return this.mPath;
    }

    private final Path $$robo$$android_gesture_GestureOverlayView$getGesturePath(Path path) {
        path.set(this.mPath);
        return path;
    }

    private final boolean $$robo$$android_gesture_GestureOverlayView$isGestureVisible() {
        return this.mGestureVisible;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setGestureVisible(boolean visible) {
        this.mGestureVisible = visible;
    }

    private final long $$robo$$android_gesture_GestureOverlayView$getFadeOffset() {
        return this.mFadeOffset;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setFadeOffset(long fadeOffset) {
        this.mFadeOffset = fadeOffset;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$addOnGestureListener(OnGestureListener listener) {
        this.mOnGestureListeners.add(listener);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$removeOnGestureListener(OnGestureListener listener) {
        this.mOnGestureListeners.remove(listener);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$removeAllOnGestureListeners() {
        this.mOnGestureListeners.clear();
    }

    private final void $$robo$$android_gesture_GestureOverlayView$addOnGesturePerformedListener(OnGesturePerformedListener listener) {
        this.mOnGesturePerformedListeners.add(listener);
        if (this.mOnGesturePerformedListeners.size() > 0) {
            this.mHandleGestureActions = true;
        }
    }

    private final void $$robo$$android_gesture_GestureOverlayView$removeOnGesturePerformedListener(OnGesturePerformedListener listener) {
        this.mOnGesturePerformedListeners.remove(listener);
        if (this.mOnGesturePerformedListeners.size() <= 0) {
            this.mHandleGestureActions = false;
        }
    }

    private final void $$robo$$android_gesture_GestureOverlayView$removeAllOnGesturePerformedListeners() {
        this.mOnGesturePerformedListeners.clear();
        this.mHandleGestureActions = false;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$addOnGesturingListener(OnGesturingListener listener) {
        this.mOnGesturingListeners.add(listener);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$removeOnGesturingListener(OnGesturingListener listener) {
        this.mOnGesturingListeners.remove(listener);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$removeAllOnGesturingListeners() {
        this.mOnGesturingListeners.clear();
    }

    private final boolean $$robo$$android_gesture_GestureOverlayView$isGesturing() {
        return this.mIsGesturing;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setCurrentColor(int color2) {
        this.mCurrentColor = color2;
        if (this.mFadingHasStarted) {
            this.setPaintAlpha((int)(255.0f * this.mFadingAlpha));
        } else {
            this.setPaintAlpha(255);
        }
        this.invalidate();
    }

    private final Paint $$robo$$android_gesture_GestureOverlayView$getGesturePaint() {
        return this.mGesturePaint;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mCurrentGesture != null && this.mGestureVisible) {
            canvas.drawPath(this.mPath, this.mGesturePaint);
        }
    }

    private final void $$robo$$android_gesture_GestureOverlayView$setPaintAlpha(int alpha) {
        alpha += alpha >> 7;
        int baseAlpha = this.mCurrentColor >>> 24;
        int useAlpha = baseAlpha * alpha >> 8;
        this.mGesturePaint.setColor(this.mCurrentColor << 8 >>> 8 | useAlpha << 24);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$clear(boolean animated) {
        this.clear(animated, false, true);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$clear(boolean animated, boolean fireActionPerformed, boolean immediate) {
        this.setPaintAlpha(255);
        this.removeCallbacks(this.mFadingOut);
        this.mResetGesture = false;
        this.mFadingOut.fireActionPerformed = fireActionPerformed;
        this.mFadingOut.resetMultipleStrokes = false;
        if (animated && this.mCurrentGesture != null) {
            this.mFadingAlpha = 1.0f;
            this.mIsFadingOut = true;
            this.mFadingHasStarted = false;
            this.mFadingStart = AnimationUtils.currentAnimationTimeMillis() + this.mFadeOffset;
            this.postDelayed(this.mFadingOut, this.mFadeOffset);
        } else {
            this.mFadingAlpha = 1.0f;
            this.mIsFadingOut = false;
            this.mFadingHasStarted = false;
            if (immediate) {
                this.mCurrentGesture = null;
                this.mPath.rewind();
                this.invalidate();
            } else if (fireActionPerformed) {
                this.postDelayed(this.mFadingOut, this.mFadeOffset);
            } else if (this.mGestureStrokeType == 1) {
                this.mFadingOut.resetMultipleStrokes = true;
                this.postDelayed(this.mFadingOut, this.mFadeOffset);
            } else {
                this.mCurrentGesture = null;
                this.mPath.rewind();
                this.invalidate();
            }
        }
    }

    private final void $$robo$$android_gesture_GestureOverlayView$cancelClearAnimation() {
        this.setPaintAlpha(255);
        this.mIsFadingOut = false;
        this.mFadingHasStarted = false;
        this.removeCallbacks(this.mFadingOut);
        this.mPath.rewind();
        this.mCurrentGesture = null;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$cancelGesture() {
        this.mIsListeningForGestures = false;
        this.mCurrentGesture.addStroke(new GestureStroke(this.mStrokeBuffer));
        long now = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
        ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).onGestureCancelled(this, event);
        }
        event.recycle();
        this.clear(false);
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mStrokeBuffer.clear();
        ArrayList<OnGesturingListener> otherListeners = this.mOnGesturingListeners;
        count = otherListeners.size();
        for (int i = 0; i < count; ++i) {
            otherListeners.get(i).onGesturingEnded(this);
        }
    }

    private final void $$robo$$android_gesture_GestureOverlayView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelClearAnimation();
    }

    private final boolean $$robo$$android_gesture_GestureOverlayView$dispatchTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            boolean cancelDispatch = (this.mIsGesturing || this.mCurrentGesture != null && this.mCurrentGesture.getStrokesCount() > 0 && this.mPreviousWasGesturing) && this.mInterceptEvents;
            this.processEvent(event);
            if (cancelDispatch) {
                event.setAction(3);
            }
            super.dispatchTouchEvent(event);
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    private final boolean $$robo$$android_gesture_GestureOverlayView$processEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchDown(event);
                this.invalidate();
                return true;
            }
            case 2: {
                if (!this.mIsListeningForGestures) break;
                Rect rect = this.touchMove(event);
                if (rect != null) {
                    this.invalidate(rect);
                }
                return true;
            }
            case 1: {
                if (!this.mIsListeningForGestures) break;
                this.touchUp(event, false);
                this.invalidate();
                return true;
            }
            case 3: {
                if (!this.mIsListeningForGestures) break;
                this.touchUp(event, true);
                this.invalidate();
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$touchDown(MotionEvent event) {
        this.mIsListeningForGestures = true;
        float x = event.getX();
        float y = event.getY();
        this.mX = x;
        this.mY = y;
        this.mTotalLength = 0.0f;
        this.mIsGesturing = false;
        if (this.mGestureStrokeType == 0 || this.mResetGesture) {
            if (this.mHandleGestureActions) {
                this.setCurrentColor(this.mUncertainGestureColor);
            }
            this.mResetGesture = false;
            this.mCurrentGesture = null;
            this.mPath.rewind();
        } else if ((this.mCurrentGesture == null || this.mCurrentGesture.getStrokesCount() == 0) && this.mHandleGestureActions) {
            this.setCurrentColor(this.mUncertainGestureColor);
        }
        if (this.mFadingHasStarted) {
            this.cancelClearAnimation();
        } else if (this.mIsFadingOut) {
            this.setPaintAlpha(255);
            this.mIsFadingOut = false;
            this.mFadingHasStarted = false;
            this.removeCallbacks(this.mFadingOut);
        }
        if (this.mCurrentGesture == null) {
            this.mCurrentGesture = new Gesture();
        }
        this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
        this.mPath.moveTo(x, y);
        int border = this.mInvalidateExtraBorder;
        this.mInvalidRect.set((int)x - border, (int)y - border, (int)x + border, (int)y + border);
        this.mCurveEndX = x;
        this.mCurveEndY = y;
        ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).onGestureStarted(this, event);
        }
    }

    private final Rect $$robo$$android_gesture_GestureOverlayView$touchMove(MotionEvent event) {
        Rect areaToRefresh = null;
        float x = event.getX();
        float y = event.getY();
        float previousX = this.mX;
        float previousY = this.mY;
        float dx = Math.abs(x - previousX);
        float dy = Math.abs(y - previousY);
        if (dx >= 3.0f || dy >= 3.0f) {
            areaToRefresh = this.mInvalidRect;
            int border = this.mInvalidateExtraBorder;
            areaToRefresh.set((int)this.mCurveEndX - border, (int)this.mCurveEndY - border, (int)this.mCurveEndX + border, (int)this.mCurveEndY + border);
            float cX = this.mCurveEndX = (x + previousX) / 2.0f;
            float cY = this.mCurveEndY = (y + previousY) / 2.0f;
            this.mPath.quadTo(previousX, previousY, cX, cY);
            areaToRefresh.union((int)previousX - border, (int)previousY - border, (int)previousX + border, (int)previousY + border);
            areaToRefresh.union((int)cX - border, (int)cY - border, (int)cX + border, (int)cY + border);
            this.mX = x;
            this.mY = y;
            this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
            if (this.mHandleGestureActions && !this.mIsGesturing) {
                this.mTotalLength += (float)Math.hypot(dx, dy);
                if (this.mTotalLength > this.mGestureStrokeLengthThreshold) {
                    OrientedBoundingBox box = GestureUtils.computeOrientedBoundingBox(this.mStrokeBuffer);
                    float angle = Math.abs(box.orientation);
                    if (angle > 90.0f) {
                        angle = 180.0f - angle;
                    }
                    if (box.squareness > this.mGestureStrokeSquarenessTreshold || (this.mOrientation == 1 ? angle < this.mGestureStrokeAngleThreshold : angle > this.mGestureStrokeAngleThreshold)) {
                        this.mIsGesturing = true;
                        this.setCurrentColor(this.mCertainGestureColor);
                        ArrayList<OnGesturingListener> listeners = this.mOnGesturingListeners;
                        int count = listeners.size();
                        for (int i = 0; i < count; ++i) {
                            listeners.get(i).onGesturingStarted(this);
                        }
                    }
                }
            }
            ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.get(i).onGesture(this, event);
            }
        }
        return areaToRefresh;
    }

    private final void $$robo$$android_gesture_GestureOverlayView$touchUp(MotionEvent event, boolean cancel) {
        int i;
        int count;
        ArrayList<Object> listeners;
        this.mIsListeningForGestures = false;
        if (this.mCurrentGesture != null) {
            this.mCurrentGesture.addStroke(new GestureStroke(this.mStrokeBuffer));
            if (!cancel) {
                listeners = this.mOnGestureListeners;
                count = listeners.size();
                for (i = 0; i < count; ++i) {
                    ((OnGestureListener)listeners.get(i)).onGestureEnded(this, event);
                }
                this.clear(this.mHandleGestureActions && this.mFadeEnabled, this.mHandleGestureActions && this.mIsGesturing, false);
            } else {
                this.cancelGesture(event);
            }
        } else {
            this.cancelGesture(event);
        }
        this.mStrokeBuffer.clear();
        this.mPreviousWasGesturing = this.mIsGesturing;
        this.mIsGesturing = false;
        listeners = this.mOnGesturingListeners;
        count = listeners.size();
        for (i = 0; i < count; ++i) {
            ((OnGesturingListener)listeners.get(i)).onGesturingEnded(this);
        }
    }

    private final void $$robo$$android_gesture_GestureOverlayView$cancelGesture(MotionEvent event) {
        ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).onGestureCancelled(this, event);
        }
        this.clear(false);
    }

    private final void $$robo$$android_gesture_GestureOverlayView$fireOnGesturePerformed() {
        ArrayList<OnGesturePerformedListener> actionListeners = this.mOnGesturePerformedListeners;
        int count = actionListeners.size();
        for (int i = 0; i < count; ++i) {
            actionListeners.get(i).onGesturePerformed(this, this.mCurrentGesture);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_gesture_GestureOverlayView$__constructor__(context);
    }

    public GestureOverlayView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureOverlayView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_gesture_GestureOverlayView$__constructor__(context, attributeSet);
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 18219034);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureOverlayView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_gesture_GestureOverlayView$__constructor__(context, attributeSet, n);
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureOverlayView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_gesture_GestureOverlayView$__constructor__(context, attributeSet, n, n2);
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureOverlayView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_gesture_GestureOverlayView$init(), 0, this);
    }

    public ArrayList<GesturePoint> getCurrentStroke() {
        return InvokeDynamicSupport.bootstrap("getCurrentStroke", $$robo$$android_gesture_GestureOverlayView$getCurrentStroke(), 0, this);
    }

    public int getOrientation() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_gesture_GestureOverlayView$getOrientation(), 0, this);
    }

    public void setOrientation(int n) {
        InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$android_gesture_GestureOverlayView$setOrientation(int ), 0, this, n);
    }

    public void setGestureColor(int n) {
        InvokeDynamicSupport.bootstrap("setGestureColor", $$robo$$android_gesture_GestureOverlayView$setGestureColor(int ), 0, this, n);
    }

    public void setUncertainGestureColor(int n) {
        InvokeDynamicSupport.bootstrap("setUncertainGestureColor", $$robo$$android_gesture_GestureOverlayView$setUncertainGestureColor(int ), 0, this, n);
    }

    public int getUncertainGestureColor() {
        return (int)InvokeDynamicSupport.bootstrap("getUncertainGestureColor", $$robo$$android_gesture_GestureOverlayView$getUncertainGestureColor(), 0, this);
    }

    public int getGestureColor() {
        return (int)InvokeDynamicSupport.bootstrap("getGestureColor", $$robo$$android_gesture_GestureOverlayView$getGestureColor(), 0, this);
    }

    public float getGestureStrokeWidth() {
        return (float)InvokeDynamicSupport.bootstrap("getGestureStrokeWidth", $$robo$$android_gesture_GestureOverlayView$getGestureStrokeWidth(), 0, this);
    }

    public void setGestureStrokeWidth(float f) {
        InvokeDynamicSupport.bootstrap("setGestureStrokeWidth", $$robo$$android_gesture_GestureOverlayView$setGestureStrokeWidth(float ), 0, this, f);
    }

    public int getGestureStrokeType() {
        return (int)InvokeDynamicSupport.bootstrap("getGestureStrokeType", $$robo$$android_gesture_GestureOverlayView$getGestureStrokeType(), 0, this);
    }

    public void setGestureStrokeType(int n) {
        InvokeDynamicSupport.bootstrap("setGestureStrokeType", $$robo$$android_gesture_GestureOverlayView$setGestureStrokeType(int ), 0, this, n);
    }

    public float getGestureStrokeLengthThreshold() {
        return (float)InvokeDynamicSupport.bootstrap("getGestureStrokeLengthThreshold", $$robo$$android_gesture_GestureOverlayView$getGestureStrokeLengthThreshold(), 0, this);
    }

    public void setGestureStrokeLengthThreshold(float f) {
        InvokeDynamicSupport.bootstrap("setGestureStrokeLengthThreshold", $$robo$$android_gesture_GestureOverlayView$setGestureStrokeLengthThreshold(float ), 0, this, f);
    }

    public float getGestureStrokeSquarenessTreshold() {
        return (float)InvokeDynamicSupport.bootstrap("getGestureStrokeSquarenessTreshold", $$robo$$android_gesture_GestureOverlayView$getGestureStrokeSquarenessTreshold(), 0, this);
    }

    public void setGestureStrokeSquarenessTreshold(float f) {
        InvokeDynamicSupport.bootstrap("setGestureStrokeSquarenessTreshold", $$robo$$android_gesture_GestureOverlayView$setGestureStrokeSquarenessTreshold(float ), 0, this, f);
    }

    public float getGestureStrokeAngleThreshold() {
        return (float)InvokeDynamicSupport.bootstrap("getGestureStrokeAngleThreshold", $$robo$$android_gesture_GestureOverlayView$getGestureStrokeAngleThreshold(), 0, this);
    }

    public void setGestureStrokeAngleThreshold(float f) {
        InvokeDynamicSupport.bootstrap("setGestureStrokeAngleThreshold", $$robo$$android_gesture_GestureOverlayView$setGestureStrokeAngleThreshold(float ), 0, this, f);
    }

    public boolean isEventsInterceptionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEventsInterceptionEnabled", $$robo$$android_gesture_GestureOverlayView$isEventsInterceptionEnabled(), 0, this);
    }

    public void setEventsInterceptionEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEventsInterceptionEnabled", $$robo$$android_gesture_GestureOverlayView$setEventsInterceptionEnabled(boolean ), 0, this, bl);
    }

    public boolean isFadeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFadeEnabled", $$robo$$android_gesture_GestureOverlayView$isFadeEnabled(), 0, this);
    }

    public void setFadeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFadeEnabled", $$robo$$android_gesture_GestureOverlayView$setFadeEnabled(boolean ), 0, this, bl);
    }

    public Gesture getGesture() {
        return InvokeDynamicSupport.bootstrap("getGesture", $$robo$$android_gesture_GestureOverlayView$getGesture(), 0, this);
    }

    public void setGesture(Gesture gesture) {
        InvokeDynamicSupport.bootstrap("setGesture", $$robo$$android_gesture_GestureOverlayView$setGesture(android.gesture.Gesture ), 0, this, gesture);
    }

    public Path getGesturePath() {
        return InvokeDynamicSupport.bootstrap("getGesturePath", $$robo$$android_gesture_GestureOverlayView$getGesturePath(), 0, this);
    }

    public Path getGesturePath(Path path) {
        return InvokeDynamicSupport.bootstrap("getGesturePath", $$robo$$android_gesture_GestureOverlayView$getGesturePath(android.graphics.Path ), 0, this, path);
    }

    public boolean isGestureVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGestureVisible", $$robo$$android_gesture_GestureOverlayView$isGestureVisible(), 0, this);
    }

    public void setGestureVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGestureVisible", $$robo$$android_gesture_GestureOverlayView$setGestureVisible(boolean ), 0, this, bl);
    }

    public long getFadeOffset() {
        return (long)InvokeDynamicSupport.bootstrap("getFadeOffset", $$robo$$android_gesture_GestureOverlayView$getFadeOffset(), 0, this);
    }

    public void setFadeOffset(long l) {
        InvokeDynamicSupport.bootstrap("setFadeOffset", $$robo$$android_gesture_GestureOverlayView$setFadeOffset(long ), 0, this, l);
    }

    public void addOnGestureListener(OnGestureListener onGestureListener) {
        InvokeDynamicSupport.bootstrap("addOnGestureListener", $$robo$$android_gesture_GestureOverlayView$addOnGestureListener(android.gesture.GestureOverlayView$OnGestureListener ), 0, this, onGestureListener);
    }

    public void removeOnGestureListener(OnGestureListener onGestureListener) {
        InvokeDynamicSupport.bootstrap("removeOnGestureListener", $$robo$$android_gesture_GestureOverlayView$removeOnGestureListener(android.gesture.GestureOverlayView$OnGestureListener ), 0, this, onGestureListener);
    }

    public void removeAllOnGestureListeners() {
        InvokeDynamicSupport.bootstrap("removeAllOnGestureListeners", $$robo$$android_gesture_GestureOverlayView$removeAllOnGestureListeners(), 0, this);
    }

    public void addOnGesturePerformedListener(OnGesturePerformedListener onGesturePerformedListener) {
        InvokeDynamicSupport.bootstrap("addOnGesturePerformedListener", $$robo$$android_gesture_GestureOverlayView$addOnGesturePerformedListener(android.gesture.GestureOverlayView$OnGesturePerformedListener ), 0, this, onGesturePerformedListener);
    }

    public void removeOnGesturePerformedListener(OnGesturePerformedListener onGesturePerformedListener) {
        InvokeDynamicSupport.bootstrap("removeOnGesturePerformedListener", $$robo$$android_gesture_GestureOverlayView$removeOnGesturePerformedListener(android.gesture.GestureOverlayView$OnGesturePerformedListener ), 0, this, onGesturePerformedListener);
    }

    public void removeAllOnGesturePerformedListeners() {
        InvokeDynamicSupport.bootstrap("removeAllOnGesturePerformedListeners", $$robo$$android_gesture_GestureOverlayView$removeAllOnGesturePerformedListeners(), 0, this);
    }

    public void addOnGesturingListener(OnGesturingListener onGesturingListener) {
        InvokeDynamicSupport.bootstrap("addOnGesturingListener", $$robo$$android_gesture_GestureOverlayView$addOnGesturingListener(android.gesture.GestureOverlayView$OnGesturingListener ), 0, this, onGesturingListener);
    }

    public void removeOnGesturingListener(OnGesturingListener onGesturingListener) {
        InvokeDynamicSupport.bootstrap("removeOnGesturingListener", $$robo$$android_gesture_GestureOverlayView$removeOnGesturingListener(android.gesture.GestureOverlayView$OnGesturingListener ), 0, this, onGesturingListener);
    }

    public void removeAllOnGesturingListeners() {
        InvokeDynamicSupport.bootstrap("removeAllOnGesturingListeners", $$robo$$android_gesture_GestureOverlayView$removeAllOnGesturingListeners(), 0, this);
    }

    public boolean isGesturing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGesturing", $$robo$$android_gesture_GestureOverlayView$isGesturing(), 0, this);
    }

    private void setCurrentColor(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentColor", $$robo$$android_gesture_GestureOverlayView$setCurrentColor(int ), 0, this, n);
    }

    public Paint getGesturePaint() {
        return InvokeDynamicSupport.bootstrap("getGesturePaint", $$robo$$android_gesture_GestureOverlayView$getGesturePaint(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_gesture_GestureOverlayView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void setPaintAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setPaintAlpha", $$robo$$android_gesture_GestureOverlayView$setPaintAlpha(int ), 0, this, n);
    }

    public void clear(boolean bl) {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_gesture_GestureOverlayView$clear(boolean ), 0, this, bl);
    }

    private void clear(boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_gesture_GestureOverlayView$clear(boolean boolean boolean ), 0, this, bl, bl2, bl3);
    }

    public void cancelClearAnimation() {
        InvokeDynamicSupport.bootstrap("cancelClearAnimation", $$robo$$android_gesture_GestureOverlayView$cancelClearAnimation(), 0, this);
    }

    public void cancelGesture() {
        InvokeDynamicSupport.bootstrap("cancelGesture", $$robo$$android_gesture_GestureOverlayView$cancelGesture(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_gesture_GestureOverlayView$onDetachedFromWindow(), 0, this);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_gesture_GestureOverlayView$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean processEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("processEvent", $$robo$$android_gesture_GestureOverlayView$processEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void touchDown(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("touchDown", $$robo$$android_gesture_GestureOverlayView$touchDown(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private Rect touchMove(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrap("touchMove", $$robo$$android_gesture_GestureOverlayView$touchMove(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void touchUp(MotionEvent motionEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("touchUp", $$robo$$android_gesture_GestureOverlayView$touchUp(android.view.MotionEvent boolean ), 0, this, motionEvent, bl);
    }

    private void cancelGesture(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("cancelGesture", $$robo$$android_gesture_GestureOverlayView$cancelGesture(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void fireOnGesturePerformed() {
        InvokeDynamicSupport.bootstrap("fireOnGesturePerformed", $$robo$$android_gesture_GestureOverlayView$fireOnGesturePerformed(), 0, this);
    }

    public /* synthetic */ GestureOverlayView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureOverlayView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnGesturePerformedListener
    extends InstrumentedInterface {
        public void onGesturePerformed(GestureOverlayView var1, Gesture var2);
    }

    public static interface OnGestureListener
    extends InstrumentedInterface {
        public void onGestureStarted(GestureOverlayView var1, MotionEvent var2);

        public void onGesture(GestureOverlayView var1, MotionEvent var2);

        public void onGestureEnded(GestureOverlayView var1, MotionEvent var2);

        public void onGestureCancelled(GestureOverlayView var1, MotionEvent var2);
    }

    public static interface OnGesturingListener
    extends InstrumentedInterface {
        public void onGesturingStarted(GestureOverlayView var1);

        public void onGesturingEnded(GestureOverlayView var1);
    }

    private class FadeOutRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean fireActionPerformed;
        boolean resetMultipleStrokes;
        /* synthetic */ GestureOverlayView this$0;

        private void $$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$__constructor__(GestureOverlayView gestureOverlayView) {
        }

        private final void $$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$run() {
            if (this.this$0.mIsFadingOut) {
                long now = AnimationUtils.currentAnimationTimeMillis();
                long duration = now - this.this$0.mFadingStart;
                if (duration > this.this$0.mFadeDuration) {
                    if (this.fireActionPerformed) {
                        this.this$0.fireOnGesturePerformed();
                    }
                    this.this$0.mPreviousWasGesturing = false;
                    this.this$0.mIsFadingOut = false;
                    this.this$0.mFadingHasStarted = false;
                    this.this$0.mPath.rewind();
                    this.this$0.mCurrentGesture = null;
                    this.this$0.setPaintAlpha(255);
                } else {
                    this.this$0.mFadingHasStarted = true;
                    float interpolatedTime = Math.max(0.0f, Math.min(1.0f, (float)duration / (float)this.this$0.mFadeDuration));
                    this.this$0.mFadingAlpha = 1.0f - this.this$0.mInterpolator.getInterpolation(interpolatedTime);
                    this.this$0.setPaintAlpha((int)(255.0f * this.this$0.mFadingAlpha));
                    this.this$0.postDelayed(this, 16L);
                }
            } else if (this.resetMultipleStrokes) {
                this.this$0.mResetGesture = true;
            } else {
                this.this$0.fireOnGesturePerformed();
                this.this$0.mFadingHasStarted = false;
                this.this$0.mPath.rewind();
                this.this$0.mCurrentGesture = null;
                this.this$0.mPreviousWasGesturing = false;
                this.this$0.setPaintAlpha(255);
            }
            this.this$0.invalidate();
        }

        private /* synthetic */ void $$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$__constructor__(GestureOverlayView x0, 1 x1) {
        }

        private void __constructor__(GestureOverlayView gestureOverlayView) {
            this.$$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$__constructor__(gestureOverlayView);
        }

        private FadeOutRunnable(GestureOverlayView gestureOverlayView) {
            this.this$0 = gestureOverlayView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$__constructor__(android.gesture.GestureOverlayView ), 0, this, gestureOverlayView);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(GestureOverlayView gestureOverlayView, 1 var2_2) {
            this.$$robo$$android_gesture_GestureOverlayView_FadeOutRunnable$__constructor__(gestureOverlayView, var2_2);
        }

        public /* synthetic */ FadeOutRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FadeOutRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

