/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.gesture.GestureLibrary;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class GestureLibraries
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_gesture_GestureLibraries$__constructor__() {
    }

    private static final GestureLibrary $$robo$$android_gesture_GestureLibraries$fromFile(String path) {
        return GestureLibraries.fromFile(new File(path));
    }

    private static final GestureLibrary $$robo$$android_gesture_GestureLibraries$fromFile(File path) {
        return new FileGestureLibrary(path);
    }

    private static final GestureLibrary $$robo$$android_gesture_GestureLibraries$fromPrivateFile(Context context, String name) {
        return GestureLibraries.fromFile(context.getFileStreamPath(name));
    }

    private static final GestureLibrary $$robo$$android_gesture_GestureLibraries$fromRawResource(Context context, int resourceId) {
        return new ResourceGestureLibrary(context, resourceId);
    }

    private void __constructor__() {
        this.$$robo$$android_gesture_GestureLibraries$__constructor__();
    }

    private GestureLibraries() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureLibraries$__constructor__(), 0, this);
    }

    public static GestureLibrary fromFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromFile", $$robo$$android_gesture_GestureLibraries$fromFile(java.lang.String ), 0, (String)string2);
    }

    public static GestureLibrary fromFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("fromFile", $$robo$$android_gesture_GestureLibraries$fromFile(java.io.File ), 0, (File)file);
    }

    public static GestureLibrary fromPrivateFile(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromPrivateFile", $$robo$$android_gesture_GestureLibraries$fromPrivateFile(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static GestureLibrary fromRawResource(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromRawResource", $$robo$$android_gesture_GestureLibraries$fromRawResource(android.content.Context int ), 0, (Context)context, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureLibraries)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ResourceGestureLibrary
    extends GestureLibrary
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<Context> mContext;
        private int mResourceId;

        private void $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$__constructor__(Context context, int resourceId) {
            this.mContext = new WeakReference<Context>(context);
            this.mResourceId = resourceId;
        }

        private final boolean $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$isReadOnly() {
            return true;
        }

        private final boolean $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$save() {
            return false;
        }

        private final boolean $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$load() {
            boolean result = false;
            Context context = (Context)this.mContext.get();
            if (context != null) {
                InputStream in = context.getResources().openRawResource(this.mResourceId);
                try {
                    this.mStore.load(in, true);
                    result = true;
                }
                catch (IOException e) {
                    Log.d("Gestures", "Could not load the gesture library from raw resource " + context.getResources().getResourceName(this.mResourceId), e);
                }
            }
            return result;
        }

        private void __constructor__(Context context, int n) {
            this.$$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$__constructor__(context, n);
        }

        public ResourceGestureLibrary(Context context, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$__constructor__(android.content.Context int ), 0, this, context, n);
        }

        @Override
        public boolean isReadOnly() {
            return (boolean)InvokeDynamicSupport.bootstrap("isReadOnly", $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$isReadOnly(), 0, this);
        }

        @Override
        public boolean save() {
            return (boolean)InvokeDynamicSupport.bootstrap("save", $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$save(), 0, this);
        }

        @Override
        public boolean load() {
            return (boolean)InvokeDynamicSupport.bootstrap("load", $$robo$$android_gesture_GestureLibraries_ResourceGestureLibrary$load(), 0, this);
        }

        public /* synthetic */ ResourceGestureLibrary() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceGestureLibrary)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FileGestureLibrary
    extends GestureLibrary
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File mPath;

        private void $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$__constructor__(File path) {
            this.mPath = path;
        }

        private final boolean $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$isReadOnly() {
            return !this.mPath.canWrite();
        }

        private final boolean $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$save() {
            if (!this.mStore.hasChanged()) {
                return true;
            }
            File file = this.mPath;
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                return false;
            }
            boolean result = false;
            try {
                file.createNewFile();
                this.mStore.save(new FileOutputStream(file), true);
                result = true;
            }
            catch (FileNotFoundException e) {
                Log.d("Gestures", "Could not save the gesture library in " + this.mPath, e);
            }
            catch (IOException e) {
                Log.d("Gestures", "Could not save the gesture library in " + this.mPath, e);
            }
            return result;
        }

        private final boolean $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$load() {
            boolean result = false;
            File file = this.mPath;
            if (file.exists() && file.canRead()) {
                try {
                    this.mStore.load(new FileInputStream(file), true);
                    result = true;
                }
                catch (FileNotFoundException e) {
                    Log.d("Gestures", "Could not load the gesture library from " + this.mPath, e);
                }
                catch (IOException e) {
                    Log.d("Gestures", "Could not load the gesture library from " + this.mPath, e);
                }
            }
            return result;
        }

        private void __constructor__(File file) {
            this.$$robo$$android_gesture_GestureLibraries_FileGestureLibrary$__constructor__(file);
        }

        public FileGestureLibrary(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$__constructor__(java.io.File ), 0, this, file);
        }

        @Override
        public boolean isReadOnly() {
            return (boolean)InvokeDynamicSupport.bootstrap("isReadOnly", $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$isReadOnly(), 0, this);
        }

        @Override
        public boolean save() {
            return (boolean)InvokeDynamicSupport.bootstrap("save", $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$save(), 0, this);
        }

        @Override
        public boolean load() {
            return (boolean)InvokeDynamicSupport.bootstrap("load", $$robo$$android_gesture_GestureLibraries_FileGestureLibrary$load(), 0, this);
        }

        public /* synthetic */ FileGestureLibrary() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileGestureLibrary)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

