/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Gesture
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long GESTURE_ID_BASE;
    private static int BITMAP_RENDERING_WIDTH = 2;
    private static boolean BITMAP_RENDERING_ANTIALIAS = true;
    private static boolean BITMAP_RENDERING_DITHER = true;
    private static AtomicInteger sGestureCount;
    private RectF mBoundingBox;
    private long mGestureID;
    private ArrayList<GestureStroke> mStrokes;
    public static Parcelable.Creator<Gesture> CREATOR;

    private void $$robo$$android_gesture_Gesture$__constructor__() {
        this.mBoundingBox = new RectF();
        this.mStrokes = new ArrayList();
        this.mGestureID = GESTURE_ID_BASE + (long)sGestureCount.incrementAndGet();
    }

    private final Object $$robo$$android_gesture_Gesture$clone() {
        Gesture gesture = new Gesture();
        gesture.mBoundingBox.set(this.mBoundingBox.left, this.mBoundingBox.top, this.mBoundingBox.right, this.mBoundingBox.bottom);
        int count = this.mStrokes.size();
        for (int i = 0; i < count; ++i) {
            GestureStroke stroke = this.mStrokes.get(i);
            gesture.mStrokes.add((GestureStroke)stroke.clone());
        }
        return gesture;
    }

    private final ArrayList<GestureStroke> $$robo$$android_gesture_Gesture$getStrokes() {
        return this.mStrokes;
    }

    private final int $$robo$$android_gesture_Gesture$getStrokesCount() {
        return this.mStrokes.size();
    }

    private final void $$robo$$android_gesture_Gesture$addStroke(GestureStroke stroke) {
        this.mStrokes.add(stroke);
        this.mBoundingBox.union(stroke.boundingBox);
    }

    private final float $$robo$$android_gesture_Gesture$getLength() {
        int len = 0;
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            len = (int)((float)len + strokes.get((int)i).length);
        }
        return len;
    }

    private final RectF $$robo$$android_gesture_Gesture$getBoundingBox() {
        return this.mBoundingBox;
    }

    private final Path $$robo$$android_gesture_Gesture$toPath() {
        return this.toPath(null);
    }

    private final Path $$robo$$android_gesture_Gesture$toPath(Path path) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            path.addPath(strokes.get(i).getPath());
        }
        return path;
    }

    private final Path $$robo$$android_gesture_Gesture$toPath(int width, int height, int edge, int numSample) {
        return this.toPath(null, width, height, edge, numSample);
    }

    private final Path $$robo$$android_gesture_Gesture$toPath(Path path, int width, int height, int edge, int numSample) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            path.addPath(strokes.get(i).toPath(width - 2 * edge, height - 2 * edge, numSample));
        }
        return path;
    }

    private final void $$robo$$android_gesture_Gesture$setID(long id2) {
        this.mGestureID = id2;
    }

    private final long $$robo$$android_gesture_Gesture$getID() {
        return this.mGestureID;
    }

    private final Bitmap $$robo$$android_gesture_Gesture$toBitmap(int width, int height, int edge, int numSample, int color2) {
        Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(edge, edge);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(color2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(2.0f);
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        for (int i = 0; i < count; ++i) {
            Path path = strokes.get(i).toPath(width - 2 * edge, height - 2 * edge, numSample);
            canvas.drawPath(path, paint);
        }
        return bitmap;
    }

    private final Bitmap $$robo$$android_gesture_Gesture$toBitmap(int width, int height, int inset, int color2) {
        Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(color2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(2.0f);
        Path path = this.toPath();
        RectF bounds = new RectF();
        path.computeBounds(bounds, true);
        float sx = (float)(width - 2 * inset) / bounds.width();
        float sy = (float)(height - 2 * inset) / bounds.height();
        float scale = sx > sy ? sy : sx;
        paint.setStrokeWidth(2.0f / scale);
        path.offset(-bounds.left + ((float)width - bounds.width() * scale) / 2.0f, -bounds.top + ((float)height - bounds.height() * scale) / 2.0f);
        canvas.translate(inset, inset);
        canvas.scale(scale, scale);
        canvas.drawPath(path, paint);
        return bitmap;
    }

    private final void $$robo$$android_gesture_Gesture$serialize(DataOutputStream out) throws IOException {
        ArrayList<GestureStroke> strokes = this.mStrokes;
        int count = strokes.size();
        out.writeLong(this.mGestureID);
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            strokes.get(i).serialize(out);
        }
    }

    private static final Gesture $$robo$$android_gesture_Gesture$deserialize(DataInputStream in) throws IOException {
        Gesture gesture = new Gesture();
        gesture.mGestureID = in.readLong();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            gesture.addStroke(GestureStroke.deserialize(in));
        }
        return gesture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_gesture_Gesture$writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mGestureID);
        boolean result = false;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(32768);
        DataOutputStream outStream = new DataOutputStream(byteStream);
        try {
            this.serialize(outStream);
            result = true;
        }
        catch (IOException e) {
            Log.e("Gestures", "Error writing Gesture to parcel:", e);
        }
        finally {
            GestureUtils.closeStream(outStream);
            GestureUtils.closeStream(byteStream);
        }
        if (result) {
            out.writeByteArray(byteStream.toByteArray());
        }
    }

    private final int $$robo$$android_gesture_Gesture$describeContents() {
        return 0;
    }

    static void __staticInitializer__() {
        GESTURE_ID_BASE = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        sGestureCount = new AtomicInteger(0);
        CREATOR = new Parcelable.Creator<Gesture>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_gesture_Gesture_1$__constructor__() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Gesture $$robo$$android_gesture_Gesture_1$createFromParcel(Parcel in) {
                Gesture gesture = null;
                long gestureID = in.readLong();
                DataInputStream inStream = new DataInputStream(new ByteArrayInputStream(in.createByteArray()));
                try {
                    gesture = Gesture.deserialize(inStream);
                }
                catch (IOException e) {
                    Log.e("Gestures", "Error reading Gesture from parcel:", e);
                }
                finally {
                    GestureUtils.closeStream(inStream);
                }
                if (gesture != null) {
                    gesture.mGestureID = gestureID;
                }
                return gesture;
            }

            private final Gesture[] $$robo$$android_gesture_Gesture_1$newArray(int size) {
                return new Gesture[size];
            }

            private void __constructor__() {
                this.$$robo$$android_gesture_Gesture_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_Gesture_1$__constructor__(), 0, this);
            }

            @Override
            public Gesture createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_gesture_Gesture_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Gesture[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_gesture_Gesture_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_gesture_Gesture$__constructor__();
    }

    public Gesture() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_Gesture$__constructor__(), 0, this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_gesture_Gesture$clone(), 0, this);
    }

    public ArrayList<GestureStroke> getStrokes() {
        return InvokeDynamicSupport.bootstrap("getStrokes", $$robo$$android_gesture_Gesture$getStrokes(), 0, this);
    }

    public int getStrokesCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStrokesCount", $$robo$$android_gesture_Gesture$getStrokesCount(), 0, this);
    }

    public void addStroke(GestureStroke gestureStroke) {
        InvokeDynamicSupport.bootstrap("addStroke", $$robo$$android_gesture_Gesture$addStroke(android.gesture.GestureStroke ), 0, this, gestureStroke);
    }

    public float getLength() {
        return (float)InvokeDynamicSupport.bootstrap("getLength", $$robo$$android_gesture_Gesture$getLength(), 0, this);
    }

    public RectF getBoundingBox() {
        return InvokeDynamicSupport.bootstrap("getBoundingBox", $$robo$$android_gesture_Gesture$getBoundingBox(), 0, this);
    }

    public Path toPath() {
        return InvokeDynamicSupport.bootstrap("toPath", $$robo$$android_gesture_Gesture$toPath(), 0, this);
    }

    public Path toPath(Path path) {
        return InvokeDynamicSupport.bootstrap("toPath", $$robo$$android_gesture_Gesture$toPath(android.graphics.Path ), 0, this, path);
    }

    public Path toPath(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("toPath", $$robo$$android_gesture_Gesture$toPath(int int int int ), 0, this, n, n2, n3, n4);
    }

    public Path toPath(Path path, int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("toPath", $$robo$$android_gesture_Gesture$toPath(android.graphics.Path int int int int ), 0, this, path, n, n2, n3, n4);
    }

    void setID(long l) {
        InvokeDynamicSupport.bootstrap("setID", $$robo$$android_gesture_Gesture$setID(long ), 0, this, l);
    }

    public long getID() {
        return (long)InvokeDynamicSupport.bootstrap("getID", $$robo$$android_gesture_Gesture$getID(), 0, this);
    }

    public Bitmap toBitmap(int n, int n2, int n3, int n4, int n5) {
        return InvokeDynamicSupport.bootstrap("toBitmap", $$robo$$android_gesture_Gesture$toBitmap(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public Bitmap toBitmap(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("toBitmap", $$robo$$android_gesture_Gesture$toBitmap(int int int int ), 0, this, n, n2, n3, n4);
    }

    void serialize(DataOutputStream dataOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("serialize", $$robo$$android_gesture_Gesture$serialize(java.io.DataOutputStream ), 0, this, dataOutputStream);
    }

    static Gesture deserialize(DataInputStream dataInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("deserialize", $$robo$$android_gesture_Gesture$deserialize(java.io.DataInputStream ), 0, (DataInputStream)dataInputStream);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_gesture_Gesture$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_gesture_Gesture$describeContents(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Gesture.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Gesture)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

