/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.io;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterFactory;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.ProtocolException;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.GraphReader;
import android.filterfw.io.PatternScanner;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextGraphReader
extends GraphReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ArrayList<Command> mCommands;
    private Filter mCurrentFilter;
    private FilterGraph mCurrentGraph;
    private KeyValueMap mBoundReferences;
    private KeyValueMap mSettings;
    private FilterFactory mFactory;

    private void $$robo$$android_filterfw_io_TextGraphReader$__constructor__() {
        this.mCommands = new ArrayList();
    }

    private final FilterGraph $$robo$$android_filterfw_io_TextGraphReader$readGraphString(String graphString) throws GraphIOException {
        FilterGraph result = new FilterGraph();
        this.reset();
        this.mCurrentGraph = result;
        this.parseString(graphString);
        this.applySettings();
        this.executeCommands();
        this.reset();
        return result;
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$reset() {
        this.mCurrentGraph = null;
        this.mCurrentFilter = null;
        this.mCommands.clear();
        this.mBoundReferences = new KeyValueMap();
        this.mSettings = new KeyValueMap();
        this.mFactory = new FilterFactory();
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$parseString(String graphString) throws GraphIOException {
        Pattern commandPattern = Pattern.compile("@[a-zA-Z]+");
        Pattern curlyClosePattern = Pattern.compile("\\}");
        Pattern curlyOpenPattern = Pattern.compile("\\{");
        Pattern ignorePattern = Pattern.compile("(\\s+|//[^\\n]*\\n)+");
        Pattern packageNamePattern = Pattern.compile("[a-zA-Z\\.]+");
        Pattern libraryNamePattern = Pattern.compile("[a-zA-Z\\./:]+");
        Pattern portPattern = Pattern.compile("\\[[a-zA-Z0-9\\-_]+\\]");
        Pattern rightArrowPattern = Pattern.compile("=>");
        Pattern semicolonPattern = Pattern.compile(";");
        Pattern wordPattern = Pattern.compile("[a-zA-Z0-9\\-_]+");
        boolean STATE_COMMAND = false;
        boolean STATE_IMPORT_PKG = true;
        int STATE_ADD_LIBRARY = 2;
        int STATE_FILTER_CLASS = 3;
        int STATE_FILTER_NAME = 4;
        int STATE_CURLY_OPEN = 5;
        int STATE_PARAMETERS = 6;
        int STATE_CURLY_CLOSE = 7;
        int STATE_SOURCE_FILTERNAME = 8;
        int STATE_SOURCE_PORT = 9;
        int STATE_RIGHT_ARROW = 10;
        int STATE_TARGET_FILTERNAME = 11;
        int STATE_TARGET_PORT = 12;
        int STATE_ASSIGNMENT = 13;
        int STATE_EXTERNAL = 14;
        int STATE_SETTING = 15;
        int STATE_SEMICOLON = 16;
        int state = 0;
        PatternScanner scanner = new PatternScanner(graphString, ignorePattern);
        String curClassName = null;
        String curSourceFilterName = null;
        String curSourcePortName = null;
        String curTargetFilterName = null;
        String curTargetPortName = null;
        while (!scanner.atEnd()) {
            switch (state) {
                case 0: {
                    String curCommand = scanner.eat(commandPattern, "<command>");
                    if (curCommand.equals("@import")) {
                        state = 1;
                        break;
                    }
                    if (curCommand.equals("@library")) {
                        state = 2;
                        break;
                    }
                    if (curCommand.equals("@filter")) {
                        state = 3;
                        break;
                    }
                    if (curCommand.equals("@connect")) {
                        state = 8;
                        break;
                    }
                    if (curCommand.equals("@set")) {
                        state = 13;
                        break;
                    }
                    if (curCommand.equals("@external")) {
                        state = 14;
                        break;
                    }
                    if (curCommand.equals("@setting")) {
                        state = 15;
                        break;
                    }
                    throw new GraphIOException("Unknown command '" + curCommand + "'!");
                }
                case 1: {
                    String packageName = scanner.eat(packageNamePattern, "<package-name>");
                    this.mCommands.add(new ImportPackageCommand(this, packageName));
                    state = 16;
                    break;
                }
                case 2: {
                    String libraryName = scanner.eat(libraryNamePattern, "<library-name>");
                    this.mCommands.add(new AddLibraryCommand(this, libraryName));
                    state = 16;
                    break;
                }
                case 3: {
                    curClassName = scanner.eat(wordPattern, "<class-name>");
                    state = 4;
                    break;
                }
                case 4: {
                    String curFilterName = scanner.eat(wordPattern, "<filter-name>");
                    this.mCommands.add(new AllocateFilterCommand(this, curClassName, curFilterName));
                    state = 5;
                    break;
                }
                case 5: {
                    scanner.eat(curlyOpenPattern, "{");
                    state = 6;
                    break;
                }
                case 6: {
                    KeyValueMap params = this.readKeyValueAssignments(scanner, curlyClosePattern);
                    this.mCommands.add(new InitFilterCommand(this, params));
                    state = 7;
                    break;
                }
                case 7: {
                    scanner.eat(curlyClosePattern, "}");
                    state = 0;
                    break;
                }
                case 8: {
                    curSourceFilterName = scanner.eat(wordPattern, "<source-filter-name>");
                    state = 9;
                    break;
                }
                case 9: {
                    String portString = scanner.eat(portPattern, "[<source-port-name>]");
                    curSourcePortName = portString.substring(1, portString.length() - 1);
                    state = 10;
                    break;
                }
                case 10: {
                    scanner.eat(rightArrowPattern, "=>");
                    state = 11;
                    break;
                }
                case 11: {
                    curTargetFilterName = scanner.eat(wordPattern, "<target-filter-name>");
                    state = 12;
                    break;
                }
                case 12: {
                    String portString = scanner.eat(portPattern, "[<target-port-name>]");
                    curTargetPortName = portString.substring(1, portString.length() - 1);
                    this.mCommands.add(new ConnectCommand(this, curSourceFilterName, curSourcePortName, curTargetFilterName, curTargetPortName));
                    state = 16;
                    break;
                }
                case 13: {
                    KeyValueMap assignment = this.readKeyValueAssignments(scanner, semicolonPattern);
                    this.mBoundReferences.putAll(assignment);
                    state = 16;
                    break;
                }
                case 14: {
                    String externalName = scanner.eat(wordPattern, "<external-identifier>");
                    this.bindExternal(externalName);
                    state = 16;
                    break;
                }
                case 15: {
                    KeyValueMap setting = this.readKeyValueAssignments(scanner, semicolonPattern);
                    this.mSettings.putAll(setting);
                    state = 16;
                    break;
                }
                case 16: {
                    scanner.eat(semicolonPattern, ";");
                    state = 0;
                }
            }
        }
        if (state != 16 && state != 0) {
            throw new GraphIOException("Unexpected end of input!");
        }
    }

    private final KeyValueMap $$robo$$android_filterfw_io_TextGraphReader$readKeyValueAssignments(String assignments) throws GraphIOException {
        Pattern ignorePattern = Pattern.compile("\\s+");
        PatternScanner scanner = new PatternScanner(assignments, ignorePattern);
        return this.readKeyValueAssignments(scanner, null);
    }

    private final KeyValueMap $$robo$$android_filterfw_io_TextGraphReader$readKeyValueAssignments(PatternScanner scanner, Pattern endPattern) throws GraphIOException {
        boolean STATE_IDENTIFIER = false;
        boolean STATE_EQUALS = true;
        int STATE_VALUE = 2;
        int STATE_POST_VALUE = 3;
        Pattern equalsPattern = Pattern.compile("=");
        Pattern semicolonPattern = Pattern.compile(";");
        Pattern wordPattern = Pattern.compile("[a-zA-Z]+[a-zA-Z0-9]*");
        Pattern stringPattern = Pattern.compile("'[^']*'|\\\"[^\\\"]*\\\"");
        Pattern intPattern = Pattern.compile("[0-9]+");
        Pattern floatPattern = Pattern.compile("[0-9]*\\.[0-9]+f?");
        Pattern referencePattern = Pattern.compile("\\$[a-zA-Z]+[a-zA-Z0-9]");
        Pattern booleanPattern = Pattern.compile("true|false");
        int state = 0;
        KeyValueMap newVals = new KeyValueMap();
        String curKey = null;
        String curValue = null;
        while (!(scanner.atEnd() || endPattern != null && scanner.peek(endPattern))) {
            switch (state) {
                case 0: {
                    curKey = scanner.eat(wordPattern, "<identifier>");
                    state = 1;
                    break;
                }
                case 1: {
                    scanner.eat(equalsPattern, "=");
                    state = 2;
                    break;
                }
                case 2: {
                    curValue = scanner.tryEat(stringPattern);
                    if (curValue != null) {
                        newVals.put(curKey, curValue.substring(1, curValue.length() - 1));
                    } else {
                        curValue = scanner.tryEat(referencePattern);
                        if (curValue != null) {
                            Object referencedObject;
                            String refName = curValue.substring(1, curValue.length());
                            Object v = referencedObject = this.mBoundReferences != null ? (Object)this.mBoundReferences.get(refName) : null;
                            if (referencedObject == null) {
                                throw new GraphIOException("Unknown object reference to '" + refName + "'!");
                            }
                            newVals.put(curKey, referencedObject);
                        } else {
                            curValue = scanner.tryEat(booleanPattern);
                            if (curValue != null) {
                                newVals.put(curKey, Boolean.parseBoolean(curValue));
                            } else {
                                curValue = scanner.tryEat(floatPattern);
                                if (curValue != null) {
                                    newVals.put(curKey, Float.valueOf(Float.parseFloat(curValue)));
                                } else {
                                    curValue = scanner.tryEat(intPattern);
                                    if (curValue != null) {
                                        newVals.put(curKey, Integer.parseInt(curValue));
                                    } else {
                                        throw new GraphIOException(scanner.unexpectedTokenMessage("<value>"));
                                    }
                                }
                            }
                        }
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    scanner.eat(semicolonPattern, ";");
                    state = 0;
                }
            }
        }
        if (state != 0 && state != 3) {
            throw new GraphIOException("Unexpected end of assignments on line " + scanner.lineNo() + "!");
        }
        return newVals;
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$bindExternal(String name) throws GraphIOException {
        if (!this.mReferences.containsKey(name)) {
            throw new GraphIOException("Unknown external variable '" + name + "'! You must add a reference to this external in the host program using addReference(...)!");
        }
        Object value = this.mReferences.get(name);
        this.mBoundReferences.put(name, value);
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$checkReferences() throws GraphIOException {
        for (String reference : this.mReferences.keySet()) {
            if (this.mBoundReferences.containsKey(reference)) continue;
            throw new GraphIOException("Host program specifies reference to '" + reference + "', which is not declared @external in graph file!");
        }
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$applySettings() throws GraphIOException {
        for (String setting : this.mSettings.keySet()) {
            Object value = this.mSettings.get(setting);
            if (setting.equals("autoBranch")) {
                this.expectSettingClass(setting, value, String.class);
                if (value.equals("synced")) {
                    this.mCurrentGraph.setAutoBranchMode(1);
                    continue;
                }
                if (value.equals("unsynced")) {
                    this.mCurrentGraph.setAutoBranchMode(2);
                    continue;
                }
                if (value.equals("off")) {
                    this.mCurrentGraph.setAutoBranchMode(0);
                    continue;
                }
                throw new GraphIOException("Unknown autobranch setting: " + value + "!");
            }
            if (setting.equals("discardUnconnectedOutputs")) {
                this.expectSettingClass(setting, value, Boolean.class);
                this.mCurrentGraph.setDiscardUnconnectedOutputs((Boolean)value);
                continue;
            }
            throw new GraphIOException("Unknown @setting '" + setting + "'!");
        }
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$expectSettingClass(String setting, Object value, Class expectedClass) throws GraphIOException {
        if (value.getClass() != expectedClass) {
            throw new GraphIOException("Setting '" + setting + "' must have a value of type " + expectedClass.getSimpleName() + ", but found a value of type " + value.getClass().getSimpleName() + "!");
        }
    }

    private final void $$robo$$android_filterfw_io_TextGraphReader$executeCommands() throws GraphIOException {
        for (Command command : this.mCommands) {
            command.execute(this);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_filterfw_io_TextGraphReader$__constructor__();
    }

    public TextGraphReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_io_TextGraphReader$__constructor__(), 0, this);
    }

    @Override
    public FilterGraph readGraphString(String string2) throws GraphIOException {
        return InvokeDynamicSupport.bootstrap("readGraphString", $$robo$$android_filterfw_io_TextGraphReader$readGraphString(java.lang.String ), 0, this, string2);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_filterfw_io_TextGraphReader$reset(), 0, this);
    }

    private void parseString(String string2) throws GraphIOException {
        InvokeDynamicSupport.bootstrap("parseString", $$robo$$android_filterfw_io_TextGraphReader$parseString(java.lang.String ), 0, this, string2);
    }

    @Override
    public KeyValueMap readKeyValueAssignments(String string2) throws GraphIOException {
        return InvokeDynamicSupport.bootstrap("readKeyValueAssignments", $$robo$$android_filterfw_io_TextGraphReader$readKeyValueAssignments(java.lang.String ), 0, this, string2);
    }

    private KeyValueMap readKeyValueAssignments(PatternScanner patternScanner, Pattern pattern) throws GraphIOException {
        return InvokeDynamicSupport.bootstrap("readKeyValueAssignments", $$robo$$android_filterfw_io_TextGraphReader$readKeyValueAssignments(android.filterfw.io.PatternScanner java.util.regex.Pattern ), 0, this, patternScanner, pattern);
    }

    private void bindExternal(String string2) throws GraphIOException {
        InvokeDynamicSupport.bootstrap("bindExternal", $$robo$$android_filterfw_io_TextGraphReader$bindExternal(java.lang.String ), 0, this, string2);
    }

    private void checkReferences() throws GraphIOException {
        InvokeDynamicSupport.bootstrap("checkReferences", $$robo$$android_filterfw_io_TextGraphReader$checkReferences(), 0, this);
    }

    private void applySettings() throws GraphIOException {
        InvokeDynamicSupport.bootstrap("applySettings", $$robo$$android_filterfw_io_TextGraphReader$applySettings(), 0, this);
    }

    private void expectSettingClass(String string2, Object object, Class clazz) throws GraphIOException {
        InvokeDynamicSupport.bootstrap("expectSettingClass", $$robo$$android_filterfw_io_TextGraphReader$expectSettingClass(java.lang.String java.lang.Object java.lang.Class ), 0, this, string2, object, clazz);
    }

    private void executeCommands() throws GraphIOException {
        InvokeDynamicSupport.bootstrap("executeCommands", $$robo$$android_filterfw_io_TextGraphReader$executeCommands(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextGraphReader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ConnectCommand
    implements Command,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mSourceFilter;
        private String mSourcePort;
        private String mTargetFilter;
        private String mTargetName;
        /* synthetic */ TextGraphReader this$0;

        private void $$robo$$android_filterfw_io_TextGraphReader_ConnectCommand$__constructor__(TextGraphReader textGraphReader, String sourceFilter, String sourcePort, String targetFilter, String targetName) {
            this.mSourceFilter = sourceFilter;
            this.mSourcePort = sourcePort;
            this.mTargetFilter = targetFilter;
            this.mTargetName = targetName;
        }

        private final void $$robo$$android_filterfw_io_TextGraphReader_ConnectCommand$execute(TextGraphReader reader) {
            reader.mCurrentGraph.connect(this.mSourceFilter, this.mSourcePort, this.mTargetFilter, this.mTargetName);
        }

        private void __constructor__(TextGraphReader textGraphReader, String string2, String string3, String string4, String string5) {
            this.$$robo$$android_filterfw_io_TextGraphReader_ConnectCommand$__constructor__(textGraphReader, string2, string3, string4, string5);
        }

        public ConnectCommand(TextGraphReader textGraphReader, String string2, String string3, String string4, String string5) {
            this.this$0 = textGraphReader;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_io_TextGraphReader_ConnectCommand$__constructor__(android.filterfw.io.TextGraphReader java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, textGraphReader, string2, string3, string4, string5);
        }

        @Override
        public void execute(TextGraphReader textGraphReader) {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_filterfw_io_TextGraphReader_ConnectCommand$execute(android.filterfw.io.TextGraphReader ), 0, this, textGraphReader);
        }

        public /* synthetic */ ConnectCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class InitFilterCommand
    implements Command,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private KeyValueMap mParams;
        /* synthetic */ TextGraphReader this$0;

        private void $$robo$$android_filterfw_io_TextGraphReader_InitFilterCommand$__constructor__(TextGraphReader textGraphReader, KeyValueMap params) {
            this.mParams = params;
        }

        private final void $$robo$$android_filterfw_io_TextGraphReader_InitFilterCommand$execute(TextGraphReader reader) throws GraphIOException {
            Filter filter = reader.mCurrentFilter;
            try {
                filter.initWithValueMap(this.mParams);
            }
            catch (ProtocolException e) {
                throw new GraphIOException(e.getMessage());
            }
            reader.mCurrentGraph.addFilter(this.this$0.mCurrentFilter);
        }

        private void __constructor__(TextGraphReader textGraphReader, KeyValueMap keyValueMap) {
            this.$$robo$$android_filterfw_io_TextGraphReader_InitFilterCommand$__constructor__(textGraphReader, keyValueMap);
        }

        public InitFilterCommand(TextGraphReader textGraphReader, KeyValueMap keyValueMap) {
            this.this$0 = textGraphReader;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_io_TextGraphReader_InitFilterCommand$__constructor__(android.filterfw.io.TextGraphReader android.filterfw.core.KeyValueMap ), 0, this, textGraphReader, keyValueMap);
        }

        @Override
        public void execute(TextGraphReader textGraphReader) throws GraphIOException {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_filterfw_io_TextGraphReader_InitFilterCommand$execute(android.filterfw.io.TextGraphReader ), 0, this, textGraphReader);
        }

        public /* synthetic */ InitFilterCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InitFilterCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AllocateFilterCommand
    implements Command,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mClassName;
        private String mFilterName;
        /* synthetic */ TextGraphReader this$0;

        private void $$robo$$android_filterfw_io_TextGraphReader_AllocateFilterCommand$__constructor__(TextGraphReader textGraphReader, String className, String filterName) {
            this.mClassName = className;
            this.mFilterName = filterName;
        }

        private final void $$robo$$android_filterfw_io_TextGraphReader_AllocateFilterCommand$execute(TextGraphReader reader) throws GraphIOException {
            Filter filter = null;
            try {
                filter = reader.mFactory.createFilterByClassName(this.mClassName, this.mFilterName);
            }
            catch (IllegalArgumentException e) {
                throw new GraphIOException(e.getMessage());
            }
            reader.mCurrentFilter = filter;
        }

        private void __constructor__(TextGraphReader textGraphReader, String string2, String string3) {
            this.$$robo$$android_filterfw_io_TextGraphReader_AllocateFilterCommand$__constructor__(textGraphReader, string2, string3);
        }

        public AllocateFilterCommand(TextGraphReader textGraphReader, String string2, String string3) {
            this.this$0 = textGraphReader;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_io_TextGraphReader_AllocateFilterCommand$__constructor__(android.filterfw.io.TextGraphReader java.lang.String java.lang.String ), 0, this, textGraphReader, string2, string3);
        }

        @Override
        public void execute(TextGraphReader textGraphReader) throws GraphIOException {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_filterfw_io_TextGraphReader_AllocateFilterCommand$execute(android.filterfw.io.TextGraphReader ), 0, this, textGraphReader);
        }

        public /* synthetic */ AllocateFilterCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AllocateFilterCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AddLibraryCommand
    implements Command,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mLibraryName;
        /* synthetic */ TextGraphReader this$0;

        private void $$robo$$android_filterfw_io_TextGraphReader_AddLibraryCommand$__constructor__(TextGraphReader textGraphReader, String libraryName) {
            this.mLibraryName = libraryName;
        }

        private final void $$robo$$android_filterfw_io_TextGraphReader_AddLibraryCommand$execute(TextGraphReader reader) {
            reader.mFactory;
            FilterFactory.addFilterLibrary(this.mLibraryName);
        }

        private void __constructor__(TextGraphReader textGraphReader, String string2) {
            this.$$robo$$android_filterfw_io_TextGraphReader_AddLibraryCommand$__constructor__(textGraphReader, string2);
        }

        public AddLibraryCommand(TextGraphReader textGraphReader, String string2) {
            this.this$0 = textGraphReader;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_io_TextGraphReader_AddLibraryCommand$__constructor__(android.filterfw.io.TextGraphReader java.lang.String ), 0, this, textGraphReader, string2);
        }

        @Override
        public void execute(TextGraphReader textGraphReader) {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_filterfw_io_TextGraphReader_AddLibraryCommand$execute(android.filterfw.io.TextGraphReader ), 0, this, textGraphReader);
        }

        public /* synthetic */ AddLibraryCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AddLibraryCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ImportPackageCommand
    implements Command,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mPackageName;
        /* synthetic */ TextGraphReader this$0;

        private void $$robo$$android_filterfw_io_TextGraphReader_ImportPackageCommand$__constructor__(TextGraphReader textGraphReader, String packageName) {
            this.mPackageName = packageName;
        }

        private final void $$robo$$android_filterfw_io_TextGraphReader_ImportPackageCommand$execute(TextGraphReader reader) throws GraphIOException {
            try {
                reader.mFactory.addPackage(this.mPackageName);
            }
            catch (IllegalArgumentException e) {
                throw new GraphIOException(e.getMessage());
            }
        }

        private void __constructor__(TextGraphReader textGraphReader, String string2) {
            this.$$robo$$android_filterfw_io_TextGraphReader_ImportPackageCommand$__constructor__(textGraphReader, string2);
        }

        public ImportPackageCommand(TextGraphReader textGraphReader, String string2) {
            this.this$0 = textGraphReader;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_io_TextGraphReader_ImportPackageCommand$__constructor__(android.filterfw.io.TextGraphReader java.lang.String ), 0, this, textGraphReader, string2);
        }

        @Override
        public void execute(TextGraphReader textGraphReader) throws GraphIOException {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_filterfw_io_TextGraphReader_ImportPackageCommand$execute(android.filterfw.io.TextGraphReader ), 0, this, textGraphReader);
        }

        public /* synthetic */ ImportPackageCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImportPackageCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface Command
    extends InstrumentedInterface {
        public void execute(TextGraphReader var1) throws GraphIOException;
    }
}

