/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DdmHandleProfiling
extends ChunkHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int CHUNK_MPRS;
    public static int CHUNK_MPRE;
    public static int CHUNK_MPSS;
    public static int CHUNK_MPSE;
    public static int CHUNK_MPRQ;
    public static int CHUNK_SPSS;
    public static int CHUNK_SPSE;
    private static boolean DEBUG = false;
    private static DdmHandleProfiling mInstance;

    private void $$robo$$android_ddm_DdmHandleProfiling$__constructor__() {
    }

    private static final void $$robo$$android_ddm_DdmHandleProfiling$register() {
        DdmServer.registerHandler(CHUNK_MPRS, mInstance);
        DdmServer.registerHandler(CHUNK_MPRE, mInstance);
        DdmServer.registerHandler(CHUNK_MPSS, mInstance);
        DdmServer.registerHandler(CHUNK_MPSE, mInstance);
        DdmServer.registerHandler(CHUNK_MPRQ, mInstance);
        DdmServer.registerHandler(CHUNK_SPSS, mInstance);
        DdmServer.registerHandler(CHUNK_SPSE, mInstance);
    }

    private final void $$robo$$android_ddm_DdmHandleProfiling$connected() {
    }

    private final void $$robo$$android_ddm_DdmHandleProfiling$disconnected() {
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_MPRS) {
            return this.handleMPRS(request);
        }
        if (type == CHUNK_MPRE) {
            return this.handleMPRE(request);
        }
        if (type == CHUNK_MPSS) {
            return this.handleMPSS(request);
        }
        if (type == CHUNK_MPSE) {
            return this.handleMPSEOrSPSE(request, "Method");
        }
        if (type == CHUNK_MPRQ) {
            return this.handleMPRQ(request);
        }
        if (type == CHUNK_SPSS) {
            return this.handleSPSS(request);
        }
        if (type == CHUNK_SPSE) {
            return this.handleMPSEOrSPSE(request, "Sample");
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleMPRS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        int len = in.getInt();
        String fileName = DdmHandleProfiling.getString(in, len);
        try {
            Debug.startMethodTracing(fileName, bufferSize, flags);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleMPRE(Chunk request) {
        byte result;
        try {
            Debug.stopMethodTracing();
            result = 0;
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", "Method profiling end failed: " + re.getMessage());
            result = 1;
        }
        byte[] reply = new byte[]{result};
        return new Chunk(CHUNK_MPRE, reply, 0, reply.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleMPSS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        try {
            Debug.startMethodTracingDdms(bufferSize, flags, false, 0);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleMPSEOrSPSE(Chunk request, String type) {
        try {
            Debug.stopMethodTracing();
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", type + " prof stream end failed: " + re.getMessage());
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleMPRQ(Chunk request) {
        int result = Debug.getMethodTracingMode();
        byte[] reply = new byte[]{(byte)result};
        return new Chunk(CHUNK_MPRQ, reply, 0, reply.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleProfiling$handleSPSS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk(request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        int interval = in.getInt();
        try {
            Debug.startMethodTracingDdms(bufferSize, flags, true, interval);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk(1, re.getMessage());
        }
    }

    static void __staticInitializer__() {
        CHUNK_MPRS = DdmHandleProfiling.type("MPRS");
        CHUNK_MPRE = DdmHandleProfiling.type("MPRE");
        CHUNK_MPSS = DdmHandleProfiling.type("MPSS");
        CHUNK_MPSE = DdmHandleProfiling.type("MPSE");
        CHUNK_MPRQ = DdmHandleProfiling.type("MPRQ");
        CHUNK_SPSS = DdmHandleProfiling.type("SPSS");
        CHUNK_SPSE = DdmHandleProfiling.type("SPSE");
        mInstance = new DdmHandleProfiling();
    }

    private void __constructor__() {
        this.$$robo$$android_ddm_DdmHandleProfiling$__constructor__();
    }

    private DdmHandleProfiling() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_ddm_DdmHandleProfiling$__constructor__(), 0, this);
    }

    public static void register() {
        InvokeDynamicSupport.bootstrapStatic("register", $$robo$$android_ddm_DdmHandleProfiling$register(), 0);
    }

    @Override
    public void connected() {
        InvokeDynamicSupport.bootstrap("connected", $$robo$$android_ddm_DdmHandleProfiling$connected(), 0, this);
    }

    @Override
    public void disconnected() {
        InvokeDynamicSupport.bootstrap("disconnected", $$robo$$android_ddm_DdmHandleProfiling$disconnected(), 0, this);
    }

    @Override
    public Chunk handleChunk(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleChunk", $$robo$$android_ddm_DdmHandleProfiling$handleChunk(org.apache.harmony.dalvik.ddmc.Chunk ), 0, this, chunk);
    }

    private Chunk handleMPRS(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleMPRS", $$robo$$android_ddm_DdmHandleProfiling$handleMPRS(org.apache.harmony.dalvik.ddmc.Chunk ), 0, this, chunk);
    }

    private Chunk handleMPRE(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleMPRE", $$robo$$android_ddm_DdmHandleProfiling$handleMPRE(org.apache.harmony.dalvik.ddmc.Chunk ), 0, this, chunk);
    }

    private Chunk handleMPSS(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleMPSS", $$robo$$android_ddm_DdmHandleProfiling$handleMPSS(org.apache.harmony.dalvik.ddmc.Chunk ), 0, this, chunk);
    }

    private Chunk handleMPSEOrSPSE(Chunk chunk, String string2) {
        return InvokeDynamicSupport.bootstrap("handleMPSEOrSPSE", $$robo$$android_ddm_DdmHandleProfiling$handleMPSEOrSPSE(org.apache.harmony.dalvik.ddmc.Chunk java.lang.String ), 0, this, chunk, string2);
    }

    private Chunk handleMPRQ(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleMPRQ", $$robo$$android_ddm_DdmHandleProfiling$handleMPRQ(org.apache.harmony.dalvik.ddmc.Chunk ), 0, this, chunk);
    }

    private Chunk handleSPSS(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleSPSS", $$robo$$android_ddm_DdmHandleProfiling$handleSPSS(org.apache.harmony.dalvik.ddmc.Chunk ), 0, this, chunk);
    }

    static {
        RobolectricInternals.classInitializing(DdmHandleProfiling.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DdmHandleProfiling)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

