/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractCursor
implements CrossProcessCursor,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Cursor";
    protected HashMap<Long, Map<String, Object>> mUpdatedRows;
    protected int mRowIdColumnIndex;
    protected Long mCurrentRowID;
    @Deprecated
    protected int mPos;
    @Deprecated
    protected boolean mClosed;
    @Deprecated
    protected ContentResolver mContentResolver;
    private Uri mNotifyUri;
    private Object mSelfObserverLock;
    private ContentObserver mSelfObserver;
    private boolean mSelfObserverRegistered;
    private DataSetObservable mDataSetObservable;
    private ContentObservable mContentObservable;
    private Bundle mExtras;

    @Override
    public abstract int getCount();

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract String getString(int var1);

    @Override
    public abstract short getShort(int var1);

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract long getLong(int var1);

    @Override
    public abstract float getFloat(int var1);

    @Override
    public abstract double getDouble(int var1);

    @Override
    public abstract boolean isNull(int var1);

    private final int $$robo$$android_database_AbstractCursor$getType(int column) {
        return 3;
    }

    private final byte[] $$robo$$android_database_AbstractCursor$getBlob(int column) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    private final CursorWindow $$robo$$android_database_AbstractCursor$getWindow() {
        return null;
    }

    private final int $$robo$$android_database_AbstractCursor$getColumnCount() {
        return this.getColumnNames().length;
    }

    private final void $$robo$$android_database_AbstractCursor$deactivate() {
        this.onDeactivateOrClose();
    }

    private final void $$robo$$android_database_AbstractCursor$onDeactivateOrClose() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    private final boolean $$robo$$android_database_AbstractCursor$requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    private final boolean $$robo$$android_database_AbstractCursor$isClosed() {
        return this.mClosed;
    }

    private final void $$robo$$android_database_AbstractCursor$close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.onDeactivateOrClose();
    }

    private final boolean $$robo$$android_database_AbstractCursor$onMove(int oldPosition, int newPosition) {
        return true;
    }

    private final void $$robo$$android_database_AbstractCursor$copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        String result = this.getString(columnIndex);
        if (result != null) {
            char[] data = buffer.data;
            if (data == null || data.length < result.length()) {
                buffer.data = result.toCharArray();
            } else {
                result.getChars(0, result.length(), data, 0);
            }
            buffer.sizeCopied = result.length();
        } else {
            buffer.sizeCopied = 0;
        }
    }

    private void $$robo$$android_database_AbstractCursor$__constructor__() {
        this.mSelfObserverLock = new Object();
        this.mDataSetObservable = new DataSetObservable();
        this.mContentObservable = new ContentObservable();
        this.mExtras = Bundle.EMPTY;
        this.mPos = -1;
    }

    private final int $$robo$$android_database_AbstractCursor$getPosition() {
        return this.mPos;
    }

    private final boolean $$robo$$android_database_AbstractCursor$moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.mPos = count;
            return false;
        }
        if (position < 0) {
            this.mPos = -1;
            return false;
        }
        if (position == this.mPos) {
            return true;
        }
        boolean result = this.onMove(this.mPos, position);
        this.mPos = !result ? -1 : position;
        return result;
    }

    private final void $$robo$$android_database_AbstractCursor$fillWindow(int position, CursorWindow window) {
        DatabaseUtils.cursorFillWindow(this, position, window);
    }

    private final boolean $$robo$$android_database_AbstractCursor$move(int offset) {
        return this.moveToPosition(this.mPos + offset);
    }

    private final boolean $$robo$$android_database_AbstractCursor$moveToFirst() {
        return this.moveToPosition(0);
    }

    private final boolean $$robo$$android_database_AbstractCursor$moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    private final boolean $$robo$$android_database_AbstractCursor$moveToNext() {
        return this.moveToPosition(this.mPos + 1);
    }

    private final boolean $$robo$$android_database_AbstractCursor$moveToPrevious() {
        return this.moveToPosition(this.mPos - 1);
    }

    private final boolean $$robo$$android_database_AbstractCursor$isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    private final boolean $$robo$$android_database_AbstractCursor$isLast() {
        int cnt = this.getCount();
        return this.mPos == cnt - 1 && cnt != 0;
    }

    private final boolean $$robo$$android_database_AbstractCursor$isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == -1;
    }

    private final boolean $$robo$$android_database_AbstractCursor$isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == this.getCount();
    }

    private final int $$robo$$android_database_AbstractCursor$getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            Log.e("Cursor", "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_database_AbstractCursor$getColumnIndexOrThrow(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("column '" + columnName + "' does not exist");
        }
        return index;
    }

    private final String $$robo$$android_database_AbstractCursor$getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    private final void $$robo$$android_database_AbstractCursor$registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
    }

    private final void $$robo$$android_database_AbstractCursor$unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver(observer);
        }
    }

    private final void $$robo$$android_database_AbstractCursor$registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver(observer);
    }

    private final void $$robo$$android_database_AbstractCursor$unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_AbstractCursor$onChange(boolean selfChange) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(selfChange, null);
            if (this.mNotifyUri != null && selfChange) {
                this.mContentResolver.notifyChange(this.mNotifyUri, this.mSelfObserver);
            }
        }
    }

    private final void $$robo$$android_database_AbstractCursor$setNotificationUri(ContentResolver cr, Uri notifyUri) {
        this.setNotificationUri(cr, notifyUri, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_AbstractCursor$setNotificationUri(ContentResolver cr, Uri notifyUri, int userHandle) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = notifyUri;
            this.mContentResolver = cr;
            if (this.mSelfObserver != null) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            this.mSelfObserver = new SelfContentObserver(this);
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver, userHandle);
            this.mSelfObserverRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$android_database_AbstractCursor$getNotificationUri() {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            return this.mNotifyUri;
        }
    }

    private final boolean $$robo$$android_database_AbstractCursor$getWantsAllOnMoveCalls() {
        return false;
    }

    private final void $$robo$$android_database_AbstractCursor$setExtras(Bundle extras) {
        this.mExtras = extras == null ? Bundle.EMPTY : extras;
    }

    private final Bundle $$robo$$android_database_AbstractCursor$getExtras() {
        return this.mExtras;
    }

    private final Bundle $$robo$$android_database_AbstractCursor$respond(Bundle extras) {
        return Bundle.EMPTY;
    }

    @Deprecated
    private final boolean $$robo$$android_database_AbstractCursor$isFieldUpdated(int columnIndex) {
        return false;
    }

    @Deprecated
    private final Object $$robo$$android_database_AbstractCursor$getUpdatedField(int columnIndex) {
        return null;
    }

    private final void $$robo$$android_database_AbstractCursor$checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    private final void $$robo$$android_database_AbstractCursor$finalize() {
        if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
        }
        try {
            if (!this.mClosed) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_database_AbstractCursor$getType(int ), 0, this, n);
    }

    @Override
    public byte[] getBlob(int n) {
        return InvokeDynamicSupport.bootstrap("getBlob", $$robo$$android_database_AbstractCursor$getBlob(int ), 0, this, n);
    }

    @Override
    public CursorWindow getWindow() {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_database_AbstractCursor$getWindow(), 0, this);
    }

    @Override
    public int getColumnCount() {
        return (int)InvokeDynamicSupport.bootstrap("getColumnCount", $$robo$$android_database_AbstractCursor$getColumnCount(), 0, this);
    }

    @Override
    public void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_database_AbstractCursor$deactivate(), 0, this);
    }

    protected void onDeactivateOrClose() {
        InvokeDynamicSupport.bootstrap("onDeactivateOrClose", $$robo$$android_database_AbstractCursor$onDeactivateOrClose(), 0, this);
    }

    @Override
    public boolean requery() {
        return (boolean)InvokeDynamicSupport.bootstrap("requery", $$robo$$android_database_AbstractCursor$requery(), 0, this);
    }

    @Override
    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_database_AbstractCursor$isClosed(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_AbstractCursor$close(), 0, this);
    }

    @Override
    public boolean onMove(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMove", $$robo$$android_database_AbstractCursor$onMove(int int ), 0, this, n, n2);
    }

    @Override
    public void copyStringToBuffer(int n, CharArrayBuffer charArrayBuffer) {
        InvokeDynamicSupport.bootstrap("copyStringToBuffer", $$robo$$android_database_AbstractCursor$copyStringToBuffer(int android.database.CharArrayBuffer ), 0, this, n, charArrayBuffer);
    }

    private void __constructor__() {
        this.$$robo$$android_database_AbstractCursor$__constructor__();
    }

    public AbstractCursor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_AbstractCursor$__constructor__(), 0, this);
    }

    @Override
    public int getPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPosition", $$robo$$android_database_AbstractCursor$getPosition(), 0, this);
    }

    @Override
    public boolean moveToPosition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("moveToPosition", $$robo$$android_database_AbstractCursor$moveToPosition(int ), 0, this, n);
    }

    @Override
    public void fillWindow(int n, CursorWindow cursorWindow) {
        InvokeDynamicSupport.bootstrap("fillWindow", $$robo$$android_database_AbstractCursor$fillWindow(int android.database.CursorWindow ), 0, this, n, cursorWindow);
    }

    @Override
    public boolean move(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("move", $$robo$$android_database_AbstractCursor$move(int ), 0, this, n);
    }

    @Override
    public boolean moveToFirst() {
        return (boolean)InvokeDynamicSupport.bootstrap("moveToFirst", $$robo$$android_database_AbstractCursor$moveToFirst(), 0, this);
    }

    @Override
    public boolean moveToLast() {
        return (boolean)InvokeDynamicSupport.bootstrap("moveToLast", $$robo$$android_database_AbstractCursor$moveToLast(), 0, this);
    }

    @Override
    public boolean moveToNext() {
        return (boolean)InvokeDynamicSupport.bootstrap("moveToNext", $$robo$$android_database_AbstractCursor$moveToNext(), 0, this);
    }

    @Override
    public boolean moveToPrevious() {
        return (boolean)InvokeDynamicSupport.bootstrap("moveToPrevious", $$robo$$android_database_AbstractCursor$moveToPrevious(), 0, this);
    }

    @Override
    public boolean isFirst() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFirst", $$robo$$android_database_AbstractCursor$isFirst(), 0, this);
    }

    @Override
    public boolean isLast() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLast", $$robo$$android_database_AbstractCursor$isLast(), 0, this);
    }

    @Override
    public boolean isBeforeFirst() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBeforeFirst", $$robo$$android_database_AbstractCursor$isBeforeFirst(), 0, this);
    }

    @Override
    public boolean isAfterLast() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAfterLast", $$robo$$android_database_AbstractCursor$isAfterLast(), 0, this);
    }

    @Override
    public int getColumnIndex(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getColumnIndex", $$robo$$android_database_AbstractCursor$getColumnIndex(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getColumnIndexOrThrow(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getColumnIndexOrThrow", $$robo$$android_database_AbstractCursor$getColumnIndexOrThrow(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getColumnName(int n) {
        return InvokeDynamicSupport.bootstrap("getColumnName", $$robo$$android_database_AbstractCursor$getColumnName(int ), 0, this, n);
    }

    @Override
    public void registerContentObserver(ContentObserver contentObserver) {
        InvokeDynamicSupport.bootstrap("registerContentObserver", $$robo$$android_database_AbstractCursor$registerContentObserver(android.database.ContentObserver ), 0, this, contentObserver);
    }

    @Override
    public void unregisterContentObserver(ContentObserver contentObserver) {
        InvokeDynamicSupport.bootstrap("unregisterContentObserver", $$robo$$android_database_AbstractCursor$unregisterContentObserver(android.database.ContentObserver ), 0, this, contentObserver);
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        InvokeDynamicSupport.bootstrap("registerDataSetObserver", $$robo$$android_database_AbstractCursor$registerDataSetObserver(android.database.DataSetObserver ), 0, this, dataSetObserver);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        InvokeDynamicSupport.bootstrap("unregisterDataSetObserver", $$robo$$android_database_AbstractCursor$unregisterDataSetObserver(android.database.DataSetObserver ), 0, this, dataSetObserver);
    }

    protected void onChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_database_AbstractCursor$onChange(boolean ), 0, this, bl);
    }

    @Override
    public void setNotificationUri(ContentResolver contentResolver, Uri uri) {
        InvokeDynamicSupport.bootstrap("setNotificationUri", $$robo$$android_database_AbstractCursor$setNotificationUri(android.content.ContentResolver android.net.Uri ), 0, this, contentResolver, uri);
    }

    public void setNotificationUri(ContentResolver contentResolver, Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setNotificationUri", $$robo$$android_database_AbstractCursor$setNotificationUri(android.content.ContentResolver android.net.Uri int ), 0, this, contentResolver, uri, n);
    }

    @Override
    public Uri getNotificationUri() {
        return InvokeDynamicSupport.bootstrap("getNotificationUri", $$robo$$android_database_AbstractCursor$getNotificationUri(), 0, this);
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return (boolean)InvokeDynamicSupport.bootstrap("getWantsAllOnMoveCalls", $$robo$$android_database_AbstractCursor$getWantsAllOnMoveCalls(), 0, this);
    }

    @Override
    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_database_AbstractCursor$setExtras(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_database_AbstractCursor$getExtras(), 0, this);
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("respond", $$robo$$android_database_AbstractCursor$respond(android.os.Bundle ), 0, this, bundle);
    }

    @Deprecated
    protected boolean isFieldUpdated(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFieldUpdated", $$robo$$android_database_AbstractCursor$isFieldUpdated(int ), 0, this, n);
    }

    @Deprecated
    protected Object getUpdatedField(int n) {
        return InvokeDynamicSupport.bootstrap("getUpdatedField", $$robo$$android_database_AbstractCursor$getUpdatedField(int ), 0, this, n);
    }

    protected void checkPosition() {
        InvokeDynamicSupport.bootstrap("checkPosition", $$robo$$android_database_AbstractCursor$checkPosition(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_database_AbstractCursor$finalize(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractCursor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected static class SelfContentObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        WeakReference<AbstractCursor> mCursor;

        private void $$robo$$android_database_AbstractCursor_SelfContentObserver$__constructor__(AbstractCursor cursor) {
            this.mCursor = new WeakReference<AbstractCursor>(cursor);
        }

        private final boolean $$robo$$android_database_AbstractCursor_SelfContentObserver$deliverSelfNotifications() {
            return false;
        }

        private final void $$robo$$android_database_AbstractCursor_SelfContentObserver$onChange(boolean selfChange) {
            AbstractCursor cursor = (AbstractCursor)this.mCursor.get();
            if (cursor != null) {
                cursor.onChange(false);
            }
        }

        private void __constructor__(AbstractCursor abstractCursor) {
            this.$$robo$$android_database_AbstractCursor_SelfContentObserver$__constructor__(abstractCursor);
        }

        public SelfContentObserver(AbstractCursor abstractCursor) {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_AbstractCursor_SelfContentObserver$__constructor__(android.database.AbstractCursor ), 0, this, abstractCursor);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return (boolean)InvokeDynamicSupport.bootstrap("deliverSelfNotifications", $$robo$$android_database_AbstractCursor_SelfContentObserver$deliverSelfNotifications(), 0, this);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_database_AbstractCursor_SelfContentObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ SelfContentObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelfContentObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

