/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Annotation;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.LineHeightSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class StringBlock
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AssetManager";
    private static boolean localLOGV = false;
    private long mNative;
    private boolean mUseSparse;
    private boolean mOwnsNative;
    private CharSequence[] mStrings;
    private SparseArray<CharSequence> mSparseStrings;
    StyleIDs mStyleIDs;

    private void $$robo$$android_content_res_StringBlock$__constructor__(byte[] data, boolean useSparse) {
        this.mStyleIDs = null;
        this.mNative = StringBlock.nativeCreate(data, 0, data.length);
        this.mUseSparse = useSparse;
        this.mOwnsNative = true;
    }

    private void $$robo$$android_content_res_StringBlock$__constructor__(byte[] data, int offset, int size, boolean useSparse) {
        this.mStyleIDs = null;
        this.mNative = StringBlock.nativeCreate(data, offset, size);
        this.mUseSparse = useSparse;
        this.mOwnsNative = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$android_content_res_StringBlock$get(int idx) {
        StringBlock stringBlock = this;
        synchronized (stringBlock) {
            String str;
            if (this.mStrings != null) {
                CharSequence res = this.mStrings[idx];
                if (res != null) {
                    return res;
                }
            } else if (this.mSparseStrings != null) {
                CharSequence res = this.mSparseStrings.get(idx);
                if (res != null) {
                    return res;
                }
            } else {
                int num = StringBlock.nativeGetSize(this.mNative);
                if (this.mUseSparse && num > 250) {
                    this.mSparseStrings = new SparseArray();
                } else {
                    this.mStrings = new CharSequence[num];
                }
            }
            CharSequence res = str = StringBlock.nativeGetString(this.mNative, idx);
            int[] style2 = StringBlock.nativeGetStyle(this.mNative, idx);
            if (style2 != null) {
                if (this.mStyleIDs == null) {
                    this.mStyleIDs = new StyleIDs();
                }
                for (int styleIndex = 0; styleIndex < style2.length; styleIndex += 3) {
                    int styleId = style2[styleIndex];
                    if (styleId == this.mStyleIDs.boldId || styleId == this.mStyleIDs.italicId || styleId == this.mStyleIDs.underlineId || styleId == this.mStyleIDs.ttId || styleId == this.mStyleIDs.bigId || styleId == this.mStyleIDs.smallId || styleId == this.mStyleIDs.subId || styleId == this.mStyleIDs.supId || styleId == this.mStyleIDs.strikeId || styleId == this.mStyleIDs.listItemId || styleId == this.mStyleIDs.marqueeId) continue;
                    String styleTag = StringBlock.nativeGetString(this.mNative, styleId);
                    if (styleTag.equals("b")) {
                        this.mStyleIDs.boldId = styleId;
                        continue;
                    }
                    if (styleTag.equals("i")) {
                        this.mStyleIDs.italicId = styleId;
                        continue;
                    }
                    if (styleTag.equals("u")) {
                        this.mStyleIDs.underlineId = styleId;
                        continue;
                    }
                    if (styleTag.equals("tt")) {
                        this.mStyleIDs.ttId = styleId;
                        continue;
                    }
                    if (styleTag.equals("big")) {
                        this.mStyleIDs.bigId = styleId;
                        continue;
                    }
                    if (styleTag.equals("small")) {
                        this.mStyleIDs.smallId = styleId;
                        continue;
                    }
                    if (styleTag.equals("sup")) {
                        this.mStyleIDs.supId = styleId;
                        continue;
                    }
                    if (styleTag.equals("sub")) {
                        this.mStyleIDs.subId = styleId;
                        continue;
                    }
                    if (styleTag.equals("strike")) {
                        this.mStyleIDs.strikeId = styleId;
                        continue;
                    }
                    if (styleTag.equals("li")) {
                        this.mStyleIDs.listItemId = styleId;
                        continue;
                    }
                    if (!styleTag.equals("marquee")) continue;
                    this.mStyleIDs.marqueeId = styleId;
                }
                res = this.applyStyles(str, style2, this.mStyleIDs);
            }
            if (this.mStrings != null) {
                this.mStrings[idx] = res;
            } else {
                this.mSparseStrings.put(idx, res);
            }
            return res;
        }
    }

    private final void $$robo$$android_content_res_StringBlock$finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (this.mOwnsNative) {
                StringBlock.nativeDestroy(this.mNative);
            }
        }
    }

    private final CharSequence $$robo$$android_content_res_StringBlock$applyStyles(String str, int[] style2, StyleIDs ids) {
        if (style2.length == 0) {
            return str;
        }
        SpannableString buffer = new SpannableString(str);
        for (int i = 0; i < style2.length; i += 3) {
            int eq;
            int type = style2[i];
            if (type == ids.boldId) {
                buffer.setSpan(new StyleSpan(1), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.italicId) {
                buffer.setSpan(new StyleSpan(2), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.underlineId) {
                buffer.setSpan(new UnderlineSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.ttId) {
                buffer.setSpan(new TypefaceSpan("monospace"), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.bigId) {
                buffer.setSpan(new RelativeSizeSpan(1.25f), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.smallId) {
                buffer.setSpan(new RelativeSizeSpan(0.8f), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.subId) {
                buffer.setSpan(new SubscriptSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.supId) {
                buffer.setSpan(new SuperscriptSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.strikeId) {
                buffer.setSpan(new StrikethroughSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.listItemId) {
                StringBlock.addParagraphSpan(buffer, new BulletSpan(10), style2[i + 1], style2[i + 2] + 1);
                continue;
            }
            if (type == ids.marqueeId) {
                buffer.setSpan((Object)TextUtils.TruncateAt.MARQUEE, style2[i + 1], style2[i + 2] + 1, 18);
                continue;
            }
            String tag = StringBlock.nativeGetString(this.mNative, type);
            if (tag.startsWith("font;")) {
                int size;
                String sub = StringBlock.subtag(tag, ";height=");
                if (sub != null) {
                    size = Integer.parseInt(sub);
                    StringBlock.addParagraphSpan(buffer, new Height(size), style2[i + 1], style2[i + 2] + 1);
                }
                if ((sub = StringBlock.subtag(tag, ";size=")) != null) {
                    size = Integer.parseInt(sub);
                    buffer.setSpan(new AbsoluteSizeSpan(size, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";fgcolor=")) != null) {
                    buffer.setSpan(StringBlock.getColor(sub, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";color=")) != null) {
                    buffer.setSpan(StringBlock.getColor(sub, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";bgcolor=")) != null) {
                    buffer.setSpan(StringBlock.getColor(sub, false), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";face=")) == null) continue;
                buffer.setSpan(new TypefaceSpan(sub), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (tag.startsWith("a;")) {
                String sub = StringBlock.subtag(tag, ";href=");
                if (sub == null) continue;
                buffer.setSpan(new URLSpan(sub), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (!tag.startsWith("annotation;")) continue;
            int len = tag.length();
            int t = tag.indexOf(59);
            while (t < len && (eq = tag.indexOf(61, t)) >= 0) {
                int next = tag.indexOf(59, eq);
                if (next < 0) {
                    next = len;
                }
                String key = tag.substring(t + 1, eq);
                String value = tag.substring(eq + 1, next);
                buffer.setSpan(new Annotation(key, value), style2[i + 1], style2[i + 2] + 1, 33);
                t = next;
            }
        }
        return new SpannedString(buffer);
    }

    private static final CharacterStyle $$robo$$android_content_res_StringBlock$getColor(String color2, boolean foreground) {
        int c = -16777216;
        if (!TextUtils.isEmpty(color2)) {
            if (color2.startsWith("@")) {
                String name;
                Resources res = Resources.getSystem();
                int colorRes = res.getIdentifier(name = color2.substring(1), "color", "android");
                if (colorRes != 0) {
                    ColorStateList colors = res.getColorStateList(colorRes, null);
                    if (foreground) {
                        return new TextAppearanceSpan(null, 0, 0, colors, null);
                    }
                    c = colors.getDefaultColor();
                }
            } else {
                try {
                    c = Color.parseColor(color2);
                }
                catch (IllegalArgumentException e) {
                    c = -16777216;
                }
            }
        }
        if (foreground) {
            return new ForegroundColorSpan(c);
        }
        return new BackgroundColorSpan(c);
    }

    private static final void $$robo$$android_content_res_StringBlock$addParagraphSpan(Spannable buffer, Object what, int start, int end) {
        int len = buffer.length();
        if (start != 0 && start != len && buffer.charAt(start - 1) != '\n') {
            --start;
            while (start > 0 && buffer.charAt(start - 1) != '\n') {
                --start;
            }
        }
        if (end != 0 && end != len && buffer.charAt(end - 1) != '\n') {
            ++end;
            while (end < len && buffer.charAt(end - 1) != '\n') {
                ++end;
            }
        }
        buffer.setSpan(what, start, end, 51);
    }

    private static final String $$robo$$android_content_res_StringBlock$subtag(String full, String attribute) {
        int start = full.indexOf(attribute);
        if (start < 0) {
            return null;
        }
        int end = full.indexOf(59, start += attribute.length());
        if (end < 0) {
            return full.substring(start);
        }
        return full.substring(start, end);
    }

    private void $$robo$$android_content_res_StringBlock$__constructor__(long obj, boolean useSparse) {
        this.mStyleIDs = null;
        this.mNative = obj;
        this.mUseSparse = useSparse;
        this.mOwnsNative = false;
    }

    private static final long $$robo$$android_content_res_StringBlock$nativeCreate(byte[] byArray, int n, int n2) {
        return 0L;
    }

    private static final int $$robo$$android_content_res_StringBlock$nativeGetSize(long l) {
        return 0;
    }

    private static final String $$robo$$android_content_res_StringBlock$nativeGetString(long l, int n) {
        return null;
    }

    private static final int[] $$robo$$android_content_res_StringBlock$nativeGetStyle(long l, int n) {
        return null;
    }

    private static final void $$robo$$android_content_res_StringBlock$nativeDestroy(long l) {
    }

    private void __constructor__(byte[] byArray, boolean bl) {
        this.$$robo$$android_content_res_StringBlock$__constructor__(byArray, bl);
    }

    public StringBlock(byte[] byArray, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_StringBlock$__constructor__(byte[] boolean ), 0, this, byArray, bl);
    }

    private void __constructor__(byte[] byArray, int n, int n2, boolean bl) {
        this.$$robo$$android_content_res_StringBlock$__constructor__(byArray, n, n2, bl);
    }

    public StringBlock(byte[] byArray, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_StringBlock$__constructor__(byte[] int int boolean ), 0, this, byArray, n, n2, bl);
    }

    public CharSequence get(int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_content_res_StringBlock$get(int ), 0, this, n);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_StringBlock$finalize(), 0, this);
    }

    private CharSequence applyStyles(String string2, int[] nArray, StyleIDs styleIDs) {
        return InvokeDynamicSupport.bootstrap("applyStyles", $$robo$$android_content_res_StringBlock$applyStyles(java.lang.String int[] android.content.res.StringBlock$StyleIDs ), 0, this, string2, nArray, styleIDs);
    }

    private static CharacterStyle getColor(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getColor", $$robo$$android_content_res_StringBlock$getColor(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static void addParagraphSpan(Spannable spannable, Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("addParagraphSpan", $$robo$$android_content_res_StringBlock$addParagraphSpan(android.text.Spannable java.lang.Object int int ), 0, (Spannable)spannable, (Object)object, (int)n, (int)n2);
    }

    private static String subtag(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("subtag", $$robo$$android_content_res_StringBlock$subtag(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void __constructor__(long l, boolean bl) {
        this.$$robo$$android_content_res_StringBlock$__constructor__(l, bl);
    }

    StringBlock(long l, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_StringBlock$__constructor__(long boolean ), 0, this, l, bl);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreate$nativeBinding(byte[] var0, int var1, int var2);

    private static long nativeCreate(byte[] byArray, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_content_res_StringBlock$nativeCreate(byte[] int int ), 1, (byte[])byArray, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetSize$nativeBinding(long var0);

    private static int nativeGetSize(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetSize", $$robo$$android_content_res_StringBlock$nativeGetSize(long ), 1, (long)l);
    }

    private static final native /* synthetic */ String $$robo$$nativeGetString$nativeBinding(long var0, int var2);

    private static String nativeGetString(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetString", $$robo$$android_content_res_StringBlock$nativeGetString(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int[] $$robo$$nativeGetStyle$nativeBinding(long var0, int var2);

    private static int[] nativeGetStyle(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetStyle", $$robo$$android_content_res_StringBlock$nativeGetStyle(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeDestroy$nativeBinding(long var0);

    private static void nativeDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestroy", $$robo$$android_content_res_StringBlock$nativeDestroy(long ), 1, (long)l);
    }

    public /* synthetic */ StringBlock() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringBlock)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Height
    implements LineHeightSpan.WithDensity,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSize;
        private static float sProportion;

        private void $$robo$$android_content_res_StringBlock_Height$__constructor__(int size) {
            this.mSize = size;
        }

        private final void $$robo$$android_content_res_StringBlock_Height$chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
            this.chooseHeight(text, start, end, spanstartv, v, fm, null);
        }

        private final void $$robo$$android_content_res_StringBlock_Height$chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm, TextPaint paint) {
            int size = this.mSize;
            if (paint != null) {
                size = (int)((float)size * paint.density);
            }
            if (fm.bottom - fm.top < size) {
                fm.top = fm.bottom - size;
                fm.ascent -= size;
            } else {
                int need;
                if (sProportion == 0.0f) {
                    Paint p = new Paint();
                    p.setTextSize(100.0f);
                    Rect r = new Rect();
                    p.getTextBounds("ABCDEFG", 0, 7, r);
                    sProportion = (float)r.top / p.ascent();
                }
                if (size - fm.descent >= (need = (int)Math.ceil((float)(-fm.top) * sProportion))) {
                    fm.top = fm.bottom - size;
                    fm.ascent = fm.descent - size;
                } else if (size >= need) {
                    fm.top = fm.ascent = -need;
                    fm.bottom = fm.descent = fm.top + size;
                } else {
                    fm.top = fm.ascent = -size;
                    fm.descent = 0;
                    fm.bottom = 0;
                }
            }
        }

        static void __staticInitializer__() {
            sProportion = 0.0f;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_content_res_StringBlock_Height$__constructor__(n);
        }

        public Height(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_StringBlock_Height$__constructor__(int ), 0, this, n);
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
            InvokeDynamicSupport.bootstrap("chooseHeight", $$robo$$android_content_res_StringBlock_Height$chooseHeight(java.lang.CharSequence int int int int android.graphics.Paint$FontMetricsInt ), 0, this, charSequence, n, n2, n3, n4, fontMetricsInt);
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt, TextPaint textPaint) {
            InvokeDynamicSupport.bootstrap("chooseHeight", $$robo$$android_content_res_StringBlock_Height$chooseHeight(java.lang.CharSequence int int int int android.graphics.Paint$FontMetricsInt android.text.TextPaint ), 0, this, charSequence, n, n2, n3, n4, fontMetricsInt, textPaint);
        }

        static {
            RobolectricInternals.classInitializing(Height.class);
        }

        public /* synthetic */ Height() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Height)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class StyleIDs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int boldId;
        private int italicId;
        private int underlineId;
        private int ttId;
        private int bigId;
        private int smallId;
        private int subId;
        private int supId;
        private int strikeId;
        private int listItemId;
        private int marqueeId;

        private void $$robo$$android_content_res_StringBlock_StyleIDs$__constructor__() {
            this.boldId = -1;
            this.italicId = -1;
            this.underlineId = -1;
            this.ttId = -1;
            this.bigId = -1;
            this.smallId = -1;
            this.subId = -1;
            this.supId = -1;
            this.strikeId = -1;
            this.listItemId = -1;
            this.marqueeId = -1;
        }

        private void __constructor__() {
            this.$$robo$$android_content_res_StringBlock_StyleIDs$__constructor__();
        }

        StyleIDs() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_StringBlock_StyleIDs$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StyleIDs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

