/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.animation.Animator;
import android.animation.StateListAnimator;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.ComplexColor;
import android.content.res.Configuration;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableInflater;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pools;
import android.util.TypedValue;
import android.view.DisplayAdjustments;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import com.android.internal.R;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class Resources
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "Resources";
    private static Object sSync;
    static Resources mSystem;
    private ResourcesImpl mResourcesImpl;
    Pools.SynchronizedPool<TypedArray> mTypedArrayPool;
    private DrawableInflater mDrawableInflater;
    private Object mTmpValueLock;
    private TypedValue mTmpValue;
    ClassLoader mClassLoader;
    private ArrayList<WeakReference<Theme>> mThemeRefs;

    private static final int $$robo$$android_content_res_Resources$selectDefaultTheme(int curTheme, int targetSdkVersion) {
        return Resources.selectSystemTheme(curTheme, targetSdkVersion, 16973829, 16973931, 16974120, 16974143);
    }

    private static final int $$robo$$android_content_res_Resources$selectSystemTheme(int curTheme, int targetSdkVersion, int orig, int holo, int dark, int deviceDefault) {
        if (curTheme != 0) {
            return curTheme;
        }
        if (targetSdkVersion < 11) {
            return orig;
        }
        if (targetSdkVersion < 14) {
            return holo;
        }
        if (targetSdkVersion < 24) {
            return dark;
        }
        return deviceDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Resources $$robo$$android_content_res_Resources$getSystem() {
        Object object = sSync;
        synchronized (object) {
            Resources ret = mSystem;
            if (ret == null) {
                mSystem = ret = new Resources();
            }
            return ret;
        }
    }

    private void $$robo$$android_content_res_Resources$__constructor__(AssetManager assets, DisplayMetrics metrics, Configuration config) {
        this.mResourcesImpl = new ResourcesImpl(assets, metrics, config, new DisplayAdjustments());
    }

    private void $$robo$$android_content_res_Resources$__constructor__(ClassLoader classLoader) {
        this.mTypedArrayPool = new Pools.SynchronizedPool(5);
        this.mTmpValueLock = new Object();
        this.mTmpValue = new TypedValue();
        this.mThemeRefs = new ArrayList();
        this.mClassLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    private void $$robo$$android_content_res_Resources$__constructor__() {
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        Configuration config = new Configuration();
        config.setToDefaults();
        this.mResourcesImpl = new ResourcesImpl(AssetManager.getSystem(), metrics, config, new DisplayAdjustments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$setImpl(ResourcesImpl impl) {
        if (impl == this.mResourcesImpl) {
            return;
        }
        this.mResourcesImpl = impl;
        ArrayList<WeakReference<Theme>> arrayList = this.mThemeRefs;
        synchronized (arrayList) {
            int count = this.mThemeRefs.size();
            for (int i = 0; i < count; ++i) {
                Theme theme;
                WeakReference<Theme> weakThemeRef = this.mThemeRefs.get(i);
                Theme theme2 = theme = weakThemeRef != null ? (Theme)weakThemeRef.get() : null;
                if (theme == null) continue;
                theme.setImpl(this.mResourcesImpl.newThemeImpl(theme.getKey()));
            }
        }
    }

    private final ResourcesImpl $$robo$$android_content_res_Resources$getImpl() {
        return this.mResourcesImpl;
    }

    private final ClassLoader $$robo$$android_content_res_Resources$getClassLoader() {
        return this.mClassLoader;
    }

    private final DrawableInflater $$robo$$android_content_res_Resources$getDrawableInflater() {
        if (this.mDrawableInflater == null) {
            this.mDrawableInflater = new DrawableInflater(this, this.mClassLoader);
        }
        return this.mDrawableInflater;
    }

    private final ConfigurationBoundResourceCache<Animator> $$robo$$android_content_res_Resources$getAnimatorCache() {
        return this.mResourcesImpl.getAnimatorCache();
    }

    private final ConfigurationBoundResourceCache<StateListAnimator> $$robo$$android_content_res_Resources$getStateListAnimatorCache() {
        return this.mResourcesImpl.getStateListAnimatorCache();
    }

    private final CharSequence $$robo$$android_content_res_Resources$getText(int id2) throws NotFoundException {
        CharSequence res = this.mResourcesImpl.getAssets().getResourceText(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    private final CharSequence $$robo$$android_content_res_Resources$getQuantityText(int id2, int quantity) throws NotFoundException {
        return this.mResourcesImpl.getQuantityText(id2, quantity);
    }

    private final String $$robo$$android_content_res_Resources$getString(int id2) throws NotFoundException {
        return this.getText(id2).toString();
    }

    private final String $$robo$$android_content_res_Resources$getString(int id2, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getString(id2);
        return String.format(this.mResourcesImpl.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    private final String $$robo$$android_content_res_Resources$getQuantityString(int id2, int quantity, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getQuantityText(id2, quantity).toString();
        return String.format(this.mResourcesImpl.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    private final String $$robo$$android_content_res_Resources$getQuantityString(int id2, int quantity) throws NotFoundException {
        return this.getQuantityText(id2, quantity).toString();
    }

    private final CharSequence $$robo$$android_content_res_Resources$getText(int id2, CharSequence def) {
        CharSequence res = id2 != 0 ? this.mResourcesImpl.getAssets().getResourceText(id2) : null;
        return res != null ? res : def;
    }

    private final CharSequence[] $$robo$$android_content_res_Resources$getTextArray(int id2) throws NotFoundException {
        CharSequence[] res = this.mResourcesImpl.getAssets().getResourceTextArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(id2));
    }

    private final String[] $$robo$$android_content_res_Resources$getStringArray(int id2) throws NotFoundException {
        String[] res = this.mResourcesImpl.getAssets().getResourceStringArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(id2));
    }

    private final int[] $$robo$$android_content_res_Resources$getIntArray(int id2) throws NotFoundException {
        int[] res = this.mResourcesImpl.getAssets().getArrayIntResource(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(id2));
    }

    private final TypedArray $$robo$$android_content_res_Resources$obtainTypedArray(int id2) throws NotFoundException {
        ResourcesImpl impl = this.mResourcesImpl;
        int len = impl.getAssets().getArraySize(id2);
        if (len < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        TypedArray array2 = TypedArray.obtain(this, len);
        array2.mLength = impl.getAssets().retrieveArray(id2, array2.mData);
        array2.mIndices[0] = 0;
        return array2;
    }

    private final float $$robo$$android_content_res_Resources$getDimension(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                float f = TypedValue.complexToDimension(value.data, impl.getDisplayMetrics());
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final int $$robo$$android_content_res_Resources$getDimensionPixelOffset(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                int n = TypedValue.complexToDimensionPixelOffset(value.data, impl.getDisplayMetrics());
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final int $$robo$$android_content_res_Resources$getDimensionPixelSize(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                int n = TypedValue.complexToDimensionPixelSize(value.data, impl.getDisplayMetrics());
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final float $$robo$$android_content_res_Resources$getFraction(int id2, int base, int pbase) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type == 6) {
                float f = TypedValue.complexToFraction(value.data, base, pbase);
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @Deprecated
    private final Drawable $$robo$$android_content_res_Resources$getDrawable(int id2) throws NotFoundException {
        Drawable d = this.getDrawable(id2, null);
        if (d != null && d.canApplyTheme()) {
            Log.w("Resources", "Drawable " + this.getResourceName(id2) + " has unresolved theme attributes! Consider using Resources.getDrawable(int, Theme) or Context.getDrawable(int).", new RuntimeException());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_content_res_Resources$getDrawable(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            Drawable drawable2 = impl.loadDrawable(this, value, id2, theme, true);
            return drawable2;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @Deprecated
    private final Drawable $$robo$$android_content_res_Resources$getDrawableForDensity(int id2, int density) throws NotFoundException {
        return this.getDrawableForDensity(id2, density, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Drawable $$robo$$android_content_res_Resources$getDrawableForDensity(int id2, int density, Theme theme) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            boolean useCache;
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValueForDensity(id2, density, value, true);
            DisplayMetrics metrics = impl.getDisplayMetrics();
            boolean bl = useCache = value.density == metrics.densityDpi;
            if (value.density > 0 && value.density != 65535) {
                value.density = value.density == density ? metrics.densityDpi : value.density * metrics.densityDpi / density;
            }
            Drawable drawable2 = impl.loadDrawable(this, value, id2, theme, useCache);
            return drawable2;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final Drawable $$robo$$android_content_res_Resources$loadDrawable(TypedValue value, int id2, Theme theme) throws NotFoundException {
        return this.mResourcesImpl.loadDrawable(this, value, id2, theme, true);
    }

    private final Movie $$robo$$android_content_res_Resources$getMovie(int id2) throws NotFoundException {
        InputStream is = this.openRawResource(id2);
        Movie movie = Movie.decodeStream(is);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return movie;
    }

    @Deprecated
    private final int $$robo$$android_content_res_Resources$getColor(int id2) throws NotFoundException {
        return this.getColor(id2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_Resources$getColor(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                int n = value.data;
                return n;
            }
            if (value.type != 3) {
                throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
            }
            ColorStateList csl = impl.loadColorStateList(this, value, id2, theme);
            int n = csl.getDefaultColor();
            return n;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @Deprecated
    private final ColorStateList $$robo$$android_content_res_Resources$getColorStateList(int id2) throws NotFoundException {
        ColorStateList csl = this.getColorStateList(id2, null);
        if (csl != null && csl.canApplyTheme()) {
            Log.w("Resources", "ColorStateList " + this.getResourceName(id2) + " has unresolved theme attributes! Consider using Resources.getColorStateList(int, Theme) or Context.getColorStateList(int).", new RuntimeException());
        }
        return csl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ColorStateList $$robo$$android_content_res_Resources$getColorStateList(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            ColorStateList colorStateList = impl.loadColorStateList(this, value, id2, theme);
            return colorStateList;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final ColorStateList $$robo$$android_content_res_Resources$loadColorStateList(TypedValue value, int id2, Theme theme) throws NotFoundException {
        return this.mResourcesImpl.loadColorStateList(this, value, id2, theme);
    }

    private final ComplexColor $$robo$$android_content_res_Resources$loadComplexColor(TypedValue value, int id2, Theme theme) {
        return this.mResourcesImpl.loadComplexColor(this, value, id2, theme);
    }

    private final boolean $$robo$$android_content_res_Resources$getBoolean(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                boolean bl = value.data != 0;
                return bl;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final int $$robo$$android_content_res_Resources$getInteger(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                int n = value.data;
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final float $$robo$$android_content_res_Resources$getFloat(int id2) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type == 4) {
                float f = value.getFloat();
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$getLayout(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "layout");
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$getAnimation(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "anim");
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$getXml(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_content_res_Resources$openRawResource(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            InputStream inputStream = this.openRawResource(id2, value);
            return inputStream;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TypedValue $$robo$$android_content_res_Resources$obtainTempTypedValue() {
        TypedValue tmpValue = null;
        Object object = this.mTmpValueLock;
        synchronized (object) {
            if (this.mTmpValue != null) {
                tmpValue = this.mTmpValue;
                this.mTmpValue = null;
            }
        }
        if (tmpValue == null) {
            return new TypedValue();
        }
        return tmpValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_Resources$releaseTempTypedValue(TypedValue value) {
        Object object = this.mTmpValueLock;
        synchronized (object) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
    }

    private final InputStream $$robo$$android_content_res_Resources$openRawResource(int id2, TypedValue value) throws NotFoundException {
        return this.mResourcesImpl.openRawResource(id2, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AssetFileDescriptor $$robo$$android_content_res_Resources$openRawResourceFd(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            AssetFileDescriptor assetFileDescriptor = this.mResourcesImpl.openRawResourceFd(id2, value);
            return assetFileDescriptor;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final void $$robo$$android_content_res_Resources$getValue(int id2, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValue(id2, outValue, resolveRefs);
    }

    private final void $$robo$$android_content_res_Resources$getValueForDensity(int id2, int density, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValueForDensity(id2, density, outValue, resolveRefs);
    }

    private final void $$robo$$android_content_res_Resources$getValue(String name, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValue(name, outValue, resolveRefs);
    }

    private final Theme $$robo$$android_content_res_Resources$newTheme() {
        Theme theme = new Theme(this);
        theme.setImpl(this.mResourcesImpl.newThemeImpl());
        this.mThemeRefs.add(new WeakReference<Theme>(theme));
        return theme;
    }

    private final TypedArray $$robo$$android_content_res_Resources$obtainAttributes(AttributeSet set, int[] attrs) {
        int len = attrs.length;
        TypedArray array2 = TypedArray.obtain(this, len);
        XmlBlock.Parser parser = (XmlBlock.Parser)set;
        this.mResourcesImpl.getAssets().retrieveAttributes(parser.mParseState, attrs, array2.mData, array2.mIndices);
        array2.mXml = parser;
        return array2;
    }

    private final void $$robo$$android_content_res_Resources$updateConfiguration(Configuration config, DisplayMetrics metrics) {
        this.updateConfiguration(config, metrics, null);
    }

    private final void $$robo$$android_content_res_Resources$updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        this.mResourcesImpl.updateConfiguration(config, metrics, compat);
    }

    private static final void $$robo$$android_content_res_Resources$updateSystemConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        if (mSystem != null) {
            mSystem.updateConfiguration(config, metrics, compat);
        }
    }

    private final DisplayMetrics $$robo$$android_content_res_Resources$getDisplayMetrics() {
        return this.mResourcesImpl.getDisplayMetrics();
    }

    private final DisplayAdjustments $$robo$$android_content_res_Resources$getDisplayAdjustments() {
        return this.mResourcesImpl.getDisplayAdjustments();
    }

    private final Configuration $$robo$$android_content_res_Resources$getConfiguration() {
        return this.mResourcesImpl.getConfiguration();
    }

    private final Configuration[] $$robo$$android_content_res_Resources$getSizeConfigurations() {
        return this.mResourcesImpl.getSizeConfigurations();
    }

    private final CompatibilityInfo $$robo$$android_content_res_Resources$getCompatibilityInfo() {
        return this.mResourcesImpl.getCompatibilityInfo();
    }

    private final void $$robo$$android_content_res_Resources$setCompatibilityInfo(CompatibilityInfo ci) {
        if (ci != null) {
            this.mResourcesImpl.updateConfiguration(null, null, ci);
        }
    }

    private final int $$robo$$android_content_res_Resources$getIdentifier(String name, String defType, String defPackage) {
        return this.mResourcesImpl.getIdentifier(name, defType, defPackage);
    }

    private static final boolean $$robo$$android_content_res_Resources$resourceHasPackage(int resid) {
        return resid >>> 24 != 0;
    }

    private final String $$robo$$android_content_res_Resources$getResourceName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceName(resid);
    }

    private final String $$robo$$android_content_res_Resources$getResourcePackageName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourcePackageName(resid);
    }

    private final String $$robo$$android_content_res_Resources$getResourceTypeName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceTypeName(resid);
    }

    private final String $$robo$$android_content_res_Resources$getResourceEntryName(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceEntryName(resid);
    }

    private final void $$robo$$android_content_res_Resources$parseBundleExtras(XmlResourceParser parser, Bundle outBundle) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("extra")) {
                this.parseBundleExtra("extra", parser, outBundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void $$robo$$android_content_res_Resources$parseBundleExtra(String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = this.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:value or android:resource attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs = v.coerceToString();
            outBundle.putCharSequence(name, cs);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    private final AssetManager $$robo$$android_content_res_Resources$getAssets() {
        return this.mResourcesImpl.getAssets();
    }

    private final void $$robo$$android_content_res_Resources$flushLayoutCache() {
        this.mResourcesImpl.flushLayoutCache();
    }

    private final void $$robo$$android_content_res_Resources$startPreloading() {
        this.mResourcesImpl.startPreloading();
    }

    private final void $$robo$$android_content_res_Resources$finishPreloading() {
        this.mResourcesImpl.finishPreloading();
    }

    private final LongSparseArray<Drawable.ConstantState> $$robo$$android_content_res_Resources$getPreloadedDrawables() {
        return this.mResourcesImpl.getPreloadedDrawables();
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$loadXmlResourceParser(int id2, String type) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 3) {
                XmlResourceParser xmlResourceParser = impl.loadXmlResourceParser(value.string.toString(), id2, value.assetCookie, type);
                return xmlResourceParser;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    private final XmlResourceParser $$robo$$android_content_res_Resources$loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws NotFoundException {
        return this.mResourcesImpl.loadXmlResourceParser(file, id2, assetCookie, type);
    }

    private final int $$robo$$android_content_res_Resources$calcConfigChanges(Configuration config) {
        return this.mResourcesImpl.calcConfigChanges(config);
    }

    private static final TypedArray $$robo$$android_content_res_Resources$obtainAttributes(Resources res, Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    static void __staticInitializer__() {
        sSync = new Object();
        mSystem = null;
    }

    public static int selectDefaultTheme(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("selectDefaultTheme", $$robo$$android_content_res_Resources$selectDefaultTheme(int int ), 0, (int)n, (int)n2);
    }

    public static int selectSystemTheme(int n, int n2, int n3, int n4, int n5, int n6) {
        return (int)InvokeDynamicSupport.bootstrapStatic("selectSystemTheme", $$robo$$android_content_res_Resources$selectSystemTheme(int int int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6);
    }

    public static Resources getSystem() {
        return InvokeDynamicSupport.bootstrapStatic("getSystem", $$robo$$android_content_res_Resources$getSystem(), 0);
    }

    private void __constructor__(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration) {
        this.$$robo$$android_content_res_Resources$__constructor__(assetManager, displayMetrics, configuration);
    }

    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration) {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources$__constructor__(android.content.res.AssetManager android.util.DisplayMetrics android.content.res.Configuration ), 0, this, assetManager, displayMetrics, configuration);
    }

    private void __constructor__(ClassLoader classLoader) {
        this.$$robo$$android_content_res_Resources$__constructor__(classLoader);
    }

    public Resources(ClassLoader classLoader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources$__constructor__(java.lang.ClassLoader ), 0, this, classLoader);
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_Resources$__constructor__();
    }

    private Resources() {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources$__constructor__(), 0, this);
    }

    public void setImpl(ResourcesImpl resourcesImpl) {
        InvokeDynamicSupport.bootstrap("setImpl", $$robo$$android_content_res_Resources$setImpl(android.content.res.ResourcesImpl ), 0, this, resourcesImpl);
    }

    public ResourcesImpl getImpl() {
        return InvokeDynamicSupport.bootstrap("getImpl", $$robo$$android_content_res_Resources$getImpl(), 0, this);
    }

    public ClassLoader getClassLoader() {
        return InvokeDynamicSupport.bootstrap("getClassLoader", $$robo$$android_content_res_Resources$getClassLoader(), 0, this);
    }

    public DrawableInflater getDrawableInflater() {
        return InvokeDynamicSupport.bootstrap("getDrawableInflater", $$robo$$android_content_res_Resources$getDrawableInflater(), 0, this);
    }

    public ConfigurationBoundResourceCache<Animator> getAnimatorCache() {
        return InvokeDynamicSupport.bootstrap("getAnimatorCache", $$robo$$android_content_res_Resources$getAnimatorCache(), 0, this);
    }

    public ConfigurationBoundResourceCache<StateListAnimator> getStateListAnimatorCache() {
        return InvokeDynamicSupport.bootstrap("getStateListAnimatorCache", $$robo$$android_content_res_Resources$getStateListAnimatorCache(), 0, this);
    }

    public CharSequence getText(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_res_Resources$getText(int ), 0, this, n);
    }

    public CharSequence getQuantityText(int n, int n2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityText", $$robo$$android_content_res_Resources$getQuantityText(int int ), 0, this, n, n2);
    }

    public String getString(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_content_res_Resources$getString(int ), 0, this, n);
    }

    public String getString(int n, Object ... objectArray) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_content_res_Resources$getString(int java.lang.Object[] ), 0, this, n, objectArray);
    }

    public String getQuantityString(int n, int n2, Object ... objectArray) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityString", $$robo$$android_content_res_Resources$getQuantityString(int int java.lang.Object[] ), 0, this, n, n2, objectArray);
    }

    public String getQuantityString(int n, int n2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getQuantityString", $$robo$$android_content_res_Resources$getQuantityString(int int ), 0, this, n, n2);
    }

    public CharSequence getText(int n, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_res_Resources$getText(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public CharSequence[] getTextArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getTextArray", $$robo$$android_content_res_Resources$getTextArray(int ), 0, this, n);
    }

    public String[] getStringArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getStringArray", $$robo$$android_content_res_Resources$getStringArray(int ), 0, this, n);
    }

    public int[] getIntArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getIntArray", $$robo$$android_content_res_Resources$getIntArray(int ), 0, this, n);
    }

    public TypedArray obtainTypedArray(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("obtainTypedArray", $$robo$$android_content_res_Resources$obtainTypedArray(int ), 0, this, n);
    }

    public float getDimension(int n) throws NotFoundException {
        return (float)InvokeDynamicSupport.bootstrap("getDimension", $$robo$$android_content_res_Resources$getDimension(int ), 0, this, n);
    }

    public int getDimensionPixelOffset(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionPixelOffset", $$robo$$android_content_res_Resources$getDimensionPixelOffset(int ), 0, this, n);
    }

    public int getDimensionPixelSize(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getDimensionPixelSize", $$robo$$android_content_res_Resources$getDimensionPixelSize(int ), 0, this, n);
    }

    public float getFraction(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("getFraction", $$robo$$android_content_res_Resources$getFraction(int int int ), 0, this, n, n2, n3);
    }

    @Deprecated
    public Drawable getDrawable(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_Resources$getDrawable(int ), 0, this, n);
    }

    public Drawable getDrawable(int n, Theme theme) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_Resources$getDrawable(int android.content.res.Resources$Theme ), 0, this, n, theme);
    }

    @Deprecated
    public Drawable getDrawableForDensity(int n, int n2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getDrawableForDensity", $$robo$$android_content_res_Resources$getDrawableForDensity(int int ), 0, this, n, n2);
    }

    public Drawable getDrawableForDensity(int n, int n2, Theme theme) {
        return InvokeDynamicSupport.bootstrap("getDrawableForDensity", $$robo$$android_content_res_Resources$getDrawableForDensity(int int android.content.res.Resources$Theme ), 0, this, n, n2, theme);
    }

    Drawable loadDrawable(TypedValue typedValue, int n, Theme theme) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadDrawable", $$robo$$android_content_res_Resources$loadDrawable(android.util.TypedValue int android.content.res.Resources$Theme ), 0, this, typedValue, n, theme);
    }

    public Movie getMovie(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getMovie", $$robo$$android_content_res_Resources$getMovie(int ), 0, this, n);
    }

    @Deprecated
    public int getColor(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_content_res_Resources$getColor(int ), 0, this, n);
    }

    public int getColor(int n, Theme theme) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_content_res_Resources$getColor(int android.content.res.Resources$Theme ), 0, this, n, theme);
    }

    @Deprecated
    public ColorStateList getColorStateList(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getColorStateList", $$robo$$android_content_res_Resources$getColorStateList(int ), 0, this, n);
    }

    public ColorStateList getColorStateList(int n, Theme theme) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getColorStateList", $$robo$$android_content_res_Resources$getColorStateList(int android.content.res.Resources$Theme ), 0, this, n, theme);
    }

    ColorStateList loadColorStateList(TypedValue typedValue, int n, Theme theme) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadColorStateList", $$robo$$android_content_res_Resources$loadColorStateList(android.util.TypedValue int android.content.res.Resources$Theme ), 0, this, typedValue, n, theme);
    }

    public ComplexColor loadComplexColor(TypedValue typedValue, int n, Theme theme) {
        return InvokeDynamicSupport.bootstrap("loadComplexColor", $$robo$$android_content_res_Resources$loadComplexColor(android.util.TypedValue int android.content.res.Resources$Theme ), 0, this, typedValue, n, theme);
    }

    public boolean getBoolean(int n) throws NotFoundException {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$android_content_res_Resources$getBoolean(int ), 0, this, n);
    }

    public int getInteger(int n) throws NotFoundException {
        return (int)InvokeDynamicSupport.bootstrap("getInteger", $$robo$$android_content_res_Resources$getInteger(int ), 0, this, n);
    }

    public float getFloat(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_content_res_Resources$getFloat(int ), 0, this, n);
    }

    public XmlResourceParser getLayout(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getLayout", $$robo$$android_content_res_Resources$getLayout(int ), 0, this, n);
    }

    public XmlResourceParser getAnimation(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getAnimation", $$robo$$android_content_res_Resources$getAnimation(int ), 0, this, n);
    }

    public XmlResourceParser getXml(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getXml", $$robo$$android_content_res_Resources$getXml(int ), 0, this, n);
    }

    public InputStream openRawResource(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResource", $$robo$$android_content_res_Resources$openRawResource(int ), 0, this, n);
    }

    private TypedValue obtainTempTypedValue() {
        return InvokeDynamicSupport.bootstrap("obtainTempTypedValue", $$robo$$android_content_res_Resources$obtainTempTypedValue(), 0, this);
    }

    private void releaseTempTypedValue(TypedValue typedValue) {
        InvokeDynamicSupport.bootstrap("releaseTempTypedValue", $$robo$$android_content_res_Resources$releaseTempTypedValue(android.util.TypedValue ), 0, this, typedValue);
    }

    public InputStream openRawResource(int n, TypedValue typedValue) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResource", $$robo$$android_content_res_Resources$openRawResource(int android.util.TypedValue ), 0, this, n, typedValue);
    }

    public AssetFileDescriptor openRawResourceFd(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("openRawResourceFd", $$robo$$android_content_res_Resources$openRawResourceFd(int ), 0, this, n);
    }

    public void getValue(int n, TypedValue typedValue, boolean bl) throws NotFoundException {
        InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_Resources$getValue(int android.util.TypedValue boolean ), 0, this, n, typedValue, bl);
    }

    public void getValueForDensity(int n, int n2, TypedValue typedValue, boolean bl) throws NotFoundException {
        InvokeDynamicSupport.bootstrap("getValueForDensity", $$robo$$android_content_res_Resources$getValueForDensity(int int android.util.TypedValue boolean ), 0, this, n, n2, typedValue, bl);
    }

    public void getValue(String string2, TypedValue typedValue, boolean bl) throws NotFoundException {
        InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_content_res_Resources$getValue(java.lang.String android.util.TypedValue boolean ), 0, this, string2, typedValue, bl);
    }

    public Theme newTheme() {
        return InvokeDynamicSupport.bootstrap("newTheme", $$robo$$android_content_res_Resources$newTheme(), 0, this);
    }

    public TypedArray obtainAttributes(AttributeSet attributeSet, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("obtainAttributes", $$robo$$android_content_res_Resources$obtainAttributes(android.util.AttributeSet int[] ), 0, this, attributeSet, nArray);
    }

    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("updateConfiguration", $$robo$$android_content_res_Resources$updateConfiguration(android.content.res.Configuration android.util.DisplayMetrics ), 0, this, configuration, displayMetrics);
    }

    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrap("updateConfiguration", $$robo$$android_content_res_Resources$updateConfiguration(android.content.res.Configuration android.util.DisplayMetrics android.content.res.CompatibilityInfo ), 0, this, configuration, displayMetrics, compatibilityInfo);
    }

    public static void updateSystemConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrapStatic("updateSystemConfiguration", $$robo$$android_content_res_Resources$updateSystemConfiguration(android.content.res.Configuration android.util.DisplayMetrics android.content.res.CompatibilityInfo ), 0, (Configuration)configuration, (DisplayMetrics)displayMetrics, (CompatibilityInfo)compatibilityInfo);
    }

    public DisplayMetrics getDisplayMetrics() {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_content_res_Resources$getDisplayMetrics(), 0, this);
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return InvokeDynamicSupport.bootstrap("getDisplayAdjustments", $$robo$$android_content_res_Resources$getDisplayAdjustments(), 0, this);
    }

    public Configuration getConfiguration() {
        return InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_content_res_Resources$getConfiguration(), 0, this);
    }

    public Configuration[] getSizeConfigurations() {
        return InvokeDynamicSupport.bootstrap("getSizeConfigurations", $$robo$$android_content_res_Resources$getSizeConfigurations(), 0, this);
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return InvokeDynamicSupport.bootstrap("getCompatibilityInfo", $$robo$$android_content_res_Resources$getCompatibilityInfo(), 0, this);
    }

    public void setCompatibilityInfo(CompatibilityInfo compatibilityInfo) {
        InvokeDynamicSupport.bootstrap("setCompatibilityInfo", $$robo$$android_content_res_Resources$setCompatibilityInfo(android.content.res.CompatibilityInfo ), 0, this, compatibilityInfo);
    }

    public int getIdentifier(String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("getIdentifier", $$robo$$android_content_res_Resources$getIdentifier(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public static boolean resourceHasPackage(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resourceHasPackage", $$robo$$android_content_res_Resources$resourceHasPackage(int ), 0, (int)n);
    }

    public String getResourceName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceName", $$robo$$android_content_res_Resources$getResourceName(int ), 0, this, n);
    }

    public String getResourcePackageName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourcePackageName", $$robo$$android_content_res_Resources$getResourcePackageName(int ), 0, this, n);
    }

    public String getResourceTypeName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceTypeName", $$robo$$android_content_res_Resources$getResourceTypeName(int ), 0, this, n);
    }

    public String getResourceEntryName(int n) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceEntryName", $$robo$$android_content_res_Resources$getResourceEntryName(int ), 0, this, n);
    }

    public void parseBundleExtras(XmlResourceParser xmlResourceParser, Bundle bundle) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("parseBundleExtras", $$robo$$android_content_res_Resources$parseBundleExtras(android.content.res.XmlResourceParser android.os.Bundle ), 0, this, xmlResourceParser, bundle);
    }

    public void parseBundleExtra(String string2, AttributeSet attributeSet, Bundle bundle) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("parseBundleExtra", $$robo$$android_content_res_Resources$parseBundleExtra(java.lang.String android.util.AttributeSet android.os.Bundle ), 0, this, string2, attributeSet, bundle);
    }

    public AssetManager getAssets() {
        return InvokeDynamicSupport.bootstrap("getAssets", $$robo$$android_content_res_Resources$getAssets(), 0, this);
    }

    public void flushLayoutCache() {
        InvokeDynamicSupport.bootstrap("flushLayoutCache", $$robo$$android_content_res_Resources$flushLayoutCache(), 0, this);
    }

    public void startPreloading() {
        InvokeDynamicSupport.bootstrap("startPreloading", $$robo$$android_content_res_Resources$startPreloading(), 0, this);
    }

    public void finishPreloading() {
        InvokeDynamicSupport.bootstrap("finishPreloading", $$robo$$android_content_res_Resources$finishPreloading(), 0, this);
    }

    public LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return InvokeDynamicSupport.bootstrap("getPreloadedDrawables", $$robo$$android_content_res_Resources$getPreloadedDrawables(), 0, this);
    }

    XmlResourceParser loadXmlResourceParser(int n, String string2) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadXmlResourceParser", $$robo$$android_content_res_Resources$loadXmlResourceParser(int java.lang.String ), 0, this, n, string2);
    }

    XmlResourceParser loadXmlResourceParser(String string2, int n, int n2, String string3) throws NotFoundException {
        return InvokeDynamicSupport.bootstrap("loadXmlResourceParser", $$robo$$android_content_res_Resources$loadXmlResourceParser(java.lang.String int int java.lang.String ), 0, this, string2, n, n2, string3);
    }

    public int calcConfigChanges(Configuration configuration) {
        return (int)InvokeDynamicSupport.bootstrap("calcConfigChanges", $$robo$$android_content_res_Resources$calcConfigChanges(android.content.res.Configuration ), 0, this, configuration);
    }

    public static TypedArray obtainAttributes(Resources resources, Theme theme, AttributeSet attributeSet, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("obtainAttributes", $$robo$$android_content_res_Resources$obtainAttributes(android.content.res.Resources android.content.res.Resources$Theme android.util.AttributeSet int[] ), 0, (Resources)resources, (Theme)theme, (AttributeSet)attributeSet, (int[])nArray);
    }

    static {
        RobolectricInternals.classInitializing(Resources.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Resources)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ThemeKey
    implements Cloneable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mResId;
        boolean[] mForce;
        int mCount;
        private int mHashCode;

        private void $$robo$$android_content_res_Resources_ThemeKey$__constructor__() {
            this.mHashCode = 0;
        }

        private final void $$robo$$android_content_res_Resources_ThemeKey$append(int resId, boolean force) {
            if (this.mResId == null) {
                this.mResId = new int[4];
            }
            if (this.mForce == null) {
                this.mForce = new boolean[4];
            }
            this.mResId = GrowingArrayUtils.append(this.mResId, this.mCount, resId);
            this.mForce = GrowingArrayUtils.append(this.mForce, this.mCount, force);
            ++this.mCount;
            this.mHashCode = 31 * (31 * this.mHashCode + resId) + (force ? 1 : 0);
        }

        private final void $$robo$$android_content_res_Resources_ThemeKey$setTo(ThemeKey other) {
            this.mResId = other.mResId == null ? null : (int[])other.mResId.clone();
            this.mForce = other.mForce == null ? null : (boolean[])other.mForce.clone();
            this.mCount = other.mCount;
        }

        private final int $$robo$$android_content_res_Resources_ThemeKey$hashCode() {
            return this.mHashCode;
        }

        private final boolean $$robo$$android_content_res_Resources_ThemeKey$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || this.hashCode() != o.hashCode()) {
                return false;
            }
            ThemeKey t = (ThemeKey)o;
            if (this.mCount != t.mCount) {
                return false;
            }
            int N = this.mCount;
            for (int i = 0; i < N; ++i) {
                if (this.mResId[i] == t.mResId[i] && this.mForce[i] == t.mForce[i]) continue;
                return false;
            }
            return true;
        }

        private final ThemeKey $$robo$$android_content_res_Resources_ThemeKey$clone() {
            ThemeKey other = new ThemeKey();
            other.mResId = this.mResId;
            other.mForce = this.mForce;
            other.mCount = this.mCount;
            other.mHashCode = this.mHashCode;
            return other;
        }

        private void __constructor__() {
            this.$$robo$$android_content_res_Resources_ThemeKey$__constructor__();
        }

        ThemeKey() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_ThemeKey$__constructor__(), 0, this);
        }

        public void append(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_content_res_Resources_ThemeKey$append(int boolean ), 0, this, n, bl);
        }

        public void setTo(ThemeKey themeKey) {
            InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_content_res_Resources_ThemeKey$setTo(android.content.res.Resources$ThemeKey ), 0, this, themeKey);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_res_Resources_ThemeKey$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_res_Resources_ThemeKey$equals(java.lang.Object ), 0, this, object);
        }

        public ThemeKey clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_content_res_Resources_ThemeKey$clone(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThemeKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class Theme
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ResourcesImpl.ThemeImpl mThemeImpl;
        /* synthetic */ Resources this$0;

        private void $$robo$$android_content_res_Resources_Theme$__constructor__(Resources this$0) {
        }

        private final void $$robo$$android_content_res_Resources_Theme$setImpl(ResourcesImpl.ThemeImpl impl) {
            this.mThemeImpl = impl;
        }

        private final void $$robo$$android_content_res_Resources_Theme$applyStyle(int resId, boolean force) {
            this.mThemeImpl.applyStyle(resId, force);
        }

        private final void $$robo$$android_content_res_Resources_Theme$setTo(Theme other) {
            this.mThemeImpl.setTo(other.mThemeImpl);
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int[] attrs) {
            return this.mThemeImpl.obtainStyledAttributes(this, null, attrs, 0, 0);
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int resId, int[] attrs) throws NotFoundException {
            return this.mThemeImpl.obtainStyledAttributes(this, null, attrs, 0, resId);
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            return this.mThemeImpl.obtainStyledAttributes(this, set, attrs, defStyleAttr, defStyleRes);
        }

        private final TypedArray $$robo$$android_content_res_Resources_Theme$resolveAttributes(int[] values, int[] attrs) {
            return this.mThemeImpl.resolveAttributes(this, values, attrs);
        }

        private final boolean $$robo$$android_content_res_Resources_Theme$resolveAttribute(int resid, TypedValue outValue, boolean resolveRefs) {
            return this.mThemeImpl.resolveAttribute(resid, outValue, resolveRefs);
        }

        private final int[] $$robo$$android_content_res_Resources_Theme$getAllAttributes() {
            return this.mThemeImpl.getAllAttributes();
        }

        private final Resources $$robo$$android_content_res_Resources_Theme$getResources() {
            return this.this$0;
        }

        private final Drawable $$robo$$android_content_res_Resources_Theme$getDrawable(int id2) throws NotFoundException {
            return this.this$0.getDrawable(id2, this);
        }

        private final int $$robo$$android_content_res_Resources_Theme$getChangingConfigurations() {
            return this.mThemeImpl.getChangingConfigurations();
        }

        private final void $$robo$$android_content_res_Resources_Theme$dump(int priority, String tag, String prefix) {
            this.mThemeImpl.dump(priority, tag, prefix);
        }

        private final long $$robo$$android_content_res_Resources_Theme$getNativeTheme() {
            return this.mThemeImpl.getNativeTheme();
        }

        private final int $$robo$$android_content_res_Resources_Theme$getAppliedStyleResId() {
            return this.mThemeImpl.getAppliedStyleResId();
        }

        private final ThemeKey $$robo$$android_content_res_Resources_Theme$getKey() {
            return this.mThemeImpl.getKey();
        }

        private final String $$robo$$android_content_res_Resources_Theme$getResourceNameFromHexString(String hexString) {
            return this.this$0.getResourceName(Integer.parseInt(hexString, 16));
        }

        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        private final String[] $$robo$$android_content_res_Resources_Theme$getTheme() {
            return this.mThemeImpl.getTheme();
        }

        private final void $$robo$$android_content_res_Resources_Theme$encode(ViewHierarchyEncoder encoder) {
            encoder.beginObject(this);
            String[] properties = this.getTheme();
            for (int i = 0; i < properties.length; i += 2) {
                encoder.addProperty(properties[i], properties[i + 1]);
            }
            encoder.endObject();
        }

        private final void $$robo$$android_content_res_Resources_Theme$rebase() {
            this.mThemeImpl.rebase();
        }

        private /* synthetic */ void $$robo$$android_content_res_Resources_Theme$__constructor__(Resources x0, 1 x1) {
        }

        private void __constructor__(Resources resources) {
            this.$$robo$$android_content_res_Resources_Theme$__constructor__(resources);
        }

        private Theme(Resources resources) {
            this.this$0 = resources;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_Theme$__constructor__(android.content.res.Resources ), 0, this, resources);
        }

        void setImpl(ResourcesImpl.ThemeImpl themeImpl) {
            InvokeDynamicSupport.bootstrap("setImpl", $$robo$$android_content_res_Resources_Theme$setImpl(android.content.res.ResourcesImpl$ThemeImpl ), 0, this, themeImpl);
        }

        public void applyStyle(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("applyStyle", $$robo$$android_content_res_Resources_Theme$applyStyle(int boolean ), 0, this, n, bl);
        }

        public void setTo(Theme theme) {
            InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_content_res_Resources_Theme$setTo(android.content.res.Resources$Theme ), 0, this, theme);
        }

        public TypedArray obtainStyledAttributes(int[] nArray) {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int[] ), 0, this, nArray);
        }

        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(int int[] ), 0, this, n, nArray);
        }

        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("obtainStyledAttributes", $$robo$$android_content_res_Resources_Theme$obtainStyledAttributes(android.util.AttributeSet int[] int int ), 0, this, attributeSet, nArray, n, n2);
        }

        public TypedArray resolveAttributes(int[] nArray, int[] nArray2) {
            return InvokeDynamicSupport.bootstrap("resolveAttributes", $$robo$$android_content_res_Resources_Theme$resolveAttributes(int[] int[] ), 0, this, nArray, nArray2);
        }

        public boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("resolveAttribute", $$robo$$android_content_res_Resources_Theme$resolveAttribute(int android.util.TypedValue boolean ), 0, this, n, typedValue, bl);
        }

        public int[] getAllAttributes() {
            return InvokeDynamicSupport.bootstrap("getAllAttributes", $$robo$$android_content_res_Resources_Theme$getAllAttributes(), 0, this);
        }

        public Resources getResources() {
            return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_content_res_Resources_Theme$getResources(), 0, this);
        }

        public Drawable getDrawable(int n) throws NotFoundException {
            return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_content_res_Resources_Theme$getDrawable(int ), 0, this, n);
        }

        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_content_res_Resources_Theme$getChangingConfigurations(), 0, this);
        }

        public void dump(int n, String string2, String string3) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_res_Resources_Theme$dump(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
        }

        long getNativeTheme() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeTheme", $$robo$$android_content_res_Resources_Theme$getNativeTheme(), 0, this);
        }

        int getAppliedStyleResId() {
            return (int)InvokeDynamicSupport.bootstrap("getAppliedStyleResId", $$robo$$android_content_res_Resources_Theme$getAppliedStyleResId(), 0, this);
        }

        public ThemeKey getKey() {
            return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_content_res_Resources_Theme$getKey(), 0, this);
        }

        private String getResourceNameFromHexString(String string2) {
            return InvokeDynamicSupport.bootstrap("getResourceNameFromHexString", $$robo$$android_content_res_Resources_Theme$getResourceNameFromHexString(java.lang.String ), 0, this, string2);
        }

        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        public String[] getTheme() {
            return InvokeDynamicSupport.bootstrap("getTheme", $$robo$$android_content_res_Resources_Theme$getTheme(), 0, this);
        }

        public void encode(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encode", $$robo$$android_content_res_Resources_Theme$encode(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
        }

        public void rebase() {
            InvokeDynamicSupport.bootstrap("rebase", $$robo$$android_content_res_Resources_Theme$rebase(), 0, this);
        }

        private /* synthetic */ void __constructor__(Resources resources, 1 var2_2) {
            this.$$robo$$android_content_res_Resources_Theme$__constructor__(resources, var2_2);
        }

        public /* synthetic */ Theme() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Theme)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NotFoundException
    extends RuntimeException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_res_Resources_NotFoundException$__constructor__() {
        }

        private void $$robo$$android_content_res_Resources_NotFoundException$__constructor__(String name) {
        }

        private void $$robo$$android_content_res_Resources_NotFoundException$__constructor__(String name, Exception cause) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_res_Resources_NotFoundException$__constructor__();
        }

        public NotFoundException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_NotFoundException$__constructor__(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_res_Resources_NotFoundException$__constructor__(string2);
        }

        public NotFoundException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_NotFoundException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(String string2, Exception exception) {
            this.$$robo$$android_content_res_Resources_NotFoundException$__constructor__(string2, exception);
        }

        public NotFoundException(String string2, Exception exception) {
            super(string2, exception);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_Resources_NotFoundException$__constructor__(java.lang.String java.lang.Exception ), 0, this, string2, exception);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotFoundException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

