/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.SparseArray;
import android.util.TypedValue;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AssetManager
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ACCESS_UNKNOWN = 0;
    public static int ACCESS_RANDOM = 1;
    public static int ACCESS_STREAMING = 2;
    public static int ACCESS_BUFFER = 3;
    private static String TAG = "AssetManager";
    private static boolean localLOGV = false;
    private static boolean DEBUG_REFS = false;
    private static Object sSync;
    static AssetManager sSystem;
    private TypedValue mValue;
    private long[] mOffsets;
    private long mObject;
    private StringBlock[] mStringBlocks;
    private int mNumRefs;
    private boolean mOpen;
    private HashMap<Long, RuntimeException> mRefStacks;
    static int STYLE_NUM_ENTRIES = 6;
    static int STYLE_TYPE = 0;
    static int STYLE_DATA = 1;
    static int STYLE_ASSET_COOKIE = 2;
    static int STYLE_RESOURCE_ID = 3;
    static int STYLE_CHANGING_CONFIGURATIONS = 4;
    static int STYLE_DENSITY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_content_res_AssetManager$__constructor__() {
        this.mValue = new TypedValue();
        this.mOffsets = new long[2];
        this.mStringBlocks = null;
        this.mNumRefs = 1;
        this.mOpen = true;
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.init(false);
            AssetManager.ensureSystemAssets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_content_res_AssetManager$ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager system = new AssetManager(true);
                system.makeStringBlocks(null);
                sSystem = system;
            }
        }
    }

    private void $$robo$$android_content_res_AssetManager$__constructor__(boolean isSystem) {
        this.mValue = new TypedValue();
        this.mOffsets = new long[2];
        this.mStringBlocks = null;
        this.mNumRefs = 1;
        this.mOpen = true;
        this.init(true);
    }

    private static final AssetManager $$robo$$android_content_res_AssetManager$getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decRefsLocked(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$android_content_res_AssetManager$getResourceText(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue outValue = this.mValue;
            if (this.getResourceValue(resId, 0, outValue, true)) {
                return outValue.coerceToString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$android_content_res_AssetManager$getResourceBagText(int resId, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue outValue = this.mValue;
            int block = this.loadResourceBagValue(resId, bagEntryId, outValue, true);
            if (block < 0) {
                return null;
            }
            if (outValue.type == 3) {
                return this.mStringBlocks[block].get(outValue.data);
            }
            return outValue.coerceToString();
        }
    }

    private final String[] $$robo$$android_content_res_AssetManager$getResourceStringArray(int resId) {
        return this.getArrayStringResource(resId);
    }

    private final boolean $$robo$$android_content_res_AssetManager$getResourceValue(int resId, int densityDpi, TypedValue outValue, boolean resolveRefs) {
        int block = this.loadResourceValue(resId, (short)densityDpi, outValue, resolveRefs);
        if (block < 0) {
            return false;
        }
        if (outValue.type == 3) {
            outValue.string = this.mStringBlocks[block].get(outValue.data);
        }
        return true;
    }

    private final CharSequence[] $$robo$$android_content_res_AssetManager$getResourceTextArray(int resId) {
        int[] rawInfoArray = this.getArrayStringInfo(resId);
        int rawInfoArrayLen = rawInfoArray.length;
        int infoArrayLen = rawInfoArrayLen / 2;
        CharSequence[] retArray = new CharSequence[infoArrayLen];
        int i = 0;
        int j = 0;
        while (i < rawInfoArrayLen) {
            int block = rawInfoArray[i];
            int index = rawInfoArray[i + 1];
            retArray[j] = index >= 0 ? this.mStringBlocks[block].get(index) : null;
            i += 2;
            ++j;
        }
        return retArray;
    }

    private final boolean $$robo$$android_content_res_AssetManager$getThemeValue(long theme, int resId, TypedValue outValue, boolean resolveRefs) {
        int block = AssetManager.loadThemeAttributeValue(theme, resId, outValue, resolveRefs);
        if (block < 0) {
            return false;
        }
        if (outValue.type == 3) {
            StringBlock[] blocks = this.ensureStringBlocks();
            outValue.string = blocks[block].get(outValue.data);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final StringBlock[] $$robo$$android_content_res_AssetManager$ensureStringBlocks() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mStringBlocks == null) {
                this.makeStringBlocks(AssetManager.sSystem.mStringBlocks);
            }
            return this.mStringBlocks;
        }
    }

    private final void $$robo$$android_content_res_AssetManager$makeStringBlocks(StringBlock[] seed) {
        int seedNum = seed != null ? seed.length : 0;
        int num = this.getStringBlockCount();
        this.mStringBlocks = new StringBlock[num];
        for (int i = 0; i < num; ++i) {
            this.mStringBlocks[i] = i < seedNum ? seed[i] : new StringBlock(this.getNativeStringBlock(i), true);
        }
    }

    private final CharSequence $$robo$$android_content_res_AssetManager$getPooledStringForCookie(int cookie, int id2) {
        return this.mStringBlocks[cookie - 1].get(id2);
    }

    private final InputStream $$robo$$android_content_res_AssetManager$open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_content_res_AssetManager$open(String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long asset = this.openAsset(fileName, accessMode);
            if (asset != 0L) {
                AssetInputStream res = new AssetInputStream(this, asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AssetFileDescriptor $$robo$$android_content_res_AssetManager$openFd(String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openAssetFd(fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    private final String[] $$robo$$android_content_res_AssetManager$list(String string2) throws IOException {
        return null;
    }

    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long asset = this.openNonAssetNative(cookie, fileName, accessMode);
            if (asset != 0L) {
                AssetInputStream res = new AssetInputStream(this, asset);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    private final AssetFileDescriptor $$robo$$android_content_res_AssetManager$openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AssetFileDescriptor $$robo$$android_content_res_AssetManager$openNonAssetFd(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openNonAssetFdNative(cookie, fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    private final XmlResourceParser $$robo$$android_content_res_AssetManager$openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    private final XmlResourceParser $$robo$$android_content_res_AssetManager$openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock block = this.openXmlBlockAsset(cookie, fileName);
        XmlResourceParser rp = block.newParser();
        block.close();
        return rp;
    }

    private final XmlBlock $$robo$$android_content_res_AssetManager$openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XmlBlock $$robo$$android_content_res_AssetManager$openXmlBlockAsset(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long xmlBlock = this.openXmlAssetNative(cookie, fileName);
            if (xmlBlock != 0L) {
                XmlBlock res = new XmlBlock(this, xmlBlock);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset XML file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_content_res_AssetManager$createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long res = this.newTheme();
            this.incRefsLocked(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$releaseTheme(long theme) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.deleteTheme(theme);
            this.decRefsLocked(theme);
        }
    }

    private final void $$robo$$android_content_res_AssetManager$finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_content_res_AssetManager$addAssetPath(String path) {
        return this.addAssetPathInternal(path, false);
    }

    private final int $$robo$$android_content_res_AssetManager$addAssetPathAsSharedLibrary(String path) {
        return this.addAssetPathInternal(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$addAssetPathInternal(String path, boolean appAsLib) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            int res = this.addAssetPathNative(path, appAsLib);
            this.makeStringBlocks(this.mStringBlocks);
            return res;
        }
    }

    private final int $$robo$$android_content_res_AssetManager$addAssetPathNative(String string2, boolean bl) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$addOverlayPath(String idmapPath) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            int res = this.addOverlayPathNative(idmapPath);
            this.makeStringBlocks(this.mStringBlocks);
            return res;
        }
    }

    private final int $$robo$$android_content_res_AssetManager$addOverlayPathNative(String string2) {
        return 0;
    }

    private final int[] $$robo$$android_content_res_AssetManager$addAssetPaths(String[] paths) {
        if (paths == null) {
            return null;
        }
        int[] cookies = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            cookies[i] = this.addAssetPath(paths[i]);
        }
        return cookies;
    }

    private final boolean $$robo$$android_content_res_AssetManager$isUpToDate() {
        return false;
    }

    private final String[] $$robo$$android_content_res_AssetManager$getLocales() {
        return null;
    }

    private final String[] $$robo$$android_content_res_AssetManager$getNonSystemLocales() {
        return null;
    }

    private final Configuration[] $$robo$$android_content_res_AssetManager$getSizeConfigurations() {
        return null;
    }

    private final void $$robo$$android_content_res_AssetManager$setConfiguration(int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
    }

    private final int $$robo$$android_content_res_AssetManager$getResourceIdentifier(String string2, String string3, String string4) {
        return 0;
    }

    private final String $$robo$$android_content_res_AssetManager$getResourceName(int n) {
        return null;
    }

    private final String $$robo$$android_content_res_AssetManager$getResourcePackageName(int n) {
        return null;
    }

    private final String $$robo$$android_content_res_AssetManager$getResourceTypeName(int n) {
        return null;
    }

    private final String $$robo$$android_content_res_AssetManager$getResourceEntryName(int n) {
        return null;
    }

    private final long $$robo$$android_content_res_AssetManager$openAsset(String string2, int n) {
        return 0L;
    }

    private final ParcelFileDescriptor $$robo$$android_content_res_AssetManager$openAssetFd(String string2, long[] lArray) throws IOException {
        return null;
    }

    private final long $$robo$$android_content_res_AssetManager$openNonAssetNative(int n, String string2, int n2) {
        return 0L;
    }

    private final ParcelFileDescriptor $$robo$$android_content_res_AssetManager$openNonAssetFdNative(int n, String string2, long[] lArray) throws IOException {
        return null;
    }

    private final void $$robo$$android_content_res_AssetManager$destroyAsset(long l) {
    }

    private final int $$robo$$android_content_res_AssetManager$readAssetChar(long l) {
        return 0;
    }

    private final int $$robo$$android_content_res_AssetManager$readAsset(long l, byte[] byArray, int n, int n2) {
        return 0;
    }

    private final long $$robo$$android_content_res_AssetManager$seekAsset(long l, long l2, int n) {
        return 0L;
    }

    private final long $$robo$$android_content_res_AssetManager$getAssetLength(long l) {
        return 0L;
    }

    private final long $$robo$$android_content_res_AssetManager$getAssetRemainingLength(long l) {
        return 0L;
    }

    private final int $$robo$$android_content_res_AssetManager$loadResourceValue(int n, short s, TypedValue typedValue, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_content_res_AssetManager$loadResourceBagValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return 0;
    }

    private static final boolean $$robo$$android_content_res_AssetManager$applyStyle(long l, int n, int n2, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        return false;
    }

    private static final boolean $$robo$$android_content_res_AssetManager$resolveAttrs(long l, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return false;
    }

    private final boolean $$robo$$android_content_res_AssetManager$retrieveAttributes(long l, int[] nArray, int[] nArray2, int[] nArray3) {
        return false;
    }

    private final int $$robo$$android_content_res_AssetManager$getArraySize(int n) {
        return 0;
    }

    private final int $$robo$$android_content_res_AssetManager$retrieveArray(int n, int[] nArray) {
        return 0;
    }

    private final int $$robo$$android_content_res_AssetManager$getStringBlockCount() {
        return 0;
    }

    private final long $$robo$$android_content_res_AssetManager$getNativeStringBlock(int n) {
        return 0L;
    }

    private final String $$robo$$android_content_res_AssetManager$getCookieName(int n) {
        return null;
    }

    private final SparseArray<String> $$robo$$android_content_res_AssetManager$getAssignedPackageIdentifiers() {
        return null;
    }

    private static final int $$robo$$android_content_res_AssetManager$getGlobalAssetCount() {
        return 0;
    }

    private static final String $$robo$$android_content_res_AssetManager$getAssetAllocations() {
        return null;
    }

    private static final int $$robo$$android_content_res_AssetManager$getGlobalAssetManagerCount() {
        return 0;
    }

    private final long $$robo$$android_content_res_AssetManager$newTheme() {
        return 0L;
    }

    private final void $$robo$$android_content_res_AssetManager$deleteTheme(long l) {
    }

    private static final void $$robo$$android_content_res_AssetManager$applyThemeStyle(long l, int n, boolean bl) {
    }

    private static final void $$robo$$android_content_res_AssetManager$copyTheme(long l, long l2) {
    }

    private static final void $$robo$$android_content_res_AssetManager$clearTheme(long l) {
    }

    private static final int $$robo$$android_content_res_AssetManager$loadThemeAttributeValue(long l, int n, TypedValue typedValue, boolean bl) {
        return 0;
    }

    private static final void $$robo$$android_content_res_AssetManager$dumpTheme(long l, int n, String string2, String string3) {
    }

    private static final int $$robo$$android_content_res_AssetManager$getThemeChangingConfigurations(long l) {
        return 0;
    }

    private final long $$robo$$android_content_res_AssetManager$openXmlAssetNative(int n, String string2) {
        return 0L;
    }

    private final String[] $$robo$$android_content_res_AssetManager$getArrayStringResource(int n) {
        return null;
    }

    private final int[] $$robo$$android_content_res_AssetManager$getArrayStringInfo(int n) {
        return null;
    }

    private final int[] $$robo$$android_content_res_AssetManager$getArrayIntResource(int n) {
        return null;
    }

    private final int[] $$robo$$android_content_res_AssetManager$getStyleAttributes(int n) {
        return null;
    }

    private final void $$robo$$android_content_res_AssetManager$init(boolean bl) {
    }

    private final void $$robo$$android_content_res_AssetManager$destroy() {
    }

    private final void $$robo$$android_content_res_AssetManager$incRefsLocked(long id2) {
        ++this.mNumRefs;
    }

    private final void $$robo$$android_content_res_AssetManager$decRefsLocked(long id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0) {
            this.destroy();
        }
    }

    static void __staticInitializer__() {
        sSync = new Object();
        sSystem = null;
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_AssetManager$__constructor__();
    }

    public AssetManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager$__constructor__(), 0, this);
    }

    private static void ensureSystemAssets() {
        InvokeDynamicSupport.bootstrapStatic("ensureSystemAssets", $$robo$$android_content_res_AssetManager$ensureSystemAssets(), 0);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_content_res_AssetManager$__constructor__(bl);
    }

    private AssetManager(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager$__constructor__(boolean ), 0, this, bl);
    }

    public static AssetManager getSystem() {
        return InvokeDynamicSupport.bootstrapStatic("getSystem", $$robo$$android_content_res_AssetManager$getSystem(), 0);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_res_AssetManager$close(), 0, this);
    }

    CharSequence getResourceText(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceText", $$robo$$android_content_res_AssetManager$getResourceText(int ), 0, this, n);
    }

    CharSequence getResourceBagText(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getResourceBagText", $$robo$$android_content_res_AssetManager$getResourceBagText(int int ), 0, this, n, n2);
    }

    String[] getResourceStringArray(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceStringArray", $$robo$$android_content_res_AssetManager$getResourceStringArray(int ), 0, this, n);
    }

    boolean getResourceValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getResourceValue", $$robo$$android_content_res_AssetManager$getResourceValue(int int android.util.TypedValue boolean ), 0, this, n, n2, typedValue, bl);
    }

    CharSequence[] getResourceTextArray(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceTextArray", $$robo$$android_content_res_AssetManager$getResourceTextArray(int ), 0, this, n);
    }

    boolean getThemeValue(long l, int n, TypedValue typedValue, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getThemeValue", $$robo$$android_content_res_AssetManager$getThemeValue(long int android.util.TypedValue boolean ), 0, this, l, n, typedValue, bl);
    }

    StringBlock[] ensureStringBlocks() {
        return InvokeDynamicSupport.bootstrap("ensureStringBlocks", $$robo$$android_content_res_AssetManager$ensureStringBlocks(), 0, this);
    }

    void makeStringBlocks(StringBlock[] stringBlockArray) {
        InvokeDynamicSupport.bootstrap("makeStringBlocks", $$robo$$android_content_res_AssetManager$makeStringBlocks(android.content.res.StringBlock[] ), 0, this, stringBlockArray);
    }

    CharSequence getPooledStringForCookie(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPooledStringForCookie", $$robo$$android_content_res_AssetManager$getPooledStringForCookie(int int ), 0, this, n, n2);
    }

    public InputStream open(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("open", $$robo$$android_content_res_AssetManager$open(java.lang.String ), 0, this, string2);
    }

    public InputStream open(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("open", $$robo$$android_content_res_AssetManager$open(java.lang.String int ), 0, this, string2, n);
    }

    public AssetFileDescriptor openFd(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openFd", $$robo$$android_content_res_AssetManager$openFd(java.lang.String ), 0, this, string2);
    }

    private final native /* synthetic */ String[] $$robo$$list$nativeBinding(String var1) throws IOException;

    public String[] list(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("list", $$robo$$android_content_res_AssetManager$list(java.lang.String ), 1, this, string2);
    }

    public InputStream openNonAsset(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(java.lang.String ), 0, this, string2);
    }

    public InputStream openNonAsset(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(java.lang.String int ), 0, this, string2, n);
    }

    public InputStream openNonAsset(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(int java.lang.String ), 0, this, n, string2);
    }

    public InputStream openNonAsset(int n, String string2, int n2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(int java.lang.String int ), 0, this, n, string2, n2);
    }

    public AssetFileDescriptor openNonAssetFd(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAssetFd", $$robo$$android_content_res_AssetManager$openNonAssetFd(java.lang.String ), 0, this, string2);
    }

    public AssetFileDescriptor openNonAssetFd(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAssetFd", $$robo$$android_content_res_AssetManager$openNonAssetFd(int java.lang.String ), 0, this, n, string2);
    }

    public XmlResourceParser openXmlResourceParser(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlResourceParser", $$robo$$android_content_res_AssetManager$openXmlResourceParser(java.lang.String ), 0, this, string2);
    }

    public XmlResourceParser openXmlResourceParser(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlResourceParser", $$robo$$android_content_res_AssetManager$openXmlResourceParser(int java.lang.String ), 0, this, n, string2);
    }

    XmlBlock openXmlBlockAsset(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlBlockAsset", $$robo$$android_content_res_AssetManager$openXmlBlockAsset(java.lang.String ), 0, this, string2);
    }

    XmlBlock openXmlBlockAsset(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlBlockAsset", $$robo$$android_content_res_AssetManager$openXmlBlockAsset(int java.lang.String ), 0, this, n, string2);
    }

    void xmlBlockGone(int n) {
        InvokeDynamicSupport.bootstrap("xmlBlockGone", $$robo$$android_content_res_AssetManager$xmlBlockGone(int ), 0, this, n);
    }

    long createTheme() {
        return (long)InvokeDynamicSupport.bootstrap("createTheme", $$robo$$android_content_res_AssetManager$createTheme(), 0, this);
    }

    void releaseTheme(long l) {
        InvokeDynamicSupport.bootstrap("releaseTheme", $$robo$$android_content_res_AssetManager$releaseTheme(long ), 0, this, l);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_AssetManager$finalize(), 0, this);
    }

    public int addAssetPath(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPath", $$robo$$android_content_res_AssetManager$addAssetPath(java.lang.String ), 0, this, string2);
    }

    public int addAssetPathAsSharedLibrary(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPathAsSharedLibrary", $$robo$$android_content_res_AssetManager$addAssetPathAsSharedLibrary(java.lang.String ), 0, this, string2);
    }

    private int addAssetPathInternal(String string2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPathInternal", $$robo$$android_content_res_AssetManager$addAssetPathInternal(java.lang.String boolean ), 0, this, string2, bl);
    }

    private final native /* synthetic */ int $$robo$$addAssetPathNative$nativeBinding(String var1, boolean var2);

    private int addAssetPathNative(String string2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPathNative", $$robo$$android_content_res_AssetManager$addAssetPathNative(java.lang.String boolean ), 1, this, string2, bl);
    }

    public int addOverlayPath(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addOverlayPath", $$robo$$android_content_res_AssetManager$addOverlayPath(java.lang.String ), 0, this, string2);
    }

    private final native /* synthetic */ int $$robo$$addOverlayPathNative$nativeBinding(String var1);

    public int addOverlayPathNative(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addOverlayPathNative", $$robo$$android_content_res_AssetManager$addOverlayPathNative(java.lang.String ), 1, this, string2);
    }

    public int[] addAssetPaths(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("addAssetPaths", $$robo$$android_content_res_AssetManager$addAssetPaths(java.lang.String[] ), 0, this, stringArray);
    }

    private final native /* synthetic */ boolean $$robo$$isUpToDate$nativeBinding();

    public boolean isUpToDate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUpToDate", $$robo$$android_content_res_AssetManager$isUpToDate(), 1, this);
    }

    private final native /* synthetic */ String[] $$robo$$getLocales$nativeBinding();

    public String[] getLocales() {
        return InvokeDynamicSupport.bootstrap("getLocales", $$robo$$android_content_res_AssetManager$getLocales(), 1, this);
    }

    private final native /* synthetic */ String[] $$robo$$getNonSystemLocales$nativeBinding();

    public String[] getNonSystemLocales() {
        return InvokeDynamicSupport.bootstrap("getNonSystemLocales", $$robo$$android_content_res_AssetManager$getNonSystemLocales(), 1, this);
    }

    private final native /* synthetic */ Configuration[] $$robo$$getSizeConfigurations$nativeBinding();

    public Configuration[] getSizeConfigurations() {
        return InvokeDynamicSupport.bootstrap("getSizeConfigurations", $$robo$$android_content_res_AssetManager$getSizeConfigurations(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setConfiguration$nativeBinding(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    public void setConfiguration(int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        InvokeDynamicSupport.bootstrap("setConfiguration", $$robo$$android_content_res_AssetManager$setConfiguration(int int java.lang.String int int int int int int int int int int int int int int ), 1, this, n, n2, string2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16);
    }

    private final native /* synthetic */ int $$robo$$getResourceIdentifier$nativeBinding(String var1, String var2, String var3);

    int getResourceIdentifier(String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceIdentifier", $$robo$$android_content_res_AssetManager$getResourceIdentifier(java.lang.String java.lang.String java.lang.String ), 1, this, string2, string3, string4);
    }

    private final native /* synthetic */ String $$robo$$getResourceName$nativeBinding(int var1);

    String getResourceName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceName", $$robo$$android_content_res_AssetManager$getResourceName(int ), 1, this, n);
    }

    private final native /* synthetic */ String $$robo$$getResourcePackageName$nativeBinding(int var1);

    String getResourcePackageName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourcePackageName", $$robo$$android_content_res_AssetManager$getResourcePackageName(int ), 1, this, n);
    }

    private final native /* synthetic */ String $$robo$$getResourceTypeName$nativeBinding(int var1);

    String getResourceTypeName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceTypeName", $$robo$$android_content_res_AssetManager$getResourceTypeName(int ), 1, this, n);
    }

    private final native /* synthetic */ String $$robo$$getResourceEntryName$nativeBinding(int var1);

    String getResourceEntryName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceEntryName", $$robo$$android_content_res_AssetManager$getResourceEntryName(int ), 1, this, n);
    }

    private final native /* synthetic */ long $$robo$$openAsset$nativeBinding(String var1, int var2);

    private long openAsset(String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrap("openAsset", $$robo$$android_content_res_AssetManager$openAsset(java.lang.String int ), 1, this, string2, n);
    }

    private final native /* synthetic */ ParcelFileDescriptor $$robo$$openAssetFd$nativeBinding(String var1, long[] var2) throws IOException;

    private ParcelFileDescriptor openAssetFd(String string2, long[] lArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("openAssetFd", $$robo$$android_content_res_AssetManager$openAssetFd(java.lang.String long[] ), 1, this, string2, lArray);
    }

    private final native /* synthetic */ long $$robo$$openNonAssetNative$nativeBinding(int var1, String var2, int var3);

    private long openNonAssetNative(int n, String string2, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("openNonAssetNative", $$robo$$android_content_res_AssetManager$openNonAssetNative(int java.lang.String int ), 1, this, n, string2, n2);
    }

    private final native /* synthetic */ ParcelFileDescriptor $$robo$$openNonAssetFdNative$nativeBinding(int var1, String var2, long[] var3) throws IOException;

    private ParcelFileDescriptor openNonAssetFdNative(int n, String string2, long[] lArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAssetFdNative", $$robo$$android_content_res_AssetManager$openNonAssetFdNative(int java.lang.String long[] ), 1, this, n, string2, lArray);
    }

    private final native /* synthetic */ void $$robo$$destroyAsset$nativeBinding(long var1);

    private void destroyAsset(long l) {
        InvokeDynamicSupport.bootstrap("destroyAsset", $$robo$$android_content_res_AssetManager$destroyAsset(long ), 1, this, l);
    }

    private final native /* synthetic */ int $$robo$$readAssetChar$nativeBinding(long var1);

    private int readAssetChar(long l) {
        return (int)InvokeDynamicSupport.bootstrap("readAssetChar", $$robo$$android_content_res_AssetManager$readAssetChar(long ), 1, this, l);
    }

    private final native /* synthetic */ int $$robo$$readAsset$nativeBinding(long var1, byte[] var3, int var4, int var5);

    private int readAsset(long l, byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("readAsset", $$robo$$android_content_res_AssetManager$readAsset(long byte[] int int ), 1, this, l, byArray, n, n2);
    }

    private final native /* synthetic */ long $$robo$$seekAsset$nativeBinding(long var1, long var3, int var5);

    private long seekAsset(long l, long l2, int n) {
        return (long)InvokeDynamicSupport.bootstrap("seekAsset", $$robo$$android_content_res_AssetManager$seekAsset(long long int ), 1, this, l, l2, n);
    }

    private final native /* synthetic */ long $$robo$$getAssetLength$nativeBinding(long var1);

    private long getAssetLength(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getAssetLength", $$robo$$android_content_res_AssetManager$getAssetLength(long ), 1, this, l);
    }

    private final native /* synthetic */ long $$robo$$getAssetRemainingLength$nativeBinding(long var1);

    private long getAssetRemainingLength(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getAssetRemainingLength", $$robo$$android_content_res_AssetManager$getAssetRemainingLength(long ), 1, this, l);
    }

    private final native /* synthetic */ int $$robo$$loadResourceValue$nativeBinding(int var1, short var2, TypedValue var3, boolean var4);

    private int loadResourceValue(int n, short s, TypedValue typedValue, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("loadResourceValue", $$robo$$android_content_res_AssetManager$loadResourceValue(int short android.util.TypedValue boolean ), 1, this, n, s, typedValue, bl);
    }

    private final native /* synthetic */ int $$robo$$loadResourceBagValue$nativeBinding(int var1, int var2, TypedValue var3, boolean var4);

    private int loadResourceBagValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("loadResourceBagValue", $$robo$$android_content_res_AssetManager$loadResourceBagValue(int int android.util.TypedValue boolean ), 1, this, n, n2, typedValue, bl);
    }

    private static final native /* synthetic */ boolean $$robo$$applyStyle$nativeBinding(long var0, int var2, int var3, long var4, int[] var6, int[] var7, int[] var8);

    static boolean applyStyle(long l, int n, int n2, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("applyStyle", $$robo$$android_content_res_AssetManager$applyStyle(long int int long int[] int[] int[] ), 1, (long)l, (int)n, (int)n2, (long)l2, (int[])nArray, (int[])nArray2, (int[])nArray3);
    }

    private static final native /* synthetic */ boolean $$robo$$resolveAttrs$nativeBinding(long var0, int var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7);

    static boolean resolveAttrs(long l, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resolveAttrs", $$robo$$android_content_res_AssetManager$resolveAttrs(long int int int[] int[] int[] int[] ), 1, (long)l, (int)n, (int)n2, (int[])nArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
    }

    private final native /* synthetic */ boolean $$robo$$retrieveAttributes$nativeBinding(long var1, int[] var3, int[] var4, int[] var5);

    boolean retrieveAttributes(long l, int[] nArray, int[] nArray2, int[] nArray3) {
        return (boolean)InvokeDynamicSupport.bootstrap("retrieveAttributes", $$robo$$android_content_res_AssetManager$retrieveAttributes(long int[] int[] int[] ), 1, this, l, nArray, nArray2, nArray3);
    }

    private final native /* synthetic */ int $$robo$$getArraySize$nativeBinding(int var1);

    int getArraySize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getArraySize", $$robo$$android_content_res_AssetManager$getArraySize(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$retrieveArray$nativeBinding(int var1, int[] var2);

    int retrieveArray(int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("retrieveArray", $$robo$$android_content_res_AssetManager$retrieveArray(int int[] ), 1, this, n, nArray);
    }

    private final native /* synthetic */ int $$robo$$getStringBlockCount$nativeBinding();

    private int getStringBlockCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStringBlockCount", $$robo$$android_content_res_AssetManager$getStringBlockCount(), 1, this);
    }

    private final native /* synthetic */ long $$robo$$getNativeStringBlock$nativeBinding(int var1);

    private long getNativeStringBlock(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getNativeStringBlock", $$robo$$android_content_res_AssetManager$getNativeStringBlock(int ), 1, this, n);
    }

    private final native /* synthetic */ String $$robo$$getCookieName$nativeBinding(int var1);

    public String getCookieName(int n) {
        return InvokeDynamicSupport.bootstrap("getCookieName", $$robo$$android_content_res_AssetManager$getCookieName(int ), 1, this, n);
    }

    private final native /* synthetic */ SparseArray<String> $$robo$$getAssignedPackageIdentifiers$nativeBinding();

    public SparseArray<String> getAssignedPackageIdentifiers() {
        return InvokeDynamicSupport.bootstrap("getAssignedPackageIdentifiers", $$robo$$android_content_res_AssetManager$getAssignedPackageIdentifiers(), 1, this);
    }

    private static final native /* synthetic */ int $$robo$$getGlobalAssetCount$nativeBinding();

    public static int getGlobalAssetCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAssetCount", $$robo$$android_content_res_AssetManager$getGlobalAssetCount(), 1);
    }

    private static final native /* synthetic */ String $$robo$$getAssetAllocations$nativeBinding();

    public static String getAssetAllocations() {
        return InvokeDynamicSupport.bootstrapStatic("getAssetAllocations", $$robo$$android_content_res_AssetManager$getAssetAllocations(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getGlobalAssetManagerCount$nativeBinding();

    public static int getGlobalAssetManagerCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAssetManagerCount", $$robo$$android_content_res_AssetManager$getGlobalAssetManagerCount(), 1);
    }

    private final native /* synthetic */ long $$robo$$newTheme$nativeBinding();

    private long newTheme() {
        return (long)InvokeDynamicSupport.bootstrap("newTheme", $$robo$$android_content_res_AssetManager$newTheme(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$deleteTheme$nativeBinding(long var1);

    private void deleteTheme(long l) {
        InvokeDynamicSupport.bootstrap("deleteTheme", $$robo$$android_content_res_AssetManager$deleteTheme(long ), 1, this, l);
    }

    private static final native /* synthetic */ void $$robo$$applyThemeStyle$nativeBinding(long var0, int var2, boolean var3);

    static void applyThemeStyle(long l, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("applyThemeStyle", $$robo$$android_content_res_AssetManager$applyThemeStyle(long int boolean ), 1, (long)l, (int)n, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$copyTheme$nativeBinding(long var0, long var2);

    static void copyTheme(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("copyTheme", $$robo$$android_content_res_AssetManager$copyTheme(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$clearTheme$nativeBinding(long var0);

    static void clearTheme(long l) {
        InvokeDynamicSupport.bootstrapStatic("clearTheme", $$robo$$android_content_res_AssetManager$clearTheme(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$loadThemeAttributeValue$nativeBinding(long var0, int var2, TypedValue var3, boolean var4);

    static int loadThemeAttributeValue(long l, int n, TypedValue typedValue, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadThemeAttributeValue", $$robo$$android_content_res_AssetManager$loadThemeAttributeValue(long int android.util.TypedValue boolean ), 1, (long)l, (int)n, (TypedValue)typedValue, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$dumpTheme$nativeBinding(long var0, int var2, String var3, String var4);

    static void dumpTheme(long l, int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("dumpTheme", $$robo$$android_content_res_AssetManager$dumpTheme(long int java.lang.String java.lang.String ), 1, (long)l, (int)n, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ int $$robo$$getThemeChangingConfigurations$nativeBinding(long var0);

    static int getThemeChangingConfigurations(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThemeChangingConfigurations", $$robo$$android_content_res_AssetManager$getThemeChangingConfigurations(long ), 1, (long)l);
    }

    private final native /* synthetic */ long $$robo$$openXmlAssetNative$nativeBinding(int var1, String var2);

    private long openXmlAssetNative(int n, String string2) {
        return (long)InvokeDynamicSupport.bootstrap("openXmlAssetNative", $$robo$$android_content_res_AssetManager$openXmlAssetNative(int java.lang.String ), 1, this, n, string2);
    }

    private final native /* synthetic */ String[] $$robo$$getArrayStringResource$nativeBinding(int var1);

    private String[] getArrayStringResource(int n) {
        return InvokeDynamicSupport.bootstrap("getArrayStringResource", $$robo$$android_content_res_AssetManager$getArrayStringResource(int ), 1, this, n);
    }

    private final native /* synthetic */ int[] $$robo$$getArrayStringInfo$nativeBinding(int var1);

    private int[] getArrayStringInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getArrayStringInfo", $$robo$$android_content_res_AssetManager$getArrayStringInfo(int ), 1, this, n);
    }

    private final native /* synthetic */ int[] $$robo$$getArrayIntResource$nativeBinding(int var1);

    int[] getArrayIntResource(int n) {
        return InvokeDynamicSupport.bootstrap("getArrayIntResource", $$robo$$android_content_res_AssetManager$getArrayIntResource(int ), 1, this, n);
    }

    private final native /* synthetic */ int[] $$robo$$getStyleAttributes$nativeBinding(int var1);

    int[] getStyleAttributes(int n) {
        return InvokeDynamicSupport.bootstrap("getStyleAttributes", $$robo$$android_content_res_AssetManager$getStyleAttributes(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$init$nativeBinding(boolean var1);

    private void init(boolean bl) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_content_res_AssetManager$init(boolean ), 1, this, bl);
    }

    private final native /* synthetic */ void $$robo$$destroy$nativeBinding();

    private void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_content_res_AssetManager$destroy(), 1, this);
    }

    private void incRefsLocked(long l) {
        InvokeDynamicSupport.bootstrap("incRefsLocked", $$robo$$android_content_res_AssetManager$incRefsLocked(long ), 0, this, l);
    }

    private void decRefsLocked(long l) {
        InvokeDynamicSupport.bootstrap("decRefsLocked", $$robo$$android_content_res_AssetManager$decRefsLocked(long ), 0, this, l);
    }

    static {
        RobolectricInternals.classInitializing(AssetManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class AssetInputStream
    extends InputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mAsset;
        private long mLength;
        private long mMarkPos;
        /* synthetic */ AssetManager this$0;

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$getAssetInt() {
            throw new UnsupportedOperationException();
        }

        private final long $$robo$$android_content_res_AssetManager_AssetInputStream$getNativeAsset() {
            return this.mAsset;
        }

        private void $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(AssetManager this$0, long asset) {
            this.mAsset = asset;
            this.mLength = this$0.getAssetLength(asset);
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$read() throws IOException {
            return this.this$0.readAssetChar(this.mAsset);
        }

        private final boolean $$robo$$android_content_res_AssetManager_AssetInputStream$markSupported() {
            return true;
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$available() throws IOException {
            long len = this.this$0.getAssetRemainingLength(this.mAsset);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$close() throws IOException {
            AssetManager assetManager = this.this$0;
            synchronized (assetManager) {
                if (this.mAsset != 0L) {
                    this.this$0.destroyAsset(this.mAsset);
                    this.mAsset = 0L;
                    this.this$0.decRefsLocked(this.hashCode());
                }
            }
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$mark(int readlimit) {
            this.mMarkPos = this.this$0.seekAsset(this.mAsset, 0L, 0);
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$reset() throws IOException {
            this.this$0.seekAsset(this.mAsset, this.mMarkPos, -1);
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] b) throws IOException {
            return this.this$0.readAsset(this.mAsset, b, 0, b.length);
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] b, int off, int len) throws IOException {
            return this.this$0.readAsset(this.mAsset, b, off, len);
        }

        private final long $$robo$$android_content_res_AssetManager_AssetInputStream$skip(long n) throws IOException {
            long pos = this.this$0.seekAsset(this.mAsset, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                this.this$0.seekAsset(this.mAsset, n, 0);
            }
            return n;
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$finalize() throws Throwable {
            this.close();
        }

        private /* synthetic */ void $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(AssetManager x0, long x1, 1 x2) {
        }

        public int getAssetInt() {
            return (int)InvokeDynamicSupport.bootstrap("getAssetInt", $$robo$$android_content_res_AssetManager_AssetInputStream$getAssetInt(), 0, this);
        }

        public long getNativeAsset() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeAsset", $$robo$$android_content_res_AssetManager_AssetInputStream$getNativeAsset(), 0, this);
        }

        private void __constructor__(AssetManager assetManager, long l) {
            this.$$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(assetManager, l);
        }

        private AssetInputStream(AssetManager assetManager, long l) {
            this.this$0 = assetManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(android.content.res.AssetManager long ), 0, this, assetManager, l);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetManager_AssetInputStream$read(), 0, this);
        }

        @Override
        public boolean markSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("markSupported", $$robo$$android_content_res_AssetManager_AssetInputStream$markSupported(), 0, this);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_content_res_AssetManager_AssetInputStream$available(), 0, this);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_res_AssetManager_AssetInputStream$close(), 0, this);
        }

        @Override
        public void mark(int n) {
            InvokeDynamicSupport.bootstrap("mark", $$robo$$android_content_res_AssetManager_AssetInputStream$mark(int ), 0, this, n);
        }

        @Override
        public void reset() throws IOException {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_content_res_AssetManager_AssetInputStream$reset(), 0, this);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] ), 0, this, byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_content_res_AssetManager_AssetInputStream$skip(long ), 0, this, l);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_AssetManager_AssetInputStream$finalize(), 0, this);
        }

        private /* synthetic */ void __constructor__(AssetManager assetManager, long l, 1 var4_3) {
            this.$$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(assetManager, l, var4_3);
        }

        public /* synthetic */ AssetInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

