/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.util.ArraySet;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ShortcutInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FLAG_DYNAMIC = 1;
    public static int FLAG_PINNED = 2;
    public static int FLAG_HAS_ICON_RES = 4;
    public static int FLAG_HAS_ICON_FILE = 8;
    public static int FLAG_KEY_FIELDS_ONLY = 16;
    private static int CLONE_REMOVE_ICON = 1;
    private static int CLONE_REMOVE_INTENT = 2;
    public static int CLONE_REMOVE_NON_KEY_INFO = 4;
    public static int CLONE_REMOVE_FOR_CREATOR = 1;
    public static int CLONE_REMOVE_FOR_LAUNCHER = 3;
    public static String SHORTCUT_CATEGORY_CONVERSATION = "android.shortcut.conversation";
    private String mId;
    private String mPackageName;
    private ComponentName mActivityComponent;
    private Icon mIcon;
    private String mTitle;
    private String mText;
    private ArraySet<String> mCategories;
    private Intent mIntent;
    private PersistableBundle mIntentPersistableExtras;
    private int mWeight;
    private PersistableBundle mExtras;
    private long mLastChangedTimestamp;
    private int mFlags;
    private int mIconResourceId;
    private String mBitmapPath;
    private int mUserId;
    public static Parcelable.Creator<ShortcutInfo> CREATOR;

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Builder b) {
        Bundle intentExtras;
        this.mUserId = b.mContext.getUserId();
        this.mId = Preconditions.checkStringNotEmpty(b.mId, "Shortcut ID must be provided");
        this.mPackageName = b.mContext.getPackageName();
        this.mActivityComponent = b.mActivityComponent;
        this.mIcon = b.mIcon;
        this.mTitle = b.mTitle;
        this.mText = b.mText;
        this.mCategories = this.clone(b.mCategories);
        this.mIntent = b.mIntent;
        if (this.mIntent != null && (intentExtras = this.mIntent.getExtras()) != null) {
            this.mIntent.replaceExtras((Bundle)null);
            this.mIntentPersistableExtras = new PersistableBundle(intentExtras);
        }
        this.mWeight = b.mWeight;
        this.mExtras = b.mExtras;
        this.updateTimestamp();
    }

    private final <T> ArraySet<T> $$robo$$android_content_pm_ShortcutInfo$clone(Set<T> source) {
        return source == null ? null : new ArraySet<T>(source);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$enforceMandatoryFields() {
        Preconditions.checkStringNotEmpty(this.mId, "Shortcut ID must be provided");
        Preconditions.checkStringNotEmpty(this.mTitle, "Shortcut title must be provided");
        Preconditions.checkNotNull(this.mIntent, "Shortcut Intent must be provided");
    }

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(ShortcutInfo source, int cloneFlags) {
        this.mUserId = source.mUserId;
        this.mId = source.mId;
        this.mPackageName = source.mPackageName;
        this.mFlags = source.mFlags;
        this.mLastChangedTimestamp = source.mLastChangedTimestamp;
        this.mIconResourceId = source.mIconResourceId;
        if ((cloneFlags & 4) == 0) {
            this.mActivityComponent = source.mActivityComponent;
            if ((cloneFlags & 1) == 0) {
                this.mIcon = source.mIcon;
                this.mBitmapPath = source.mBitmapPath;
            }
            this.mTitle = source.mTitle;
            this.mText = source.mText;
            this.mCategories = this.clone(source.mCategories);
            if ((cloneFlags & 2) == 0) {
                this.mIntent = source.mIntent;
                this.mIntentPersistableExtras = source.mIntentPersistableExtras;
            }
            this.mWeight = source.mWeight;
            this.mExtras = source.mExtras;
        } else {
            this.mFlags |= 0x10;
        }
    }

    private final ShortcutInfo $$robo$$android_content_pm_ShortcutInfo$clone(int cloneFlags) {
        return new ShortcutInfo(this, cloneFlags);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$copyNonNullFieldsFrom(ShortcutInfo source) {
        Preconditions.checkState(this.mUserId == source.mUserId, "Owner User ID must match");
        Preconditions.checkState(this.mId.equals(source.mId), "ID must match");
        Preconditions.checkState(this.mPackageName.equals(source.mPackageName), "Package name must match");
        if (source.mActivityComponent != null) {
            this.mActivityComponent = source.mActivityComponent;
        }
        if (source.mIcon != null) {
            this.mIcon = source.mIcon;
        }
        if (source.mTitle != null) {
            this.mTitle = source.mTitle;
        }
        if (source.mText != null) {
            this.mText = source.mText;
        }
        if (source.mCategories != null) {
            this.mCategories = this.clone(source.mCategories);
        }
        if (source.mIntent != null) {
            this.mIntent = source.mIntent;
            this.mIntentPersistableExtras = source.mIntentPersistableExtras;
        }
        if (source.mWeight != 0) {
            this.mWeight = source.mWeight;
        }
        if (source.mExtras != null) {
            this.mExtras = source.mExtras;
        }
        this.updateTimestamp();
    }

    private static final Icon $$robo$$android_content_pm_ShortcutInfo$validateIcon(Icon icon) {
        switch (icon.getType()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw ShortcutInfo.getInvalidIconException();
            }
        }
        if (icon.hasTint()) {
            throw new IllegalArgumentException("Icons with tints are not supported");
        }
        return icon;
    }

    private static final IllegalArgumentException $$robo$$android_content_pm_ShortcutInfo$getInvalidIconException() {
        return new IllegalArgumentException("Unsupported icon type: only bitmap, resource and content URI are supported");
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getId() {
        return this.mId;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getPackageName() {
        return this.mPackageName;
    }

    private final ComponentName $$robo$$android_content_pm_ShortcutInfo$getActivityComponent() {
        return this.mActivityComponent;
    }

    private final Icon $$robo$$android_content_pm_ShortcutInfo$getIcon() {
        return this.mIcon;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getTitle() {
        return this.mTitle;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getText() {
        return this.mText;
    }

    private final Set<String> $$robo$$android_content_pm_ShortcutInfo$getCategories() {
        return this.mCategories;
    }

    private final Intent $$robo$$android_content_pm_ShortcutInfo$getIntent() {
        if (this.mIntent == null) {
            return null;
        }
        Intent intent = new Intent(this.mIntent);
        intent.replaceExtras(this.mIntentPersistableExtras != null ? new Bundle(this.mIntentPersistableExtras) : null);
        return intent;
    }

    private final Intent $$robo$$android_content_pm_ShortcutInfo$getIntentNoExtras() {
        return this.mIntent;
    }

    private final PersistableBundle $$robo$$android_content_pm_ShortcutInfo$getIntentPersistableExtras() {
        return this.mIntentPersistableExtras;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getWeight() {
        return this.mWeight;
    }

    private final PersistableBundle $$robo$$android_content_pm_ShortcutInfo$getExtras() {
        return this.mExtras;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getUserId() {
        return this.mUserId;
    }

    private final UserHandle $$robo$$android_content_pm_ShortcutInfo$getUserHandle() {
        return UserHandle.of(this.mUserId);
    }

    private final long $$robo$$android_content_pm_ShortcutInfo$getLastChangedTimestamp() {
        return this.mLastChangedTimestamp;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getFlags() {
        return this.mFlags;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$replaceFlags(int flags) {
        this.mFlags = flags;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$addFlags(int flags) {
        this.mFlags |= flags;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$clearFlags(int flags) {
        this.mFlags &= ~flags;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasFlags(int flags) {
        return (this.mFlags & flags) == flags;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isDynamic() {
        return this.hasFlags(1);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isPinned() {
        return this.hasFlags(2);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasIconResource() {
        return this.hasFlags(4);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasIconFile() {
        return this.hasFlags(8);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasKeyFieldsOnly() {
        return this.hasFlags(16);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$updateTimestamp() {
        this.mLastChangedTimestamp = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setTimestamp(long value) {
        this.mLastChangedTimestamp = value;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$clearIcon() {
        this.mIcon = null;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setIconResourceId(int iconResourceId) {
        this.mIconResourceId = iconResourceId;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getIconResourceId() {
        return this.mIconResourceId;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getBitmapPath() {
        return this.mBitmapPath;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setBitmapPath(String bitmapPath) {
        this.mBitmapPath = bitmapPath;
    }

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Parcel source) {
        ClassLoader cl = this.getClass().getClassLoader();
        this.mUserId = source.readInt();
        this.mId = source.readString();
        this.mPackageName = source.readString();
        this.mActivityComponent = (ComponentName)source.readParcelable(cl);
        this.mIcon = (Icon)source.readParcelable(cl);
        this.mTitle = source.readString();
        this.mText = source.readString();
        this.mIntent = (Intent)source.readParcelable(cl);
        this.mIntentPersistableExtras = (PersistableBundle)source.readParcelable(cl);
        this.mWeight = source.readInt();
        this.mExtras = (PersistableBundle)source.readParcelable(cl);
        this.mLastChangedTimestamp = source.readLong();
        this.mFlags = source.readInt();
        this.mIconResourceId = source.readInt();
        this.mBitmapPath = source.readString();
        int N = source.readInt();
        if (N == 0) {
            this.mCategories = null;
        } else {
            this.mCategories = new ArraySet(N);
            for (int i = 0; i < N; ++i) {
                this.mCategories.add(source.readString().intern());
            }
        }
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUserId);
        dest.writeString(this.mId);
        dest.writeString(this.mPackageName);
        dest.writeParcelable(this.mActivityComponent, flags);
        dest.writeParcelable(this.mIcon, flags);
        dest.writeString(this.mTitle);
        dest.writeString(this.mText);
        dest.writeParcelable(this.mIntent, flags);
        dest.writeParcelable(this.mIntentPersistableExtras, flags);
        dest.writeInt(this.mWeight);
        dest.writeParcelable(this.mExtras, flags);
        dest.writeLong(this.mLastChangedTimestamp);
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mIconResourceId);
        dest.writeString(this.mBitmapPath);
        if (this.mCategories != null) {
            int N = this.mCategories.size();
            dest.writeInt(N);
            for (int i = 0; i < N; ++i) {
                dest.writeString(this.mCategories.valueAt(i));
            }
        } else {
            dest.writeInt(0);
        }
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$describeContents() {
        return 0;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$toString() {
        return this.toStringInner(true, false);
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$toInsecureString() {
        return this.toStringInner(false, true);
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$toStringInner(boolean secure, boolean includeInternalData) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShortcutInfo {");
        sb.append("id=");
        sb.append(secure ? "***" : this.mId);
        sb.append(", packageName=");
        sb.append(this.mPackageName);
        if (this.isDynamic()) {
            sb.append(", dynamic");
        }
        if (this.isPinned()) {
            sb.append(", pinned");
        }
        sb.append(", activity=");
        sb.append(this.mActivityComponent);
        sb.append(", title=");
        sb.append(secure ? "***" : this.mTitle);
        sb.append(", text=");
        sb.append(secure ? "***" : this.mText);
        sb.append(", categories=");
        sb.append(this.mCategories);
        sb.append(", icon=");
        sb.append(this.mIcon);
        sb.append(", weight=");
        sb.append(this.mWeight);
        sb.append(", timestamp=");
        sb.append(this.mLastChangedTimestamp);
        sb.append(", intent=");
        sb.append(this.mIntent);
        sb.append(", intentExtras=");
        sb.append(secure ? "***" : this.mIntentPersistableExtras);
        sb.append(", extras=");
        sb.append(this.mExtras);
        sb.append(", flags=");
        sb.append(this.mFlags);
        if (includeInternalData) {
            sb.append(", iconRes=");
            sb.append(this.mIconResourceId);
            sb.append(", bitmapPath=");
            sb.append(this.mBitmapPath);
        }
        sb.append("}");
        return sb.toString();
    }

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(int userId, String id2, String packageName, ComponentName activityComponent, Icon icon, String title, String text, Set<String> categories, Intent intent, PersistableBundle intentPersistableExtras, int weight, PersistableBundle extras, long lastChangedTimestamp, int flags, int iconResId, String bitmapPath) {
        this.mUserId = userId;
        this.mId = id2;
        this.mPackageName = packageName;
        this.mActivityComponent = activityComponent;
        this.mIcon = icon;
        this.mTitle = title;
        this.mText = text;
        this.mCategories = this.clone(categories);
        this.mIntent = intent;
        this.mIntentPersistableExtras = intentPersistableExtras;
        this.mWeight = weight;
        this.mExtras = extras;
        this.mLastChangedTimestamp = lastChangedTimestamp;
        this.mFlags = flags;
        this.mIconResourceId = iconResId;
        this.mBitmapPath = bitmapPath;
    }

    private /* synthetic */ void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Builder x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ShortcutInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_ShortcutInfo_1$__constructor__() {
            }

            private final ShortcutInfo $$robo$$android_content_pm_ShortcutInfo_1$createFromParcel(Parcel source) {
                return new ShortcutInfo(source);
            }

            private final ShortcutInfo[] $$robo$$android_content_pm_ShortcutInfo_1$newArray(int size) {
                return new ShortcutInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_ShortcutInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo_1$__constructor__(), 0, this);
            }

            @Override
            public ShortcutInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_ShortcutInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ShortcutInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_ShortcutInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(builder);
    }

    private ShortcutInfo(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(android.content.pm.ShortcutInfo$Builder ), 0, this, builder);
    }

    private <T> ArraySet<T> clone(Set<T> set) {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_content_pm_ShortcutInfo$clone(java.util.Set<T> ), 0, this, set);
    }

    public void enforceMandatoryFields() {
        InvokeDynamicSupport.bootstrap("enforceMandatoryFields", $$robo$$android_content_pm_ShortcutInfo$enforceMandatoryFields(), 0, this);
    }

    private void __constructor__(ShortcutInfo shortcutInfo, int n) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(shortcutInfo, n);
    }

    private ShortcutInfo(ShortcutInfo shortcutInfo, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(android.content.pm.ShortcutInfo int ), 0, this, shortcutInfo, n);
    }

    public ShortcutInfo clone(int n) {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_content_pm_ShortcutInfo$clone(int ), 0, this, n);
    }

    public void copyNonNullFieldsFrom(ShortcutInfo shortcutInfo) {
        InvokeDynamicSupport.bootstrap("copyNonNullFieldsFrom", $$robo$$android_content_pm_ShortcutInfo$copyNonNullFieldsFrom(android.content.pm.ShortcutInfo ), 0, this, shortcutInfo);
    }

    public static Icon validateIcon(Icon icon) {
        return InvokeDynamicSupport.bootstrapStatic("validateIcon", $$robo$$android_content_pm_ShortcutInfo$validateIcon(android.graphics.drawable.Icon ), 0, (Icon)icon);
    }

    public static IllegalArgumentException getInvalidIconException() {
        return InvokeDynamicSupport.bootstrapStatic("getInvalidIconException", $$robo$$android_content_pm_ShortcutInfo$getInvalidIconException(), 0);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_content_pm_ShortcutInfo$getId(), 0, this);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_content_pm_ShortcutInfo$getPackageName(), 0, this);
    }

    public ComponentName getActivityComponent() {
        return InvokeDynamicSupport.bootstrap("getActivityComponent", $$robo$$android_content_pm_ShortcutInfo$getActivityComponent(), 0, this);
    }

    public Icon getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_content_pm_ShortcutInfo$getIcon(), 0, this);
    }

    public String getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_content_pm_ShortcutInfo$getTitle(), 0, this);
    }

    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_pm_ShortcutInfo$getText(), 0, this);
    }

    public Set<String> getCategories() {
        return InvokeDynamicSupport.bootstrap("getCategories", $$robo$$android_content_pm_ShortcutInfo$getCategories(), 0, this);
    }

    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_content_pm_ShortcutInfo$getIntent(), 0, this);
    }

    public Intent getIntentNoExtras() {
        return InvokeDynamicSupport.bootstrap("getIntentNoExtras", $$robo$$android_content_pm_ShortcutInfo$getIntentNoExtras(), 0, this);
    }

    public PersistableBundle getIntentPersistableExtras() {
        return InvokeDynamicSupport.bootstrap("getIntentPersistableExtras", $$robo$$android_content_pm_ShortcutInfo$getIntentPersistableExtras(), 0, this);
    }

    public int getWeight() {
        return (int)InvokeDynamicSupport.bootstrap("getWeight", $$robo$$android_content_pm_ShortcutInfo$getWeight(), 0, this);
    }

    public PersistableBundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_pm_ShortcutInfo$getExtras(), 0, this);
    }

    public int getUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getUserId", $$robo$$android_content_pm_ShortcutInfo$getUserId(), 0, this);
    }

    public UserHandle getUserHandle() {
        return InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_content_pm_ShortcutInfo$getUserHandle(), 0, this);
    }

    public long getLastChangedTimestamp() {
        return (long)InvokeDynamicSupport.bootstrap("getLastChangedTimestamp", $$robo$$android_content_pm_ShortcutInfo$getLastChangedTimestamp(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_content_pm_ShortcutInfo$getFlags(), 0, this);
    }

    public void replaceFlags(int n) {
        InvokeDynamicSupport.bootstrap("replaceFlags", $$robo$$android_content_pm_ShortcutInfo$replaceFlags(int ), 0, this, n);
    }

    public void addFlags(int n) {
        InvokeDynamicSupport.bootstrap("addFlags", $$robo$$android_content_pm_ShortcutInfo$addFlags(int ), 0, this, n);
    }

    public void clearFlags(int n) {
        InvokeDynamicSupport.bootstrap("clearFlags", $$robo$$android_content_pm_ShortcutInfo$clearFlags(int ), 0, this, n);
    }

    public boolean hasFlags(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFlags", $$robo$$android_content_pm_ShortcutInfo$hasFlags(int ), 0, this, n);
    }

    public boolean isDynamic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDynamic", $$robo$$android_content_pm_ShortcutInfo$isDynamic(), 0, this);
    }

    public boolean isPinned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPinned", $$robo$$android_content_pm_ShortcutInfo$isPinned(), 0, this);
    }

    public boolean hasIconResource() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIconResource", $$robo$$android_content_pm_ShortcutInfo$hasIconResource(), 0, this);
    }

    public boolean hasIconFile() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIconFile", $$robo$$android_content_pm_ShortcutInfo$hasIconFile(), 0, this);
    }

    public boolean hasKeyFieldsOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasKeyFieldsOnly", $$robo$$android_content_pm_ShortcutInfo$hasKeyFieldsOnly(), 0, this);
    }

    public void updateTimestamp() {
        InvokeDynamicSupport.bootstrap("updateTimestamp", $$robo$$android_content_pm_ShortcutInfo$updateTimestamp(), 0, this);
    }

    public void setTimestamp(long l) {
        InvokeDynamicSupport.bootstrap("setTimestamp", $$robo$$android_content_pm_ShortcutInfo$setTimestamp(long ), 0, this, l);
    }

    public void clearIcon() {
        InvokeDynamicSupport.bootstrap("clearIcon", $$robo$$android_content_pm_ShortcutInfo$clearIcon(), 0, this);
    }

    public void setIconResourceId(int n) {
        InvokeDynamicSupport.bootstrap("setIconResourceId", $$robo$$android_content_pm_ShortcutInfo$setIconResourceId(int ), 0, this, n);
    }

    public int getIconResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getIconResourceId", $$robo$$android_content_pm_ShortcutInfo$getIconResourceId(), 0, this);
    }

    public String getBitmapPath() {
        return InvokeDynamicSupport.bootstrap("getBitmapPath", $$robo$$android_content_pm_ShortcutInfo$getBitmapPath(), 0, this);
    }

    public void setBitmapPath(String string2) {
        InvokeDynamicSupport.bootstrap("setBitmapPath", $$robo$$android_content_pm_ShortcutInfo$setBitmapPath(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(parcel);
    }

    private ShortcutInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_ShortcutInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_ShortcutInfo$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_ShortcutInfo$toString(), 0, this);
    }

    public String toInsecureString() {
        return InvokeDynamicSupport.bootstrap("toInsecureString", $$robo$$android_content_pm_ShortcutInfo$toInsecureString(), 0, this);
    }

    private String toStringInner(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("toStringInner", $$robo$$android_content_pm_ShortcutInfo$toStringInner(boolean boolean ), 0, this, bl, bl2);
    }

    private void __constructor__(int n, String string2, String string3, ComponentName componentName, Icon icon, String string4, String string5, Set<String> set, Intent intent, PersistableBundle persistableBundle, int n2, PersistableBundle persistableBundle2, long l, int n3, int n4, String string6) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(n, string2, string3, componentName, icon, string4, string5, set, intent, persistableBundle, n2, persistableBundle2, l, n3, n4, string6);
    }

    public ShortcutInfo(int n, String string2, String string3, ComponentName componentName, Icon icon, String string4, String string5, Set<String> set, Intent intent, PersistableBundle persistableBundle, int n2, PersistableBundle persistableBundle2, long l, int n3, int n4, String string6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(int java.lang.String java.lang.String android.content.ComponentName android.graphics.drawable.Icon java.lang.String java.lang.String java.util.Set<java.lang.String> android.content.Intent android.os.PersistableBundle int android.os.PersistableBundle long int int java.lang.String ), 0, this, n, string2, string3, componentName, icon, string4, string5, set, intent, persistableBundle, n2, persistableBundle2, l, n3, n4, string6);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(builder, var2_2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ShortcutInfo.class);
    }

    public /* synthetic */ ShortcutInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShortcutInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private String mId;
        private ComponentName mActivityComponent;
        private Icon mIcon;
        private String mTitle;
        private String mText;
        private Set<String> mCategories;
        private Intent mIntent;
        private int mWeight;
        private PersistableBundle mExtras;

        private void $$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(Context context) {
            this.mContext = context;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setId(String id2) {
            this.mId = Preconditions.checkStringNotEmpty(id2, "id");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setActivityComponent(ComponentName activityComponent) {
            this.mActivityComponent = Preconditions.checkNotNull(activityComponent, "activityComponent");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setIcon(Icon icon) {
            this.mIcon = ShortcutInfo.validateIcon(icon);
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setTitle(String title) {
            this.mTitle = Preconditions.checkStringNotEmpty(title, "title");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setText(String text) {
            this.mText = Preconditions.checkStringNotEmpty(text, "text");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setCategories(Set<String> categories) {
            this.mCategories = categories;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setIntent(Intent intent) {
            this.mIntent = Preconditions.checkNotNull(intent, "intent");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setWeight(int weight) {
            this.mWeight = weight;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setExtras(PersistableBundle extras) {
            this.mExtras = extras;
            return this;
        }

        private final ShortcutInfo $$robo$$android_content_pm_ShortcutInfo_Builder$build() {
            return new ShortcutInfo(this);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        public Builder setId(String string2) {
            return InvokeDynamicSupport.bootstrap("setId", $$robo$$android_content_pm_ShortcutInfo_Builder$setId(java.lang.String ), 0, this, string2);
        }

        public Builder setActivityComponent(ComponentName componentName) {
            return InvokeDynamicSupport.bootstrap("setActivityComponent", $$robo$$android_content_pm_ShortcutInfo_Builder$setActivityComponent(android.content.ComponentName ), 0, this, componentName);
        }

        public Builder setIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_content_pm_ShortcutInfo_Builder$setIcon(android.graphics.drawable.Icon ), 0, this, icon);
        }

        public Builder setTitle(String string2) {
            return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_content_pm_ShortcutInfo_Builder$setTitle(java.lang.String ), 0, this, string2);
        }

        public Builder setText(String string2) {
            return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_content_pm_ShortcutInfo_Builder$setText(java.lang.String ), 0, this, string2);
        }

        public Builder setCategories(Set<String> set) {
            return InvokeDynamicSupport.bootstrap("setCategories", $$robo$$android_content_pm_ShortcutInfo_Builder$setCategories(java.util.Set<java.lang.String> ), 0, this, set);
        }

        public Builder setIntent(Intent intent) {
            return InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_content_pm_ShortcutInfo_Builder$setIntent(android.content.Intent ), 0, this, intent);
        }

        public Builder setWeight(int n) {
            return InvokeDynamicSupport.bootstrap("setWeight", $$robo$$android_content_pm_ShortcutInfo_Builder$setWeight(int ), 0, this, n);
        }

        public Builder setExtras(PersistableBundle persistableBundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_content_pm_ShortcutInfo_Builder$setExtras(android.os.PersistableBundle ), 0, this, persistableBundle);
        }

        public ShortcutInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_content_pm_ShortcutInfo_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

