/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageUserState;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.VerifierInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.PatternMatcher;
import android.os.Trace;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.TypedValue;
import android.util.apk.ApkSignatureSchemeV2Verifier;
import android.util.jar.StrictJarFile;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_JAR = false;
    private static boolean DEBUG_PARSER = false;
    private static boolean DEBUG_BACKUP = false;
    private static boolean MULTI_PACKAGE_APK_ENABLED = false;
    private static int MAX_PACKAGES_PER_APK = 5;
    public static int APK_SIGNING_UNKNOWN = 0;
    public static int APK_SIGNING_V1 = 1;
    public static int APK_SIGNING_V2 = 2;
    private static String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private static String MNT_EXPAND = "/mnt/expand/";
    private static String TAG_MANIFEST = "manifest";
    private static String TAG_APPLICATION = "application";
    private static String TAG_OVERLAY = "overlay";
    private static String TAG_KEY_SETS = "key-sets";
    private static String TAG_PERMISSION_GROUP = "permission-group";
    private static String TAG_PERMISSION = "permission";
    private static String TAG_PERMISSION_TREE = "permission-tree";
    private static String TAG_USES_PERMISSION = "uses-permission";
    private static String TAG_USES_PERMISSION_SDK_M = "uses-permission-sdk-m";
    private static String TAG_USES_PERMISSION_SDK_23 = "uses-permission-sdk-23";
    private static String TAG_USES_CONFIGURATION = "uses-configuration";
    private static String TAG_USES_FEATURE = "uses-feature";
    private static String TAG_FEATURE_GROUP = "feature-group";
    private static String TAG_USES_SDK = "uses-sdk";
    private static String TAG_SUPPORT_SCREENS = "supports-screens";
    private static String TAG_PROTECTED_BROADCAST = "protected-broadcast";
    private static String TAG_INSTRUMENTATION = "instrumentation";
    private static String TAG_ORIGINAL_PACKAGE = "original-package";
    private static String TAG_ADOPT_PERMISSIONS = "adopt-permissions";
    private static String TAG_USES_GL_TEXTURE = "uses-gl-texture";
    private static String TAG_COMPATIBLE_SCREENS = "compatible-screens";
    private static String TAG_SUPPORTS_INPUT = "supports-input";
    private static String TAG_EAT_COMMENT = "eat-comment";
    private static String TAG_PACKAGE = "package";
    private static String TAG_RESTRICT_UPDATE = "restrict-update";
    private static Set<String> CHILD_PACKAGE_TAGS;
    public static NewPermissionInfo[] NEW_PERMISSIONS;
    public static SplitPermissionInfo[] SPLIT_PERMISSIONS;
    @Deprecated
    private String mArchiveSourcePath;
    private String[] mSeparateProcesses;
    private boolean mOnlyCoreApps;
    private DisplayMetrics mMetrics;
    private static int SDK_VERSION;
    private static String[] SDK_CODENAMES;
    private int mParseError;
    private static boolean sCompatibilityModeEnabled;
    private static int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private ParseComponentArgs mParseActivityArgs;
    private ParseComponentArgs mParseActivityAliasArgs;
    private ParseComponentArgs mParseServiceArgs;
    private ParseComponentArgs mParseProviderArgs;
    private static boolean RIGID_PARSER = false;
    private static String TAG = "PackageParser";
    public static int PARSE_IS_SYSTEM = 1;
    public static int PARSE_CHATTY = 2;
    public static int PARSE_MUST_BE_APK = 4;
    public static int PARSE_IGNORE_PROCESSES = 8;
    public static int PARSE_FORWARD_LOCK = 16;
    public static int PARSE_EXTERNAL_STORAGE = 32;
    public static int PARSE_IS_SYSTEM_DIR = 64;
    public static int PARSE_IS_PRIVILEGED = 128;
    public static int PARSE_COLLECT_CERTIFICATES = 256;
    public static int PARSE_TRUSTED_OVERLAY = 512;
    public static int PARSE_ENFORCE_CODE = 1024;
    public static int PARSE_IS_EPHEMERAL = 2048;
    public static int PARSE_FORCE_SDK = 4096;
    private static Comparator<String> sSplitNameComparator;
    private static String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";
    private static AtomicReference<byte[]> sBuffer;

    private void $$robo$$android_content_pm_PackageParser$__constructor__() {
        this.mParseError = 1;
        this.mMetrics = new DisplayMetrics();
        this.mMetrics.setToDefaults();
    }

    private final void $$robo$$android_content_pm_PackageParser$setSeparateProcesses(String[] procs) {
        this.mSeparateProcesses = procs;
    }

    private final void $$robo$$android_content_pm_PackageParser$setOnlyCoreApps(boolean onlyCoreApps) {
        this.mOnlyCoreApps = onlyCoreApps;
    }

    private final void $$robo$$android_content_pm_PackageParser$setDisplayMetrics(DisplayMetrics metrics) {
        this.mMetrics = metrics;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isApkFile(File file) {
        return PackageParser.isApkPath(file.getName());
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isApkPath(String path) {
        return path.endsWith(".apk");
    }

    private static final PackageInfo $$robo$$android_content_pm_PackageParser$generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state) {
        return PackageParser.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, grantedPermissions, state, UserHandle.getCallingUserId());
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$checkUseInstalledOrHidden(int flags, PackageUserState state) {
        return state.installed && !state.hidden || (flags & 0x2000) != 0;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$isAvailable(PackageUserState state) {
        return PackageParser.checkUseInstalledOrHidden(0, state);
    }

    private static final PackageInfo $$robo$$android_content_pm_PackageParser$generatePackageInfo(Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime, Set<String> grantedPermissions, PackageUserState state, int userId) {
        int i;
        Activity a;
        int i2;
        ComponentInfo[] res;
        int num;
        int N;
        if (!PackageParser.checkUseInstalledOrHidden(flags, state) || !p.isMatch(flags)) {
            return null;
        }
        PackageInfo pi = new PackageInfo();
        pi.packageName = p.packageName;
        pi.splitNames = p.splitNames;
        pi.versionCode = p.mVersionCode;
        pi.baseRevisionCode = p.baseRevisionCode;
        pi.splitRevisionCodes = p.splitRevisionCodes;
        pi.versionName = p.mVersionName;
        pi.sharedUserId = p.mSharedUserId;
        pi.sharedUserLabel = p.mSharedUserLabel;
        pi.applicationInfo = PackageParser.generateApplicationInfo(p, flags, state, userId);
        pi.installLocation = p.installLocation;
        pi.coreApp = p.coreApp;
        if ((pi.applicationInfo.flags & 1) != 0 || (pi.applicationInfo.flags & 0x80) != 0) {
            pi.requiredForAllUsers = p.mRequiredForAllUsers;
        }
        pi.restrictedAccountType = p.mRestrictedAccountType;
        pi.requiredAccountType = p.mRequiredAccountType;
        pi.overlayTarget = p.mOverlayTarget;
        pi.firstInstallTime = firstInstallTime;
        pi.lastUpdateTime = lastUpdateTime;
        if ((flags & 0x100) != 0) {
            pi.gids = gids;
        }
        if ((flags & 0x4000) != 0) {
            int n = N = p.configPreferences != null ? p.configPreferences.size() : 0;
            if (N > 0) {
                pi.configPreferences = new ConfigurationInfo[N];
                p.configPreferences.toArray(pi.configPreferences);
            }
            int n2 = N = p.reqFeatures != null ? p.reqFeatures.size() : 0;
            if (N > 0) {
                pi.reqFeatures = new FeatureInfo[N];
                p.reqFeatures.toArray(pi.reqFeatures);
            }
            int n3 = N = p.featureGroups != null ? p.featureGroups.size() : 0;
            if (N > 0) {
                pi.featureGroups = new FeatureGroupInfo[N];
                p.featureGroups.toArray(pi.featureGroups);
            }
        }
        if ((flags & 1) != 0 && (N = p.activities.size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                a = p.activities.get(i2);
                if (!state.isMatch(a.info, flags)) continue;
                res[num++] = PackageParser.generateActivityInfo(a, flags, state, userId);
            }
            pi.activities = ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 2) != 0 && (N = p.receivers.size()) > 0) {
            num = 0;
            res = new ActivityInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                a = p.receivers.get(i2);
                if (!state.isMatch(a.info, flags)) continue;
                res[num++] = PackageParser.generateActivityInfo(a, flags, state, userId);
            }
            pi.receivers = (ActivityInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 4) != 0 && (N = p.services.size()) > 0) {
            num = 0;
            res = new ServiceInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                Service s = p.services.get(i2);
                if (!state.isMatch(s.info, flags)) continue;
                res[num++] = PackageParser.generateServiceInfo(s, flags, state, userId);
            }
            pi.services = (ServiceInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 8) != 0 && (N = p.providers.size()) > 0) {
            num = 0;
            res = new ProviderInfo[N];
            for (i2 = 0; i2 < N; ++i2) {
                Provider pr = p.providers.get(i2);
                if (!state.isMatch(pr.info, flags)) continue;
                res[num++] = PackageParser.generateProviderInfo(pr, flags, state, userId);
            }
            pi.providers = (ProviderInfo[])ArrayUtils.trimToSize(res, num);
        }
        if ((flags & 0x10) != 0 && (N = p.instrumentation.size()) > 0) {
            pi.instrumentation = new InstrumentationInfo[N];
            for (i = 0; i < N; ++i) {
                pi.instrumentation[i] = PackageParser.generateInstrumentationInfo(p.instrumentation.get(i), flags);
            }
        }
        if ((flags & 0x1000) != 0) {
            N = p.permissions.size();
            if (N > 0) {
                pi.permissions = new PermissionInfo[N];
                for (i = 0; i < N; ++i) {
                    pi.permissions[i] = PackageParser.generatePermissionInfo(p.permissions.get(i), flags);
                }
            }
            if ((N = p.requestedPermissions.size()) > 0) {
                pi.requestedPermissions = new String[N];
                pi.requestedPermissionsFlags = new int[N];
                for (i = 0; i < N; ++i) {
                    String perm;
                    pi.requestedPermissions[i] = perm = p.requestedPermissions.get(i);
                    int n = i;
                    pi.requestedPermissionsFlags[n] = pi.requestedPermissionsFlags[n] | 1;
                    if (grantedPermissions == null || !grantedPermissions.contains(perm)) continue;
                    int n4 = i;
                    pi.requestedPermissionsFlags[n4] = pi.requestedPermissionsFlags[n4] | 2;
                }
            }
        }
        if ((flags & 0x40) != 0) {
            int n = N = p.mSignatures != null ? p.mSignatures.length : 0;
            if (N > 0) {
                pi.signatures = new Signature[N];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)p.mSignatures, (int)0, (Object)pi.signatures, (int)0, (int)N);
            }
        }
        return pi;
    }

    private static final Certificate[][] $$robo$$android_content_pm_PackageParser$loadCertificates(StrictJarFile jarFile, ZipEntry entry) throws PackageParserException {
        InputStream is = null;
        try {
            is = jarFile.getInputStream(entry);
            PackageParser.readFullyIgnoringContents(is);
            Certificate[][] certificateArray = jarFile.getCertificateChains(entry);
            return certificateArray;
        }
        catch (IOException | RuntimeException e) {
            throw new PackageParserException(-102, "Failed reading " + entry.getName() + " in " + jarFile, e);
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parsePackageLite(File packageFile, int flags) throws PackageParserException {
        if (packageFile.isDirectory()) {
            return PackageParser.parseClusterPackageLite(packageFile, flags);
        }
        return PackageParser.parseMonolithicPackageLite(packageFile, flags);
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parseMonolithicPackageLite(File packageFile, int flags) throws PackageParserException {
        ApkLite baseApk = PackageParser.parseApkLite(packageFile, flags);
        String packagePath = packageFile.getAbsolutePath();
        return new PackageLite(packagePath, baseApk, null, null, null);
    }

    private static final PackageLite $$robo$$android_content_pm_PackageParser$parseClusterPackageLite(File packageDir, int flags) throws PackageParserException {
        File[] files = packageDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            throw new PackageParserException(-100, "No packages found in split");
        }
        String packageName = null;
        int versionCode = 0;
        ArrayMap<String, ApkLite> apks = new ArrayMap<String, ApkLite>();
        for (File file : files) {
            if (!PackageParser.isApkFile(file)) continue;
            ApkLite lite = PackageParser.parseApkLite(file, flags);
            if (packageName == null) {
                packageName = lite.packageName;
                versionCode = lite.versionCode;
            } else {
                if (!packageName.equals(lite.packageName)) {
                    throw new PackageParserException(-101, "Inconsistent package " + lite.packageName + " in " + file + "; expected " + packageName);
                }
                if (versionCode != lite.versionCode) {
                    throw new PackageParserException(-101, "Inconsistent version " + lite.versionCode + " in " + file + "; expected " + versionCode);
                }
            }
            if (apks.put(lite.splitName, lite) == null) continue;
            throw new PackageParserException(-101, "Split name " + lite.splitName + " defined more than once; most recent was " + file);
        }
        ApkLite baseApk = (ApkLite)apks.remove(null);
        if (baseApk == null) {
            throw new PackageParserException(-101, "Missing base APK in " + packageDir);
        }
        int size = apks.size();
        String[] splitNames = null;
        String[] splitCodePaths = null;
        int[] splitRevisionCodes = null;
        if (size > 0) {
            splitNames = new String[size];
            splitCodePaths = new String[size];
            splitRevisionCodes = new int[size];
            splitNames = apks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                splitCodePaths[i] = ((ApkLite)apks.get((Object)splitNames[i])).codePath;
                splitRevisionCodes[i] = ((ApkLite)apks.get((Object)splitNames[i])).revisionCode;
            }
        }
        String codePath = packageDir.getAbsolutePath();
        return new PackageLite(codePath, baseApk, splitNames, splitCodePaths, splitRevisionCodes);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parsePackage(File packageFile, int flags) throws PackageParserException {
        if (packageFile.isDirectory()) {
            return this.parseClusterPackage(packageFile, flags);
        }
        return this.parseMonolithicPackage(packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Package $$robo$$android_content_pm_PackageParser$parseClusterPackage(File packageDir, int flags) throws PackageParserException {
        PackageLite lite = PackageParser.parseClusterPackageLite(packageDir, 0);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + packageDir);
        }
        AssetManager assets = new AssetManager();
        try {
            File baseApk;
            Package pkg;
            PackageParser.loadApkIntoAssetManager(assets, lite.baseCodePath, flags);
            if (!ArrayUtils.isEmpty(lite.splitCodePaths)) {
                for (String path : lite.splitCodePaths) {
                    PackageParser.loadApkIntoAssetManager(assets, path, flags);
                }
            }
            if ((pkg = this.parseBaseApk(baseApk = new File(lite.baseCodePath), assets, flags)) == null) {
                throw new PackageParserException(-100, "Failed to parse base APK: " + baseApk);
            }
            if (!ArrayUtils.isEmpty(lite.splitNames)) {
                int num = lite.splitNames.length;
                pkg.splitNames = lite.splitNames;
                pkg.splitCodePaths = lite.splitCodePaths;
                pkg.splitRevisionCodes = lite.splitRevisionCodes;
                pkg.splitFlags = new int[num];
                pkg.splitPrivateFlags = new int[num];
                for (int i = 0; i < num; ++i) {
                    this.parseSplitApk(pkg, i, assets, flags);
                }
            }
            pkg.setCodePath(packageDir.getAbsolutePath());
            pkg.setUse32bitAbi(lite.use32bitAbi);
            Package package_ = pkg;
            return package_;
        }
        finally {
            IoUtils.closeQuietly(assets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final Package $$robo$$android_content_pm_PackageParser$parseMonolithicPackage(File apkFile, int flags) throws PackageParserException {
        PackageLite lite = PackageParser.parseMonolithicPackageLite(apkFile, flags);
        if (this.mOnlyCoreApps && !lite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + apkFile);
        }
        AssetManager assets = new AssetManager();
        try {
            Package pkg = this.parseBaseApk(apkFile, assets, flags);
            pkg.setCodePath(apkFile.getAbsolutePath());
            pkg.setUse32bitAbi(lite.use32bitAbi);
            Package package_ = pkg;
            return package_;
        }
        finally {
            IoUtils.closeQuietly(assets);
        }
    }

    private static final int $$robo$$android_content_pm_PackageParser$loadApkIntoAssetManager(AssetManager assets, String apkPath, int flags) throws PackageParserException {
        if ((flags & 4) != 0 && !PackageParser.isApkPath(apkPath)) {
            throw new PackageParserException(-100, "Invalid package file: " + apkPath);
        }
        int cookie = assets.addAssetPath(apkPath);
        if (cookie == 0) {
            throw new PackageParserException(-101, "Failed adding asset path: " + apkPath);
        }
        return cookie;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApk(File apkFile, AssetManager assets, int flags) throws PackageParserException {
        Package package_;
        String apkPath = apkFile.getAbsolutePath();
        String volumeUuid = null;
        if (apkPath.startsWith("/mnt/expand/")) {
            int end = apkPath.indexOf(47, "/mnt/expand/".length());
            volumeUuid = apkPath.substring("/mnt/expand/".length(), end);
        }
        this.mParseError = 1;
        this.mArchiveSourcePath = apkFile.getAbsolutePath();
        int cookie = PackageParser.loadApkIntoAssetManager(assets, apkPath, flags);
        Resources res = null;
        XmlResourceParser parser = null;
        try {
            res = new Resources(assets, this.mMetrics, null);
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            String[] outError = new String[1];
            Package pkg = this.parseBaseApk(res, parser, flags, outError);
            if (pkg == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
            pkg.setVolumeUuid(volumeUuid);
            pkg.setApplicationVolumeUuid(volumeUuid);
            pkg.setBaseCodePath(apkPath);
            pkg.setSignatures(null);
            package_ = pkg;
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        return package_;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$android_content_pm_PackageParser$parseSplitApk(Package pkg, int splitIndex, AssetManager assets, int flags) throws PackageParserException {
        String apkPath = pkg.splitCodePaths[splitIndex];
        this.mParseError = 1;
        this.mArchiveSourcePath = apkPath;
        int cookie = PackageParser.loadApkIntoAssetManager(assets, apkPath, flags);
        Resources res = null;
        XmlResourceParser parser = null;
        try {
            res = new Resources(assets, this.mMetrics, null);
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            String[] outError = new String[1];
            pkg = this.parseSplitApk(pkg, res, parser, flags, splitIndex, outError);
            if (pkg == null) {
                throw new PackageParserException(this.mParseError, apkPath + " (at " + parser.getPositionDescription() + "): " + outError[0]);
            }
        }
        catch (PackageParserException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackageParserException(-102, "Failed to read manifest from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseSplitApk(Package pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException, PackageParserException {
        int type;
        XmlResourceParser attrs = parser;
        PackageParser.parsePackageSplitNames(parser, attrs);
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        boolean foundApp = false;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("application")) {
                if (foundApp) {
                    Slog.w("PackageParser", "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseSplitApplication(pkg, res, parser, flags, splitIndex, outError)) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp) {
            outError[0] = "<manifest> does not contain an <application>";
            this.mParseError = -109;
        }
        return pkg;
    }

    private static final int $$robo$$android_content_pm_PackageParser$getApkSigningVersion(Package pkg) {
        try {
            if (ApkSignatureSchemeV2Verifier.hasSignature(pkg.baseCodePath)) {
                return 2;
            }
            return 1;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static final void $$robo$$android_content_pm_PackageParser$populateCertificates(Package pkg, Certificate[][] certificates) throws PackageParserException {
        pkg.mCertificates = null;
        pkg.mSignatures = null;
        pkg.mSigningKeys = null;
        pkg.mCertificates = certificates;
        try {
            pkg.mSignatures = PackageParser.convertToSignatures(certificates);
        }
        catch (CertificateEncodingException e) {
            throw new PackageParserException(-103, "Failed to collect certificates from " + pkg.baseCodePath, e);
        }
        pkg.mSigningKeys = new ArraySet(certificates.length);
        for (int i = 0; i < certificates.length; ++i) {
            Certificate[] signerCerts = certificates[i];
            Certificate signerCert = signerCerts[0];
            pkg.mSigningKeys.add(signerCert.getPublicKey());
        }
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            Package childPkg = pkg.childPackages.get(i);
            childPkg.mCertificates = pkg.mCertificates;
            childPkg.mSignatures = pkg.mSignatures;
            childPkg.mSigningKeys = pkg.mSigningKeys;
        }
    }

    private static final void $$robo$$android_content_pm_PackageParser$collectCertificates(Package pkg, int parseFlags) throws PackageParserException {
        PackageParser.collectCertificatesInternal(pkg, parseFlags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            Package childPkg = pkg.childPackages.get(i);
            childPkg.mCertificates = pkg.mCertificates;
            childPkg.mSignatures = pkg.mSignatures;
            childPkg.mSigningKeys = pkg.mSigningKeys;
        }
    }

    private static final void $$robo$$android_content_pm_PackageParser$collectCertificatesInternal(Package pkg, int parseFlags) throws PackageParserException {
        pkg.mCertificates = null;
        pkg.mSignatures = null;
        pkg.mSigningKeys = null;
        Trace.traceBegin(262144L, "collectCertificates");
        try {
            PackageParser.collectCertificates(pkg, new File(pkg.baseCodePath), parseFlags);
            if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
                for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                    PackageParser.collectCertificates(pkg, new File(pkg.splitCodePaths[i]), parseFlags);
                }
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void $$robo$$android_content_pm_PackageParser$collectCertificates(Package pkg, File apkFile, int parseFlags) throws PackageParserException {
        ZipEntry manifestEntry;
        StrictJarFile jarFile;
        String apkPath;
        block26: {
            apkPath = apkFile.getAbsolutePath();
            boolean verified = false;
            Certificate[][] allSignersCerts = null;
            Signature[] signatures = null;
            try {
                Trace.traceBegin(262144L, "verifyV2");
                allSignersCerts = ApkSignatureSchemeV2Verifier.verify(apkPath);
                signatures = PackageParser.convertToSignatures(allSignersCerts);
                verified = true;
            }
            catch (ApkSignatureSchemeV2Verifier.SignatureNotFoundException signatureNotFoundException) {
            }
            catch (Exception e) {
                throw new PackageParserException(-103, "Failed to collect certificates from " + apkPath + " using APK Signature Scheme v2", e);
            }
            finally {
                Trace.traceEnd(262144L);
            }
            if (verified) {
                if (pkg.mCertificates == null) {
                    pkg.mCertificates = allSignersCerts;
                    pkg.mSignatures = signatures;
                    pkg.mSigningKeys = new ArraySet(allSignersCerts.length);
                    for (int i = 0; i < allSignersCerts.length; ++i) {
                        Certificate[] signerCerts = allSignersCerts[i];
                        Certificate signerCert = signerCerts[0];
                        pkg.mSigningKeys.add(signerCert.getPublicKey());
                    }
                } else if (!Signature.areExactMatch(pkg.mSignatures, signatures)) {
                    throw new PackageParserException(-104, apkPath + " has mismatched certificates");
                }
            }
            jarFile = null;
            Trace.traceBegin(262144L, "strictJarFileCtor");
            boolean signatureSchemeRollbackProtectionsEnforced = (parseFlags & 0x40) == 0;
            jarFile = new StrictJarFile(apkPath, !verified, signatureSchemeRollbackProtectionsEnforced);
            Trace.traceEnd(262144L);
            manifestEntry = jarFile.findEntry("AndroidManifest.xml");
            if (manifestEntry == null) {
                throw new PackageParserException(-101, "Package " + apkPath + " has no manifest");
            }
            if (!verified) break block26;
            PackageParser.closeQuietly(jarFile);
            return;
        }
        try {
            Trace.traceBegin(262144L, "verifyV1");
            ArrayList<ZipEntry> toVerify = new ArrayList<ZipEntry>();
            toVerify.add(manifestEntry);
            if ((parseFlags & 0x40) == 0) {
                Iterator<ZipEntry> i = jarFile.iterator();
                while (i.hasNext()) {
                    String entryName;
                    ZipEntry entry = i.next();
                    if (entry.isDirectory() || (entryName = entry.getName()).startsWith("META-INF/") || entryName.equals("AndroidManifest.xml")) continue;
                    toVerify.add(entry);
                }
            }
            for (ZipEntry entry : toVerify) {
                Certificate[][] entryCerts = PackageParser.loadCertificates(jarFile, entry);
                if (ArrayUtils.isEmpty(entryCerts)) {
                    throw new PackageParserException(-103, "Package " + apkPath + " has no certificates at entry " + entry.getName());
                }
                Signature[] entrySignatures = PackageParser.convertToSignatures(entryCerts);
                if (pkg.mCertificates == null) {
                    pkg.mCertificates = entryCerts;
                    pkg.mSignatures = entrySignatures;
                    pkg.mSigningKeys = new ArraySet();
                    for (int i = 0; i < entryCerts.length; ++i) {
                        pkg.mSigningKeys.add(entryCerts[i][0].getPublicKey());
                    }
                    continue;
                }
                if (Signature.areExactMatch(pkg.mSignatures, entrySignatures)) continue;
                throw new PackageParserException(-104, "Package " + apkPath + " has mismatched certificates at entry " + entry.getName());
            }
            Trace.traceEnd(262144L);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new PackageParserException(-105, "Failed to collect certificates from " + apkPath, e);
                catch (IOException | RuntimeException e2) {
                    throw new PackageParserException(-103, "Failed to collect certificates from " + apkPath, e2);
                }
            }
            catch (Throwable throwable) {
                PackageParser.closeQuietly(jarFile);
                throw throwable;
            }
        }
        PackageParser.closeQuietly(jarFile);
        return;
    }

    private static final Signature[] $$robo$$android_content_pm_PackageParser$convertToSignatures(Certificate[][] certs) throws CertificateEncodingException {
        Signature[] res = new Signature[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            res[i] = new Signature(certs[i]);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(File apkFile, int flags) throws PackageParserException {
        ApkLite apkLite;
        String apkPath = apkFile.getAbsolutePath();
        AssetManager assets = null;
        XmlResourceParser parser = null;
        try {
            Certificate[][] certificates;
            Signature[] signatures;
            assets = new AssetManager();
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            int cookie = assets.addAssetPath(apkPath);
            if (cookie == 0) {
                throw new PackageParserException(-100, "Failed to parse " + apkPath);
            }
            DisplayMetrics metrics = new DisplayMetrics();
            metrics.setToDefaults();
            Resources res = new Resources(assets, metrics, null);
            parser = assets.openXmlResourceParser(cookie, "AndroidManifest.xml");
            if ((flags & 0x100) != 0) {
                Package tempPkg = new Package(null);
                Trace.traceBegin(262144L, "collectCertificates");
                try {
                    PackageParser.collectCertificates(tempPkg, apkFile, 0);
                }
                finally {
                    Trace.traceEnd(262144L);
                }
                signatures = tempPkg.mSignatures;
                certificates = tempPkg.mCertificates;
            } else {
                signatures = null;
                certificates = null;
            }
            XmlResourceParser attrs = parser;
            apkLite = PackageParser.parseApkLite(apkPath, res, parser, attrs, flags, signatures, certificates);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                throw new PackageParserException(-102, "Failed to parse " + apkPath, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                IoUtils.closeQuietly(assets);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(parser);
        IoUtils.closeQuietly(assets);
        return apkLite;
    }

    private static final String $$robo$$android_content_pm_PackageParser$validateName(String name, boolean requireSeparator, boolean requireFilename) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "bad character '" + c + "'";
        }
        if (requireFilename && !FileUtils.isValidExtFilename(name)) {
            return "Invalid filename";
        }
        return hasSep || !requireSeparator ? null : "must have at least one '.' separator";
    }

    private static final Pair<String, String> $$robo$$android_content_pm_PackageParser$parsePackageSplitNames(XmlPullParser parser, AttributeSet attrs) throws IOException, XmlPullParserException, PackageParserException {
        String error;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new PackageParserException(-108, "No start tag found");
        }
        if (!parser.getName().equals("manifest")) {
            throw new PackageParserException(-108, "No <manifest> tag");
        }
        String packageName = attrs.getAttributeValue(null, "package");
        if (!"android".equals(packageName) && (error = PackageParser.validateName(packageName, true, true)) != null) {
            throw new PackageParserException(-106, "Invalid manifest package: " + error);
        }
        String splitName = attrs.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                String error2 = PackageParser.validateName(splitName, false, false);
                if (error2 != null) {
                    throw new PackageParserException(-106, "Invalid manifest split: " + error2);
                }
            }
        }
        return Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName);
    }

    private static final ApkLite $$robo$$android_content_pm_PackageParser$parseApkLite(String codePath, Resources res, XmlPullParser parser, AttributeSet attrs, int flags, Signature[] signatures, Certificate[][] certificates) throws IOException, XmlPullParserException, PackageParserException {
        int type;
        Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, attrs);
        int installLocation = -1;
        int versionCode = 0;
        int revisionCode = 0;
        boolean coreApp = false;
        boolean multiArch = false;
        boolean use32bitAbi = false;
        boolean extractNativeLibs = true;
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            String attr2 = attrs.getAttributeName(i);
            if (attr2.equals("installLocation")) {
                installLocation = attrs.getAttributeIntValue(i, -1);
                continue;
            }
            if (attr2.equals("versionCode")) {
                versionCode = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (attr2.equals("revisionCode")) {
                revisionCode = attrs.getAttributeIntValue(i, 0);
                continue;
            }
            if (!attr2.equals("coreApp")) continue;
            coreApp = attrs.getAttributeBooleanValue(i, false);
        }
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            VerifierInfo verifier;
            if (type == 3 || type == 4) continue;
            if (parser.getDepth() == searchDepth && "package-verifier".equals(parser.getName()) && (verifier = PackageParser.parseVerifier(res, parser, attrs, flags)) != null) {
                verifiers.add(verifier);
            }
            if (parser.getDepth() != searchDepth || !"application".equals(parser.getName())) continue;
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                String attr3 = attrs.getAttributeName(i);
                if ("multiArch".equals(attr3)) {
                    multiArch = attrs.getAttributeBooleanValue(i, false);
                }
                if ("use32bitAbi".equals(attr3)) {
                    use32bitAbi = attrs.getAttributeBooleanValue(i, false);
                }
                if (!"extractNativeLibs".equals(attr3)) continue;
                extractNativeLibs = attrs.getAttributeBooleanValue(i, true);
            }
        }
        return new ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, versionCode, revisionCode, installLocation, verifiers, signatures, certificates, coreApp, multiArch, use32bitAbi, extractNativeLibs);
    }

    private static final Signature $$robo$$android_content_pm_PackageParser$stringToSignature(String str) {
        int N = str.length();
        byte[] sig = new byte[N];
        for (int i = 0; i < N; ++i) {
            sig[i] = (byte)str.charAt(i);
        }
        return new Signature(sig);
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseBaseApkChild(Package parentPkg, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        if (parentPkg.childPackages != null && parentPkg.childPackages.size() + 2 > 5) {
            outError[0] = "Maximum number of packages per APK is: 5";
            this.mParseError = -108;
            return false;
        }
        String childPackageName = parser.getAttributeValue(null, "package");
        if (PackageParser.validateName(childPackageName, true, false) != null) {
            this.mParseError = -106;
            return false;
        }
        if (childPackageName.equals(parentPkg.packageName)) {
            String message = "Child package name cannot be equal to parent package name: " + parentPkg.packageName;
            Slog.w("PackageParser", message);
            outError[0] = message;
            this.mParseError = -108;
            return false;
        }
        if (parentPkg.hasChildPackage(childPackageName)) {
            String message = "Duplicate child package:" + childPackageName;
            Slog.w("PackageParser", message);
            outError[0] = message;
            this.mParseError = -108;
            return false;
        }
        Package childPkg = new Package(childPackageName);
        childPkg.mVersionCode = parentPkg.mVersionCode;
        childPkg.baseRevisionCode = parentPkg.baseRevisionCode;
        childPkg.mVersionName = parentPkg.mVersionName;
        childPkg.applicationInfo.targetSdkVersion = parentPkg.applicationInfo.targetSdkVersion;
        childPkg.applicationInfo.minSdkVersion = parentPkg.applicationInfo.minSdkVersion;
        if ((childPkg = this.parseBaseApkCommon(childPkg, CHILD_PACKAGE_TAGS, res, parser, flags, outError)) == null) {
            return false;
        }
        if (parentPkg.childPackages == null) {
            parentPkg.childPackages = new ArrayList();
        }
        parentPkg.childPackages.add(childPkg);
        childPkg.parentPackage = parentPkg;
        return true;
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApk(Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        String pkgName;
        try {
            Pair<String, String> packageSplit = PackageParser.parsePackageSplitNames(parser, parser);
            pkgName = (String)packageSplit.first;
            String splitName = (String)packageSplit.second;
            if (!TextUtils.isEmpty(splitName)) {
                outError[0] = "Expected base APK, but found split " + splitName;
                this.mParseError = -106;
                return null;
            }
        }
        catch (PackageParserException e) {
            this.mParseError = -106;
            return null;
        }
        Package pkg = new Package(pkgName);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        pkg.mVersionCode = pkg.applicationInfo.versionCode = sa.getInteger(1, 0);
        pkg.baseRevisionCode = sa.getInteger(5, 0);
        pkg.mVersionName = sa.getNonConfigurationString(2, 0);
        if (pkg.mVersionName != null) {
            pkg.mVersionName = pkg.mVersionName.intern();
        }
        pkg.coreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
        sa.recycle();
        return this.parseBaseApkCommon(pkg, null, res, parser, flags, outError);
    }

    private final Package $$robo$$android_content_pm_PackageParser$parseBaseApkCommon(Package pkg, Set<String> acceptedTags, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        boolean foundApp = false;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        String str = sa.getNonConfigurationString(0, 0);
        if (str != null && str.length() > 0) {
            String nameError = PackageParser.validateName(str, true, false);
            if (nameError != null && !"android".equals(pkg.packageName)) {
                outError[0] = "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameError;
                this.mParseError = -107;
                return null;
            }
            pkg.mSharedUserId = str.intern();
            pkg.mSharedUserLabel = sa.getResourceId(3, 0);
        }
        pkg.applicationInfo.installLocation = pkg.installLocation = sa.getInteger(4, -1);
        if ((flags & 0x10) != 0) {
            pkg.applicationInfo.privateFlags |= 4;
        }
        if ((flags & 0x20) != 0) {
            pkg.applicationInfo.flags |= 0x40000;
        }
        if ((flags & 0x800) != 0) {
            pkg.applicationInfo.privateFlags |= 0x200;
        }
        int supportsSmallScreens = 1;
        int supportsNormalScreens = 1;
        int supportsLargeScreens = 1;
        int supportsXLargeScreens = 1;
        int resizeable = 1;
        int anyDensity = 1;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (acceptedTags != null && !acceptedTags.contains(tagName)) {
                Slog.w("PackageParser", "Skipping unsupported element under <manifest>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("application")) {
                if (foundApp) {
                    Slog.w("PackageParser", "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                foundApp = true;
                if (this.parseBaseApplication(pkg, res, parser, flags, outError)) continue;
                return null;
            }
            if (tagName.equals("overlay")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestResourceOverlay);
                pkg.mOverlayTarget = sa.getString(1);
                pkg.mOverlayPriority = sa.getInt(0, -1);
                sa.recycle();
                if (pkg.mOverlayTarget == null) {
                    outError[0] = "<overlay> does not specify a target package";
                    this.mParseError = -108;
                    return null;
                }
                if (pkg.mOverlayPriority < 0 || pkg.mOverlayPriority > 9999) {
                    outError[0] = "<overlay> priority must be between 0 and 9999";
                    this.mParseError = -108;
                    return null;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("key-sets")) {
                if (this.parseKeySets(pkg, res, parser, outError)) continue;
                return null;
            }
            if (tagName.equals("permission-group")) {
                if (this.parsePermissionGroup(pkg, flags, res, parser, outError) != null) continue;
                return null;
            }
            if (tagName.equals("permission")) {
                if (this.parsePermission(pkg, res, parser, outError) != null) continue;
                return null;
            }
            if (tagName.equals("permission-tree")) {
                if (this.parsePermissionTree(pkg, res, parser, outError) != null) continue;
                return null;
            }
            if (tagName.equals("uses-permission")) {
                if (this.parseUsesPermission(pkg, res, parser)) continue;
                return null;
            }
            if (tagName.equals("uses-permission-sdk-m") || tagName.equals("uses-permission-sdk-23")) {
                if (this.parseUsesPermission(pkg, res, parser)) continue;
                return null;
            }
            if (tagName.equals("uses-configuration")) {
                ConfigurationInfo cPref = new ConfigurationInfo();
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesConfiguration);
                cPref.reqTouchScreen = sa.getInt(0, 0);
                cPref.reqKeyboardType = sa.getInt(1, 0);
                if (sa.getBoolean(2, false)) {
                    cPref.reqInputFeatures |= 1;
                }
                cPref.reqNavigation = sa.getInt(3, 0);
                if (sa.getBoolean(4, false)) {
                    cPref.reqInputFeatures |= 2;
                }
                sa.recycle();
                pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-feature")) {
                FeatureInfo fi = this.parseUsesFeature(res, parser);
                pkg.reqFeatures = ArrayUtils.add(pkg.reqFeatures, fi);
                if (fi.name == null) {
                    ConfigurationInfo cPref = new ConfigurationInfo();
                    cPref.reqGlEsVersion = fi.reqGlEsVersion;
                    pkg.configPreferences = ArrayUtils.add(pkg.configPreferences, cPref);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("feature-group")) {
                FeatureGroupInfo group = new FeatureGroupInfo();
                ArrayList<FeatureInfo> features = null;
                int innerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String innerTagName = parser.getName();
                    if (innerTagName.equals("uses-feature")) {
                        FeatureInfo featureInfo = this.parseUsesFeature(res, parser);
                        featureInfo.flags |= 1;
                        features = ArrayUtils.add(features, featureInfo);
                    } else {
                        Slog.w("PackageParser", "Unknown element under <feature-group>: " + innerTagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    }
                    XmlUtils.skipCurrentTag(parser);
                }
                if (features != null) {
                    group.features = new FeatureInfo[features.size()];
                    group.features = features.toArray(group.features);
                }
                pkg.featureGroups = ArrayUtils.add(pkg.featureGroups, group);
                continue;
            }
            if (tagName.equals("uses-sdk")) {
                if (SDK_VERSION > 0) {
                    boolean allowedCodename;
                    sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesSdk);
                    int minVers = 1;
                    String minCode = null;
                    int targetVers = 0;
                    String targetCode = null;
                    TypedValue val = sa.peekValue(0);
                    if (val != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = minCode = val.string.toString();
                        } else {
                            targetVers = minVers = val.data;
                        }
                    }
                    if ((val = sa.peekValue(1)) != null) {
                        if (val.type == 3 && val.string != null) {
                            targetCode = val.string.toString();
                            if (minCode == null) {
                                minCode = targetCode;
                            }
                        } else {
                            targetVers = val.data;
                        }
                    }
                    sa.recycle();
                    if (minCode != null) {
                        allowedCodename = false;
                        for (String codename : SDK_CODENAMES) {
                            if (!minCode.equals(codename)) continue;
                            allowedCodename = true;
                            break;
                        }
                        if (!allowedCodename) {
                            outError[0] = SDK_CODENAMES.length > 0 ? "Requires development platform " + minCode + " (current platform is any of " + Arrays.toString(SDK_CODENAMES) + ")" : "Requires development platform " + minCode + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                        pkg.applicationInfo.minSdkVersion = 10000;
                    } else {
                        if (minVers > SDK_VERSION) {
                            outError[0] = "Requires newer sdk version #" + minVers + " (current version is #" + SDK_VERSION + ")";
                            this.mParseError = -12;
                            return null;
                        }
                        pkg.applicationInfo.minSdkVersion = minVers;
                    }
                    if (targetCode != null) {
                        allowedCodename = false;
                        for (String codename : SDK_CODENAMES) {
                            if (!targetCode.equals(codename)) continue;
                            allowedCodename = true;
                            break;
                        }
                        if (!allowedCodename) {
                            outError[0] = SDK_CODENAMES.length > 0 ? "Requires development platform " + targetCode + " (current platform is any of " + Arrays.toString(SDK_CODENAMES) + ")" : "Requires development platform " + targetCode + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                        pkg.applicationInfo.targetSdkVersion = 10000;
                    } else {
                        pkg.applicationInfo.targetSdkVersion = targetVers;
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-screens")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestSupportsScreens);
                pkg.applicationInfo.requiresSmallestWidthDp = sa.getInteger(6, 0);
                pkg.applicationInfo.compatibleWidthLimitDp = sa.getInteger(7, 0);
                pkg.applicationInfo.largestWidthLimitDp = sa.getInteger(8, 0);
                supportsSmallScreens = sa.getInteger(1, supportsSmallScreens);
                supportsNormalScreens = sa.getInteger(2, supportsNormalScreens);
                supportsLargeScreens = sa.getInteger(3, supportsLargeScreens);
                supportsXLargeScreens = sa.getInteger(5, supportsXLargeScreens);
                resizeable = sa.getInteger(4, resizeable);
                anyDensity = sa.getInteger(0, anyDensity);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("protected-broadcast")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProtectedBroadcast);
                String name = sa.getNonResourceString(0);
                sa.recycle();
                if (name != null && (flags & 1) != 0) {
                    if (pkg.protectedBroadcasts == null) {
                        pkg.protectedBroadcasts = new ArrayList();
                    }
                    if (!pkg.protectedBroadcasts.contains(name)) {
                        pkg.protectedBroadcasts.add(name.intern());
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("instrumentation")) {
                if (this.parseInstrumentation(pkg, res, parser, outError) != null) continue;
                return null;
            }
            if (tagName.equals("original-package")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
                String orig = sa.getNonConfigurationString(0, 0);
                if (!pkg.packageName.equals(orig)) {
                    if (pkg.mOriginalPackages == null) {
                        pkg.mOriginalPackages = new ArrayList();
                        pkg.mRealPackage = pkg.packageName;
                    }
                    pkg.mOriginalPackages.add(orig);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("adopt-permissions")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
                String name = sa.getNonConfigurationString(0, 0);
                sa.recycle();
                if (name != null) {
                    if (pkg.mAdoptPermissions == null) {
                        pkg.mAdoptPermissions = new ArrayList();
                    }
                    pkg.mAdoptPermissions.add(name);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-gl-texture")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("compatible-screens")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("supports-input")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("eat-comment")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("restrict-update")) {
                if ((flags & 0x40) != 0) {
                    sa = res.obtainAttributes(parser, R.styleable.AndroidManifestRestrictUpdate);
                    String hash = sa.getNonConfigurationString(0, 0);
                    sa.recycle();
                    pkg.restrictUpdateHash = null;
                    if (hash != null) {
                        int hashLength = hash.length();
                        byte[] hashBytes = new byte[hashLength / 2];
                        for (int i = 0; i < hashLength; i += 2) {
                            hashBytes[i / 2] = (byte)((Character.digit(hash.charAt(i), 16) << 4) + Character.digit(hash.charAt(i + 1), 16));
                        }
                        pkg.restrictUpdateHash = hashBytes;
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <manifest>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!foundApp && pkg.instrumentation.size() == 0) {
            outError[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = -109;
        }
        int NP = NEW_PERMISSIONS.length;
        StringBuilder implicitPerms = null;
        for (int ip = 0; ip < NP; ++ip) {
            NewPermissionInfo npi = NEW_PERMISSIONS[ip];
            if (pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) break;
            if (pkg.requestedPermissions.contains(npi.name)) continue;
            if (implicitPerms == null) {
                implicitPerms = new StringBuilder(128);
                implicitPerms.append(pkg.packageName);
                implicitPerms.append(": compat added ");
            } else {
                implicitPerms.append(' ');
            }
            implicitPerms.append(npi.name);
            pkg.requestedPermissions.add(npi.name);
        }
        if (implicitPerms != null) {
            Slog.i("PackageParser", implicitPerms.toString());
        }
        for (SplitPermissionInfo spi : SPLIT_PERMISSIONS) {
            if (pkg.applicationInfo.targetSdkVersion >= spi.targetSdk || !pkg.requestedPermissions.contains(spi.rootPerm)) continue;
            for (int in = 0; in < spi.newPerms.length; ++in) {
                String perm = spi.newPerms[in];
                if (pkg.requestedPermissions.contains(perm)) continue;
                pkg.requestedPermissions.add(perm);
            }
        }
        if (supportsSmallScreens < 0 || supportsSmallScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x200;
        }
        if (supportsNormalScreens != 0) {
            pkg.applicationInfo.flags |= 0x400;
        }
        if (supportsLargeScreens < 0 || supportsLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x800;
        }
        if (supportsXLargeScreens < 0 || supportsXLargeScreens > 0 && pkg.applicationInfo.targetSdkVersion >= 9) {
            pkg.applicationInfo.flags |= 0x80000;
        }
        if (resizeable < 0 || resizeable > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x1000;
        }
        if (anyDensity < 0 || anyDensity > 0 && pkg.applicationInfo.targetSdkVersion >= 4) {
            pkg.applicationInfo.flags |= 0x2000;
        }
        return pkg;
    }

    private final FeatureInfo $$robo$$android_content_pm_PackageParser$parseUsesFeature(Resources res, AttributeSet attrs) {
        FeatureInfo fi = new FeatureInfo();
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
        fi.name = sa.getNonResourceString(0);
        fi.version = sa.getInt(3, 0);
        if (fi.name == null) {
            fi.reqGlEsVersion = sa.getInt(1, 0);
        }
        if (sa.getBoolean(2, true)) {
            fi.flags |= 1;
        }
        sa.recycle();
        return fi;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseUsesPermission(Package pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesPermission);
        String name = sa.getNonResourceString(0);
        int maxSdkVersion = 0;
        TypedValue val = sa.peekValue(1);
        if (val != null && val.type >= 16 && val.type <= 31) {
            maxSdkVersion = val.data;
        }
        sa.recycle();
        if ((maxSdkVersion == 0 || maxSdkVersion >= Build.VERSION.RESOURCES_SDK_INT) && name != null) {
            int index = pkg.requestedPermissions.indexOf(name);
            if (index == -1) {
                pkg.requestedPermissions.add(name.intern());
            } else {
                Slog.w("PackageParser", "Ignoring duplicate uses-permissions/uses-permissions-sdk-m: " + name + " in package: " + pkg.packageName + " at: " + parser.getPositionDescription());
            }
        }
        XmlUtils.skipCurrentTag(parser);
        return true;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildClassName(String pkg, CharSequence clsSeq, String[] outError) {
        if (clsSeq == null || clsSeq.length() <= 0) {
            outError[0] = "Empty class name in package " + pkg;
            return null;
        }
        String cls = clsSeq.toString();
        char c = cls.charAt(0);
        if (c == '.') {
            return (pkg + cls).intern();
        }
        if (cls.indexOf(46) < 0) {
            StringBuilder b = new StringBuilder(pkg);
            b.append('.');
            b.append(cls);
            return b.toString().intern();
        }
        if (c >= 'a' && c <= 'z') {
            return cls.intern();
        }
        outError[0] = "Bad class name " + cls + " in package " + pkg;
        return null;
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildCompoundName(String pkg, CharSequence procSeq, String type, String[] outError) {
        String proc = procSeq.toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                outError[0] = "Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters";
                return null;
            }
            String subName = proc.substring(1);
            String nameError = PackageParser.validateName(subName, false, false);
            if (nameError != null) {
                outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
                return null;
            }
            return (pkg + proc).intern();
        }
        String nameError = PackageParser.validateName(proc, true, false);
        if (nameError != null && !"system".equals(proc)) {
            outError[0] = "Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameError;
            return null;
        }
        return proc.intern();
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildProcessName(String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, String[] outError) {
        if ((flags & 8) != 0 && !"system".equals(procSeq)) {
            return defProc != null ? defProc : pkg;
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.equals(procSeq)) continue;
                return pkg;
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return defProc;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "process", outError);
    }

    private static final String $$robo$$android_content_pm_PackageParser$buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, String[] outError) {
        if (procSeq == null) {
            return defProc;
        }
        if (procSeq.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(pkg, procSeq, "taskAffinity", outError);
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseKeySets(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        int currentKeySetDepth = -1;
        String currentKeySet = null;
        ArrayMap<String, PublicKey> publicKeys = new ArrayMap<String, PublicKey>();
        ArraySet<String> upgradeKeySets = new ArraySet<String>();
        ArrayMap definedKeySets = new ArrayMap();
        ArraySet<String> improperKeySets = new ArraySet<String>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            TypedArray sa;
            if (type == 3) {
                if (parser.getDepth() != currentKeySetDepth) continue;
                currentKeySet = null;
                currentKeySetDepth = -1;
                continue;
            }
            String tagName = parser.getName();
            if (tagName.equals("key-set")) {
                if (currentKeySet != null) {
                    outError[0] = "Improperly nested 'key-set' tag at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    return false;
                }
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestKeySet);
                String keysetName = sa.getNonResourceString(0);
                definedKeySets.put(keysetName, new ArraySet());
                currentKeySet = keysetName;
                currentKeySetDepth = parser.getDepth();
                sa.recycle();
                continue;
            }
            if (tagName.equals("public-key")) {
                if (currentKeySet == null) {
                    outError[0] = "Improperly nested 'key-set' tag at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    return false;
                }
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPublicKey);
                String publicKeyName = sa.getNonResourceString(0);
                String encodedKey = sa.getNonResourceString(1);
                if (encodedKey == null && publicKeys.get(publicKeyName) == null) {
                    outError[0] = "'public-key' " + publicKeyName + " must define a public-key value on first use at " + parser.getPositionDescription();
                    this.mParseError = -108;
                    sa.recycle();
                    return false;
                }
                if (encodedKey != null) {
                    PublicKey currentKey = PackageParser.parsePublicKey(encodedKey);
                    if (currentKey == null) {
                        Slog.w("PackageParser", "No recognized valid key in 'public-key' tag at " + parser.getPositionDescription() + " key-set " + currentKeySet + " will not be added to the package's defined key-sets.");
                        sa.recycle();
                        improperKeySets.add(currentKeySet);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    if (publicKeys.get(publicKeyName) == null || ((PublicKey)publicKeys.get(publicKeyName)).equals(currentKey)) {
                        publicKeys.put(publicKeyName, currentKey);
                    } else {
                        outError[0] = "Value of 'public-key' " + publicKeyName + " conflicts with previously defined value at " + parser.getPositionDescription();
                        this.mParseError = -108;
                        sa.recycle();
                        return false;
                    }
                }
                ((ArraySet)definedKeySets.get(currentKeySet)).add(publicKeyName);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("upgrade-key-set")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUpgradeKeySet);
                String name = sa.getNonResourceString(0);
                upgradeKeySets.add(name);
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <key-sets>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        Set publicKeyNames = publicKeys.keySet();
        if (publicKeyNames.removeAll(definedKeySets.keySet())) {
            outError[0] = "Package" + owner.packageName + " AndroidManifext.xml 'key-set' and 'public-key' names must be distinct.";
            this.mParseError = -108;
            return false;
        }
        owner.mKeySetMapping = new ArrayMap();
        for (Map.Entry e : definedKeySets.entrySet()) {
            String keySetName = (String)e.getKey();
            if (((ArraySet)e.getValue()).size() == 0) {
                Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml 'key-set' " + keySetName + " has no valid associated 'public-key'. Not including in package's defined key-sets.");
                continue;
            }
            if (improperKeySets.contains(keySetName)) {
                Slog.w("PackageParser", "Package" + owner.packageName + " AndroidManifext.xml 'key-set' " + keySetName + " contained improper 'public-key' tags. Not including in package's defined key-sets.");
                continue;
            }
            owner.mKeySetMapping.put(keySetName, new ArraySet());
            for (String s : (ArraySet)e.getValue()) {
                owner.mKeySetMapping.get(keySetName).add((PublicKey)publicKeys.get(s));
            }
        }
        if (!owner.mKeySetMapping.keySet().containsAll(upgradeKeySets)) {
            outError[0] = "Package" + owner.packageName + " AndroidManifext.xml does not define all 'upgrade-key-set's .";
            this.mParseError = -108;
            return false;
        }
        owner.mUpgradeKeySets = upgradeKeySets;
        return true;
    }

    private final PermissionGroup $$robo$$android_content_pm_PackageParser$parsePermissionGroup(Package owner, int flags, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        PermissionGroup perm = new PermissionGroup(owner);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionGroup);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission-group>", sa, 2, 0, 1, 5, 7)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        perm.info.descriptionRes = sa.getResourceId(4, 0);
        perm.info.flags = sa.getInt(6, 0);
        perm.info.priority = sa.getInt(3, 0);
        if (perm.info.priority > 0 && (flags & 1) == 0) {
            perm.info.priority = 0;
        }
        sa.recycle();
        if (!this.parseAllMetaData(res, parser, "<permission-group>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissionGroups.add(perm);
        return perm;
    }

    private final Permission $$robo$$android_content_pm_PackageParser$parsePermission(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermission);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission>", sa, 2, 0, 1, 6, 8)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        perm.info.group = sa.getNonResourceString(4);
        if (perm.info.group != null) {
            perm.info.group = perm.info.group.intern();
        }
        perm.info.descriptionRes = sa.getResourceId(5, 0);
        perm.info.protectionLevel = sa.getInt(3, 0);
        perm.info.flags = sa.getInt(7, 0);
        sa.recycle();
        if (perm.info.protectionLevel == -1) {
            outError[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return null;
        }
        perm.info.protectionLevel = PermissionInfo.fixProtectionLevel(perm.info.protectionLevel);
        if ((perm.info.protectionLevel & 0xFF0) != 0 && (perm.info.protectionLevel & 0xF) != 2) {
            outError[0] = "<permission>  protectionLevel specifies a flag but is not based on signature type";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, "<permission>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissions.add(perm);
        return perm;
    }

    private final Permission $$robo$$android_content_pm_PackageParser$parsePermissionTree(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        Permission perm = new Permission(owner);
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPermissionTree);
        if (!this.parsePackageItemInfo(owner, perm.info, outError, "<permission-tree>", sa, 2, 0, 1, 3, 4)) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        sa.recycle();
        int index = perm.info.name.indexOf(46);
        if (index > 0) {
            index = perm.info.name.indexOf(46, index + 1);
        }
        if (index < 0) {
            outError[0] = "<permission-tree> name has less than three segments: " + perm.info.name;
            this.mParseError = -108;
            return null;
        }
        perm.info.descriptionRes = 0;
        perm.info.protectionLevel = 0;
        perm.tree = true;
        if (!this.parseAllMetaData(res, parser, "<permission-tree>", perm, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.permissions.add(perm);
        return perm;
    }

    private final Instrumentation $$robo$$android_content_pm_PackageParser$parseInstrumentation(Package owner, Resources res, XmlResourceParser parser, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(owner, outError, 2, 0, 1, 6, 7);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = sa;
        Instrumentation a = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (outError[0] != null) {
            sa.recycle();
            this.mParseError = -108;
            return null;
        }
        String str = sa.getNonResourceString(3);
        a.info.targetPackage = str != null ? str.intern() : null;
        a.info.handleProfiling = sa.getBoolean(4, false);
        a.info.functionalTest = sa.getBoolean(5, false);
        sa.recycle();
        if (a.info.targetPackage == null) {
            outError[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(res, parser, "<instrumentation>", a, outError)) {
            this.mParseError = -108;
            return null;
        }
        owner.instrumentation.add(a);
        return a;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseBaseApplication(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String requiredAccountType;
        String restrictedAccountType;
        TypedValue v;
        boolean allowBackup;
        String manageSpaceActivity;
        ApplicationInfo ai = owner.applicationInfo;
        String pkgName = owner.applicationInfo.packageName;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        String name = sa.getNonConfigurationString(3, 0);
        if (name != null) {
            ai.className = PackageParser.buildClassName(pkgName, name, outError);
            if (ai.className == null) {
                sa.recycle();
                this.mParseError = -108;
                return false;
            }
        }
        if ((manageSpaceActivity = sa.getNonConfigurationString(4, 1024)) != null) {
            ai.manageSpaceActivityName = PackageParser.buildClassName(pkgName, manageSpaceActivity, outError);
        }
        if (allowBackup = sa.getBoolean(17, true)) {
            TypedValue v2;
            ai.flags |= 0x8000;
            String backupAgent = sa.getNonConfigurationString(16, 1024);
            if (backupAgent != null) {
                ai.backupAgentName = PackageParser.buildClassName(pkgName, backupAgent, outError);
                if (sa.getBoolean(18, true)) {
                    ai.flags |= 0x10000;
                }
                if (sa.getBoolean(21, false)) {
                    ai.flags |= 0x20000;
                }
                if (sa.getBoolean(32, false)) {
                    ai.flags |= 0x4000000;
                }
                if (sa.getBoolean(40, false)) {
                    ai.privateFlags |= 0x1000;
                }
            }
            if ((v2 = sa.peekValue(35)) != null && (ai.fullBackupContent = v2.resourceId) == 0) {
                int n = ai.fullBackupContent = v2.data == 0 ? -1 : 0;
            }
        }
        if ((v = sa.peekValue(1)) != null && (ai.labelRes = v.resourceId) == 0) {
            ai.nonLocalizedLabel = v.coerceToString();
        }
        ai.icon = sa.getResourceId(2, 0);
        ai.logo = sa.getResourceId(22, 0);
        ai.banner = sa.getResourceId(30, 0);
        ai.theme = sa.getResourceId(0, 0);
        ai.descriptionRes = sa.getResourceId(13, 0);
        if ((flags & 1) != 0 && sa.getBoolean(8, false)) {
            ai.flags |= 8;
        }
        if (sa.getBoolean(27, false)) {
            owner.mRequiredForAllUsers = true;
        }
        if ((restrictedAccountType = sa.getString(28)) != null && restrictedAccountType.length() > 0) {
            owner.mRestrictedAccountType = restrictedAccountType;
        }
        if ((requiredAccountType = sa.getString(29)) != null && requiredAccountType.length() > 0) {
            owner.mRequiredAccountType = requiredAccountType;
        }
        if (sa.getBoolean(10, false)) {
            ai.flags |= 2;
        }
        if (sa.getBoolean(20, false)) {
            ai.flags |= 0x4000;
        }
        owner.baseHardwareAccelerated = sa.getBoolean(23, owner.applicationInfo.targetSdkVersion >= 14);
        if (owner.baseHardwareAccelerated) {
            ai.flags |= 0x20000000;
        }
        if (sa.getBoolean(7, true)) {
            ai.flags |= 4;
        }
        if (sa.getBoolean(14, false)) {
            ai.flags |= 0x20;
        }
        if (sa.getBoolean(5, true)) {
            ai.flags |= 0x40;
        }
        if (owner.parentPackage == null && sa.getBoolean(15, false)) {
            ai.flags |= 0x100;
        }
        if (sa.getBoolean(24, false)) {
            ai.flags |= 0x100000;
        }
        if (sa.getBoolean(36, true)) {
            ai.flags |= 0x8000000;
        }
        if (sa.getBoolean(26, false)) {
            ai.flags |= 0x400000;
        }
        if (sa.getBoolean(33, false)) {
            ai.flags |= Integer.MIN_VALUE;
        }
        if (sa.getBoolean(34, true)) {
            ai.flags |= 0x10000000;
        }
        if (sa.getBoolean(38, false)) {
            ai.privateFlags |= 0x20;
        }
        if (sa.getBoolean(39, false)) {
            ai.privateFlags |= 0x40;
        }
        if (sa.getBoolean(37, owner.applicationInfo.targetSdkVersion >= 24)) {
            ai.privateFlags |= 0x800;
        }
        ai.networkSecurityConfigRes = sa.getResourceId(41, 0);
        String str = sa.getNonConfigurationString(6, 0);
        ai.permission = str != null && str.length() > 0 ? str.intern() : null;
        str = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(12, 1024) : sa.getNonResourceString(12);
        ai.taskAffinity = PackageParser.buildTaskAffinityName(ai.packageName, ai.packageName, str, outError);
        if (outError[0] == null) {
            String pname = owner.applicationInfo.targetSdkVersion >= 8 ? sa.getNonConfigurationString(11, 1024) : sa.getNonResourceString(11);
            ai.processName = PackageParser.buildProcessName(ai.packageName, null, pname, flags, this.mSeparateProcesses, outError);
            ai.enabled = sa.getBoolean(9, true);
            if (sa.getBoolean(31, false)) {
                ai.flags |= 0x2000000;
            }
        }
        ai.uiOptions = sa.getInt(25, 0);
        sa.recycle();
        if (outError[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            String lname;
            Activity a;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, flags, outError, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, flags, outError, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, flags, outError);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, flags, outError);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, flags, outError);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestLibrary);
                lname = sa.getNonResourceString(0);
                sa.recycle();
                if (lname != null && !ArrayUtils.contains(owner.libraryNames, lname = lname.intern())) {
                    owner.libraryNames = ArrayUtils.add(owner.libraryNames, lname);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
                lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                    } else {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        PackageParser.modifySharedLibrariesForBackwardCompatibility(owner);
        owner.applicationInfo.privateFlags = PackageParser.hasDomainURLs(owner) ? (owner.applicationInfo.privateFlags |= 0x10) : (owner.applicationInfo.privateFlags &= 0xFFFFFFEF);
        return true;
    }

    private static final void $$robo$$android_content_pm_PackageParser$modifySharedLibrariesForBackwardCompatibility(Package owner) {
        owner.usesLibraries = ArrayUtils.remove(owner.usesLibraries, "org.apache.http.legacy");
        owner.usesOptionalLibraries = ArrayUtils.remove(owner.usesOptionalLibraries, "org.apache.http.legacy");
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$hasDomainURLs(Package pkg) {
        if (pkg == null || pkg.activities == null) {
            return false;
        }
        ArrayList<Activity> activities = pkg.activities;
        int countActivities = activities.size();
        for (int n = 0; n < countActivities; ++n) {
            Activity activity = activities.get(n);
            ArrayList filters = activity.intents;
            if (filters == null) continue;
            int countFilters = filters.size();
            for (int m = 0; m < countFilters; ++m) {
                ActivityIntentInfo aii = (ActivityIntentInfo)filters.get(m);
                if (!aii.hasAction("android.intent.action.VIEW") || !aii.hasAction("android.intent.action.VIEW") || !aii.hasDataScheme("http") && !aii.hasDataScheme("https")) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseSplitApplication(Package owner, Resources res, XmlResourceParser parser, int flags, int splitIndex, String[] outError) throws XmlPullParserException, IOException {
        int type;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        if (sa.getBoolean(7, true)) {
            int n = splitIndex;
            owner.splitFlags[n] = owner.splitFlags[n] | 4;
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            Activity a;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("activity")) {
                a = this.parseActivity(owner, res, parser, flags, outError, false, owner.baseHardwareAccelerated);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (tagName.equals("receiver")) {
                a = this.parseActivity(owner, res, parser, flags, outError, true, false);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.receivers.add(a);
                continue;
            }
            if (tagName.equals("service")) {
                Service s = this.parseService(owner, res, parser, flags, outError);
                if (s == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.services.add(s);
                continue;
            }
            if (tagName.equals("provider")) {
                Provider p = this.parseProvider(owner, res, parser, flags, outError);
                if (p == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.providers.add(p);
                continue;
            }
            if (tagName.equals("activity-alias")) {
                a = this.parseActivityAlias(owner, res, parser, flags, outError);
                if (a == null) {
                    this.mParseError = -108;
                    return false;
                }
                owner.activities.add(a);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                owner.mAppMetaData = this.parseMetaData(res, parser, owner.mAppMetaData, outError);
                if (owner.mAppMetaData != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (tagName.equals("uses-library")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
                String lname = sa.getNonResourceString(0);
                boolean req = sa.getBoolean(1, true);
                sa.recycle();
                if (lname != null) {
                    lname = lname.intern();
                    if (req) {
                        owner.usesLibraries = ArrayUtils.add(owner.usesLibraries, lname);
                        owner.usesOptionalLibraries = ArrayUtils.remove(owner.usesOptionalLibraries, lname);
                    } else if (!ArrayUtils.contains(owner.usesLibraries, lname)) {
                        owner.usesOptionalLibraries = ArrayUtils.add(owner.usesOptionalLibraries, lname);
                    }
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("uses-package")) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <application>: " + tagName + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parsePackageItemInfo(Package owner, PackageItemInfo outInfo, String[] outError, String tag, TypedArray sa, int nameRes, int labelRes, int iconRes, int logoRes, int bannerRes) {
        TypedValue v;
        int bannerVal;
        int logoVal;
        String name = sa.getNonConfigurationString(nameRes, 0);
        if (name == null) {
            outError[0] = tag + " does not specify android:name";
            return false;
        }
        outInfo.name = PackageParser.buildClassName(owner.applicationInfo.packageName, name, outError);
        if (outInfo.name == null) {
            return false;
        }
        int iconVal = sa.getResourceId(iconRes, 0);
        if (iconVal != 0) {
            outInfo.icon = iconVal;
            outInfo.nonLocalizedLabel = null;
        }
        if ((logoVal = sa.getResourceId(logoRes, 0)) != 0) {
            outInfo.logo = logoVal;
        }
        if ((bannerVal = sa.getResourceId(bannerRes, 0)) != 0) {
            outInfo.banner = bannerVal;
        }
        if ((v = sa.peekValue(labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.packageName = owner.packageName;
        return true;
    }

    private final Activity $$robo$$android_content_pm_PackageParser$parseActivity(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError, boolean receiver, boolean hardwareAccelerated) throws XmlPullParserException, IOException {
        int type;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivity);
        if (this.mParseActivityArgs == null) {
            this.mParseActivityArgs = new ParseComponentArgs(owner, outError, 3, 1, 2, 23, 30, this.mSeparateProcesses, 7, 17, 5);
        }
        this.mParseActivityArgs.tag = receiver ? "<receiver>" : "<activity>";
        this.mParseActivityArgs.sa = sa;
        this.mParseActivityArgs.flags = flags;
        Activity a = new Activity(this.mParseActivityArgs, new ActivityInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(6);
        if (setExported) {
            a.info.exported = sa.getBoolean(6, false);
        }
        a.info.theme = sa.getResourceId(0, 0);
        a.info.uiOptions = sa.getInt(26, a.info.applicationInfo.uiOptions);
        String parentName = sa.getNonConfigurationString(27, 1024);
        if (parentName != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e("PackageParser", "Activity " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        a.info.permission = (str = sa.getNonConfigurationString(4, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(8, 1024);
        a.info.taskAffinity = PackageParser.buildTaskAffinityName(owner.applicationInfo.packageName, owner.applicationInfo.taskAffinity, str, outError);
        a.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            a.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            a.info.flags |= 2;
        }
        if (sa.getBoolean(11, false)) {
            a.info.flags |= 4;
        }
        if (sa.getBoolean(21, false)) {
            a.info.flags |= 0x80;
        }
        if (sa.getBoolean(18, false)) {
            a.info.flags |= 8;
        }
        if (sa.getBoolean(12, false)) {
            a.info.flags |= 0x10;
        }
        if (sa.getBoolean(13, false)) {
            a.info.flags |= 0x20;
        }
        if (sa.getBoolean(19, (owner.applicationInfo.flags & 0x20) != 0)) {
            a.info.flags |= 0x40;
        }
        if (sa.getBoolean(22, false)) {
            a.info.flags |= 0x100;
        }
        if (sa.getBoolean(29, false) || sa.getBoolean(39, false)) {
            a.info.flags |= 0x400;
        }
        if (sa.getBoolean(24, false)) {
            a.info.flags |= 0x800;
        }
        if (sa.getBoolean(44, false)) {
            a.info.flags |= 0x20000000;
        }
        if (!receiver) {
            if (sa.getBoolean(25, hardwareAccelerated)) {
                a.info.flags |= 0x200;
            }
            a.info.launchMode = sa.getInt(14, 0);
            a.info.documentLaunchMode = sa.getInt(33, 0);
            a.info.maxRecents = sa.getInt(34, ActivityManager.getDefaultAppRecentsLimitStatic());
            a.info.configChanges = sa.getInt(16, 0);
            a.info.softInputMode = sa.getInt(20, 0);
            a.info.persistableMode = sa.getInteger(32, 0);
            if (sa.getBoolean(31, false)) {
                a.info.flags |= Integer.MIN_VALUE;
            }
            if (sa.getBoolean(35, false)) {
                a.info.flags |= 0x2000;
            }
            if (sa.getBoolean(36, false)) {
                a.info.flags |= 0x1000;
            }
            if (sa.getBoolean(37, false)) {
                a.info.flags |= 0x4000;
            }
            a.info.screenOrientation = sa.getInt(15, -1);
            a.info.resizeMode = 0;
            boolean appDefault = (owner.applicationInfo.privateFlags & 0x800) != 0;
            boolean resizeableSetExplicitly = sa.hasValue(40);
            boolean resizeable = sa.getBoolean(40, appDefault);
            if (resizeable) {
                a.info.resizeMode = sa.getBoolean(41, false) ? 3 : 2;
            } else if (owner.applicationInfo.targetSdkVersion >= 24 || resizeableSetExplicitly) {
                a.info.resizeMode = 0;
            } else if (!a.info.isFixedOrientation() && (a.info.flags & 0x800) == 0) {
                a.info.resizeMode = 4;
            }
            if (sa.getBoolean(45, false)) {
                a.info.flags |= 0x40000;
            }
            a.info.lockTaskLaunchMode = sa.getInt(38, 0);
            a.info.encryptionAware = a.info.directBootAware = sa.getBoolean(42, false);
            a.info.requestedVrComponent = sa.getString(43);
        } else {
            a.info.launchMode = 0;
            a.info.configChanges = 0;
            if (sa.getBoolean(28, false)) {
                a.info.flags |= 0x40000000;
                if (a.info.exported && (flags & 0x80) == 0) {
                    Slog.w("PackageParser", "Activity exported request ignored due to singleUser: " + a.className + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    a.info.exported = false;
                    setExported = true;
                }
            }
            a.info.encryptionAware = a.info.directBootAware = sa.getBoolean(42, false);
        }
        if (a.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        sa.recycle();
        if (receiver && (owner.applicationInfo.privateFlags & 2) != 0 && a.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, true, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    continue;
                }
                a.intents.add(intent);
                continue;
            }
            if (!receiver && parser.getName().equals("preferred")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, false, false, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in preferred at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    continue;
                }
                if (owner.preferredActivityFilters == null) {
                    owner.preferredActivityFilters = new ArrayList();
                }
                owner.preferredActivityFilters.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            if (!receiver && parser.getName().equals("layout")) {
                this.parseLayout(res, parser, a);
                continue;
            }
            Slog.w("PackageParser", "Problem in package " + this.mArchiveSourcePath + ":");
            if (receiver) {
                Slog.w("PackageParser", "Unknown element under <receiver>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            } else {
                Slog.w("PackageParser", "Unknown element under <activity>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private final void $$robo$$android_content_pm_PackageParser$parseLayout(Resources res, AttributeSet attrs, Activity a) {
        TypedArray sw = res.obtainAttributes(attrs, R.styleable.AndroidManifestLayout);
        int width = -1;
        float widthFraction = -1.0f;
        int height = -1;
        float heightFraction = -1.0f;
        int widthType = sw.getType(3);
        if (widthType == 6) {
            widthFraction = sw.getFraction(3, 1, 1, -1.0f);
        } else if (widthType == 5) {
            width = sw.getDimensionPixelSize(3, -1);
        }
        int heightType = sw.getType(4);
        if (heightType == 6) {
            heightFraction = sw.getFraction(4, 1, 1, -1.0f);
        } else if (heightType == 5) {
            height = sw.getDimensionPixelSize(4, -1);
        }
        int gravity = sw.getInt(0, 17);
        int minWidth = sw.getDimensionPixelSize(1, -1);
        int minHeight = sw.getDimensionPixelSize(2, -1);
        sw.recycle();
        a.info.windowLayout = new ActivityInfo.WindowLayout(width, widthFraction, height, heightFraction, gravity, minWidth, minHeight);
    }

    private final Activity $$robo$$android_content_pm_PackageParser$parseActivityAlias(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String parentName;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivityAlias);
        String targetActivity = sa.getNonConfigurationString(7, 1024);
        if (targetActivity == null) {
            outError[0] = "<activity-alias> does not specify android:targetActivity";
            sa.recycle();
            return null;
        }
        if ((targetActivity = PackageParser.buildClassName(owner.applicationInfo.packageName, targetActivity, outError)) == null) {
            sa.recycle();
            return null;
        }
        if (this.mParseActivityAliasArgs == null) {
            this.mParseActivityAliasArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 8, 10, this.mSeparateProcesses, 0, 6, 4);
            this.mParseActivityAliasArgs.tag = "<activity-alias>";
        }
        this.mParseActivityAliasArgs.sa = sa;
        this.mParseActivityAliasArgs.flags = flags;
        Activity target = null;
        int NA = owner.activities.size();
        for (int i = 0; i < NA; ++i) {
            Activity t = owner.activities.get(i);
            if (!targetActivity.equals(t.info.name)) continue;
            target = t;
            break;
        }
        if (target == null) {
            outError[0] = "<activity-alias> target activity " + targetActivity + " not found in manifest";
            sa.recycle();
            return null;
        }
        ActivityInfo info = new ActivityInfo();
        info.targetActivity = targetActivity;
        info.configChanges = target.info.configChanges;
        info.flags = target.info.flags;
        info.icon = target.info.icon;
        info.logo = target.info.logo;
        info.banner = target.info.banner;
        info.labelRes = target.info.labelRes;
        info.nonLocalizedLabel = target.info.nonLocalizedLabel;
        info.launchMode = target.info.launchMode;
        info.lockTaskLaunchMode = target.info.lockTaskLaunchMode;
        info.processName = target.info.processName;
        if (info.descriptionRes == 0) {
            info.descriptionRes = target.info.descriptionRes;
        }
        info.screenOrientation = target.info.screenOrientation;
        info.taskAffinity = target.info.taskAffinity;
        info.theme = target.info.theme;
        info.softInputMode = target.info.softInputMode;
        info.uiOptions = target.info.uiOptions;
        info.parentActivityName = target.info.parentActivityName;
        info.maxRecents = target.info.maxRecents;
        info.windowLayout = target.info.windowLayout;
        info.resizeMode = target.info.resizeMode;
        info.encryptionAware = info.directBootAware = target.info.directBootAware;
        Activity a = new Activity(this.mParseActivityAliasArgs, info);
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            a.info.exported = sa.getBoolean(5, false);
        }
        if ((str = sa.getNonConfigurationString(3, 0)) != null) {
            String string2 = a.info.permission = str.length() > 0 ? str.toString().intern() : null;
        }
        if ((parentName = sa.getNonConfigurationString(9, 1024)) != null) {
            String parentClassName = PackageParser.buildClassName(a.info.packageName, parentName, outError);
            if (outError[0] == null) {
                a.info.parentActivityName = parentClassName;
            } else {
                Log.e("PackageParser", "Activity alias " + a.info.name + " specified invalid parentActivityName " + parentName);
                outError[0] = null;
            }
        }
        sa.recycle();
        if (outError[0] != null) {
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ActivityIntentInfo intent = new ActivityIntentInfo(a);
                if (!this.parseIntent(res, parser, true, true, intent, outError)) {
                    return null;
                }
                if (intent.countActions() == 0) {
                    Slog.w("PackageParser", "No actions in intent filter at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    continue;
                }
                a.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                a.metaData = this.parseMetaData(res, parser, a.metaData, outError);
                if (a.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <activity-alias>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            a.info.exported = a.intents.size() > 0;
        }
        return a;
    }

    private final Provider $$robo$$android_content_pm_PackageParser$parseProvider(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProvider);
        if (this.mParseProviderArgs == null) {
            this.mParseProviderArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 15, 17, this.mSeparateProcesses, 8, 14, 6);
            this.mParseProviderArgs.tag = "<provider>";
        }
        this.mParseProviderArgs.sa = sa;
        this.mParseProviderArgs.flags = flags;
        Provider p = new Provider(this.mParseProviderArgs, new ProviderInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean providerExportedDefault = false;
        if (owner.applicationInfo.targetSdkVersion < 17) {
            providerExportedDefault = true;
        }
        p.info.exported = sa.getBoolean(7, providerExportedDefault);
        String cpname = sa.getNonConfigurationString(10, 0);
        p.info.isSyncable = sa.getBoolean(11, false);
        String permission2 = sa.getNonConfigurationString(3, 0);
        String str = sa.getNonConfigurationString(4, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.readPermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        str = sa.getNonConfigurationString(5, 0);
        if (str == null) {
            str = permission2;
        }
        p.info.writePermission = str == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        p.info.grantUriPermissions = sa.getBoolean(13, false);
        p.info.multiprocess = sa.getBoolean(9, false);
        p.info.initOrder = sa.getInt(12, 0);
        p.info.flags = 0;
        if (sa.getBoolean(16, false)) {
            p.info.flags |= 0x40000000;
            if (p.info.exported && (flags & 0x80) == 0) {
                Slog.w("PackageParser", "Provider exported request ignored due to singleUser: " + p.className + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                p.info.exported = false;
            }
        }
        p.info.encryptionAware = p.info.directBootAware = sa.getBoolean(18, false);
        if (p.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        sa.recycle();
        if ((owner.applicationInfo.privateFlags & 2) != 0 && p.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (cpname == null) {
            outError[0] = "<provider> does not include authorities attribute";
            return null;
        }
        if (cpname.length() <= 0) {
            outError[0] = "<provider> has empty authorities attribute";
            return null;
        }
        p.info.authority = cpname.intern();
        if (!this.parseProviderTags(res, parser, p, outError)) {
            return null;
        }
        return p;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseProviderTags(Resources res, XmlResourceParser parser, Provider outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            PatternMatcher pa;
            TypedArray sa;
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ProviderIntentInfo intent = new ProviderIntentInfo(outInfo);
                if (!this.parseIntent(res, parser, true, false, intent, outError)) {
                    return false;
                }
                outInfo.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            if (parser.getName().equals("grant-uri-permission")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestGrantUriPermission);
                pa = null;
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    pa = new PatternMatcher(str, 0);
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    pa = new PatternMatcher(str, 1);
                }
                if ((str = sa.getNonConfigurationString(2, 0)) != null) {
                    pa = new PatternMatcher(str, 2);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.uriPermissionPatterns == null) {
                        outInfo.info.uriPermissionPatterns = new PatternMatcher[1];
                        outInfo.info.uriPermissionPatterns[0] = pa;
                    } else {
                        int N = outInfo.info.uriPermissionPatterns.length;
                        PatternMatcher[] newp = new PatternMatcher[N + 1];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)outInfo.info.uriPermissionPatterns, (int)0, (Object)newp, (int)0, (int)N);
                        newp[N] = pa;
                        outInfo.info.uriPermissionPatterns = newp;
                    }
                } else {
                    Slog.w("PackageParser", "Unknown element under <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                outInfo.info.grantUriPermissions = true;
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals("path-permission")) {
                String writePermission;
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPathPermission);
                pa = null;
                String permission2 = sa.getNonConfigurationString(0, 0);
                String readPermission = sa.getNonConfigurationString(1, 0);
                if (readPermission == null) {
                    readPermission = permission2;
                }
                if ((writePermission = sa.getNonConfigurationString(2, 0)) == null) {
                    writePermission = permission2;
                }
                boolean havePerm = false;
                if (readPermission != null) {
                    readPermission = readPermission.intern();
                    havePerm = true;
                }
                if (writePermission != null) {
                    writePermission = writePermission.intern();
                    havePerm = true;
                }
                if (!havePerm) {
                    Slog.w("PackageParser", "No readPermission or writePermssion for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String path = sa.getNonConfigurationString(3, 0);
                if (path != null) {
                    pa = new PathPermission(path, 0, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(4, 0)) != null) {
                    pa = new PathPermission(path, 1, readPermission, writePermission);
                }
                if ((path = sa.getNonConfigurationString(5, 0)) != null) {
                    pa = new PathPermission(path, 2, readPermission, writePermission);
                }
                sa.recycle();
                if (pa != null) {
                    if (outInfo.info.pathPermissions == null) {
                        outInfo.info.pathPermissions = new PathPermission[1];
                        outInfo.info.pathPermissions[0] = pa;
                    } else {
                        int N = outInfo.info.pathPermissions.length;
                        PathPermission[] newp = new PathPermission[N + 1];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)outInfo.info.pathPermissions, (int)0, (Object)newp, (int)0, (int)N);
                        newp[N] = pa;
                        outInfo.info.pathPermissions = newp;
                    }
                } else {
                    Slog.w("PackageParser", "No path, pathPrefix, or pathPattern for <path-permission>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <provider>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final Service $$robo$$android_content_pm_PackageParser$parseService(Package owner, Resources res, XmlResourceParser parser, int flags, String[] outError) throws XmlPullParserException, IOException {
        int type;
        String str;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestService);
        if (this.mParseServiceArgs == null) {
            this.mParseServiceArgs = new ParseComponentArgs(owner, outError, 2, 0, 1, 8, 12, this.mSeparateProcesses, 6, 7, 4);
            this.mParseServiceArgs.tag = "<service>";
        }
        this.mParseServiceArgs.sa = sa;
        this.mParseServiceArgs.flags = flags;
        Service s = new Service(this.mParseServiceArgs, new ServiceInfo());
        if (outError[0] != null) {
            sa.recycle();
            return null;
        }
        boolean setExported = sa.hasValue(5);
        if (setExported) {
            s.info.exported = sa.getBoolean(5, false);
        }
        s.info.permission = (str = sa.getNonConfigurationString(3, 0)) == null ? owner.applicationInfo.permission : (str.length() > 0 ? str.toString().intern() : null);
        s.info.flags = 0;
        if (sa.getBoolean(9, false)) {
            s.info.flags |= 1;
        }
        if (sa.getBoolean(10, false)) {
            s.info.flags |= 2;
        }
        if (sa.getBoolean(14, false)) {
            s.info.flags |= 4;
        }
        if (sa.getBoolean(11, false)) {
            s.info.flags |= 0x40000000;
            if (s.info.exported && (flags & 0x80) == 0) {
                Slog.w("PackageParser", "Service exported request ignored due to singleUser: " + s.className + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                s.info.exported = false;
                setExported = true;
            }
        }
        s.info.encryptionAware = s.info.directBootAware = sa.getBoolean(13, false);
        if (s.info.directBootAware) {
            owner.applicationInfo.privateFlags |= 0x100;
        }
        sa.recycle();
        if ((owner.applicationInfo.privateFlags & 2) != 0 && s.info.processName == owner.packageName) {
            outError[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("intent-filter")) {
                ServiceIntentInfo intent = new ServiceIntentInfo(s);
                if (!this.parseIntent(res, parser, true, false, intent, outError)) {
                    return null;
                }
                s.intents.add(intent);
                continue;
            }
            if (parser.getName().equals("meta-data")) {
                s.metaData = this.parseMetaData(res, parser, s.metaData, outError);
                if (s.metaData != null) continue;
                return null;
            }
            Slog.w("PackageParser", "Unknown element under <service>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        if (!setExported) {
            s.info.exported = s.intents.size() > 0;
        }
        return s;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseAllMetaData(Resources res, XmlResourceParser parser, String tag, Component<?> outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (parser.getName().equals("meta-data")) {
                outInfo.metaData = this.parseMetaData(res, parser, outInfo.metaData, outError);
                if (outInfo.metaData != null) continue;
                return false;
            }
            Slog.w("PackageParser", "Unknown element under " + tag + ": " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        return true;
    }

    private final Bundle $$robo$$android_content_pm_PackageParser$parseMetaData(Resources res, XmlResourceParser parser, Bundle data, String[] outError) throws XmlPullParserException, IOException {
        String name;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestMetaData);
        if (data == null) {
            data = new Bundle();
        }
        if ((name = sa.getNonConfigurationString(0, 0)) == null) {
            outError[0] = "<meta-data> requires an android:name attribute";
            sa.recycle();
            return null;
        }
        name = name.intern();
        TypedValue v = sa.peekValue(2);
        if (v != null && v.resourceId != 0) {
            data.putInt(name, v.resourceId);
        } else {
            v = sa.peekValue(1);
            if (v != null) {
                if (v.type == 3) {
                    CharSequence cs = v.coerceToString();
                    data.putString(name, cs != null ? cs.toString().intern() : null);
                } else if (v.type == 18) {
                    data.putBoolean(name, v.data != 0);
                } else if (v.type >= 16 && v.type <= 31) {
                    data.putInt(name, v.data);
                } else if (v.type == 4) {
                    data.putFloat(name, v.getFloat());
                } else {
                    Slog.w("PackageParser", "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
                }
            } else {
                outError[0] = "<meta-data> requires an android:value or android:resource attribute";
                data = null;
            }
        }
        sa.recycle();
        XmlUtils.skipCurrentTag(parser);
        return data;
    }

    private static final VerifierInfo $$robo$$android_content_pm_PackageParser$parseVerifier(Resources res, XmlPullParser parser, AttributeSet attrs, int flags) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPackageVerifier);
        String packageName = sa.getNonResourceString(0);
        String encodedPublicKey = sa.getNonResourceString(1);
        sa.recycle();
        if (packageName == null || packageName.length() == 0) {
            Slog.i("PackageParser", "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i("PackageParser", "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }

    private static final PublicKey $$robo$$android_content_pm_PackageParser$parsePublicKey(String encodedPublicKey) {
        X509EncodedKeySpec keySpec;
        if (encodedPublicKey == null) {
            Slog.w("PackageParser", "Could not parse null public key");
            return null;
        }
        try {
            byte[] encoded = Base64.decode(encodedPublicKey, 0);
            keySpec = new X509EncodedKeySpec(encoded);
        }
        catch (IllegalArgumentException e) {
            Slog.w("PackageParser", "Could not parse verifier public key; invalid Base64");
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf("PackageParser", "Could not parse public key: RSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf("PackageParser", "Could not parse public key: EC KeyFactory not included in build");
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            Slog.wtf("PackageParser", "Could not parse public key: DSA KeyFactory not included in build");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    private final boolean $$robo$$android_content_pm_PackageParser$parseIntent(Resources res, XmlResourceParser parser, boolean allowGlobs, boolean allowAutoVerify, IntentInfo outInfo, String[] outError) throws XmlPullParserException, IOException {
        int type;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestIntentFilter);
        int priority = sa.getInt(2, 0);
        outInfo.setPriority(priority);
        TypedValue v = sa.peekValue(0);
        if (v != null && (outInfo.labelRes = v.resourceId) == 0) {
            outInfo.nonLocalizedLabel = v.coerceToString();
        }
        outInfo.icon = sa.getResourceId(1, 0);
        outInfo.logo = sa.getResourceId(3, 0);
        outInfo.banner = sa.getResourceId(4, 0);
        if (allowAutoVerify) {
            outInfo.setAutoVerify(sa.getBoolean(5, false));
        }
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String value;
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("action")) {
                value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addAction(value);
                continue;
            }
            if (nodeName.equals("category")) {
                value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (value == null || value == "") {
                    outError[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(parser);
                outInfo.addCategory(value);
                continue;
            }
            if (nodeName.equals("data")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestData);
                String str = sa.getNonConfigurationString(0, 0);
                if (str != null) {
                    try {
                        outInfo.addDataType(str);
                    }
                    catch (IntentFilter.MalformedMimeTypeException e) {
                        outError[0] = e.toString();
                        sa.recycle();
                        return false;
                    }
                }
                if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                    outInfo.addDataScheme(str);
                }
                if ((str = sa.getNonConfigurationString(7, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 0);
                }
                if ((str = sa.getNonConfigurationString(8, 0)) != null) {
                    outInfo.addDataSchemeSpecificPart(str, 1);
                }
                if ((str = sa.getNonConfigurationString(9, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "sspPattern not allowed here; ssp must be literal";
                        return false;
                    }
                    outInfo.addDataSchemeSpecificPart(str, 2);
                }
                String host = sa.getNonConfigurationString(2, 0);
                String port = sa.getNonConfigurationString(3, 0);
                if (host != null) {
                    outInfo.addDataAuthority(host, port);
                }
                if ((str = sa.getNonConfigurationString(4, 0)) != null) {
                    outInfo.addDataPath(str, 0);
                }
                if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                    outInfo.addDataPath(str, 1);
                }
                if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                    if (!allowGlobs) {
                        outError[0] = "pathPattern not allowed here; path must be literal";
                        return false;
                    }
                    outInfo.addDataPath(str, 2);
                }
                sa.recycle();
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("PackageParser", "Unknown element under <intent-filter>: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
        }
        outInfo.hasDefault = outInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    private static final boolean $$robo$$android_content_pm_PackageParser$copyNeeded(int flags, Package p, PackageUserState state, Bundle metaData, int userId) {
        boolean suspended;
        if (userId != 0) {
            return true;
        }
        if (state.enabled != 0) {
            boolean enabled;
            boolean bl = enabled = state.enabled == 1;
            if (p.applicationInfo.enabled != enabled) {
                return true;
            }
        }
        boolean bl = suspended = (p.applicationInfo.flags & 0x40000000) != 0;
        if (state.suspended != suspended) {
            return true;
        }
        if (!state.installed || state.hidden) {
            return true;
        }
        if (state.stopped) {
            return true;
        }
        if ((flags & 0x80) != 0 && (metaData != null || p.mAppMetaData != null)) {
            return true;
        }
        return (flags & 0x400) != 0 && p.usesLibraryFiles != null;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(Package p, int flags, PackageUserState state) {
        return PackageParser.generateApplicationInfo(p, flags, state, UserHandle.getCallingUserId());
    }

    private static final void $$robo$$android_content_pm_PackageParser$updateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state) {
        if (!sCompatibilityModeEnabled) {
            ai.disableCompatibilityMode();
        }
        ai.flags = state.installed ? (ai.flags |= 0x800000) : (ai.flags &= 0xFF7FFFFF);
        ai.flags = state.suspended ? (ai.flags |= 0x40000000) : (ai.flags &= 0xBFFFFFFF);
        ai.privateFlags = state.hidden ? (ai.privateFlags |= 1) : (ai.privateFlags &= 0xFFFFFFFE);
        if (state.enabled == 1) {
            ai.enabled = true;
        } else if (state.enabled == 4) {
            ai.enabled = (flags & 0x8000) != 0;
        } else if (state.enabled == 2 || state.enabled == 3) {
            ai.enabled = false;
        }
        ai.enabledSetting = state.enabled;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(Package p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state) || !p.isMatch(flags)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p, state, null, userId) || (flags & 0x8000) != 0 && state.enabled == 4)) {
            PackageParser.updateApplicationInfo(p.applicationInfo, flags, state);
            return p.applicationInfo;
        }
        ApplicationInfo ai = new ApplicationInfo(p.applicationInfo);
        ai.initForUser(userId);
        if ((flags & 0x80) != 0) {
            ai.metaData = p.mAppMetaData;
        }
        if ((flags & 0x400) != 0) {
            ai.sharedLibraryFiles = p.usesLibraryFiles;
        }
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    private static final ApplicationInfo $$robo$$android_content_pm_PackageParser$generateApplicationInfo(ApplicationInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        ai = new ApplicationInfo(ai);
        ai.initForUser(userId);
        ai.flags = state.stopped ? (ai.flags |= 0x200000) : (ai.flags &= 0xFFDFFFFF);
        PackageParser.updateApplicationInfo(ai, flags, state);
        return ai;
    }

    private static final PermissionInfo $$robo$$android_content_pm_PackageParser$generatePermissionInfo(Permission p, int flags) {
        if (p == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return p.info;
        }
        PermissionInfo pi = new PermissionInfo(p.info);
        pi.metaData = p.metaData;
        return pi;
    }

    private static final PermissionGroupInfo $$robo$$android_content_pm_PackageParser$generatePermissionGroupInfo(PermissionGroup pg, int flags) {
        if (pg == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return pg.info;
        }
        PermissionGroupInfo pgi = new PermissionGroupInfo(pg.info);
        pgi.metaData = pg.metaData;
        return pgi;
    }

    private static final ActivityInfo $$robo$$android_content_pm_PackageParser$generateActivityInfo(Activity a, int flags, PackageUserState state, int userId) {
        if (a == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, a.owner, state, a.metaData, userId)) {
            return a.info;
        }
        ActivityInfo ai = new ActivityInfo(a.info);
        ai.metaData = a.metaData;
        ai.applicationInfo = PackageParser.generateApplicationInfo(a.owner, flags, state, userId);
        return ai;
    }

    private static final ActivityInfo $$robo$$android_content_pm_PackageParser$generateActivityInfo(ActivityInfo ai, int flags, PackageUserState state, int userId) {
        if (ai == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        ai = new ActivityInfo(ai);
        ai.applicationInfo = PackageParser.generateApplicationInfo(ai.applicationInfo, flags, state, userId);
        return ai;
    }

    private static final ServiceInfo $$robo$$android_content_pm_PackageParser$generateServiceInfo(Service s, int flags, PackageUserState state, int userId) {
        if (s == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!PackageParser.copyNeeded(flags, s.owner, state, s.metaData, userId)) {
            return s.info;
        }
        ServiceInfo si = new ServiceInfo(s.info);
        si.metaData = s.metaData;
        si.applicationInfo = PackageParser.generateApplicationInfo(s.owner, flags, state, userId);
        return si;
    }

    private static final ProviderInfo $$robo$$android_content_pm_PackageParser$generateProviderInfo(Provider p, int flags, PackageUserState state, int userId) {
        if (p == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(flags, state)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(flags, p.owner, state, p.metaData, userId) || (flags & 0x800) == 0 && p.info.uriPermissionPatterns != null)) {
            return p.info;
        }
        ProviderInfo pi = new ProviderInfo(p.info);
        pi.metaData = p.metaData;
        if ((flags & 0x800) == 0) {
            pi.uriPermissionPatterns = null;
        }
        pi.applicationInfo = PackageParser.generateApplicationInfo(p.owner, flags, state, userId);
        return pi;
    }

    private static final InstrumentationInfo $$robo$$android_content_pm_PackageParser$generateInstrumentationInfo(Instrumentation i, int flags) {
        if (i == null) {
            return null;
        }
        if ((flags & 0x80) == 0) {
            return i.info;
        }
        InstrumentationInfo ii = new InstrumentationInfo(i.info);
        ii.metaData = i.metaData;
        return ii;
    }

    private static final void $$robo$$android_content_pm_PackageParser$setCompatibilityModeEnabled(boolean compatibilityModeEnabled) {
        sCompatibilityModeEnabled = compatibilityModeEnabled;
    }

    private static final long $$robo$$android_content_pm_PackageParser$readFullyIgnoringContents(InputStream in) throws IOException {
        byte[] buffer = sBuffer.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[4096];
        }
        int n = 0;
        int count = 0;
        while ((n = in.read(buffer, 0, buffer.length)) != -1) {
            count += n;
        }
        sBuffer.set(buffer);
        return count;
    }

    private static final void $$robo$$android_content_pm_PackageParser$closeQuietly(StrictJarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void __staticInitializer__() {
        CHILD_PACKAGE_TAGS = new ArraySet<String>();
        CHILD_PACKAGE_TAGS.add("application");
        CHILD_PACKAGE_TAGS.add("uses-permission");
        CHILD_PACKAGE_TAGS.add("uses-permission-sdk-m");
        CHILD_PACKAGE_TAGS.add("uses-permission-sdk-23");
        CHILD_PACKAGE_TAGS.add("uses-configuration");
        CHILD_PACKAGE_TAGS.add("uses-feature");
        CHILD_PACKAGE_TAGS.add("feature-group");
        CHILD_PACKAGE_TAGS.add("uses-sdk");
        CHILD_PACKAGE_TAGS.add("supports-screens");
        CHILD_PACKAGE_TAGS.add("instrumentation");
        CHILD_PACKAGE_TAGS.add("uses-gl-texture");
        CHILD_PACKAGE_TAGS.add("compatible-screens");
        CHILD_PACKAGE_TAGS.add("supports-input");
        CHILD_PACKAGE_TAGS.add("eat-comment");
        NEW_PERMISSIONS = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
        SPLIT_PERMISSIONS = new SplitPermissionInfo[]{new SplitPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 10001), new SplitPermissionInfo("android.permission.READ_CONTACTS", new String[]{"android.permission.READ_CALL_LOG"}, 16), new SplitPermissionInfo("android.permission.WRITE_CONTACTS", new String[]{"android.permission.WRITE_CALL_LOG"}, 16)};
        SDK_VERSION = Build.VERSION.SDK_INT;
        SDK_CODENAMES = Build.VERSION.ACTIVE_CODENAMES;
        sCompatibilityModeEnabled = true;
        sSplitNameComparator = new SplitNameComparator();
        sBuffer = new AtomicReference();
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_PackageParser$__constructor__();
    }

    public PackageParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser$__constructor__(), 0, this);
    }

    public void setSeparateProcesses(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSeparateProcesses", $$robo$$android_content_pm_PackageParser$setSeparateProcesses(java.lang.String[] ), 0, this, stringArray);
    }

    public void setOnlyCoreApps(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOnlyCoreApps", $$robo$$android_content_pm_PackageParser$setOnlyCoreApps(boolean ), 0, this, bl);
    }

    public void setDisplayMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setDisplayMetrics", $$robo$$android_content_pm_PackageParser$setDisplayMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public static boolean isApkFile(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApkFile", $$robo$$android_content_pm_PackageParser$isApkFile(java.io.File ), 0, (File)file);
    }

    private static boolean isApkPath(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApkPath", $$robo$$android_content_pm_PackageParser$isApkPath(java.lang.String ), 0, (String)string2);
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, Set<String> set, PackageUserState packageUserState) {
        return InvokeDynamicSupport.bootstrapStatic("generatePackageInfo", $$robo$$android_content_pm_PackageParser$generatePackageInfo(android.content.pm.PackageParser$Package int[] int long long java.util.Set<java.lang.String> android.content.pm.PackageUserState ), 0, (Package)package_, (int[])nArray, (int)n, (long)l, (long)l2, set, (PackageUserState)packageUserState);
    }

    private static boolean checkUseInstalledOrHidden(int n, PackageUserState packageUserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkUseInstalledOrHidden", $$robo$$android_content_pm_PackageParser$checkUseInstalledOrHidden(int android.content.pm.PackageUserState ), 0, (int)n, (PackageUserState)packageUserState);
    }

    public static boolean isAvailable(PackageUserState packageUserState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_content_pm_PackageParser$isAvailable(android.content.pm.PackageUserState ), 0, (PackageUserState)packageUserState);
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, Set<String> set, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generatePackageInfo", $$robo$$android_content_pm_PackageParser$generatePackageInfo(android.content.pm.PackageParser$Package int[] int long long java.util.Set<java.lang.String> android.content.pm.PackageUserState int ), 0, (Package)package_, (int[])nArray, (int)n, (long)l, (long)l2, set, (PackageUserState)packageUserState, (int)n2);
    }

    private static Certificate[][] loadCertificates(StrictJarFile strictJarFile, ZipEntry zipEntry) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("loadCertificates", $$robo$$android_content_pm_PackageParser$loadCertificates(android.util.jar.StrictJarFile java.util.zip.ZipEntry ), 0, (StrictJarFile)strictJarFile, (ZipEntry)zipEntry);
    }

    public static PackageLite parsePackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parsePackageLite", $$robo$$android_content_pm_PackageParser$parsePackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static PackageLite parseMonolithicPackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseMonolithicPackageLite", $$robo$$android_content_pm_PackageParser$parseMonolithicPackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static PackageLite parseClusterPackageLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseClusterPackageLite", $$robo$$android_content_pm_PackageParser$parseClusterPackageLite(java.io.File int ), 0, (File)file, (int)n);
    }

    public Package parsePackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parsePackage", $$robo$$android_content_pm_PackageParser$parsePackage(java.io.File int ), 0, this, file, n);
    }

    private Package parseClusterPackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseClusterPackage", $$robo$$android_content_pm_PackageParser$parseClusterPackage(java.io.File int ), 0, this, file, n);
    }

    @Deprecated
    public Package parseMonolithicPackage(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseMonolithicPackage", $$robo$$android_content_pm_PackageParser$parseMonolithicPackage(java.io.File int ), 0, this, file, n);
    }

    private static int loadApkIntoAssetManager(AssetManager assetManager, String string2, int n) throws PackageParserException {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadApkIntoAssetManager", $$robo$$android_content_pm_PackageParser$loadApkIntoAssetManager(android.content.res.AssetManager java.lang.String int ), 0, (AssetManager)assetManager, (String)string2, (int)n);
    }

    private Package parseBaseApk(File file, AssetManager assetManager, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseBaseApk", $$robo$$android_content_pm_PackageParser$parseBaseApk(java.io.File android.content.res.AssetManager int ), 0, this, file, assetManager, n);
    }

    private void parseSplitApk(Package package_, int n, AssetManager assetManager, int n2) throws PackageParserException {
        InvokeDynamicSupport.bootstrap("parseSplitApk", $$robo$$android_content_pm_PackageParser$parseSplitApk(android.content.pm.PackageParser$Package int android.content.res.AssetManager int ), 0, this, package_, n, assetManager, n2);
    }

    private Package parseSplitApk(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException, PackageParserException {
        return InvokeDynamicSupport.bootstrap("parseSplitApk", $$robo$$android_content_pm_PackageParser$parseSplitApk(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, n2, stringArray);
    }

    public static int getApkSigningVersion(Package package_) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getApkSigningVersion", $$robo$$android_content_pm_PackageParser$getApkSigningVersion(android.content.pm.PackageParser$Package ), 0, (Package)package_);
    }

    public static void populateCertificates(Package package_, Certificate[][] certificateArray) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("populateCertificates", $$robo$$android_content_pm_PackageParser$populateCertificates(android.content.pm.PackageParser$Package java.security.cert.Certificate[][] ), 0, (Package)package_, (Certificate[][])certificateArray);
    }

    public static void collectCertificates(Package package_, int n) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificates", $$robo$$android_content_pm_PackageParser$collectCertificates(android.content.pm.PackageParser$Package int ), 0, (Package)package_, (int)n);
    }

    private static void collectCertificatesInternal(Package package_, int n) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificatesInternal", $$robo$$android_content_pm_PackageParser$collectCertificatesInternal(android.content.pm.PackageParser$Package int ), 0, (Package)package_, (int)n);
    }

    private static void collectCertificates(Package package_, File file, int n) throws PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("collectCertificates", $$robo$$android_content_pm_PackageParser$collectCertificates(android.content.pm.PackageParser$Package java.io.File int ), 0, (Package)package_, (File)file, (int)n);
    }

    private static Signature[] convertToSignatures(Certificate[][] certificateArray) throws CertificateEncodingException {
        return InvokeDynamicSupport.bootstrapStatic("convertToSignatures", $$robo$$android_content_pm_PackageParser$convertToSignatures(java.security.cert.Certificate[][] ), 0, (Certificate[][])certificateArray);
    }

    public static ApkLite parseApkLite(File file, int n) throws PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.io.File int ), 0, (File)file, (int)n);
    }

    private static String validateName(String string2, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("validateName", $$robo$$android_content_pm_PackageParser$validateName(java.lang.String boolean boolean ), 0, (String)string2, (boolean)bl, (boolean)bl2);
    }

    private static Pair<String, String> parsePackageSplitNames(XmlPullParser xmlPullParser, AttributeSet attributeSet) throws IOException, XmlPullParserException, PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parsePackageSplitNames", $$robo$$android_content_pm_PackageParser$parsePackageSplitNames(org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet);
    }

    private static ApkLite parseApkLite(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, Signature[] signatureArray, Certificate[][] certificateArray) throws IOException, XmlPullParserException, PackageParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseApkLite", $$robo$$android_content_pm_PackageParser$parseApkLite(java.lang.String android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int android.content.pm.Signature[] java.security.cert.Certificate[][] ), 0, (String)string2, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (int)n, (Signature[])signatureArray, (Certificate[][])certificateArray);
    }

    public static Signature stringToSignature(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stringToSignature", $$robo$$android_content_pm_PackageParser$stringToSignature(java.lang.String ), 0, (String)string2);
    }

    private boolean parseBaseApkChild(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseBaseApkChild", $$robo$$android_content_pm_PackageParser$parseBaseApkChild(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private Package parseBaseApk(Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseBaseApk", $$robo$$android_content_pm_PackageParser$parseBaseApk(android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, resources, xmlResourceParser, n, stringArray);
    }

    private Package parseBaseApkCommon(Package package_, Set<String> set, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseBaseApkCommon", $$robo$$android_content_pm_PackageParser$parseBaseApkCommon(android.content.pm.PackageParser$Package java.util.Set<java.lang.String> android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, set, resources, xmlResourceParser, n, stringArray);
    }

    private FeatureInfo parseUsesFeature(Resources resources, AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("parseUsesFeature", $$robo$$android_content_pm_PackageParser$parseUsesFeature(android.content.res.Resources android.util.AttributeSet ), 0, this, resources, attributeSet);
    }

    private boolean parseUsesPermission(Package package_, Resources resources, XmlResourceParser xmlResourceParser) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseUsesPermission", $$robo$$android_content_pm_PackageParser$parseUsesPermission(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser ), 0, this, package_, resources, xmlResourceParser);
    }

    private static String buildClassName(String string2, CharSequence charSequence, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildClassName", $$robo$$android_content_pm_PackageParser$buildClassName(java.lang.String java.lang.CharSequence java.lang.String[] ), 0, (String)string2, (CharSequence)charSequence, (String[])stringArray);
    }

    private static String buildCompoundName(String string2, CharSequence charSequence, String string3, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildCompoundName", $$robo$$android_content_pm_PackageParser$buildCompoundName(java.lang.String java.lang.CharSequence java.lang.String java.lang.String[] ), 0, (String)string2, (CharSequence)charSequence, (String)string3, (String[])stringArray);
    }

    private static String buildProcessName(String string2, String string3, CharSequence charSequence, int n, String[] stringArray, String[] stringArray2) {
        return InvokeDynamicSupport.bootstrapStatic("buildProcessName", $$robo$$android_content_pm_PackageParser$buildProcessName(java.lang.String java.lang.String java.lang.CharSequence int java.lang.String[] java.lang.String[] ), 0, (String)string2, (String)string3, (CharSequence)charSequence, (int)n, (String[])stringArray, (String[])stringArray2);
    }

    private static String buildTaskAffinityName(String string2, String string3, CharSequence charSequence, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildTaskAffinityName", $$robo$$android_content_pm_PackageParser$buildTaskAffinityName(java.lang.String java.lang.String java.lang.CharSequence java.lang.String[] ), 0, (String)string2, (String)string3, (CharSequence)charSequence, (String[])stringArray);
    }

    private boolean parseKeySets(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseKeySets", $$robo$$android_content_pm_PackageParser$parseKeySets(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private PermissionGroup parsePermissionGroup(Package package_, int n, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parsePermissionGroup", $$robo$$android_content_pm_PackageParser$parsePermissionGroup(android.content.pm.PackageParser$Package int android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, n, resources, xmlResourceParser, stringArray);
    }

    private Permission parsePermission(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parsePermission", $$robo$$android_content_pm_PackageParser$parsePermission(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private Permission parsePermissionTree(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parsePermissionTree", $$robo$$android_content_pm_PackageParser$parsePermissionTree(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private Instrumentation parseInstrumentation(Package package_, Resources resources, XmlResourceParser xmlResourceParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseInstrumentation", $$robo$$android_content_pm_PackageParser$parseInstrumentation(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, stringArray);
    }

    private boolean parseBaseApplication(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseBaseApplication", $$robo$$android_content_pm_PackageParser$parseBaseApplication(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private static void modifySharedLibrariesForBackwardCompatibility(Package package_) {
        InvokeDynamicSupport.bootstrapStatic("modifySharedLibrariesForBackwardCompatibility", $$robo$$android_content_pm_PackageParser$modifySharedLibrariesForBackwardCompatibility(android.content.pm.PackageParser$Package ), 0, (Package)package_);
    }

    private static boolean hasDomainURLs(Package package_) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasDomainURLs", $$robo$$android_content_pm_PackageParser$hasDomainURLs(android.content.pm.PackageParser$Package ), 0, (Package)package_);
    }

    private boolean parseSplitApplication(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseSplitApplication", $$robo$$android_content_pm_PackageParser$parseSplitApplication(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, n2, stringArray);
    }

    private boolean parsePackageItemInfo(Package package_, PackageItemInfo packageItemInfo, String[] stringArray, String string2, TypedArray typedArray, int n, int n2, int n3, int n4, int n5) {
        return (boolean)InvokeDynamicSupport.bootstrap("parsePackageItemInfo", $$robo$$android_content_pm_PackageParser$parsePackageItemInfo(android.content.pm.PackageParser$Package android.content.pm.PackageItemInfo java.lang.String[] java.lang.String android.content.res.TypedArray int int int int int ), 0, this, package_, packageItemInfo, stringArray, string2, typedArray, n, n2, n3, n4, n5);
    }

    private Activity parseActivity(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray, boolean bl, boolean bl2) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseActivity", $$robo$$android_content_pm_PackageParser$parseActivity(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] boolean boolean ), 0, this, package_, resources, xmlResourceParser, n, stringArray, bl, bl2);
    }

    private void parseLayout(Resources resources, AttributeSet attributeSet, Activity activity) {
        InvokeDynamicSupport.bootstrap("parseLayout", $$robo$$android_content_pm_PackageParser$parseLayout(android.content.res.Resources android.util.AttributeSet android.content.pm.PackageParser$Activity ), 0, this, resources, attributeSet, activity);
    }

    private Activity parseActivityAlias(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseActivityAlias", $$robo$$android_content_pm_PackageParser$parseActivityAlias(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private Provider parseProvider(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseProvider", $$robo$$android_content_pm_PackageParser$parseProvider(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private boolean parseProviderTags(Resources resources, XmlResourceParser xmlResourceParser, Provider provider, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseProviderTags", $$robo$$android_content_pm_PackageParser$parseProviderTags(android.content.res.Resources android.content.res.XmlResourceParser android.content.pm.PackageParser$Provider java.lang.String[] ), 0, this, resources, xmlResourceParser, provider, stringArray);
    }

    private Service parseService(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseService", $$robo$$android_content_pm_PackageParser$parseService(android.content.pm.PackageParser$Package android.content.res.Resources android.content.res.XmlResourceParser int java.lang.String[] ), 0, this, package_, resources, xmlResourceParser, n, stringArray);
    }

    private boolean parseAllMetaData(Resources resources, XmlResourceParser xmlResourceParser, String string2, Component<?> component, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseAllMetaData", $$robo$$android_content_pm_PackageParser$parseAllMetaData(android.content.res.Resources android.content.res.XmlResourceParser java.lang.String android.content.pm.PackageParser$Component<?> java.lang.String[] ), 0, this, resources, xmlResourceParser, string2, component, stringArray);
    }

    private Bundle parseMetaData(Resources resources, XmlResourceParser xmlResourceParser, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("parseMetaData", $$robo$$android_content_pm_PackageParser$parseMetaData(android.content.res.Resources android.content.res.XmlResourceParser android.os.Bundle java.lang.String[] ), 0, this, resources, xmlResourceParser, bundle, stringArray);
    }

    private static VerifierInfo parseVerifier(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseVerifier", $$robo$$android_content_pm_PackageParser$parseVerifier(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet int ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (int)n);
    }

    public static PublicKey parsePublicKey(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parsePublicKey", $$robo$$android_content_pm_PackageParser$parsePublicKey(java.lang.String ), 0, (String)string2);
    }

    private boolean parseIntent(Resources resources, XmlResourceParser xmlResourceParser, boolean bl, boolean bl2, IntentInfo intentInfo, String[] stringArray) throws XmlPullParserException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("parseIntent", $$robo$$android_content_pm_PackageParser$parseIntent(android.content.res.Resources android.content.res.XmlResourceParser boolean boolean android.content.pm.PackageParser$IntentInfo java.lang.String[] ), 0, this, resources, xmlResourceParser, bl, bl2, intentInfo, stringArray);
    }

    private static boolean copyNeeded(int n, Package package_, PackageUserState packageUserState, Bundle bundle, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("copyNeeded", $$robo$$android_content_pm_PackageParser$copyNeeded(int android.content.pm.PackageParser$Package android.content.pm.PackageUserState android.os.Bundle int ), 0, (int)n, (Package)package_, (PackageUserState)packageUserState, (Bundle)bundle, (int)n2);
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.PackageParser$Package int android.content.pm.PackageUserState ), 0, (Package)package_, (int)n, (PackageUserState)packageUserState);
    }

    private static void updateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState) {
        InvokeDynamicSupport.bootstrapStatic("updateApplicationInfo", $$robo$$android_content_pm_PackageParser$updateApplicationInfo(android.content.pm.ApplicationInfo int android.content.pm.PackageUserState ), 0, (ApplicationInfo)applicationInfo, (int)n, (PackageUserState)packageUserState);
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.PackageParser$Package int android.content.pm.PackageUserState int ), 0, (Package)package_, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ApplicationInfo generateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateApplicationInfo", $$robo$$android_content_pm_PackageParser$generateApplicationInfo(android.content.pm.ApplicationInfo int android.content.pm.PackageUserState int ), 0, (ApplicationInfo)applicationInfo, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static PermissionInfo generatePermissionInfo(Permission permission2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generatePermissionInfo", $$robo$$android_content_pm_PackageParser$generatePermissionInfo(android.content.pm.PackageParser$Permission int ), 0, (Permission)permission2, (int)n);
    }

    public static PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup permissionGroup, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generatePermissionGroupInfo", $$robo$$android_content_pm_PackageParser$generatePermissionGroupInfo(android.content.pm.PackageParser$PermissionGroup int ), 0, (PermissionGroup)permissionGroup, (int)n);
    }

    public static ActivityInfo generateActivityInfo(Activity activity, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateActivityInfo", $$robo$$android_content_pm_PackageParser$generateActivityInfo(android.content.pm.PackageParser$Activity int android.content.pm.PackageUserState int ), 0, (Activity)activity, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ActivityInfo generateActivityInfo(ActivityInfo activityInfo, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateActivityInfo", $$robo$$android_content_pm_PackageParser$generateActivityInfo(android.content.pm.ActivityInfo int android.content.pm.PackageUserState int ), 0, (ActivityInfo)activityInfo, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ServiceInfo generateServiceInfo(Service service, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateServiceInfo", $$robo$$android_content_pm_PackageParser$generateServiceInfo(android.content.pm.PackageParser$Service int android.content.pm.PackageUserState int ), 0, (Service)service, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static ProviderInfo generateProviderInfo(Provider provider, int n, PackageUserState packageUserState, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("generateProviderInfo", $$robo$$android_content_pm_PackageParser$generateProviderInfo(android.content.pm.PackageParser$Provider int android.content.pm.PackageUserState int ), 0, (Provider)provider, (int)n, (PackageUserState)packageUserState, (int)n2);
    }

    public static InstrumentationInfo generateInstrumentationInfo(Instrumentation instrumentation, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generateInstrumentationInfo", $$robo$$android_content_pm_PackageParser$generateInstrumentationInfo(android.content.pm.PackageParser$Instrumentation int ), 0, (Instrumentation)instrumentation, (int)n);
    }

    public static void setCompatibilityModeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setCompatibilityModeEnabled", $$robo$$android_content_pm_PackageParser$setCompatibilityModeEnabled(boolean ), 0, (boolean)bl);
    }

    public static long readFullyIgnoringContents(InputStream inputStream) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("readFullyIgnoringContents", $$robo$$android_content_pm_PackageParser$readFullyIgnoringContents(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static void closeQuietly(StrictJarFile strictJarFile) {
        InvokeDynamicSupport.bootstrapStatic("closeQuietly", $$robo$$android_content_pm_PackageParser$closeQuietly(android.util.jar.StrictJarFile ), 0, (StrictJarFile)strictJarFile);
    }

    static {
        RobolectricInternals.classInitializing(PackageParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PackageParserException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int error;

        private void $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int error, String detailMessage) {
            this.error = error;
        }

        private void $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int error, String detailMessage, Throwable throwable) {
            this.error = error;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(n, string2);
        }

        public PackageParserException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        private void __constructor__(int n, String string2, Throwable throwable) {
            this.$$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(n, string2, throwable);
        }

        public PackageParserException(int n, String string2, Throwable throwable) {
            super(string2, throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageParserException$__constructor__(int java.lang.String java.lang.Throwable ), 0, this, n, string2, throwable);
        }

        public /* synthetic */ PackageParserException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageParserException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ProviderIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Provider provider;

        private void $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(Provider provider) {
            this.provider = provider;
        }

        private final String $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ProviderIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.provider.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(Provider provider) {
            this.$$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(provider);
        }

        public ProviderIntentInfo(Provider provider) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$__constructor__(android.content.pm.PackageParser$Provider ), 0, this, provider);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ProviderIntentInfo$toString(), 0, this);
        }

        public /* synthetic */ ProviderIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProviderIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ServiceIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Service service;

        private void $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(Service _service) {
            this.service = _service;
        }

        private final String $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ServiceIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.service.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(Service service) {
            this.$$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(service);
        }

        public ServiceIntentInfo(Service service) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$__constructor__(android.content.pm.PackageParser$Service ), 0, this, service);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ServiceIntentInfo$toString(), 0, this);
        }

        public /* synthetic */ ServiceIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ActivityIntentInfo
    extends IntentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Activity activity;

        private void $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(Activity _activity) {
            this.activity = _activity;
        }

        private final String $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ActivityIntentInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.activity.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(Activity activity) {
            this.$$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(activity);
        }

        public ActivityIntentInfo(Activity activity) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$__constructor__(android.content.pm.PackageParser$Activity ), 0, this, activity);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_ActivityIntentInfo$toString(), 0, this);
        }

        public /* synthetic */ ActivityIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IntentInfo
    extends IntentFilter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean hasDefault;
        public int labelRes;
        public CharSequence nonLocalizedLabel;
        public int icon;
        public int logo;
        public int banner;
        public int preferred;

        private void $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__();
        }

        public IntentInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_IntentInfo$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Instrumentation
    extends Component<IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public InstrumentationInfo info;

        private void $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(ParsePackageItemArgs args, InstrumentationInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_Instrumentation$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Instrumentation$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Instrumentation{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            this.$$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(parsePackageItemArgs, instrumentationInfo);
        }

        public Instrumentation(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            super(parsePackageItemArgs, instrumentationInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Instrumentation$__constructor__(android.content.pm.PackageParser$ParsePackageItemArgs android.content.pm.InstrumentationInfo ), 0, this, parsePackageItemArgs, instrumentationInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Instrumentation$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Instrumentation$toString(), 0, this);
        }

        public /* synthetic */ Instrumentation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instrumentation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Provider
    extends Component<ProviderIntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ProviderInfo info;
        public boolean syncable;

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(ParseComponentArgs args, ProviderInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
            this.syncable = false;
        }

        private void $$robo$$android_content_pm_PackageParser_Provider$__constructor__(Provider existingProvider) {
            this.info = existingProvider.info;
            this.syncable = existingProvider.syncable;
        }

        private final void $$robo$$android_content_pm_PackageParser_Provider$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Provider$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Provider{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(parseComponentArgs, providerInfo);
        }

        public Provider(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            super(parseComponentArgs, providerInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ProviderInfo ), 0, this, parseComponentArgs, providerInfo);
        }

        private void __constructor__(Provider provider) {
            this.$$robo$$android_content_pm_PackageParser_Provider$__constructor__(provider);
        }

        public Provider(Provider provider) {
            super(provider);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Provider$__constructor__(android.content.pm.PackageParser$Provider ), 0, this, provider);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Provider$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Provider$toString(), 0, this);
        }

        public /* synthetic */ Provider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Provider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Service
    extends Component<ServiceIntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ServiceInfo info;

        private void $$robo$$android_content_pm_PackageParser_Service$__constructor__(ParseComponentArgs args, ServiceInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        private final void $$robo$$android_content_pm_PackageParser_Service$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Service$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Service{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            this.$$robo$$android_content_pm_PackageParser_Service$__constructor__(parseComponentArgs, serviceInfo);
        }

        public Service(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            super(parseComponentArgs, serviceInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Service$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ServiceInfo ), 0, this, parseComponentArgs, serviceInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Service$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Service$toString(), 0, this);
        }

        public /* synthetic */ Service() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Service)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Activity
    extends Component<ActivityIntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public ActivityInfo info;

        private void $$robo$$android_content_pm_PackageParser_Activity$__constructor__(ParseComponentArgs args, ActivityInfo _info) {
            this.info = _info;
            this.info.applicationInfo = args.owner.applicationInfo;
        }

        private final void $$robo$$android_content_pm_PackageParser_Activity$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Activity$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Activity{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            this.appendComponentShortName(sb);
            sb.append('}');
            return sb.toString();
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            this.$$robo$$android_content_pm_PackageParser_Activity$__constructor__(parseComponentArgs, activityInfo);
        }

        public Activity(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            super(parseComponentArgs, activityInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Activity$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ActivityInfo ), 0, this, parseComponentArgs, activityInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Activity$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Activity$toString(), 0, this);
        }

        public /* synthetic */ Activity() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Activity)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PermissionGroup
    extends Component<IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public PermissionGroupInfo info;

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Package _owner) {
            this.info = new PermissionGroupInfo();
        }

        private void $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(Package _owner, PermissionGroupInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_PermissionGroup$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_PermissionGroup$toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(package_);
        }

        public PermissionGroup(Package package_) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(Package package_, PermissionGroupInfo permissionGroupInfo) {
            this.$$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(package_, permissionGroupInfo);
        }

        public PermissionGroup(Package package_, PermissionGroupInfo permissionGroupInfo) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PermissionGroup$__constructor__(android.content.pm.PackageParser$Package android.content.pm.PermissionGroupInfo ), 0, this, package_, permissionGroupInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_PermissionGroup$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_PermissionGroup$toString(), 0, this);
        }

        public /* synthetic */ PermissionGroup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionGroup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Permission
    extends Component<IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public PermissionInfo info;
        public boolean tree;
        public PermissionGroup group;

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Package _owner) {
            this.info = new PermissionInfo();
        }

        private void $$robo$$android_content_pm_PackageParser_Permission$__constructor__(Package _owner, PermissionInfo _info) {
            this.info = _info;
        }

        private final void $$robo$$android_content_pm_PackageParser_Permission$setPackageName(String packageName) {
            super.setPackageName(packageName);
            this.info.packageName = packageName;
        }

        private final String $$robo$$android_content_pm_PackageParser_Permission$toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(package_);
        }

        public Permission(Package package_) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(Package package_, PermissionInfo permissionInfo) {
            this.$$robo$$android_content_pm_PackageParser_Permission$__constructor__(package_, permissionInfo);
        }

        public Permission(Package package_, PermissionInfo permissionInfo) {
            super(package_);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Permission$__constructor__(android.content.pm.PackageParser$Package android.content.pm.PermissionInfo ), 0, this, package_, permissionInfo);
        }

        @Override
        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Permission$setPackageName(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Permission$toString(), 0, this);
        }

        public /* synthetic */ Permission() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Permission)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Component<II extends IntentInfo> {
        public transient /* synthetic */ Object __robo_data__;
        public Package owner;
        public ArrayList<II> intents;
        public String className;
        public Bundle metaData;
        ComponentName componentName;
        String componentShortName;

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Package _owner) {
            this.owner = _owner;
            this.intents = null;
            this.className = null;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(ParsePackageItemArgs args, PackageItemInfo outInfo) {
            TypedValue v;
            int bannerVal;
            int logoVal;
            this.owner = args.owner;
            this.intents = new ArrayList(0);
            String name = args.sa.getNonConfigurationString(args.nameRes, 0);
            if (name == null) {
                this.className = null;
                args.outError[0] = args.tag + " does not specify android:name";
                return;
            }
            outInfo.name = PackageParser.buildClassName(this.owner.applicationInfo.packageName, name, args.outError);
            if (outInfo.name == null) {
                this.className = null;
                args.outError[0] = args.tag + " does not have valid android:name";
                return;
            }
            this.className = outInfo.name;
            int iconVal = args.sa.getResourceId(args.iconRes, 0);
            if (iconVal != 0) {
                outInfo.icon = iconVal;
                outInfo.nonLocalizedLabel = null;
            }
            if ((logoVal = args.sa.getResourceId(args.logoRes, 0)) != 0) {
                outInfo.logo = logoVal;
            }
            if ((bannerVal = args.sa.getResourceId(args.bannerRes, 0)) != 0) {
                outInfo.banner = bannerVal;
            }
            if ((v = args.sa.peekValue(args.labelRes)) != null && (outInfo.labelRes = v.resourceId) == 0) {
                outInfo.nonLocalizedLabel = v.coerceToString();
            }
            outInfo.packageName = this.owner.packageName;
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(ParseComponentArgs args, ComponentInfo outInfo) {
            if (args.outError[0] != null) {
                return;
            }
            if (args.processRes != 0) {
                String pname = this.owner.applicationInfo.targetSdkVersion >= 8 ? args.sa.getNonConfigurationString(args.processRes, 1024) : args.sa.getNonResourceString(args.processRes);
                outInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, pname, args.flags, args.sepProcesses, args.outError);
            }
            if (args.descriptionRes != 0) {
                outInfo.descriptionRes = args.sa.getResourceId(args.descriptionRes, 0);
            }
            outInfo.enabled = args.sa.getBoolean(args.enabledRes, true);
        }

        private void $$robo$$android_content_pm_PackageParser_Component$__constructor__(Component<II> clone) {
            this.owner = clone.owner;
            this.intents = clone.intents;
            this.className = clone.className;
            this.componentName = clone.componentName;
            this.componentShortName = clone.componentShortName;
        }

        private final ComponentName $$robo$$android_content_pm_PackageParser_Component$getComponentName() {
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className != null) {
                this.componentName = new ComponentName(this.owner.applicationInfo.packageName, this.className);
            }
            return this.componentName;
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$appendComponentShortName(StringBuilder sb) {
            ComponentName.appendShortString(sb, this.owner.applicationInfo.packageName, this.className);
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$printComponentShortName(PrintWriter pw) {
            ComponentName.printShortString(pw, this.owner.applicationInfo.packageName, this.className);
        }

        private final void $$robo$$android_content_pm_PackageParser_Component$setPackageName(String packageName) {
            this.componentName = null;
            this.componentShortName = null;
        }

        private void __constructor__(Package package_) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(package_);
        }

        public Component(Package package_) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$Package ), 0, this, package_);
        }

        private void __constructor__(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parsePackageItemArgs, packageItemInfo);
        }

        public Component(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$ParsePackageItemArgs android.content.pm.PackageItemInfo ), 0, this, parsePackageItemArgs, packageItemInfo);
        }

        private void __constructor__(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(parseComponentArgs, componentInfo);
        }

        public Component(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this((ParsePackageItemArgs)parseComponentArgs, (PackageItemInfo)componentInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$ParseComponentArgs android.content.pm.ComponentInfo ), 0, this, parseComponentArgs, componentInfo);
        }

        private void __constructor__(Component<II> component) {
            this.$$robo$$android_content_pm_PackageParser_Component$__constructor__(component);
        }

        public Component(Component<II> component) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Component$__constructor__(android.content.pm.PackageParser$Component<II> ), 0, this, component);
        }

        public ComponentName getComponentName() {
            return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$android_content_pm_PackageParser_Component$getComponentName(), 0, this);
        }

        public void appendComponentShortName(StringBuilder stringBuilder) {
            InvokeDynamicSupport.bootstrap("appendComponentShortName", $$robo$$android_content_pm_PackageParser_Component$appendComponentShortName(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        public void printComponentShortName(PrintWriter printWriter) {
            InvokeDynamicSupport.bootstrap("printComponentShortName", $$robo$$android_content_pm_PackageParser_Component$printComponentShortName(java.io.PrintWriter ), 0, this, printWriter);
        }

        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Component$setPackageName(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Component() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Component)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Package
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public String[] splitNames;
        public String volumeUuid;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public int baseRevisionCode;
        public int[] splitRevisionCodes;
        public int[] splitFlags;
        public int[] splitPrivateFlags;
        public boolean baseHardwareAccelerated;
        public ApplicationInfo applicationInfo;
        public ArrayList<Permission> permissions;
        public ArrayList<PermissionGroup> permissionGroups;
        public ArrayList<Activity> activities;
        public ArrayList<Activity> receivers;
        public ArrayList<Provider> providers;
        public ArrayList<Service> services;
        public ArrayList<Instrumentation> instrumentation;
        public ArrayList<String> requestedPermissions;
        public ArrayList<String> protectedBroadcasts;
        public Package parentPackage;
        public ArrayList<Package> childPackages;
        public ArrayList<String> libraryNames;
        public ArrayList<String> usesLibraries;
        public ArrayList<String> usesOptionalLibraries;
        public String[] usesLibraryFiles;
        public ArrayList<ActivityIntentInfo> preferredActivityFilters;
        public ArrayList<String> mOriginalPackages;
        public String mRealPackage;
        public ArrayList<String> mAdoptPermissions;
        public Bundle mAppMetaData;
        public int mVersionCode;
        public String mVersionName;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public Signature[] mSignatures;
        public Certificate[][] mCertificates;
        public int mPreferredOrder;
        public long[] mLastPackageUsageTimeInMills;
        public Object mExtras;
        public ArrayList<ConfigurationInfo> configPreferences;
        public ArrayList<FeatureInfo> reqFeatures;
        public ArrayList<FeatureGroupInfo> featureGroups;
        public int installLocation;
        public boolean coreApp;
        public boolean mRequiredForAllUsers;
        public String mRestrictedAccountType;
        public String mRequiredAccountType;
        public String mOverlayTarget;
        public int mOverlayPriority;
        public boolean mTrustedOverlay;
        public ArraySet<PublicKey> mSigningKeys;
        public ArraySet<String> mUpgradeKeySets;
        public ArrayMap<String, ArraySet<PublicKey>> mKeySetMapping;
        public String cpuAbiOverride;
        public boolean use32bitAbi;
        public byte[] restrictUpdateHash;

        private void $$robo$$android_content_pm_PackageParser_Package$__constructor__(String packageName) {
            this.applicationInfo = new ApplicationInfo();
            this.permissions = new ArrayList(0);
            this.permissionGroups = new ArrayList(0);
            this.activities = new ArrayList(0);
            this.receivers = new ArrayList(0);
            this.providers = new ArrayList(0);
            this.services = new ArrayList(0);
            this.instrumentation = new ArrayList(0);
            this.requestedPermissions = new ArrayList();
            this.libraryNames = null;
            this.usesLibraries = null;
            this.usesOptionalLibraries = null;
            this.usesLibraryFiles = null;
            this.preferredActivityFilters = null;
            this.mOriginalPackages = null;
            this.mRealPackage = null;
            this.mAdoptPermissions = null;
            this.mAppMetaData = null;
            this.mPreferredOrder = 0;
            this.mLastPackageUsageTimeInMills = new long[8];
            this.configPreferences = null;
            this.reqFeatures = null;
            this.featureGroups = null;
            this.packageName = packageName;
            this.applicationInfo.packageName = packageName;
            this.applicationInfo.uid = -1;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationVolumeUuid(String volumeUuid) {
            this.applicationInfo.volumeUuid = volumeUuid;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.volumeUuid = volumeUuid;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoCodePath(String codePath) {
            this.applicationInfo.setCodePath(codePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setCodePath(codePath);
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoResourcePath(String resourcePath) {
            this.applicationInfo.setResourcePath(resourcePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setResourcePath(resourcePath);
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseResourcePath(String resourcePath) {
            this.applicationInfo.setBaseResourcePath(resourcePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setBaseResourcePath(resourcePath);
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseCodePath(String baseCodePath) {
            this.applicationInfo.setBaseCodePath(baseCodePath);
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.setBaseCodePath(baseCodePath);
                }
            }
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$hasChildPackage(String packageName) {
            int childCount = this.childPackages != null ? this.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                if (!this.childPackages.get((int)i).packageName.equals(packageName)) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitCodePaths(String[] splitCodePaths) {
            this.applicationInfo.setSplitCodePaths(splitCodePaths);
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitResourcePaths(String[] resroucePaths) {
            this.applicationInfo.setSplitResourcePaths(resroucePaths);
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setSplitCodePaths(String[] codePaths) {
            this.splitCodePaths = codePaths;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setCodePath(String codePath) {
            this.codePath = codePath;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).codePath = codePath;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setBaseCodePath(String baseCodePath) {
            this.baseCodePath = baseCodePath;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).baseCodePath = baseCodePath;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setSignatures(Signature[] signatures) {
            this.mSignatures = signatures;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).mSignatures = signatures;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setVolumeUuid(String volumeUuid) {
            this.volumeUuid = volumeUuid;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).volumeUuid = volumeUuid;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoFlags(int mask, int flags) {
            this.applicationInfo.flags = this.applicationInfo.flags & ~mask | mask & flags;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).applicationInfo.flags = this.applicationInfo.flags & ~mask | mask & flags;
                }
            }
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setUse32bitAbi(boolean use32bitAbi) {
            this.use32bitAbi = use32bitAbi;
            if (this.childPackages != null) {
                int packageCount = this.childPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    this.childPackages.get((int)i).use32bitAbi = use32bitAbi;
                }
            }
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_Package$getAllCodePathsExcludingResourceOnly() {
            ArrayList<String> paths = new ArrayList<String>();
            if ((this.applicationInfo.flags & 4) != 0) {
                paths.add(this.baseCodePath);
            }
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                for (int i = 0; i < this.splitCodePaths.length; ++i) {
                    if ((this.splitFlags[i] & 4) == 0) continue;
                    paths.add(this.splitCodePaths[i]);
                }
            }
            return paths;
        }

        private final void $$robo$$android_content_pm_PackageParser_Package$setPackageName(String newName) {
            int i;
            this.packageName = newName;
            this.applicationInfo.packageName = newName;
            for (i = this.permissions.size() - 1; i >= 0; --i) {
                this.permissions.get(i).setPackageName(newName);
            }
            for (i = this.permissionGroups.size() - 1; i >= 0; --i) {
                this.permissionGroups.get(i).setPackageName(newName);
            }
            for (i = this.activities.size() - 1; i >= 0; --i) {
                this.activities.get(i).setPackageName(newName);
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                this.receivers.get(i).setPackageName(newName);
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                this.providers.get(i).setPackageName(newName);
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                this.services.get(i).setPackageName(newName);
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                this.instrumentation.get(i).setPackageName(newName);
            }
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$hasComponentClassName(String name) {
            int i;
            for (i = this.activities.size() - 1; i >= 0; --i) {
                if (!name.equals(this.activities.get((int)i).className)) continue;
                return true;
            }
            for (i = this.receivers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.receivers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.providers.size() - 1; i >= 0; --i) {
                if (!name.equals(this.providers.get((int)i).className)) continue;
                return true;
            }
            for (i = this.services.size() - 1; i >= 0; --i) {
                if (!name.equals(this.services.get((int)i).className)) continue;
                return true;
            }
            for (i = this.instrumentation.size() - 1; i >= 0; --i) {
                if (!name.equals(this.instrumentation.get((int)i).className)) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isForwardLocked() {
            return this.applicationInfo.isForwardLocked();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isSystemApp() {
            return this.applicationInfo.isSystemApp();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isPrivilegedApp() {
            return this.applicationInfo.isPrivilegedApp();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isUpdatedSystemApp() {
            return this.applicationInfo.isUpdatedSystemApp();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$canHaveOatDir() {
            return (!this.isSystemApp() || this.isUpdatedSystemApp()) && !this.isForwardLocked() && !this.applicationInfo.isExternalAsec();
        }

        private final boolean $$robo$$android_content_pm_PackageParser_Package$isMatch(int flags) {
            if ((flags & 0x100000) != 0) {
                return this.isSystemApp();
            }
            return true;
        }

        private final long $$robo$$android_content_pm_PackageParser_Package$getLatestPackageUseTimeInMills() {
            long latestUse = 0L;
            for (long use : this.mLastPackageUsageTimeInMills) {
                latestUse = Math.max(latestUse, use);
            }
            return latestUse;
        }

        private final long $$robo$$android_content_pm_PackageParser_Package$getLatestForegroundPackageUseTimeInMills() {
            int[] foregroundReasons = new int[]{0, 2};
            long latestUse = 0L;
            for (int reason : foregroundReasons) {
                latestUse = Math.max(latestUse, this.mLastPackageUsageTimeInMills[reason]);
            }
            return latestUse;
        }

        private final String $$robo$$android_content_pm_PackageParser_Package$toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_pm_PackageParser_Package$__constructor__(string2);
        }

        public Package(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_Package$__constructor__(java.lang.String ), 0, this, string2);
        }

        public void setApplicationVolumeUuid(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationVolumeUuid", $$robo$$android_content_pm_PackageParser_Package$setApplicationVolumeUuid(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoCodePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoCodePath(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoResourcePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoResourcePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoResourcePath(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoBaseResourcePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoBaseResourcePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseResourcePath(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoBaseCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoBaseCodePath", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoBaseCodePath(java.lang.String ), 0, this, string2);
        }

        public boolean hasChildPackage(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasChildPackage", $$robo$$android_content_pm_PackageParser_Package$hasChildPackage(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoSplitCodePaths(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoSplitCodePaths", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitCodePaths(java.lang.String[] ), 0, this, stringArray);
        }

        public void setApplicationInfoSplitResourcePaths(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoSplitResourcePaths", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoSplitResourcePaths(java.lang.String[] ), 0, this, stringArray);
        }

        public void setSplitCodePaths(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setSplitCodePaths", $$robo$$android_content_pm_PackageParser_Package$setSplitCodePaths(java.lang.String[] ), 0, this, stringArray);
        }

        public void setCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setCodePath", $$robo$$android_content_pm_PackageParser_Package$setCodePath(java.lang.String ), 0, this, string2);
        }

        public void setBaseCodePath(String string2) {
            InvokeDynamicSupport.bootstrap("setBaseCodePath", $$robo$$android_content_pm_PackageParser_Package$setBaseCodePath(java.lang.String ), 0, this, string2);
        }

        public void setSignatures(Signature[] signatureArray) {
            InvokeDynamicSupport.bootstrap("setSignatures", $$robo$$android_content_pm_PackageParser_Package$setSignatures(android.content.pm.Signature[] ), 0, this, signatureArray);
        }

        public void setVolumeUuid(String string2) {
            InvokeDynamicSupport.bootstrap("setVolumeUuid", $$robo$$android_content_pm_PackageParser_Package$setVolumeUuid(java.lang.String ), 0, this, string2);
        }

        public void setApplicationInfoFlags(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setApplicationInfoFlags", $$robo$$android_content_pm_PackageParser_Package$setApplicationInfoFlags(int int ), 0, this, n, n2);
        }

        public void setUse32bitAbi(boolean bl) {
            InvokeDynamicSupport.bootstrap("setUse32bitAbi", $$robo$$android_content_pm_PackageParser_Package$setUse32bitAbi(boolean ), 0, this, bl);
        }

        public List<String> getAllCodePaths() {
            return InvokeDynamicSupport.bootstrap("getAllCodePaths", $$robo$$android_content_pm_PackageParser_Package$getAllCodePaths(), 0, this);
        }

        public List<String> getAllCodePathsExcludingResourceOnly() {
            return InvokeDynamicSupport.bootstrap("getAllCodePathsExcludingResourceOnly", $$robo$$android_content_pm_PackageParser_Package$getAllCodePathsExcludingResourceOnly(), 0, this);
        }

        public void setPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_content_pm_PackageParser_Package$setPackageName(java.lang.String ), 0, this, string2);
        }

        public boolean hasComponentClassName(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasComponentClassName", $$robo$$android_content_pm_PackageParser_Package$hasComponentClassName(java.lang.String ), 0, this, string2);
        }

        public boolean isForwardLocked() {
            return (boolean)InvokeDynamicSupport.bootstrap("isForwardLocked", $$robo$$android_content_pm_PackageParser_Package$isForwardLocked(), 0, this);
        }

        public boolean isSystemApp() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSystemApp", $$robo$$android_content_pm_PackageParser_Package$isSystemApp(), 0, this);
        }

        public boolean isPrivilegedApp() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPrivilegedApp", $$robo$$android_content_pm_PackageParser_Package$isPrivilegedApp(), 0, this);
        }

        public boolean isUpdatedSystemApp() {
            return (boolean)InvokeDynamicSupport.bootstrap("isUpdatedSystemApp", $$robo$$android_content_pm_PackageParser_Package$isUpdatedSystemApp(), 0, this);
        }

        public boolean canHaveOatDir() {
            return (boolean)InvokeDynamicSupport.bootstrap("canHaveOatDir", $$robo$$android_content_pm_PackageParser_Package$canHaveOatDir(), 0, this);
        }

        public boolean isMatch(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isMatch", $$robo$$android_content_pm_PackageParser_Package$isMatch(int ), 0, this, n);
        }

        public long getLatestPackageUseTimeInMills() {
            return (long)InvokeDynamicSupport.bootstrap("getLatestPackageUseTimeInMills", $$robo$$android_content_pm_PackageParser_Package$getLatestPackageUseTimeInMills(), 0, this);
        }

        public long getLatestForegroundPackageUseTimeInMills() {
            return (long)InvokeDynamicSupport.bootstrap("getLatestForegroundPackageUseTimeInMills", $$robo$$android_content_pm_PackageParser_Package$getLatestForegroundPackageUseTimeInMills(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_PackageParser_Package$toString(), 0, this);
        }

        public /* synthetic */ Package() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Package)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__() {
        }

        private final int $$robo$$android_content_pm_PackageParser_SplitNameComparator$compare(String lhs, String rhs) {
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }

        private /* synthetic */ void $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__();
        }

        private SplitNameComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(), 0, this);
        }

        @Override
        public int compare(String string2, String string3) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_content_pm_PackageParser_SplitNameComparator$compare(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_content_pm_PackageParser_SplitNameComparator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitNameComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ApkLite
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String codePath;
        public String packageName;
        public String splitName;
        public int versionCode;
        public int revisionCode;
        public int installLocation;
        public VerifierInfo[] verifiers;
        public Signature[] signatures;
        public Certificate[][] certificates;
        public boolean coreApp;
        public boolean multiArch;
        public boolean use32bitAbi;
        public boolean extractNativeLibs;

        private void $$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(String codePath, String packageName, String splitName, int versionCode, int revisionCode, int installLocation, List<VerifierInfo> verifiers, Signature[] signatures, Certificate[][] certificates, boolean coreApp, boolean multiArch, boolean use32bitAbi, boolean extractNativeLibs) {
            this.codePath = codePath;
            this.packageName = packageName;
            this.splitName = splitName;
            this.versionCode = versionCode;
            this.revisionCode = revisionCode;
            this.installLocation = installLocation;
            this.verifiers = verifiers.toArray(new VerifierInfo[verifiers.size()]);
            this.signatures = signatures;
            this.certificates = certificates;
            this.coreApp = coreApp;
            this.multiArch = multiArch;
            this.use32bitAbi = use32bitAbi;
            this.extractNativeLibs = extractNativeLibs;
        }

        private void __constructor__(String string2, String string3, String string4, int n, int n2, int n3, List<VerifierInfo> list, Signature[] signatureArray, Certificate[][] certificateArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.$$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(string2, string3, string4, n, n2, n3, list, signatureArray, certificateArray, bl, bl2, bl3, bl4);
        }

        public ApkLite(String string2, String string3, String string4, int n, int n2, int n3, List<VerifierInfo> list, Signature[] signatureArray, Certificate[][] certificateArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ApkLite$__constructor__(java.lang.String java.lang.String java.lang.String int int int java.util.List<android.content.pm.VerifierInfo> android.content.pm.Signature[] java.security.cert.Certificate[][] boolean boolean boolean boolean ), 0, this, string2, string3, string4, n, n2, n3, list, signatureArray, certificateArray, bl, bl2, bl3, bl4);
        }

        public /* synthetic */ ApkLite() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkLite)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PackageLite
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public int versionCode;
        public int installLocation;
        public VerifierInfo[] verifiers;
        public String[] splitNames;
        public String codePath;
        public String baseCodePath;
        public String[] splitCodePaths;
        public int baseRevisionCode;
        public int[] splitRevisionCodes;
        public boolean coreApp;
        public boolean multiArch;
        public boolean use32bitAbi;
        public boolean extractNativeLibs;

        private void $$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(String codePath, ApkLite baseApk, String[] splitNames, String[] splitCodePaths, int[] splitRevisionCodes) {
            this.packageName = baseApk.packageName;
            this.versionCode = baseApk.versionCode;
            this.installLocation = baseApk.installLocation;
            this.verifiers = baseApk.verifiers;
            this.splitNames = splitNames;
            this.codePath = codePath;
            this.baseCodePath = baseApk.codePath;
            this.splitCodePaths = splitCodePaths;
            this.baseRevisionCode = baseApk.revisionCode;
            this.splitRevisionCodes = splitRevisionCodes;
            this.coreApp = baseApk.coreApp;
            this.multiArch = baseApk.multiArch;
            this.use32bitAbi = baseApk.use32bitAbi;
            this.extractNativeLibs = baseApk.extractNativeLibs;
        }

        private final List<String> $$robo$$android_content_pm_PackageParser_PackageLite$getAllCodePaths() {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(paths, this.splitCodePaths);
            }
            return paths;
        }

        private void __constructor__(String string2, ApkLite apkLite, String[] stringArray, String[] stringArray2, int[] nArray) {
            this.$$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(string2, apkLite, stringArray, stringArray2, nArray);
        }

        public PackageLite(String string2, ApkLite apkLite, String[] stringArray, String[] stringArray2, int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_PackageLite$__constructor__(java.lang.String android.content.pm.PackageParser$ApkLite java.lang.String[] java.lang.String[] int[] ), 0, this, string2, apkLite, stringArray, stringArray2, nArray);
        }

        public List<String> getAllCodePaths() {
            return InvokeDynamicSupport.bootstrap("getAllCodePaths", $$robo$$android_content_pm_PackageParser_PackageLite$getAllCodePaths(), 0, this);
        }

        public /* synthetic */ PackageLite() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageLite)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParseComponentArgs
    extends ParsePackageItemArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String[] sepProcesses;
        int processRes;
        int descriptionRes;
        int enabledRes;
        int flags;

        private void $$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _logoRes, int _bannerRes, String[] _sepProcesses, int _processRes, int _descriptionRes, int _enabledRes) {
            this.sepProcesses = _sepProcesses;
            this.processRes = _processRes;
            this.descriptionRes = _descriptionRes;
            this.enabledRes = _enabledRes;
        }

        private void __constructor__(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, String[] stringArray2, int n6, int n7, int n8) {
            this.$$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(package_, stringArray, n, n2, n3, n4, n5, stringArray2, n6, n7, n8);
        }

        ParseComponentArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, String[] stringArray2, int n6, int n7, int n8) {
            super(package_, stringArray, n, n2, n3, n4, n5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ParseComponentArgs$__constructor__(android.content.pm.PackageParser$Package java.lang.String[] int int int int int java.lang.String[] int int int ), 0, this, package_, stringArray, n, n2, n3, n4, n5, stringArray2, n6, n7, n8);
        }

        public /* synthetic */ ParseComponentArgs() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseComponentArgs)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParsePackageItemArgs
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Package owner;
        String[] outError;
        int nameRes;
        int labelRes;
        int iconRes;
        int logoRes;
        int bannerRes;
        String tag;
        TypedArray sa;

        private void $$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(Package _owner, String[] _outError, int _nameRes, int _labelRes, int _iconRes, int _logoRes, int _bannerRes) {
            this.owner = _owner;
            this.outError = _outError;
            this.nameRes = _nameRes;
            this.labelRes = _labelRes;
            this.iconRes = _iconRes;
            this.logoRes = _logoRes;
            this.bannerRes = _bannerRes;
        }

        private void __constructor__(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(package_, stringArray, n, n2, n3, n4, n5);
        }

        ParsePackageItemArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_ParsePackageItemArgs$__constructor__(android.content.pm.PackageParser$Package java.lang.String[] int int int int int ), 0, this, package_, stringArray, n, n2, n3, n4, n5);
        }

        public /* synthetic */ ParsePackageItemArgs() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParsePackageItemArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SplitPermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String rootPerm;
        public String[] newPerms;
        public int targetSdk;

        private void $$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(String rootPerm, String[] newPerms, int targetSdk) {
            this.rootPerm = rootPerm;
            this.newPerms = newPerms;
            this.targetSdk = targetSdk;
        }

        private void __constructor__(String string2, String[] stringArray, int n) {
            this.$$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(string2, stringArray, n);
        }

        public SplitPermissionInfo(String string2, String[] stringArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_SplitPermissionInfo$__constructor__(java.lang.String java.lang.String[] int ), 0, this, string2, stringArray, n);
        }

        public /* synthetic */ SplitPermissionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitPermissionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NewPermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String name;
        public int sdkVersion;
        public int fileVersion;

        private void $$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(String name, int sdkVersion, int fileVersion) {
            this.name = name;
            this.sdkVersion = sdkVersion;
            this.fileVersion = fileVersion;
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(string2, n, n2);
        }

        public NewPermissionInfo(String string2, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageParser_NewPermissionInfo$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public /* synthetic */ NewPermissionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NewPermissionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

