/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SearchRecentSuggestionsProvider
extends ContentProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SuggestionsProvider";
    private String mAuthority;
    private int mMode;
    private boolean mTwoLineDisplay;
    private SQLiteOpenHelper mOpenHelper;
    private static String sDatabaseName = "suggestions.db";
    private static String sSuggestions = "suggestions";
    private static String ORDER_BY = "date DESC";
    private static String NULL_COLUMN = "query";
    private static int DATABASE_VERSION = 512;
    public static int DATABASE_MODE_QUERIES = 1;
    public static int DATABASE_MODE_2LINES = 2;
    private static int URI_MATCH_SUGGEST = 1;
    private Uri mSuggestionsUri;
    private UriMatcher mUriMatcher;
    private String mSuggestSuggestionClause;
    private String[] mSuggestionProjection;

    private void $$robo$$android_content_SearchRecentSuggestionsProvider$__constructor__() {
    }

    private final void $$robo$$android_content_SearchRecentSuggestionsProvider$setupSuggestions(String authority, int mode) {
        if (TextUtils.isEmpty(authority) || (mode & 1) == 0) {
            throw new IllegalArgumentException();
        }
        this.mTwoLineDisplay = 0 != (mode & 2);
        this.mAuthority = new String(authority);
        this.mMode = mode;
        this.mSuggestionsUri = Uri.parse("content://" + this.mAuthority + "/suggestions");
        this.mUriMatcher = new UriMatcher(-1);
        this.mUriMatcher.addURI(this.mAuthority, "search_suggest_query", 1);
        if (this.mTwoLineDisplay) {
            this.mSuggestSuggestionClause = "display1 LIKE ? OR display2 LIKE ?";
            this.mSuggestionProjection = new String[]{"0 AS suggest_format", "'android.resource://system/17301578' AS suggest_icon_1", "display1 AS suggest_text_1", "display2 AS suggest_text_2", "query AS suggest_intent_query", "_id"};
        } else {
            this.mSuggestSuggestionClause = "display1 LIKE ?";
            this.mSuggestionProjection = new String[]{"0 AS suggest_format", "'android.resource://system/17301578' AS suggest_icon_1", "display1 AS suggest_text_1", "query AS suggest_intent_query", "_id"};
        }
    }

    private final int $$robo$$android_content_SearchRecentSuggestionsProvider$delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int length = uri.getPathSegments().size();
        if (length != 1) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String base = uri.getPathSegments().get(0);
        int count = 0;
        if (!base.equals("suggestions")) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        count = db.delete("suggestions", selection, selectionArgs);
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    private final String $$robo$$android_content_SearchRecentSuggestionsProvider$getType(Uri uri) {
        String base;
        if (this.mUriMatcher.match(uri) == 1) {
            return "vnd.android.cursor.dir/vnd.android.search.suggest";
        }
        int length = uri.getPathSegments().size();
        if (length >= 1 && (base = uri.getPathSegments().get(0)).equals("suggestions")) {
            if (length == 1) {
                return "vnd.android.cursor.dir/suggestion";
            }
            if (length == 2) {
                return "vnd.android.cursor.item/suggestion";
            }
        }
        throw new IllegalArgumentException("Unknown Uri");
    }

    private final Uri $$robo$$android_content_SearchRecentSuggestionsProvider$insert(Uri uri, ContentValues values) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int length = uri.getPathSegments().size();
        if (length < 1) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        long rowID = -1L;
        String base = uri.getPathSegments().get(0);
        Uri newUri = null;
        if (base.equals("suggestions") && length == 1 && (rowID = db.insert("suggestions", "query", values)) > 0L) {
            newUri = Uri.withAppendedPath(this.mSuggestionsUri, String.valueOf(rowID));
        }
        if (rowID < 0L) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        this.getContext().getContentResolver().notifyChange(newUri, null);
        return newUri;
    }

    private final boolean $$robo$$android_content_SearchRecentSuggestionsProvider$onCreate() {
        if (this.mAuthority == null || this.mMode == 0) {
            throw new IllegalArgumentException("Provider not configured");
        }
        int mWorkingDbVersion = 512 + this.mMode;
        this.mOpenHelper = new DatabaseHelper(this.getContext(), mWorkingDbVersion);
        return true;
    }

    private final Cursor $$robo$$android_content_SearchRecentSuggestionsProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        if (this.mUriMatcher.match(uri) == 1) {
            String[] myArgs;
            String suggestSelection;
            if (TextUtils.isEmpty(selectionArgs[0])) {
                suggestSelection = null;
                myArgs = null;
            } else {
                String like = "%" + selectionArgs[0] + "%";
                myArgs = this.mTwoLineDisplay ? new String[]{like, like} : new String[]{like};
                suggestSelection = this.mSuggestSuggestionClause;
            }
            Cursor c = db.query("suggestions", this.mSuggestionProjection, suggestSelection, myArgs, null, null, "date DESC", null);
            c.setNotificationUri(this.getContext().getContentResolver(), uri);
            return c;
        }
        int length = uri.getPathSegments().size();
        if (length != 1 && length != 2) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String base = uri.getPathSegments().get(0);
        if (!base.equals("suggestions")) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String[] useProjection = null;
        if (projection != null && projection.length > 0) {
            useProjection = new String[projection.length + 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)projection, (int)0, (Object)useProjection, (int)0, (int)projection.length);
            useProjection[projection.length] = "_id AS _id";
        }
        StringBuilder whereClause = new StringBuilder(256);
        if (length == 2) {
            whereClause.append("(_id = ").append(uri.getPathSegments().get(1)).append(")");
        }
        if (selection != null && selection.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append('(');
            whereClause.append(selection);
            whereClause.append(')');
        }
        Cursor c = db.query(base, useProjection, whereClause.toString(), selectionArgs, null, null, sortOrder, null);
        c.setNotificationUri(this.getContext().getContentResolver(), uri);
        return c;
    }

    private final int $$robo$$android_content_SearchRecentSuggestionsProvider$update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void __constructor__() {
        this.$$robo$$android_content_SearchRecentSuggestionsProvider$__constructor__();
    }

    public SearchRecentSuggestionsProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SearchRecentSuggestionsProvider$__constructor__(), 0, this);
    }

    protected void setupSuggestions(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setupSuggestions", $$robo$$android_content_SearchRecentSuggestionsProvider$setupSuggestions(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_content_SearchRecentSuggestionsProvider$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    @Override
    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_SearchRecentSuggestionsProvider$getType(android.net.Uri ), 0, this, uri);
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_content_SearchRecentSuggestionsProvider$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    @Override
    public boolean onCreate() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_content_SearchRecentSuggestionsProvider$onCreate(), 0, this);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_SearchRecentSuggestionsProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_content_SearchRecentSuggestionsProvider$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchRecentSuggestionsProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mNewVersion;

        private void $$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$__constructor__(Context context, int newVersion) {
            this.mNewVersion = newVersion;
        }

        private final void $$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$onCreate(SQLiteDatabase db) {
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE suggestions (_id INTEGER PRIMARY KEY,display1 TEXT UNIQUE ON CONFLICT REPLACE");
            if (0 != (this.mNewVersion & 2)) {
                builder.append(",display2 TEXT");
            }
            builder.append(",query TEXT,date LONG);");
            db.execSQL(builder.toString());
        }

        private final void $$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w("SuggestionsProvider", "Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data");
            db.execSQL("DROP TABLE IF EXISTS suggestions");
            this.onCreate(db);
        }

        private void __constructor__(Context context, int n) {
            this.$$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$__constructor__(context, n);
        }

        public DatabaseHelper(Context context, int n) {
            super(context, "suggestions.db", null, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$__constructor__(android.content.Context int ), 0, this, context, n);
        }

        @Override
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$onCreate(android.database.sqlite.SQLiteDatabase ), 0, this, sQLiteDatabase);
        }

        @Override
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onUpgrade", $$robo$$android_content_SearchRecentSuggestionsProvider_DatabaseHelper$onUpgrade(android.database.sqlite.SQLiteDatabase int int ), 0, this, sQLiteDatabase, n, n2);
        }

        public /* synthetic */ DatabaseHelper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatabaseHelper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

