/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.annotation.RequiresPermission;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncRequest;
import android.content.SyncStatusInfo;
import android.content.SyncStatusObserver;
import android.content.UriPermission;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ContentResolver
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static String SYNC_EXTRAS_ACCOUNT = "account";
    public static String SYNC_EXTRAS_EXPEDITED = "expedited";
    public static String SYNC_EXTRAS_REQUIRE_CHARGING = "require_charging";
    @Deprecated
    public static String SYNC_EXTRAS_FORCE = "force";
    public static String SYNC_EXTRAS_IGNORE_SETTINGS = "ignore_settings";
    public static String SYNC_EXTRAS_IGNORE_BACKOFF = "ignore_backoff";
    public static String SYNC_EXTRAS_DO_NOT_RETRY = "do_not_retry";
    public static String SYNC_EXTRAS_MANUAL = "force";
    public static String SYNC_EXTRAS_UPLOAD = "upload";
    public static String SYNC_EXTRAS_OVERRIDE_TOO_MANY_DELETIONS = "deletions_override";
    public static String SYNC_EXTRAS_DISCARD_LOCAL_DELETIONS = "discard_deletions";
    public static String SYNC_EXTRAS_EXPECTED_UPLOAD = "expected_upload";
    public static String SYNC_EXTRAS_EXPECTED_DOWNLOAD = "expected_download";
    public static String SYNC_EXTRAS_PRIORITY = "sync_priority";
    public static String SYNC_EXTRAS_DISALLOW_METERED = "allow_metered";
    public static String SYNC_EXTRAS_INITIALIZE = "initialize";
    public static Intent ACTION_SYNC_CONN_STATUS_CHANGED;
    public static String SCHEME_CONTENT = "content";
    public static String SCHEME_ANDROID_RESOURCE = "android.resource";
    public static String SCHEME_FILE = "file";
    public static String EXTRA_SIZE = "android.content.extra.SIZE";
    public static String CURSOR_ITEM_BASE_TYPE = "vnd.android.cursor.item";
    public static String CURSOR_DIR_BASE_TYPE = "vnd.android.cursor.dir";
    public static String ANY_CURSOR_ITEM_TYPE = "vnd.android.cursor.item/*";
    public static int SYNC_ERROR_SYNC_ALREADY_IN_PROGRESS = 1;
    public static int SYNC_ERROR_AUTHENTICATION = 2;
    public static int SYNC_ERROR_IO = 3;
    public static int SYNC_ERROR_PARSE = 4;
    public static int SYNC_ERROR_CONFLICT = 5;
    public static int SYNC_ERROR_TOO_MANY_DELETIONS = 6;
    public static int SYNC_ERROR_TOO_MANY_RETRIES = 7;
    public static int SYNC_ERROR_INTERNAL = 8;
    private static String[] SYNC_ERROR_NAMES;
    public static int SYNC_OBSERVER_TYPE_SETTINGS = 1;
    public static int SYNC_OBSERVER_TYPE_PENDING = 2;
    public static int SYNC_OBSERVER_TYPE_ACTIVE = 4;
    public static int SYNC_OBSERVER_TYPE_STATUS = 8;
    public static int SYNC_OBSERVER_TYPE_ALL = Integer.MAX_VALUE;
    public static int NOTIFY_SYNC_TO_NETWORK = 1;
    public static int NOTIFY_SKIP_NOTIFY_FOR_DESCENDANTS = 2;
    private static boolean ENABLE_CONTENT_SAMPLE = false;
    private static int SLOW_THRESHOLD_MILLIS = 500;
    private Random mRandom;
    public static String CONTENT_SERVICE_NAME = "content";
    private static IContentService sContentService;
    private Context mContext;
    String mPackageName;
    private static String TAG = "ContentResolver";

    private static final String $$robo$$android_content_ContentResolver$syncErrorToString(int error) {
        if (error < 1 || error > SYNC_ERROR_NAMES.length) {
            return String.valueOf(error);
        }
        return SYNC_ERROR_NAMES[error - 1];
    }

    private static final int $$robo$$android_content_ContentResolver$syncErrorStringToInt(String error) {
        int n = SYNC_ERROR_NAMES.length;
        for (int i = 0; i < n; ++i) {
            if (!SYNC_ERROR_NAMES[i].equals(error)) continue;
            return i + 1;
        }
        if (error != null) {
            try {
                return Integer.parseInt(error);
            }
            catch (NumberFormatException e) {
                Log.d("ContentResolver", "error parsing sync error: " + error);
            }
        }
        return 0;
    }

    private void $$robo$$android_content_ContentResolver$__constructor__(Context context) {
        this.mRandom = new Random();
        this.mContext = context != null ? context : ActivityThread.currentApplication();
        this.mPackageName = this.mContext.getOpPackageName();
    }

    protected abstract IContentProvider acquireProvider(Context var1, String var2);

    private final IContentProvider $$robo$$android_content_ContentResolver$acquireExistingProvider(Context c, String name) {
        return this.acquireProvider(c, name);
    }

    public abstract boolean releaseProvider(IContentProvider var1);

    protected abstract IContentProvider acquireUnstableProvider(Context var1, String var2);

    public abstract boolean releaseUnstableProvider(IContentProvider var1);

    public abstract void unstableProviderDied(IContentProvider var1);

    private final void $$robo$$android_content_ContentResolver$appNotRespondingViaProvider(IContentProvider icp) {
        throw new UnsupportedOperationException("appNotRespondingViaProvider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_content_ContentResolver$getType(Uri url) {
        Preconditions.checkNotNull(url, "url");
        IContentProvider provider = this.acquireExistingProvider(url);
        if (provider != null) {
            try {
                String string2 = provider.getType(url);
                return string2;
            }
            catch (RemoteException e) {
                String string3 = null;
                return string3;
            }
            catch (Exception e) {
                Log.w("ContentResolver", "Failed to get type for: " + url + " (" + e.getMessage() + ")");
                String string4 = null;
                return string4;
            }
            finally {
                this.releaseProvider(provider);
            }
        }
        if (!"content".equals(url.getScheme())) {
            return null;
        }
        try {
            String type = ActivityManagerNative.getDefault().getProviderMimeType(ContentProvider.getUriWithoutUserId(url), this.resolveUserId(url));
            return type;
        }
        catch (RemoteException e) {
            return null;
        }
        catch (Exception e) {
            Log.w("ContentResolver", "Failed to get type for: " + url + " (" + e.getMessage() + ")");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_content_ContentResolver$getStreamTypes(Uri url, String mimeTypeFilter) {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(mimeTypeFilter, "mimeTypeFilter");
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            String[] stringArray = provider.getStreamTypes(url, mimeTypeFilter);
            return stringArray;
        }
        catch (RemoteException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    private final Cursor $$robo$$android_content_ContentResolver$query(@RequiresPermission.Read Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder, null);
    }

    /*
     * Exception decompiling
     */
    private final Cursor $$robo$$android_content_ContentResolver$query(@RequiresPermission.Read Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$android_content_ContentResolver$canonicalize(Uri url) {
        Preconditions.checkNotNull(url, "url");
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            Uri uri = provider.canonicalize(this.mPackageName, url);
            return uri;
        }
        catch (RemoteException e) {
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$android_content_ContentResolver$uncanonicalize(Uri url) {
        Preconditions.checkNotNull(url, "url");
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            return null;
        }
        try {
            Uri uri = provider.uncanonicalize(this.mPackageName, url);
            return uri;
        }
        catch (RemoteException e) {
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    private final InputStream $$robo$$android_content_ContentResolver$openInputStream(Uri uri) throws FileNotFoundException {
        Preconditions.checkNotNull(uri, "uri");
        String scheme = uri.getScheme();
        if ("android.resource".equals(scheme)) {
            OpenResourceIdResult r = this.getResourceId(uri);
            try {
                InputStream stream = r.r.openRawResource(r.id);
                return stream;
            }
            catch (Resources.NotFoundException ex) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        if ("file".equals(scheme)) {
            return new FileInputStream(uri.getPath());
        }
        AssetFileDescriptor fd = this.openAssetFileDescriptor(uri, "r", null);
        try {
            return fd != null ? fd.createInputStream() : null;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    private final OutputStream $$robo$$android_content_ContentResolver$openOutputStream(Uri uri) throws FileNotFoundException {
        return this.openOutputStream(uri, "w");
    }

    private final OutputStream $$robo$$android_content_ContentResolver$openOutputStream(Uri uri, String mode) throws FileNotFoundException {
        AssetFileDescriptor fd = this.openAssetFileDescriptor(uri, mode, null);
        try {
            return fd != null ? fd.createOutputStream() : null;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    private final ParcelFileDescriptor $$robo$$android_content_ContentResolver$openFileDescriptor(Uri uri, String mode) throws FileNotFoundException {
        return this.openFileDescriptor(uri, mode, null);
    }

    private final ParcelFileDescriptor $$robo$$android_content_ContentResolver$openFileDescriptor(Uri uri, String mode, CancellationSignal cancellationSignal) throws FileNotFoundException {
        AssetFileDescriptor afd = this.openAssetFileDescriptor(uri, mode, cancellationSignal);
        if (afd == null) {
            return null;
        }
        if (afd.getDeclaredLength() < 0L) {
            return afd.getParcelFileDescriptor();
        }
        try {
            afd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new FileNotFoundException("Not a whole file");
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentResolver$openAssetFileDescriptor(Uri uri, String mode) throws FileNotFoundException {
        return this.openAssetFileDescriptor(uri, mode, null);
    }

    /*
     * Exception decompiling
     */
    private final AssetFileDescriptor $$robo$$android_content_ContentResolver$openAssetFileDescriptor(Uri uri, String mode, CancellationSignal cancellationSignal) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final AssetFileDescriptor $$robo$$android_content_ContentResolver$openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, mimeType, opts, null);
    }

    /*
     * Exception decompiling
     */
    private final AssetFileDescriptor $$robo$$android_content_ContentResolver$openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts, CancellationSignal cancellationSignal) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final OpenResourceIdResult $$robo$$android_content_ContentResolver$getResourceId(Uri uri) throws FileNotFoundException {
        int id2;
        Resources r;
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty(authority)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            r = this.mContext.getPackageManager().getResourcesForApplication(authority);
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        List<String> path = uri.getPathSegments();
        if (path == null) {
            throw new FileNotFoundException("No path: " + uri);
        }
        int len = path.size();
        if (len == 1) {
            try {
                id2 = Integer.parseInt(path.get(0));
            }
            catch (NumberFormatException e) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else if (len == 2) {
            id2 = r.getIdentifier(path.get(1), path.get(0), authority);
        } else {
            throw new FileNotFoundException("More than two path segments: " + uri);
        }
        if (id2 == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        OpenResourceIdResult res = new OpenResourceIdResult(this);
        res.r = r;
        res.id = id2;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$android_content_ContentResolver$insert(@RequiresPermission.Write Uri url, ContentValues values) {
        Preconditions.checkNotNull(url, "url");
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            Uri createdRow = provider.insert(this.mPackageName, url, values);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, url, "insert", null);
            Uri uri = createdRow;
            return uri;
        }
        catch (RemoteException e) {
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ContentProviderResult[] $$robo$$android_content_ContentResolver$applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Preconditions.checkNotNull(authority, "authority");
        Preconditions.checkNotNull(operations, "operations");
        ContentProviderClient provider = this.acquireContentProviderClient(authority);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown authority " + authority);
        }
        try {
            ContentProviderResult[] contentProviderResultArray = provider.applyBatch(operations);
            return contentProviderResultArray;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_ContentResolver$bulkInsert(@RequiresPermission.Write Uri url, ContentValues[] values) {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(values, "values");
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            int rowsCreated = provider.bulkInsert(this.mPackageName, url, values);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, url, "bulkinsert", null);
            int n = rowsCreated;
            return n;
        }
        catch (RemoteException e) {
            int n = 0;
            return n;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_ContentResolver$delete(@RequiresPermission.Write Uri url, String where, String[] selectionArgs) {
        Preconditions.checkNotNull(url, "url");
        IContentProvider provider = this.acquireProvider(url);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            int rowsDeleted = provider.delete(this.mPackageName, url, where, selectionArgs);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, url, "delete", where);
            int n = rowsDeleted;
            return n;
        }
        catch (RemoteException e) {
            int n = -1;
            return n;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_ContentResolver$update(@RequiresPermission.Write Uri uri, ContentValues values, String where, String[] selectionArgs) {
        Preconditions.checkNotNull(uri, "uri");
        IContentProvider provider = this.acquireProvider(uri);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            long startTime = SystemClock.uptimeMillis();
            int rowsUpdated = provider.update(this.mPackageName, uri, values, where, selectionArgs);
            long durationMillis = SystemClock.uptimeMillis() - startTime;
            this.maybeLogUpdateToEventLog(durationMillis, uri, "update", where);
            int n = rowsUpdated;
            return n;
        }
        catch (RemoteException e) {
            int n = -1;
            return n;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle $$robo$$android_content_ContentResolver$call(Uri uri, String method, String arg, Bundle extras) {
        Preconditions.checkNotNull(uri, "uri");
        Preconditions.checkNotNull(method, "method");
        IContentProvider provider = this.acquireProvider(uri);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            Bundle res = provider.call(this.mPackageName, method, arg, extras);
            Bundle.setDefusable(res, true);
            Bundle bundle = res;
            return bundle;
        }
        catch (RemoteException e) {
            Bundle bundle = null;
            return bundle;
        }
        finally {
            this.releaseProvider(provider);
        }
    }

    private final IContentProvider $$robo$$android_content_ContentResolver$acquireProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireProvider(this.mContext, auth);
        }
        return null;
    }

    private final IContentProvider $$robo$$android_content_ContentResolver$acquireExistingProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireExistingProvider(this.mContext, auth);
        }
        return null;
    }

    private final IContentProvider $$robo$$android_content_ContentResolver$acquireProvider(String name) {
        if (name == null) {
            return null;
        }
        return this.acquireProvider(this.mContext, name);
    }

    private final IContentProvider $$robo$$android_content_ContentResolver$acquireUnstableProvider(Uri uri) {
        if (!"content".equals(uri.getScheme())) {
            return null;
        }
        String auth = uri.getAuthority();
        if (auth != null) {
            return this.acquireUnstableProvider(this.mContext, uri.getAuthority());
        }
        return null;
    }

    private final IContentProvider $$robo$$android_content_ContentResolver$acquireUnstableProvider(String name) {
        if (name == null) {
            return null;
        }
        return this.acquireUnstableProvider(this.mContext, name);
    }

    private final ContentProviderClient $$robo$$android_content_ContentResolver$acquireContentProviderClient(Uri uri) {
        Preconditions.checkNotNull(uri, "uri");
        IContentProvider provider = this.acquireProvider(uri);
        if (provider != null) {
            return new ContentProviderClient(this, provider, true);
        }
        return null;
    }

    private final ContentProviderClient $$robo$$android_content_ContentResolver$acquireContentProviderClient(String name) {
        Preconditions.checkNotNull(name, "name");
        IContentProvider provider = this.acquireProvider(name);
        if (provider != null) {
            return new ContentProviderClient(this, provider, true);
        }
        return null;
    }

    private final ContentProviderClient $$robo$$android_content_ContentResolver$acquireUnstableContentProviderClient(Uri uri) {
        Preconditions.checkNotNull(uri, "uri");
        IContentProvider provider = this.acquireUnstableProvider(uri);
        if (provider != null) {
            return new ContentProviderClient(this, provider, false);
        }
        return null;
    }

    private final ContentProviderClient $$robo$$android_content_ContentResolver$acquireUnstableContentProviderClient(String name) {
        Preconditions.checkNotNull(name, "name");
        IContentProvider provider = this.acquireUnstableProvider(name);
        if (provider != null) {
            return new ContentProviderClient(this, provider, false);
        }
        return null;
    }

    private final void $$robo$$android_content_ContentResolver$registerContentObserver(Uri uri, boolean notifyForDescendants, ContentObserver observer) {
        Preconditions.checkNotNull(uri, "uri");
        Preconditions.checkNotNull(observer, "observer");
        this.registerContentObserver(ContentProvider.getUriWithoutUserId(uri), notifyForDescendants, observer, ContentProvider.getUserIdFromUri(uri, UserHandle.myUserId()));
    }

    private final void $$robo$$android_content_ContentResolver$registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
        try {
            ContentResolver.getContentService().registerContentObserver(uri, notifyForDescendents, observer.getContentObserver(), userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_ContentResolver$unregisterContentObserver(ContentObserver observer) {
        Preconditions.checkNotNull(observer, "observer");
        try {
            IContentObserver contentObserver = observer.releaseContentObserver();
            if (contentObserver != null) {
                ContentResolver.getContentService().unregisterContentObserver(contentObserver);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_ContentResolver$notifyChange(Uri uri, ContentObserver observer) {
        this.notifyChange(uri, observer, true);
    }

    private final void $$robo$$android_content_ContentResolver$notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
        Preconditions.checkNotNull(uri, "uri");
        this.notifyChange(ContentProvider.getUriWithoutUserId(uri), observer, syncToNetwork, ContentProvider.getUserIdFromUri(uri, UserHandle.myUserId()));
    }

    private final void $$robo$$android_content_ContentResolver$notifyChange(Uri uri, ContentObserver observer, int flags) {
        Preconditions.checkNotNull(uri, "uri");
        this.notifyChange(ContentProvider.getUriWithoutUserId(uri), observer, flags, ContentProvider.getUserIdFromUri(uri, UserHandle.myUserId()));
    }

    private final void $$robo$$android_content_ContentResolver$notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork, int userHandle) {
        try {
            ContentResolver.getContentService().notifyChange(uri, observer == null ? null : observer.getContentObserver(), observer != null && observer.deliverSelfNotifications(), syncToNetwork ? 1 : 0, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_ContentResolver$notifyChange(Uri uri, ContentObserver observer, int flags, int userHandle) {
        try {
            ContentResolver.getContentService().notifyChange(uri, observer == null ? null : observer.getContentObserver(), observer != null && observer.deliverSelfNotifications(), flags, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_ContentResolver$takePersistableUriPermission(Uri uri, int modeFlags) {
        Preconditions.checkNotNull(uri, "uri");
        try {
            ActivityManagerNative.getDefault().takePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), modeFlags, this.resolveUserId(uri));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_ContentResolver$releasePersistableUriPermission(Uri uri, int modeFlags) {
        Preconditions.checkNotNull(uri, "uri");
        try {
            ActivityManagerNative.getDefault().releasePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), modeFlags, this.resolveUserId(uri));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final List<UriPermission> $$robo$$android_content_ContentResolver$getPersistedUriPermissions() {
        try {
            return ActivityManagerNative.getDefault().getPersistedUriPermissions(this.mPackageName, true).getList();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Activity manager has died", e);
        }
    }

    private final List<UriPermission> $$robo$$android_content_ContentResolver$getOutgoingPersistedUriPermissions() {
        try {
            return ActivityManagerNative.getDefault().getPersistedUriPermissions(this.mPackageName, false).getList();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Activity manager has died", e);
        }
    }

    @Deprecated
    private final void $$robo$$android_content_ContentResolver$startSync(Uri uri, Bundle extras) {
        Account account = null;
        if (extras != null) {
            String accountName = extras.getString("account");
            if (!TextUtils.isEmpty(accountName)) {
                account = new Account(accountName, "com.google");
            }
            extras.remove("account");
        }
        ContentResolver.requestSync(account, uri != null ? uri.getAuthority() : null, extras);
    }

    private static final void $$robo$$android_content_ContentResolver$requestSync(Account account, String authority, Bundle extras) {
        ContentResolver.requestSyncAsUser(account, authority, UserHandle.myUserId(), extras);
    }

    private static final void $$robo$$android_content_ContentResolver$requestSyncAsUser(Account account, String authority, int userId, Bundle extras) {
        if (extras == null) {
            throw new IllegalArgumentException("Must specify extras.");
        }
        SyncRequest request = new SyncRequest.Builder().setSyncAdapter(account, authority).setExtras(extras).syncOnce().build();
        try {
            ContentResolver.getContentService().syncAsUser(request, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_content_ContentResolver$requestSync(SyncRequest request) {
        try {
            ContentResolver.getContentService().sync(request);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_content_ContentResolver$validateSyncExtrasBundle(Bundle extras) {
        try {
            for (String key : extras.keySet()) {
                Object value = extras.get(key);
                if (value == null || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Account) continue;
                throw new IllegalArgumentException("unexpected value type: " + value.getClass().getName());
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException exc) {
            throw new IllegalArgumentException("error unparceling Bundle", exc);
        }
    }

    @Deprecated
    private final void $$robo$$android_content_ContentResolver$cancelSync(Uri uri) {
        ContentResolver.cancelSync(null, uri != null ? uri.getAuthority() : null);
    }

    private static final void $$robo$$android_content_ContentResolver$cancelSync(Account account, String authority) {
        try {
            ContentResolver.getContentService().cancelSync(account, authority, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_content_ContentResolver$cancelSyncAsUser(Account account, String authority, int userId) {
        try {
            ContentResolver.getContentService().cancelSyncAsUser(account, authority, null, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final SyncAdapterType[] $$robo$$android_content_ContentResolver$getSyncAdapterTypes() {
        try {
            return ContentResolver.getContentService().getSyncAdapterTypes();
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final SyncAdapterType[] $$robo$$android_content_ContentResolver$getSyncAdapterTypesAsUser(int userId) {
        try {
            return ContentResolver.getContentService().getSyncAdapterTypesAsUser(userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final String[] $$robo$$android_content_ContentResolver$getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) {
        try {
            return ContentResolver.getContentService().getSyncAdapterPackagesForAuthorityAsUser(authority, userId);
        }
        catch (RemoteException remoteException) {
            return ArrayUtils.emptyArray(String.class);
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$getSyncAutomatically(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getSyncAutomatically(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$getSyncAutomaticallyAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().getSyncAutomaticallyAsUser(account, authority, userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final void $$robo$$android_content_ContentResolver$setSyncAutomatically(Account account, String authority, boolean sync) {
        ContentResolver.setSyncAutomaticallyAsUser(account, authority, sync, UserHandle.myUserId());
    }

    private static final void $$robo$$android_content_ContentResolver$setSyncAutomaticallyAsUser(Account account, String authority, boolean sync, int userId) {
        try {
            ContentResolver.getContentService().setSyncAutomaticallyAsUser(account, authority, sync, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_content_ContentResolver$addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        ContentResolver.validateSyncExtrasBundle(extras);
        if (extras.getBoolean("force", false) || extras.getBoolean("do_not_retry", false) || extras.getBoolean("ignore_backoff", false) || extras.getBoolean("ignore_settings", false) || extras.getBoolean("initialize", false) || extras.getBoolean("force", false) || extras.getBoolean("expedited", false)) {
            throw new IllegalArgumentException("illegal extras were set");
        }
        try {
            ContentResolver.getContentService().addPeriodicSync(account, authority, extras, pollFrequency);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$invalidPeriodicExtras(Bundle extras) {
        return extras.getBoolean("force", false) || extras.getBoolean("do_not_retry", false) || extras.getBoolean("ignore_backoff", false) || extras.getBoolean("ignore_settings", false) || extras.getBoolean("initialize", false) || extras.getBoolean("force", false) || extras.getBoolean("expedited", false);
    }

    private static final void $$robo$$android_content_ContentResolver$removePeriodicSync(Account account, String authority, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        try {
            ContentResolver.getContentService().removePeriodicSync(account, authority, extras);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final void $$robo$$android_content_ContentResolver$cancelSync(SyncRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        try {
            ContentResolver.getContentService().cancelRequest(request);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final List<PeriodicSync> $$robo$$android_content_ContentResolver$getPeriodicSyncs(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getPeriodicSyncs(account, authority, null);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final int $$robo$$android_content_ContentResolver$getIsSyncable(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getIsSyncable(account, authority);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final int $$robo$$android_content_ContentResolver$getIsSyncableAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().getIsSyncableAsUser(account, authority, userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final void $$robo$$android_content_ContentResolver$setIsSyncable(Account account, String authority, int syncable) {
        try {
            ContentResolver.getContentService().setIsSyncable(account, authority, syncable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$getMasterSyncAutomatically() {
        try {
            return ContentResolver.getContentService().getMasterSyncAutomatically();
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$getMasterSyncAutomaticallyAsUser(int userId) {
        try {
            return ContentResolver.getContentService().getMasterSyncAutomaticallyAsUser(userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final void $$robo$$android_content_ContentResolver$setMasterSyncAutomatically(boolean sync) {
        ContentResolver.setMasterSyncAutomaticallyAsUser(sync, UserHandle.myUserId());
    }

    private static final void $$robo$$android_content_ContentResolver$setMasterSyncAutomaticallyAsUser(boolean sync, int userId) {
        try {
            ContentResolver.getContentService().setMasterSyncAutomaticallyAsUser(sync, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$isSyncActive(Account account, String authority) {
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        try {
            return ContentResolver.getContentService().isSyncActive(account, authority, null);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    @Deprecated
    private static final SyncInfo $$robo$$android_content_ContentResolver$getCurrentSync() {
        try {
            List<SyncInfo> syncs = ContentResolver.getContentService().getCurrentSyncs();
            if (syncs.isEmpty()) {
                return null;
            }
            return syncs.get(0);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final List<SyncInfo> $$robo$$android_content_ContentResolver$getCurrentSyncs() {
        try {
            return ContentResolver.getContentService().getCurrentSyncs();
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final List<SyncInfo> $$robo$$android_content_ContentResolver$getCurrentSyncsAsUser(int userId) {
        try {
            return ContentResolver.getContentService().getCurrentSyncsAsUser(userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final SyncStatusInfo $$robo$$android_content_ContentResolver$getSyncStatus(Account account, String authority) {
        try {
            return ContentResolver.getContentService().getSyncStatus(account, authority, null);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final SyncStatusInfo $$robo$$android_content_ContentResolver$getSyncStatusAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().getSyncStatusAsUser(account, authority, null, userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final boolean $$robo$$android_content_ContentResolver$isSyncPending(Account account, String authority) {
        return ContentResolver.isSyncPendingAsUser(account, authority, UserHandle.myUserId());
    }

    private static final boolean $$robo$$android_content_ContentResolver$isSyncPendingAsUser(Account account, String authority, int userId) {
        try {
            return ContentResolver.getContentService().isSyncPendingAsUser(account, authority, null, userId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final Object $$robo$$android_content_ContentResolver$addStatusChangeListener(int mask, SyncStatusObserver callback) {
        if (callback == null) {
            throw new IllegalArgumentException("you passed in a null callback");
        }
        try {
            ShadowedObject observer = new ShadowedObject(callback){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SyncStatusObserver val$callback;

                private void $$robo$$android_content_ContentResolver_1$__constructor__(SyncStatusObserver syncStatusObserver) {
                }

                private final void $$robo$$android_content_ContentResolver_1$onStatusChanged(int which) throws RemoteException {
                    this.val$callback.onStatusChanged(which);
                }

                private void __constructor__(SyncStatusObserver syncStatusObserver) {
                    this.$$robo$$android_content_ContentResolver_1$__constructor__(syncStatusObserver);
                }
                {
                    this.val$callback = syncStatusObserver;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentResolver_1$__constructor__(android.content.SyncStatusObserver ), 0, this, syncStatusObserver);
                }

                @Override
                public void onStatusChanged(int n) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onStatusChanged", $$robo$$android_content_ContentResolver_1$onStatusChanged(int ), 0, this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            ContentResolver.getContentService().addStatusChangeListener(mask, (ISyncStatusObserver)observer);
            return observer;
        }
        catch (RemoteException e) {
            throw new RuntimeException("the ContentService should always be reachable", e);
        }
    }

    private static final void $$robo$$android_content_ContentResolver$removeStatusChangeListener(Object handle) {
        if (handle == null) {
            throw new IllegalArgumentException("you passed in a null handle");
        }
        try {
            ContentResolver.getContentService().removeStatusChangeListener((ISyncStatusObserver.Stub)handle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_content_ContentResolver$putCache(Uri key, Bundle value) {
        try {
            ContentResolver.getContentService().putCache(this.mContext.getPackageName(), key, value, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Bundle $$robo$$android_content_ContentResolver$getCache(Uri key) {
        try {
            Bundle bundle = ContentResolver.getContentService().getCache(this.mContext.getPackageName(), key, this.mContext.getUserId());
            if (bundle != null) {
                bundle.setClassLoader(this.mContext.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_content_ContentResolver$samplePercentForDuration(long durationMillis) {
        if (durationMillis >= 500L) {
            return 100;
        }
        return (int)(100L * durationMillis / 500L) + 1;
    }

    private final void $$robo$$android_content_ContentResolver$maybeLogQueryToEventLog(long durationMillis, Uri uri, String[] projection, String selection, String sortOrder) {
    }

    private final void $$robo$$android_content_ContentResolver$maybeLogUpdateToEventLog(long durationMillis, Uri uri, String operation, String selection) {
    }

    private static final IContentService $$robo$$android_content_ContentResolver$getContentService() {
        if (sContentService != null) {
            return sContentService;
        }
        IBinder b = ServiceManager.getService("content");
        sContentService = IContentService.Stub.asInterface(b);
        return sContentService;
    }

    private final String $$robo$$android_content_ContentResolver$getPackageName() {
        return this.mPackageName;
    }

    private final int $$robo$$android_content_ContentResolver$resolveUserId(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, this.mContext.getUserId());
    }

    static void __staticInitializer__() {
        ACTION_SYNC_CONN_STATUS_CHANGED = new Intent("com.android.sync.SYNC_CONN_STATUS_CHANGED");
        SYNC_ERROR_NAMES = new String[]{"already-in-progress", "authentication-error", "io-error", "parse-error", "conflict", "too-many-deletions", "too-many-retries", "internal-error"};
    }

    public static String syncErrorToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("syncErrorToString", $$robo$$android_content_ContentResolver$syncErrorToString(int ), 0, (int)n);
    }

    public static int syncErrorStringToInt(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("syncErrorStringToInt", $$robo$$android_content_ContentResolver$syncErrorStringToInt(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_content_ContentResolver$__constructor__(context);
    }

    public ContentResolver(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentResolver$__constructor__(android.content.Context ), 0, this, context);
    }

    protected IContentProvider acquireExistingProvider(Context context, String string2) {
        return InvokeDynamicSupport.bootstrap("acquireExistingProvider", $$robo$$android_content_ContentResolver$acquireExistingProvider(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    public void appNotRespondingViaProvider(IContentProvider iContentProvider) {
        InvokeDynamicSupport.bootstrap("appNotRespondingViaProvider", $$robo$$android_content_ContentResolver$appNotRespondingViaProvider(android.content.IContentProvider ), 0, this, iContentProvider);
    }

    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_content_ContentResolver$getType(android.net.Uri ), 0, this, uri);
    }

    public String[] getStreamTypes(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrap("getStreamTypes", $$robo$$android_content_ContentResolver$getStreamTypes(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentResolver$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_content_ContentResolver$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String android.os.CancellationSignal ), 0, this, uri, stringArray, string2, stringArray2, string3, cancellationSignal);
    }

    public Uri canonicalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_content_ContentResolver$canonicalize(android.net.Uri ), 0, this, uri);
    }

    public Uri uncanonicalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("uncanonicalize", $$robo$$android_content_ContentResolver$uncanonicalize(android.net.Uri ), 0, this, uri);
    }

    public InputStream openInputStream(Uri uri) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openInputStream", $$robo$$android_content_ContentResolver$openInputStream(android.net.Uri ), 0, this, uri);
    }

    public OutputStream openOutputStream(Uri uri) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openOutputStream", $$robo$$android_content_ContentResolver$openOutputStream(android.net.Uri ), 0, this, uri);
    }

    public OutputStream openOutputStream(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openOutputStream", $$robo$$android_content_ContentResolver$openOutputStream(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public ParcelFileDescriptor openFileDescriptor(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFileDescriptor", $$robo$$android_content_ContentResolver$openFileDescriptor(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public ParcelFileDescriptor openFileDescriptor(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFileDescriptor", $$robo$$android_content_ContentResolver$openFileDescriptor(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    public AssetFileDescriptor openAssetFileDescriptor(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFileDescriptor", $$robo$$android_content_ContentResolver$openAssetFileDescriptor(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    public AssetFileDescriptor openAssetFileDescriptor(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFileDescriptor", $$robo$$android_content_ContentResolver$openAssetFileDescriptor(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFileDescriptor", $$robo$$android_content_ContentResolver$openTypedAssetFileDescriptor(android.net.Uri java.lang.String android.os.Bundle ), 0, this, uri, string2, bundle);
    }

    public AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFileDescriptor", $$robo$$android_content_ContentResolver$openTypedAssetFileDescriptor(android.net.Uri java.lang.String android.os.Bundle android.os.CancellationSignal ), 0, this, uri, string2, bundle, cancellationSignal);
    }

    public OpenResourceIdResult getResourceId(Uri uri) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_content_ContentResolver$getResourceId(android.net.Uri ), 0, this, uri);
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_content_ContentResolver$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    public ContentProviderResult[] applyBatch(String string2, ArrayList<ContentProviderOperation> arrayList) throws RemoteException, OperationApplicationException {
        return InvokeDynamicSupport.bootstrap("applyBatch", $$robo$$android_content_ContentResolver$applyBatch(java.lang.String java.util.ArrayList<android.content.ContentProviderOperation> ), 0, this, string2, arrayList);
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        return (int)InvokeDynamicSupport.bootstrap("bulkInsert", $$robo$$android_content_ContentResolver$bulkInsert(android.net.Uri android.content.ContentValues[] ), 0, this, uri, contentValuesArray);
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_content_ContentResolver$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_content_ContentResolver$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    public Bundle call(Uri uri, String string2, String string3, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("call", $$robo$$android_content_ContentResolver$call(android.net.Uri java.lang.String java.lang.String android.os.Bundle ), 0, this, uri, string2, string3, bundle);
    }

    public IContentProvider acquireProvider(Uri uri) {
        return InvokeDynamicSupport.bootstrap("acquireProvider", $$robo$$android_content_ContentResolver$acquireProvider(android.net.Uri ), 0, this, uri);
    }

    public IContentProvider acquireExistingProvider(Uri uri) {
        return InvokeDynamicSupport.bootstrap("acquireExistingProvider", $$robo$$android_content_ContentResolver$acquireExistingProvider(android.net.Uri ), 0, this, uri);
    }

    public IContentProvider acquireProvider(String string2) {
        return InvokeDynamicSupport.bootstrap("acquireProvider", $$robo$$android_content_ContentResolver$acquireProvider(java.lang.String ), 0, this, string2);
    }

    public IContentProvider acquireUnstableProvider(Uri uri) {
        return InvokeDynamicSupport.bootstrap("acquireUnstableProvider", $$robo$$android_content_ContentResolver$acquireUnstableProvider(android.net.Uri ), 0, this, uri);
    }

    public IContentProvider acquireUnstableProvider(String string2) {
        return InvokeDynamicSupport.bootstrap("acquireUnstableProvider", $$robo$$android_content_ContentResolver$acquireUnstableProvider(java.lang.String ), 0, this, string2);
    }

    public ContentProviderClient acquireContentProviderClient(Uri uri) {
        return InvokeDynamicSupport.bootstrap("acquireContentProviderClient", $$robo$$android_content_ContentResolver$acquireContentProviderClient(android.net.Uri ), 0, this, uri);
    }

    public ContentProviderClient acquireContentProviderClient(String string2) {
        return InvokeDynamicSupport.bootstrap("acquireContentProviderClient", $$robo$$android_content_ContentResolver$acquireContentProviderClient(java.lang.String ), 0, this, string2);
    }

    public ContentProviderClient acquireUnstableContentProviderClient(Uri uri) {
        return InvokeDynamicSupport.bootstrap("acquireUnstableContentProviderClient", $$robo$$android_content_ContentResolver$acquireUnstableContentProviderClient(android.net.Uri ), 0, this, uri);
    }

    public ContentProviderClient acquireUnstableContentProviderClient(String string2) {
        return InvokeDynamicSupport.bootstrap("acquireUnstableContentProviderClient", $$robo$$android_content_ContentResolver$acquireUnstableContentProviderClient(java.lang.String ), 0, this, string2);
    }

    public void registerContentObserver(Uri uri, boolean bl, ContentObserver contentObserver) {
        InvokeDynamicSupport.bootstrap("registerContentObserver", $$robo$$android_content_ContentResolver$registerContentObserver(android.net.Uri boolean android.database.ContentObserver ), 0, this, uri, bl, contentObserver);
    }

    public void registerContentObserver(Uri uri, boolean bl, ContentObserver contentObserver, int n) {
        InvokeDynamicSupport.bootstrap("registerContentObserver", $$robo$$android_content_ContentResolver$registerContentObserver(android.net.Uri boolean android.database.ContentObserver int ), 0, this, uri, bl, contentObserver, n);
    }

    public void unregisterContentObserver(ContentObserver contentObserver) {
        InvokeDynamicSupport.bootstrap("unregisterContentObserver", $$robo$$android_content_ContentResolver$unregisterContentObserver(android.database.ContentObserver ), 0, this, contentObserver);
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver) {
        InvokeDynamicSupport.bootstrap("notifyChange", $$robo$$android_content_ContentResolver$notifyChange(android.net.Uri android.database.ContentObserver ), 0, this, uri, contentObserver);
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyChange", $$robo$$android_content_ContentResolver$notifyChange(android.net.Uri android.database.ContentObserver boolean ), 0, this, uri, contentObserver, bl);
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver, int n) {
        InvokeDynamicSupport.bootstrap("notifyChange", $$robo$$android_content_ContentResolver$notifyChange(android.net.Uri android.database.ContentObserver int ), 0, this, uri, contentObserver, n);
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("notifyChange", $$robo$$android_content_ContentResolver$notifyChange(android.net.Uri android.database.ContentObserver boolean int ), 0, this, uri, contentObserver, bl, n);
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver, int n, int n2) {
        InvokeDynamicSupport.bootstrap("notifyChange", $$robo$$android_content_ContentResolver$notifyChange(android.net.Uri android.database.ContentObserver int int ), 0, this, uri, contentObserver, n, n2);
    }

    public void takePersistableUriPermission(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("takePersistableUriPermission", $$robo$$android_content_ContentResolver$takePersistableUriPermission(android.net.Uri int ), 0, this, uri, n);
    }

    public void releasePersistableUriPermission(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("releasePersistableUriPermission", $$robo$$android_content_ContentResolver$releasePersistableUriPermission(android.net.Uri int ), 0, this, uri, n);
    }

    public List<UriPermission> getPersistedUriPermissions() {
        return InvokeDynamicSupport.bootstrap("getPersistedUriPermissions", $$robo$$android_content_ContentResolver$getPersistedUriPermissions(), 0, this);
    }

    public List<UriPermission> getOutgoingPersistedUriPermissions() {
        return InvokeDynamicSupport.bootstrap("getOutgoingPersistedUriPermissions", $$robo$$android_content_ContentResolver$getOutgoingPersistedUriPermissions(), 0, this);
    }

    @Deprecated
    public void startSync(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startSync", $$robo$$android_content_ContentResolver$startSync(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    public static void requestSync(Account account, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrapStatic("requestSync", $$robo$$android_content_ContentResolver$requestSync(android.accounts.Account java.lang.String android.os.Bundle ), 0, (Account)account, (String)string2, (Bundle)bundle);
    }

    public static void requestSyncAsUser(Account account, String string2, int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrapStatic("requestSyncAsUser", $$robo$$android_content_ContentResolver$requestSyncAsUser(android.accounts.Account java.lang.String int android.os.Bundle ), 0, (Account)account, (String)string2, (int)n, (Bundle)bundle);
    }

    public static void requestSync(SyncRequest syncRequest) {
        InvokeDynamicSupport.bootstrapStatic("requestSync", $$robo$$android_content_ContentResolver$requestSync(android.content.SyncRequest ), 0, (SyncRequest)syncRequest);
    }

    public static void validateSyncExtrasBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrapStatic("validateSyncExtrasBundle", $$robo$$android_content_ContentResolver$validateSyncExtrasBundle(android.os.Bundle ), 0, (Bundle)bundle);
    }

    @Deprecated
    public void cancelSync(Uri uri) {
        InvokeDynamicSupport.bootstrap("cancelSync", $$robo$$android_content_ContentResolver$cancelSync(android.net.Uri ), 0, this, uri);
    }

    public static void cancelSync(Account account, String string2) {
        InvokeDynamicSupport.bootstrapStatic("cancelSync", $$robo$$android_content_ContentResolver$cancelSync(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    public static void cancelSyncAsUser(Account account, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("cancelSyncAsUser", $$robo$$android_content_ContentResolver$cancelSyncAsUser(android.accounts.Account java.lang.String int ), 0, (Account)account, (String)string2, (int)n);
    }

    public static SyncAdapterType[] getSyncAdapterTypes() {
        return InvokeDynamicSupport.bootstrapStatic("getSyncAdapterTypes", $$robo$$android_content_ContentResolver$getSyncAdapterTypes(), 0);
    }

    public static SyncAdapterType[] getSyncAdapterTypesAsUser(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSyncAdapterTypesAsUser", $$robo$$android_content_ContentResolver$getSyncAdapterTypesAsUser(int ), 0, (int)n);
    }

    public static String[] getSyncAdapterPackagesForAuthorityAsUser(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSyncAdapterPackagesForAuthorityAsUser", $$robo$$android_content_ContentResolver$getSyncAdapterPackagesForAuthorityAsUser(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static boolean getSyncAutomatically(Account account, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getSyncAutomatically", $$robo$$android_content_ContentResolver$getSyncAutomatically(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    public static boolean getSyncAutomaticallyAsUser(Account account, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getSyncAutomaticallyAsUser", $$robo$$android_content_ContentResolver$getSyncAutomaticallyAsUser(android.accounts.Account java.lang.String int ), 0, (Account)account, (String)string2, (int)n);
    }

    public static void setSyncAutomatically(Account account, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setSyncAutomatically", $$robo$$android_content_ContentResolver$setSyncAutomatically(android.accounts.Account java.lang.String boolean ), 0, (Account)account, (String)string2, (boolean)bl);
    }

    public static void setSyncAutomaticallyAsUser(Account account, String string2, boolean bl, int n) {
        InvokeDynamicSupport.bootstrapStatic("setSyncAutomaticallyAsUser", $$robo$$android_content_ContentResolver$setSyncAutomaticallyAsUser(android.accounts.Account java.lang.String boolean int ), 0, (Account)account, (String)string2, (boolean)bl, (int)n);
    }

    public static void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        InvokeDynamicSupport.bootstrapStatic("addPeriodicSync", $$robo$$android_content_ContentResolver$addPeriodicSync(android.accounts.Account java.lang.String android.os.Bundle long ), 0, (Account)account, (String)string2, (Bundle)bundle, (long)l);
    }

    public static boolean invalidPeriodicExtras(Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("invalidPeriodicExtras", $$robo$$android_content_ContentResolver$invalidPeriodicExtras(android.os.Bundle ), 0, (Bundle)bundle);
    }

    public static void removePeriodicSync(Account account, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrapStatic("removePeriodicSync", $$robo$$android_content_ContentResolver$removePeriodicSync(android.accounts.Account java.lang.String android.os.Bundle ), 0, (Account)account, (String)string2, (Bundle)bundle);
    }

    public static void cancelSync(SyncRequest syncRequest) {
        InvokeDynamicSupport.bootstrapStatic("cancelSync", $$robo$$android_content_ContentResolver$cancelSync(android.content.SyncRequest ), 0, (SyncRequest)syncRequest);
    }

    public static List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getPeriodicSyncs", $$robo$$android_content_ContentResolver$getPeriodicSyncs(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    public static int getIsSyncable(Account account, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIsSyncable", $$robo$$android_content_ContentResolver$getIsSyncable(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    public static int getIsSyncableAsUser(Account account, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIsSyncableAsUser", $$robo$$android_content_ContentResolver$getIsSyncableAsUser(android.accounts.Account java.lang.String int ), 0, (Account)account, (String)string2, (int)n);
    }

    public static void setIsSyncable(Account account, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("setIsSyncable", $$robo$$android_content_ContentResolver$setIsSyncable(android.accounts.Account java.lang.String int ), 0, (Account)account, (String)string2, (int)n);
    }

    public static boolean getMasterSyncAutomatically() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getMasterSyncAutomatically", $$robo$$android_content_ContentResolver$getMasterSyncAutomatically(), 0);
    }

    public static boolean getMasterSyncAutomaticallyAsUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getMasterSyncAutomaticallyAsUser", $$robo$$android_content_ContentResolver$getMasterSyncAutomaticallyAsUser(int ), 0, (int)n);
    }

    public static void setMasterSyncAutomatically(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setMasterSyncAutomatically", $$robo$$android_content_ContentResolver$setMasterSyncAutomatically(boolean ), 0, (boolean)bl);
    }

    public static void setMasterSyncAutomaticallyAsUser(boolean bl, int n) {
        InvokeDynamicSupport.bootstrapStatic("setMasterSyncAutomaticallyAsUser", $$robo$$android_content_ContentResolver$setMasterSyncAutomaticallyAsUser(boolean int ), 0, (boolean)bl, (int)n);
    }

    public static boolean isSyncActive(Account account, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSyncActive", $$robo$$android_content_ContentResolver$isSyncActive(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    @Deprecated
    public static SyncInfo getCurrentSync() {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentSync", $$robo$$android_content_ContentResolver$getCurrentSync(), 0);
    }

    public static List<SyncInfo> getCurrentSyncs() {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentSyncs", $$robo$$android_content_ContentResolver$getCurrentSyncs(), 0);
    }

    public static List<SyncInfo> getCurrentSyncsAsUser(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentSyncsAsUser", $$robo$$android_content_ContentResolver$getCurrentSyncsAsUser(int ), 0, (int)n);
    }

    public static SyncStatusInfo getSyncStatus(Account account, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getSyncStatus", $$robo$$android_content_ContentResolver$getSyncStatus(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    public static SyncStatusInfo getSyncStatusAsUser(Account account, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSyncStatusAsUser", $$robo$$android_content_ContentResolver$getSyncStatusAsUser(android.accounts.Account java.lang.String int ), 0, (Account)account, (String)string2, (int)n);
    }

    public static boolean isSyncPending(Account account, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSyncPending", $$robo$$android_content_ContentResolver$isSyncPending(android.accounts.Account java.lang.String ), 0, (Account)account, (String)string2);
    }

    public static boolean isSyncPendingAsUser(Account account, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSyncPendingAsUser", $$robo$$android_content_ContentResolver$isSyncPendingAsUser(android.accounts.Account java.lang.String int ), 0, (Account)account, (String)string2, (int)n);
    }

    public static Object addStatusChangeListener(int n, SyncStatusObserver syncStatusObserver) {
        return InvokeDynamicSupport.bootstrapStatic("addStatusChangeListener", $$robo$$android_content_ContentResolver$addStatusChangeListener(int android.content.SyncStatusObserver ), 0, (int)n, (SyncStatusObserver)syncStatusObserver);
    }

    public static void removeStatusChangeListener(Object object) {
        InvokeDynamicSupport.bootstrapStatic("removeStatusChangeListener", $$robo$$android_content_ContentResolver$removeStatusChangeListener(java.lang.Object ), 0, (Object)object);
    }

    public void putCache(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putCache", $$robo$$android_content_ContentResolver$putCache(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    public Bundle getCache(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getCache", $$robo$$android_content_ContentResolver$getCache(android.net.Uri ), 0, this, uri);
    }

    private int samplePercentForDuration(long l) {
        return (int)InvokeDynamicSupport.bootstrap("samplePercentForDuration", $$robo$$android_content_ContentResolver$samplePercentForDuration(long ), 0, this, l);
    }

    private void maybeLogQueryToEventLog(long l, Uri uri, String[] stringArray, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("maybeLogQueryToEventLog", $$robo$$android_content_ContentResolver$maybeLogQueryToEventLog(long android.net.Uri java.lang.String[] java.lang.String java.lang.String ), 0, this, l, uri, stringArray, string2, string3);
    }

    private void maybeLogUpdateToEventLog(long l, Uri uri, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("maybeLogUpdateToEventLog", $$robo$$android_content_ContentResolver$maybeLogUpdateToEventLog(long android.net.Uri java.lang.String java.lang.String ), 0, this, l, uri, string2, string3);
    }

    public static IContentService getContentService() {
        return InvokeDynamicSupport.bootstrapStatic("getContentService", $$robo$$android_content_ContentResolver$getContentService(), 0);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_content_ContentResolver$getPackageName(), 0, this);
    }

    public int resolveUserId(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("resolveUserId", $$robo$$android_content_ContentResolver$resolveUserId(android.net.Uri ), 0, this, uri);
    }

    static {
        RobolectricInternals.classInitializing(ContentResolver.class);
    }

    public /* synthetic */ ContentResolver() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentResolver)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class ParcelFileDescriptorInner
    extends ParcelFileDescriptor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IContentProvider mContentProvider;
        private AtomicBoolean mProviderReleased;
        /* synthetic */ ContentResolver this$0;

        private void $$robo$$android_content_ContentResolver_ParcelFileDescriptorInner$__constructor__(ContentResolver contentResolver, ParcelFileDescriptor pfd, IContentProvider icp) {
            this.mProviderReleased = new AtomicBoolean();
            this.mContentProvider = icp;
        }

        private final void $$robo$$android_content_ContentResolver_ParcelFileDescriptorInner$releaseResources() {
            if (this.mProviderReleased.compareAndSet(false, true)) {
                this.this$0.releaseProvider(this.mContentProvider);
            }
        }

        private void __constructor__(ContentResolver contentResolver, ParcelFileDescriptor parcelFileDescriptor, IContentProvider iContentProvider) {
            this.$$robo$$android_content_ContentResolver_ParcelFileDescriptorInner$__constructor__(contentResolver, parcelFileDescriptor, iContentProvider);
        }

        ParcelFileDescriptorInner(ContentResolver contentResolver, ParcelFileDescriptor parcelFileDescriptor, IContentProvider iContentProvider) {
            this.this$0 = contentResolver;
            super(parcelFileDescriptor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentResolver_ParcelFileDescriptorInner$__constructor__(android.content.ContentResolver android.os.ParcelFileDescriptor android.content.IContentProvider ), 0, this, contentResolver, parcelFileDescriptor, iContentProvider);
        }

        @Override
        public void releaseResources() {
            InvokeDynamicSupport.bootstrap("releaseResources", $$robo$$android_content_ContentResolver_ParcelFileDescriptorInner$releaseResources(), 0, this);
        }

        public /* synthetic */ ParcelFileDescriptorInner() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelFileDescriptorInner)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class CursorWrapperInner
    extends CrossProcessCursorWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IContentProvider mContentProvider;
        private AtomicBoolean mProviderReleased;
        private CloseGuard mCloseGuard;
        /* synthetic */ ContentResolver this$0;

        private void $$robo$$android_content_ContentResolver_CursorWrapperInner$__constructor__(ContentResolver contentResolver, Cursor cursor, IContentProvider contentProvider) {
            this.mProviderReleased = new AtomicBoolean();
            this.mCloseGuard = CloseGuard.get();
            this.mContentProvider = contentProvider;
            this.mCloseGuard.open("close");
        }

        private final void $$robo$$android_content_ContentResolver_CursorWrapperInner$close() {
            this.mCloseGuard.close();
            super.close();
            if (this.mProviderReleased.compareAndSet(false, true)) {
                this.this$0.releaseProvider(this.mContentProvider);
            }
        }

        private final void $$robo$$android_content_ContentResolver_CursorWrapperInner$finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(ContentResolver contentResolver, Cursor cursor, IContentProvider iContentProvider) {
            this.$$robo$$android_content_ContentResolver_CursorWrapperInner$__constructor__(contentResolver, cursor, iContentProvider);
        }

        CursorWrapperInner(ContentResolver contentResolver, Cursor cursor, IContentProvider iContentProvider) {
            this.this$0 = contentResolver;
            super(cursor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentResolver_CursorWrapperInner$__constructor__(android.content.ContentResolver android.database.Cursor android.content.IContentProvider ), 0, this, contentResolver, cursor, iContentProvider);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_ContentResolver_CursorWrapperInner$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_ContentResolver_CursorWrapperInner$finalize(), 0, this);
        }

        public /* synthetic */ CursorWrapperInner() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorWrapperInner)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class OpenResourceIdResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Resources r;
        public int id;
        /* synthetic */ ContentResolver this$0;

        private void $$robo$$android_content_ContentResolver_OpenResourceIdResult$__constructor__(ContentResolver this$0) {
        }

        private void __constructor__(ContentResolver contentResolver) {
            this.$$robo$$android_content_ContentResolver_OpenResourceIdResult$__constructor__(contentResolver);
        }

        public OpenResourceIdResult(ContentResolver contentResolver) {
            this.this$0 = contentResolver;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_ContentResolver_OpenResourceIdResult$__constructor__(android.content.ContentResolver ), 0, this, contentResolver);
        }

        public /* synthetic */ OpenResourceIdResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpenResourceIdResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

